/** 
 ** CURSTEST.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/


#include "test.h"
#include "mousex.h"

char p16d[] = {
    0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,
    1,2,1,0,0,0,0,0,0,0,0,1,2,2,1,0,
    1,2,2,1,0,0,0,0,0,0,1,2,0,0,2,1,
    1,2,2,2,1,0,0,0,0,0,1,2,0,0,2,1,
    1,2,2,2,2,1,0,0,0,0,0,1,2,2,1,0,
    1,2,2,2,2,2,1,0,0,0,0,0,1,1,0,0,
    1,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,
    1,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
    1,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,
    1,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,
    1,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,
    1,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,
    1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,
    1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,
    1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

TESTFUNC(cursortest)
{
	int bgc = GrAllocColor(0,0,128);
	int fgc = GrAllocColor(255,255,0);
	int msc[3];
	GrCursor *cur;
	int x,y;

	msc[0] = 2;
	msc[1] = GrWhite();
	msc[2] = GrAllocColor(255,0,0);
	cur = GrBuildCursor(p16d,16,16,1,1,msc);
	x = GrScreenX() / 2;
	y = GrScreenY() / 2;
	GrMoveCursor(cur,x,y);
	GrClearScreen(bgc);
	drawing(0,0,GrSizeX(),GrSizeY(),fgc,GrNOCOLOR);
	GrDisplayCursor(cur);
	for( ; ; ) {
	    switch(getkey()) {
		case 'u': y--; break;
		case 'd': y++; break;
		case 'l': x--; break;
		case 'r': x++; break;
		case 'U': y -= 10; break;
		case 'D': y += 10; break;
		case 'L': x -= 10; break;
		case 'R': x += 10; break;
		case 'q': return;
		default:  continue;
	    }
	    GrMoveCursor(cur,x,y);
	}
}

