/** 
 ** MEMCOPY.H 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _MEMCOPY_H_
#define _MEMCOPY_H_

#ifdef  __TURBOC__
#pragma inline
#endif

/*
 * utilities -- other files may define them too
 */
#ifndef _SaveDS

#ifdef  __TURBOC__
#define _ClrDir()	asm cld
#define _SetDir()	asm std
#define _SaveDS()	asm push ds
#define _RestoreDS()	asm pop  ds
#endif

#ifdef  __GNUC__
#define _ASV		asm volatile
#define _ClrDir()	_ASV("cld")
#define _SetDir()	_ASV("std")
#define _SaveDS()
#define _RestoreDS()
#endif

#endif  /* _SaveDS */

/*
 * copy a pixel row
 */
#ifdef  __TURBOC__
#define _MC_ROWCPY_(dstp,srcp,len,SZ) do {				    \
	_CX = len;							    \
	asm les	    di,DWORD PTR dstp;					    \
	asm lds	    si,DWORD PTR srcp;					    \
	asm rep	    movs##SZ;						    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MC_ROWCPY_(dstp,srcp,len,SZ) _ASV(				 "\n\
	movl	%0,%%edi						  \n\
	movl	%1,%%esi						  \n\
	movl	%2,%%ecx						  \n\
	rep								  \n\
	movs"#SZ"							   "\
	: /* NOTHING */							    \
	: "g" (dstp), "g" (srcp), "g" (len)				    \
	: "di", "si", "cx"						    \
)
#endif

#define _RowCpyB(ID,dstp,srcp,len)	_MC_ROWCPY_(dstp,srcp,len,b)
#define _RowCpyW(ID,dstp,srcp,len)	_MC_ROWCPY_(dstp,srcp,len,w)
#define _RowCpyL(ID,dstp,srcp,len)	_MC_ROWCPY_(dstp,srcp,len,l)

/*
 * copy a pixel row with logical operations
 */
#ifdef  __TURBOC__
#define _MC_ROWCPYOPR_(dstp,srcp,len,OPR,REG,SZ,ID) do {		    \
	_CX = len;							    \
	asm les	    di,DWORD PTR dstp;					    \
	asm lds	    si,DWORD PTR srcp;					    \
MC_RowCpy##ID##Loop:							    \
	asm lods##SZ;							    \
	asm OPR	    REG,es:[di];					    \
	asm stos##SZ;							    \
	asm loop    MC_RowCpy##ID##Loop;				    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MC_ROWCPYOPR_(dstp,srcp,len,OPR,REG,SZ,ID) _ASV(		 "\n\
	movl	%0,%%edi						  \n\
	movl	%1,%%esi						  \n\
	movl	%2,%%ecx						  \n\
L_MC_RowCpy"#ID"Loop:							  \n\
	lods"#SZ"							  \n\
	"#OPR #SZ"  (%%edi),%%"#REG"					  \n\
	stos"#SZ"							  \n\
	loop	L_MC_RowCpy"#ID"Loop					   "\
	: /* NOTHING */							    \
	: "g" (dstp), "g" (srcp), "g" (len)				    \
	: "di", "si", "cx", "ax"					    \
)
#endif

#define _RowCpyXorB(ID,dstp,srcp,len)	_MC_ROWCPYOPR_(dstp,srcp,len,xor,al,b,ID##XB)
#define _RowCpyOrB(ID,dstp,srcp,len)	_MC_ROWCPYOPR_(dstp,srcp,len,or,al,b,ID##OB)
#define _RowCpyAndB(ID,dstp,srcp,len)	_MC_ROWCPYOPR_(dstp,srcp,len,and,al,b,ID##AB)

#define _RowCpyXorW(ID,dstp,srcp,len)	_MC_ROWCPYOPR_(dstp,srcp,len,xor,ax,w,ID##XW)
#define _RowCpyOrW(ID,dstp,srcp,len)	_MC_ROWCPYOPR_(dstp,srcp,len,or,ax,w,ID##OW)
#define _RowCpyAndW(ID,dstp,srcp,len)	_MC_ROWCPYOPR_(dstp,srcp,len,and,ax,w,ID##AW)

#define _RowCpyXorL(ID,dstp,srcp,len)	_MC_ROWCPYOPR_(dstp,srcp,len,xor,eax,l,ID##XL)
#define _RowCpyOrL(ID,dstp,srcp,len)	_MC_ROWCPYOPR_(dstp,srcp,len,or,eax,l,ID##OL)
#define _RowCpyAndL(ID,dstp,srcp,len)	_MC_ROWCPYOPR_(dstp,srcp,len,and,eax,l,ID##AL)

/*
 * copy a pixel column with logical operations
 */
#ifdef  __TURBOC__
#define _MC_COLCPYOPR_(dstp,doff,srcp,soff,hgt,OPR,REG,SZ,ID) do {	    \
	_BX = soff;							    \
	_DX = doff;							    \
	_CX = hgt;							    \
	asm les	    di,DWORD PTR dstp;					    \
	asm lds	    di,DWORD PTR srcp;					    \
MC_ColCpy##ID##Loop:							    \
	asm mov	    REG,ds:[si];					    \
	asm OPR	    es:[di],REG;					    \
	asm add	    di,dx;						    \
	asm add	    si,bx;						    \
	asm loop    MC_ColCpy##ID##Loop;				    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MC_COLCPYOPR_(dstp,doff,srcp,soff,hgt,OPR,REG,SZ,ID) _ASV(	 "\n\
	movl	%0,%%edi						  \n\
	movl	%1,%%edx						  \n\
	movl	%2,%%esi						  \n\
	movl	%3,%%ebx						  \n\
	movl	%4,%%ecx						  \n\
L_MC_ColCpy"#ID"Loop:							  \n\
	mov"#SZ"    (%%esi),%%"#REG"					  \n\
	"#OPR #SZ"  %%"#REG",(%%edi)					  \n\
	addl	%%edx,%%edi						  \n\
	addl	%%ebx,%%esi						  \n\
	loop	L_MC_ColCpy"#ID"Loop					   "\
	: /* NOTHING */							    \
	: "g" (dstp), "g" (doff), "g" (srcp), "g" (soff), "g" (hgt)	    \
	: "di", "si", "dx", "cx", "bx", "ax"				    \
)
#endif

#define _ColCpyB(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,mov,al,b,ID##B)
#define _ColCpyXorB(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,xor,al,b,ID##XB)
#define _ColCpyOrB(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,or,al,b,ID##OB)
#define _ColCpyAndB(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,and,al,b,ID##AB)

#define _ColCpyW(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,mov,ax,w,ID##W)
#define _ColCpyXorW(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,xor,ax,w,ID##XW)
#define _ColCpyOrW(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,or,ax,w,ID##OW)
#define _ColCpyAndW(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,and,ax,w,ID##AW)

#define _ColCpyL(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,mov,eax,l,ID##L)
#define _ColCpyXorL(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,xor,eax,l,ID##XL)
#define _ColCpyOrL(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,or,eax,l,ID##OL)
#define _ColCpyAndL(ID,dp,do,sp,so,h)	_MC_COLCPYOPR_(dp,do,sp,so,h,and,eax,l,ID##AL)

/*
 * copy a pixel block
 */
#ifdef  __TURBOC__
#define _MC_BLKCPY_(dstp,doff,srcp,soff,wdt,hgt,SZ,ID) do {		    \
	_BX = soff;							    \
	_DX = doff;							    \
	_AX = hgt;							    \
	asm les	    di,DWORD PTR dstp;					    \
	asm lds	    si,DWORD PTR srcp;					    \
MC_BlkCpy##ID##Loop:							    \
	asm mov	    cx,WORD  PTR wdt;					    \
	asm rep	    movs##SZ;						    \
	asm add	    di,dx;						    \
	asm add	    si,bx;						    \
	asm dec	    ax;							    \
	asm jnz	    MC_BlkCpy##ID##Loop;				    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MC_BLKCPY_(dstp,doff,srcp,soff,wdt,hgt,SZ,ID) _ASV(		 "\n\
	movl	%0,%%edi						  \n\
	movl	%1,%%edx						  \n\
	movl	%2,%%esi						  \n\
	movl	%3,%%ebx						  \n\
	movl	%5,%%eax						  \n\
L_MC_BlkCpy"#ID"Loop:							  \n\
	movl	%4,%%ecx						  \n\
	rep								  \n\
	movs"#SZ"							  \n\
	addl	%%edx,%%edi						  \n\
	addl	%%ebx,%%esi						  \n\
	decl	%%eax							  \n\
	jnz	L_MC_BlkCpy"#ID"Loop					   "\
	: /* NOTHING */							    \
	: "g" (dstp), "g" (doff),					    \
	  "g" (srcp), "g" (soff),					    \
	  "g" (wdt),  "g" (hgt)						    \
	: "di", "si", "dx", "cx", "bx", "ax"				    \
)
#endif

#define _BlkCpyB(ID,dp,do,sp,so,wd,hg)  _MC_BLKCPY_(dp,do,sp,so,wd,hg,b,ID##B)
#define _BlkCpyW(ID,dp,do,sp,so,wd,hg)  _MC_BLKCPY_(dp,do,sp,so,wd,hg,w,ID##W)
#define _BlkCpyL(ID,dp,do,sp,so,wd,hg)  _MC_BLKCPY_(dp,do,sp,so,wd,hg,l,ID##L)

/*
 * copy a pixel block with logical operations
 */
#ifdef  __TURBOC__
#define _MC_BLKCPYOPR_(dstp,doff,srcp,soff,wdt,hgt,OPR,REG,SZ,ID) do {	    \
	_DX = hgt;							    \
	asm les	    di,DWORD PTR dstp;					    \
	asm lds	    si,DWORD PTR srcp;					    \
MC_BlkCpy##ID##VertLoop:						    \
	asm mov	    cx,WORD  PTR wdt;					    \
MC_BlkCpy##ID##LineLoop:						    \
	asm lods##SZ;							    \
	asm OPR	    REG,es:[di];					    \
	asm stos##SZ;							    \
	asm loop    MC_BlkCpy##ID##LineLoop;				    \
	asm add	    di,WORD PTR doff;					    \
	asm add	    si,WORD PTR soff;					    \
	asm dec	    dx;							    \
	asm jnz	    MC_BlkCpy##ID##VertLoop;				    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MC_BLKCPYOPR_(dstp,doff,srcp,soff,wdt,hgt,OPR,REG,SZ,ID) _ASV(  "\n\
	movl	%0,%%edi						  \n\
	movl	%2,%%esi						  \n\
	movl	%5,%%edx						  \n\
L_MC_BlkCpy"#ID"VertLoop:						  \n\
	movl	%4,%%ecx						  \n\
L_MC_BlkCpy"#ID"LineLoop:						  \n\
	lods"#SZ"							  \n\
	"#OPR #SZ"  (%%edi),%%"#REG"					  \n\
	stos"#SZ"							  \n\
	loop	L_MC_BlkCpy"#ID"LineLoop				  \n\
	addl	%1,%%edi						  \n\
	addl	%3,%%esi						  \n\
	decl	%%edx							  \n\
	jne	L_MC_BlkCpy"#ID"VertLoop				   "\
	: /* NOTHING */							    \
	: "g" (dstp), "g" (doff),					    \
	  "g" (srcp), "g" (soff),					    \
	  "g" (wdt),  "g" (hgt)						    \
	: "di", "si", "dx", "cx", "ax"					    \
)
#endif

#define _BlkCpyXorB(ID,dp,do,sp,so,W,H) _MC_BLKCPYOPR_(dp,do,sp,so,W,H,xor,al,b,ID##XB)
#define _BlkCpyOrB(ID,dp,do,sp,so,W,H)  _MC_BLKCPYOPR_(dp,do,sp,so,W,H,or,al,b,ID##OB)
#define _BlkCpyAndB(ID,dp,do,sp,so,W,H) _MC_BLKCPYOPR_(dp,do,sp,so,W,H,and,al,b,ID##AB)

#define _BlkCpyXorW(ID,dp,do,sp,so,W,H) _MC_BLKCPYOPR_(dp,do,sp,so,W,H,xor,ax,w,ID##XW)
#define _BlkCpyOrW(ID,dp,do,sp,so,W,H)  _MC_BLKCPYOPR_(dp,do,sp,so,W,H,or,ax,w,ID##OW)
#define _BlkCpyAndW(ID,dp,do,sp,so,W,H) _MC_BLKCPYOPR_(dp,do,sp,so,W,H,and,ax,w,ID##AW)

#define _BlkCpyXorL(ID,dp,do,sp,so,W,H) _MC_BLKCPYOPR_(dp,do,sp,so,W,H,xor,eax,l,ID##XL)
#define _BlkCpyOrL(ID,dp,do,sp,so,W,H)  _MC_BLKCPYOPR_(dp,do,sp,so,W,H,or,eax,l,ID##OL)
#define _BlkCpyAndL(ID,dp,do,sp,so,W,H) _MC_BLKCPYOPR_(dp,do,sp,so,W,H,and,eax,l,ID##AL)

#endif  /* whole file */

