/**
 ** LOADFONT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "grxfile.h"
#include "grxfont.h"
#include "gmalloc.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>


char   _GrFontPath[80] = { "" };
static ResList *loaded = NULL;

void GrSetFontPath(char *path)
{
	_GrSetPath(((path == NULL) ? getenv(FNTENV) : path),_GrFontPath);
}

GrFont *GrLoadFont(char *name)
{
	FntFileHdr hdr;
	GrFont *font;
	char fullname[120];
	int  file;

	_GrGetFname(name,_GrFontPath,FNTENV,FNTEXT,fullname);
	if(fullname[0] == '@') {
	    font = GrLoadBIOSFont(fullname);
	    if(font != NULL) return(font);
	    _GrGetFname(&name[2],_GrFontPath,FNTENV,FNTEXT,fullname);
	}
	font = (GrFont *)_GrLookupInResList(fullname,loaded);
	if(font != NULL) return(font);
	if(((file = _GrFileOpen(fullname)) == EOF) ||
		(read(file,&hdr,sizeof(FntFileHdr)) != sizeof(FntFileHdr)) ||
		(hdr.magic != FONT_MAGIC)) {
	    if(file != EOF) _GrFileClose(file);
	    return(NULL);
	}
	if(hdr.h.fnt_isfixed) {
	    FixedFont *result;
	    char far  *bits;

#ifdef _MAXMEMPLANESIZE
	    if(hdr.bitmapsize >= _MAXMEMPLANESIZE) {
		_GrFileClose(file);
		return(NULL);
	    }
#endif
	    result = _GrMalloc(sizeof(FixedFont));
	    bits = _GrFarMalloc(hdr.bitmapsize + 1);
	    if((result == NULL) ||
	       (bits == (char far *)NULL) ||
	       (_GrFarRead(file,bits,hdr.bitmapsize) != hdr.bitmapsize)) {
		if(result != NULL) _GrFree(result);
		if(bits != (char far *)NULL) _GrFarFree(bits);
		_GrFileClose(file);
		return(NULL);
	    }
	    result->h = hdr.h;
	    result->ff_bits = bits;
	    result->ff_chrsize =
		((hdr.h.fnt_width + 7) >> 3) * hdr.h.fnt_height;
	    _GrFileClose(file);
	    font = (GrFont *)result;
	}
	else {
	    int ii,numc = hdr.h.fnt_maxchar - hdr.h.fnt_minchar + 1;
	    int tsize1 = numc * sizeof(short);
	    int tsize2 = (numc - 1) * sizeof(char far *);
	    PropFont *result = _GrMalloc(sizeof(PropFont) + tsize1 + tsize2);
	    char far *bits   = _GrFarMalloc(hdr.bitmapsize + 1);

	    if((result == NULL) ||
	       (bits == (char far *)NULL) ||
	       (read(file,&result->pf_bits[numc],tsize1) != tsize1) ||
	       (_GrFarRead(file,bits,hdr.bitmapsize) != hdr.bitmapsize)) {
		if(result != NULL) _GrFree(result);
		if(bits != (char far *)NULL) _GrFarFree(bits);
		_GrFileClose(file);
		return(NULL);
	    }
	    result->h = hdr.h;
	    result->pf_width = (short *)(&result->pf_bits[numc]);
	    result->pf_maxwidth = 0;
	    result->pf_minwidth = 32767;
	    for(ii = 0; ii < numc; ii++) {
		tsize1 = result->pf_width[ii];
		tsize2 = ((tsize1 + 7) >> 3) * hdr.h.fnt_height;
		result->pf_bits[ii] = bits;
		bits = (char far *)((char huge *)bits + (long)tsize2);
		if(result->pf_minwidth > tsize1) result->pf_minwidth = tsize1;
		if(result->pf_maxwidth < tsize1) result->pf_maxwidth = tsize1;
	    }
	    _GrFileClose(file);
	    font = (GrFont *)result;
	}
	_GrAddToResList((void *)font,fullname,&loaded);
	return(font);
}

void GrUnloadFont(GrFont *font)
{
	if((font != NULL) && !font->fnt_internal) {
	    _GrRemoveFromResList(font,&loaded);
	    _GrFarFree(font->fnt_isfixed ?
		((FixedFont *)font)->ff_bits :
		((PropFont *)font)->pf_bits[0]
	    );
	    _GrFree(font);
	}
}

