/** 
 ** LINECLIP.H 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _CLIPPING_H_

#include "scale.h"
#include "clipping.h"

#define CLIPLINE(c,x1,y1,x2,y2) do {					\
    register int temp;							\
									\
    if(x1 > x2)								\
	{ EXCHG(x1,x2); EXCHG(y1,y2); }					\
    if((x2 < c->gc_xcliplo) || (x1 > c->gc_xcliphi))			\
	{ WHEN_OUTSIDE; }						\
    if(y1 < y2) {							\
	if((y2 < c->gc_ycliplo) || (y1 > c->gc_ycliphi)) {		\
	    WHEN_OUTSIDE;						\
	}								\
	if(y1 < c->gc_ycliplo) {					\
	    USCALE(temp,(x2 - x1),(c->gc_ycliplo - y1),(y2 - y1));	\
	    if((x1 += temp) > c->gc_xcliphi) { WHEN_OUTSIDE; }		\
	    y1 = c->gc_ycliplo;						\
	    WHEN_CLIPPED;						\
	}								\
	if(y2 > c->gc_ycliphi) {					\
	    USCALE(temp,(x2 - x1),(y2 - c->gc_ycliphi),(y2 - y1));	\
	    if((x2 -= temp) < c->gc_xcliplo) { WHEN_OUTSIDE; }		\
	    y2 = c->gc_ycliphi;						\
	    WHEN_CLIPPED;						\
	}								\
	if(x1 < c->gc_xcliplo) {					\
	    USCALE(temp,(y2 - y1),(c->gc_xcliplo - x1),(x2 - x1));	\
	    y1 += temp;							\
	    x1 = c->gc_xcliplo;						\
	    WHEN_CLIPPED;						\
	}								\
	if(x2 > c->gc_xcliphi) {					\
	    USCALE(temp,(y2 - y1),(x2 - c->gc_xcliphi),(x2 - x1));	\
	    y2 -= temp;							\
	    x2 = c->gc_xcliphi;						\
	    WHEN_CLIPPED;						\
	}								\
    }									\
    else {								\
	if((y1 < c->gc_ycliplo) || (y2 > c->gc_ycliphi)) {		\
	    WHEN_OUTSIDE;						\
	}								\
	if(y1 > c->gc_ycliphi) {					\
	    USCALE(temp,(x2 - x1),(y1 - c->gc_ycliphi),(y1 - y2));	\
	    if((x1 += temp) > c->gc_xcliphi) { WHEN_OUTSIDE; }		\
	    y1 = c->gc_ycliphi;						\
	    WHEN_CLIPPED;						\
	}								\
	if(y2 < c->gc_ycliplo) {					\
	    USCALE(temp,(x2 - x1),(c->gc_ycliplo - y2),(y1 - y2));	\
	    if((x2 -= temp) < c->gc_xcliplo) { WHEN_OUTSIDE; }		\
	    y2 = c->gc_ycliplo;						\
	    WHEN_CLIPPED;						\
	}								\
	if(x1 < c->gc_xcliplo) {					\
	    USCALE(temp,(y1 - y2),(c->gc_xcliplo - x1),(x2 - x1));	\
	    y1 -= temp;							\
	    x1 = c->gc_xcliplo;						\
	    WHEN_CLIPPED;						\
	}								\
	if(x2 > c->gc_xcliphi) {					\
	    USCALE(temp,(y1 - y2),(x2 - c->gc_xcliphi),(x2 - x1));	\
	    y2 += temp;							\
	    x2 = c->gc_xcliphi;						\
	    WHEN_CLIPPED;						\
	}								\
    }									\
} while(0)

#endif /* whole file */

