#include "fntool.h"
#include "../include/grx.h"
#include "../include/grxfile.h"

void writedir(int argc,char **argv)
{
	FntDirHdr  dhdr;
	FntFileHdr fhdr;
	char name[100],*p;

	dhdr.magic = FONTDIR_MAGIC;
	dhdr.numentries = argc;
	fwrite(&dhdr,sizeof(FntDirHdr),1,outfile);
	while(--argc >= 0) {
	    openinput(*argv++,"rb");
	    if(fread(&fhdr,sizeof(fhdr),1,infile) != 1)
		fatalerr("error reading input file \"%s\"",inname);
	    if(fhdr.magic != FONT_MAGIC)
		fatalerr("invalid \".fnt\" file: \"%s\"",inname);
	    if(opt.verbose)
		printf("  adding font \"%s\" to directory \"%s\"\n",inname,outname);
	    strcpy(name,inname);
	    for(p = name; *p != '\0'; p++) {
		if(*p == '\\') { *p = '/'; continue; }
		*p = tolower(*p);
	    }
	    memset(fhdr.h.fnt_name,0,sizeof(fhdr.h.fnt_name));
	    strcpy(fhdr.h.fnt_name,name);
	    fwrite(&fhdr.h,sizeof(GrFont),1,outfile);
	    closeinput();
	}
}

