!if $d(DEBUG)
TDEBUG= -v -DDEBUG=1
!endif

TCCOPT= -O -G -Z -w -d $(TDEBUG)

all:	..\lib\queues.lib    \
	..\lib\queuem.lib    \
	..\lib\queuec.lib    \
	..\lib\queuel.lib    \
	..\lib\queueh.lib    \
	evtest.exe

evtest.exe: evtest.c ..\lib\queues.lib
	tcc -ms -eevtest $(TCCOPT) evtest.c ..\lib\queues.lib

..\lib\queues.lib: event.obs nextevnt.obs evintr.obj
	-del ..\lib\queues.lib
	tlib ..\lib\queues.lib /c +event.obs +nextevnt.obs +evintr.obj

..\lib\queuem.lib: event.obm nextevnt.obm evintr.obj
	-del ..\lib\queuem.lib
	tlib ..\lib\queuem.lib /c +event.obm +nextevnt.obm +evintr.obj

..\lib\queuec.lib: event.obc nextevnt.obc evintr.obj
	-del ..\lib\queuec.lib
	tlib ..\lib\queuec.lib /c +event.obc +nextevnt.obc +evintr.obj

..\lib\queuel.lib: event.obl nextevnt.obl evintr.obj
	-del ..\lib\queuel.lib
	tlib ..\lib\queuel.lib /c +event.obl +nextevnt.obl +evintr.obj

..\lib\queueh.lib: event.obh nextevnt.obh evintr.obj
	-del ..\lib\queueh.lib
	tlib ..\lib\queueh.lib /c +event.obh +nextevnt.obh +evintr.obj

evintr.obj: evintr.asm
	tasm /mx evintr.asm


#
# Dependencies:
#
EVENT_OBJ=    event.obs event.obm event.obc event.obl event.obm

NEXTEVNT_OBJ= nextevnt.obs nextevnt.obm nextevnt.obc nextevnt.obl nextevnt.obm

$(EVENT_OBJ):	 eventque.h

$(NEXTEVNT_OBJ): eventque.h


#
# Rules:
#
.c.obs:
	tcc -c -ms $(TCCOPT) -o$*.obs $*.c

.c.obm:
	tcc -c -mm $(TCCOPT) -o$*.obm $*.c

.c.obc:
	tcc -c -mc $(TCCOPT) -o$*.obc $*.c

.c.obl:
	tcc -c -ml $(TCCOPT) -o$*.obl $*.c

.c.obh:
	tcc -c -mh $(TCCOPT) -o$*.obh $*.c


