#include <X11/IntrinsicP.h>		/* for toolkit stuff */
#include <X11/StringDefs.h>		/* for useful atom names */
#include <X11/cursorfont.h>		/* for cursor constants */
#include <X11/Xosdefs.h>		/* for X_NOT_POSIX def */
#include <sys/stat.h>			/* for stat() ** needs types.h ***/
#include <stdio.h>			/* for printing error messages */
#include <stdlib.h>
#include <ctype.h>			/* for tolower() */
#include <string.h>

#include <X11/Xaw/XawInit.h>
#include "SSMailboxP.h"

#include "xbiff-proto.h"

typedef struct string {
  char *str;
  int allocated, used;
} string;

struct mailHeaderTable {
  char name[8];
  int len;
  string *line;
} mhTable[] = {
#define		MHT_CC		0
  { "Cc",	2,	NULL },
#define		MHT_TO		1
  { "To",	2,	NULL },
#define		MHT_FROM	2
  { "From",	4,	NULL },
#define		MHT_SUBJECT	3
  { "Subject",	7,	NULL },
};
static int mhTableLen = sizeof(mhTable) / sizeof(struct mailHeaderTable);
static int mhTableCaseSensitive = TRUE;

static void
saveHdr(sp, line)
string **sp;
char *line;
{
  int len;

  /* create string if it doesn't exist */
  if (*sp == NULL) {
    *sp = (string *)malloc(sizeof(string));
    (*sp)->str = NULL;
    (*sp)->allocated = (*sp)->used = 0;
  }

  /* lose leading & trailing blanks */
  while (*line && isspace(*line))
    line++;
  len = strlen(line);
  while (isspace(line[len-1])) {
    len--;
    line[len] = 0;
  }

  /* make sure there's room for this string */
  if ((*sp)->allocated < len+1) {
    if ((*sp)->str)
      free((*sp)->str);

    (*sp)->str = (char *)malloc(len+1);
    if ((*sp)->str == NULL) {
      (*sp)->allocated = 0;
      return;
    }

    (*sp)->allocated = len+1;
  }

  /* save this string */
  strcpy((*sp)->str, line);
  (*sp)->used = len+1;
}

static void
appendHdr(sp, line)
string **sp;
char *line;
{
  int len;

  /* create string if it doesn't exist */
  if (*sp == NULL) {
    *sp = (string *)malloc(sizeof(string));
    (*sp)->str = NULL;
    (*sp)->allocated = (*sp)->used = 0;
  }

  /* lose leading & trailing blanks */
  while (*line && isspace(*line))
    line++;
  len = strlen(line);
  while (isspace(line[len-1])) {
    len--;
    line[len] = 0;
  }

  /* make sure there's room for this string */
  if ((*sp)->allocated < ((*sp)->used + 1 + len)) {
    (*sp)->str = (char *)realloc((*sp)->str, (*sp)->used+1+len);
    if ((*sp)->str == NULL) {
      (*sp)->allocated = 0;
      return;
    }

    (*sp)->allocated = (*sp)->used + 1 + len;
  }

  /* append this string */
  (*sp)->str[(*sp)->used-1] = ' ';
  strcpy(&((*sp)->str[(*sp)->used]), line);
  (*sp)->used = (*sp)->used + 1 + len;
}

static void
clearHdrs()
{
  int i;

  for (i = 0; i < mhTableLen; i++) {
    if (mhTable[i].line) {
      mhTable[i].line->used = 0;
      mhTable[i].line->str[0] = 0;
    }
  }
}

#ifdef NEED_TO_FREE_EVERYTHING
static void
freeHdrs()
{
  int i;

  for (i = 0; i < mhTableLen; i++) {
    if (mhTable[i].line) {
      if (mhTable[i].line->str)
	free(mhTable[i].line->str);
      free(mhTable[i].line);
    }
  }
}
#endif

static void
match_headers(w, msp)
SSMailboxWidget w;
struct MsgStruct **msp;
{
   int matched;
   Bindings *binding;

   if (w->ssmailbox.debug == TRUE) {
      fprintf(stderr, "\nMSG HEADERS:\n");
      if (mhTable[MHT_FROM].line && mhTable[MHT_FROM].line->str &&
	  mhTable[MHT_FROM].line->str[0])
         fprintf(stderr, "%s\n", mhTable[MHT_FROM].line->str);
      if (mhTable[MHT_TO].line && mhTable[MHT_TO].line->str &&
	  mhTable[MHT_TO].line->str[0])
         fprintf(stderr, "%s\n", mhTable[MHT_TO].line->str);
      if (mhTable[MHT_CC].line && mhTable[MHT_CC].line->str &&
	  mhTable[MHT_CC].line->str[0])
	 fprintf(stderr, "%s\n", mhTable[MHT_CC].line->str);
      if (mhTable[MHT_SUBJECT].line && mhTable[MHT_SUBJECT].line->str &&
	  mhTable[MHT_SUBJECT].line->str[0])
         fprintf(stderr, "%s\n", mhTable[MHT_SUBJECT].line->str);
   }

   for (binding=w->ssmailbox.bindings; binding; binding = binding->next) {

      /* the order of the comparison here shouldn't matter, since we're
	 iterating by the user's regexps, not by the fields in the
	 incoming message. */
      if (mhTable[MHT_CC].line &&
	  regexec(binding->pattern, mhTable[MHT_CC].line->str)) {
	 matched = 1;
	 if (w->ssmailbox.debug == TRUE)
	    fprintf(stderr, "Cc line matched pattern \"%s\"\n",
		    binding->patstr);
      } else if (mhTable[MHT_TO].line &&
		 regexec(binding->pattern, mhTable[MHT_TO].line->str)) {
	 matched = 1;
	 if (w->ssmailbox.debug == TRUE)
	    fprintf(stderr, "To line matched pattern \"%s\"\n",
		    binding->patstr);
      } else if (mhTable[MHT_FROM].line &&
		 regexec(binding->pattern, mhTable[MHT_FROM].line->str)) {
	 matched = 1;
	 if (w->ssmailbox.debug == TRUE)
	    fprintf(stderr, "From line matched pattern \"%s\"\n",
		    binding->patstr);
      } else if (mhTable[MHT_SUBJECT].line &&
		 regexec(binding->pattern, mhTable[MHT_SUBJECT].line->str)) {
	 matched = 1;
	 if (w->ssmailbox.debug == TRUE)
	    fprintf(stderr, "Subject line matched pattern \"%s\"\n",
		    binding->patstr);
      } else {
	 matched = 0;
	 if (w->ssmailbox.debug == TRUE)
	    fprintf(stderr, "Nothing matched pattern \"%s\"\n", binding->patstr);
      }

      if (matched) {
	 struct SoundStruct *s;
	 if (!*msp) {
	    *msp = (struct MsgStruct *)malloc(sizeof(struct MsgStruct));
	    (*msp)->sounds = 0;
	    (*msp)->next = 0;
	 }
	 s = (struct SoundStruct *)malloc(sizeof(struct SoundStruct));
	 s->sound = binding->sound;
	 s->face = binding->face;
	 s->next = (*msp)->sounds;
	 (*msp)->sounds = s;
	 if (w->ssmailbox.debug == TRUE)
	    fprintf(stderr, "Sound=\"%s\", Face=\"%s\"\n",
		    s->sound ? s->sound : "<null>",
		    s->face ? s->face : "<null>");
	 return;
      }
   }
}

static void
add_sound(w, sounds, ms, status)
SSMailboxWidget w;
struct MsgStruct **sounds, *ms;
int status;
{
    if (!status)
    {
	if (!ms)
	{
	    ms = (struct MsgStruct *)malloc(sizeof(struct
						   MsgStruct));
	    ms->sounds = (struct SoundStruct *)malloc(sizeof(struct
							     SoundStruct));
	    ms->sounds->sound = w->ssmailbox.sound;
	    ms->sounds->face = w->ssmailbox.face;
	    ms->sounds->next = 0;
	}
	ms->next = *sounds;
	*sounds = ms;
    }
    else if (ms)
    {
	while (ms->sounds)
	{
	    struct SoundStruct *x;
	    x = ms->sounds->next;
	    free((char *)ms->sounds);
	    ms->sounds = x;
	}
	free((char *)ms);
    }
}

int
scanmbox(w, fp, sounds)
SSMailboxWidget w;
FILE *fp;
struct MsgStruct **sounds;
{
    int mcnt, status, numnew, in_header;
    char line[256], *lp;
    struct MsgStruct *ms = 0;
    int i, lasti = -1;
    int hlen;

    /* Most of this rewritten by dglo.
       read in the headers of each letter first, then compare.
     */
    mcnt = 0; status = numnew = in_header = 0;

    if (w->ssmailbox.case_sensitive == FALSE && mhTableCaseSensitive == TRUE) {
	int i;
	char *c;

	for (i = 0; i < mhTableLen; i++)
	    for (c = mhTable[i].name; *c != '\0'; c++)
		if (isupper(*c)) *c = tolower(*c);
	mhTableCaseSensitive = FALSE;
    }

    while ( fgets(line, sizeof(line), fp) ) {
        if (strncmp(line, "From ", 5) == 0) {

	   ms = 0;
	   status = 0;
	   in_header = 1;
	   clearHdrs();
	} else if (in_header) {
	   if (*line != '\n' && !status) {

	      /* downshift for insensitive types */
	      if (w->ssmailbox.case_sensitive == FALSE) {
		 char *c = line;
		 for (; *c != '\0'; c++)
		    if (isupper(*c)) *c = tolower(*c);
	      }

	      /* replace newline w/ null for regexp */
	      line[strlen(line)-1]='\0';

	      /* skip header title */
	      lp = line;
	      while (*lp && !isspace(*lp) && *lp != ':')
		 lp++;

	      /* make sure we didn't stumble across a bogus header field */
	      if (lp[0] && lp[0] == ':' && lp[1] && isspace(lp[1]))
		 hlen = lp - line;
	      else if (!isspace(line[0])) {
		 if (w->ssmailbox.debug == TRUE)
		    fprintf(stderr, "Saw garbage hdr \"%s\"\n", line);
		 return -1;
	      }

	      if (isspace(line[0])) {

		 /* save continued line with previous header */
		 if (lasti != -1)
		    appendHdr(&(mhTable[lasti].line), &line[1]);

	      } else if ((*line == 's' || *line == 'S') &&
			 !strncmp(&line[1], "tatus:", 7) && isspace(line[7])) {
	         if (strchr(&line[8],'r') || strchr(&line[8],'R')) {

		    /* ignore previously read msgs */
		    status = 1;
#ifdef DEBUG_SCANMBOX
		    fprintf(stderr, "Skipping previously read msg %d\n", mcnt);
#endif
		 }
	      } else {

		 /* do we care about this header? */
		 lasti = -1;
		 for (i = 0; i < mhTableLen; i++)
		    if (mhTable[i].len == hlen &&
			!strncmp(line, mhTable[i].name, mhTable[i].len) &&
			line[mhTable[i].len] == ':' &&
			isspace(line[mhTable[i].len+1])) {
		       lasti = i;
		       saveHdr(&(mhTable[i].line), line);
		       break;
		    }
	      }
	   } else if (*line == '\n') {

	      /* at this point, we've just reached the end of the message
	       *  header, and have already passed over the whole header and
	       *  collected the four relevant fields;
	       * now match them against the db.
	       */
	      in_header = 0;
	      match_headers(w, &ms);
	      mcnt++;

	      if (!status) {
		 /* this is a new (subsequent) message - add a struct
		    representing it */

		 numnew++;
#ifdef DEBUG_SCANMBOX
	      fprintf(stderr, "Found hdrs for msg %d (%d new)\n", mcnt, numnew);
#endif
		 add_sound(w, sounds, ms, status);
	      }
	   }
	} else if (mcnt == 0) {
	   if (w->ssmailbox.debug == TRUE)
	      fprintf(stderr, "First msg doesn't start with \"From \"\n");
#ifdef DEBUG_SCANMBOX
	   fprintf(stderr, "Bad line = %s", line);
#endif
	   return -1;
	}
    }
    fclose(fp);
    return numnew;
}

#ifdef DEBUG_SCANMBOX

int
regexec(prog, string)
regexp *prog;
char *string;
{
  return 0;
}

int
main(argc, argv)
int argc;
char *argv[];
{
  struct _SSMailboxRec ssmw;
  int i;
  FILE *fp;
  size_t offset = 0;
  int numnew;
  struct MsgStruct *sounds = NULL;

  /* initialize pseudo-widget */
  ssmw.ssmailbox.debug = TRUE;
  ssmw.ssmailbox.bindings = NULL;
  ssmw.ssmailbox.sound = NULL;
  ssmw.ssmailbox.face = NULL;
  ssmw.ssmailbox.case_sensitive = FALSE;

  for (i = 1; i < argc; i++) {
    if (argv[i][0] == '+') {
      offset = strtol(&argv[i][1], NULL, 10);
    } else {
      fp = fopen(argv[i], "r");
      if (offset > 0)
	 fseek(fp, offset, SEEK_SET);
      if (!fp)
	fprintf(stderr, "Couldn't read mbox \"%s\"\n", argv[i]);
      else {
	numnew = scanmbox(&ssmw, fp, &sounds);
	printf("Saw %d new msg%s in mbox \"%s\"\n", numnew,
	       (numnew == 1 ? "" : "s"), argv[i]);
      }
    }
  }

  exit(0);
}
#endif /* DEBUG_SCANMBOX */
