/* $XConsortium: MailboxP.h,v 1.22 94/04/17 20:43:27 rws Exp $ */
/*

Copyright (c) 1988  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

#ifndef _SSMailboxP_h
#define _SSMailboxP_h

#include "SSMailbox.h"
#include <X11/Xaw/SimpleP.h>

#include "regexp.h"


#ifdef SYSV
#define MAILBOX_DIRECTORY "/usr/mail"
#else
#ifdef SVR4
#define MAILBOX_DIRECTORY "/var/mail"
#else
#define MAILBOX_DIRECTORY "/usr/spool/mail"
#endif
#endif

struct SoundStruct
{
    char *sound;
    char *face;
    struct SoundStruct *next;
};

struct MsgStruct
{
    struct SoundStruct *sounds;
    struct MsgStruct *next;
};

typedef struct bindings_struct
{
    String patstr;
    regexp *pattern;
    String sound;
    String face;
    struct bindings_struct *next;
} Bindings;

typedef struct {			/* new fields for mailbox widget */
    /* resources */
    int update;				/* seconds between updates */
    Pixel foreground_pixel;		/* color index of normal state fg */
    String filename;			/* filename to watch */
    String check_command;		/* command to exec for mail check */
    Boolean flipit;			/* do flip of full pixmap */
    int volume;				/* bell volume */
    Boolean once_only;			/* ring bell only once on new mail */
    /* local state */
    GC gc;				/* normal GC to use */
    long last_size;			/* size in bytes of mailboxname */
    time_t last_mtime;			/* last modification time */
    long last_numnew;			/* last number of new msgs */
    XtIntervalId interval_id;		/* time between checks */
    Boolean flag_up;			/* is the flag up? */
    struct _mbimage {
	Pixmap bitmap, mask;		/* depth 1, describing shape */
	XImage *image;			/* full depth XImage */
	XColor *colors;			/* the colors in this image */
	int ncolors;			/* this is 0 for monochrome xbms */
	int width, height;		/* geometry of pixmaps */
    } full, empty, current_face;
    Boolean shapeit;			/* do shape extension */
    struct {
	Pixmap mask;
	int x, y;
    } shape_cache;			/* last set of info */
    String sound;                     /* name of default sound to play */
    String no_mail_sound;             /* sound to play when no mail */
    String face;                      /* name of the bitmap to show */
    String sound_bindings;	      /* bindings of sounds to sender names */
    String face_bindings;	      /* bindings of bitmaps to sender names */
    Bindings *bindings;		      /* sounds and faces */
    Boolean case_sensitive;
    Boolean auto_resize;
    Boolean not_on_console;

    Boolean use_LED;		/* whether to use a kbd LED for reporting */
    int which_LED;		/* if so, which one */
    Boolean debug;		/* whether to print debugging msgs */
    String sound_path;		/* sound file lookup path */
} SSMailboxPart;

typedef struct _SSMailboxRec {		/* full instance record */
    CorePart core;
    SimplePart simple;
    SSMailboxPart ssmailbox;
} SSMailboxRec;


typedef struct {			/* new fields for mailbox class */
    int dummy;				/* stupid C compiler */
} SSMailboxClassPart;

typedef struct _SSMailboxClassRec {	/* full class record declaration */
    CoreClassPart core_class;
    SimpleClassPart simple_class;
    SSMailboxClassPart ssmailbox_class;
} SSMailboxClassRec;

extern SSMailboxClassRec ssmailboxClassRec;	 /* class pointer */

#endif /* _SSMailboxP_h */
