/*
 *  ncptest.c
 *
 *  Copyright (C) 1995 by Volker Lendecke
 *
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ioctl.h>
/* #include <sys/wait.h> */  /* generates a warning here */
extern pid_t waitpid(pid_t, int *, int);
#include <sys/errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <mntent.h>
#include <linux/ipx.h>

#include <linux/fs.h>
#include <linux/ncp.h>
#include <linux/ncp_fs.h>
#include <linux/ncp_mount.h>
#include "ncplib_user.h"
#include "ipxutil.h"

static char *progname;
static char *mount_point;

void
test_filesearch(struct ncp_server *server)
{
	struct ncp_filesearch_info fsinfo;
	struct ncp_file_info       finfo;

	if (ncp_file_search_init(server, 0, "sys:\\public", &fsinfo) != 0) {
		printf("could not fs init\n");
		return;
	}

	while (ncp_file_search_continue(server, &fsinfo,
					0,
					"*", &finfo) == 0) {
		printf("name: %s\n", finfo.file_name);
	}
	return;
}

void
test_getfinfo(struct ncp_server *server)
{
	struct ncp_file_info finfo;

	ncp_get_finfo(server, 0, "sys:", "public", &finfo);
	ncp_get_finfo(server, 0, "sys:login", "login.exe", &finfo);
}

void
testopen(struct ncp_server *server)
{
	struct ncp_file_info finfo;
	char buf[1025];
	int bytes_read;

	ncp_open_file(server, 0, "sys:\\etc\\samples\\protocol", 0,
		      AR_READ|AR_WRITE,
		      &finfo);
	if (ncp_read(server, finfo.file_id, 0, 1024, buf, &bytes_read) == 0) {
		printf("bytes: %d\n", bytes_read);
		buf[bytes_read]=0;
		puts(buf);
	}
	
	ncp_close_file(server, finfo.file_id);
}

void
testcreate(struct ncp_server *server)
{

	if (ncp_rename_file(server, 0, "sys:\\me\\blub.txt", 0,
			    0, "sys:\\me\\blub1.txt") != 0) {
		printf("create war nix\n");
	}
	if (ncp_create_directory(server, 0, "sys:\\me\\blubdir", 0xff) != 0) {
		printf("mkdir war nix\n");
	}
	if (ncp_rename_directory(server, 0, "sys:\\me\\blubdir",
				 "\\me\\blubneu") != 0) {
		printf("mvdir war nix\n");
		return;
	}
	if (ncp_delete_directory(server, 0, "sys:\\me\\blubneu") != 0) {
		printf("rmdir war nix\n");
		return;
	}


}

void
test_lookup(struct ncp_server *server)
{
	struct nw_info_struct sys;
	struct nw_info_struct me;
	struct nw_file_info blub;
	
	if (ncp_do_lookup(server, NULL, "SYS", &sys) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_do_lookup(server, &sys, "ME", &me) != 0) {
		printf("lookup error\n");
		return;
	}
	
	if (ncp_open_create_file_or_subdir(server, &me, "BLUB.TXT",
					   OC_MODE_CREATE, 0, 0xffff,
					   &blub) != 0) {
		printf("open error\n");
		return;
	}
	return;
}

void
test_trunc(struct ncp_server *server)
{
	struct nw_info_struct sys;
	struct nw_info_struct me;
	struct nw_file_info blub;
	int written;
	
	if (ncp_do_lookup(server, NULL, "SYS", &sys) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_do_lookup(server, &sys, "ME", &me) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_do_lookup(server, &me, "BLUB.TXT", &(blub.i)) != 0) {
		printf("lookup error\n");
		return;
	}
	
	if (ncp_open_create_file_or_subdir(server, &(blub.i), NULL,
					   OC_MODE_OPEN, 0, AR_READ | AR_WRITE,
					   &blub) != 0) {
		printf("open error\n");
		return;
	}

	if (ncp_write(server, blub.file_handle, 4, 0, "", &written) != 0) {
		printf("trunc error\n");
		return;
	}

	if (ncp_close_file(server, blub.file_handle) != 0) {
		printf("close error\n");
		return;
	}

	return;
}

void
test_ls(struct ncp_server *server)
{
	struct nw_info_struct sys;
	struct nw_search_sequence seq;
	struct nw_info_struct found;
	int res;
	
	if (ncp_do_lookup(server, NULL, "SYS", &sys) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_initialize_search(server, &sys, &seq) != 0) {
		printf("init error\n");
		return;
	}
	while ((res=ncp_search_for_file_or_subdir(server,&seq,&found)) == 0) {
		printf("found %s: %s\n",
		       (found.attributes & aDIR) ? "dir " : "file",
		       found.entryName);
	}

	if (res == 0xfe) {
		printf("result: no more files\n");
	}
	else
	{
		printf("other error: %x\n", res);
	}
	return;
}

void
test_ren(struct ncp_server *server)
{
	struct nw_info_struct sys;
	struct nw_info_struct me;
	
	if (ncp_do_lookup(server, NULL, "SYS", &sys) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_do_lookup(server, &sys, "ME", &me) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_ren_or_mov_file_or_subdir(server, &me, "BLUB.TXT",
					  &me, "BLUB1.TXT") != 0) {
		printf("ren error\n");
		return;
	}
	    
}

void
test_rm(struct ncp_server *server)
{
	struct nw_info_struct sys;
	struct nw_info_struct me;
	
	if (ncp_do_lookup(server, NULL, "SYS", &sys) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_do_lookup(server, &sys, "ME", &me) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_del_file_or_subdir(server, &me, "BLUB1.TXT") != 0) {
		printf("ren error\n");
		return;
	}
	    
}

void
test_mkdir(struct ncp_server *server)
{
	struct nw_info_struct sys;
	struct nw_info_struct me;
	struct nw_file_info dir1;
	struct nw_file_info dir2;
	
	
	if (ncp_do_lookup(server, NULL, "SYS", &sys) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_do_lookup(server, &sys, "ME", &me) != 0) {
		printf("lookup error\n");
		return;
	}
	if (ncp_open_create_file_or_subdir(server, &me, "DIR1",
					   OC_MODE_CREATE, aDIR, 0xffff, &dir1)
	    != 0) {
		printf("mkdir1 error\n");
		return;
	}
	if (ncp_open_create_file_or_subdir(server, &me, "DIR2",
					   OC_MODE_CREATE, aDIR, 0xffff, &dir2)
	    != 0) {
		printf("mkdir2 error\n");
		return;
	}

	if (ncp_del_file_or_subdir(server, &me, "DIR1") != 0) {
		printf("rmdir error\n");
		return;
	}
}


void
test_print(struct ncp_server *server)
{
	struct ncp_bindery_object q;
	struct queue_job j;
	struct print_job_record pj;
	int written;

	if (ncp_get_bindery_object_id(server, NCP_BINDERY_PQUEUE,
				      "Q_DJ500", &q) != 0) {
		printf("get oid error\n");
		return;
	}

	memset(&j, 0, sizeof(j));

	j.j.TargetServerID = 0xffffffff; /* any server */
	memset(&(j.j.TargetExecTime), 0xff, sizeof(j.j.TargetExecTime)); /* at once */
	j.j.JobType = 0xffff;
	strcpy(j.j.JobTextDescription, "Test Job");

	memset(&pj, 0, sizeof(pj));

	pj.Version = 0;
	pj.TabSize = 0;
	pj.Copies = 1;
	pj.CtrlFlags = 0;
	pj.Lines = 0;
	pj.Rows = 0;
	strcpy(pj.FormName, "");
	strcpy(pj.Banner, "");
	strcpy(pj.FnameBanner, "");
	strcpy(pj.FnameHeader, "");
	strcpy(pj.Path, "");

	memcpy(j.j.ClientRecordArea, &pj, sizeof(pj));

	if (ncp_create_queue_job_and_file(server, q.object_id, &j) != 0) {
		printf("create error\n");
		return;
	}

	if (ncp_write(server, j.file_handle, 0, 5, "hallo", &written) != 0) {
		printf("write error\n");
		return;
	}

	if (ncp_close_file_and_start_job(server, q.object_id, &j) != 0) {
		printf("close error\n");
		return;
	}			

	return;
}

	
	       

int
main(int argc, char **argv)
{
        struct stat st;
	struct ncp_server serv;
	struct ncp_server *server = &serv;
	

	progname = argv[0];

        if (geteuid() != 0) {
                fprintf(stderr, "%s must be installed suid root\n", progname);
                exit(1);
        }

	if (argc == 2) {
		mount_point = argv[1];
	} else {
		fprintf(stderr, "usage: %s mount-point\n", progname);
		printf("defaulting to %s mnt\n", progname);
		mount_point = "mnt";
	}
	

	if (stat(mount_point, &st) == -1) {
                fprintf(stderr, "could not find mount point %s: %s\n",
                        mount_point, strerror(errno));
                exit(1);
        }

	server->mount_fid = open(mount_point, O_RDONLY, 0);
	server->silent = 0;

	if (server->mount_fid == -1) {
		fprintf(stderr, "Could not open %s: %s\n",
			mount_point, strerror(errno));
		return -1;
	}

#if 0
	for (i=0; i<5; i++) {
		struct ncp_volume_info info;
		ncp_get_volume_info_with_number(server, i, &info);
		printf("vol %d: %s\n", i, info.volume_name);
	}

	test_filesearch(server);
	test_getfinfo(server);
	test_mkdir(server);
	test_ls(server);

#endif
	test_trunc(server);

	return 0;
}

