
/*

    IPX support library

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef __IPXUTIL_H__

#define __IPXUTIL_H__

#include <string.h>
#include <linux/ipx.h>

#define IPX_SAP_PTYPE (0x04)
#define IPX_SAP_PORT  (0x0452)

#define IPX_SAP_FILE_SERVER (0x004)

#define IPX_BROADCAST_NODE "\xff\xff\xff\xff\xff\xff"
#define IPX_THIS_NODE      "\0\0\0\0\0\0"


typedef unsigned long  IPXNet;
typedef unsigned short IPXPort;
typedef unsigned char  IPXNode[IPX_NODE_LEN];

void ipx_print_node(IPXNode node);
void ipx_print_network(IPXNet net);
void ipx_print_port(IPXPort port);
void ipx_print_saddr(struct sockaddr_ipx* sipx);

static __inline__ void
ipx_assign_node(IPXNode dest, IPXNode src) {
	memcpy(dest, src, IPX_NODE_LEN);
}

#endif
