/*
 *  ncpmount.c
 *
 *  Copyright (C) 1995 by Volker Lendecke
 *
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ioctl.h>
/* #include <sys/wait.h> */  /* generates a warning here */
extern pid_t waitpid(pid_t, int *, int);
#include <sys/errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <mntent.h>
#include <linux/ipx.h>

#include <linux/fs.h>
#include <linux/ncp.h>
#include <linux/ncp_fs.h>
#include <linux/ncp_mount.h>
#include "ncplib.h"
#include "ipxutil.h"

static char *progname;
static char *mount_point;

void
test_filesearch(struct ncp_server *server)
{
	struct ncp_filesearch_info fsinfo;
	struct ncp_file_info       finfo;

	if (ncp_file_search_init(server, 0, "sys:\\public", &fsinfo) != 0) {
		printf("could not fs init\n");
		return;
	}

	while (ncp_file_search_continue(server, &fsinfo,
					0,
					"*", &finfo) == 0) {
		printf("name: %s\n", finfo.file_name);
	}
	return;
}

void
test_getfinfo(struct ncp_server *server)
{
	struct ncp_file_info finfo;

	ncp_get_finfo(server, 0, "sys:", "public", &finfo);
	ncp_get_finfo(server, 0, "sys:login", "login.exe", &finfo);
}

void
testopen(struct ncp_server *server)
{
	struct ncp_file_info finfo;
	char buf[1025];
	int bytes_read;

	ncp_open_file(server, 0, "sys:\\etc\\samples\\protocol", 0,
		      AR_READ|AR_WRITE,
		      &finfo);
	if (ncp_read(server, finfo.file_id, 0, 1024, buf, &bytes_read) == 0) {
		printf("bytes: %d\n", bytes_read);
		buf[bytes_read]=0;
		puts(buf);
	}
	
	ncp_close_file(server, finfo.file_id);
}

void
testcreate(struct ncp_server *server)
{

	if (ncp_rename_file(server, 0, "sys:\\me\\blub.txt", 0,
			    0, "sys:\\me\\blub1.txt") != 0) {
		printf("create war nix\n");
	}
	if (ncp_create_directory(server, 0, "sys:\\me\\blubdir", 0xff) != 0) {
		printf("mkdir war nix\n");
	}
	if (ncp_rename_directory(server, 0, "sys:\\me\\blubdir",
				 "\\me\\blubneu") != 0) {
		printf("mvdir war nix\n");
		return;
	}
	if (ncp_delete_directory(server, 0, "sys:\\me\\blubneu") != 0) {
		printf("rmdir war nix\n");
		return;
	}


}

int
main(int argc, char **argv)
{
	struct ncp_mount_data data;
        struct stat st;
	struct ncp_server serv;
	struct ncp_server *server = &serv;
	

	progname = argv[0];

        if (geteuid() != 0) {
                fprintf(stderr, "%s must be installed suid root\n", progname);
                exit(1);
        }

	memset(&data, 0, sizeof(struct ncp_mount_data));

	if (argc == 2) {
		mount_point = argv[1];
	} else {
		fprintf(stderr, "usage: %s mount-point\n", progname);
		printf("defaulting to %s mnt\n", progname);
		mount_point = "mnt";
	}
	

	if (stat(mount_point, &st) == -1) {
                fprintf(stderr, "could not find mount point %s: %s\n",
                        mount_point, strerror(errno));
                exit(1);
        }

	server->mount_fid = open(mount_point, O_RDONLY, 0);

	if (server->mount_fid == -1) {
		fprintf(stderr, "Could not open %s: %s\n",
			mount_point, strerror(errno));
		return -1;
	}

#if 0
	for (i=0; i<5; i++) {
		struct ncp_volume_info info;
		ncp_get_volume_info_with_number(server, i, &info);
		printf("vol %d: %s\n", i, info.volume_name);
	}

	test_filesearch(server);
	test_getfinfo(server);


#endif

	testcreate(server);

	return 0;
}

