#ifndef _NCPLIB_H
#define _NCPLIB_H

#ifdef __KERNEL__

#include <linux/config.h>
#ifdef MODULE
#include <linux/module.h>
#include <linux/version.h>
#endif


#include <linux/fs.h>
#include <linux/ncp.h>
#include <linux/ncp_fs.h>
#include <linux/ncp_fs_sb.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/malloc.h>
#include <linux/stat.h>
#include <linux/fcntl.h>
#include <asm/segment.h>
#include <asm/string.h>

#else

#include <linux/types.h>
#include <linux/ncp.h>
#include <linux/ncp_fs.h>

struct ncp_server {
	int current_size;
	int has_subfunction;
	int mount_fid;
	int ncp_reply_size;
	char *packet;
	int lock;

	char ncp_data[NCP_PACKET_SIZE];
};

#endif __KERNEL__

#include <linux/ncp.h>

int
ncp_negotiate_buffersize(struct ncp_server *server, int size,
			 int *target);
int
ncp_get_encryption_key(struct ncp_server *server,
		       char *target);
int
ncp_get_bindery_object_id(struct ncp_server *server,
			  int object_type, char *object_name,
			  struct ncp_bindery_object *target);
int
ncp_login_encrypted(struct ncp_server *server,
		    struct ncp_bindery_object *object,
		    unsigned char *key,
		    unsigned char *passwd);
int
ncp_login_user(struct ncp_server *server,
	       unsigned char *username,
	       unsigned char *password);
int
ncp_get_volume_info_with_number(struct ncp_server *server, int n,
				struct ncp_volume_info *target);

int
ncp_get_volume_number(struct ncp_server *server, const char *name,
		      int *target);

int
ncp_file_search_init(struct ncp_server *server,
		     int dir_handle, const char *path,
		     struct ncp_filesearch_info *target);

int
ncp_file_search_continue(struct ncp_server *server,
			 struct ncp_filesearch_info *fsinfo,
			 int attributes, const char *path,
			 struct ncp_file_info *target);

int
ncp_get_finfo(struct ncp_server *server,
	      int dir_handle, const char *path, const char *name,
	      struct ncp_file_info *target);

int
ncp_open_file(struct ncp_server *server,
	      int dir_handle, const char *path,
	      int attr, int access,
	      struct ncp_file_info *target);
int
ncp_close_file(struct ncp_server *server, const char *file_id);

int
ncp_create_newfile(struct ncp_server *server,
		   int dir_handle, const char *path,
		   int attr,
		   struct ncp_file_info *target);

int
ncp_create_file(struct ncp_server *server,
		int dir_handle, const char *path,
		int attr,
		struct ncp_file_info *target);

int
ncp_erase_file(struct ncp_server *server,
	       int dir_handle, const char *path,
	       int attr);

int
ncp_rename_file(struct ncp_server *server,
		int old_handle, const char *old_path,
		int attr,
		int new_handle, const char *new_path);

int
ncp_create_directory(struct ncp_server *server,
		     int dir_handle, const char *path,
		     int inherit_mask);

int
ncp_delete_directory(struct ncp_server *server,
		     int dir_handle, const char *path);

int
ncp_rename_directory(struct ncp_server *server,
		     int dir_handle,
		     const char *old_path, const char *new_path);

int
ncp_read(struct ncp_server *server, const char *file_id,
	 __u32 offset, __u16 to_read,
	 char *target, int *bytes_read);

int
ncp_write(struct ncp_server *server, const char *file_id,
	  __u32 offset, __u16 to_write,
	  const char *source, int *bytes_written);

#endif /* _NCPLIB_H */
