/*
 *  ncp_fs_i.h
 *
 *  Copyright (C) 1995 by Paal-Kr. Engstad and Volker Lendecke
 *
 */

#ifndef _LINUX_NCP_FS_I
#define _LINUX_NCP_FS_I

#include <linux/ncp.h>

#ifdef __KERNEL__

/*
 * Contains all relevant data on a NCP networked file.
 */
struct ncp_dirent {
        int         opened;	/* is it open on the fileserver? */
	__u8        file_id[NCP_FILE_ID_LEN];
	__u32       attr;	/* Attribute fields, NCP value. Either
				   only lower 8 bits used or upper
				   bits contain extended attributs */
	__u32       size;	/* File size. */

        time_t      atime,      /* Times, as seen by the server, normalized */
                    mtime,      /* to UTC. The ugly conversion happens in */
                    ctime;      /* proc.c */

	__u16       access;	/* Access bits. */
	__u16       next_search; /* Next search index, for proc_readdir */
	unsigned long f_pos;	/* for ncp_readdir */

	char       *path;	/* Complete path, MS-DOS notation, with '\' */
	int         len;	/* Namelength. */
};


enum ncp_inode_state {
        INODE_VALID = 19,       /* Inode currently in use */
        INODE_LOOKED_UP,        /* directly before iget */
        INODE_CACHED,           /* in a path to an inode which is in use */
        INODE_INVALID
};

/*
 * ncp fs inode data (in memory only)
 */
struct ncp_inode_info {
        enum ncp_inode_state state;
        int nused;              /* for directories:
                                   number of references in memory */
        struct ncp_inode_info *dir;
        struct ncp_inode_info *next, *prev;
        struct ncp_dirent finfo;
};

#endif
#endif
