/*
 *  ncp_fs.h
 *
 *  Copyright (C) 1995 by Volker Lendecke
 *
 */

#ifndef _LINUX_NCP_H
#define _LINUX_NCP_H

#include <linux/types.h>

#define NCP_PTYPE                (0x17)
#define NCP_PORT                 (0x0451)

#define NCP_ALLOC_SLOT_REQUEST   (0x1111)
#define NCP_REQUEST              (0x2222)
#define NCP_DEALLOC_SLOT_REQUEST (0x5555)

struct ncp_request_header {
	__u16   type      __attribute__ ((packed));
	__u8    sequence  __attribute__ ((packed));
	__u8    conn_low  __attribute__ ((packed));
	__u8    task      __attribute__ ((packed));
	__u8    conn_high __attribute__ ((packed));
	__u8    function  __attribute__ ((packed));
	__u8    data[0]   __attribute__ ((packed));
};

#define NCP_REPLY                (0x3333)
#define NCP_POSITIVE_ACK         (0x9999)

struct ncp_reply_header {
	__u16   type             __attribute__ ((packed));
	__u8    sequence         __attribute__ ((packed));
	__u8    conn_low         __attribute__ ((packed));
	__u8    task             __attribute__ ((packed));
	__u8    conn_high        __attribute__ ((packed));
	__u8    completion_code  __attribute__ ((packed));
	__u8    connection_state __attribute__ ((packed));
	__u8    data[0]          __attribute__ ((packed));
};


#define NCP_BINDERY_USER (0x0001)
#define NCP_BINDERY_NAME_LEN (48)
struct ncp_bindery_object {
	__u32   object_id;
	__u16   object_type;
	__u8    object_name[NCP_BINDERY_NAME_LEN];
};


#define NCP_VOLNAME_LEN (16)
#define NCP_NUMBER_OF_VOLUMES (64)
struct ncp_volume_info {
	__u32   total_blocks;
	__u32   free_blocks;
	__u32   purgeable_blocks;
	__u32   not_yet_purgeable_blocks;
	__u32   total_dir_entries;
	__u32   available_dir_entries;
	__u8    sectors_per_block;
	char    volume_name[NCP_VOLNAME_LEN+1];
};

struct ncp_filesearch_info {
	__u8    volume_number;
	__u16   directory_id;
	__u16   sequence_no;
	__u8    access_rights;
};

#define NCP_MAX_FILENAME 14

/* these define the attribute byte as seen by NCP */
#define aRONLY     (1L<<0)
#define aHIDDEN    (1L<<1)
#define aSYSTEM    (1L<<2)
#define aEXECUTE   (1L<<3)
#define aDIR       (1L<<4)
#define aARCH      (1L<<5)

#define AR_READ      (0x01)
#define AR_WRITE     (0x02)
#define AR_EXCLUSIVE (0x20)

#define NCP_FILE_ID_LEN 6
struct ncp_file_info {
	__u8    file_id[NCP_FILE_ID_LEN];
        char    file_name[NCP_MAX_FILENAME+1];
	__u8    file_attributes;
	__u8    file_mode;
	__u32   file_length;
	__u16   creation_date;
	__u16   access_date;
	__u16   update_date;
	__u16   update_time;
};

#endif /* _LINUX_NCP_H */
