/*
 *  ncptest.c
 *
 *  Copyright (C) 1995 by Volker Lendecke
 *
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ioctl.h>
/* #include <sys/wait.h> */  /* generates a warning here */
extern pid_t waitpid(pid_t, int *, int);
#include <sys/errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <mntent.h>
#include <linux/ipx.h>

#include <linux/fs.h>
#include <linux/ncp.h>
#include <linux/ncp_fs.h>
#include <linux/ncp_mount.h>
#include "ncplib.h"


void
test_print(struct ncp_conn *conn)
{
	struct ncp_bindery_object q;
	struct queue_job j;
	struct print_job_record pj;
	int written;

	if (ncp_get_bindery_object_id(conn, NCP_BINDERY_PQUEUE,
				      "Q_DJ500", &q) != 0) {
		printf("get oid error\n");
		return;
	}

	memset(&j, 0, sizeof(j));

	j.j.TargetServerID = 0xffffffff; /* any server */
	/* at once */
	memset(&(j.j.TargetExecTime), 0xff, sizeof(j.j.TargetExecTime));
	j.j.JobType = htons(0);
	strcpy(j.j.JobTextDescription, "Test Job");

	memset(&pj, 0, sizeof(pj));

	pj.Version = 0;
	pj.TabSize = 8;
	pj.Copies = htons(1);
	pj.CtrlFlags = 0;
	pj.Lines = htons(66);
	pj.Rows = htons(80);
	strcpy(pj.FormName, "test");
	strcpy(pj.BannerName, "BannerName");
	strcpy(pj.FnameBanner, "BannerFile");
	strcpy(pj.FnameHeader, "HeaderName");
	strcpy(pj.Path, "");

	memcpy(j.j.ClientRecordArea, &pj, sizeof(pj));

	if (ncp_create_queue_job_and_file(conn, q.object_id, &j) != 0) {
		printf("create error\n");
		return;
	}

	if ((written = ncp_write(conn, j.file_handle, 0, 15,
				 "hallo, wie geht's?")) < 0) {
		printf("write error\n");
		return;
	}

	if (ncp_close_file_and_start_job(conn, q.object_id, &j) != 0) {
		printf("close error\n");
		return;
	}			

	return;
}

void
test_ls(struct ncp_conn *server)
{
	struct nw_info_struct sys;
	struct nw_info_struct public;
	struct ncp_search_seq seq;
	struct nw_info_struct found;
	int res;
	
	if (ncp_do_lookup(server, NULL, "SYS", &sys) != 0)
	{
		printf("lookup error\n");
		return;
	}
	if (ncp_do_lookup(server, &sys, "PUBLIC", &public) != 0)
	{
		printf("lookup public error\n");
		return;
	}
	if (ncp_initialize_search(server, &public, 4, &seq) != 0)
	{
		printf("init error\n");
		return;
	}
	while ((res=ncp_search_for_file_or_subdir(server,&seq,&found)) == 0)
	{
		printf("found %s: %s\n",
		       (found.attributes & aDIR) ? "dir " : "file",
		       found.entryName);
	}

	if (res == 0xfe)
	{
		printf("result: no more files\n");
	}
	else
	{
		printf("other error: %x\n", res);
	}
	return;
}

void
test_connlist(struct ncp_conn *conn)
{
	__u16 conn_list[256];
	int no;

	ncp_get_connlist(conn, 0, NCP_BINDERY_USER, "*", &no, conn_list);
	return;
}

int
main(int argc, char *argv[])
{
	struct ncp_conn conn;

	if (ncp_initialize(&conn, &argc, argv, 1) != 0)
	{
		perror("ncp_initialize");
		return 1;
	}

	test_connlist(&conn);
	ncp_close(&conn);
	return 0;
}
