/* connect.h 04-May-96 */
#ifndef _CONNECT_H_
#define _CONNECT_H_
typedef struct {
  DIR    *f;
  char   unixname[256]; /* kompletter unixname       */
  ino_t  inode;         /* Unix Inode                */
  time_t timestamp;     /* fr letzte Allocierung    */
  char   *kpath;        /* Ein Zeichen nach unixname */
  int    vol_options;   /* Suchoptions               */
  int    volume;        /* Volume Number	     */
} DIR_HANDLE;

typedef struct {
  uint8 path[256];      /* directory        */
  uint8 fn[256];        /* file             */
  int   volume;         /* Volume Number    */
  int   has_wild;       /* fn has wildcards */
} NW_PATH;

typedef struct {
   ino_t  inode;        /* Unix Inode dieses Verzeichnisses */
   time_t timestamp;    /* Zeitmarke          */
   uint8  *path;        /* path ab Volume     */
   uint8  volume;       /* Welches Volume     */
   uint8  is_temp;      /* 0:perm. 1:temp 2: spez. temp */
   uint8  drive;        /* driveletter        */
   uint8  task;         /* actual task        */
} NW_DIR;

typedef struct {
  uint8   name[14];              /* filename in DOS format */
  uint8   attrib;                /* Attribute  */
  uint8   ext_attrib;            /* File Execute Type */
  uint8   size[4];               /* size of file     */
  uint8   create_date[2];
  uint8   acces_date[2];
  uint8   modify_date[2];
  uint8   modify_time[2];
} NW_FILE_INFO;

typedef struct {
  uint8   name[14];              /* dirname */
  uint8   attrib;
  uint8   ext_attrib;
  uint8   create_date[2];
  uint8   create_time[2];
  uint8   owner_id[4];
  uint8   access_right_mask;
  uint8   reserved; /* future use */
  uint8   next_search[2];
} NW_DIR_INFO;


extern int nw_init_connect(void);
extern void nw_exit_connect(void);

extern int nw_free_handles(int task);

extern int nw_creat_open_file(int dir_handle, uint8 *data, int len,
                NW_FILE_INFO *info, int attrib, int access, int mode);

extern int nw_delete_datei(int dir_handle,  uint8 *data, int len);
extern int nw_set_file_information(int dir_handle, uint8 *data, int len,
                             int searchattrib, NW_FILE_INFO *f);

extern int nw_chmod_datei(int dir_handle, uint8 *data, int len, int modus);

extern int mv_file(int qdirhandle, uint8 *q, int qlen,
            int zdirhandle, uint8 *z, int zlen);

extern int mv_dir(int dir_handle, uint8 *q, int qlen,
                           uint8 *z, int zlen);

extern int nw_mk_rd_dir(int dir_handle, uint8 *data, int len, int mode);

extern int nw_search(uint8 *info,
              int dirhandle, int searchsequence,
              int search_attrib, uint8 *data, int len);

extern int nw_dir_search(uint8 *info,
              int dirhandle, int searchsequence,
              int search_attrib, uint8 *data, int len);


extern int nw_find_dir_handle( int dir_handle,
                               uint8      *data, /* zustzlicher Pfad  */
                               int         len); /* Lnge Pfad        */

extern int xinsert_new_dir(int volume, uint8 *path,
                           int inode, int drive, int is_temp, int task);

extern int nw_alloc_dir_handle(
                      int dir_handle,  /* Suche ab Pfad dirhandle   */
                      uint8  *data,       /* zustzl. Pfad             */
                      int    len,         /* Lnge DATA                */
                      int    driveletter, /* A .. Z normal             */
                      int    is_temphandle, /* temporres Handle 1     */
                                               /* spez. temp Handle  2    */
                      int    task);          /* Prozess Task            */


extern int nw_open_dir_handle( int        dir_handle,
                        uint8      *data,     /* zustzlicher Pfad  */
                        int        len,       /* Lnge DATA         */
                        int        *volume,   /* Volume             */
                        int        *dir_id,   /* hnlich Filehandle */
                        int        *searchsequence);


extern int nw_free_dir_handle(int dir_handle);

extern int nw_set_dir_handle(int targetdir, int dir_handle,
                             uint8 *data, int len, int task);

extern int nw_get_directory_path(int dir_handle, uint8 *name);

extern int nw_get_vol_number(int dir_handle);



extern int nw_get_eff_dir_rights(int dir_handle, uint8 *data, int len, int modus);

extern int nw_scan_dir_info(int dir_handle, uint8 *data, int len,
                            uint8 *subnr, uint8 *subname,
                            uint8 *subdatetime, uint8 *owner);


#define MAX_NW_DIRS    255
extern NW_DIR  dirs[MAX_NW_DIRS];
extern int     used_dirs;


extern int conn_get_kpl_path(NW_PATH *nwpath, int dirhandle,
	                  uint8 *data,   int len, int only_dir) ;

extern void set_default_guid(void);
extern void set_guid(int gid, int uid);


extern int nw_scan_a_directory(uint8   *rdata,
                        int     dirhandle,
                        uint8   *data,
                        int     len,
                        int     searchattrib,
                        uint32  searchbeg);   /* 32 bit */

extern int nw_scan_a_root_dir(uint8   *rdata,
                              int     dirhandle);


extern int fn_match(uint8 *s, uint8 *p, int options);


extern uint16 un_date_2_nw(time_t time, uint8 *d);
extern time_t nw_2_un_time(uint8 *d, uint8 *t);
extern uint16 un_time_2_nw(time_t time, uint8 *d);

extern void xun_date_2_nw(time_t time, uint8 *d);
extern void xun_time_2_nw(time_t time, uint8 *d);

#endif
