#ifndef	GNU_WINSPOOL_
#define	GNU_WINSPOOL_
#ifndef	_GNU_H_WIN32Headers
#define	_GNU_H_WIN32Headers
#include	<win.h>
#endif
#define	PRINTER_ERROR_INFORMATION	0x80000000
#define	PRINTER_ERROR_WARNING	0x40000000
#define	PRINTER_ERROR_SEVERE	0x20000000
#define	PRINTER_ERROR_OUTOFPAPER	1
#define	PRINTER_ERROR_JAM	2
#define	PRINTER_ERROR_OUTOFTONER	4
#define	PRINTER_CONTROL_PAUSE	1
#define	PRINTER_CONTROL_RESUME	2
#define	PRINTER_CONTROL_PURGE	3
#define	PRINTER_CONTROL_SET_STATUS	4
#define	PRINTER_STATUS_PAUSED	1
#define	PRINTER_STATUS_ERROR	2
#define	PRINTER_STATUS_PENDING_DELETION	4
#define	PRINTER_STATUS_PAPER_JAM	8
#define	PRINTER_STATUS_PAPER_OUT	0x10
#define	PRINTER_STATUS_MANUAL_FEED	0x20
#define	PRINTER_STATUS_PAPER_PROBLEM	0x40
#define	PRINTER_STATUS_OFFLINE	0x80
#define	PRINTER_STATUS_IO_ACTIVE	0x100
#define	PRINTER_STATUS_BUSY	0x200
#define	PRINTER_STATUS_PRINTING	0x400
#define	PRINTER_STATUS_OUTPUT_BIN_FULL	0x800
#define	PRINTER_STATUS_NOT_AVAILABLE	0x1000
#define	PRINTER_STATUS_WAITING	0x2000
#define	PRINTER_STATUS_PROCESSING	0x4000
#define	PRINTER_STATUS_INITIALIZING	0x8000
#define	PRINTER_STATUS_WARMING_UP	0x10000
#define	PRINTER_STATUS_TONER_LOW	0x20000
#define	PRINTER_STATUS_NO_TONER	0x40000
#define	PRINTER_STATUS_PAGE_PUNT	0x80000
#define	PRINTER_STATUS_USER_INTERVENTION	0x100000
#define	PRINTER_STATUS_OUT_OF_MEMORY	0x200000
#define	PRINTER_STATUS_DOOR_OPEN	0x400000
#define	PRINTER_STATUS_SERVER_UNKNOWN	0x800000
#define	PRINTER_STATUS_POWER_SAVE	0x1000000
#define	PRINTER_ATTRIBUTE_QUEUED	1
#define	PRINTER_ATTRIBUTE_DIRECT	2
#define	PRINTER_ATTRIBUTE_DEFAULT	4
#define	PRINTER_ATTRIBUTE_SHARED	8
#define	PRINTER_ATTRIBUTE_NETWORK	0x10
#define	PRINTER_ATTRIBUTE_HIDDEN	0x20
#define	PRINTER_ATTRIBUTE_LOCAL	0x40
#define	PRINTER_ATTRIBUTE_ENABLE_DEVQ	0x80
#define	PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS	0x100
#define	PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST	0x200
#define	PRINTER_ATTRIBUTE_WORK_OFFLINE	0x400
#define	PRINTER_ATTRIBUTE_ENABLE_BIDI	0x800
#define	NO_PRIORITY	0
#define	MAX_PRIORITY	99
#define	MIN_PRIORITY	1
#define	DEF_PRIORITY	1
#define	PORT_TYPE_WRITE	1
#define	PORT_TYPE_READ	2
#define	PORT_TYPE_REDIRECTED	4
#define	PORT_TYPE_NET_ATTACHED	8
#define	DI_CHANNEL	1
#define	DI_CHANNEL_WRITE	2
#define	DI_READ_SPOOL_JOB	3
#define	FORM_BUILTIN	1
#define	JOB_CONTROL_PAUSE	1
#define	JOB_CONTROL_RESUME	2
#define	JOB_CONTROL_CANCEL	3
#define	JOB_CONTROL_RESTART	4
#define	JOB_CONTROL_DELETE	5
#define	JOB_STATUS_PAUSED	1
#define	JOB_STATUS_ERROR	2
#define	JOB_STATUS_DELETING	4
#define	JOB_STATUS_SPOOLING	8
#define	JOB_STATUS_PRINTING	16
#define	JOB_STATUS_OFFLINE	32
#define	JOB_STATUS_PAPEROUT	0x40
#define	JOB_STATUS_PRINTED	0x80
#define	JOB_STATUS_DELETED	0x100
#define	JOB_STATUS_BLOCKED_DEVQ	0x200
#define	JOB_STATUS_USER_INTERVENTION	0x400
#define	JOB_POSITION_UNSPECIFIED	0
#define	PRINTER_ENUM_DEFAULT	1
#define	PRINTER_ENUM_LOCAL	2
#define	PRINTER_ENUM_CONNECTIONS	4
#define	PRINTER_ENUM_FAVORITE	4
#define	PRINTER_ENUM_NAME	8
#define	PRINTER_ENUM_REMOTE	16
#define	PRINTER_ENUM_SHARED	32
#define	PRINTER_ENUM_NETWORK	0x40
#define	PRINTER_ENUM_EXPAND	0x4000
#define	PRINTER_ENUM_CONTAINER	0x8000
#define	PRINTER_ENUM_ICONMASK	0xff0000
#define	PRINTER_ENUM_ICON1	0x10000
#define	PRINTER_ENUM_ICON2	0x20000
#define	PRINTER_ENUM_ICON3	0x40000
#define	PRINTER_ENUM_ICON4	0x80000
#define	PRINTER_ENUM_ICON5	0x100000
#define	PRINTER_ENUM_ICON6	0x200000
#define	PRINTER_ENUM_ICON7	0x400000
#define	PRINTER_ENUM_ICON8	0x800000
#define	PRINTER_NOTIFY_TYPE	0
#define	JOB_NOTIFY_TYPE	1
#define	PRINTER_NOTIFY_FIELD_SERVER_NAME	0
#define	PRINTER_NOTIFY_FIELD_PRINTER_NAME	1
#define	PRINTER_NOTIFY_FIELD_SHARE_NAME	2
#define	PRINTER_NOTIFY_FIELD_PORT_NAME	3
#define	PRINTER_NOTIFY_FIELD_DRIVER_NAME	4
#define	PRINTER_NOTIFY_FIELD_COMMENT	5
#define	PRINTER_NOTIFY_FIELD_LOCATION	6
#define	PRINTER_NOTIFY_FIELD_DEVMODE	7
#define	PRINTER_NOTIFY_FIELD_SEPFILE	8
#define	PRINTER_NOTIFY_FIELD_PRINT_PROCESSOR	9
#define	PRINTER_NOTIFY_FIELD_PARAMETERS	10
#define	PRINTER_NOTIFY_FIELD_DATATYPE	11
#define	PRINTER_NOTIFY_FIELD_SECURITY_DESCRIPTOR	12
#define	PRINTER_NOTIFY_FIELD_ATTRIBUTES	13
#define	PRINTER_NOTIFY_FIELD_PRIORITY	14
#define	PRINTER_NOTIFY_FIELD_DEFAULT_PRIORITY	15
#define	PRINTER_NOTIFY_FIELD_START_TIME	16
#define	PRINTER_NOTIFY_FIELD_UNTIL_TIME	17
#define	PRINTER_NOTIFY_FIELD_STATUS	18
#define	PRINTER_NOTIFY_FIELD_STATUS_STRING	19
#define	PRINTER_NOTIFY_FIELD_CJOBS	20
#define	PRINTER_NOTIFY_FIELD_AVERAGE_PPM	21
#define	PRINTER_NOTIFY_FIELD_TOTAL_PAGES	22
#define	PRINTER_NOTIFY_FIELD_PAGES_PRINTED	23
#define	PRINTER_NOTIFY_FIELD_TOTAL_BYTES	24
#define	PRINTER_NOTIFY_FIELD_BYTES_PRINTED	25
#define	JOB_NOTIFY_FIELD_PRINTER_NAME	0
#define	JOB_NOTIFY_FIELD_MACHINE_NAME	1
#define	JOB_NOTIFY_FIELD_PORT_NAME	2
#define	JOB_NOTIFY_FIELD_USER_NAME	3
#define	JOB_NOTIFY_FIELD_NOTIFY_NAME	4
#define	JOB_NOTIFY_FIELD_DATATYPE	5
#define	JOB_NOTIFY_FIELD_PRINT_PROCESSOR	6
#define	JOB_NOTIFY_FIELD_PARAMETERS	7
#define	JOB_NOTIFY_FIELD_DRIVER_NAME	8
#define	JOB_NOTIFY_FIELD_DEVMODE	9
#define	JOB_NOTIFY_FIELD_STATUS	10
#define	JOB_NOTIFY_FIELD_STATUS_STRING	11
#define	JOB_NOTIFY_FIELD_SECURITY_DESCRIPTOR	12
#define	JOB_NOTIFY_FIELD_DOCUMENT	13
#define	JOB_NOTIFY_FIELD_PRIORITY	14
#define	JOB_NOTIFY_FIELD_POSITION	15
#define	JOB_NOTIFY_FIELD_SUBMITTED	16
#define	JOB_NOTIFY_FIELD_START_TIME	17
#define	JOB_NOTIFY_FIELD_UNTIL_TIME	18
#define	JOB_NOTIFY_FIELD_TIME	19
#define	JOB_NOTIFY_FIELD_TOTAL_PAGES	20
#define	JOB_NOTIFY_FIELD_PAGES_PRINTED	21
#define	JOB_NOTIFY_FIELD_TOTAL_BYTES	22
#define	JOB_NOTIFY_FIELD_BYTES_PRINTED	23
#define	PRINTER_NOTIFY_OPTIONS_REFRESH	1
#define	SERVER_ACCESS_ADMINISTER	1
#define	SERVER_ACCESS_ENUMERATE	2
#define	PRINTER_ACCESS_ADMINISTER	4
#define	PRINTER_ACCESS_USE	8
#define	JOB_ACCESS_ADMINISTER	16
#define	SERVER_ALL_ACCESS	(STANDARD_RIGHTS_REQUIRED|SERVER_ACCESS_ADMINISTER|SERVER_ACCESS_ENUMERATE)
#define	SERVER_READ	(STANDARD_RIGHTS_READ|SERVER_ACCESS_ENUMERATE)
#define	SERVER_WRITE	(STANDARD_RIGHTS_WRITE|SERVER_ACCESS_ADMINISTER|SERVER_ACCESS_ENUMERATE)
#define	SERVER_EXECUTE	(STANDARD_RIGHTS_EXECUTE|SERVER_ACCESS_ENUMERATE)
#define	PRINTER_ALL_ACCESS	(STANDARD_RIGHTS_REQUIRED|PRINTER_ACCESS_ADMINISTER|PRINTER_ACCESS_USE)
#define	PRINTER_READ	(STANDARD_RIGHTS_READ|PRINTER_ACCESS_USE)
#define	PRINTER_WRITE	(STANDARD_RIGHTS_WRITE|PRINTER_ACCESS_USE)
#define	PRINTER_EXECUTE	(STANDARD_RIGHTS_EXECUTE|PRINTER_ACCESS_USE)
#define	JOB_ALL_ACCESS	(STANDARD_RIGHTS_REQUIRED|JOB_ACCESS_ADMINISTER)
#define	JOB_READ	(STANDARD_RIGHTS_READ|	JOB_ACCESS_ADMINISTER)
#define	JOB_WRITE	(STANDARD_RIGHTS_WRITE|JOB_ACCESS_ADMINISTER)
#define	JOB_EXECUTE	(STANDARD_RIGHTS_EXECUTE|JOB_ACCESS_ADMINISTER)
#define	PRINTER_CHANGE_ADD_PRINTER	1
#define	PRINTER_CHANGE_SET_PRINTER	2
#define	PRINTER_CHANGE_DELETE_PRINTER	4
#define	PRINTER_CHANGE_FAILED_CONNECTION_PRINTER	8
#define	PRINTER_CHANGE_PRINTER	0xFF
#define	PRINTER_CHANGE_ADD_JOB	0x100
#define	PRINTER_CHANGE_SET_JOB	0x200
#define	PRINTER_CHANGE_DELETE_JOB	0x400
#define	PRINTER_CHANGE_WRITE_JOB	0x800
#define	PRINTER_CHANGE_JOB	0xFF00
#define	PRINTER_CHANGE_ADD_FORM	0x10000
#define	PRINTER_CHANGE_SET_FORM	0x20000
#define	PRINTER_CHANGE_DELETE_FORM	0x40000
#define	PRINTER_CHANGE_FORM	0x70000
#define	PRINTER_CHANGE_ADD_PORT	0x100000
#define	PRINTER_CHANGE_CONFIGURE_PORT	0x200000
#define	PRINTER_CHANGE_DELETE_PORT	0x400000
#define	PRINTER_CHANGE_PORT	0x700000
#define	PRINTER_CHANGE_ADD_PRINT_PROCESSOR	0x1000000
#define	PRINTER_CHANGE_DELETE_PRINT_PROCESSOR	0x4000000
#define	PRINTER_CHANGE_PRINT_PROCESSOR	0x7000000
#define	PRINTER_CHANGE_ADD_PRINTER_DRIVER	0x10000000
#define	PRINTER_CHANGE_SET_PRINTER_DRIVER	0x20000000
#define	PRINTER_CHANGE_DELETE_PRINTER_DRIVER	0x40000000
#define	PRINTER_CHANGE_PRINTER_DRIVER	0x70000000
#define	PRINTER_CHANGE_TIMEOUT	0x80000000
#define	PRINTER_CHANGE_ALL	0x7777FFFF
#define	PRINTER_NOTIFY_INFO_DISCARDED	1
#ifdef	UNICODE
#define	ResetPrinter	ResetPrinterW
#define	OpenPrinter	OpenPrinterW
#define	SetJob	SetJobW
#define	GetJob	GetJobW
#define	AddPrinter	AddPrinterW
#define	GetPrinter	GetPrinterW
#define	SetPrinter	SetPrinterW
#define	AddPrinterDriver	AddPrinterDriverW
#define	EnumJobs	EnumJobsW
#define	DeletePrinterDriver	DeletePrinterDriverW
#define	AddPrintProcessor	AddPrintProcessorW
#define	EnumPrintProcessors	EnumPrintProcessorsW
#define	GetPrintProcessorDirectory	GetPrintProcessorDirectoryW
#define	GetPrinterDriver	GetPrinterDriverW
#define	EnumPrintProcessorDatatypes	EnumPrintProcessorDatatypesW
#define	EnumJobs	EnumJobsA
#define	DeletePrintProcessor	DeletePrintProcessorW
#define	EnumPrinterDrivers	EnumPrinterDriversW
#define	StartDocPrinter	StartDocPrinterW
#define	AddJob	AddJobW
#define	GetPrinterDriverDirectory	GetPrinterDriverDirectoryW
#define	DocumentProperties	DocumentPropertiesW
#define	AdvancedDocumentProperties	AdvancedDocumentPropertiesW
#define	GetPrinterData	GetPrinterDataW
#define	SetPrinterData	SetPrinterDataW
#define	EnumPrinters	EnumPrintersW
#define	DeletePrinterConnection	DeletePrinterConnectionW
#define	DeletePort	DeletePortW
#define	AddPrintProvidor	AddPrintProvidorW
#define	DeletePrintProvidor	DeletePrintProvidorW
#define	DeleteMonitor	DeleteMonitorW
#define	EnumPorts	EnumPortsW
#define	AddPort	AddPortW
#define	ConfigurePort	ConfigurePortW
#define	AddPrinterConnection	AddPrinterConnectionW
#define	DeleteForm	DeleteFormW
#define	SetForm	SetFormW
#define	EnumForms	EnumFormsW
#define	EnumMonitors	EnumMonitorsW
#define	AddMonitor	AddMonitorW
#define	GetForm	GetFormW
#define	PrinterMessageBox	PrinterMessageBoxW
#define	AddForm	AddFormW
#else
#define	OpenPrinter	OpenPrinterA
#define	ResetPrinter	ResetPrinterA
#define	SetJob	SetJobA
#define	GetJob	GetJobA
#define	AddPrinter	AddPrinterA
#define	SetPrinter	SetPrinterA
#define	GetPrinter	GetPrinterA
#define	AddPrinterDriver	AddPrinterDriverA
#define	DeletePrinterDriver	DeletePrinterDriverA
#define	AddPrintProcessor	AddPrintProcessorA
#define	EnumPrintProcessors	EnumPrintProcessorsA
#define	GetPrinterDriver	GetPrinterDriverA
#define	GetPrintProcessorDirectory	GetPrintProcessorDirectoryA
#define	DocumentProperties	DocumentPropertiesA
#define	GetPrinterDriverDirectory	GetPrinterDriverDirectoryA
#define	EnumPrintProcessorDatatypes	EnumPrintProcessorDatatypesA
#define	EnumPrinterDrivers	EnumPrinterDriversA
#define	DeletePrintProcessor	DeletePrintProcessorA
#define	StartDocPrinter	StartDocPrinterA
#define	AddJob	AddJobA
#define	AdvancedDocumentProperties	AdvancedDocumentPropertiesA
#define	GetPrinterData	GetPrinterDataA
#define	SetPrinterData	SetPrinterDataA
#define	EnumPrinters	EnumPrintersA
#define	DeletePrinterConnection	DeletePrinterConnectionA
#define	DeletePort	DeletePortA
#define	AddPrintProvidor	AddPrintProvidorA
#define	DeletePrintProvidor	DeletePrintProvidorA
#define	AddPrinterConnection	AddPrinterConnectionA
#define	ConfigurePort	ConfigurePortA
#define	AddPort	AddPortA
#define	EnumPorts	EnumPortsA
#define	DeleteMonitor	DeleteMonitorA
#define	DeleteForm	DeleteFormA
#define	SetForm	SetFormA
#define	EnumForms	EnumFormsA
#define	EnumMonitors	EnumMonitorsA
#define	AddMonitor	AddMonitorA
#define	GetForm	GetFormA
#define	PrinterMessageBox	PrinterMessageBoxA
#define	AddForm	AddFormA
#endif	//	!UNICODE
typedef	struct	_PRINTER_INFO_1A	{
	DWORD	Flags;
	LPSTR	pDescription;
	LPSTR	pName;
	LPSTR	pComment;
}	PRINTER_INFO_1A,*PPRINTER_INFO_1A,*LPPRINTER_INFO_1A;
typedef	struct	_PRINTER_INFO_1W	{
	DWORD	Flags;
	LPWSTR	pDescription;
	LPWSTR	pName;
	LPWSTR	pComment;
}	PRINTER_INFO_1W,*PPRINTER_INFO_1W,*LPPRINTER_INFO_1W;
typedef	struct	_PRINTER_INFO_2A	{
	LPSTR	pServerName;
	LPSTR	pPrinterName;
	LPSTR	pShareName;
	LPSTR	pPortName;
	LPSTR	pDriverName;
	LPSTR	pComment;
	LPSTR	pLocation;
	LPDEVMODE	pDevMode;
	LPSTR	pSepFile;
	LPSTR	pPrintProcessor;
	LPSTR	pDatatype;
	LPSTR	pParameters;
	PSECURITY_DESCRIPTOR	pSecurityDescriptor;
	DWORD	Attributes;
	DWORD	Priority;
	DWORD	DefaultPriority;
	DWORD	StartTime;
	DWORD	UntilTime;
	DWORD	Status;
	DWORD	cJobs;
	DWORD	AveragePPM;
}	PRINTER_INFO_2A,*PPRINTER_INFO_2A,*LPPRINTER_INFO_2A;
typedef	struct	_PRINTER_INFO_2W	{
	LPWSTR	pServerName;
	LPWSTR	pPrinterName;
	LPWSTR	pShareName;
	LPWSTR	pPortName;
	LPWSTR	pDriverName;
	LPWSTR	pComment;
	LPWSTR	pLocation;
	LPDEVMODE	pDevMode;
	LPWSTR	pSepFile;
	LPWSTR	pPrintProcessor;
	LPWSTR	pDatatype;
	LPWSTR	pParameters;
	PSECURITY_DESCRIPTOR	pSecurityDescriptor;
	DWORD	Attributes;
	DWORD	Priority;
	DWORD	DefaultPriority;
	DWORD	StartTime;
	DWORD	UntilTime;
	DWORD	Status;
	DWORD	cJobs;
	DWORD	AveragePPM;
}	PRINTER_INFO_2W,*PPRINTER_INFO_2W,*LPPRINTER_INFO_2W;
typedef	struct	_PRINTER_INFO_3	{
	PSECURITY_DESCRIPTOR	pSecurityDescriptor;
}	PRINTER_INFO_3,*PPRINTER_INFO_3,*LPPRINTER_INFO_3;
typedef	struct	_PRINTER_INFO_4A	{
	LPSTR	pPrinterName;
	LPSTR	pServerName;
	DWORD	Attributes;
}	PRINTER_INFO_4A,*PPRINTER_INFO_4A,*LPPRINTER_INFO_4A;
typedef	struct	_PRINTER_INFO_4W	{
	LPWSTR	pPrinterName;
	LPWSTR	pServerName;
	DWORD	Attributes;
}	PRINTER_INFO_4W,*PPRINTER_INFO_4W,*LPPRINTER_INFO_4W;
typedef	struct	_PRINTER_INFO_5A	{
	LPSTR	pPrinterName;
	LPSTR	pPortName;
	DWORD	Attributes;
	DWORD	DeviceNotSelectedTimeout;
	DWORD	TransmissionRetryTimeout;
}	PRINTER_INFO_5A,*PPRINTER_INFO_5A,*LPPRINTER_INFO_5A;
typedef	struct	_PRINTER_INFO_5W	{
	LPWSTR	pPrinterName;
	LPWSTR	pPortName;
	DWORD	Attributes;
	DWORD	DeviceNotSelectedTimeout;
	DWORD	TransmissionRetryTimeout;
}	PRINTER_INFO_5W,*PPRINTER_INFO_5W,*LPPRINTER_INFO_5W;
typedef	struct	_JOB_INFO_1A	{
	DWORD	JobId;
	LPSTR	pPrinterName;
	LPSTR	pMachineName;
	LPSTR	pUserName;
	LPSTR	pDocument;
	LPSTR	pDatatype;
	LPSTR	pStatus;
	DWORD	Status;
	DWORD	Priority;
	DWORD	Position;
	DWORD	TotalPages;
	DWORD	PagesPrinted;
	SYSTEMTIME	Submitted;
}	JOB_INFO_1A,*PJOB_INFO_1A,*LPJOB_INFO_1A;
typedef	struct	_JOB_INFO_1W	{
	DWORD	JobId;
	LPWSTR	pPrinterName;
	LPWSTR	pMachineName;
	LPWSTR	pUserName;
	LPWSTR	pDocument;
	LPWSTR	pDatatype;
	LPWSTR	pStatus;
	DWORD	Status;
	DWORD	Priority;
	DWORD	Position;
	DWORD	TotalPages;
	DWORD	PagesPrinted;
	SYSTEMTIME	Submitted;
}	JOB_INFO_1W,*PJOB_INFO_1W,*LPJOB_INFO_1W;
typedef	struct	_JOB_INFO_2A	{
	DWORD	JobId;
	LPSTR	pPrinterName;
	LPSTR	pMachineName;
	LPSTR	pUserName;
	LPSTR	pDocument;
	LPSTR	pNotifyName;
	LPSTR	pDatatype;
	LPSTR	pPrintProcessor;
	LPSTR	pParameters;
	LPSTR	pDriverName;
	LPDEVMODE	pDevMode;
	LPSTR	pStatus;
	PSECURITY_DESCRIPTOR	pSecurityDescriptor;
	DWORD	Status;
	DWORD	Priority;
	DWORD	Position;
	DWORD	StartTime;
	DWORD	UntilTime;
	DWORD	TotalPages;
	DWORD	Size;
	SYSTEMTIME	Submitted;
	DWORD	Time;
	DWORD	PagesPrinted;
}	JOB_INFO_2A,*PJOB_INFO_2A,*LPJOB_INFO_2A;
typedef	struct	_JOB_INFO_2W	{
	DWORD	JobId;
	LPWSTR	pPrinterName;
	LPWSTR	pMachineName;
	LPWSTR	pUserName;
	LPWSTR	pDocument;
	LPWSTR	pNotifyName;
	LPWSTR	pDatatype;
	LPWSTR	pPrintProcessor;
	LPWSTR	pParameters;
	LPWSTR	pDriverName;
	LPDEVMODE	pDevMode;
	LPWSTR	pStatus;
	PSECURITY_DESCRIPTOR	pSecurityDescriptor;
	DWORD	Status;
	DWORD	Priority;
	DWORD	Position;
	DWORD	StartTime;
	DWORD	UntilTime;
	DWORD	TotalPages;
	DWORD	Size;
	SYSTEMTIME	Submitted;
	DWORD	Time;
	DWORD	PagesPrinted;
}	JOB_INFO_2W,*PJOB_INFO_2W,*LPJOB_INFO_2W;
typedef	struct	_ADDJOB_INFO_1A	{
	LPSTR	Path;
	DWORD	JobId;
}	ADDJOB_INFO_1A,*PADDJOB_INFO_1A,*LPADDJOB_INFO_1A;
typedef	struct	_ADDJOB_INFO_1W	{
	LPWSTR	Path;
	DWORD	JobId;
}	ADDJOB_INFO_1W,*PADDJOB_INFO_1W,*LPADDJOB_INFO_1W;
typedef	struct	_DRIVER_INFO_1A	{
	LPSTR	pName;
}	DRIVER_INFO_1A,*PDRIVER_INFO_1A,*LPDRIVER_INFO_1A;
typedef	struct	_DRIVER_INFO_1W	{
	LPWSTR	pName;
}	DRIVER_INFO_1W,*PDRIVER_INFO_1W,*LPDRIVER_INFO_1W;
typedef	struct	_DRIVER_INFO_2A	{
	DWORD	cVersion;
	LPSTR	pName;
	LPSTR	pEnvironment;
	LPSTR	pDriverPath;
	LPSTR	pDataFile;
	LPSTR	pConfigFile;
}	DRIVER_INFO_2A,*PDRIVER_INFO_2A,*LPDRIVER_INFO_2A;
typedef	struct	_DRIVER_INFO_2W	{
	DWORD	cVersion;
	LPWSTR	pName;
	LPWSTR	pEnvironment;
	LPWSTR	pDriverPath;
	LPWSTR	pDataFile;
	LPWSTR	pConfigFile;
}	DRIVER_INFO_2W,*PDRIVER_INFO_2W,*LPDRIVER_INFO_2W;
typedef	struct	_DRIVER_INFO_3A	{
	DWORD	cVersion;
	LPSTR	pName;
	LPSTR	pEnvironment;
	LPSTR	pDriverPath;
	LPSTR	pDataFile;
	LPSTR	pConfigFile;
	LPSTR	pHelpFile;
	LPSTR	pDependentFiles;
	LPSTR	pMonitorName;
	LPSTR	pDefaultDataType;
}	DRIVER_INFO_3A,*PDRIVER_INFO_3A,*LPDRIVER_INFO_3A;
typedef	struct	_DRIVER_INFO_3W	{
	DWORD	cVersion;
	LPWSTR	pName;
	LPWSTR	pEnvironment;
	LPWSTR	pDriverPath;
	LPWSTR	pDataFile;
	LPWSTR	pConfigFile;
	LPWSTR	pHelpFile;
	LPWSTR	pDependentFiles;
	LPWSTR	pMonitorName;
	LPWSTR	pDefaultDataType;
}	DRIVER_INFO_3W,*PDRIVER_INFO_3W,*LPDRIVER_INFO_3W;
typedef	struct	_DOC_INFO_1A	{
	LPSTR	pDocName;
	LPSTR	pOutputFile;
	LPSTR	pDatatype;
}	DOC_INFO_1A,*PDOC_INFO_1A,*LPDOC_INFO_1A;
typedef	struct	_DOC_INFO_1W	{
	LPWSTR	pDocName;
	LPWSTR	pOutputFile;
	LPWSTR	pDatatype;
}	DOC_INFO_1W,*PDOC_INFO_1W,*LPDOC_INFO_1W;
typedef	struct	_FORM_INFO_1A	{
	DWORD	Flags;
	LPSTR	pName;
	SIZEL	Size;
	RECTL	ImageableArea;
}	FORM_INFO_1A,*PFORM_INFO_1A,*LPFORM_INFO_1A;
typedef	struct	_FORM_INFO_1W	{
	DWORD	Flags;
	LPWSTR	pName;
	SIZEL	Size;
	RECTL	ImageableArea;
}	FORM_INFO_1W,*PFORM_INFO_1W,*LPFORM_INFO_1W;
typedef	struct	_DOC_INFO_2A	{
	LPSTR	pDocName;
	LPSTR	pOutputFile;
	LPSTR	pDatatype;
	DWORD	dwMode;
	DWORD	JobId;
}	DOC_INFO_2A,*PDOC_INFO_2A,*LPDOC_INFO_2A;
typedef	struct	_DOC_INFO_2W	{
	LPWSTR	pDocName;
	LPWSTR	pOutputFile;
	LPWSTR	pDatatype;
	DWORD	dwMode;
	DWORD	JobId;
}	DOC_INFO_2W,*PDOC_INFO_2W,*LPDOC_INFO_2W;
typedef	struct	_PRINTPROCESSOR_INFO_1A	{
	LPSTR	pName;
}	PRINTPROCESSOR_INFO_1A,*PPRINTPROCESSOR_INFO_1A,*LPPRINTPROCESSOR_INFO_1A;
typedef	struct	_PRINTPROCESSOR_INFO_1W	{
	LPWSTR	pName;
}	PRINTPROCESSOR_INFO_1W,*PPRINTPROCESSOR_INFO_1W,*LPPRINTPROCESSOR_INFO_1W;
typedef	struct	_PORT_INFO_1A	{
	LPSTR	pName;
}	PORT_INFO_1A,*PPORT_INFO_1A,*LPPORT_INFO_1A;
typedef	struct	_PORT_INFO_1W	{
	LPWSTR	pName;
}	PORT_INFO_1W,*PPORT_INFO_1W,*LPPORT_INFO_1W;
typedef	struct	_PORT_INFO_2A	{
	LPSTR	pPortName;
	LPSTR	pMonitorName;
	LPSTR	pDescription;
	DWORD	fPortType;
	DWORD	Reserved;
}	PORT_INFO_2A,*PPORT_INFO_2A,*LPPORT_INFO_2A;
typedef	struct	_PORT_INFO_2W	{
	LPWSTR	pPortName;
	LPWSTR	pMonitorName;
	LPWSTR	pDescription;
	DWORD	fPortType;
	DWORD	Reserved;
}	PORT_INFO_2W,*PPORT_INFO_2W,*LPPORT_INFO_2W;
typedef	struct	_MONITOR_INFO_1A{
	LPSTR	pName;
}	MONITOR_INFO_1A,*PMONITOR_INFO_1A,*LPMONITOR_INFO_1A;
typedef	struct	_MONITOR_INFO_1W{
	LPWSTR	pName;
}	MONITOR_INFO_1W,*PMONITOR_INFO_1W,*LPMONITOR_INFO_1W;
typedef	struct	_MONITOR_INFO_2A{
	LPSTR	pName;
	LPSTR	pEnvironment;
	LPSTR	pDLLName;
}	MONITOR_INFO_2A,*PMONITOR_INFO_2A,*LPMONITOR_INFO_2A;
typedef	struct	_MONITOR_INFO_2W{
	LPWSTR	pName;
	LPWSTR	pEnvironment;
	LPWSTR	pDLLName;
}	MONITOR_INFO_2W,*PMONITOR_INFO_2W,*LPMONITOR_INFO_2W;
typedef	struct	_DATATYPES_INFO_1A{
	LPSTR	pName;
}	DATATYPES_INFO_1A,*PDATATYPES_INFO_1A,*LPDATATYPES_INFO_1A;
typedef	struct	_DATATYPES_INFO_1W{
	LPWSTR	pName;
}	DATATYPES_INFO_1W,*PDATATYPES_INFO_1W,*LPDATATYPES_INFO_1W;
typedef	struct	_PRINTER_DEFAULTSA{
	LPSTR	pDatatype;
	LPDEVMODE	pDevMode;
	ACCESS_MASK	DesiredAccess;
}	PRINTER_DEFAULTSA,*PPRINTER_DEFAULTSA,*LPPRINTER_DEFAULTSA;
typedef	struct	_PRINTER_DEFAULTSW{
	LPWSTR	pDatatype;
	LPDEVMODE	pDevMode;
	ACCESS_MASK	DesiredAccess;
}	PRINTER_DEFAULTSW,*PPRINTER_DEFAULTSW,*LPPRINTER_DEFAULTSW;
typedef	struct	_PRINTER_NOTIFY_OPTIONS_TYPE	{
	WORD	Type;
	WORD	Reserved0;
	DWORD	Reserved1;
	DWORD	Reserved2;
	DWORD	Count;
	PWORD	pFields;
}	PRINTER_NOTIFY_OPTIONS_TYPE,*PPRINTER_NOTIFY_OPTIONS_TYPE,*LPPRINTER_NOTIFY_OPTIONS_TYPE;
typedef	struct	_PRINTER_NOTIFY_OPTIONS	{
	DWORD	Version;
	DWORD	Flags;
	DWORD	Count;
	PPRINTER_NOTIFY_OPTIONS_TYPE	pTypes;
}	PRINTER_NOTIFY_OPTIONS,*PPRINTER_NOTIFY_OPTIONS,*LPPRINTER_NOTIFY_OPTIONS;
typedef	struct	_PRINTER_NOTIFY_INFO_DATA	{
	WORD	Type;
	WORD	Field;
	DWORD	Reserved;
	DWORD	Id;
	union	{
		DWORD	adwData[2];
		struct	{
			DWORD	cbBuf;
			LPVOID	pBuf;
		}	Data;
	}	NotifyData;
}	PRINTER_NOTIFY_INFO_DATA,*PPRINTER_NOTIFY_INFO_DATA,*LPPRINTER_NOTIFY_INFO_DATA;
typedef	struct	_PRINTER_NOTIFY_INFO	{
	DWORD	Version;
	DWORD	Flags;
	DWORD	Count;
	PRINTER_NOTIFY_INFO_DATA	aData[1];
}	PRINTER_NOTIFY_INFO,*PPRINTER_NOTIFY_INFO,*LPPRINTER_NOTIFY_INFO;
typedef	struct	_PROVIDOR_INFO_1A{
	LPSTR	pName;
	LPSTR	pEnvironment;
	LPSTR	pDLLName;
}	PROVIDOR_INFO_1A,*PPROVIDOR_INFO_1A,*LPPROVIDOR_INFO_1A;
typedef	struct	_PROVIDOR_INFO_1W{
	LPWSTR	pName;
	LPWSTR	pEnvironment;
	LPWSTR	pDLLName;
}	PROVIDOR_INFO_1W,*PPROVIDOR_INFO_1W,*LPPROVIDOR_INFO_1W;
#ifdef	UNICODE
typedef	PRINTER_INFO_1W	PRINTER_INFO_1;
typedef	PPRINTER_INFO_1W	PPRINTER_INFO_1;
typedef	LPPRINTER_INFO_1W	LPPRINTER_INFO_1;
typedef	PRINTER_INFO_2W	PRINTER_INFO_2;
typedef	PPRINTER_INFO_2W	PPRINTER_INFO_2;
typedef	LPPRINTER_INFO_2W	LPPRINTER_INFO_2;
typedef	PRINTER_INFO_4W	PRINTER_INFO_4;
typedef	PPRINTER_INFO_4W	PPRINTER_INFO_4;
typedef	LPPRINTER_INFO_4W	LPPRINTER_INFO_4;
typedef	PRINTER_INFO_5W	PRINTER_INFO_5;
typedef	PPRINTER_INFO_5W	PPRINTER_INFO_5;
typedef	LPPRINTER_INFO_5W	LPPRINTER_INFO_5;
typedef	JOB_INFO_1W	JOB_INFO_1;
typedef	PJOB_INFO_1W	PJOB_INFO_1;
typedef	LPJOB_INFO_1W	LPJOB_INFO_1;
typedef	DRIVER_INFO_2W	DRIVER_INFO_2;
typedef	PDRIVER_INFO_2W	PDRIVER_INFO_2;
typedef	LPDRIVER_INFO_2W	LPDRIVER_INFO_2;
typedef	DRIVER_INFO_1W	DRIVER_INFO_1;
typedef	PDRIVER_INFO_1W	PDRIVER_INFO_1;
typedef	LPDRIVER_INFO_1W	LPDRIVER_INFO_1;
typedef	ADDJOB_INFO_1W	ADDJOB_INFO_1;
typedef	PADDJOB_INFO_1W	PADDJOB_INFO_1;
typedef	LPADDJOB_INFO_1W	LPADDJOB_INFO_1;
typedef	JOB_INFO_2W	JOB_INFO_2;
typedef	PJOB_INFO_2W	PJOB_INFO_2;
typedef	LPJOB_INFO_2W	LPJOB_INFO_2;
typedef	DRIVER_INFO_3W	DRIVER_INFO_3;
typedef	PDRIVER_INFO_3W	PDRIVER_INFO_3;
typedef	LPDRIVER_INFO_3W	LPDRIVER_INFO_3;
typedef	DOC_INFO_1W	DOC_INFO_1;
typedef	PDOC_INFO_1W	PDOC_INFO_1;
typedef	LPDOC_INFO_1W	LPDOC_INFO_1;
typedef	FORM_INFO_1W	FORM_INFO_1;
typedef	PFORM_INFO_1W	PFORM_INFO_1;
typedef	LPFORM_INFO_1W	LPFORM_INFO_1;
typedef	DOC_INFO_2W	DOC_INFO_2;
typedef	PDOC_INFO_2W	PDOC_INFO_2;
typedef	LPDOC_INFO_2W	LPDOC_INFO_2;
typedef	PRINTPROCESSOR_INFO_1W	PRINTPROCESSOR_INFO_1;
typedef	PPRINTPROCESSOR_INFO_1W	PPRINTPROCESSOR_INFO_1;
typedef	LPPRINTPROCESSOR_INFO_1W	LPPRINTPROCESSOR_INFO_1;
typedef	PORT_INFO_1W	PORT_INFO_1;
typedef	PPORT_INFO_1W	PPORT_INFO_1;
typedef	LPPORT_INFO_1W	LPPORT_INFO_1;
typedef	PORT_INFO_2W	PORT_INFO_2;
typedef	PPORT_INFO_2W	PPORT_INFO_2;
typedef	LPPORT_INFO_2W	LPPORT_INFO_2;
typedef	MONITOR_INFO_1W	MONITOR_INFO_1;
typedef	PMONITOR_INFO_1W	PMONITOR_INFO_1;
typedef	LPMONITOR_INFO_1W	LPMONITOR_INFO_1;
typedef	MONITOR_INFO_2W	MONITOR_INFO_2;
typedef	PMONITOR_INFO_2W	PMONITOR_INFO_2;
typedef	LPMONITOR_INFO_2W	LPMONITOR_INFO_2;
typedef	DATATYPES_INFO_1W	DATATYPES_INFO_1;
typedef	PDATATYPES_INFO_1W	PDATATYPES_INFO_1;
typedef	LPDATATYPES_INFO_1W	LPDATATYPES_INFO_1;
typedef	PROVIDOR_INFO_1W	PROVIDOR_INFO_1;
typedef	PPROVIDOR_INFO_1W	PPROVIDOR_INFO_1;
typedef	LPPROVIDOR_INFO_1W	LPPROVIDOR_INFO_1;
typedef	PRINTER_DEFAULTSW	PRINTER_DEFAULTS;
typedef	PPRINTER_DEFAULTSW	PPRINTER_DEFAULTS;
typedef	LPPRINTER_DEFAULTSW	LPPRINTER_DEFAULTS;
#else
typedef	PRINTER_INFO_1A	PRINTER_INFO_1;
typedef	PPRINTER_INFO_1A	PPRINTER_INFO_1;
typedef	LPPRINTER_INFO_1A	LPPRINTER_INFO_1;
typedef	PRINTER_INFO_2A	PRINTER_INFO_2;
typedef	PPRINTER_INFO_2A	PPRINTER_INFO_2;
typedef	LPPRINTER_INFO_2A	LPPRINTER_INFO_2;
typedef	PRINTER_INFO_4A	PRINTER_INFO_4;
typedef	PPRINTER_INFO_4A	PPRINTER_INFO_4;
typedef	LPPRINTER_INFO_4A	LPPRINTER_INFO_4;
typedef	PRINTER_INFO_5A	PRINTER_INFO_5;
typedef	PPRINTER_INFO_5A	PPRINTER_INFO_5;
typedef	LPPRINTER_INFO_5A	LPPRINTER_INFO_5;
typedef	JOB_INFO_1A	JOB_INFO_1;
typedef	PJOB_INFO_1A	PJOB_INFO_1;
typedef	LPJOB_INFO_1A	LPJOB_INFO_1;
typedef	JOB_INFO_2A	JOB_INFO_2;
typedef	PJOB_INFO_2A	PJOB_INFO_2;
typedef	LPJOB_INFO_2A	LPJOB_INFO_2;
typedef	DRIVER_INFO_2A	DRIVER_INFO_2;
typedef	PDRIVER_INFO_2A	PDRIVER_INFO_2;
typedef	LPDRIVER_INFO_2A	LPDRIVER_INFO_2;
typedef	DRIVER_INFO_1A	DRIVER_INFO_1;
typedef	PDRIVER_INFO_1A	PDRIVER_INFO_1;
typedef	LPDRIVER_INFO_1A	LPDRIVER_INFO_1;
typedef	ADDJOB_INFO_1A	ADDJOB_INFO_1;
typedef	PADDJOB_INFO_1A	PADDJOB_INFO_1;
typedef	LPADDJOB_INFO_1A	LPADDJOB_INFO_1;
typedef	DRIVER_INFO_3A	DRIVER_INFO_3;
typedef	PDRIVER_INFO_3A	PDRIVER_INFO_3;
typedef	LPDRIVER_INFO_3A	LPDRIVER_INFO_3;
typedef	DOC_INFO_1A	DOC_INFO_1;
typedef	PDOC_INFO_1A	PDOC_INFO_1;
typedef	LPDOC_INFO_1A	LPDOC_INFO_1;
typedef	FORM_INFO_1A	FORM_INFO_1;
typedef	PFORM_INFO_1A	PFORM_INFO_1;
typedef	LPFORM_INFO_1A	LPFORM_INFO_1;
typedef	DOC_INFO_2A	DOC_INFO_2;
typedef	PDOC_INFO_2A	PDOC_INFO_2;
typedef	LPDOC_INFO_2A	LPDOC_INFO_2;
typedef	PRINTPROCESSOR_INFO_1A	PRINTPROCESSOR_INFO_1;
typedef	PPRINTPROCESSOR_INFO_1A	PPRINTPROCESSOR_INFO_1;
typedef	LPPRINTPROCESSOR_INFO_1A	LPPRINTPROCESSOR_INFO_1;
typedef	PORT_INFO_1A	PORT_INFO_1;
typedef	PPORT_INFO_1A	PPORT_INFO_1;
typedef	LPPORT_INFO_1A	LPPORT_INFO_1;
typedef	PORT_INFO_2A	PORT_INFO_2;
typedef	PPORT_INFO_2A	PPORT_INFO_2;
typedef	LPPORT_INFO_2A	LPPORT_INFO_2;
typedef	MONITOR_INFO_1A	MONITOR_INFO_1;
typedef	PMONITOR_INFO_1A	PMONITOR_INFO_1;
typedef	LPMONITOR_INFO_1A	LPMONITOR_INFO_1;
typedef	MONITOR_INFO_2A	MONITOR_INFO_2;
typedef	PMONITOR_INFO_2A	PMONITOR_INFO_2;
typedef	LPMONITOR_INFO_2A	LPMONITOR_INFO_2;
typedef	DATATYPES_INFO_1A	DATATYPES_INFO_1;
typedef	PDATATYPES_INFO_1A	PDATATYPES_INFO_1;
typedef	LPDATATYPES_INFO_1A	LPDATATYPES_INFO_1;
typedef	PROVIDOR_INFO_1A	PROVIDOR_INFO_1;
typedef	PPROVIDOR_INFO_1A	PPROVIDOR_INFO_1;
typedef	LPPROVIDOR_INFO_1A	LPPROVIDOR_INFO_1;
typedef	PRINTER_DEFAULTSA	PRINTER_DEFAULTS;
typedef	PPRINTER_DEFAULTSA	PPRINTER_DEFAULTS;
typedef	LPPRINTER_DEFAULTSA	LPPRINTER_DEFAULTS;
#endif	//	UNICODE
BOOL WINAPI EnumPrintersA(DWORD,LPSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI EnumPrintersW(DWORD,LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI OpenPrinterA(LPSTR,LPHANDLE,LPPRINTER_DEFAULTSA);
BOOL WINAPI OpenPrinterW(LPWSTR,LPHANDLE,LPPRINTER_DEFAULTSW);
BOOL WINAPI ResetPrinterA(HANDLE,LPPRINTER_DEFAULTSA);
BOOL WINAPI ResetPrinterW(HANDLE,LPPRINTER_DEFAULTSW);
BOOL WINAPI SetJobA(HANDLE,DWORD,DWORD,LPBYTE,DWORD);
BOOL WINAPI SetJobW(HANDLE,DWORD,DWORD,LPBYTE,DWORD);
BOOL WINAPI GetJobA(HANDLE,DWORD,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI GetJobW(HANDLE,DWORD,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI EnumJobsA(HANDLE,DWORD,DWORD,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI EnumJobsW(HANDLE,DWORD,DWORD,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
HANDLE WINAPI AddPrinterA(LPSTR,DWORD,LPBYTE);
HANDLE WINAPI AddPrinterW(LPWSTR,DWORD,LPBYTE);
BOOL WINAPI DeletePrinter(HANDLE);
BOOL WINAPI SetPrinterA(HANDLE,DWORD,LPBYTE,DWORD);
BOOL WINAPI SetPrinterW(HANDLE,DWORD,LPBYTE,DWORD);
BOOL WINAPI GetPrinterA(HANDLE,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI GetPrinterW(HANDLE,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI AddPrinterDriverA(LPSTR,DWORD,LPBYTE);
BOOL WINAPI AddPrinterDriverW(LPWSTR,DWORD,LPBYTE);
BOOL WINAPI EnumPrinterDriversA(LPSTR,LPSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI EnumPrinterDriversW(LPWSTR,LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI GetPrinterDriverA(HANDLE,LPSTR,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI GetPrinterDriverW(HANDLE,LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI GetPrinterDriverDirectoryA(LPSTR,LPSTR,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI GetPrinterDriverDirectoryW(LPWSTR,LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI DeletePrinterDriverA(LPSTR,LPSTR,LPSTR);
BOOL WINAPI DeletePrinterDriverW(LPWSTR,LPWSTR,LPWSTR);
BOOL WINAPI AddPrintProcessorA(LPSTR,LPSTR,LPSTR,LPSTR);
BOOL WINAPI AddPrintProcessorW(LPWSTR,LPWSTR,LPWSTR,LPWSTR);
BOOL WINAPI EnumPrintProcessorsA(LPSTR,LPSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI EnumPrintProcessorsW(LPWSTR,LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI GetPrintProcessorDirectoryA(LPSTR,LPSTR,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI GetPrintProcessorDirectoryW(LPWSTR,LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI EnumPrintProcessorDatatypesA(LPSTR,LPSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI EnumPrintProcessorDatatypesW(LPWSTR,LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI DeletePrintProcessorA(LPSTR,LPSTR,LPSTR);
BOOL WINAPI DeletePrintProcessorW(LPWSTR,LPWSTR,LPWSTR);
DWORD WINAPI StartDocPrinterA(HANDLE,DWORD,LPBYTE);
DWORD WINAPI StartDocPrinterW(HANDLE,DWORD,LPBYTE);
BOOL WINAPI StartPagePrinter(HANDLE);
BOOL WINAPI WritePrinter(HANDLE,LPVOID,DWORD,LPDWORD);
BOOL WINAPI EndPagePrinter(HANDLE);
BOOL WINAPI AbortPrinter(HANDLE);
BOOL WINAPI ReadPrinter(HANDLE,LPVOID,DWORD,LPDWORD);
BOOL WINAPI EndDocPrinter(HANDLE);
BOOL WINAPI AddJobA(HANDLE,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI AddJobW(HANDLE,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI ScheduleJob(HANDLE,DWORD);
BOOL WINAPI PrinterProperties(HWND,HANDLE);
LONG WINAPI DocumentPropertiesA(HWND,HANDLE,LPSTR,PDEVMODE,PDEVMODE,DWORD);
LONG WINAPI AdvancedDocumentPropertiesA(HWND,HANDLE,LPSTR,PDEVMODE,PDEVMODE);
LONG WINAPI AdvancedDocumentPropertiesW(HWND,HANDLE,LPWSTR,PDEVMODE,PDEVMODE);
DWORD WINAPI GetPrinterDataA(HANDLE,LPSTR,LPDWORD,LPBYTE,DWORD,LPDWORD);
DWORD WINAPI GetPrinterDataW(HANDLE,LPWSTR,LPDWORD,LPBYTE,DWORD,LPDWORD);
DWORD WINAPI SetPrinterDataA(HANDLE,LPSTR,DWORD,LPBYTE,DWORD);
DWORD WINAPI SetPrinterDataW(HANDLE,LPWSTR,DWORD,LPBYTE,DWORD);
DWORD WINAPI WaitForPrinterChange(HANDLE,DWORD);
HANDLE WINAPI FindFirstPrinterChangeNotification(HANDLE,DWORD,DWORD,LPVOID);
BOOL WINAPI FindNextPrinterChangeNotification(HANDLE,PDWORD,LPVOID,LPVOID *);
BOOL WINAPI FreePrinterNotifyInfo(PPRINTER_NOTIFY_INFO);
BOOL WINAPI FindClosePrinterChangeNotification(HANDLE);
DWORD WINAPI PrinterMessageBoxA(HANDLE,DWORD,HWND,LPSTR,LPSTR,DWORD);
DWORD WINAPI PrinterMessageBoxW(HANDLE,DWORD,HWND,LPWSTR,LPWSTR,DWORD);
BOOL WINAPI ClosePrinter(HANDLE);
BOOL WINAPI AddFormA(HANDLE,DWORD,LPBYTE);
BOOL WINAPI AddFormW(HANDLE,DWORD,LPBYTE);
BOOL WINAPI DeleteFormA(HANDLE,LPSTR);
BOOL WINAPI DeleteFormW(HANDLE,LPWSTR);
BOOL WINAPI GetFormA(HANDLE,LPSTR,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI GetFormW(HANDLE,LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD);
BOOL WINAPI SetFormA(HANDLE,LPSTR,DWORD,LPBYTE);
BOOL WINAPI SetFormW(HANDLE,LPWSTR,DWORD,LPBYTE);
BOOL WINAPI EnumFormsA(HANDLE,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI EnumFormsW(HANDLE,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI EnumMonitorsA(LPSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI EnumMonitorsW(LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI AddMonitorA(LPSTR,DWORD,LPBYTE);
BOOL WINAPI AddMonitorW(LPWSTR,DWORD,LPBYTE);
BOOL WINAPI DeleteMonitorA(LPSTR,LPSTR,LPSTR);
BOOL WINAPI DeleteMonitorW(LPWSTR,LPWSTR,LPWSTR);
BOOL WINAPI EnumPortsA(LPSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI EnumPortsW(LPWSTR,DWORD,LPBYTE,DWORD,LPDWORD,LPDWORD);
BOOL WINAPI AddPortA(LPSTR,HWND,LPSTR);
BOOL WINAPI AddPortW(LPWSTR,HWND,LPWSTR);
BOOL WINAPI ConfigurePortA(LPSTR,HWND,LPSTR);
BOOL WINAPI ConfigurePortW(LPWSTR,HWND,LPWSTR);
BOOL WINAPI DeletePortA(LPSTR,HWND,LPSTR);
BOOL WINAPI DeletePortW(LPWSTR,HWND,LPWSTR);
BOOL WINAPI AddPrinterConnectionA(LPSTR);
BOOL WINAPI AddPrinterConnectionW(LPWSTR);
BOOL WINAPI DeletePrinterConnectionA(LPSTR);
BOOL WINAPI DeletePrinterConnectionW(LPWSTR);
HANDLE WINAPI ConnectToPrinterDlg(HWND,DWORD);
BOOL WINAPI AddPrintProvidorA(LPSTR,DWORD,LPBYTE);
BOOL WINAPI AddPrintProvidorW(LPWSTR,DWORD,LPBYTE);
BOOL WINAPI DeletePrintProvidorA(LPSTR,LPSTR,LPSTR);
BOOL WINAPI DeletePrintProvidorW(LPWSTR,LPWSTR,LPWSTR);
#endif // GNU_WINSPOOL_

