
#include "g_local.h"

/**
 * Switch the team of a player 
 * 
 * argv(1) switch
 *
 * FIXME: both atoi() below are not checked for errors,
 * so if bogus text is entered, the value 0 is used
 */
void Svcmd_Switch_f (void)
{
	edict_t *player;
	int playerNum, team;

	if (!(expflags & EXPERT_ENFORCED_TEAMS)) {
		gi.cprintf(NULL, PRINT_HIGH, "Enforced Teamplay not enabled\n");
		return;
	}	

	if (gi.argc() != 4) {
		gi.cprintf(NULL, PRINT_HIGH, "switch: Usage: switch [playernum] [team]\n");
		return;
	}

	playerNum = atoi(gi.argv(2));
	if (playerNum < 0 || playerNum > (int)maxclients->value - 1) {
		gi.cprintf(NULL, PRINT_HIGH, "switch: invalid player number: %d\n", playerNum);
		return;
	}
	player = g_edicts + 1 + playerNum;	
	if (!player->inuse) {
		gi.cprintf(NULL, PRINT_HIGH, "switch: player %d is not active\n", playerNum);
		return;
	}
	if (!playerIsOnATeam(player)) {
		gi.cprintf(NULL, PRINT_HIGH, "switch: player %d is not assigned to a team\n", playerNum);
		return;
	}

	// allow either team name or team number to be used
	team = teamForName(gi.argv(3));
	if (team == -1) {
		// invalid team name; assume number
		team = atoi(gi.argv(3));
		if (team < 0 || team > (int)sv_numteams->value - 1) {
			gi.cprintf(NULL, PRINT_HIGH, "switch: %s is neither a valid "
			                             "team name nor team number\n", gi.argv(3));
			return;
		}
	}
	if (player->client->resp.team == team) {
		gi.cprintf(NULL, PRINT_HIGH, "switch: player %s is already on team %d\n", 
		           player->client->pers.netname, team);
		return;
	}
	killAndSwitchTeam(player, team);
	gi.cprintf(NULL, PRINT_HIGH, "switch: player %d switched to team %d\n", 
	           playerNum, team);
	
	gi.bprintf(PRINT_HIGH, "%s was switched to team %s\n",
	           player->client->pers.netname, nameForTeam(team));
}

/**
 * Clear all properties
 * 
 * argv(1) clearprops
 */
void Svcmd_ClearProps_f (void)
{
	if (gi.argc() != 2) {
		gi.cprintf(NULL, PRINT_HIGH, "clearprops: Usage: clearprops\n");
	} else {
		gi.cprintf(NULL, PRINT_HIGH, "All properties cleared\n");
		freeProps(gProperties);
		gProperties = newProps();
	}
}

/**
 * Set, change or view global properties
 * 
 * argv(1) prop
 */
void Svcmd_Prop_f (void) {

	if (gi.argc() > 4 || gi.argc() < 2) {
		gi.cprintf(NULL, PRINT_HIGH, "prop: Usage: prop [property] [value]\n");
		return;
	}
	
	if (gi.argc() == 2) {
		// show all global properties
		gi.cprintf(NULL, PRINT_HIGH, "Properties defined:\n");
		printProps(gProperties);
		return;
	} else if (gi.argc() == 3) {
		// display the value of a particular property
		char *value = getProp(gProperties, gi.argv(2)); 
		gi.cprintf(NULL, PRINT_HIGH, "\"%s\" is %s\n", gi.argv(2), value);
		return;
	} else { // gi.argc() == 4
		// set a new property (or override an old one)
		if (Q_stricmp("", gi.argv(3)) == 0) {
			// user entered : sv prop someprop ""
			// treat as removing a property
			removeProp(gProperties, gi.argv(2));
			gi.cprintf(NULL, PRINT_HIGH, "Removed property \"%s\"\n", gi.argv(2)); 
		} else {
			// user entered either a new prop or a real value
			// with which to override an old one
			addProp(gProperties, gi.argv(2), gi.argv(3));
			gi.cprintf(NULL, PRINT_HIGH, "Property \"%s\" is now \"%s\"\n", gi.argv(2), gi.argv(3));
		}
		return;
	}
}

/**
 * Send a stuffcmd to all players.  Use to do things
 * like move all players to another server.
 */
void Svcmd_StuffAll_f (void) 
{
	edict_t *player;
	int i;
	char text[2048];

	if (gi.argc() != 3) {
		gi.cprintf(NULL, PRINT_HIGH, "stuffall: Usage: stuffall \"command text\"\n");
		return;
	}

	gi.cprintf(NULL, PRINT_HIGH, "Stuffing \"%s\" to all players\n", gi.argv(2));

	strcat(text, gi.argv(2));
	strcat(text + strlen(gi.argv(2)), "\n");

	player = g_edicts + 1;
	for (i = 1; i <= maxclients->value; i++) {
		if (player->inuse)
		{
			StuffCmd(player, text);
		}
		player = player + 1;
	}

}

/**
 * Send a stuffcmd to a single player for entertainment purposes.
 */
void Svcmd_Stuff_f (void) 
{
	edict_t *player;
	int playerNum;
	char text[2048];

	if (gi.argc() != 4) {
		gi.cprintf(NULL, PRINT_HIGH, "stuff: Usage: stuff [playernum] \"command text\"\n");
		return;
	}

	playerNum = atoi(gi.argv(2));
	if (playerNum < 0 || playerNum > (int)maxclients->value - 1) {
		gi.cprintf(NULL, PRINT_HIGH, "stuff: invalid player number: %d\n", playerNum);
		return;
	}

	player = g_edicts + 1 + playerNum;	
	if (!player->inuse) {
		gi.cprintf(NULL, PRINT_HIGH, "stuff: player %d is not active\n", playerNum);
		return;
	}

	gi.cprintf(NULL, PRINT_HIGH, "Stuffing \"%s\" to player %s\n", 
			gi.argv(3), player->client->pers.netname);

	strcat(text, gi.argv(3));
	strcat(text + strlen(gi.argv(3)), "\n");

	StuffCmd(player, text);
}

/**
 * Set or unset a flag in expflags
 * 
 * argv(1) set
 */
void Svcmd_ExpflagsSet_f (void)
{
	char* settingName;
	int settingBit;

	if (gi.argc() < 3 || gi.argc() > 4) {
		gi.cprintf(NULL, PRINT_HIGH, "set: Usage: set \"flagname\" [off|on]\n");
		return;
	} 

	settingName = gi.argv(2);
	settingBit = getSettingBit(settingName);
	if (settingBit <= 0) {
		gi.cprintf(NULL, PRINT_HIGH, "Unrecognized setting \"%s\"\n", settingName);
		return;
	}

	if (gi.argc() == 3) {
		// used form "sv set setting", which means turn setting on
		gi.cvar_set("expflags", va("%d", expflags | settingBit));
		gi.cprintf(NULL, PRINT_HIGH, "Setting \"%s\" is now enabled\n", settingName);
	} else {
		// used form "sv set setting off"
		if (Q_stricmp("off", gi.argv(3)) == 0) {
			gi.cvar_set("expflags", va("%d", expflags & ~settingBit));
			gi.cprintf(NULL, PRINT_HIGH, "Setting \"%s\" is now disabled\n", settingName);
		} else if (Q_stricmp("on", gi.argv(3)) == 0) {
			gi.cvar_set("expflags", va("%d", expflags | settingBit));
			gi.cprintf(NULL, PRINT_HIGH, "Setting \"%s\" is now enabled\n", settingName);
		} else {
			gi.cprintf(NULL, PRINT_HIGH, "set: Usage: set \"flagname\" [off|on]\n");
		}
	}
}

// Pause/unpause a multiplayer game
void Svcmd_Pause_f (void)
{
	if ((int) sv_paused->value == 0) {
		// Don't pause the game in an intermission
		if (level.intermissiontime) {
			gi.cprintf(NULL, PRINT_HIGH, "Can't pause in an intermission.\n");
		}
		sv_paused->value = 1;
		// Display a pause message to all players
		gi.bprintf(PRINT_HIGH, "Game paused by console\n");
		// FIXME: Display a pause graphic to all players like in single-player
	} else {
		sv_paused->value = 0;
		// Display an unpause message to all players
		gi.bprintf(PRINT_HIGH, "Game unpaused\n");
		// FIXME: Turn off the pause graphic?
	}
}

/*
=================
ServerCommand

ServerCommand will be called when an "sv" command is issued.
The game can issue gi.argc() / gi.argv() commands to get the rest
of the parameters
=================
*/
void	ServerCommand (void)
{
	char	*cmd;

	cmd = gi.argv(1);
//	if (Q_stricmp (cmd, "loadprops") == 0)
//		Svcmd_LoadProps_f ();
	if (Q_stricmp (cmd, "prop") == 0)
		Svcmd_Prop_f ();
	else if (Q_stricmp (cmd, "clearprops") == 0)
		Svcmd_ClearProps_f ();
	else if (Q_stricmp (cmd, "switch") == 0)
		Svcmd_Switch_f ();
	else if (Q_stricmp (cmd, "stuff") == 0)
		Svcmd_Stuff_f();
	else if (Q_stricmp (cmd, "stuffall") == 0)
		Svcmd_StuffAll_f();
	else if (Q_stricmp (cmd, "set") == 0)
		Svcmd_ExpflagsSet_f();
	// Expert: Pause/unpause the game
	else if (Q_stricmp (cmd, "pause") == 0)
		Svcmd_Pause_f();
	else
		gi.cprintf (NULL, PRINT_HIGH, "Unknown server command \"%s\"\n", cmd);
}

