#include "patch.h"

/************************************************************
 SUBS.C
			 /-------------------------\
			||   General Subroutnes    ||
			 \-------------------------/
									
************************************************************/

// Initialize a range to empty

void InitRng(Rng *r)
{
	r->typ = 0;
	r->num = 0;
	r->start = 0;
	r->end = -1;
};

// Initialize the range globals for base and patch wad sprites, flats
// levels and patches. All are set empty.

void InitRanges(void)
{
	int i;

	for (i=0;i<4;i++)
	{
		InitRng(bpatRng+i);
		InitRng(bsprRng+i);
		InitRng(bflaRng+i);
		InitRng(ppatRng+i);
		InitRng(psprRng+i);
		InitRng(pflaRng+i);
	}
	for (i=0;i<64;i++)
	{
		InitRng(blevRng+i);
		InitRng(plevRng+i);
	}
	nbpr=nbsr=nbfr=nblr=0;
	nppr=npsr=npfr=nplr=0;
}

// Scan a wad directory, for the location of levels, sprites, flats, and patches

void GetRanges(WadDir *dir,int *nlevs,Rng *levs,int *nsprs,Rng *sprs,int *nflas,Rng *flas,int *npats,Rng *pats)
{
	int i,j,m,n,o;
	char *p,resn[16];;
	WadDirEntry *wde;
	int inlev=0;
	int inpat=0;
	int infla=0;
	int inspr=0;

	for (i=0;i<dir->nentries;i++)		// scan the directory
	{
		wde = dir->dirp+i;				// pointer to current wad entry
		strcpy(resn,Str8(wde->resname));

		if (inlev)						// if scanning a level map
		{
			// if not a level resource, or if a new level name close a range
			if (!IsMapResource(wde) || IsMapName(wde))
			{
				levs[*nlevs].end = i-1;	// index of last resource in level
				levs[*nlevs].num = levs[*nlevs].end-levs[*nlevs].start+1;
				(*nlevs)++;				// next range
			}
		}
		if (IsMapName(wde))				// if a new map name start new range
		{
			levs[*nlevs].typ = LevelNumber(resn);
			levs[*nlevs].start = i;	
			inlev=1;					// note we have level context
			goto skipit;
		}

		if (IsMapResource(wde))			// if a level resource
			goto skipit;				// continue scan with next entry

		inlev=0;						// not scanning a level, clear context

		// if a patch end Flag close a range and end patch context
		if (IsPatchEndFlag(wde))
		{
			n = 0;
			if ((p=strstr(resn,"_"))!=NULL)
				n = isdigit(*(p-1))? *(p-1)-'0' : 0;
			pats[n].end = i-1;		// index of last resource in range
			pats[n].num = pats[n].end-pats[n].start+1;
			(*npats)++;				// next range
			inpat = 0;				// patch context off
			goto skipit;				// scan on, from next entry
		}
		// if a patch start Flag start a range and set patch context
		if (IsPatchStartFlag(wde))
		{
			n = 0;
			if ((p=strstr(resn,"_"))!=NULL)
				n = isdigit(*(p-1))? *(p-1)-'0' : 0;
			pats[n].typ = n;			// set typ to number in start Flag
			pats[n].start = i+1;	
			inpat=1;					// note we have patch context
			goto skipit;					// scan on, from next entry
		}

		// if a flat end Flag close a range and end flat context
		if (IsFlatEndFlag(wde))
		{
			n = 0;
			if ((p=strstr(resn,"_"))!=NULL)
				n = isdigit(*(p-1))? *(p-1)-'0' : 0;
			flas[n].end = i-1;		// index of last resource in range
			flas[n].num = flas[n].end-flas[n].start+1;
			(*nflas)++;				// next range
			infla = 0;				// flat context off
			goto skipit;				// scan on, from next entry
		}
		// if a flat start Flag start a range and set sprite context
		if (IsFlatStartFlag(wde))
		{
			n = 0;
			if ((p=strstr(resn,"_"))!=NULL)
				n = isdigit(*(p-1))? *(p-1)-'0' : 0;
			flas[n].typ = n;			// set typ to number in start Flag
			flas[n].start = i+1;	
			infla=1;					// note we have flat context
			goto skipit;					// scan on, from next entry
		}

		// if a sprite end Flag close a range and end sprite context
		if (IsSpriteEndFlag(wde))
		{
			n = 0;
			if ((p=strstr(resn,"_"))!=NULL)
				n = isdigit(*(p-1))? *(p-1)-'0' : 0;
			sprs[n].end = i-1;		// index of last resource in range
			sprs[n].num = sprs[n].end-sprs[n].start+1;
			(*nsprs)++;				// next range
			inspr = 0;				// sprite context off
			goto skipit;				// scan on, from next entry
		}
		// if a sprite start Flag start a range and set sprite context
		if (IsSpriteStartFlag(wde))
		{
			n = 0;
			if ((p=strstr(resn,"_"))!=NULL)
				n = isdigit(*(p-1))? *(p-1)-'0' : 0;
			sprs[n].typ = n;			// set typ to number in start Flag
			sprs[n].start = i+1;	
			inspr=1;					// note we have sprite context
			goto skipit;					// scan on, from next entry
		}
skipit:;
	}
	if (inlev)
	{
		levs[*nlevs].end = i-1;	// index of last resource in level
		levs[*nlevs].num = levs[*nlevs].end-levs[*nlevs].start+1;
		(*nlevs)++;				// next range
	}

	if (Verbose)
	{
		if (*nlevs)
		{
			printf("%d levels:\n",*nlevs);
			printf("level   start  end    len\n");
			for (i=0;i<*nlevs;i++)
				printf("MAP%02d %5d %5d %5d\n",levs[i].typ,levs[i].start,levs[i].end,levs[i].num);
		}
		else printf("No levels\n");

		printf("\nPatch Ranges:\n");
		printf("start  end    len    typ\n");
		for (i=0;i<4;i++)
			printf("%5d %5d %5d %5d\n",pats[i].start,pats[i].end,pats[i].num,pats[i].typ);
		printf("\nFlat Ranges:\n");
		printf("start  end    len    typ\n");
		for (i=0;i<4;i++)
			printf("%5d %5d %5d %5d\n",flas[i].start,flas[i].end,flas[i].num,flas[i].typ);
		printf("\nSprite Ranges:\n");
		printf("start  end    len    typ\n");
		for (i=0;i<4;i++)
			printf("%5d %5d %5d %5d\n",sprs[i].start,sprs[i].end,sprs[i].num,sprs[i].typ);
	}
}

/*
int IsBaseSprite(char *resn)
{
	return = IsInRange(&bdir,resn,bsprRng[0].start,bsprRng[0].end);
}
int IsPatchSprite(char *resn)
int IsBasePatch(char *resn)
int IsPatchPatch(char *resn)
int IsBaseFlat(char *resn)
int IsPatchFlat(char *resn)
int IsBaseGraphic(char *resn)
int	IsPatchGraphic(char *resn)
int IsBaseLevel(char *resn)
int IsPatchLevel(char *resn)
*/

// Convert a spritename to a valid DOS filename
// This routine is used in ReadBMP and WriteBMP for file system names only, 
// the remainder of the program uses actual sprite names.

void DOSTranslate(char *q,char *p)
{
	for (;*q;p++,q++)		// for each char
	{
		switch(*q)			// translate bad chars to something ok
		{
			case '[':
				*p = '@';
				break;
			case '\\':
				*p = '#';
				break;
			case ']':
				*p = '$';
				break;
			default:
				*p = *q;
				break;
		}
	}
	*p = '\0';				// terminate output string
}

// Convert a sprite filename that was converted to become a legal DOS filename
// back to the actual sprite name. Not used at this time.

void DOSUnTranslate(char *q,char *p)
{
	for (;*q;p++,q++)		// for each char
	{
		switch(*q)			// translate subst'd chars back to sprite chars
		{
			case '@':
				*p = '[';
				break;
			case '#':
				*p = '\\';
				break;
			case '$':
				*p = ']';
				break;
			default:
				*p = *q;
				break;
		}
	}
	*p = '\0';				// terminate output string
}

/* Return a string equal to an 8 char buffer in content */

char *Str8(char *buff)
{
	static char bf[9];

	strncpy(bf,buff,8);
	bf[8]='\0';
	return bf;
}


// Return the level number corresponding to level name
// Note for DOOM 1 the value of digits xy is returned for ExMy

int LevelNumber(char *levtag)
{
	char nums[3];

	if (IsD1Map(levtag))
	{
		nums[0]=levtag[1];
		nums[1]=levtag[3];
		nums[2]='\0';
	}
	else if (IsD2Map(levtag))
	{
		nums[0]=levtag[3];
		nums[1]=levtag[4];
		nums[2]='\0';
	}
	else return 0;

	return atoi(nums);
}

/* return true if wde points to a DOOM 1 map tag ExMy */

int IsD1Map(char *mname)
{
	return (mname[0]=='E' || mname[0]=='e')
		&& (mname[2]=='M' || mname[2]=='m')
		&& isdigit(mname[1])
		&& isdigit(mname[3]);
}

// Return true if wde points to a DOOM 2 map tag Mapnn */

int IsD2Map(char *mname)
{
	return !strnicmp("MAP",mname,3)
		&& isdigit(mname[3])
		&& isdigit(mname[4]);
}

/* return true if wde points to a DOOM 1 or DOOM 2 map tag */

int IsDMap(char *mname)
{
	return IsD1Map(mname) || IsD2Map(mname);
}

// Add a resource to a DTex list

void AddDTex(DTex **dt,int *n,int isp,char *nam,int n1,int n2)
{
	*dt = (DTex *)realloc(*dt,((*n)+1)*sizeof(DTex));
	assert(*dt);
	(*dt)[*n].isp = isp;
	strcpy((*dt)[*n].name,nam);
	(*dt)[*n].num1 = n1;
	(*dt)[*n].num2 = n2;
	(*n)++;
}

// Find a DTex with a certain name as initial substring

int IsInDTexN(char *nam,DTex *list,int len,int n)
{
	int i;

	for (i=0;i<len;i++)
		if (strnicmp(nam,list[i].name,n)==0)
			return i;
	return -1;
}

// Find a DTex with a certain name in a list

int IsInDTex(char *nam,DTex *list,int len)
{
	return IsInDTexN(nam,list,len,8);
}

// Free all global DTex arrays

void FreeDTex()
{
	free(clump); clump=NULL; nclump=0;
	free(ctexture); ctexture=NULL; nctext=0;
	free(clevel); clevel=NULL; ncleve=0;
	free(csound); csound=NULL; ncsoun=0;
	free(cmusic); cmusic=NULL; ncmusi=0;
	free(cgraphic); cgraphic=NULL; ncgrap=0;
	free(csprite); csprite=NULL; ncspri=0;
	free(cpatch); cpatch=NULL; ncpatc=0;
	free(cflat); cflat=NULL; ncflat=0; 
}

// Initialize global DTex pointers

void InitDTex()
{
	clump=NULL; nclump=0;
	ctexture=NULL; nctext=0;
	clevel=NULL; ncleve=0;
	csound=NULL; ncsoun=0;
	cmusic=NULL; ncmusi=0;
	cgraphic=NULL; ncgrap=0;
	csprite=NULL; ncspri=0;
	cpatch=NULL; ncpatc=0;
	cflat=NULL; ncflat=0; 
}

// return the length of an opened binary file

int filelen(FILE *st)
{
	int p,l1,l2;

	p = ftell(st);
	fseek(st,0,SEEK_SET);
	l1 = ftell(st);
	fseek(st,0,SEEK_END);
	l2 = ftell(st);
	fseek(st,p,SEEK_SET);
	return l2-l1;
}

// Add a string at the end of a dynamic array of dynamic strings

void AddDynStr(char ***dynstrp,int *ndynstr,char *str)
{
	// add one more dynamic string pointer to array

	*dynstrp = (char **) realloc (*dynstrp, (*ndynstr+1)*sizeof(char *));
	assert(*dynstrp);

	// allocate the bytes for new string on new pointer

	(*dynstrp)[*ndynstr] = (char *) malloc (1+strlen(str));
	assert((*dynstrp)[*ndynstr]);
	strcpy((*dynstrp)[*ndynstr],str);	// copy string bytes and terminator

	(*ndynstr)++;						// note one more dynamic string
}

// deallocate a dynamic array of dynamic strings

void FreeDynStr(char ***dynstrp,int *ndynstr)
{
	int i;

	for (i=0;i<*ndynstr;i++)			// free the strings
		free((*dynstrp)[i]);
	free (*dynstrp);					// free array of string pointers
	*ndynstr = 0;
	*dynstrp = NULL;					// ready for next use
}

// Add an integer to a dynamic array of them

void AddDynInt(int **dynintp,int *n,int val)
{
	// add one more integer

	*dynintp = (int *) realloc (*dynintp, ((*n)+1)*sizeof(int));
	assert(*dynintp);
	(*dynintp)[*n] = val;

	(*n)++;
}

// deallocate a dynamic array of integers

void FreeDynInt(int **dynintp,int *n)
{
	int i;

	free(*dynintp);
	*n = 0;
	*dynintp = NULL;
}

// Read the specified environment variable and use it as default command
// line if present. Add the command line arguments at the end.

void CopyEnvironmentCLArgs(char *envar,int arc,char **arv)
{
	char *p,**toks;
	int ntoks,i;

	if ((p = getenv(envar))!=NULL)
		Tokenize(p," \t",&clstrs,&nclstrs);
	for (i=1;i<arc;i++)
		AddDynStr(&clstrs,&nclstrs,arv[i]);
}

// Read the command line arguments and separate options and parameters

void ParseCommandLine(int maxopts,int maxfiles)
{
	int i,j,k,m,n;
	char temp[128];
	

	nclfiles=nclopts=0;
	for (i=0;i<nclstrs;i++)
	{
		if (clstrs[i][0]=='-' || clstrs[i][0]=='/' || clstrs[i][0]=='+')
		{
			if (maxopts>=0 && nclopts==maxopts)
			{
				printf("Only %d options allowed on command line\n",maxopts);
				exit(1);
			}
			k = n = nclopts;
			strcpy(temp,clstrs[i]+1);
			Tokenize(temp,"\-\/\+",&cloptions,&n);
			for (j=0,m=0;j<n-k;j++)
			{
				AddDynInt(&cloptsense,&nclopts,clstrs[i][m]=='-'? 0 : 1);
				m += 1+strlen(cloptions[k+j]);
			}					  
		}
		else
		{
			if (maxfiles>=0 && nclfiles==maxfiles)
			{
				printf("Only %d parameters allowed on command line\n",maxfiles);
				exit(1);
			}
			AddDynStr(&clfiles,&nclfiles,clstrs[i]);
		}
	}

	if (0)
	{
		printf("Parameters:\n");
		for (i=0;i<nclfiles;i++)
			printf("%1d: %s  ",i,clfiles[i]);
		printf("\nOptions:\n");
		for (i=0;i<nclopts;i++)
			printf("%1d: %c%s  ",i,cloptsense[i]?'+':'-',cloptions[i]);
		printf("\n");
	}
}

// Walk the heap and report its status and free and used sizes

void heap_dump(void)
{

    struct _heapinfo h_info;
    int heap_status;
	int usize=0,fsize=0;

    h_info._pentry = NULL;
    while (1)
	{
    	heap_status = _heapwalk(&h_info);
		if (heap_status != _HEAPOK)
			break;
		if (0)
		{
			printf
			(
				"  %s block at %Fp of size %4.4X\n",
		    	(h_info._useflag == _USEDENTRY ? "USED" : "FREE"),
	        	h_info._pentry,
				h_info._size
			);
		}
		if (h_info._useflag==_USEDENTRY)
			usize += h_info._size;
		else
			fsize += h_info._size;
	}

    switch( heap_status )
	{
	    case _HEAPEND:
	      printf("OK - end of heap ");
	      break;
	    case _HEAPEMPTY:
	      printf("OK - heap is empty ");
	      break;
	    case _HEAPBADBEGIN:
          printf("ERROR - heap is damaged ");
	      break;
	    case _HEAPBADPTR:
	      printf("ERROR - bad pointer to heap ");
	      break;
	    case _HEAPBADNODE:
	      printf("ERROR - bad node in heap ");
		  break;
		default:
 		  break;
	}
	printf("Unused: %6d  Used: %d\n",fsize,usize);

}

// Return the next larger power of two

int NextPowerTwo(int n)
{
	int i;

	for (i=0;i<32;i++)
		if ((1<<i)>=n) break;

	return 1<<i;
}

// Add the tokens in str delimited by chars in dlm to the dynamic
// array of dynamic strings *dynstrp of length *ndynstr

int Tokenize (char *str,char *dlm,char ***dynstrp,int *ndynstr)
{
	char *t,*s;

	s = strdup(str);
	t = strtok(s,dlm);
	while (t!=NULL)
	{
		AddDynStr(dynstrp,ndynstr,t);
		t = strtok(NULL,dlm);
	}
	free(s);
	return *ndynstr;
}

// Add the next n-1 tokens in str delimited by chars in dlm to the dynamic
// array of dynamic strings *dynstrp of length *ndynstr. Then if str not
// exhausted add the remainder of str (minus initial delimiters) as
// one more string.

int TokenizeN (char *str,char *dlm,char ***dynstrp,int *ndynstr, int n)
{
	char *t,*s;
	int cnt=0,p;

	s = strdup(str);
	t = strtok(s,dlm);			 				// 0-th string
	while (t!=NULL && ++cnt<n)
	{
		AddDynStr(dynstrp,ndynstr,t); 			// add cnt-1 th string
		t = strtok(NULL,cnt==n-1? "" : dlm);	// on last call get rest
	}
	p = strspn(t,dlm);			 				// skip delims before last
	AddDynStr(dynstrp,ndynstr,t+p);				// add rest as n-1th string

	free(s);
	return *ndynstr;
}

// If SingleMarker or DoubleMarker convert X_END and XX_END tags appropriately

void ConvertMarker(char *resn)
{
	if
	(
		SingleMarker
		&&
		resn[2]=='_'
		&&
		resn[0]==resn[1]
		&&
		(
			resn[0]=='P'
			||
			resn[0]=='F'
			||
			resn[0]=='S'
		)
		&&
		(
			strcmp(resn+3,"END")==0
			||
			strcmp(resn+3,"START")==0
		)
	)
		memmove(resn,resn+1,strlen(resn));	
	else if
	(
		DoubleMarker
		&&
		resn[1]=='_'
		&&
		resn[0]!='D'		// speeds up check
		&&
		resn[0]!='M'		// by rejecting musics and menus
		&&
		(
			strcmp(resn,"S_START")==0
			||
			strcmp(resn,"F_START")==0
			||
			strcmp(resn,"P_START")==0
			||
			strcmp(resn,"S_END")==0
			||
			strcmp(resn,"F_END")==0
			||
			strcmp(resn,"P_END")==0
		)
	)
		memmove(resn+1,resn,1+strlen(resn));
}

