#include "patch.h"

/************************************************************
 GLOBAL.C
			 /-------------------------\
			|| Global Data Definitions ||
			 \-------------------------/
									
************************************************************/

// Global Data

// Three parameter wad data structures
// Data Structure	BaseWad			PatchWad		OutWad
//-------------------------------------------------------------------
FILE 				*bst,			*pst,			*ost;
char 				bwadname[128],	pwadname[128],	owadname[128];
WadHeader 			bhdr,			phdr,			ohdr;
WadDir 				bdir,			pdir,			odir;
WadTextures 		bwt,			pwt,			owt;
Rng 				bpatRng[4],		ppatRng[4];
int 				nbpr=0,			nppr=0;
Rng					bsprRng[4],		psprRng[4];
int					nbsr=0,			npsr=0;
Rng					bflaRng[4],		pflaRng[4];
int					nbfr=0,			npfr=0;
Rng					blevRng[64],	plevRng[64];
int					nblr=0,			nplr=0;
//-------------------------------------------------------------------

int *XIdx=NULL;
char iwadname[128]="",outname[128]="";
char levmapfil[128]="";

// Resource name and offsets lists

DTex *ctexture=NULL;
int nctext=0;
DTex *clevel=NULL;
int ncleve=0;
DTex *csprite=NULL;
int ncspri=0;
DTex *cflat=NULL;
int ncflat=0;
DTex *cpatch=NULL;
int ncpatc=0;
DTex *cgraphic=NULL;
int ncgrap=0;
DTex *cmusic=NULL;
int ncmusi=0;
DTex *csound=NULL;
int ncsoun=0;
DTex *clump=NULL;
int nclump=0;

// Mode flags

int PatchFormat=1;
int Xlation=0;
int DoubleSize=0;
int SingleMap=0;

// Command line switches, currently set at default

int Verbose=0;			// turn on debug outputs
int NewOnly=0;			// Do not merge resources already existing in base
int MakeIwad=0;			// Output an IWAD
int MakeRwad=0;			// Output a large resource WAD
int SingleMarker=0;		// Output S_START not SS_START etc.
int DoubleMarker=0;		// Output SS_END not S_END etc.
int RenameControl=0;	// BRK always writes BRKINFO.TXT
int AdditionalPatches=0;// BRK extracts patches in PNAMES always
int DoLumps=1;			// Allow lumps to be created, merged or extracted
int DoWads=1;			// Allow levels
int DoTextures=1;		// Allow textures and pnames
int DoEffects=1;		// Allow sound effects
int DoMusics=1;			// Allow musics
int DoGraphics=1;		// Allow graphics
int DoSprites=1;		// Allow sprites
int DoPatches=1;		// Allow patches
int DoFlats=1;			// Allow flats
int ReplaceLevels=1;	// Normal default patch operation on levels
int BaseFirst=0;		// If not replacing or mapping, which comes first
int MapLevels=0;		// Read external text file for output level order

int CenterText=1;
int Brightness=0;
int XlateTextColor=TEXTRED;
Segment *segs=NULL;
int nsegs=0;

// dynamic command line parsing variables

char **clfiles;			// dynamic array of dynamic parameter strings
int nclfiles;			// number of strings in array
char **cloptions;		// dynamic array of dynamic option strings
int *cloptsense;		// polarity of option - vs. / or +
int nclopts;			// number of strings in array
char **clstrs;			// dynamic array of dynamic argument strings
int nclstrs;			// number of strings in array

// A list of known resource names of monolithic structure
// The only resources known to the engine outside these are the level
// resources and tags, the PNAMES and TEXTUREn resources, and the
// SPRITES, PATCHES, and FLATS resources, and their markers.
//
// All resources named here are simple to merge. The block of data
// is taken from the patch wad if present there, else the base wad if
// present there, and not written to the output wad otherwise.

char *resstr[]=
{
	"XYZZY",
	"PLAYPAL","COLORMAP","ENDOOM","DEMO1","DEMO2","DEMO3",
	"GENMIDI","DMXGUSC",
	"DPPISTOL","DSPISTOL","DPSHOTGN","DSSHOTGN","DPSGCOCK","DSSGCOCK",
	"DPSAWUP","DSSAWUP","DPSAWIDL","DSSAWIDL","DPSAWFUL","DSSAWFUL",
	"DPSAWHIT","DSSAWHIT","DPRLAUNC","DSRLAUNC","DPRXPLOD","DSRXPLOD",
	"DPFIRSHT","DSFIRSHT","DPFIRXPL","DSFIRXPL","DPPSTART","DSPSTART",
	"DPPSTOP","DSPSTOP","DPDOROPN","DSDOROPN","DPDORCLS","DSDORCLS",
	"DPSTNMOV","DSSTNMOV","DPSWTCHN","DSSWTCHN","DPSWTCHX","DSSWTCHX",
	"DPPLPAIN","DSPLPAIN","DPDMPAIN","DSDMPAIN","DPPOPAIN","DSPOPAIN",
	"DPSLOP","DSSLOP","DPITEMUP","DSITEMUP","DPWPNUP","DSWPNUP",
	"DPOOF","DSOOF","DPTELEPT","DSTELEPT","DPPOSIT1","DSPOSIT1",
	"DPPOSIT2","DSPOSIT2","DPPOSIT3","DSPOSIT3","DPBGSIT1","DSBGSIT1",
	"DPBGSIT2","DSBGSIT2","DPSGTSIT","DSSGTSIT","DPBRSSIT","DSBRSSIT",
	"DPSGTATK","DSSGTATK","DPCLAW","DSCLAW","DPPLDETH","DSPLDETH",
	"DPPDIEHI","DSPDIEHI","DPPODTH1","DSPODTH1","DPPODTH2","DSPODTH2",
	"DPPODTH3","DSPODTH3","DPBGDTH1","DSBGDTH1","DPBGDTH2","DSBGDTH2",
	"DPSGTDTH","DSSGTDTH","DPBRSDTH","DSBRSDTH","DPPOSACT","DSPOSACT",
	"DPBGACT","DSBGACT","DPDMACT","DSDMACT","DPNOWAY","DSNOWAY",
	"DPBAREXP","DSBAREXP","DPPUNCH","DSPUNCH","DPTINK","DSTINK",
	"DPBDOPN","DSBDOPN","DPBDCLS","DSBDCLS","DPITMBK","DSITMBK",
	"DPGETPOW","DSGETPOW","DPPLASMA","DSPLASMA","DPBFG","DSBFG",
	"DPCACSIT","DSCACSIT","DPCYBSIT","DSCYBSIT","DPSPISIT","DSSPISIT",
	"DPSKLATK","DSSKLATK","DPCACDTH","DSCACDTH","DPSKLDTH","DSSKLDTH",
	"DPCYBDTH","DSCYBDTH","DPSPIDTH","DSSPIDTH","DPHOOF","DSHOOF",
	"DPMETAL","DSMETAL","DPDSHTGN","DSDSHTGN","DPDBOPN","DSDBOPN",
	"DPDBCLS","DSDBCLS","DPDBLOAD","DSDBLOAD","DPVIPAIN","DSVIPAIN",
	"DPMNPAIN","DSMNPAIN","DPPEPAIN","DSPEPAIN","DPBSPSIT","DSBSPSIT",
	"DPKNTSIT","DSKNTSIT","DPVILSIT","DSVILSIT","DPMANSIT","DSMANSIT",
	"DPPESIT","DSPESIT","DPSKEPCH","DSSKEPCH","DPVILATK","DSVILATK",
	"DPSKESWG","DSSKESWG","DPBSPDTH","DSBSPDTH","DPVILDTH","DSVILDTH",
	"DPKNTDTH","DSKNTDTH","DPPEDTH","DSPEDTH","DPSKEDTH","DSSKEDTH",
	"DPBSPACT","DSBSPACT","DPBSPWLK","DSBSPWLK","DPVILACT","DSVILACT",
	"DPFLAME","DSFLAME","DPFLAMST","DSFLAMST","DPBOSPIT","DSBOSPIT",
	"DPBOSCUB","DSBOSCUB","DPBOSSIT","DSBOSSIT","DPBOSPN","DSBOSPN",
	"DPBOSDTH","DSBOSDTH","DPMANATK","DSMANATK","DPMANDTH","DSMANDTH",
	"DPSSSIT","DSSSSIT","DPSSDTH","DSSSDTH","DPKEENPN","DSKEENPN",
	"DPKEENDT","DSKEENDT","DPSKEACT","DSSKEACT","DPSKESIT","DSSKESIT",
	"DPSKEATK","DSSKEATK","DPRADIO","DSRADIO",
	"D_RUNNIN","D_STALKS","D_COUNTD","D_BETWEE","D_DOOM","D_THE_DA",
	"D_SHAWN","D_DDTBLU","D_IN_CIT","D_DEAD","D_STLKS2","D_THEDA2",
	"D_DOOM2","D_DDTBL2","D_RUNNI2","D_DEAD2","D_STLKS3","D_ROMERO",
	"D_SHAWN2","D_MESSAG","D_COUNT2","D_DDTBL3","D_AMPIE","D_THEDA3",
	"D_ADRIAN","D_MESSG2","D_ROMER2","D_TENSE","D_SHAWN3","D_OPENIN",
	"D_EVIL","D_ULTIMA","D_READ_M","D_DM2TTL","D_DM2INT",
	"HELP","VICTORY2","PFUB1","PFUB2",
	"END0","END1","END2","END3","END4","END5","END6",
	"TITLEPIC","CREDIT","BOSSBACK",
	"AMMNUM0","AMMNUM1","AMMNUM2","AMMNUM3","AMMNUM4","AMMNUM5",
	"AMMNUM6","AMMNUM7","AMMNUM8","AMMNUM9",
	"STBAR","STGNUM0","STGNUM1","STGNUM2","STGNUM3","STGNUM4",
	"STGNUM5","STGNUM6","STGNUM7","STGNUM8","STGNUM9",
	"STTMINUS","STTNUM0","STTNUM1","STTNUM2","STTNUM3","STTNUM4",
	"STTNUM5","STTNUM6","STTNUM7","STTNUM8","STTNUM9",
	"STTPRCNT","STYSNUM0","STYSNUM1","STYSNUM2","STYSNUM3","STYSNUM4",
	"STYSNUM5","STYSNUM6","STYSNUM7","STYSNUM8","STYSNUM9",
	"STKEYS0","STKEYS1","STKEYS2","STKEYS3","STKEYS4","STKEYS5",
	"STDISK","STCDROM",
	"STARMS",
	"STCFN033","STCFN034","STCFN035","STCFN036","STCFN037","STCFN038",
	"STCFN039","STCFN040","STCFN041","STCFN042","STCFN043","STCFN044",
	"STCFN045","STCFN046","STCFN047","STCFN048","STCFN049","STCFN050",
	"STCFN051","STCFN052","STCFN053","STCFN054","STCFN055","STCFN056",
	"STCFN057","STCFN058","STCFN059","STCFN060","STCFN061","STCFN062",
	"STCFN063","STCFN064","STCFN065","STCFN066","STCFN067","STCFN068",
	"STCFN069","STCFN070","STCFN071","STCFN072","STCFN073","STCFN074",
	"STCFN075","STCFN076","STCFN077","STCFN078","STCFN079","STCFN080",
	"STCFN081","STCFN082","STCFN083","STCFN084","STCFN085","STCFN086",
	"STCFN087","STCFN088","STCFN089","STCFN090","STCFN091","STCFN092",
	"STCFN093","STCFN094","STCFN095","STCFN121",
	"STFB1","STFB0","STFB2","STFB3","STPB1","STPB0","STPB2","STPB3",
	"STFST01","STFST00","STFST02",
	"STFTL00","STFTR00",
	"STFOUCH0","STFEVL0","STFKILL0",
	"STFST11","STFST10",
	"STFST12","STFTL10","STFTR10",
	"STFOUCH1","STFEVL1","STFKILL1",
	"STFST21","STFST20","STFST22","STFTL20","STFTR20",
	"STFOUCH2","STFEVL2","STFKILL2",
	"STFST31","STFST30","STFST32","STFTL30","STFTR30",
	"STFOUCH3","STFEVL3","STFKILL3",
	"STFST41","STFST40","STFST42","STFTL40","STFTR40",
	"STFOUCH4","STFEVL4","STFKILL4","STFGOD0","STFDEAD0",
	"M_DOOM","M_RDTHIS","M_OPTION","M_QUITG","M_NGAME","M_SKULL1",
	"M_SKULL2","M_THERMO","M_THERMR","M_THERMM","M_THERML","M_ENDGAM",
	"M_PAUSE","M_MESSG","M_MSGON","M_MSGOFF","M_EPISOD","M_EPI1",
	"M_EPI2","M_EPI3","M_HURT","M_JKILL","M_ROUGH","M_SKILL",
	"M_NEWG","M_ULTRA","M_NMARE","M_SVOL","M_OPTTTL","M_SAVEG",
	"M_LOADG","M_DISP","M_MSENS","M_GDHIGH","M_GDLOW","M_DETAIL",
	"M_DISOPT","M_SCRNSZ","M_SGTTL","M_LGTTL","M_SFXVOL","M_MUSVOL",
	"M_LSLEFT","M_LSCNTR","M_LSRGHT",
	"BRDR_TL","BRDR_T","BRDR_TR","BRDR_L",
	"BRDR_R","BRDR_BL","BRDR_B","BRDR_BR",
	"WIOSTK","WIOSTI","WIF","WIMSTT","WIOSTS","WIOSTF","WITIME","WIPAR",
	"WIMSTAR","WIMINUS","WIPCNT","WINUM0","WINUM1","WINUM2","WINUM3",
	"WINUM4","WINUM5","WINUM6","WINUM7","WINUM8","WINUM9",
	"WICOLON","WISUCKS","WIFRGS",
	"WILV00","WILV01","WILV02","WILV03","WILV04","WILV05","WILV06",
	"WILV07","WILV08","WILV11","WILV12","WILV14","WILV15","WILV16",
	"WILV17","WILV18","WILV20","WILV21","WILV22","WILV23","WILV24",
	"WILV25","WILV26","WILV27","WILV28","WILV13","WILV10",
	"WIP1","WIP2","WIP3","WIP4",
	"WIBP1","WIBP2","WIBP3","WIBP4","WIKILRS","WIVCTMS","WISCRT2","WIENTER",
	"CWILV00","CWILV01","CWILV02","CWILV03","CWILV04","CWILV05",
	"CWILV06","CWILV07","CWILV08","CWILV09","CWILV10","CWILV11",
	"CWILV12","CWILV13","CWILV14","CWILV15","CWILV16","CWILV17",
	"CWILV18","CWILV19","CWILV22","CWILV21","CWILV20","CWILV23",
	"CWILV25","CWILV26","CWILV27","CWILV28","CWILV29","CWILV24",
	"CWILV30","CWILV31",
	"INTERPIC",
};


char *musstr[]=
{
	"NOTMUSIC", //  index place holder
	"D_RUNNIN", //	Map01
	"D_STALKS", //	Map02
	"D_COUNTD", //	Map03
	"D_BETWEE", //	Map04
	"D_DOOM",	//	Map05
	"D_THE_DA", //	Map06
	"D_SHAWN",	//	Map07
	"D_DDTBLU", //	Map08
	"D_IN_CIT", //	Map09
	"D_DEAD",	//	Map10
	"D_STLKS2", //	Map11
	"D_THEDA2", //	Map12
	"D_DOOM2",	//	Map13
	"D_DDTBL2", //	Map14
	"D_RUNNI2", //	Map15
	"D_DEAD2",	//	Map16
	"D_STLKS3", //	Map17
	"D_ROMERO", //	Map18
	"D_SHAWN2", //	Map19
	"D_MESSAG", //	Map20
	"D_COUNT2", //	Map21
	"D_DDTBL3", //	Map22
	"D_AMPIE",	//	Map23
	"D_THEDA3", //	Map24
	"D_ADRIAN", //	Map25
	"D_MESSG2", //	Map26
	"D_ROMER2", //	Map27
	"D_TENSE",	//	Map28
	"D_SHAWN3", //	Map29
	"D_OPENIN", //	Map30
	"D_EVIL",	//	Map31
	"D_ULTIMA", //	Map32
	"D_READ_M", //	readme music
	"D_DM2TTL", //	title music
	"D_DM2INT", //	intermission music
};

RGBQUAD DoomPalette[]=
{
	{  0,  0,  0,  0},{ 11, 23, 31,  0},{  7, 15, 23,  0},{ 75, 75, 75,  0},
	{255,255,255,  0},{ 27, 27, 27,  0},{ 19, 19, 19,  0},{ 11, 11, 11,  0},
	{  7,  7,  7,  0},{ 31, 55, 47,  0},{ 15, 43, 35,  0},{  7, 31, 23,  0},
	{  0, 23, 15,  0},{ 43, 59, 79,  0},{ 35, 51, 71,  0},{ 27, 43, 63,  0},
	{183,183,255,  0},{171,171,247,  0},{163,163,243,  0},{151,151,235,  0},
	{143,143,231,  0},{135,135,223,  0},{123,123,219,  0},{115,115,211,  0},
	{107,107,203,  0},{ 99, 99,199,  0},{ 91, 91,191,  0},{ 87, 87,187,  0},
	{ 79, 79,179,  0},{ 71, 71,175,  0},{ 63, 63,167,  0},{ 59, 59,163,  0},
	{ 51, 51,155,  0},{ 47, 47,151,  0},{ 43, 43,143,  0},{ 35, 35,139,  0},
	{ 31, 31,131,  0},{ 27, 27,127,  0},{ 23, 23,119,  0},{ 19, 19,115,  0},
	{ 15, 15,107,  0},{ 11, 11,103,  0},{  7,  7, 95,  0},{  7,  7, 91,  0},
	{  7,  7, 83,  0},{  0,  0, 79,  0},{  0,  0, 71,  0},{  0,  0, 67,  0},
	{223,235,255,  0},{211,227,255,  0},{199,219,255,  0},{187,211,255,  0},
	{179,207,255,  0},{167,199,255,  0},{155,191,255,  0},{147,187,255,  0},
	{131,179,255,  0},{123,171,247,  0},{115,163,239,  0},{107,155,231,  0},
	{ 99,147,223,  0},{ 91,139,215,  0},{ 83,131,207,  0},{ 79,127,203,  0},
	{ 75,123,191,  0},{ 71,115,179,  0},{ 67,111,171,  0},{ 63,107,163,  0},
	{ 59, 99,155,  0},{ 55, 95,143,  0},{ 51, 87,135,  0},{ 47, 83,127,  0},
	{ 43, 79,119,  0},{ 39, 71,107,  0},{ 35, 67, 95,  0},{ 31, 63, 83,  0},
	{ 27, 55, 75,  0},{ 23, 47, 63,  0},{ 19, 43, 51,  0},{ 15, 35, 43,  0},
	{239,239,239,  0},{231,231,231,  0},{223,223,223,  0},{219,219,219,  0},
	{211,211,211,  0},{203,203,203,  0},{199,199,199,  0},{191,191,191,  0},
	{183,183,183,  0},{179,179,179,  0},{171,171,171,  0},{167,167,167,  0},
	{159,159,159,  0},{151,151,151,  0},{147,147,147,  0},{139,139,139,  0},
	{131,131,131,  0},{127,127,127,  0},{119,119,119,  0},{111,111,111,  0},
	{107,107,107,  0},{ 99, 99, 99,  0},{ 91, 91, 91,  0},{ 87, 87, 87,  0},
	{ 79, 79, 79,  0},{ 71, 71, 71,  0},{ 67, 67, 67,  0},{ 59, 59, 59,  0},
	{ 55, 55, 55,  0},{ 47, 47, 47,  0},{ 39, 39, 39,  0},{ 35, 35, 35,  0},
	{111,255,119,  0},{103,239,111,  0},{ 95,223,103,  0},{ 87,207, 95,  0},
	{ 79,191, 91,  0},{ 71,175, 83,  0},{ 63,159, 75,  0},{ 55,147, 67,  0},
	{ 47,131, 63,  0},{ 43,115, 55,  0},{ 35, 99, 47,  0},{ 27, 83, 39,  0},
	{ 23, 67, 31,  0},{ 15, 51, 23,  0},{ 11, 35, 19,  0},{  7, 23, 11,  0},
	{143,167,191,  0},{135,159,183,  0},{127,151,175,  0},{119,143,167,  0},
	{111,135,159,  0},{107,127,155,  0},{ 99,123,147,  0},{ 91,115,139,  0},
	{ 87,107,131,  0},{ 79, 99,123,  0},{ 75, 95,119,  0},{ 67, 87,111,  0},
	{ 63, 83,103,  0},{ 55, 75, 95,  0},{ 51, 67, 87,  0},{ 47, 63, 83,  0},
	{ 99,131,159,  0},{ 83,119,143,  0},{ 75,107,131,  0},{ 63, 95,119,  0},
	{ 51, 83,103,  0},{ 43, 71, 91,  0},{ 35, 59, 79,  0},{ 27, 51, 67,  0},
	{ 99,127,123,  0},{ 87,115,111,  0},{ 79,107,103,  0},{ 71, 99, 91,  0},
	{ 59, 87, 83,  0},{ 51, 79, 71,  0},{ 43, 71, 63,  0},{ 39, 63, 55,  0},
	{115,255,255,  0},{ 87,219,235,  0},{ 67,187,215,  0},{ 47,155,195,  0},
	{ 31,123,175,  0},{ 19, 91,155,  0},{  7, 67,135,  0},{  0, 43,115,  0},
	{255,255,255,  0},{219,219,255,  0},{187,187,255,  0},{155,155,255,  0},
	{123,123,255,  0},{ 95, 95,255,  0},{ 63, 63,255,  0},{ 31, 31,255,  0},
	{  0,  0,255,  0},{  0,  0,239,  0},{  0,  0,227,  0},{  0,  0,215,  0},
	{  0,  0,203,  0},{  0,  0,191,  0},{  0,  0,179,  0},{  0,  0,167,  0},
	{  0,  0,155,  0},{  0,  0,139,  0},{  0,  0,127,  0},{  0,  0,115,  0},
	{  0,  0,103,  0},{  0,  0, 91,  0},{  0,  0, 79,  0},{  0,  0, 67,  0},
	{255,231,231,  0},{255,199,199,  0},{255,171,171,  0},{255,143,143,  0},
	{255,115,115,  0},{255, 83, 83,  0},{255, 55, 55,  0},{255, 27, 27,  0},
	{255,  0,  0,  0},{227,  0,  0,  0},{203,  0,  0,  0},{179,  0,  0,  0},
	{155,  0,  0,  0},{131,  0,  0,  0},{107,  0,  0,  0},{ 83,  0,  0,  0},
	{255,255,255,  0},{219,235,255,  0},{187,215,255,  0},{155,199,255,  0},
	{123,179,255,  0},{ 91,163,255,  0},{ 59,143,255,  0},{ 27,127,255,  0},
	{ 23,115,243,  0},{ 15,111,235,  0},{ 15,103,223,  0},{ 11, 95,215,  0},
	{  7, 87,203,  0},{  0, 79,195,  0},{  0, 71,183,  0},{  0, 67,175,  0},
	{255,255,255,  0},{215,255,255,  0},{179,255,255,  0},{143,255,255,  0},
	{107,255,255,  0},{ 71,255,255,  0},{ 35,255,255,  0},{  0,255,255,  0},
	{  0, 63,167,  0},{  0, 55,159,  0},{  0, 47,147,  0},{  0, 35,135,  0},
	{ 39, 59, 79,  0},{ 27, 47, 67,  0},{ 19, 35, 55,  0},{ 11, 27, 47,  0},
	{ 83,  0,  0,  0},{ 71,  0,  0,  0},{ 59,  0,  0,  0},{ 47,  0,  0,  0},
	{ 35,  0,  0,  0},{ 23,  0,  0,  0},{ 11,  0,  0,  0},{255,255,  0,  0},
	{ 67,159,255,  0},{ 75,231,255,  0},{255,123,255,  0},{255,  0,255,  0},
	{207,  0,207,  0},{155,  0,159,  0},{107,  0,111,  0},{107,107,167,  0},
};

unsigned char ColorMap[][256]=
{
    {
      0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
     64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
     80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
     96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
    112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
    128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
    144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
    160,161,162,163,164,165,166,167,  4,169,170,171,172,173,174,175,
    176,177,178,179,180,181,182,183,184,185,186,187,188,189, 45, 47,
    192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
      4,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
      4,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
    207,241,242,243,244,245,246,  0,248,249,250,251,252,253,254,255
    },
    {
      0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
     17, 18, 19, 20, 21, 21, 23, 24, 24, 25, 27, 27, 28, 29, 31, 31,
     33, 33, 34, 35, 36, 37, 38, 39, 40, 41, 43, 43, 44, 45, 46, 47,
     49, 50, 51, 52, 53, 54, 55, 55, 57, 58, 59, 60, 61, 62, 63, 64,
     64, 66, 67, 67, 68, 69, 71, 71, 72, 73, 74, 75, 76, 77, 78, 79,
     81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 95,
     97, 97, 98,100,100,101,103,103,  3,105,106,107,108,109,110,111,
    112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
    129,130,131,132,133,134,134,136,136,138,138,139,140,141,143, 13,
    144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
    160,161,162,163,164,165,166,167,  4,169, 16,171,172,173,174,175,
    176,178,179,180,180,181,182,183,184,185,186,187,188,189, 45, 47,
    192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
      4, 49, 52, 54, 57,213,214,215,217,218,219,219,220,221,223,232,
      4,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
    207,241,242,243,244,245,246,  0,248,249,250,251,252,253,254,255
    },
    {
      0,  1,  2,105, 80,  5,  6,  7,  8,  9, 10, 11, 12,236, 14, 15,
     17, 18, 19, 21, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
     33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 44, 46, 47, 47,
     49, 50, 51, 53, 53, 54, 55, 57, 57, 58, 59, 60, 61, 62, 64, 64,
     65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,151, 77, 78, 79,
     82, 83, 84, 85, 86, 87, 87, 89, 90, 91, 92, 92, 93, 95, 95, 96,
     97, 98, 99,100,101,102,103,104,  3,106,106,108,108,109,110,111,
    113,114,115,116,117,118,119,120,121,121,122,123,124,125,126,127,
    129,130,131,132,133,134,135,136,137,138,139,140,141,142,143, 13,
    134,146,138,139,141,149, 14, 77,153,154,155,155,156,157,159,159,
    228,161,162,163,164,165,166,167, 80, 50, 17, 20,172,173,174,175,
    177,178,179,180,181,182,183,184,185,186,187,188,188, 45, 46, 47,
     82,193,194,195,196,197,198,199,201,202,203,203,204,205,206,207,
     80, 50, 52, 55, 58,213,214,216,218,218,219,220,221,222,223,232,
     80, 49,226,227,228,249,230,231,233,234,234,235, 14, 15,238,239,
    207,241,242,243,244,245,246,  0,214,161,250,251,252,253,254,255
    },
    {
      0,  1,  2,106, 81,  5,  6,  7,  8,  9, 10, 11, 12, 14, 15,238,
     18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 28, 29, 30, 32, 32,
     34, 34, 35, 36, 38, 38, 39, 40, 41, 42, 44, 44, 44, 46, 47, 47,
     83, 51, 52, 53, 17, 18, 57, 57, 58, 59, 60, 61, 62, 63, 64, 65,
     66, 67, 68, 69, 69, 70, 72, 72, 73, 74, 75, 76,151, 78, 79, 79,
     83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 92, 93, 94, 95, 96, 97,
     98, 98,100,101,101,102,104,104,105,106,107,108,109,109,111,111,
    113,114,115,116,117,118,119,120,121,122,123,124,124,125,126,127,
    130,131,132,133,134,135,136,137,137,139,139,140,141,142, 13, 13,
    135,146,147,140,149,236, 14, 77,153,154,155,156,157,158,159,  9,
    161,162,163,164,164,165,166,167, 81, 84, 18, 20, 22,173,174,175,
    178,179,180,181,182,182,183,184,185,186,187,188,189, 45, 46, 47,
     83,194,195,195,196,197,198,199,201,202,203,204,205,205,206,241,
     81, 84, 53, 57, 59, 60,214,217,218,219,220,220,222,223,232,233,
     81, 50, 52,227,161,161,230,231,233,234,235,167, 14, 15,238,239,
    241,242,242,243,244,245,246,  0,214,161,250,251,252,253,254,255
    },
    {
      0,  1,  2,106, 82,  5,  6,  7,  8,  9, 10, 11, 12, 14, 15,238,
     19, 20, 21, 21, 23, 23, 24, 25, 27, 28, 28, 29, 30, 31, 32, 33,
     34, 35, 36, 37, 38, 38, 40, 40, 42, 43, 44, 44, 46, 46, 47, 47,
     84, 85, 17, 17, 18, 19, 19, 58, 59, 60, 61, 62, 63, 64, 65, 65,
     66, 68, 68, 69, 70, 71, 72, 73, 73, 74, 75, 76, 77, 78, 79, 79,
     84, 85, 86, 87, 88, 89, 90, 91, 92, 92, 93, 94, 95, 96, 96, 98,
     98, 99,100,101,102,103,104,  3,105,107,107,108,109,110,111,  5,
    114,115,116,117,117,118,119,120,121,122,123,124,124,125,126,127,
    131,131,132,134,135,135,136,137,138,139,140,141,141,143, 13, 13,
    135,146,147,148,149,236, 14, 77,153,155,155,156,157,158,159,  9,
    161,162,163,164,165,166,167,167, 82, 85, 18, 21, 23, 25,174,175,
    178,179,180,181,182,183,184,185,185,186,187,188,189, 45, 46, 47,
     84,194,195,196,196,197,198,199,201,202,203,204,205,206,207,241,
     82, 84, 17, 57, 59, 61, 63,218,219,219,220,221,222,223,232,233,
     82, 84,211,161,161,161,230,231,234,234,235,167, 14, 15, 79,239,
    241,242,243,243,244,245,246,  0, 62,162,250,252,253,253,254,136
    },
    {
      0,  2,  2,106, 83,  5,  6,  7,  8,  9, 10, 11, 12, 14, 15,238,
     19, 21, 21, 23, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
     34, 36, 36, 38, 38, 39, 40, 41, 43, 43, 44, 44, 46, 47, 47, 47,
     86, 86, 87,128,128,128, 20, 59, 60, 61, 61, 62, 64, 65, 66, 66,
     67, 68, 69, 70, 70, 72, 72, 73, 74, 75,150,151, 77, 78, 79,  1,
     85, 86, 87, 88, 89, 90, 91, 92, 93, 93, 94, 95, 96, 97, 97, 98,
     99,100,101,102,102,103,  3,  3,106,107,107,109,109,110,111,  5,
    114,115,116,117,118,119,120,120,121,122,123,124,125,126,126,127,
    131,132,133,134,135,136,137,138,139,140,140,141,142,143, 13, 14,
    136,138,139,148,149,150,151, 15,154,155,156,156,157,158,159,  9,
    161,162,163,164,165,166,167,167, 83, 86, 19, 21, 24, 26,174,179,
    179,180,181,182,183,183,184,185,186,187,188,188,189, 45, 47, 47,
     85, 88,195,196,197,197,198,201,201,202,203,204,205,206,207,241,
     83, 86,128,128, 60, 62, 63,218,219,220,220,222,223,232,233,234,
     83, 85,211,161,161,162,162,231,234,235,167,167, 14,238, 79,239,
    241,242,243,244,244,245,246,  0, 63,162,250,252,253,254,254,136
    },
    {
      0,  2,  2,107, 84,  6,  6,  7,  8, 10, 11, 11, 12, 14, 15,238,
    128, 21, 22, 23, 24,255,255, 27, 28, 28, 30, 30, 31, 32, 34, 34,
     36, 36, 37, 38, 39, 40, 40, 41, 43, 44, 44, 46, 47, 47, 47, 47,
     87, 87,128,128,128,128,129, 60, 60, 61, 62, 64, 65, 65, 66, 67,
     68, 69, 70, 70, 71, 72, 73, 73, 74, 75, 76,151, 77, 78, 79,  1,
     87, 87, 88, 89, 90, 91, 92, 92, 93, 94, 95, 95, 96, 97, 98, 99,
    100,100,101,102,103,104,  3,105,106,107,108,109,109,110,111,  5,
    115,116,117,117,118,119,120,121,122,122,123,124,125,126,127,127,
    132,133,134,135,136,136,137,138,139,140,141,142,142, 13, 14, 14,
    146,147,140,141,143,150,237, 78,154,155,156,157,158,159,  9,  9,
    161,162,163,164,165,166,167,167, 84, 87,128, 22, 25, 27, 29,180,
    180,181,182,182,183,184,185,185,186,187,188,189, 45, 46, 47, 47,
     87, 89,195,196,197,198,198,202,202,203,204,204,205,206,207,241,
     84, 87,128,128, 61, 63, 64,219,220,220,222,222,232,232,233,234,
     84, 86,128,161,162,162,162,231,234,235,167,167,237,238,239,  1,
    241,242,243,244,245,245,246,  0, 63,162,250,252,253,254,254,137
    },
    {
      0,  2,  2,107, 86,  6,  6,  7,  8, 10, 11, 12, 12, 15, 15,238,
    129,130, 23,255,255,255,255, 28, 28, 29, 30, 31, 32, 33, 34, 34,
     36, 36, 38, 38, 40, 40, 41, 43, 44, 44, 46, 46, 47, 47, 47, 47,
     88, 89,128,128,128,129,129,130, 61, 62, 64, 64, 65, 66, 67, 68,
     68, 69, 70, 71, 72, 73, 73, 74, 74, 75, 76, 77, 77, 78, 79,  1,
     87, 89, 90, 90, 91, 92, 92, 93, 94, 95, 96, 96, 97, 98, 98, 99,
    101,101,102,103,103,  3,105,106,107,108,108,109,109,110,  5,  5,
    115,116,117,118,119,119,120,121,122,122,123,124,125,126,127,127,
    133,134,135,136,136,137,138,139,140,141,141,142,143, 13, 14, 14,
    137,139,140,141,236, 14, 15, 78,155,155,156,157,158,159,  9,  9,
    162,163,163,164,165,166,167,167, 86, 89,128, 23, 25, 28, 30,180,
    180,181,182,183,184,184,185,186,186,187,188,189, 45, 46, 47, 47,
     88, 90, 92,196,197,198,198,202,202,203,204,205,205,206,207,241,
     86, 88,128,129, 61, 63,164,220,220,221,222,223,232,233,234,234,
     86, 87,128,128,162,162,162,163,235,167,167,167, 15,238,239,  1,
    241,242,243,244,245,245,246,  0, 64,162, 21,252,253,254,254,137
    },
    {
      0,  2,  2,108, 87,  6,  7,  8,  8, 10, 11, 12, 12, 15,238, 79,
    129,130,131,255,255,255,255, 28, 29, 30, 31, 31, 32, 34, 34, 36,
     36, 37, 38, 39, 40, 40, 43, 44, 44, 44, 46, 47, 47, 47, 47, 47,
     89,128,128,128,129,129,130,130, 62, 64, 64, 65, 66, 67, 68, 68,
     69, 70, 71, 72, 72, 73, 74, 74, 75, 76,151, 77, 78, 79, 79,  1,
     89, 90, 91, 91, 92, 93, 93, 94, 95, 96, 97, 97, 98, 99, 99,100,
    101,101,102,103,104,  3,106,106,107,108,109,109,110,111,  5,  5,
    116,117,117,118,119,120,121,121,122,123,124,124,125,126,127,127,
    134,134,135,136,137,138,139,140,140,141,142,143, 13, 14, 14, 15,
    138,139,141,149,236, 14, 15, 78,155,156,156,157,158,159,  9,  9,
    162,163,164, 69,165,166,167, 44, 87,128,129, 24, 26, 29, 31,181,
    181,182,183,183,184,185,185,186,187,188,189,189, 45, 47, 47, 47,
     89, 91, 93,196,197,198,202,202,202,203,204,205,206,206,207,242,
     87, 89,128,130, 62, 64,164,220,221,222,223,232,233,234,234,235,
     87, 88,128,128,162,162,163,163,167,167,167, 41, 15,238,239,  1,
    242,242,243,244,245,245,246,  0, 65,163, 21,252,253,254,254,138
    },
    {
      0,  2,  2,108, 88,  6,  7,  8,  8, 10, 11, 12, 12, 15,238, 79,
    130,131,255,255,255,255, 28, 28, 69, 31, 70, 71, 34, 34, 36, 36,
     37, 38, 38, 40, 40, 41, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47,
     90,128,129,129,130,130,131,131, 64, 64, 65, 66, 67, 68, 68, 69,
     70, 71, 71, 72, 73, 73, 74, 74, 75, 76,237, 77, 78, 79, 79,  1,
     90, 91, 92, 92, 93, 94, 94, 95, 96, 96, 97, 98, 99, 99,100,101,
    102,102,103,104,  3,105,106,106,107,108,109,110,110,111,  5,  5,
    116,117,118,119,119,120,121,122,122,123,124,124,125,126,127,127,
    134,135,136,137,138,138,139,140,141,142,142,143, 13, 14, 14, 15,
    138,140,141,142,150,151, 15, 78,155,156,157,158,159,  9,  9,  9,
    162,163,164, 69, 72,166,167, 44, 88,128,130,255, 27, 29, 31,182,
    182,183,183,184,185,185,186,187,187,188,189, 45, 46, 47, 47, 47,
     90, 92, 94, 96,197,198,203,203,203,204,204,205,206,207,207,242,
     88,128,129,131, 64, 65,164,220,165,223,232,232,166,234,234,167,
     88,128,128,129,162,163,163,163,167,167,167, 41, 15, 79,239,  1,
    242,243,243,244,245,245,246,  0,164,163, 93,252,253,254,254,139
    },
    {
      0,  2,  7,108, 89,  6,  7,  8,  8, 10, 11, 12, 12, 15,238, 79,
    131,255,255,255,255,255, 28, 69, 70, 70, 71, 71, 34, 34, 36, 36,
     38, 38, 39, 40, 40, 43, 44, 44, 44, 46, 47, 47, 47, 47, 47, 47,
     91,129,130,130,131,131,132,144,144, 65, 66, 67, 68, 68, 69, 70,
     70, 71, 72, 73, 73, 74, 74, 75, 76, 76, 77, 78,238, 79,  1,  1,
     91, 92, 93, 93, 94, 95, 95, 96, 97, 97, 98, 98, 99,100,101,101,
    102,103,104,  3,  3,106,106,107,108,109,109,110,110,111,  5,  5,
    117,118,118,119,120,121,121,122,123,123,124,125,125,126,127,127,
    135,136,137,137,138,139,140,140,141,142,142, 13, 13, 14, 15, 15,
    139,140,141,143, 14,151, 78, 79,156,157,157,158,159,  9,  9,111,
    163,163,164, 69, 72,167,167, 44, 89, 92,131,255, 28, 29, 32,182,
    182,183,184,184,185,186,186,187,188,189,189, 45, 46, 47, 47, 47,
     91, 93, 95, 97, 99,198,203,203,203,204,205,205,206,207,241,242,
     89, 92,130,131, 65, 66, 67,165,165,232,166,166,166,234,167,167,
     89,128,129,130,163,163,163,163,167,167,167, 42, 78, 79,  1,  1,
    242,243,243,244,245,246,246,  0,164,163,255,253,253,254,254,139
    },
    {
      0,  2,  7,109, 91,  6,  7,  8,  8, 10, 11,127, 12, 78, 79, 79,
    255,255,255,255,255,136,137, 70, 70, 71, 72, 72, 73, 73, 36, 38,
     38, 38, 40, 40, 44, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47,
     92,130,130,131,131,132,144,144, 65, 66, 67, 68, 69, 69, 70, 70,
     71, 72, 73, 73, 73, 74, 75,150, 76,237, 77, 78,238, 79,  1,  1,
     92, 93, 94, 94, 95, 96, 96, 97, 98, 98, 99, 99,100,101,101,102,
    103,103,104,  3,105,106,107,107,108,109,109,110,111,  5,  5,  5,
    117,118,119,120,120,121,122,122,123,123,124,125,125,126,127,  7,
    136,136,137,138,139,140,140,141,142,143,143, 13, 14, 14, 15, 15,
    140,141,142, 13, 14, 15, 78, 79,156,157,157,158,159,  9,  9,111,
    163,145, 69, 71, 73,167,167, 44, 91, 93,132,255, 28, 30, 33,183,
    183,184,184,185,185,186,187,187,188,189, 45, 45, 47, 47, 47, 47,
     92, 94, 96, 98,100,203,203,203,203,204,205,206,206,207,241,242,
     91, 92,131,144, 65, 67,165,165,165,232,166,166,166,167,167,167,
     91,129,130,131,163,163,163,164,167,167,167, 43, 78, 79,  1,  1,
    242,243,244,244,245,246,246,  0, 67,163,255,253,253,254,254,140
    },
    {
      0,  2,  7,109, 92,  6,  7,  8,  8,  5, 11, 12,  8, 78, 79, 79,
    255,255,255,136,136,137,138, 70, 71, 71, 73, 73, 73, 73, 38, 38,
     38, 40, 40, 43, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47, 47,
     94,131,131,132,132,133,144,134,145, 67, 68, 69, 69, 70, 71, 71,
     72, 73, 73, 73, 74, 75,150, 76, 76,237, 15, 78, 79, 79,  1,  1,
     93, 94, 95, 95, 96, 97, 97, 98, 99, 99,100,100,101,102,102,103,
    104,104,  3,105,106,107,107,108,109,109,110,110,111,  5,  5,  6,
    118,119,119,120,121,121,122,122,123,124,124,125,126,126,127,  8,
    137,137,138,139,140,140,141,142,142,143, 13, 14, 14, 15, 15, 78,
    140,141,143,236,151, 15, 78, 79,156,157,158,159,  9,  9, 10, 10,
    144,145, 69, 72, 73, 75, 76, 44, 92, 94,133,255, 29, 31, 33,184,
    184,184,185,185,186,187,187,188,188,189, 45, 46, 47, 47, 47, 47,
     93, 95, 97, 99,101,204,204,204,204,205,205,206,206,207,241,243,
     92, 94,132,144, 67, 68,165,165,166,166,166,166,166,167,167,167,
     92,130,131,144,163,163,164,164,167,167, 43, 44, 78, 79,  1,  2,
    243,243,244,244,245,246,246,  0, 68,164,255,253,254,254,109,140
    },
    {
      0,  2,  7,109, 93,  6,  7,  8,  8,  5, 11, 12,  8,238, 79,  1,
    255,135,136,136,137,138,139,139,139, 72, 73, 73, 73, 74, 38, 38,
     40, 40, 40, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47, 47,  2,
     95,132,132,133,133,134,135,145,145, 68, 69, 69, 70, 71, 71, 72,
     72, 73, 73, 74, 74,150, 76, 76,237, 15,238, 78, 79,  1,  1,  1,
     95, 95, 96, 96, 97, 98, 98, 99, 99,100,101,101,102,102,103,103,
    104,  3,105,106,106,107,108,108,109,110,110,111,111,  5,  5,  6,
    118,119,120,120,121,122,122,123,123,124,124,125,126,126,127,  8,
    137,138,139,140,140,141,141,142,143, 13, 13, 14, 14, 15, 78, 78,
    141,142, 13, 14, 15, 78, 79, 79,157,158,158,159,  9,  9, 10, 10,
    145,145, 69, 72, 74, 76, 77,239, 93, 95,133,136, 30, 32, 34,184,
    184,185,185,186,186,187,188,188,189, 45, 45, 47, 47, 47, 47,  2,
     95, 96, 98,100,101,204,204,204,204,205,205,206,207,207,242,243,
     93, 95,133,134, 67, 68,165,165,166,166,166,166,167,167,167,167,
     93, 94,132,144,145,164,164,164,167,167, 43, 44, 79, 79,  1,  2,
    243,243,244,245,245,246,246,  0, 69,164,255,253,254,254,109,141
    },
    {
      0,  2,  8,110, 94,  6,  7,  8,  8,126, 11,127,  8, 79, 79,  1,
    135,136,136,137,138,138,139,139, 73, 73, 73, 73, 74,236, 14, 14,
    237, 40, 44, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47,  2,  2,
     96,133,133,134,134,135,135,136,146, 69, 69, 70, 71, 72, 72, 73,
     73, 74, 74, 74, 75, 76, 76,237,237, 15,238, 79, 79,  1,  1,  2,
     96, 96, 97, 97, 98, 99, 99,100,100,101,101,102,102,103,103,104,
      3,105,106,107,107,108,108,109,109,110,110,111,  5,  5,  6,  6,
    119,120,120,121,121,122,123,123,124,124,125,125,126,127,127,  8,
    138,139,140,140,141,142,142,143, 13, 13, 14, 14, 15, 15, 78,238,
    141,143, 13, 14, 15, 78, 79, 79,157,158,159,159,  9,110, 10,  5,
    145,146, 71, 72, 74, 76, 77,239, 94, 96,135,136, 31, 33, 35, 37,
    185,185,186,186,187,188,188,189,189, 45, 46, 47, 47, 47, 47,  2,
     96, 98, 99,101,102,204,204,204,204,205,206,206,207,241,242,243,
     94, 96,134,135,146, 69, 70,166,166,166,166,167,167,167,167,167,
     94, 95,144,145,145,164,164,164,167, 43, 44, 44, 79,  1,  1,  2,
    243,244,244,245,245,246,246,  0, 70,164,255,253,254,254,110,142
    },
    {
      0,  7,  8,110, 95,  7,  7,  8,  8, 11,127,127,  8, 79, 79,  1,
    136,136,137,138,139,139,140,141,141, 73,143,143, 13,236, 14, 14,
     15, 15, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47, 47,  2,  2,
     97, 98,134,135,135,136,136,146,146,147,147, 71, 72, 72, 73, 73,
     74, 74, 74, 75,150, 76,237,237, 15,238,238, 79, 79,  1,  1,  2,
     97, 97, 98, 98, 99,100,100,101,101,101,102,102,103,104,104,  3,
    105,106,106,107,107,108,109,109,110,110,111,  5,  5,  5,  6,  6,
    120,120,121,121,122,122,123,123,124,124,125,125,126,127,127,  8,
    139,140,140,141,142,142,143, 13, 13, 14, 14, 15, 15, 78, 78, 79,
    142, 13, 14,151, 15, 78, 79,  1,158,159,159,  9,  9,111, 10,  5,
    145,147, 72, 73, 75, 76,238,239, 95, 98,136,137, 70, 34, 35, 37,
    185,186,186,187,188,188,189,189, 45, 46, 47, 47, 47, 47, 47,  2,
     97, 98,100,101,103,205,205,205,205,205,206,206,207,241,242,243,
     95, 97,135,136, 69, 70, 71,166,166,166,167,167,167,167,167,167,
     95, 97,152,145,145,164,164,165, 43, 44, 44, 44, 79,  1,  1,  2,
    243,244,244,245,245,246,246,  0, 71, 69, 99,253,254,254,110,142
    },
    {
      0,  7,  8,110, 97,  7,  7,  8,  8, 11,127,127,  8, 79,  1,  1,
    137,137,138,139,139,140,141,141,142,142,143, 13,236, 14, 14,237,
     15, 15,238, 44, 44, 47, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,
     98,152,136,136,136,137,137,137,147,147, 71, 72, 72, 73, 73, 73,
     74, 75,150,150, 76,237,237, 15, 15,238, 79, 79, 79,  1,  1,  2,
     98, 98, 99, 99,100,101,101,101,102,102,103,103,104,  3,  3,105,
    106,106,107,108,108,109,109,109,110,111,111,  5,  5,  5,  6,  6,
    120,121,121,122,122,123,123,124,124,124,125,126,126,127,127,  8,
    140,140,141,142,142,143, 13, 13, 14, 14, 14, 15, 15, 78, 79, 79,
    143, 13, 14, 15, 78, 79, 79,  1,158,159,159,  9,110,111, 10,  5,
    146,147, 72, 74, 75, 76,238,239, 97, 98,136,138, 71, 34, 36, 38,
    186,187,187,188,188,189,189, 45, 45, 46, 47, 47, 47, 47,  2,  2,
     98, 99,101,102,104,205,205,205,205,206,206,207,207,241,242,243,
     97, 98,136,137,147, 71, 72,166,166,167,167,167,167,167,167, 43,
     97,152,152,145,146, 69,165,165, 44, 44, 44, 47, 79,  1,  1,  2,
    243,244,244,245,245,246,246,  0, 72, 69,100,254,254,254,111,143
    },
    {
      0,  7,  8,111, 98,  7,  7,  8,  0,  6,127,  7,  8, 79,  1,  1,
    138,139,139,140,140,141,141,142,143, 13, 13, 13, 14, 14, 15, 15,
     15,238,238,238,239,239,239, 47, 47, 47, 47,  2,  2,  2,  2,  2,
     99,100,136,137,137,138,138,138,139,139,148, 73, 73, 73, 74, 74,
     75,150, 76, 76,237,237, 15, 15,238,238, 79, 79,  1,  1,  2,  2,
     99,100,100,100,101,101,102,102,103,103,104,104,  3,105,105,106,
    107,107,108,108,109,109,109,110,110,111,  5,  5,  5,  6,  6,  6,
    121,121,122,122,122,123,123,124,124,125,125,126,126,127,127,  8,
    141,141,142,142,143, 13, 13, 14, 14, 15, 15, 15, 78, 79, 79, 79,
     13, 14, 14, 15, 78, 79,  1,  1,159,159,  9,  9,111, 10,  5,  5,
    147,148, 73, 74, 76, 77,238,239, 98,100,137,139, 72, 36, 37, 39,
    187,187,188,188,189,189, 45, 45, 46, 47, 47, 47, 47, 47,  2,  2,
     99,101,102,103,  3,205,205,205,205,206,206,207,241,242,243,244,
     98, 99,137,138,147, 72, 73,166,167,167,167,167,167,167, 44, 44,
     98,152,153,146,147,147,165,165, 44, 44, 44, 47, 79,  1,  2,  2,
    244,244,245,245,246,246,  0,  0, 72, 71,101,254,254,254,111, 13
    },
    {
      0,  7,  8,111, 99,  7,  8,  8,  0,  6,127,  7,  8,  1,  1,  1,
    139,139,140,141,141,142,142,143, 13, 13, 14, 14, 14, 15, 15, 15,
    238,238,238,239,239,239,239,239,239,239,  2,  2,  2,  2,  2,  2,
    100,101,137,138,138,139,139,139,140,148, 73, 73, 74, 74, 74, 75,
    150, 76, 76,237,237, 15,238,238,238, 79, 79,  1,  1,  1,  2,  2,
    100,101,101,101,102,102,103,103,104,104,  3,  3,105,106,106,107,
    107,108,108,109,109,109,110,110,111,  5,  5,  5,  5,  6,  6,  6,
    121,121,122,122,123,123,124,124,125,125,125,126,127,127,  7,  8,
    141,142,142,143, 13, 13, 14, 14, 15, 15, 15, 78,111, 79, 79,  5,
     13, 14, 15, 78, 79, 79,  1,  1,159,  9,  9,110,111,  5,  5,  1,
    147,148, 74, 75, 76, 77,239,239, 99,101,139,140, 73, 36, 38, 40,
    187,188,188,189,189, 45, 45, 46, 47, 47, 47, 47, 47,  2,  2,  2,
    100,101,103,104,105,206,206,206,206,206,207,207,241,242,243,244,
     99,100,138,139,148, 73, 73,167,167,167,167,167,167, 44, 44, 44,
     99,153,153,147,147, 72, 72,166, 44, 44,239, 47,  1,  1,  2,  2,
    244,244,245,245,246,246,  0,  0, 73, 72,102,254,254,109,111, 14
    },
    {
      0,  8,  8,  5,100,  7,  8,  8,  0,  6,127,  8,  8,  1,  1,  2,
    140,140,141,142,142,142,143, 13, 14, 14, 14, 14, 15, 15,238,238,
    238,238,239,239,239,239,239,239,  1,  2,  2,  2,  2,  2,  2,  2,
    101,102,139,139,139,140,140,140,141,141,149,149, 74,150,150,150,
     76,237,237, 15, 15,238,238,238, 79, 79,239,  1,  1,  2,  2,  2,
    101,102,102,102,103,104,104,104,  3,  3,105,106,106,107,107,108,
    108,108,109,109,109,110,110,111,111,  5,  5,  5,  6,  6,  6,  7,
    122,122,122,123,123,124,124,124,125,125,126,126,127,127,  8,  8,
    142,143, 13, 13, 14, 14, 14, 15, 15,110, 78, 79, 79, 79,  5,  1,
     14, 15, 15, 78, 79, 79,  1,  1,109,  9,110,111,  5,  5,  1,  6,
    148,148, 75, 76, 77,238,239,239,100,102,140,141, 73, 38, 39, 41,
    188,188,189,189, 45, 45, 46, 47, 47, 47, 47, 47, 47,  2,  2,  2,
    101,103,104,  3,106,206,206,206,206,207,207,241,242,242,243,244,
    100,101,139,140,148, 73, 74,167,167,167,167,167, 44, 44, 44, 44,
    100,154,154,147,148,148, 72,166,239,239,239, 47,  1,  1,  2,  2,
    244,244,245,245,246,246,  0,  0, 74,148,103,254,254,110,  5, 14
    },
    {
      0,  8,  8,  5,101,  7,  8,  8,  0,  6,  7,  8,  8,  1,  1,  2,
    141,141,142,142,143, 13, 13, 14, 14, 14, 15, 15, 15,238,238,238,
    239,239,239,239,239,239,239,  1,  2,  2,  2,  2,  2,  2,  2,  2,
    102,103,140,140,140,141,141,141,149,149,143,236,150,150, 76, 14,
    237, 15, 15, 15,238,238,238, 79, 79,239,  1,  1,  1,  2,  2,  2,
    102,103,103,104,104,  3,  3,105,105,106,106,106,107,107,108,108,
    109,109,109,110,110,110,111,111,  5,  5,  5,  6,  6,  6,  6,  7,
    122,122,123,123,124,124,124,125,125,125,126,126,127,127,  8,  8,
    143, 13,107,108, 14,109,109, 15,110,110,111, 79, 79,  5,  1,  1,
     14, 15, 78, 79, 79,  1,  1,  2,  9,110,111,111,  5,  5,  1,  6,
    148,149, 75, 76, 77,238,239,239,101,103,141,142,143,150, 40, 41,
    189,189, 45, 45, 45, 46, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,
    102,104,  3,106,107,206,206,206,206,207,241,241,242,243,244,244,
    101,103,140,141,149, 74, 75,167,167,167, 76, 77,238, 44,239,239,
    101,155,155,148,148,148, 74, 74,239,239,239,239,  1,  2,  2,  2,
    244,245,245,245,246,246,  0,  0, 74, 74,104,254,254,110,  5, 15
    },
    {
      0,  8,  8,  5,103,  7,  8,  8,  0,127,  7,  8,  8,  1,  2,  2,
    142,142,143, 13, 13, 13, 14, 14, 15, 15, 15, 15,238,238,238,239,
    239,239,239,239,239,239,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,
    104,104,  3,141,141,142,142,142,143, 13,236,150, 14, 14,237,237,
     15, 15,238,238,238,238, 79, 79,239,  1,  1,  1,  2,  2,  2,  7,
    104,104,  3,  3,  3,105,106,106,106,107,107,107,108,108,108,109,
    109,109,110,110,110,111,  5,  5,  5,  5,  5,  6,  6,  6,  7,  7,
    123,123,123,124,124,124,125,125,125,126,126,127,127,127,  8,  8,
    107,108,108,109,109,109,110,110,110,111,111, 79,  5,  1,  1,  1,
     15, 78, 78, 79,  1,  1,  1,  2,110,111,111,  5,  5,  5,  6,  6,
    149, 75, 76, 77,238,239,239,  1,103,104,142,143, 13, 14, 40, 43,
    189, 45, 45, 46, 46, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,
    104,  3,106,107,108,207,207,207,207,207,241,242,242,243,244,244,
    103,104,141,142,143, 75, 76, 76, 76, 77, 77,238,238,239,239,239,
    103,155,156,156,149, 74, 75, 75,239,239,239,239,  1,  2,  2,  7,
    244,245,245,246,246,246,  0,  0, 75, 74,105,254,254,111,  5, 15
    },
    {
      0,  8,  8,  5,104,  8,  8,  0,  0,  7,  7,  8,  8,  2,  2,  2,
    143, 13, 13, 14, 14, 14, 15, 15, 15, 15,238,238,238,238,239,239,
    239,239,239,239,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
      3,105,105,142,142,143,143, 13, 13,236, 14, 14,237, 15, 15, 15,
     15,238,238,238, 79, 79,239,239,  1,  1,  1,  1,  2,  2,  2,  7,
      3,105,105,106,106,106,107,107,107,108,108,108,109,109,109,109,
    110,110,110,111,111,  5,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,
    123,123,124,124,124,125,125,125,126,126,126,127,127,127,  8,  8,
    108,109,109,109,110,110,110,111,111,111,  5,  5,  5,  1,  1,  1,
     78, 78, 79, 79,  1,  1,  2,  2,111,111,  5,  5,  5,  6,  6,  6,
    149, 75,151, 77,238,239,239,  2,104,105,143, 13, 14, 15, 44, 44,
     45, 45, 46, 47, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,  2,
      3,106,107,108,109,207,207,207,207,241,242,242,243,243,244,245,
    104,  3,142,143,236, 76, 76, 77, 77,238,238,238,239,239,239,239,
    104,  3,156,157, 75, 75, 75, 75,239,239,239,  1,  2,  2,  2,  8,
    245,245,245,246,246,246,  0,  0, 76, 75,106,254,109,111,  6,238
    },
    {
      0,  8,  8,  6,105,  8,  8,  0,  0,  7,  8,  8,  0,  2,  2,  2,
     13, 14, 14, 14, 14, 15, 15, 15,238,238,238,238,239,239,239,239,
    239,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,
    106,106,106, 13, 13, 13, 13, 14, 14, 14,237, 15, 15, 15,238,238,
    238,238, 79, 79,239,239,  1,  1,  1,  1,  1,  2,  2,  2,  7,  8,
    106,106,106,107,107,107,108,108,108,109,109,109,109,110,110,110,
    110,111,111,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,  7,
    124,124,124,124,125,125,125,126,126,126,127,127,127,  8,  8,  8,
    109,109,110,110,110,111,111,111,  5,  5,  5,  1,  1,  1,  6,  2,
     78, 79, 79,  1,  1,  1,  2,  2,111,  5,  5,  5,  6,  6,  6,127,
     75,151, 77, 78, 79,239,  1,  2,105,106, 13, 14, 15, 15, 44, 44,
     46, 47, 47, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,  2,  8,
    106,107,108,109,109,241,241,241,241,242,242,243,243,244,244,245,
    105,106, 13, 13, 14,237, 77,238,238,238,239,239,239,239,239,239,
    105,106,157,158, 75, 75, 76, 76,239,239,  1,  2,  2,  2,  7,  8,
    245,245,245,246,246,246,  0,  0,237, 76,107,254,110,  5,  6,111
    },
    {
      0,  8,  8,  6,106,  8,  8,  0,  0,  7,  8,  8,  0,  2,  2,  7,
     14, 14, 15, 15, 15, 15,238,238,238,238,239,239,239,239,239,  1,
      1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,
    107,107,108,108, 14, 14, 14, 14, 15, 15, 15, 15,238,238,238,238,
     79, 79, 79,239,  1,  1,  1,  1,  1,  2,  2,  2,  2,  7,  7,  8,
    107,107,108,108,108,108,109,109,109,109,109,110,110,110,110,111,
    111,111,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,  7,  7,
    124,124,125,125,125,125,126,126,126,126,127,127,127,  8,  8,  8,
    110,110,110,111,111,111,  5,  5,  5,  5,  1,  1,  1,  6,  2,  2,
     79, 79,  1,  1,  1,  2,  2,  2,  5,  5,  5,  6,  6,  6,127,  7,
    151, 77, 78, 79,239,  1,  1,  2,106,107, 14, 15, 15,238,239, 47,
     47, 47, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,  2,  8,  8,
    107,108,109,109,110,242,242,242,242,242,243,243,244,244,245,245,
    106,107,108, 14, 15, 15,238,238,239,239,239,239,239,239,239,239,
    106,107,158,159,151,151, 77, 77,239,  1,  2,  2,  2,  2,  7,  8,
    245,245,246,246,246,246,  0,  0, 77,151,108,110,111,  5,  6,111
    },
    {
      0,  8,  0,  6,108,  8,  8,  0,  0,  7,  8,  8,  0,  2,  7,  7,
    109, 15,110,110,238,238,238,239,239,239,239,239,  1,  1,  1,  1,
      1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,
    108,109,109,109,109, 15, 15, 15, 15,238,238,238,238, 79, 79,239,
    239,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  7,  7,  8,  8,
    108,108,109,109,109,109,109,110,110,110,110,110,111,111,111,  5,
      5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  7,  7,  7,  7,  8,
    125,125,125,125,126,126,126,126,127,127,127,127,  7,  8,  8,  0,
    111,111,111,111,  5,  5,  5,  5,  1,  1,  1,  6,  6,  2,  2,  2,
      5,  1,  1,  1,  2,  2,  2,  7,  5,  6,  6,  6,  6,  7,  7,  7,
      9, 78, 78, 79,  1,  1,  2,  2,108,109,109, 15,238,238,239, 47,
     47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,
    108,109,109,110,111,242,242,242,242,243,243,244,244,244,245,245,
    108,108,109, 15, 15,238,238,239,239,239,239,239,239,239,  1,  1,
    108,108,159,  9, 77, 77, 78, 78,  1,  2,  2,  2,  2,  7,  8,  8,
    245,246,246,246,246,  0,  0,  0,238, 78,109,110,  5,  5,  6,  5
    },
    {
      0,  8,  0,  7,109,  8,  8,  0,  0,  8,  8,  8,  0,  7,  7,  8,
    110,111,111,111,111, 79,239,239,  1,  1,  1,  1,  1,  1,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,  8,  8,  8,
    109,109,110,110,110,110,238,238,238, 79, 79, 79, 79,239,  1,  1,
      1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  7,  7,  8,  8,  8,
    109,109,110,110,110,110,110,111,111,111,111,  5,  5,  5,  5,  5,
      5,  5,  6,  6,  6,  6,  6,  6,  6,  7,  7,  7,  7,  7,  8,  8,
    125,125,126,126,126,126,126,127,127,127,127,127,  8,  8,  8,  0,
    111,  5,  5,  5,  5,  5,  1,  1,  6,  6,  6,  2,  2,  2,  7,  7,
      1,  1,  1,  2,  2,  2,  7,  7,  6,  6,  6,  6,  7,  7,  7,  7,
     78, 79, 79,  1,  1,  2,  2,  2,109,109,110,238,239,239,239, 47,
     47, 47, 47,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,
    109,110,110,111,  5,243,243,243,243,243,244,244,244,245,245,246,
    109,109,110, 78,238, 79,239,239,239,239,239,  1,  1,  1,  2,  2,
    109,109,  9,  9, 78, 78, 78, 78,  2,  2,  2,  2,  7,  7,  8,  8,
    246,246,246,246,246,  0,  0,  0,239, 78,110,111,  5,  6,  7,  1
    },
    {
      0,  8,  0,  7,110,  8,  0,  0,  0,  8,  8,  0,  0,  7,  8,  8,
    111,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,  8,  8,  8,  8,  0,
    110,111,111,111,111,111, 79, 79, 79, 79,  1,  1,  1,  1,  1,  1,
      1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  7,  7,  8,  8,  8,  8,
    110,111,111,111,111,111,  5,  5,  5,  5,  5,  5,  5,  5,  5,  6,
      6,  6,  6,  6,  6,  6,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,
    126,126,126,126,126,127,127,127,127,127,  7,  8,  8,  8,  0,  0,
      5,  5,  5,  6,  6,  6,  6,  6,  6,  2,  2,  2,  7,  7,  7,  7,
      6,  6,  2,  2,  7,  7,  8,  8,  6,  6,  6,  7,  7,  7,  7,  8,
     10, 79,  1,  1,  2,  2,  2,  2,110,111,111,  5,  1,  1,  1,  2,
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,  8,  0,
    110,111,111,  5,  5,244,244,244,244,244,244,245,245,245,245,246,
    110,110,111, 79, 79,239,239,  1,  1,  1,  1,  2,  2,  2,  2,  2,
    110,110,111, 10, 10, 10, 10, 10,  2,  2,  2,  2,  7,  8,  8,  8,
    246,246,246,246,  0,  0,  0,  0,239, 79,111,  5,  6,  6,  7,  6
    },
    {
      0,  0,  0,  7,111,  0,  0,  0,  0,  8,  8,  0,  0,  8,  8,  8,
      5,  5,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,
      5,  5,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  7,  7,  7,  8,  8,  8,  8,  8,  8,
      5,  5,  5,  5,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,
    126,126,127,127,127,127,127,127,  7,  8,  8,  8,  8,  8,  0,  0,
      6,  6,  6,  6,  6,  6,  2,  7,  7,  7,  7,  7,  7,  7,  8,  8,
      2,  2,  7,  7,  7,  8,  8,  8,  7,  7,  7,  7,  7,  8,  8,  8,
      1,  1,  1,  2,  2,  2,  2,  8,111,  5,  5,  1,  1,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,  8,  8,  0,  0,
      5,  5,  5,  6,  6,244,244,244,244,245,245,245,245,246,246,246,
    111,  5,  5,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    111,  5,  5,  1,  1,  1, 11, 11,  2,  2,  2,  8,  8,  8,  8,  0,
    246,246,246,246,  0,  0,  0,  0,  1,  1,  5,  6,  6,  7,  7,  2
    },
    {
      0,  0,  0,  8,  5,  0,  0,  0,  0,  8,  0,  0,  0,  8,  8,  8,
      6,  6,  6,  2,  2,  2,  2,  2,  2,  2,  7,  7,  7,  7,  7,  7,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      6,  6,  6,  6,  6,  6,  6,  6,  2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,
      6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  0,
    127,127,127,127,127,  7,  7,  8,  8,  8,  8,  8,  8,  0,  0,  0,
      6,  6,  7,  7,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,
      7,  7,  7,  8,  8,  8,  8,  8,  7,  7,  7,  8,  8,  8,  8,  8,
      1,  2,  2,  2,  2,  8,  8,  8,  5,  6,  6,  6,  2,  2,  2,  2,
      2,  2,  2,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      6,  6,  6,  6,  6,245,245,245,245,245,245,245,246,246,246,246,
      5,  6,  6,  6,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,
      5,  6,  6,  1,  1, 11, 11, 12,  8,  8,  8,  8,  8,  8,  0,  0,
    246,246,246,  0,  0,  0,  0,  0,  2,  2,  6,  6,  7,  7,  8,  7
    },
    {
      0,  0,  0,  8,  6,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0,  0,
      7,  7,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      6,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      6,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,
      7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  0,  8,  8,  8,  8,  8,  8,  8,  0,
      2,  7,  7,  8,  8,  8,  8,  0,  6,  7,  7,  7,  7,  7,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      7,  7,  7,  7,  7,246,246,246,246,246,246,246,246,246,246,  0,
      6,  6,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      6,  6,  7,  2,  2,  2, 12, 12,  8,  8,  8,  0,  8,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  7,  2,  7,  7,  8,  8,  8,  8
    },
    {
      0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  0,  0,  0,  0,  8,  8,  8,  8,  8,  8,  8,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,246,246,246,246,246,246,246,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  8,  8,  8,  8,  8,  0,  0,  8
    },
    {
      4, 81, 80, 89,  0, 81, 80, 80,  4, 85, 83, 81, 80, 87, 86, 84,
    109,108,106,  3,104,102,101,100, 98, 97, 96, 95, 94, 93, 92, 91,
     90, 89, 88, 87, 87, 86, 85, 85, 84, 83, 82, 82, 82, 81, 81, 80,
      7,  6,  6,  5,111,110,109,109,108,106,105,104,103,101,100,100,
     98, 97, 96, 96, 95, 94, 92, 92, 91, 89, 88, 87, 86, 85, 84, 83,
      7,  6,  5,  5,110,109,109,107,106,105,104,103,102,101,100, 99,
     98, 97, 96, 95, 94, 93, 92, 91, 90, 88, 88, 87, 86, 85, 84, 83,
    108,106,104,102,100, 98, 96, 95, 93, 91, 89, 87, 85, 83, 81, 80,
    104,103,101,100, 99, 98, 97, 96, 95, 93, 93, 92, 91, 90, 88, 88,
     98, 96, 95, 93, 91, 89, 87, 85, 96, 95, 93, 92, 90, 89, 87, 86,
      7,109,105,101, 97, 93, 90, 86,  0,  6,110,106,102, 99, 96, 92,
     89, 88, 87, 87, 87, 86, 85, 85, 84, 84, 83, 83, 82, 81, 81, 80,
      7,110,106,102, 98, 94, 90, 87, 83, 82, 82, 81, 81, 80, 80, 80,
      0,  7,  5,110,108,105,103,101, 99, 98, 97, 96, 95, 93, 92, 91,
      0,  0,  8,  7,  7,  6,  5,  5, 91, 89, 88, 87, 87, 85, 83, 82,
     80, 80, 80,  4,  4,  4,  4,  4,  3,111,105, 95, 91, 88, 85, 97
    },
    {
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
    }
};

unsigned char FontPic33[72]=
{
      4,  0,  7,  0,  0,  0,  0,  0, 24,  0,  0,  0, 36,  0,  0,  0,
     48,  0,  0,  0, 60,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191,191,191,255,  0,  7,191,191,177,181,181,191,181,191,191,255,
      0,  7,191,191,177,178,177,191,179,191,191,255,  0,  7,191,191,
    191,191,191,191,191,191,191,255};

unsigned char FontPic34[100]=
{
      7,  0,  4,  0,  0,  0,  0,  0, 36,  0,  0,  0, 44,  0,  0,  0,
     53,  0,  0,  0, 62,  0,  0,  0, 71,  0,  0,  0, 80,  0,  0,  0,
     89,  0,  0,  0,  0,  3,191,191,191,191,191,255,  0,  4,191,191,
    181,191,191,191,255,  0,  4,191,191,179,182,191,191,255,  0,  4,
    191,191,191,191,191,191,255,  0,  4,191,191,181,191,191,191,255,
      0,  4,191,191,179,182,191,191,255,  0,  4,191,191,191,191,191,
    191,255,  0,  0};

unsigned char FontPic35[116]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 46,  0,  0,  0,
     58,  0,  0,  0, 70,  0,  0,  0, 82,  0,  0,  0, 94,  0,  0,  0,
    106,  0,  0,  0,  1,  5,191,191,191,191,191,191,191,255,  0,  7,
    191,191,191,180,191,181,191,191,191,255,  0,  7,191,191,181,177,
    177,177,180,191,191,255,  0,  7,191,191,191,177,191,177,191,191,
    191,255,  0,  7,191,191,180,177,177,177,180,191,191,255,  0,  7,
    191,191,191,180,191,180,191,191,191,255,  1,  5,191,191,191,191,
    191,191,191,255};

unsigned char FontPic36[128]=
{
      7,  0,  8,  0,  0,  0,  0,  0, 36,  0,  0,  0, 50,  0,  0,  0,
     62,  0,  0,  0, 75,  0,  0,  0, 88,  0,  0,  0,101,  0,  0,  0,
    113,  0,  0,  0,  1,  3,191,191,191,191,191,  5,  2,191,191,191,
    191,255,  0,  7,191,191,185,181,185,191,185,191,191,255,  0,  8,
    191,191,181,191,181,191,181,191,191,191,255,  0,  8,181,181,178,
    178,178,185,178,181,191,191,255,  0,  8,191,191,181,191,181,191,
    181,191,191,191,255,  0,  7,191,191,185,191,185,181,185,191,191,
    255,  1,  1,191,191,191,  3,  3,191,191,191,191,191,255,  0,  0
};

unsigned char FontPic37[144]=
{
      9,  0,  7,  0,  0,  0,  0,  0, 44,  0,  0,  0, 52,  0,  0,  0,
     67,  0,  0,  0, 79,  0,  0,  0, 89,  0,  0,  0, 99,  0,  0,  0,
    109,  0,  0,  0,121,  0,  0,  0,136,  0,  0,  0,  0,  3,191,191,
    191,191,191,255,  0,  3,191,191,177,191,191,  4,  3,191,191,191,
    191,191,255,  0,  7,191,191,191,191,191,182,181,191,191,255,  2,
      5,191,191,181,180,183,191,191,255,  1,  5,191,191,181,180,183,
    191,191,255,  0,  5,191,191,178,181,183,191,191,255,  0,  7,191,
    191,179,183,191,191,191,191,191,255,  0,  3,191,191,191,191,191,
      4,  3,191,191,177,191,191,255,  4,  3,191,191,191,191,191,255
};

unsigned char FontPic38[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     59,  0,  0,  0, 71,  0,  0,  0, 83,  0,  0,  0, 95,  0,  0,  0,
    107,  0,  0,  0,121,  0,  0,  0,  3,  3,191,191,191,191,191,255,
      1,  6,191,191,191,187,182,187,191,191,255,  0,  7,191,191,184,
    179,181,182,183,191,191,255,  0,  7,191,191,181,190,181,190,182,
    191,191,255,  0,  7,191,191,182,180,182,181,180,191,191,255,  0,
      7,191,191,185,186,191,180,180,191,191,255,  1,  2,191,191,191,
    191,  4,  3,191,191,180,191,191,255,  4,  3,191,191,191,191,191,
    255,  0,  0,  0};

unsigned char FontPic39[60]=
{
      4,  0,  4,  0,  0,  0,  0,  0, 24,  0,  0,  0, 32,  0,  0,  0,
     41,  0,  0,  0, 50,  0,  0,  0,  0,  3,191,191,191,191,191,255,
      0,  4,191,191,181,191,191,191,255,  0,  4,191,191,179,179,191,
    191,255,  0,  3,191,191,191,191,191,255,  0,  0};

unsigned char FontPic40[120]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 44,  0,  0,  0,
     54,  0,  0,  0, 66,  0,  0,  0, 78,  0,  0,  0, 90,  0,  0,  0,
    105,  0,  0,  0,  2,  3,191,191,191,191,191,255,  1,  5,191,191,
    185,183,186,191,191,255,  0,  7,191,191,185,179,178,181,183,191,
    191,255,  0,  7,191,191,180,184,185,184,181,191,191,255,  0,  7,
    191,191,179,191,191,191,178,191,191,255,  0,  3,191,191,184,191,
    191,  4,  3,191,191,183,191,191,255,  0,  3,191,191,191,191,191,
      4,  3,191,191,191,191,191,255};

unsigned char FontPic41[120]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 51,  0,  0,  0,
     66,  0,  0,  0, 78,  0,  0,  0, 90,  0,  0,  0,102,  0,  0,  0,
    112,  0,  0,  0,  0,  3,191,191,191,191,191,  4,  3,191,191,191,
    191,191,255,  0,  3,191,191,184,191,191,  4,  3,191,191,183,191,
    191,255,  0,  7,191,191,179,191,191,191,178,191,191,255,  0,  7,
    191,191,180,184,185,184,181,191,191,255,  0,  7,191,191,185,179,
    178,181,183,191,191,255,  1,  5,191,191,185,183,186,191,191,255,
      2,  3,191,191,191,191,191,255};

unsigned char FontPic42[96]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 42,  0,  0,  0,
     50,  0,  0,  0, 60,  0,  0,  0, 72,  0,  0,  0, 82,  0,  0,  0,
     90,  0,  0,  0,  3,  1,191,191,191,255,  2,  3,191,191,184,191,
    191,255,  1,  5,191,191,182,178,184,191,191,255,  0,  7,191,191,
    182,178,178,178,184,191,191,255,  1,  5,191,191,182,178,184,191,
    191,255,  2,  3,191,191,184,191,191,255,  3,  1,191,191,191,255
};

unsigned char FontPic43[76]=
{
      5,  0,  5,  0,  0,  0,255,255, 28,  0,  0,  0, 36,  0,  0,  0,
     46,  0,  0,  0, 56,  0,  0,  0, 66,  0,  0,  0,  1,  3,191,191,
    191,191,191,255,  0,  5,191,191,191,182,191,191,191,255,  0,  5,
    191,191,182,182,182,191,191,255,  0,  5,191,191,191,182,191,191,
    191,255,  1,  3,191,191,191,191,191,255,  0,  0};

unsigned char FontPic44[60]=
{
      4,  0,  4,  0,  0,  0,253,255, 24,  0,  0,  0, 32,  0,  0,  0,
     41,  0,  0,  0, 50,  0,  0,  0,  0,  3,191,191,191,191,191,255,
      0,  4,191,191,181,191,191,191,255,  0,  4,191,191,179,179,191,
    191,255,  0,  4,191,191,191,191,191,191,255,  0};

unsigned char FontPic45[80]=
{
      6,  0,  3,  0,  0,  0,254,255, 32,  0,  0,  0, 40,  0,  0,  0,
     48,  0,  0,  0, 56,  0,  0,  0, 64,  0,  0,  0, 72,  0,  0,  0,
      0,  3,191,191,191,191,191,255,  0,  3,191,191,177,191,191,255,
      0,  3,191,191,177,191,191,255,  0,  3,191,191,177,191,191,255,
      0,  3,191,191,177,191,191,255,  0,  3,191,191,191,191,191,255
};

unsigned char FontPic46[56]=
{
      4,  0,  3,  0,  0,  0,252,255, 24,  0,  0,  0, 32,  0,  0,  0,
     40,  0,  0,  0, 48,  0,  0,  0,  0,  3,191,191,191,191,191,255,
      0,  3,191,191,181,191,191,255,  0,  3,191,191,179,191,191,255,
      0,  3,191,191,191,191,191,255};

unsigned char FontPic47[100]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 44,  0,  0,  0,
     53,  0,  0,  0, 63,  0,  0,  0, 73,  0,  0,  0, 83,  0,  0,  0,
     92,  0,  0,  0,  4,  3,191,191,191,191,191,255,  3,  4,191,191,
    180,184,191,191,255,  2,  5,191,191,181,182,186,191,191,255,  1,
      5,191,191,181,182,185,191,191,255,  0,  5,191,191,181,182,185,
    191,191,255,  0,  4,191,191,182,185,191,191,255,  0,  3,191,191,
    191,191,191,255};

unsigned char FontPic48[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 50,  0,  0,  0,
     62,  0,  0,  0, 74,  0,  0,  0, 86,  0,  0,  0, 98,  0,  0,  0,
    110,  0,  0,  0,122,  0,  0,  0,  1,  5,191,191,191,191,191,191,
    191,255,  0,  7,191,191,191,184,184,184,191,191,191,255,  0,  7,
    191,191,184,179,181,180,184,191,191,255,  0,  7,191,191,181,185,
    191,185,181,191,191,255,  0,  7,191,191,181,185,191,185,181,191,
    191,255,  0,  7,191,191,184,180,178,180,184,191,191,255,  0,  7,
    191,191,191,184,182,184,191,191,191,255,  1,  5,191,191,191,191,
    191,191,191,255};

unsigned char FontPic49[84]=
{
      5,  0,  7,  0,  0,  0,  0,  0, 28,  0,  0,  0, 36,  0,  0,  0,
     48,  0,  0,  0, 60,  0,  0,  0, 72,  0,  0,  0,  1,  3,191,191,
    191,191,191,255,  0,  7,191,191,191,182,191,191,191,191,191,255,
      0,  7,191,191,177,181,181,181,181,191,191,255,  0,  7,191,191,
    177,179,182,181,179,191,191,255,  0,  7,191,191,191,191,191,191,
    191,191,191,255};

unsigned char FontPic50[140]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 52,  0,  0,  0,
     64,  0,  0,  0, 76,  0,  0,  0, 88,  0,  0,  0,100,  0,  0,  0,
    112,  0,  0,  0,124,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191,191,191,255,  0,  7,191,191,181,191,188,181,181,191,191,255,
      0,  7,191,191,180,191,183,180,180,191,191,255,  0,  7,191,191,
    181,188,181,191,181,191,191,255,  0,  7,191,191,178,185,180,191,
    179,191,191,255,  0,  7,191,191,179,179,181,191,177,191,191,255,
      0,  7,191,191,188,185,188,191,181,191,191,255,  1,  3,191,191,
    191,191,191,  5,  2,191,191,191,191,255,  0,  0};

unsigned char FontPic51[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 53,  0,  0,  0,
     65,  0,  0,  0, 77,  0,  0,  0, 89,  0,  0,  0,101,  0,  0,  0,
    113,  0,  0,  0,123,  0,  0,  0,  0,  2,191,191,191,191,  5,  2,
    191,191,191,191,255,  0,  7,191,191,184,191,191,191,183,191,191,
    255,  0,  7,191,191,179,191,180,191,180,191,191,255,  0,  7,191,
    191,179,191,180,191,178,191,191,255,  0,  7,191,191,180,185,180,
    185,181,191,191,255,  0,  7,191,191,185,179,178,181,183,191,191,
    255,  1,  5,191,191,185,183,186,191,191,255,  2,  3,191,191,191,
    191,191,255,  0};

unsigned char FontPic52[116]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 46,  0,  0,  0,
     56,  0,  0,  0, 66,  0,  0,  0, 78,  0,  0,  0, 90,  0,  0,  0,
    102,  0,  0,  0,  0,  5,191,191,191,191,191,191,191,255,  0,  5,
    191,191,179,179,179,191,191,255,  0,  5,191,191,180,181,179,191,
    191,255,  0,  7,191,191,191,191,177,191,191,191,191,255,  0,  7,
    191,191,180,179,177,178,179,191,191,255,  0,  7,191,191,180,179,
    179,180,180,191,191,255,  0,  7,191,191,191,191,191,191,191,191,
    191,255,  0,  0};

unsigned char FontPic53[124]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 48,  0,  0,  0,
     60,  0,  0,  0, 72,  0,  0,  0, 84,  0,  0,  0, 96,  0,  0,  0,
    108,  0,  0,  0,  0,  7,191,191,191,191,191,191,191,191,191,255,
      0,  7,191,191,182,182,182,191,184,191,191,255,  0,  7,191,191,
    178,178,178,188,177,191,191,255,  0,  7,191,191,178,191,178,188,
    179,191,191,255,  0,  7,191,191,178,191,181,180,181,191,191,255,
      0,  7,191,191,180,191,185,178,185,191,191,255,  0,  2,191,191,
    191,191,  3,  3,191,191,191,191,191,255,  0,  0};

unsigned char FontPic54[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     58,  0,  0,  0, 70,  0,  0,  0, 82,  0,  0,  0, 94,  0,  0,  0,
    106,  0,  0,  0,118,  0,  0,  0,  2,  3,191,191,191,191,191,255,
      1,  5,191,191,183,183,183,191,191,255,  0,  7,191,191,183,180,
    178,178,183,191,191,255,  0,  7,191,191,180,187,180,191,183,191,
    191,255,  0,  7,191,191,178,191,178,191,178,191,191,255,  0,  7,
    191,191,178,191,178,177,178,191,191,255,  0,  7,191,191,185,191,
    187,184,187,191,191,255,  0,  2,191,191,191,191,  3,  3,191,191,
    191,191,191,255};

unsigned char FontPic55[120]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     56,  0,  0,  0, 64,  0,  0,  0, 72,  0,  0,  0, 84,  0,  0,  0,
     96,  0,  0,  0,108,  0,  0,  0,  0,  3,191,191,191,191,191,255,
      0,  3,191,191,181,191,191,255,  0,  3,191,191,180,191,191,255,
      0,  3,191,191,181,191,191,255,  0,  7,191,191,178,185,191,191,
    191,191,191,255,  0,  7,191,191,178,182,181,181,181,191,191,255,
      0,  7,191,191,183,181,180,178,179,191,191,255,  1,  6,191,191,
    191,191,191,191,191,191,255,  0};

unsigned char FontPic56[140]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 53,  0,  0,  0,
     65,  0,  0,  0, 77,  0,  0,  0, 89,  0,  0,  0,101,  0,  0,  0,
    113,  0,  0,  0,125,  0,  0,  0,  1,  2,191,191,191,191,  4,  2,
    191,191,191,191,255,  0,  7,191,191,186,186,191,186,186,191,191,
    255,  0,  7,191,191,183,180,180,180,183,191,191,255,  0,  7,191,
    191,179,191,182,191,183,191,191,255,  0,  7,191,191,180,191,182,
    191,183,191,191,255,  0,  7,191,191,181,181,180,180,181,191,191,
    255,  0,  7,191,191,186,186,191,186,186,191,191,255,  1,  2,191,
    191,191,191,  4,  2,191,191,191,191,255,  0,  0};

unsigned char FontPic57[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 54,  0,  0,  0,
     66,  0,  0,  0, 78,  0,  0,  0, 90,  0,  0,  0,102,  0,  0,  0,
    114,  0,  0,  0,124,  0,  0,  0,  1,  2,191,191,191,191,  4,  3,
    191,191,191,191,191,255,  0,  7,191,191,187,182,187,191,185,191,
    191,255,  0,  7,191,191,180,177,182,191,178,191,191,255,  0,  7,
    191,191,176,191,182,191,178,191,191,255,  0,  7,191,191,179,191,
    182,187,180,191,191,255,  0,  7,191,191,183,181,180,180,183,191,
    191,255,  1,  5,191,191,186,183,183,191,191,255,  2,  3,191,191,
    191,191,191,255};

unsigned char FontPic58[84]=
{
      4,  0,  7,  0,  0,  0,  0,  0, 24,  0,  0,  0, 39,  0,  0,  0,
     54,  0,  0,  0, 69,  0,  0,  0,  0,  3,191,191,191,191,191,  4,
      3,191,191,191,191,191,255,  0,  3,191,191,177,191,191,  4,  3,
    191,191,178,191,191,255,  0,  3,191,191,184,191,191,  4,  3,191,
    191,184,191,191,255,  0,  3,191,191,191,191,191,  4,  3,191,191,
    191,191,191,255};

unsigned char FontPic59[72]=
{
      4,  0,  7,  0,  0,  0,  0,  0, 24,  0,  0,  0, 35,  0,  0,  0,
     47,  0,  0,  0, 59,  0,  0,  0,  0,  6,191,191,191,191,191,191,
    191,191,255,  0,  7,191,191,177,191,191,181,191,191,191,255,  0,
      7,191,191,177,191,191,179,179,191,191,255,  0,  7,191,191,191,
    191,191,191,191,191,191,255,  0};

unsigned char FontPic60[80]=
{
      5,  0,  7,  0,  0,  0,  0,  0, 28,  0,  0,  0, 34,  0,  0,  0,
     42,  0,  0,  0, 52,  0,  0,  0, 64,  0,  0,  0,  3,  1,191,191,
    191,255,  2,  3,191,191,181,191,191,255,  1,  5,191,191,181,181,
    181,191,191,255,  0,  7,191,191,181,180,191,180,181,191,191,255,
      0,  3,191,191,191,191,191,  4,  3,191,191,191,191,191,255,  0
};

unsigned char FontPic61[80]=
{
      5,  0,  5,  0,  0,  0,255,255, 28,  0,  0,  0, 38,  0,  0,  0,
     48,  0,  0,  0, 58,  0,  0,  0, 68,  0,  0,  0,  0,  5,191,191,
    191,191,191,191,191,255,  0,  5,191,191,177,191,181,191,191,255,
      0,  5,191,191,177,191,179,191,191,255,  0,  5,191,191,177,191,
    179,191,191,255,  0,  5,191,191,191,191,191,191,191,255,  0,  0
};

unsigned char FontPic62[80]=
{
      5,  0,  7,  0,  0,  0,  0,  0, 28,  0,  0,  0, 43,  0,  0,  0,
     55,  0,  0,  0, 65,  0,  0,  0, 73,  0,  0,  0,  0,  3,191,191,
    191,191,191,  4,  3,191,191,191,191,191,255,  0,  7,191,191,181,
    180,191,180,181,191,191,255,  1,  5,191,191,181,181,181,191,191,
    255,  2,  3,191,191,181,191,191,255,  3,  1,191,191,191,255,  0
};

unsigned char FontPic63[128]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 52,  0,  0,  0,
     64,  0,  0,  0, 76,  0,  0,  0, 88,  0,  0,  0,100,  0,  0,  0,
    110,  0,  0,  0,120,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191,191,191,255,  0,  7,191,191,181,191,181,191,181,191,191,255,
      0,  7,191,191,180,191,181,191,180,191,191,255,  0,  7,191,191,
    181,191,181,191,181,191,191,255,  0,  7,191,191,178,182,181,191,
    191,191,191,255,  0,  5,191,191,179,179,181,191,191,255,  0,  5,
    191,191,182,185,185,191,191,255,  1,  3,191,191,191,191,191,255
};

unsigned char FontPic64[156]=
{
      9,  0,  8,  0,  0,  0,  0,  0, 44,  0,  0,  0, 54,  0,  0,  0,
     66,  0,  0,  0, 79,  0,  0,  0, 92,  0,  0,  0,105,  0,  0,  0,
    118,  0,  0,  0,131,  0,  0,  0,143,  0,  0,  0,  2,  5,191,191,
    191,191,191,191,191,255,  1,  7,191,191,183,178,178,178,183,191,
    191,255,  0,  8,191,191,183,187,191,191,191,187,183,183,255,  0,
      8,191,191,178,191,187,178,178,191,178,178,255,  0,  8,191,191,
    178,191,183,191,178,191,178,178,255,  0,  8,191,191,178,191,178,
    178,178,191,178,178,255,  0,  8,191,191,181,191,191,191,182,191,
    181,181,255,  1,  7,191,191,181,178,182,187,191,191,191,255,  2,
      5,191,191,191,191,191,191,191,255,  0,  0,  0};

unsigned char FontPic65[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 50,  0,  0,  0,
     61,  0,  0,  0, 73,  0,  0,  0, 85,  0,  0,  0, 97,  0,  0,  0,
    109,  0,  0,  0,121,  0,  0,  0,  2,  5,191,191,191,191,191,191,
    191,255,  1,  6,191,191,186,180,180,180,191,191,255,  0,  7,191,
    191,183,180,183,183,183,191,191,255,  0,  7,191,191,178,191,181,
    191,191,191,191,255,  0,  7,191,191,178,191,181,191,191,191,191,
    255,  0,  7,191,191,178,182,180,180,180,191,191,255,  0,  7,191,
    191,182,179,179,179,179,191,191,255,  1,  6,191,191,191,191,191,
    191,191,191,255};

unsigned char FontPic66[140]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 52,  0,  0,  0,
     64,  0,  0,  0, 76,  0,  0,  0, 88,  0,  0,  0,100,  0,  0,  0,
    112,  0,  0,  0,124,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191,191,191,255,  0,  7,191,191,182,191,183,181,181,191,191,255,
      0,  7,191,191,179,191,181,181,180,191,191,255,  0,  7,191,191,
    177,191,182,191,178,191,191,255,  0,  7,191,191,178,186,181,186,
    178,191,191,255,  0,  7,191,191,177,179,181,179,180,191,191,255,
      0,  7,191,191,185,185,191,183,187,191,191,255,  1,  2,191,191,
    191,191,  4,  2,191,191,191,191,255,  0,  0,  0};

unsigned char FontPic67[140]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     58,  0,  0,  0, 70,  0,  0,  0, 82,  0,  0,  0, 94,  0,  0,  0,
    109,  0,  0,  0,124,  0,  0,  0,  2,  3,191,191,191,191,191,255,
      1,  5,191,191,185,184,186,191,191,255,  0,  7,191,191,186,179,
    181,179,186,191,191,255,  0,  7,191,191,179,179,181,179,181,191,
    191,255,  0,  7,191,191,177,191,191,191,177,191,191,255,  0,  3,
    191,191,177,191,191,  4,  3,191,191,177,191,191,255,  0,  3,191,
    191,180,191,191,  4,  3,191,191,182,191,191,255,  0,  3,191,191,
    191,191,191,  4,  3,191,191,191,191,191,255,  0};

unsigned char FontPic68[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 52,  0,  0,  0,
     64,  0,  0,  0, 76,  0,  0,  0, 88,  0,  0,  0,100,  0,  0,  0,
    112,  0,  0,  0,122,  0,  0,  0,  0,  7,191,191, 45,191,191,191,
    191,191,191,255,  0,  7,191,191,184,191,181,180,180,191,191,255,
      0,  7,191,191,178,191,181,178,178,191,191,255,  0,  7,191,191,
    177,191,191,191,177,191,191,255,  0,  7,191,191,180,187,191,187,
    179,191,191,255,  0,  7,191,191,185,182,180,180,185,191,191,255,
      1,  5,191,191,185,182,185,191,191,255,  2,  3,191,191,191,191,
    191,255,  0,  0};

unsigned char FontPic69[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     58,  0,  0,  0, 70,  0,  0,  0, 82,  0,  0,  0, 94,  0,  0,  0,
    106,  0,  0,  0,118,  0,  0,  0,  2,  3,191,191,191,191,191,255,
      1,  5,191,191,185,183,186,191,191,255,  0,  7,191,191,185,179,
    178,181,183,191,191,255,  0,  7,191,191,181,179,179,179,179,191,
    191,255,  0,  7,191,191,180,185,180,185,181,191,191,255,  0,  7,
    191,191,179,191,181,191,180,191,191,255,  0,  7,191,191,184,191,
    185,191,183,191,191,255,  0,  7,191,191,191,191,191,191,191,191,
    191,255,  0,  0};

unsigned char FontPic70[128]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 52,  0,  0,  0,
     64,  0,  0,  0, 76,  0,  0,  0, 88,  0,  0,  0, 98,  0,  0,  0,
    108,  0,  0,  0,118,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191, 47, 47,255,  0,  7,191,191,181,181,181,181,181,191,191,255,
      0,  7,191,191,180,181,181,182,183,191,191,255,  0,  7,191,191,
    177,185,181,191,191,191,191,255,  0,  5,191,191,177,191,181,191,
    191,255,  0,  5,191,191,177,191,181,191,191,255,  0,  5,191,191,
    177,191,191,191,191,255,  0,  3,191,191,191,191,191,255,  0,  0
};

unsigned char FontPic71[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     58,  0,  0,  0, 70,  0,  0,  0, 82,  0,  0,  0, 94,  0,  0,  0,
    106,  0,  0,  0,118,  0,  0,  0,  2,  3,191,191,191,191,191,255,
      1,  5,191,191,183,183,186,191,191,255,  0,  7,191,191,183,180,
    180,181,183,191,191,255,  0,  7,191,191,180,184,187,184,183,191,
    191,255,  0,  7,191,191,178,191,191,191,178,191,191,255,  0,  7,
    191,191,178,191,180,184,181,191,191,255,  0,  7,191,191,178,191,
    180,178,178,191,191,255,  0,  7,191,191,191,191,191,191,191,191,
    191,255,  0,  0};

unsigned char FontPic72[136]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 52,  0,  0,  0,
     64,  0,  0,  0, 76,  0,  0,  0, 88,  0,  0,  0,100,  0,  0,  0,
    112,  0,  0,  0,124,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191,191,191,255,  0,  7,191,191,180,180,180,180,180,191,191,255,
      0,  7,191,191,183,183,180,183,183,191,191,255,  0,  7,191,191,
    191,191,181,191,191,191,191,255,  0,  7,191,191,191,191,181,191,
    191,191,191,255,  0,  7,191,191,183,181,181,183,184,191,191,255,
      0,  7,191,191,178,180,178,178,179,191,191,255,  0,  7,191,191,
    191,191,191,191,191,191,191,255};

unsigned char FontPic73[72]=
{
      4,  0,  7,  0,  0,  0,  0,  0, 24,  0,  0,  0, 36,  0,  0,  0,
     48,  0,  0,  0, 60,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191,191,191,255,  0,  7,191,191,183,183,183,183,183,191,191,255,
      0,  7,191,191,177,178,179,178,179,191,191,255,  0,  7,191,191,
    191,191,191,191,191,191,191,255};

unsigned char FontPic74[120]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     56,  0,  0,  0, 64,  0,  0,  0, 72,  0,  0,  0, 84,  0,  0,  0,
     96,  0,  0,  0,108,  0,  0,  0,  4,  3,191,191,191,191,191,255,
      4,  3,191,191,182,191,191,255,  4,  3,191,191,179,191,191,255,
      4,  3,191,191,179,191,191,255,  0,  7,191,191,191,191,191,185,
    179,191,191,255,  0,  7,191,191,178,181,182,182,182,191,191,255,
      0,  7,191,191,184,184,184,184,186,191,191,255,  0,  6,191,191,
    191,191,191,191,191,191,255,  0};

unsigned char FontPic75[140]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 52,  0,  0,  0,
     64,  0,  0,  0, 76,  0,  0,  0, 88,  0,  0,  0, 98,  0,  0,  0,
    110,  0,  0,  0,125,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191,191,191,255,  0,  7,191,191,183,183,183,183,183,191,191,255,
      0,  7,191,191,177,180,178,178,179,191,191,255,  0,  7,191,191,
    191,191,180,191,191,191,191,255,  1,  5,191,191,178,180,184,191,
    191,255,  0,  7,191,191,177,184,191,179,184,191,191,255,  0,  3,
    191,191,182,191,191,  4,  3,191,191,179,191,191,255,  0,  2,191,
    191,191,191,  5,  2,191,191,191,191,255,  0,  0};

unsigned char FontPic76[120]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0,
     63,  0,  0,  0, 75,  0,  0,  0, 87,  0,  0,  0, 95,  0,  0,  0,
    103,  0,  0,  0,111,  0,  0,  0,  0,  6,191,191,191,191,191,191,
    191,191,255,  0,  7,191,191,180,184,184,184,186,191,191,255,  0,
      7,191,191,178,181,181,181,184,191,191,255,  0,  7,191,191,191,
    191,191,185,179,191,191,255,  4,  3,191,191,179,191,191,255,  4,
      3,191,191,179,191,191,255,  4,  3,191,191,179,191,191,255,  4,
      3,191,191,191,191,191,255,  0};

unsigned char FontPic77[148]=
{
      9,  0,  7,  0,  0,  0,  0,  0, 44,  0,  0,  0, 55,  0,  0,  0,
     67,  0,  0,  0, 79,  0,  0,  0, 90,  0,  0,  0, 99,  0,  0,  0,
    110,  0,  0,  0,122,  0,  0,  0,134,  0,  0,  0,  1,  6,191,191,
    191,191,191,191,191,191,255,  0,  7,191,191,185,183,181,182,181,
    191,191,255,  0,  7,191,191,180,180,182,184,183,191,191,255,  1,
      6,191,191,183,183,191,191,191,191,255,  2,  4,191,191,180,182,
    191,191,255,  1,  6,191,191,185,183,191,191,191,191,255,  0,  7,
    191,191,179,181,181,181,181,191,191,255,  0,  7,191,191,185,179,
    183,183,183,191,191,255,  1,  6,191,191,191,191,191,191,191,191,
    255,  0,  0,  0};

unsigned char FontPic78[136]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0,
     63,  0,  0,  0, 75,  0,  0,  0, 87,  0,  0,  0, 99,  0,  0,  0,
    111,  0,  0,  0,123,  0,  0,  0,  1,  6,191,191,191,191,191,191,
    191,191,255,  0,  7,191,191,186,181,181,181,181,191,191,255,  0,
      7,191,191,180,181,180,183,184,191,191,255,  0,  7,191,191,187,
    184,183,187,191,191,191,255,  0,  7,191,191,191,191,183,180,186,
    191,191,255,  0,  7,191,191,180,182,179,178,178,191,191,255,  0,
      7,191,191,179,179,179,181,187,191,191,255,  0,  6,191,191,191,
    191,191,191,191,191,255,  0,  0};

unsigned char FontPic79[124]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     58,  0,  0,  0, 70,  0,  0,  0, 82,  0,  0,  0, 94,  0,  0,  0,
    106,  0,  0,  0,116,  0,  0,  0,  2,  3,191,191,191,191,191,255,
      1,  5,191,191,186,184,186,191,191,255,  0,  7,191,191,186,179,
    181,179,186,191,191,255,  0,  7,191,191,177,185,191,185,177,191,
    191,255,  0,  7,191,191,177,185,191,185,180,191,191,255,  0,  7,
    191,191,186,181,181,183,186,191,191,255,  1,  5,191,191,186,184,
    186,191,191,255,  2,  3,191,191,191,191,191,255};

unsigned char FontPic80[128]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 52,  0,  0,  0,
     64,  0,  0,  0, 76,  0,  0,  0, 88,  0,  0,  0, 98,  0,  0,  0,
    108,  0,  0,  0,118,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191,191,191,255,  0,  7,191,191,183,191,177,177,181,191,191,255,
      0,  7,191,191,178,191,177,177,181,191,191,255,  0,  7,191,191,
    177,191,177,191,191,191,191,255,  0,  5,191,191,177,189,179,191,
    191,255,  0,  5,191,191,177,181,179,191,191,255,  0,  5,191,191,
    186,181,186,191,191,255,  1,  3,191,191,191,191,191,255,  0,  0
};

unsigned char FontPic81[136]=
{
      8,  0,  8,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     58,  0,  0,  0, 70,  0,  0,  0, 82,  0,  0,  0, 94,  0,  0,  0,
    107,  0,  0,  0,119,  0,  0,  0,  2,  3,191,191,191,191,191,255,
      1,  5,191,191,182,182,186,191,191,255,  0,  7,191,191,182,179,
    181,179,186,191,191,255,  0,  7,191,191,181,185,191,185,181,191,
    191,255,  0,  7,191,191,181,185,191,185,181,191,191,255,  0,  8,
    191,191,182,181,181,183,183,183,191,191,255,  1,  7,191,191,182,
    182,186,191,183,191,191,255,  2,  3,191,191,191,191,191,  6,  2,
    191,191,191,191,255,  0,  0,  0};

unsigned char FontPic82[140]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 52,  0,  0,  0,
     64,  0,  0,  0, 76,  0,  0,  0, 88,  0,  0,  0,100,  0,  0,  0,
    112,  0,  0,  0,124,  0,  0,  0,  0,  7,191,191,191,191,191,191,
    191,191,191,255,  0,  7,191,191,183,191,179,181,181,191,191,255,
      0,  7,191,191,178,191,177,177,181,191,191,255,  0,  7,191,191,
    177,191,177,191,191,191,191,255,  0,  7,191,191,177,186,177,184,
    191,191,191,255,  0,  7,191,191,177,181,179,181,181,191,191,255,
      0,  7,191,191,186,184,191,186,184,191,191,255,  1,  2,191,191,
    191,191,  4,  3,191,191,191,191,191,255,  0,  0};

unsigned char FontPic83[120]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 47,  0,  0,  0,
     59,  0,  0,  0, 71,  0,  0,  0, 83,  0,  0,  0, 95,  0,  0,  0,
    107,  0,  0,  0,  1,  6,191,191,191,191,191,191,191,191,255,  0,
      7,191,191,185,182,185,191,184,191,191,255,  0,  7,191,191,182,
    182,181,191,177,191,191,255,  0,  7,191,191,178,191,182,191,179,
    191,191,255,  0,  7,191,191,180,191,184,180,182,191,191,255,  0,
      7,191,191,185,191,185,182,185,191,191,255,  0,  6,191,191,191,
    191,191,191,191,191,255,  0,  0};

unsigned char FontPic84[120]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     56,  0,  0,  0, 68,  0,  0,  0, 80,  0,  0,  0, 92,  0,  0,  0,
    104,  0,  0,  0,112,  0,  0,  0,  0,  3,191,191,191,191,191,255,
      0,  3,191,191,176,191,191,255,  0,  7,191,191,176,191,191,191,
    191,191,191,255,  0,  7,191,191,177,181,181,181,181,191,191,255,
      0,  7,191,191,177,178,179,178,179,191,191,255,  0,  7,191,191,
    180,191,191,191,191,191,191,255,  0,  3,191,191,180,191,191,255,
      0,  3,191,191,191,191,191,255};

unsigned char FontPic85[132]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 50,  0,  0,  0,
     61,  0,  0,  0, 73,  0,  0,  0, 85,  0,  0,  0, 97,  0,  0,  0,
    109,  0,  0,  0,120,  0,  0,  0,  0,  5,191,191,191,191,191,191,
    191,255,  0,  6,191,191,183,182,183,186,191,191,255,  0,  7,191,
    191,178,181,181,181,186,191,191,255,  0,  7,191,191,191,191,191,
    179,183,191,191,255,  0,  7,191,191,191,191,191,179,183,191,191,
    255,  0,  7,191,191,180,181,181,181,186,191,191,255,  0,  6,191,
    191,182,183,183,186,191,191,255,  0,  5,191,191,191,191,191,191,
    191,255,  0,  0};

unsigned char FontPic86[108]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 44,  0,  0,  0,
     54,  0,  0,  0, 66,  0,  0,  0, 78,  0,  0,  0, 90,  0,  0,  0,
    100,  0,  0,  0,  0,  3,191,191,191,191,191,255,  0,  5,191,191,
    180,180,191,191,191,255,  0,  7,191,191,177,178,180,182,191,191,
    191,255,  0,  7,191,191,191,191,185,178,180,191,191,255,  0,  7,
    191,191,178,179,178,182,191,191,191,255,  0,  5,191,191,181,181,
    191,191,191,255,  0,  3,191,191,191,191,191,255};

unsigned char FontPic87[148]=
{
      9,  0,  7,  0,  0,  0,  0,  0, 44,  0,  0,  0, 55,  0,  0,  0,
     67,  0,  0,  0, 79,  0,  0,  0, 91,  0,  0,  0,101,  0,  0,  0,
    113,  0,  0,  0,125,  0,  0,  0,137,  0,  0,  0,  0,  6,191,191,
    191,191,191,191,191,191,255,  0,  7,191,191,179,182,182,184,184,
    191,191,255,  0,  7,191,191,179,180,179,179,178,191,191,255,  0,
      7,191,191,191,191,186,182,182,191,191,255,  1,  5,191,191,179,
    180,180,191,191,255,  0,  7,191,191,191,191,186,182,181,191,191,
    255,  0,  7,191,191,179,180,180,181,184,191,191,255,  0,  7,191,
    191,186,184,184,184,184,191,191,255,  0,  6,191,191,191,191,191,
    191,191,191,255};

unsigned char FontPic88[160]=
{
      9,  0,  7,  0,  0,  0,  0,  0, 44,  0,  0,  0, 57,  0,  0,  0,
     72,  0,  0,  0, 84,  0,  0,  0, 96,  0,  0,  0,106,  0,  0,  0,
    118,  0,  0,  0,130,  0,  0,  0,145,  0,  0,  0,  0,  2,191,191,
    191,191,  5,  2,191,191,191,191,255,  0,  3,191,191,179,191,191,
      4,  3,191,191,179,191,191,255,  0,  7,191,191,181,182,191,182,
    181,191,191,255,  0,  7,191,191,183,183,183,183,183,191,191,255,
      1,  5,191,191,181,181,181,191,191,255,  0,  7,191,191,183,183,
    181,183,183,191,191,255,  0,  7,191,191,181,182,191,182,181,191,
    191,255,  0,  3,191,191,183,191,191,  4,  3,191,191,183,191,191,
    255,  0,  2,191,191,191,191,  5,  2,191,191,191,191,255,  0,  0
};

unsigned char FontPic89[124]=
{
      8,  0,  7,  0,  0,  0,  0,  0, 40,  0,  0,  0, 48,  0,  0,  0,
     57,  0,  0,  0, 69,  0,  0,  0, 81,  0,  0,  0, 93,  0,  0,  0,
    105,  0,  0,  0,114,  0,  0,  0,  0,  3,191,191,191,191,191,255,
      0,  4,191,191,177,180,191,191,255,  0,  7,191,191,177,179,181,
    191,191,191,191,255,  0,  7,191,191,191,191,177,183,183,191,191,
    255,  0,  7,191,191,191,191,177,182,181,191,191,255,  0,  7,191,
    191,178,179,181,191,191,191,191,255,  0,  4,191,191,178,182,191,
    191,255,  0,  3,191,191,191,191,191,255,  0,  0};

unsigned char FontPic90[128]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 51,  0,  0,  0,
     63,  0,  0,  0, 75,  0,  0,  0, 87,  0,  0,  0, 99,  0,  0,  0,
    111,  0,  0,  0,  0,  3,191,191,191,191,191,  4,  3,191,191,191,
    191,191,255,  0,  7,191,191,181,191,191,182,181,191,191,255,  0,
      7,191,191,180,191,180,180,180,191,191,255,  0,  7,191,191,178,
    180,181,186,179,191,191,255,  0,  7,191,191,178,182,186,191,177,
    191,191,255,  0,  7,191,191,182,186,191,191,181,191,191,255,  0,
      3,191,191,191,191,191,  4,  3,191,191,191,191,191,255,  0,  0
};

unsigned char FontPic91[92]=
{
      5,  0,  7,  0,  0,  0,  0,  0, 28,  0,  0,  0, 38,  0,  0,  0,
     50,  0,  0,  0, 62,  0,  0,  0, 74,  0,  0,  0,  1,  5,191,191,
    191,191,191,191,191,255,  0,  7,191,191,186,184,184,184,186,191,
    191,255,  0,  7,191,191,178,181,181,181,184,191,191,255,  0,  7,
    191,191,177,191,191,191,179,191,191,255,  0,  3,191,191,191,191,
    191,  4,  3,191,191,191,191,191,255,  0,  0,  0};

unsigned char FontPic92[100]=
{
      7,  0,  7,  0,  0,  0,  0,  0, 36,  0,  0,  0, 44,  0,  0,  0,
     53,  0,  0,  0, 63,  0,  0,  0, 73,  0,  0,  0, 83,  0,  0,  0,
     92,  0,  0,  0,  0,  3,191,191,191,191,191,255,  0,  4,191,191,
    182,185,191,191,255,  0,  5,191,191,179,179,185,191,191,255,  1,
      5,191,191,181,181,185,191,191,255,  2,  5,191,191,181,181,185,
    191,191,255,  3,  4,191,191,180,180,191,191,255,  4,  3,191,191,
    191,191,191,255};

unsigned char FontPic93[92]=
{
      5,  0,  7,  0,  0,  0,  0,  0, 28,  0,  0,  0, 43,  0,  0,  0,
     55,  0,  0,  0, 67,  0,  0,  0, 79,  0,  0,  0,  0,  3,191,191,
    191,191,191,  4,  3,191,191,191,191,191,255,  0,  7,191,191,177,
    191,191,191,179,191,191,255,  0,  7,191,191,178,181,182,182,182,
    191,191,255,  0,  7,191,191,186,184,184,184,186,191,191,255,  1,
      5,191,191,191,191,191,191,191,255,  0,  0,  0};

unsigned char FontPic94[96]=
{
      7,  0,  5,  0,  0,  0,  0,  0, 36,  0,  0,  0, 43,  0,  0,  0,
     51,  0,  0,  0, 60,  0,  0,  0, 69,  0,  0,  0, 78,  0,  0,  0,
     86,  0,  0,  0,  3,  2,191,191,191,191,255,  2,  3,191,191,184,
    191,191,255,  1,  4,191,191,184,180,191,191,255,  0,  4,191,191,
    184,181,191,191,255,  1,  4,191,191,184,180,191,191,255,  2,  3,
    191,191,184,191,191,255,  3,  2,191,191,191,191,255,  0,  0,  0
};

unsigned char *FontData[64]=
{
	FontPic33,FontPic34,FontPic35,FontPic36,FontPic37,FontPic38,
	FontPic39,FontPic40,FontPic41,FontPic42,FontPic43,FontPic44,
	FontPic45,FontPic46,FontPic47,FontPic48,FontPic49,FontPic50,
	FontPic51,FontPic52,FontPic53,FontPic54,FontPic55,FontPic56,
	FontPic57,FontPic58,FontPic59,FontPic60,FontPic61,FontPic62,
	FontPic63,FontPic64,FontPic65,FontPic66,FontPic67,FontPic68,
	FontPic69,FontPic70,FontPic71,FontPic72,FontPic73,FontPic74,
	FontPic75,FontPic76,FontPic77,FontPic78,FontPic79,FontPic80,
	FontPic81,FontPic82,FontPic83,FontPic84,FontPic85,FontPic86,
	FontPic87,FontPic88,FontPic89,FontPic90,FontPic91,FontPic92,
	FontPic93,FontPic94
};

PicData DoomFont[64];

unsigned char BigPic48[318]=
{
     14,  0, 16,  0,  0,  0,  0,  0, 64,  0,  0,  0, 76,  0,  0,  0,
     92,  0,  0,  0,110,  0,  0,  0,129,  0,  0,  0,149,  0,  0,  0,
    170,  0,  0,  0,191,  0,  0,  0,212,  0,  0,  0,233,  0,  0,  0,
    253,  0,  0,  0, 16,  1,  0,  0, 34,  1,  0,  0, 50,  1,  0,  0,
      4,  7,  0,191,191,191,191,191,191,191,  0,255,  2, 11,  0,191,
    191,186,187,189,189,189,187,186,191,191,  0,255,  1, 13,  0,191,
    189,183,183,183,183,184,184,183,183,186, 45,191,  0,255,  1, 14,
      0,191,184,183,183,185,185,185,185,182,182,182,188,191,109,  0,
    255,  0, 15,  0,191,186,187,186,186,186,186,185,185,185,185,186,
    187,188,191,  0,255,  0, 16,  0,191,184,185,185,188,191,191,191,
    191,191,184,185,188,189,191,109,  0,255,  0,  6,  0,191,182,184,
    185,191,109,  0, 10,  6,  0,191,183,184,185,191,109,  0,255,  0,
     16,  0,191,185,189,188, 45,191,191,191,191,191,182,183,183,188,
    191,109,  0,255,  0, 16,  0,191,184,187,188,189,188,187,187,186,
    186,185,186,186,189,191,109,  0,255,  1, 15,  0,191,183,181,181,
    181,182,181,180,181,181,181,186,191,109,109,  0,255,  1, 14,  0,
    191,189,184,184,184,184,185,184,184,184,183,189,191,109,  0,255,
      2, 13,  0,191,191,186,185,186,186,185,185,186,191,191,109,109,
      0,255,  3, 11,  0,109,191,191,191,191,191,191,191,109,109,109,
      0,255,  5,  7,  0,109,109,109,109,109,109,109,  0,255
};

unsigned char BigPic49[244]=
{
     11,  0, 16,  0,  0,  0,  0,  0, 52,  0,  0,  0, 59,  0,  0,  0,
     68,  0,  0,  0, 78,  0,  0,  0, 98,  0,  0,  0,119,  0,  0,  0,
    140,  0,  0,  0,161,  0,  0,  0,182,  0,  0,  0,203,  0,  0,  0,
    224,  0,  0,  0,  3,  2,  0,191,191,  0,255,  2,  4,  0,191,185,
    191,109,  0,255,  1,  5,  0,191,185,185,191,109,  0,255,  0, 15,
      0,191,183,183,183,191,191,191,191,191,191,191,191,191,191,191,
      0,255,  0, 16,  0,191,182,184,183,182,183,183,184,184,184,184,
    184,184,185,191,109,  0,255,  0, 16,  0,191,180,181,180,180,180,
    181,181,181,181,181,182,182,184,191,109,  0,255,  0, 16,  0,191,
    180,181,180,180,180,180,181,181,181,181,182,181,185,191,109,  0,
    255,  0, 16,  0,191,179,182,181,181,180,180,181,181,181,181,182,
    181,185,191,109,  0,255,  0, 16,  0,191,183,185,185,185,185,185,
    185,185,185,186,186,186,187,191,109,  0,255,  0, 16,  0,191,191,
    191,191,191,191,191,191,191,191,191,191,191,191,191,109,  0,255,
      1, 15,  0,109,109,109,109,109,109,109,109,109,109,109,109,109,
    109,109,  0,255
};

unsigned char BigPic50[334]=
{
     14,  0, 16,  0,  0,  0,  0,  0, 64,  0,  0,  0, 76,  0,  0,  0,
     99,  0,  0,  0,120,  0,  0,  0,141,  0,  0,  0,162,  0,  0,  0,
    183,  0,  0,  0,204,  0,  0,  0,225,  0,  0,  0,246,  0,  0,  0,
     10,  1,  0,  0, 30,  1,  0,  0, 49,  1,  0,  0, 69,  1,  0,  0,
      8,  7,  0,191,191,191,191,191,191,191,  0,255,  0,  5,  0,191,
    191,191,191,191,  0,  7,  9,  0,191,186,182,182,183,183,186,191,
    109,  0,255,  0, 16,  0,191,185,186,187,191,109,191,186,184,184,
    183,183,183,186,191,109,  0,255,  0, 16,  0,191,183,185,185,191,
    191,186,184,183,184,183,182,181,186,191,109,  0,255,  0, 16,  0,
    191,179,183,187,191,191,180,182,182,186,186,183,183,187,191,109,
      0,255,  0, 16,  0,191,180,182,186,191,191,178,186,188,191,191,
    177,181,185,191,109,  0,255,  0, 16,  0,191,180,184,186,191,191,
    179,183,186,191,191,177,181,185,191,109,  0,255,  0, 16,  0,191,
    182,184,187,191,191,180,182,185,191,191,177,181,184,191,109,  0,
    255,  0, 16,  0,191,183,186,184,186,186,181,181,185,191,191,177,
    179,183,191,109,  0,255,  1, 15,  0,188,185,184,183,182,181,181,
    187,191,191,177,178,183,191,109,  0,255,  1, 15,  0,191,186,181,
    181,180,182,186,191,109,191,182,184,185,191,109,  0,255,  2, 14,
      0,191,186,184,184,186,191,109,109,191,191,191,191,191,109,  0,
    255,  3,  6,  0,191,191,191,191,109,109,  0, 11,  5,  0,109,109,
    109,109,109,  0,255,  4,  4,  0,109,109,109,109,  0,255
};

unsigned char BigPic51[336]=
{
     14,  0, 16,  0,  0,  0,  0,  0, 64,  0,  0,  0, 83,  0,  0,  0,
    104,  0,  0,  0,125,  0,  0,  0,146,  0,  0,  0,167,  0,  0,  0,
    188,  0,  0,  0,209,  0,  0,  0,230,  0,  0,  0,251,  0,  0,  0,
     15,  1,  0,  0, 34,  1,  0,  0, 52,  1,  0,  0, 68,  1,  0,  0,
      0,  5,  0,191,191,191,191,191,  0, 10,  5,  0,191,191,191,191,
    191,  0,255,  0,  6,  0,191,185,186,187,191,109,  0, 10,  6,  0,
    191,182,184,187,191,109,  0,255,  0,  6,  0,191,179,183,187,191,
    109,  0, 10,  6,  0,191,177,182,187,191,109,  0,255,  0, 16,  0,
    191,178,182,187,191,191,191,191,191,191,191,177,182,187,191,109,
      0,255,  0, 16,  0,191,178,182,187,191,191,180,181,187,191,191,
    177,181,187,191,109,  0,255,  0, 16,  0,191,178,181,187,191,191,
    178,181,187,191,191,179,182,187,191,109,  0,255,  0, 16,  0,191,
    180,182,187,191,191,178,182,187,191,191,180,182,187,191,109,  0,
    255,  0, 16,  0,191,181,182,187,191,191,180,182,185,191,191,180,
    182,187,191,109,  0,255,  0, 16,  0,191,187,183,181,181,181,181,
    181,182,181,181,181,181,187,191,109,  0,255,  1, 15,  0,191,184,
    181,180,180,179,179,178,178,178,179,184,191,109,109,  0,255,  1,
     14,  0,191,188,184,184,183,181,181,181,182,181,184,188,191,109,
      0,255,  2, 13,  0,191,191,187,185,185,185,185,185,188,191,191,
    109,109,  0,255,  3, 11,  0,109,191,191,191,191,191,191,191,109,
    109,109,  0,255,  5,  7,  0,109,109,109,109,109,109,109,  0,255
};

unsigned char BigPic52[314]=
{
     14,  0, 16,  0,  0,  0,  0,  0, 64,  0,  0,  0, 79,  0,  0,  0,
     94,  0,  0,  0,110,  0,  0,  0,126,  0,  0,  0,142,  0,  0,  0,
    158,  0,  0,  0,169,  0,  0,  0,189,  0,  0,  0,210,  0,  0,  0,
    231,  0,  0,  0,252,  0,  0,  0, 17,  1,  0,  0, 38,  1,  0,  0,
      0, 10,  0,191,191,191,191,191,191,191,191,191,191,  0,255,  0,
     10,  0,191,185,186,186,185,185,185,185,185,191,  0,255,  0, 11,
      0,191,178,182,183,183,184,182,181,181,191,109,  0,255,  0, 11,
      0,191,177,182,183,183,184,182,181,182,191,109,  0,255,  0, 11,
      0,191,182,185,186,186,186,185,183,183,191,109,  0,255,  0, 11,
      0,191,191,191,191,191,191,182,184,186,191,109,  0,255,  5,  6,
      0,191,183,185,188,191,109,  0,255,  0, 15,  0,191,191,191,191,
    191,191,183,186,188,191,191,191,191,191,191,  0,255,  0, 16,  0,
    191,183,186,186,186,187,187,186,187,188,188,188,188, 44,191,109,
      0,255,  0, 16,  0,191,179,183,184,185,186,187,187,187,187,187,
    187,187,189,191,109,  0,255,  0, 16,  0,191,179,184,184,185,185,
    187,187,186,186,186,186,185,187,191,109,  0,255,  0, 16,  0,191,
    184,185,185,186,186,186,188,188,188,187,188,187,188,191,109,  0,
    255,  0, 16,  0,191,191,191,191,191,191,191,191,191,191,191,191,
    191, 47,191,109,  0,255,  1, 15,  0,109,109,109,109,109,109,109,
    109,109,109,109,109,109,109,109,  0,255
};

unsigned char BigPic53[348]=
{
     14,  0, 16,  0,  0,  0,  0,  0, 64,  0,  0,  0, 87,  0,  0,  0,
    108,  0,  0,  0,129,  0,  0,  0,150,  0,  0,  0,171,  0,  0,  0,
    192,  0,  0,  0,213,  0,  0,  0,234,  0,  0,  0,255,  0,  0,  0,
     20,  1,  0,  0, 40,  1,  0,  0, 63,  1,  0,  0, 83,  1,  0,  0,
      0,  9,  0,191,191,191,191,191,191,191,191,191,  0, 10,  5,  0,
    191,191,191,191,191,  0,255,  0, 16,  0,191,187,187,186,184,184,
    186,187,187,109,191,182,184,185,191,109,  0,255,  0, 16,  0,191,
    181,181,181,181,180,182,181,187,109,191,177,178,183,191,109,  0,
    255,  0, 16,  0,191,183,186,184,186,186,181,181,185,191,191,177,
    179,183,191,109,  0,255,  0, 16,  0,191,182,184,187,191,191,180,
    182,185,191,191,177,181,184,191,109,  0,255,  0, 16,  0,191,180,
    184,186,191,191,179,183,186,191,191,177,181,185,191,109,  0,255,
      0, 16,  0,191,179,186,187,191,191,178,185,187,191,191,180,184,
    185,191,109,  0,255,  0, 16,  0,191,179,185,187,191,191,179,183,
    185,191,191,185,184,186,191,109,  0,255,  0, 16,  0,191,179,183,
    187,191,191,181,182,182,186,186,183,183,187,191,109,  0,255,  0,
     16,  0,191,183,185,185,191,191,186,184,183,184,183,182,181,186,
    109,109,  0,255,  0, 15,  0,191,185,186,187,191,109,191,186,184,
    184,183,184,186,191,109,  0,255,  0,  6,  0,191,191,191,191,191,
    109,  0,  7,  8,  0,191,186,182,182,186,191,109,109,  0,255,  1,
      5,  0,109,109,109,109,109,  0,  8,  6,  0,191,191,191,191,109,
    109,  0,255,  9,  4,  0,109,109,109,109,  0,255
};

unsigned char BigPic54[338]=
{
     14,  0, 16,  0,  0,  0,  0,  0, 64,  0,  0,  0, 76,  0,  0,  0,
     92,  0,  0,  0,110,  0,  0,  0,129,  0,  0,  0,149,  0,  0,  0,
    170,  0,  0,  0,191,  0,  0,  0,212,  0,  0,  0,233,  0,  0,  0,
    254,  0,  0,  0, 19,  1,  0,  0, 39,  1,  0,  0, 62,  1,  0,  0,
      4,  7,  0,191,191,191,191,191,191,191,  0,255,  2, 11,  0,191,
    191,187,185,185,185,185,185,188,191,191,  0,255,  1, 13,  0,191,
    188,184,184,183,181,181,181,182,181,184,188,191,  0,255,  1, 14,
      0,191,184,181,180,180,179,179,178,178,178,179,184,191,109,  0,
    255,  0, 15,  0,191,187,183,181,181,181,181,181,182,181,181,181,
    181,187,191,  0,255,  0, 16,  0,191,181,182,187,191,191,180,182,
    185,191,191,180,182,187,191,109,  0,255,  0, 16,  0,191,180,182,
    187,191,191,178,182,187,191,191,180,182,187,191,109,  0,255,  0,
     16,  0,191,179,183,187,191,191,181,184,187,191,191,183,186,188,
    191,109,  0,255,  0, 16,  0,191,179,183,187,191,191,181,183,186,
    191,191,184,187,188,191,109,  0,255,  0, 16,  0,191,179,185,187,
    191,191,183,184,184,185,185,187,187,188,191,109,  0,255,  0, 16,
      0,191,181,186,187,191,109,191,183,183,184,184,185,188,191,109,
    109,  0,255,  0, 15,  0,191,185,186,187,191,109,191,185,185,185,
    185,185,187,191,109,  0,255,  0,  6,  0,191,191,191,191,191,109,
      0,  7,  8,  0,191,191,191,191,191,191,109,109,  0,255,  1,  5,
      0,109,109,109,109,109,  0,  8,  6,  0,109,109,109,109,109,109,
      0,255
};

unsigned char BigPic55[274]=
{
     14,  0, 16,  0,  0,  0,  0,  0, 64,  0,  0,  0, 74,  0,  0,  0,
     85,  0,  0,  0, 96,  0,  0,  0,107,  0,  0,  0,118,  0,  0,  0,
    129,  0,  0,  0,140,  0,  0,  0,160,  0,  0,  0,181,  0,  0,  0,
    201,  0,  0,  0,221,  0,  0,  0,240,  0,  0,  0,  2,  1,  0,  0,
      0,  5,  0,191,191,191,191,191,  0,255,  0,  6,  0,191,186,185,
    187,191,109,  0,255,  0,  6,  0,191,184,184,187,191,109,  0,255,
      0,  6,  0,191,181,184,187,191,109,  0,255,  0,  6,  0,191,181,
    185,187,191,109,  0,255,  0,  6,  0,191,181,183,187,191,109,  0,
    255,  0,  6,  0,191,183,183,187,191,109,  0,255,  0, 15,  0,191,
    184,183,187,191,191,191,191,191,191,191,191,191,191,191,  0,255,
      0, 16,  0,191,187,183,182,184,184,184,183,183,185,186,188,188,
    187,191,109,  0,255,  1, 15,  0,191,185,185,185,185,185,185,185,
    185,185,185,185,187,191,109,  0,255,  1, 15,  0,191,187,184,182,
    182,182,182,182,182,182,182,182,187,191,109,  0,255,  2, 14,  0,
    191,191,187,184,185,185,184,185,185,186,186,187,191,109,  0,255,
      3, 13,  0,109,191,191,191,191,191,191,191,191,191,191,191,109,
      0,255,  5, 11,  0,109,109,109,109,109,109,109,109,109,109,109,
      0,255
};

unsigned char BigPic56[346]=
{
     14,  0, 16,  0,  0,  0,  0,  0, 64,  0,  0,  0, 81,  0,  0,  0,
    102,  0,  0,  0,121,  0,  0,  0,142,  0,  0,  0,163,  0,  0,  0,
    184,  0,  0,  0,205,  0,  0,  0,226,  0,  0,  0,247,  0,  0,  0,
     12,  1,  0,  0, 32,  1,  0,  0, 52,  1,  0,  0, 73,  1,  0,  0,
      2,  4,  0,191,191,191,191,  0,  9,  4,  0,191,191,191,191,  0,
    255,  1,  6,  0,191,188,187,187,188,191,  0,  8,  6,  0,191,188,
    185,185,188,191,  0,255,  1, 14,  0,189,185,184,184,183,188,191,
    188,184,184,182,184,187,191,  0,255,  0, 16,  0,191,187,185,185,
    185,185,185,185,184,182,182,184,184,187,191,109,  0,255,  0, 16,
      0,191,184,184,184,180,180,184,183,183,180,180,184,185,187,191,
    109,  0,255,  0, 16,  0,191,178,182,185,191,191,178,183,187,191,
    191,180,181,187,191,109,  0,255,  0, 16,  0,191,178,181,184,191,
    191,179,183,187,191,191,178,182,187,191,109,  0,255,  0, 16,  0,
    191,182,184,186,191,191,181,183,187,191,191,180,184,187,191,109,
      0,255,  0, 16,  0,191,184,184,184,181,180,184,183,183,180,180,
    183,184,187,191,109,  0,255,  0, 16,  0,191,187,185,185,185,185,
    185,185,184,180,182,181,182,187,191,109,  0,255,  1, 15,  0,189,
    185,184,184,183,188,191,188,184,182,182,184,187,191,109,  0,255,
      1, 15,  0,191,188,187,187,188,191,109,191,188,185,185,188,191,
    109,109,  0,255,  2,  6,  0,191,191,191,191,109,109,  0,  9,  6,
      0,191,191,191,191,109,109,  0,255,  3,  4,  0,109,109,109,109,
      0, 10,  4,  0,109,109,109,109,  0,255
};

unsigned char BigPic57[336]=
{
     14,  0, 16,  0,  0,  0,  0,  0, 64,  0,  0,  0, 82,  0,  0,  0,
    103,  0,  0,  0,126,  0,  0,  0,146,  0,  0,  0,167,  0,  0,  0,
    188,  0,  0,  0,209,  0,  0,  0,230,  0,  0,  0,251,  0,  0,  0,
     15,  1,  0,  0, 34,  1,  0,  0, 52,  1,  0,  0, 68,  1,  0,  0,
      3,  4,  0,191,191,191,191,  0, 10,  5,  0,191,191,191,191,191,
      0,255,  2,  6,  0,191,188,184,184,188,191,  0, 10,  6,  0,191,
    182,184,187,191,109,  0,255,  1,  8,  0,191,185,185,185,185,185,
    187,191,  0, 10,  6,  0,191,180,182,187,191,109,  0,255,  1, 15,
      0,191,183,183,184,184,185,188,191,109,191,179,182,187,191,109,
      0,255,  0, 16,  0,191,183,184,184,185,185,185,185,188,191,191,
    178,182,187,191,109,  0,255,  0, 16,  0,191,180,183,186,191,191,
    182,182,188,191,191,177,182,187,191,109,  0,255,  0, 16,  0,191,
    180,182,187,191,191,178,182,187,191,191,180,182,187,191,109,  0,
    255,  0, 16,  0,191,181,182,187,191,191,180,182,185,191,191,180,
    182,187,191,109,  0,255,  0, 16,  0,191,187,183,182,182,182,181,
    181,186,186,186,181,181,187,191,109,  0,255,  1, 15,  0,191,184,
    181,180,180,179,179,178,178,178,179,184,191,109,109,  0,255,  1,
     14,  0,191,188,184,184,183,181,181,181,182,181,184,188,191,109,
      0,255,  2, 13,  0,191,191,187,185,185,185,185,185,188,191,191,
    109,109,  0,255,  3, 11,  0,109,191,191,191,191,191,191,191,109,
    109,109,  0,255,  5,  7,  0,109,109,109,109,109,109,109,  0,255
};

unsigned char BigPic65[266]=
{
     14,  0, 12,  0,  0,  0,  0,  0, 64,  0,  0,  0, 74,  0,  0,  0,
     86,  0,  0,  0,100,  0,  0,  0,115,  0,  0,  0,129,  0,  0,  0,
    141,  0,  0,  0,154,  0,  0,  0,167,  0,  0,  0,184,  0,  0,  0,
    201,  0,  0,  0,218,  0,  0,  0,235,  0,  0,  0,251,  0,  0,  0,
      7,  5,  0,191,191, 47, 47,191,  0,255,  5,  7,  0,191,191,186,
    183,181,184,191,  0,255,  3,  9,  0,191,191,186,184,181,178,178,
    183,191,  0,255,  2, 10,  0,191,186,184,181,181,180,179,186,191,
    191,  0,255,  1,  9,  0,191,187,184,182,181,182,186,191,191,  0,
    255,  1,  7,  0,191,184,182,183,186,191,191,  0,255,  0,  8,  0,
    191,183,185,186,191,191,191,191,  0,255,  0,  8,  0,191,182,184,
    191,191,180,185,191,  0,255,  0, 12,  0,191,178,186,191,191,180,
    187,191,191,191,191,191,  0,255,  0, 12,  0,191,178,187,185,185,
    183,185,185,186,186,187,191,  0,255,  0, 12,  0,191,179,181,182,
    182,182,182,183,183,183,186,191,  0,255,  0, 12,  0,191,186,183,
    183,184,183,184,183,182,181,185,191,  0,255,  1, 11,  0,191,188,
    186,185,186,186,185,186,186,187,191,  0,255,  2, 10,  0,191,191,
    191,191,191,191,191,191,191,191,  0,255
};

unsigned char BigPic66[321]=
{
     15,  0, 12,  0,  0,  0,  0,  0, 68,  0,  0,  0, 85,  0,  0,  0,
    102,  0,  0,  0,119,  0,  0,  0,136,  0,  0,  0,153,  0,  0,  0,
    170,  0,  0,  0,187,  0,  0,  0,204,  0,  0,  0,221,  0,  0,  0,
    238,  0,  0,  0,255,  0,  0,  0, 16,  1,  0,  0, 33,  1,  0,  0,
     49,  1,  0,  0,  0, 12,  0, 47, 47,191,191,191,191, 47, 47,191,
    191,191,191,  0,255,  0, 12,  0, 47,187,185,185,185,187,187,185,
    185,185,186,191,  0,255,  0, 12,  0,191,180,180,180,180,180,180,
    180,180,180,186,191,  0,255,  0, 12,  0,191,180,180,179,180,180,
    180,180,179,180,185,191,  0,255,  0, 12,  0,191,184,184,184,183,
    183,184,184,184,183,186,191,  0,255,  0, 12,  0,191,178,187,191,
    191,179,188,191,191,179,188,191,  0,255,  0, 12,  0,191,178,188,
    191,191,178,186,191,191,178,186,191,  0,255,  0, 12,  0,191,178,
    187,191,191,178,185,191,191,179,187,191,  0,255,  0, 12,  0,191,
    180,186,191,191,178,186,191,191,182,186,191,  0,255,  0, 12,  0,
    191,182,186,191,191,180,188,191,191,181,185,191,  0,255,  0, 12,
      0,191,180,186,191,191,180,188,188,187,182,185,191,  0,255,  0,
     12,  0,191,185,182,184,186,182,184,184,184,184,186,191,  0,255,
      0, 12,  0,191,185,186,184,186,186,184,185,185,184,188,191,  0,
    255,  0, 11,  0,191,186,186,187,186,191,187,186,186,187,191,  0,
    255,  1,  3,  0,191,191,191,  0,  6,  4,  0,191,191,191,191,  0,
    255
};

unsigned char BigPic67[273]=
{
     13,  0, 12,  0,  0,  0,  0,  0, 60,  0,  0,  0, 73,  0,  0,  0,
     88,  0,  0,  0,103,  0,  0,  0,120,  0,  0,  0,137,  0,  0,  0,
    154,  0,  0,  0,171,  0,  0,  0,188,  0,  0,  0,205,  0,  0,  0,
    222,  0,  0,  0,239,  0,  0,  0,  0,  1,  0,  0,  2,  8,  0,191,
    191, 47, 47, 47, 47,191,191,  0,255,  1, 10,  0,191,187,184,184,
    184,184,184,184,188,191,  0,255,  1, 10,  0,191,182,185,185,186,
    186,187,187,187,191,  0,255,  0, 12,  0,191,187,188,188,188,188,
    187,188,188,188, 44,191,  0,255,  0, 12,  0,191,184,188,189,191,
    191,191,191,184,187,187,191,  0,255,  0,  4,  0,191,184,188,191,
      0,  8,  4,  0,191,180,187,191,  0,255,  0,  4,  0,191,182,188,
    191,  0,  8,  4,  0,191,178,184,191,  0,255,  0,  4,  0,191,178,
    184,191,  0,  8,  4,  0,191,180,187,191,  0,255,  0,  4,  0,191,
    178,186,191,  0,  8,  4,  0,191,178,186,191,  0,255,  0,  4,  0,
    191,178,184,191,  0,  8,  4,  0,191,179,186,191,  0,255,  0,  4,
      0,191,178,185,191,  0,  8,  4,  0,191,178,186,191,  0,255,  0,
      4,  0,191,182,186,191,  0,  8,  4,  0,191,182,185,191,  0,255,
      0,  4,  0,191,191,191,191,  0,  8,  4,  0,191,191,191,191,  0,
    255
};

unsigned char BigPic68[307]=
{
     15,  0, 12,  0,  0,  0,  0,  0, 68,  0,  0,  0, 85,  0,  0,  0,
    102,  0,  0,  0,119,  0,  0,  0,136,  0,  0,  0,153,  0,  0,  0,
    170,  0,  0,  0,187,  0,  0,  0,204,  0,  0,  0,221,  0,  0,  0,
    238,  0,  0,  0,255,  0,  0,  0, 14,  1,  0,  0, 29,  1,  0,  0,
     42,  1,  0,  0,  0, 12,  0,191, 45, 47,191,191,191,191,191,191,
    191,191,191,  0,255,  0, 12,  0,191,184,187,191,191,184,185,184,
    184,184,186,191,  0,255,  0, 12,  0,191,178,186,191,191,181,183,
    183,182,183,185,191,  0,255,  0, 12,  0,191,178,185,191,191,181,
    184,183,182,181,185,191,  0,255,  0, 12,  0,191,178,185,191,191,
    184,185,185,184,180,184,191,  0,255,  0, 12,  0,191,178,185,191,
    191,191,191,191,191,178,184,191,  0,255,  0,  4,  0,191,177,184,
    191,  0,  8,  4,  0,191,177,184,191,  0,255,  0,  4,  0,191,177,
    184,191,  0,  8,  4,  0,191,177,184,191,  0,255,  0,  4,  0,191,
    178,185,191,  0,  8,  4,  0,191,180,185,191,  0,255,  0, 12,  0,
    191,180,182,185,191,191,191,191,180,181,185,191,  0,255,  0, 12,
      0,191,186,182,181,181,181,181,180,180,179,186,191,  0,255,  1,
     10,  0,191,181,180,178,178,178,178,178,183,191,  0,255,  1, 10,
      0,191,187,182,182,180,179,179,183,187,191,  0,255,  2,  8,  0,
    191,191,187,185,185,187,191,191,  0,255,  4,  4,  0,191,191,191,
    191,  0,255
};

unsigned char BigPic69[286]=
{
     14,  0, 12,  0,  0,  0,  0,  0, 64,  0,  0,  0, 73,  0,  0,  0,
     86,  0,  0,  0,101,  0,  0,  0,116,  0,  0,  0,133,  0,  0,  0,
    150,  0,  0,  0,167,  0,  0,  0,184,  0,  0,  0,201,  0,  0,  0,
    218,  0,  0,  0,235,  0,  0,  0,252,  0,  0,  0, 13,  1,  0,  0,
      4,  4,  0,191,191,191,191,  0,255,  2,  8,  0,191,191,186,185,
    185,186,191,191,  0,255,  1, 10,  0,191,188,185,182,182,182,181,
    183,188,191,  0,255,  1, 10,  0,191,183,181,181,181,182,181,178,
    185,191,  0,255,  0, 12,  0,191,185,182,181,181,181,181,180,179,
    179,186,191,  0,255,  0, 12,  0,191,180,182,185,185,181,182,185,
    185,181,184,191,  0,255,  0, 12,  0,191,182,186,191,191,181,186,
    191,191,179,185,191,  0,255,  0, 12,  0,191,179,187,191,191,180,
    188,191,191,178,185,191,  0,255,  0, 12,  0,191,179,186,191,191,
    180,187,191,191,178,186,191,  0,255,  0, 12,  0,191,180,188,191,
    191,180,188,191,191,178,185,191,  0,255,  0, 12,  0,191,180,188,
    191,191,178,186,191,191,179,186,191,  0,255,  0, 12,  0,191,179,
    185,191,191,178,185,191,191,180,186,191,  0,255,  0, 12,  0,191,
    184,187,191,191,185,187,191,191,183,186,191,  0,255,  0, 12,  0,
    191,191,191,191,191,191,191,191,191,191,191,191,  0,255
};

unsigned char BigPic70[224]=
{
     12,  0, 12,  0,  0,  0,  0,  0, 56,  0,  0,  0, 73,  0,  0,  0,
     90,  0,  0,  0,107,  0,  0,  0,124,  0,  0,  0,141,  0,  0,  0,
    158,  0,  0,  0,171,  0,  0,  0,184,  0,  0,  0,197,  0,  0,  0,
    206,  0,  0,  0,215,  0,  0,  0,  0, 12,  0,191,191,191,191,191,
    191,191,191,191,191, 47,191,  0,255,  0, 12,  0,191,187,187,187,
    187,185,185,184,185,185,186,191,  0,255,  0, 12,  0,191,180,184,
    184,184,183,182,183,182,182,186,191,  0,255,  0, 12,  0,191,181,
    184,186,184,181,180,181,179,178,183,191,  0,255,  0, 12,  0,191,
    180,182,181,181,180,180,185,184,184,186,191,  0,255,  0, 12,  0,
    191,180,185,191,191,177,185,191,191,191,191,191,  0,255,  0,  8,
      0,191,177,185,191,191,177,184,191,  0,255,  0,  8,  0,191,177,
    185,191,191,182,186,191,  0,255,  0,  8,  0,191,177,184,191,191,
    191,191,191,  0,255,  0,  4,  0,191,178,184,191,  0,255,  0,  4,
      0,191,183,186,191,  0,255,  0,  4,  0,191,191,191,191,  0,255
};

unsigned char BigPic71[346]=
{
     16,  0, 12,  0,  0,  0,  0,  0, 72,  0,  0,  0, 81,  0,  0,  0,
     94,  0,  0,  0,109,  0,  0,  0,124,  0,  0,  0,141,  0,  0,  0,
    158,  0,  0,  0,175,  0,  0,  0,192,  0,  0,  0,209,  0,  0,  0,
    226,  0,  0,  0,246,  0,  0,  0, 10,  1,  0,  0, 30,  1,  0,  0,
     50,  1,  0,  0, 70,  1,  0,  0,  4,  4,  0,191,191,191,191,  0,
    255,  2,  8,  0,191,191,187,186,186,186,191,191,  0,255,  1, 10,
      0,191,188,182,183,184,184,181,179,188,191,  0,255,  1, 10,  0,
    191,184,184,184,184,184,184,184,183,191,  0,255,  0, 12,  0,191,
    187,185,185,185,186,186,187,187,187,189,191,  0,255,  0, 12,  0,
    191,184,188,188,191,191,191,191,188,188, 44,191,  0,255,  0,  4,
      0,191,184,189,191,  0,  8,  4,  0,191,183,187,191,  0,255,  0,
      4,  0,191,181,188,191,  0,  8,  4,  0,191,178,187,191,  0,255,
      0,  4,  0,191,180,188,191,  0,  8,  4,  0,191,177,184,191,  0,
    255,  0,  4,  0,191,178,184,191,  0,  8,  4,  0,191,178,187,191,
      0,255,  0,  4,  0,191,178,186,191,  0,  5,  7,  0,191,191,191,
    191,179,186,191,  0,255,  0,  4,  0,191,178,184,191,  0,  5,  7,
      0,191,182,184,185,184,186,191,  0,255,  0,  4,  0,191,178,185,
    191,  0,  5,  7,  0,191,177,178,178,178,183,191,  0,255,  0,  4,
      0,191,180,185,191,  0,  5,  7,  0,191,177,177,177,177,183,191,
      0,255,  0,  4,  0,191,185,187,191,  0,  5,  7,  0,191,184,185,
    185,185,186,191,  0,255,  0,  4,  0,191,191,191,191,  0,  5,  7,
      0,191,191,191,191,191,191,191,  0,255
};

unsigned char BigPic72[299]=
{
     15,  0, 12,  0,  0,  0,  0,  0, 68,  0,  0,  0, 85,  0,  0,  0,
    102,  0,  0,  0,119,  0,  0,  0,136,  0,  0,  0,153,  0,  0,  0,
    170,  0,  0,  0,179,  0,  0,  0,188,  0,  0,  0,197,  0,  0,  0,
    214,  0,  0,  0,231,  0,  0,  0,248,  0,  0,  0,  9,  1,  0,  0,
     26,  1,  0,  0,  0, 12,  0,191,191,191,191,191,191,191,191,191,
    191,191,191,  0,255,  0, 12,  0,191,184,186,186,186,186,186,185,
    185,185,186, 45,  0,255,  0, 12,  0,191,180,185,184,184,184,183,
    182,181,182,185,191,  0,255,  0, 12,  0,191,180,184,184,184,184,
    183,183,182,183,185,191,  0,255,  0, 12,  0,191,183,184,185,185,
    184,186,186,186,185,187, 45,  0,255,  0, 12,  0,191,191,191,191,
    191,182,186,191,191,191,191,191,  0,255,  4,  4,  0,191,180,186,
    191,  0,255,  4,  4,  0,191,178,185,191,  0,255,  4,  4,  0,191,
    178,185,191,  0,255,  0, 12,  0,191,191,191,191,191,179,185,191,
    191,191,191,191,  0,255,  0, 12,  0,191,183,184,184,184,182,185,
    185,185,184,186,191,  0,255,  0, 12,  0,191,178,182,181,181,181,
    181,180,180,179,184,191,  0,255,  0, 12,  0,191,178,181,180,178,
    178,178,178,178,179,183,191,  0,255,  0, 12,  0,191,183,186,185,
    185,183,183,183,183,183,186,191,  0,255,  0, 12,  0,191,191,191,
    191,191,191,191,191,191,191,191,191,  0,255
};

unsigned char BigPic73[134]=
{
      6,  0, 12,  0,  0,  0,  0,  0, 32,  0,  0,  0, 49,  0,  0,  0,
     66,  0,  0,  0, 83,  0,  0,  0,100,  0,  0,  0,117,  0,  0,  0,
      0, 12,  0,191,191,191,191,191,191,191,191,191,191,191,191,  0,
    255,  0, 12,  0,191,183,185,184,185,185,185,184,184,184,186,191,
      0,255,  0, 12,  0,191,179,185,186,186,186,187,185,183,181,185,
    191,  0,255,  0, 12,  0,191,179,184,184,186,185,185,187,185,184,
    186,191,  0,255,  0, 12,  0,191,184,187,186,186,186,187,187,186,
    185,186,191,  0,255,  0, 12,  0,191,191,191,191,191,191,191,191,
    191,191,191,191,  0,255
};

unsigned char BigPic74[278]=
{
     16,  0, 12,  0,  0,  0,  0,  0, 72,  0,  0,  0, 80,  0,  0,  0,
     90,  0,  0,  0,101,  0,  0,  0,112,  0,  0,  0,124,  0,  0,  0,
    136,  0,  0,  0,151,  0,  0,  0,160,  0,  0,  0,169,  0,  0,  0,
    184,  0,  0,  0,201,  0,  0,  0,218,  0,  0,  0,234,  0,  0,  0,
    250,  0,  0,  0,  9,  1,  0,  0,  5,  3,  0, 47,191,191,  0,255,
      5,  5,  0, 47,188,187,191,191,  0,255,  5,  6,  0, 47,187,187,
    187,189,191,  0,255,  5,  6,  0, 47,186,186,186,184,191,  0,255,
      5,  7,  0, 47,185,184,182,184,188,191,  0,255,  5,  7,  0, 47,
    191,191,180,178,186,191,  0,255,  5,  2,  0, 47, 47,  0,  8,  4,
      0,191,177,186,191,  0,255,  8,  4,  0,191,178,187,191,  0,255,
      8,  4,  0,191,180,189,191,  0,255,  0,  2,  0, 47, 47,  0,  8,
      4,  0,191,180,188,191,  0,255,  0, 12,  0,191,191,191,191,191,
    191,191,191,186,184,185,191,  0,255,  0, 12,  0,191,184,186,185,
    185,187,187,187,185,183,188,191,  0,255,  0, 11,  0,191,180,185,
    183,184,186,187,186,184,182,191,  0,255,  0, 11,  0,191,178,181,
    183,184,186,186,185,184,188,191,  0,255,  0, 10,  0,191,182,182,
    183,184,185,185,187,191,191,  0,255,  0,  8,  0,191,191,191,191,
    191,191,191,191,  0,255
};

unsigned char BigPic75[307]=
{
     15,  0, 12,  0,  0,  0,  0,  0, 68,  0,  0,  0, 85,  0,  0,  0,
    102,  0,  0,  0,119,  0,  0,  0,136,  0,  0,  0,153,  0,  0,  0,
    170,  0,  0,  0,180,  0,  0,  0,192,  0,  0,  0,206,  0,  0,  0,
    222,  0,  0,  0,239,  0,  0,  0,  3,  1,  0,  0, 21,  1,  0,  0,
     37,  1,  0,  0,  0, 12,  0,191,191,191,191,191,191,191,191,191,
    191,191,191,  0,255,  0, 12,  0,191,182,183,182,183,185,184,183,
    184,182,185,191,  0,255,  0, 12,  0,191,178,182,179,178,179,179,
    180,181,181,184,191,  0,255,  0, 12,  0,191,177,179,180,177,178,
    178,178,178,179,184,191,  0,255,  0, 12,  0,191,181,180,182,183,
    180,183,183,182,182,185,191,  0,255,  0, 12,  0,191,191,191,191,
    191,181,191,191,191,191,191,191,  0,255,  3,  5,  0,191,178,182,
    185,191,  0,255,  2,  7,  0,191,178,181,183,180,184,191,  0,255,
      1,  9,  0,191,177,180,180,180,179,179,184,191,  0,255,  0, 11,
      0,191,177,180,180,179,180,179,178,178,183, 47,  0,255,  0, 12,
      0,191,177,182,180,185,191,178,179,179,180,187,191,  0,255,  0,
      5,  0,191,177,181,184,191,  0,  6,  6,  0,191,181,184,184,188,
    191,  0,255,  0,  4,  0,191,177,186,191,  0,  7,  5,  0,191,180,
    183,186,191,  0,255,  0,  3,  0,191,184,191,  0,  8,  4,  0,191,
    181,187,191,  0,255,  0,  2,  0,191,191,  0,  9,  3,  0,191, 47,
    191,  0,255
};

unsigned char BigPic76[195]=
{
     11,  0, 12,  0,  0,  0,  0,  0, 52,  0,  0,  0, 67,  0,  0,  0,
     83,  0,  0,  0, 99,  0,  0,  0,116,  0,  0,  0,133,  0,  0,  0,
    150,  0,  0,  0,159,  0,  0,  0,168,  0,  0,  0,177,  0,  0,  0,
    186,  0,  0,  0,  0, 10,  0,191,191,191,191,191,191,191,191,191,
    191,  0,255,  0, 11,  0,191,186,188,187,187,187,186,185,185,191,
    191,  0,255,  0, 11,  0,191,180,185,186,187,184,184,182,182,184,
    191,  0,255,  0, 12,  0,191,178,182,186,186,185,184,185,184,185,
    187,191,  0,255,  0, 12,  0,191,183,187,187,187,186,185,187,187,
    185,187,191,  0,255,  0, 12,  0,191,191,191,191,191,191,191,191,
    185,178,183,191,  0,255,  8,  4,  0,191,179,185,191,  0,255,  8,
      4,  0,191,180,185,191,  0,255,  8,  4,  0,191,179,184,191,  0,
    255,  8,  4,  0,191,182,185,191,  0,255,  8,  4,  0,191,191,191,
    191,  0,255
};

unsigned char BigPic77[316]=
{
     16,  0, 12,  0,  0,  0,  0,  0, 72,  0,  0,  0, 87,  0,  0,  0,
    103,  0,  0,  0,120,  0,  0,  0,137,  0,  0,  0,154,  0,  0,  0,
    170,  0,  0,  0,182,  0,  0,  0,194,  0,  0,  0,206,  0,  0,  0,
    218,  0,  0,  0,234,  0,  0,  0,251,  0,  0,  0, 12,  1,  0,  0,
     29,  1,  0,  0, 45,  1,  0,  0,  2, 10,  0,191,191,191,191,191,
    191,191,191,191,191,  0,255,  1, 11,  0,191,184,183,184,182,182,
    182,181,181,184,191,  0,255,  0, 12,  0,191,181,178,179,179,179,
    179,180,180,179,184,191,  0,255,  0, 12,  0,191,177,177,179,181,
    181,180,179,180,179,184,191,  0,255,  0, 12,  0,191,182,181,182,
    184,182,183,184,183,183,185,191,  0,255,  1, 11,  0,191,182,187,
    187,188,188,191,191,191,191,191,  0,255,  2,  7,  0,191,183,187,
    187,187,188,191,  0,255,  3,  7,  0,191,180,186,186,186,186,191,
      0,255,  3,  7,  0,191,180,185,184,182,185,191,  0,255,  2,  7,
      0,191,179,181,181,182,185,191,  0,255,  1, 11,  0,191,181,185,
    183,182,181,191,191,191,191,191,  0,255,  0, 12,  0,191,180,184,
    183,181,180,179,183,184,184,186,191,  0,255,  0, 12,  0,191,177,
    180,182,183,184,186,186,186,187,188,191,  0,255,  0, 12,  0,191,
    179,182,184,184,186,186,187,186,185,187,191,  0,255,  1, 11,  0,
    191,184,187,187,188, 42,187,187,185,186,191,  0,255,  2, 10,  0,
    191,191,191,191,191,191,191,191,191,191,  0,255
};

unsigned char BigPic78[297]=
{
     15,  0, 12,  0,  0,  0,  0,  0, 68,  0,  0,  0, 84,  0,  0,  0,
    101,  0,  0,  0,118,  0,  0,  0,135,  0,  0,  0,151,  0,  0,  0,
    163,  0,  0,  0,175,  0,  0,  0,187,  0,  0,  0,198,  0,  0,  0,
    215,  0,  0,  0,232,  0,  0,  0,249,  0,  0,  0, 10,  1,  0,  0,
     26,  1,  0,  0,  1, 11,  0,191, 47, 47, 47, 47, 47, 47, 47, 47,
     47,191,  0,255,  0, 12,  0,191,177,180,182,181,182,182,182,181,
    181,185,191,  0,255,  0, 12,  0,191,177,181,181,181,182,181,180,
    179,179,184,191,  0,255,  0, 12,  0,191,186,180,181,180,182,180,
    183,184,184,186,191,  0,255,  1, 11,  0,191,186,182,182,182,182,
    191,191,191,191,191,  0,255,  2,  7,  0,191,186,182,182,182,186,
    191,  0,255,  3,  7,  0,191,186,182,180,178,186,191,  0,255,  4,
      7,  0,191,186,178,178,178,186,191,  0,255,  5,  6,  0,191,186,
    180,181,179,191,  0,255,  0, 12,  0,191,191,191,191,191,191,191,
    180,180,178,186,191,  0,255,  0, 12,  0,191,184,182,182,183,183,
    182,178,178,178,184,191,  0,255,  0, 12,  0,191,176,176,176,176,
    176,176,176,176,176,182,191,  0,255,  0, 12,  0,191,177,180,181,
    180,179,179,179,179,178,184,191,  0,255,  0, 11,  0,191,184,184,
    185,185,185,185,185,185,187,191,  0,255,  0, 10,  0,191,191,191,
    191,191,191,191,191,191,191,  0,255
};

unsigned char BigPic79[307]=
{
     15,  0, 12,  0,  0,  0,  0,  0, 68,  0,  0,  0, 81,  0,  0,  0,
     96,  0,  0,  0,111,  0,  0,  0,128,  0,  0,  0,145,  0,  0,  0,
    162,  0,  0,  0,179,  0,  0,  0,196,  0,  0,  0,213,  0,  0,  0,
    230,  0,  0,  0,247,  0,  0,  0,  8,  1,  0,  0, 23,  1,  0,  0,
     38,  1,  0,  0,  2,  8,  0,191,191, 47, 47, 47, 47,191,191,  0,
    255,  1, 10,  0,191,187,178,180,180,180,180,178,187,191,  0,255,
      1, 10,  0,191,177,179,181,181,180,179,178,183,191,  0,255,  0,
     12,  0,191,185,181,181,184,184,184,182,179,178,185,191,  0,255,
      0, 12,  0,191,179,181,187,191,191,191,191,181,181,185,191,  0,
    255,  0,  4,  0,191,177,184,191,  0,  8,  4,  0,191,177,184,191,
      0,255,  0,  4,  0,191,177,184,191,  0,  8,  4,  0,191,177,183,
    191,  0,255,  0,  4,  0,191,177,187,191,  0,  8,  4,  0,191,177,
    185,191,  0,255,  0,  4,  0,191,177,187,191,  0,  8,  4,  0,191,
    179,188,191,  0,255,  0,  4,  0,191,177,186,191,  0,  8,  4,  0,
    191,180,186,191,  0,255,  0, 12,  0,191,180,182,188,191,191,191,
    191,182,184,187,191,  0,255,  0, 12,  0,191,185,183,183,185,185,
    185,186,185,186,187,191,  0,255,  1, 10,  0,191,184,184,184,186,
    187,187,186,184,191,  0,255,  1, 10,  0,191,187,181,182,185,187,
    187,186,188,191,  0,255,  2,  8,  0,191,191, 47, 47, 47, 47,191,
    191,  0,255
};

unsigned char BigPic80[264]=
{
     14,  0, 12,  0,  0,  0,  0,  0, 64,  0,  0,  0, 81,  0,  0,  0,
     98,  0,  0,  0,115,  0,  0,  0,132,  0,  0,  0,149,  0,  0,  0,
    166,  0,  0,  0,179,  0,  0,  0,192,  0,  0,  0,205,  0,  0,  0,
    218,  0,  0,  0,231,  0,  0,  0,244,  0,  0,  0,255,  0,  0,  0,
      0, 12,  0,191,191,191,191,191,191,191,191,191,191,191,191,  0,
    255,  0, 12,  0,191,183,186,191,191,183,185,186,185,186,187,191,
      0,255,  0, 12,  0,191,178,188,191,191,178,183,186,186,184,188,
    191,  0,255,  0, 12,  0,191,178,185,191,191,177,177,179,180,181,
    187,191,  0,255,  0, 12,  0,191,178,185,191,191,177,178,177,179,
    180,185,191,  0,255,  0, 12,  0,191,177,182,191,191,178,185,191,
    191,191,191,191,  0,255,  0,  8,  0,191,177,184,191,191,177,182,
    191,  0,255,  0,  8,  0,191,177,182,191,191,177,182,191,  0,255,
      0,  8,  0,191,177,184,191,191,179,185,191,  0,255,  0,  8,  0,
    191,180,182,180,179,181,185,191,  0,255,  0,  8,  0,191,182,182,
    179,179,179,183,191,  0,255,  0,  8,  0,191,186,181,180,181,179,
    186,191,  0,255,  1,  6,  0,191,186,182,182,186,191,  0,255,  2,
      4,  0,191,191,191,191,  0,255
};

unsigned char BigPic81[297]=
{
     15,  0, 12,  0,  0,  0,  0,  0, 68,  0,  0,  0, 80,  0,  0,  0,
     94,  0,  0,  0,109,  0,  0,  0,125,  0,  0,  0,141,  0,  0,  0,
    157,  0,  0,  0,173,  0,  0,  0,189,  0,  0,  0,206,  0,  0,  0,
    223,  0,  0,  0,240,  0,  0,  0,  1,  1,  0,  0, 15,  1,  0,  0,
     29,  1,  0,  0,  2,  7,  0,191,191, 47, 47, 47, 47,191,  0,255,
      1,  9,  0,191,187,178,180,180,180,180, 47, 47,  0,255,  1, 10,
      0,191,177,179,181,181,180,179,178, 47,191,  0,255,  0, 11,  0,
    191,185,181,181,184,184,184,182,179,178, 47,  0,255,  0, 11,  0,
    191,179,181,187,191,191,191,191,181,181, 47,  0,255,  0,  4,  0,
    191,177,184,191,  0,  8,  3,  0,191,177, 47,  0,255,  0,  4,  0,
    191,177,184,191,  0,  8,  3,  0,191,177, 47,  0,255,  0,  4,  0,
    191,177,187,191,  0,  8,  3,  0,191,177, 47,  0,255,  0,  4,  0,
    191,177,187,191,  0,  8,  4,  0,191,179, 47,191,  0,255,  0,  4,
      0,191,177,186,191,  0,  8,  4,  0,191,187,186, 47,  0,255,  0,
     12,  0,191,180,182,188,191,191,191,191,187,187,187, 47,  0,255,
      0, 12,  0,191,185,183,183,185,185,185,186,185, 47, 47,191,  0,
    255,  1,  9,  0,191,184,184,184,186,187,187,186, 47,  0,255,  1,
      9,  0,191,187,181,182,185,187,187, 47, 47,  0,255,  2,  7,  0,
    191,191, 47, 47, 47, 47,191,  0,255
};

unsigned char BigPic82[310]=
{
     15,  0, 12,  0,  0,  0,  0,  0, 68,  0,  0,  0, 85,  0,  0,  0,
    102,  0,  0,  0,119,  0,  0,  0,136,  0,  0,  0,153,  0,  0,  0,
    170,  0,  0,  0,183,  0,  0,  0,196,  0,  0,  0,209,  0,  0,  0,
    226,  0,  0,  0,243,  0,  0,  0,  4,  1,  0,  0, 21,  1,  0,  0,
     37,  1,  0,  0,  0, 12,  0,191,191,191,191,191,191,191,191,191,
    191,191,191,  0,255,  0, 12,  0,191,184,186,191,191,183,184,183,
    182,182,185,191,  0,255,  0, 12,  0,191,177,184,191,191,178,180,
    180,181,181,186,191,  0,255,  0, 12,  0,191,178,185,191,191,177,
    182,181,180,180,186,191,  0,255,  0, 12,  0,191,177,184,191,191,
    177,182,181,182,182,185,191,  0,255,  0, 12,  0,191,177,185,191,
    191,177,184,191,191,191,191,191,  0,255,  0,  8,  0,191,177,185,
    191,191,177,186,191,  0,255,  0,  8,  0,191,177,185,191,191,177,
    186,191,  0,255,  0,  8,  0,191,177,184,191,191,179,185,191,  0,
    255,  0, 12,  0,191,178,183,191,191,178,183,186,191,191,191,191,
      0,255,  0, 12,  0,191,178,183,184,184,179,179,178,178,179,184,
    191,  0,255,  0, 12,  0,191,178,180,181,180,179,179,179,179,178,
    186,191,  0,255,  0, 12,  0,191,186,178,179,181,181,180,180,179,
    178,185,191,  0,255,  1, 11,  0,191,186,182,184,191,191,183,184,
    182,185,191,  0,255,  2,  3,  0,191,191,191,  0,  7,  5,  0,191,
    191,191,191,191,  0,255
};

unsigned char BigPic83[306]=
{
     14,  0, 12,  0,  0,  0,  0,  0, 64,  0,  0,  0, 83,  0,  0,  0,
    100,  0,  0,  0,117,  0,  0,  0,134,  0,  0,  0,151,  0,  0,  0,
    168,  0,  0,  0,185,  0,  0,  0,202,  0,  0,  0,219,  0,  0,  0,
    236,  0,  0,  0,253,  0,  0,  0, 14,  1,  0,  0, 33,  1,  0,  0,
      1,  6,  0,191, 47, 47, 47, 47,191,  0,  8,  4,  0,191, 47, 47,
    191,  0,255,  0, 12,  0,191,182,180,180,180,180,186,191,191,178,
    186,191,  0,255,  0, 12,  0,191,179,180,180,179,180,188,191,191,
    177,185,191,  0,255,  0, 12,  0,191,178,184,184,184,183,186,191,
    191,177,186,191,  0,255,  0, 12,  0,191,178,187,191,191,179,188,
    191,191,179,188,191,  0,255,  0, 12,  0,191,178,188,191,191,178,
    186,191,191,178,186,191,  0,255,  0, 12,  0,191,178,187,191,191,
    178,185,191,191,179,187,191,  0,255,  0, 12,  0,191,180,186,191,
    191,178,186,191,191,182,186,191,  0,255,  0, 12,  0,191,182,186,
    191,191,180,188,191,191,181,185,191,  0,255,  0, 12,  0,191,180,
    186,191,191,180,188,188,187,182,185,191,  0,255,  0, 12,  0,191,
    183,189,191,191,182,184,184,184,184,186,191,  0,255,  0, 12,  0,
    191,185, 45,191,191,186,184,185,185,184,188,191,  0,255,  0,  4,
      0,191,186,188,191,  0,  5,  6,  0,191,187,186,186,187,191,  0,
    255,  0,  4,  0,191,191,191,191,  0,  6,  4,  0,191,191,191,191,
      0,255
};

unsigned char BigPic84[212]=
{
     12,  0, 12,  0,  0,  0,  0,  0, 56,  0,  0,  0, 65,  0,  0,  0,
     74,  0,  0,  0, 83,  0,  0,  0,100,  0,  0,  0,117,  0,  0,  0,
    134,  0,  0,  0,151,  0,  0,  0,168,  0,  0,  0,185,  0,  0,  0,
    194,  0,  0,  0,203,  0,  0,  0,  0,  4,  0,191,191,191,191,  0,
    255,  0,  4,  0,191,184,187,191,  0,255,  0,  4,  0,191,178,187,
    191,  0,255,  0, 12,  0,191,177,182,191,191,191,191,191,191,191,
    191,191,  0,255,  0, 12,  0,191,177,182,181,181,181,181,181,181,
    182,185,191,  0,255,  0, 12,  0,191,177,177,178,179,177,177,178,
    179,179,184,191,  0,255,  0, 12,  0,191,177,179,179,182,181,181,
    180,179,179,184,191,  0,255,  0, 12,  0,191,178,182,183,182,184,
    184,184,183,182,185,191,  0,255,  0, 12,  0,191,178,185,191,191,
    191,191,191,191,191,191,191,  0,255,  0,  4,  0,191,178,187,191,
      0,255,  0,  4,  0,191,181,187,191,  0,255,  0,  4,  0,191,191,
     47,191,  0,255
};

unsigned char BigPic85[296]=
{
     16,  0, 12,  0,  0,  0,  0,  0, 72,  0,  0,  0, 85,  0,  0,  0,
    100,  0,  0,  0,116,  0,  0,  0,132,  0,  0,  0,149,  0,  0,  0,
    166,  0,  0,  0,175,  0,  0,  0,184,  0,  0,  0,193,  0,  0,  0,
    202,  0,  0,  0,219,  0,  0,  0,236,  0,  0,  0,252,  0,  0,  0,
     12,  1,  0,  0, 27,  1,  0,  0,  0,  8,  0,191,191,191,191,191,
    191,191,191,  0,255,  0, 10,  0,191,183,186,187,187,188,188,187,
    191,191,  0,255,  0, 11,  0,191,178,187,187,187,187,187,187,187,
    189,191,  0,255,  0, 11,  0,191,178,187,187,187,186,186,186,186,
    184,191,  0,255,  0, 12,  0,191,185,187,186,186,186,185,184,182,
    184,188,191,  0,255,  0, 12,  0,191,191,191,191,191,191,191,191,
    180,178,186,191,  0,255,  8,  4,  0,191,177,186,191,  0,255,  8,
      4,  0,191,178,187,191,  0,255,  8,  4,  0,191,180,189,191,  0,
    255,  8,  4,  0,191,180,188,191,  0,255,  0, 12,  0,191,191,191,
    191,191,191,191,191,186,184,185,191,  0,255,  0, 12,  0,191,184,
    186,185,185,187,187,187,185,183,188,191,  0,255,  0, 11,  0,191,
    180,185,183,184,186,187,186,184,182,191,  0,255,  0, 11,  0,191,
    178,181,183,184,186,186,185,184,188,191,  0,255,  0, 10,  0,191,
    182,182,183,184,185,185,187,191,191,  0,255,  0,  8,  0,191,191,
    191,191,191,191,191,191,  0,255
};

unsigned char BigPic86[254]=
{
     14,  0, 12,  0,  0,  0,  0,  0, 64,  0,  0,  0, 74,  0,  0,  0,
     86,  0,  0,  0,100,  0,  0,  0,116,  0,  0,  0,133,  0,  0,  0,
    147,  0,  0,  0,159,  0,  0,  0,171,  0,  0,  0,185,  0,  0,  0,
    202,  0,  0,  0,218,  0,  0,  0,232,  0,  0,  0,244,  0,  0,  0,
      0,  5,  0,191, 47, 47,191,191,  0,255,  0,  7,  0,191,177,180,
    182,184,191,191,  0,255,  0,  9,  0,191,177,181,181,181,182,184,
    191,191,  0,255,  0, 11,  0,191,182,183,181,180,182,180,180,184,
    191,191,  0,255,  0, 12,  0,191,191,191,185,184,182,182,181,180,
    180,185,191,  0,255,  3,  9,  0,191,191,185,182,181,182,182,187,
    191,  0,255,  5,  7,  0,191,185,178,180,183,187,191,  0,255,  5,
      7,  0,191,185,178,178,180,188,191,  0,255,  3,  9,  0,191,191,
    184,179,180,181,179,184,191,  0,255,  0, 12,  0,191,191,191,184,
    182,181,181,180,180,178,183,191,  0,255,  0, 11,  0,191,182,182,
    179,180,180,178,178,184,191,191,  0,255,  0,  9,  0,191,178,180,
    181,181,179,184,191,191,  0,255,  0,  7,  0,191,177,180,181,184,
    191,191,  0,255,  0,  5,  0,191, 47, 47,191,191,  0,255
};

unsigned char BigPic87[308]=
{
     16,  0, 12,  0,  0,  0,  0,  0, 72,  0,  0,  0, 87,  0,  0,  0,
    103,  0,  0,  0,120,  0,  0,  0,137,  0,  0,  0,154,  0,  0,  0,
    166,  0,  0,  0,178,  0,  0,  0,190,  0,  0,  0,202,  0,  0,  0,
    214,  0,  0,  0,226,  0,  0,  0,243,  0,  0,  0,  4,  1,  0,  0,
     21,  1,  0,  0, 37,  1,  0,  0,  0, 10,  0,191,191,191,191,191,
    191,191,191,191,191,  0,255,  0, 11,  0,191,182,183,183,183,184,
    183,182,182,186,191,  0,255,  0, 12,  0,191,178,181,181,181,183,
    180,179,181,181,187,191,  0,255,  0, 12,  0,191,181,183,183,183,
    183,182,179,180,179,186,191,  0,255,  0, 12,  0,191,191,191,191,
    191,191,179,178,178,178,188,191,  0,255,  4,  7,  0,191,178,180,
    179,179,184,191,  0,255,  3,  7,  0,191,178,184,183,184,188,191,
      0,255,  2,  7,  0,191,178,183,183,183,188,191,  0,255,  2,  7,
      0,191,178,184,183,182,187,191,  0,255,  3,  7,  0,191,178,183,
    184,185,187,191,  0,255,  4,  7,  0,191,180,187,187,186,186,191,
      0,255,  0, 12,  0,191,191,191,191,191,191,187,187,186,182,189,
    191,  0,255,  0, 12,  0,191,185,188,187,186,186,185,184,184,184,
    188,191,  0,255,  0, 12,  0,191,182,189,188,187,185,184,185,185,
    184,189,191,  0,255,  0, 11,  0,191,184,186,185,185,185,185,184,
    184,185,191,  0,255,  0, 10,  0,191,191,191,191,191,191,191,191,
    191,191,  0,255
};

unsigned char BigPic88[307]=
{
     15,  0, 12,  0,  0,  0,  0,  0, 68,  0,  0,  0, 83,  0,  0,  0,
    100,  0,  0,  0,119,  0,  0,  0,136,  0,  0,  0,153,  0,  0,  0,
    168,  0,  0,  0,181,  0,  0,  0,194,  0,  0,  0,209,  0,  0,  0,
    226,  0,  0,  0,243,  0,  0,  0,  6,  1,  0,  0, 23,  1,  0,  0,
     38,  1,  0,  0,  0,  3,  0,191, 47,191,  0,  9,  3,  0,191, 47,
    191,  0,255,  0,  4,  0,191,177,184,191,  0,  8,  4,  0,191,178,
    184,191,  0,255,  0,  5,  0,191,178,182,184,191,  0,  7,  5,  0,
    191,178,179,184,191,  0,255,  0, 12,  0,191,178,182,179,184,191,
    191,177,179,179,183,191,  0,255,  0, 12,  0,191,178,181,180,181,
    184,179,178,177,177,182,191,  0,255,  1, 10,  0,191,177,179,179,
    179,179,180,180,184,191,  0,255,  2,  8,  0,191,177,181,181,180,
    179,186,191,  0,255,  2,  8,  0,191,177,184,182,183,182,186,191,
      0,255,  1, 10,  0,191,182,183,187,188,188,187,187,186,191,  0,
    255,  0, 12,  0,191,178,187,187,187,188,187,187,187,184,186,191,
      0,255,  0, 12,  0,191,180,187,187,188,191,191,182,186,184,186,
    191,  0,255,  0,  5,  0,191,180,186,187,191,  0,  7,  5,  0,191,
    180,184,186,191,  0,255,  0,  4,  0,191,180,186,191,  0,  8,  4,
      0,191,178,184,191,  0,255,  0,  3,  0,191,185,191,  0,  9,  3,
      0,191,181,191,  0,255,  0,  2,  0,191,191,  0, 10,  2,  0,191,
    191,  0,255
};

unsigned char BigPic89[263]=
{
     16,  0, 12,  0,  0,  0,  0,  0, 72,  0,  0,  0, 81,  0,  0,  0,
     90,  0,  0,  0,100,  0,  0,  0,111,  0,  0,  0,123,  0,  0,  0,
    139,  0,  0,  0,154,  0,  0,  0,168,  0,  0,  0,182,  0,  0,  0,
    197,  0,  0,  0,213,  0,  0,  0,225,  0,  0,  0,236,  0,  0,  0,
    246,  0,  0,  0,255,  0,  0,  0,  0,  4,  0,191,191,191,191,  0,
    255,  0,  4,  0,191,180,187,191,  0,255,  0,  5,  0,191,180,185,
    186,191,  0,255,  0,  6,  0,191,177,181,183,186,191,  0,255,  0,
      7,  0,191,177,178,180,182,186,191,  0,255,  1, 11,  0,191,179,
    179,178,178,184,191,191,191,191,191,  0,255,  2, 10,  0,191,179,
    181,183,183,185,186,187,187,191,  0,255,  3,  9,  0,191,177,182,
    182,182,182,184,186,191,  0,255,  3,  9,  0,191,177,182,182,182,
    181,181,185,191,  0,255,  2, 10,  0,191,179,181,182,181,183,182,
    182,185,191,  0,255,  1, 11,  0,191,178,181,180,182,184,191,191,
    191,191,191,  0,255,  0,  7,  0,191,178,181,182,182,185,191,  0,
    255,  0,  6,  0,191,178,180,181,185,191,  0,255,  0,  5,  0,191,
    177,181,185,191,  0,255,  0,  4,  0,191,178,185,191,  0,255,  0,
      3,  0,191,191,191,  0,255
};

unsigned char BigPic90[366]=
{
     16,  0, 12,  0,  0,  0,  0,  0, 72,  0,  0,  0, 90,  0,  0,  0,
    109,  0,  0,  0,128,  0,  0,  0,148,  0,  0,  0,168,  0,  0,  0,
    185,  0,  0,  0,202,  0,  0,  0,219,  0,  0,  0,236,  0,  0,  0,
    253,  0,  0,  0, 17,  1,  0,  0, 37,  1,  0,  0, 56,  1,  0,  0,
     75,  1,  0,  0, 93,  1,  0,  0,  0,  4,  0,191,191, 47,191,  0,
      7,  5,  0,191,191,191, 47,191,  0,255,  0,  4,  0,191,181,185,
    191,  0,  6,  6,  0,191,183,182,182,185,191,  0,255,  0,  4,  0,
    191,177,184,191,  0,  6,  6,  0,191,177,179,178,185,191,  0,255,
      0,  4,  0,191,177,183,191,  0,  5,  7,  0,191,180,180,179,178,
    183,191,  0,255,  0,  4,  0,191,177,184,191,  0,  5,  7,  0,191,
    178,180,181,179,184,191,  0,255,  0, 12,  0,191,178,185,191,191,
    180,179,180,179,181,184,191,  0,255,  0, 12,  0,191,177,184,191,
    191,177,178,178,191,178,184,191,  0,255,  0, 12,  0,191,177,182,
    191,180,180,180,186,191,177,183,191,  0,255,  0, 12,  0,191,177,
    177,179,178,181,179,191,191,177,182,191,  0,255,  0, 12,  0,191,
    177,181,181,181,182,186,191,191,177,184,191,  0,255,  0,  7,  0,
    191,178,181,181,181,183,191,  0,  8,  4,  0,191,178,185,191,  0,
    255,  0,  7,  0,191,177,180,180,180,186,191,  0,  8,  4,  0,191,
    177,184,191,  0,255,  0,  6,  0,191,178,180,180,179,191,  0,  8,
      4,  0,191,177,183,191,  0,255,  0,  6,  0,191,178,182,180,186,
    191,  0,  8,  4,  0,191,177,185,191,  0,255,  0,  5,  0,191,183,
    184,182,191,  0,  8,  4,  0,191,181,188,191,  0,255,  0,  4,  0,
    191,191,191,191,  0,  8,  4,  0,191,191,191,191,  0,255
};

unsigned char *BigData[64]=
{
	BigPic48,BigPic48,BigPic48,BigPic48,BigPic48,BigPic48,
	BigPic48,BigPic48,BigPic48,BigPic48,BigPic48,BigPic48,
	BigPic48,BigPic48,BigPic48,BigPic48,BigPic49,BigPic50,
	BigPic51,BigPic52,BigPic53,BigPic54,BigPic55,BigPic56,
	BigPic57,BigPic48,BigPic48,BigPic48,BigPic48,BigPic48,    
	BigPic48,BigPic48,BigPic65,BigPic66,BigPic67,BigPic68,
	BigPic69,BigPic70,BigPic71,BigPic72,BigPic73,BigPic74,
	BigPic75,BigPic76,BigPic77,BigPic78,BigPic79,BigPic80,
	BigPic81,BigPic82,BigPic83,BigPic84,BigPic85,BigPic86,
	BigPic87,BigPic88,BigPic89,BigPic90,BigPic48,BigPic48,
	BigPic48,BigPic48
};

PicData BigFont[64];

int colidx[256]=
{
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,	
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	 0, 1, 2, 3, 4 ,5, 6, 7, 8, 9,10,11,12,13,14,15,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
};

int blueidx[16]=
{ 200,200,201,201,202,202,203,203,204,204,205,206,240,241,242,243 };

int greenidx[16]=
{ 112,113,114,115,116,117,118,119,120,121,122,122,123,123,124,124 };

int whiteidx[16]=
{ 80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95 };

int grayidx[16]=
{ 96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111 };

int yellowidx[16]=
{ 208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223 };


