#include "patch.h"

/************************************************************
 BRKSUBS.C
			 /-------------------------\
			||     BRK subroutines     ||
			 \-------------------------/
									
************************************************************/

// Extract a generalized lump wad to a .BMP

void OutputLump(WadDir *dir,int idx,char *dirn,char *extn)
{
	char *buffer = NULL,resn[16];
	char path[256];
	int n,o;
	FILE *st;

	n = dir->dirp[idx].reslen;
	o = dir->dirp[idx].resptr;
	strcpy(resn,Str8(dir->dirp[idx].resname));

	strcpy(path,dirn);
	strcat(path,"\\");
	strcat(path,resn);
	strcat(path,extn);
	mkdir(dirn);
	
	st = fopen(path,"wb");
	if (st!=NULL)
	{
		if (n>0)
		{
			buffer = malloc(n);
			assert(buffer);
			fseek(pst,o,SEEK_SET);
			fread(buffer,n,1,pst);

			fwrite(buffer,n,1,st);
			fclose(st);
			free(buffer);
		}
	}
}

// Extract a level from a wad to a level only .WAD

void OutputWad(WadDir *dir,int idx,char *dirn,char *extn)
{
	char *buffer = NULL,resn[16];
	char path[256];
	int n,o,i,j,offs=0;
	FILE *st;
	WadHeader wh;
	WadDir wd;

	n = dir->dirp[idx].reslen;
	o = dir->dirp[idx].resptr;
	strcpy(resn,Str8(dir->dirp[idx].resname));

	strcpy(path,dirn);
	strcat(path,"\\");
	strcat(path,resn);
	strcat(path,extn);
	mkdir(dirn);
	
	st = fopen(path,"wb");
	if (st!=NULL)
	{
		InitDir(&wd);

		strncpy(wh.wadtag,"PWAD",4);
		wh.waddiraddr=0;
		wh.waddirlen=0;
		fwrite(&wh,sizeof(WadHeader),1,st);
		offs = sizeof(WadHeader);
		AddDirEntry(&wd,offs,0,resn);
		idx++;

		while (idx<dir->nentries && IsMapResource(dir->dirp+idx))
		{
			n = dir->dirp[idx].reslen;
			o = dir->dirp[idx].resptr;
			strcpy(resn,Str8(dir->dirp[idx].resname));

			if (n>0)
			{
				buffer = malloc(n);
				assert(buffer);
				fseek(pst,o,SEEK_SET);
				fread(buffer,n,1,pst);

				fwrite(buffer,n,1,st);
				AddDirEntry(&wd,offs,n,resn);
				offs+=n;

				free(buffer);
			}
			idx++;
		}
		fwrite(wd.dirp,sizeof(WadDirEntry),wd.nentries,st);
		fseek(st,0,SEEK_SET);
		wh.waddirlen = wd.nentries;
		wh.waddiraddr = offs;
		fwrite(&wh,sizeof(WadHeader),1,st);
		fclose(st);
	}
}

// Extract a sound effect from a wad to a .WAV

void OutputWave(WadDir *dir,int idx,char *dirn,char *extn)
{
	char *buffer = NULL,resn[16];
	char path[256];
	int n,o;
	FILE *st;
	RawHeader rh;
	WaveHeader wh;
	short *sp;

	n = dir->dirp[idx].reslen;
	o = dir->dirp[idx].resptr;
	strcpy(resn,Str8(dir->dirp[idx].resname));

	strcpy(path,dirn);
	strcat(path,"\\");
	strcat(path,resn);
	strcat(path,extn);
	mkdir(dirn);
	
	st = fopen(path,"wb");
	if (st!=NULL)
	{
		if (n>0)
		{
			assert(pst);
			fseek(pst,o,SEEK_SET);
			fread(&rh,sizeof(RawHeader),1,pst);
			n -= sizeof(RawHeader);

			buffer = malloc(n);
			assert(buffer);

			fread(buffer,n,1,pst);

			strncpy(wh.riff,"RIFF",4);
			wh.flen = n+36;
			strncpy(wh.wave,"WAVEfmt ",8);
			wh.a0 = 16;
			wh.a1 = 1;
			wh.a2 = 1;
			wh.s1 = rh.srate;
			wh.s2 = rh.srate;
			wh.a3 = 1;
			wh.a4 = 8;
			strncpy(wh.data,"data",4);
			wh.nsamps = n;

			fwrite(&wh,sizeof(WaveHeader),1,st);
			fwrite(buffer,n,1,st);
			free(buffer);
			fclose(st);
		}
	}
}

// Extract a Graphic, Patch, or Sprite from a wad to a .BMP

void OutputPicture(WadDir *dir,int idx,char *dirn,char *extn)
{
	char *buffer = NULL,resn[16];
	char path[256];
	int n,o,i,wid;
	FILE *st;
	PicData pic;
	BYTE *out=NULL;

	n = dir->dirp[idx].reslen;
	o = dir->dirp[idx].resptr;
	strcpy(resn,Str8(dir->dirp[idx].resname));

	strcpy(path,dirn);
	strcat(path,"\\");
	strcat(path,resn);
	strcat(path,extn);
	mkdir(dirn);

	if (n>0)
	{
		buffer = malloc(n);
		assert(buffer);
		fseek(pst,o,SEEK_SET);
		fread(buffer,n,1,pst);
		pic.pwid = ((short *)buffer)[0];
		wid = 4*((pic.pwid+3)/4);
		pic.phgt = ((short *)buffer)[1];
		pic.pxoff = ((short *)buffer)[2];
		pic.pyoff = ((short *)buffer)[3];
		pic.coloffs = (long *)(((short *)buffer)+4);
		pic.posts = (unsigned char *)(buffer+pic.coloffs[0]);

		out = (BYTE *) malloc(pic.pwid*pic.phgt);
		assert(out);
		for (i=0;i<pic.pwid*pic.phgt;i++)
			out[i] = XPARENT;
		OverlayPicture(out,pic.pwid,pic.phgt,&pic,0,0);
		WriteBMP(out,pic.pwid,pic.phgt,path);

		free(buffer);
		free(out);
	}
}

// Extract a flat from a wad to a .BMP

void OutputFlat(WadDir *dir,int idx,char *dirn,char *extn)
{
	char *buffer = NULL,resn[16];
	char path[256];
	int n,o;
	FILE *st;
	BYTE *out=NULL;
	int i,j;

	n = dir->dirp[idx].reslen;
	o = dir->dirp[idx].resptr;
	strcpy(resn,Str8(dir->dirp[idx].resname));

	strcpy(path,dirn);
	strcat(path,"\\");
	strcat(path,resn);
	strcat(path,extn);
	mkdir(dirn);

	if (n>0)
	{
		buffer = malloc(n);
		assert(buffer);
		fseek(pst,o,SEEK_SET);
		fread(buffer,n,1,pst);

		out = (BYTE *)malloc(sizeof(short)*64*64);
		assert(out);
		for (i=0;i<64;i++)
			memmove(out+(63-i)*64,buffer+64*i,64);
		WriteBMP(out,64,64,path);

		free(buffer);
		free(out);
	}
}

// This routine implements BRK
// Extract resources to files, write a control file listing them

void WriteResourceControl(char *name)
{
	FILE *cst=NULL;
	char buffer[256],*p,*q,secname[128],resn[16],patn[16];
	char *tok,token1[16],token2[16],token3[16];
	int i,j,k,m,ispatch=0,t,np=0,npats=0;
	TextureDesc *td;
	PicData pic;
	int cur=0;

	cst = fopen(name,"w");
	if (cst!=NULL)
	{
		for (i=0;i<pdir.nentries;i++)
		{
			strcpy(resn,Str8(pdir.dirp[i].resname));
			switch(ResourceType(pdir.dirp+i))
			{
				case RES_LUMPS:
					if (DoLumps)
					{
						AddDTex(&clump,&nclump,0,resn,0,0);
						OutputLump(&pdir,i,"LUMPS",".LMP");
						printf("Extracted %-1d LUMPS: %8s        \r",nclump,resn);
					}
					break;
				case RES_LEVELS:
					if (DoWads)
					{
						if (IsMapName(pdir.dirp+i))
						{
							AddDTex(&clevel,&ncleve,0,resn,0,0);
							OutputWad(&pdir,i,"LEVELS",".WAD");
						}
						printf("Extracted %-2d LEVELS: %8s        \r",ncleve,resn);
					}
					break;
				case RES_TEXTURES:
				case RES_PNAMES:
					if (DoTextures)
					{
						if (nctext==0)
						{
							for (j=0;j<pwt.t1.N;j++)
							{
								td = pwt.t1.textures+j;
								AddDTex(&ctexture,&nctext,0,
									Str8(td->textname),
									td->twid,td->thgt);
								for (k=0;k<td->npatches;k++)
								{
									strcpy(patn,GetPName(&pwt.pnames,td->patches[k].pidx));
									AddDTex(&ctexture,&nctext,1,patn,
										td->patches[k].xoff,td->patches[k].yoff);
									if (AdditionalPatches)
									{
										m = IsIn(patn,&pdir);
										if (m>=0)
										{
											if (IsInDTex(patn,cpatch,ncpatc)<0)
											{
												fseek(pst,pdir.dirp[m].resptr,SEEK_SET);
												fread(&pic,sizeof(short),4,pst);
												AddDTex(&cpatch,&ncpatc,0,patn,pic.pxoff,pic.pyoff);
												OutputPicture(&pdir,m,"PATCHES",".BMP");
												printf("Extracted %-3d PATCHES: %8s        \r",ncpatc,patn);
											}
										}
									}
								}
							}
							printf("Extracted PNAMES                         \r");
							printf("Extracted TEXTURE1                       \r");
						}
					}
					break;
				case RES_SOUNDS:
					if (DoEffects)
					{
						AddDTex(&csound,&ncsoun,0,resn,0,0);
						if (resn[1]=='P')
							OutputLump(&pdir,i,"SOUNDS",".TXT");
						else
							OutputWave(&pdir,i,"SOUNDS",".WAV");
						printf("Extracted %-3d SOUNDS: %8s        \r",ncsoun,resn);
					}
					break;
				case RES_MUSICS:
					if (DoMusics)
					{
						AddDTex(&cmusic,&ncmusi,0,resn,0,0);
						OutputLump(&pdir,i,"MUSICS",".MUS");
						printf("Extracted %-2d MUSICS: %8s        \r",ncmusi,resn);
					}
					break;
				case RES_GRAPHICS:
					if (DoGraphics)
					{
						fseek(pst,pdir.dirp[i].resptr,SEEK_SET);
						fread(&pic,sizeof(short),4,pst);
						AddDTex(&cgraphic,&ncgrap,0,resn,pic.pxoff,pic.pyoff);
						OutputPicture(&pdir,i,"GRAPHICS",".BMP");
						printf("Extracted %-3d GRAPHICS: %8s        \r",ncgrap,resn);
					}
					break;
				case RES_PICTURES:
					fseek(pst,pdir.dirp[i].resptr,SEEK_SET);
					fread(&pic,sizeof(short),4,pst);
					if
					(
					    DoSprites && (psprRng[0].start<=i && i<=psprRng[0].end)
				    )
					{
						if (pdir.dirp[i].reslen)
						{
							AddDTex(&csprite,&ncspri,0,resn,pic.pxoff,pic.pyoff);
							OutputPicture(&pdir,i,"SPRITES",".BMP");
							printf("Extracted %-3d SPRITES: %8s        \r",ncspri,resn);
						}
					}
					else if
					(
						DoFlats && (pflaRng[0].start<=i && i<=pflaRng[0].end)
					)
					{
						if (pdir.dirp[i].reslen)
						{
							AddDTex(&cflat,&ncflat,0,resn,0,0);
							OutputFlat(&pdir,i,"FLATS",".BMP");
							printf("Extracted %-3d FLATS: %8s        \r",ncflat,resn);
						}
					}
					else if
					(
						DoPatches && (ppatRng[0].start<=i && i<=ppatRng[0].end)
					)
					{
						if (pdir.dirp[i].reslen && IsInDTex(resn,cpatch,ncpatc)<0)
						{
							AddDTex(&cpatch,&ncpatc,0,resn,pic.pxoff,pic.pyoff);
							OutputPicture(&pdir,i,"PATCHES",".BMP");
							printf("Extracted %-3d PATCHES: %8s        \r",ncpatc,resn);
						}
					}
					break;
				default:
					break;
			}

		}
		//erase transient display line
		printf("                                                          \n");

		// write the control file and report totals
		fprintf(cst,";--------------------------------------------------------\n");
		fprintf(cst,";%s breakdown by resources, written by BRK.EXE\n",pwadname);
		fprintf(cst,";--------------------------------------------------------\n");
		fprintf(cst,";\n");
		fprintf(cst,";Main control resources: LUMPS\\*.LMP\n");
		fprintf(cst,";\n");
		fprintf(cst,"[LUMPS]\n");
		for (i=0;i<nclump;i++)
			fprintf(cst,"%s\n",clump[i].name);
		printf("Extracted %d LUMPS\n",nclump);
		fprintf(cst,";\n");
		fprintf(cst,";Levels: LEVELS\\MAP??.WAD\n");
		fprintf(cst,";\n");
		fprintf(cst,"[LEVELS]\n");
		for (i=0;i<ncleve;i++)
			fprintf(cst,"%s\n",clevel[i].name);
		printf("Extracted %d LEVELS\n",ncleve);
		fprintf(cst,";\n");
		fprintf(cst,";Sounds: SOUNDS\\*.TXT,*.WAV\n");
		fprintf(cst,";\n");
		fprintf(cst,"[SOUNDS]\n");
		for (i=0;i<ncsoun;i++)
			fprintf(cst,"%s\n",csound[i].name);
		printf("Extracted %d SOUNDS\n",ncsoun);
		fprintf(cst,";\n");
		fprintf(cst,";Music: MUSICS\\*.MUS\n");
		fprintf(cst,";\n");
		fprintf(cst,"[MUSICS]\n");
		for (i=0;i<ncmusi;i++)
			fprintf(cst,"%s\n",cmusic[i].name);
		printf("Extracted %d MUSICS\n",ncmusi);
		fprintf(cst,";\n");
		fprintf(cst,";Status bar, fonts, intermission graphics : GRAPHICS\\*.BMP\n");
		fprintf(cst,";\n");
		fprintf(cst,"[GRAPHICS]\n");
		for (i=0;i<ncgrap;i++)
			fprintf(cst,"%s  %d  %d\n",cgraphic[i].name,cgraphic[i].num1,cgraphic[i].num2);
		printf("Extracted %d GRAPHICS\n",ncgrap);
		fprintf(cst,";\n");
		fprintf(cst,";Thing Sprites: SPRITES\\*.BMP\n");
		fprintf(cst,";\n");
		fprintf(cst,"[SPRITES]\n");
		for (i=0;i<ncspri;i++)
			fprintf(cst,"%s  %d   %d\n",csprite[i].name,csprite[i].num1,csprite[i].num2);
		printf("Extracted %d SPRITES\n",ncspri);
		fprintf(cst,";\n");
		fprintf(cst,";Floor and ceiling bitmaps: FLATS\\*.BMP\n");
		fprintf(cst,";\n");
		fprintf(cst,"[FLATS]\n");
		for (i=0;i<ncflat;i++)
			fprintf(cst,"%s\n",cflat[i].name);
		printf("Extracted %d FLATS\n",ncflat);
		fprintf(cst,";\n");
		fprintf(cst,";Textures and Patches: PATCHES\\*.BMP\n");
		fprintf(cst,";\n");
		fprintf(cst,"[TEXTURES]\n");
		for (i=0,np=0;i<nctext;i++)
			if (ctexture[i].isp)
			{
				fprintf(cst,"\*  %s  %d  %d\n",ctexture[i].name,ctexture[i].num1,ctexture[i].num2);
				np++;
			}
			else
				fprintf(cst,"%s  %d  %d\n",ctexture[i].name,ctexture[i].num1,ctexture[i].num2);
		fprintf(cst,";End\n");
		printf("Extracted %d TEXTURES, %d PATCHES\n",nctext-np,ncpatc);
		fclose(cst);
		printf("Resources extracted listed in %s\n",name);
	}
	FreeDTex();
}


