--- orig/soldier.qc	Thu Sep 26 11:15:40 1996
+++ soldier.qc	Fri Nov 29 20:46:42 1996
@@ -149,6 +149,31 @@
 	if (self.pain_finished > time)
 		return;
 
+	ThrowGib ("progs/gib1.mdl", self.health);
+	ThrowGib ("progs/gib2.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+	ThrowGib ("progs/gib1.mdl", self.health);
+	ThrowGib ("progs/gib2.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+
+	//
+	// throw off head, but undo death variables
+	//
+
+	ThrowHead ("progs/h_guard.mdl", self.health);
+	self.takedamage = DAMAGE_YES;
+	self.solid = SOLID_SLIDEBOX;
+
+	r = random();
+
+	if (r < 0.5)
+		self.movetype = MOVETYPE_FLY;
+	else
+	{
+		self.movetype = MOVETYPE_STEP;
+		self.origin_z = self.origin_z + 10; // raise off floor
+	}
+
 	r = random();
 
 	if (r < 0.2)
@@ -195,7 +220,7 @@
 void()	army_die1	=[	$death1,	army_die2	] {};
 void()	army_die2	=[	$death2,	army_die3	] {};
 void()	army_die3	=[	$death3,	army_die4	]
-{self.solid = SOLID_NOT;self.ammo_shells = 5;DropBackpack();};
+{self.ammo_shells = 5;DropBackpack();};
 void()	army_die4	=[	$death4,	army_die5	] {};
 void()	army_die5	=[	$death5,	army_die6	] {};
 void()	army_die6	=[	$death6,	army_die7	] {};
@@ -207,7 +232,7 @@
 void()	army_cdie1	=[	$deathc1,	army_cdie2	] {};
 void()	army_cdie2	=[	$deathc2,	army_cdie3	] {ai_back(5);};
 void()	army_cdie3	=[	$deathc3,	army_cdie4	]
-{self.solid = SOLID_NOT;self.ammo_shells = 5;DropBackpack();ai_back(4);};
+{self.ammo_shells = 5;DropBackpack();ai_back(4);};
 void()	army_cdie4	=[	$deathc4,	army_cdie5	] {ai_back(13);};
 void()	army_cdie5	=[	$deathc5,	army_cdie6	] {ai_back(3);};
 void()	army_cdie6	=[	$deathc6,	army_cdie7	] {ai_back(4);};
@@ -220,23 +245,33 @@
 
 void() army_die =
 {
-// check for gib
-	if (self.health < -35)
-	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_guard.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		return;
-	}
-
-// regular death
 	sound (self, CHAN_VOICE, "soldier/death1.wav", 1, ATTN_NORM);
-	if (random() < 0.5)
-		army_die1 ();
-	else
-		army_cdie1 ();
+	sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+
+	ThrowGib("progs/gib1.mdl",self.health);
+	ThrowGib ("progs/gib2.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+	ThrowGib ("progs/gib1.mdl", self.health);
+	ThrowGib ("progs/gib2.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+	ThrowGib ("progs/gib1.mdl", self.health);
+	ThrowGib ("progs/gib2.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+
+	// ThrowHead ("progs/h_guard.mdl", self.health);
+	// equivalent follows
+	self.frame = 0;
+	self.nextthink = -1;
+	self.movetype = MOVETYPE_BOUNCE;
+	self.takedamage = DAMAGE_NO;
+	self.solid = SOLID_NOT;
+	self.view_ofs = '0 0 8';
+	setsize (self, '-16 -16 0', '16 16 56');
+	self.velocity = VelocityForDamage (self.health);
+	self.origin_z = self.origin_z - 24;
+	self.flags = self.flags - (self.flags & FL_ONGROUND);
+	self.avelocity = crandom() * '0 600 0';
+	return;
 };
 
 
