/*
  Crystal Space QuakeMDL convertor : pcx writer
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Nathaniel Saint Martin aka NooTe <noote@bigfoot.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "csendian.h"

bool WritePCX (char *name, unsigned char *data, unsigned char *pal, int width, int height)
{
  typedef struct
  {
    char	manufacturer;
    char	version;
    char	encoding;
    char	bits_per_pixel;
    short	xmin;
    short	ymin;
    short	xmax;
    short	ymax;
    short	hres;
    short	vres;
    unsigned char	palette[48];
    char	reserved;
    char	color_planes;
    short	bytes_per_line;
    short	palette_type;
    char	filler[58];
    unsigned char	data;
  } pcx_header;

  int i, j, len;
	pcx_header *pcx;
	unsigned char *pack;
	FILE *fp;

	pcx = (pcx_header*)malloc (width*height*2+1000);
	pcx->manufacturer = 10;         // Some programs complains if this is 0
	pcx->version = 5;
	pcx->encoding = 1;
	pcx->bits_per_pixel = 8;
	pcx->xmin = convert_endian ((short)0);
	pcx->ymin = convert_endian ((short)0);
	pcx->xmax = convert_endian ((short)(width - 1));
	pcx->ymax = convert_endian ((short)(height - 1));
	pcx->hres = convert_endian ((short)width);
	pcx->vres = convert_endian ((short)height);
	memset (pcx->palette, 0, sizeof(pcx->palette));
	pcx->color_planes = 1;
	pcx->bytes_per_line = convert_endian ((short)width);
	pcx->palette_type = convert_endian ((short)2);
	memset (pcx->filler, 0, sizeof(pcx->filler));
	pack = &(pcx->data);

	for (i=0; i<height; i++)
	{
		for (j=0; j<width; j++)
		{
			if  ((*data & 0xc0) != 0xc0)
				*pack++ = *data++;
			else
			{
				*pack++ = 0xc1;
				*pack++ = *data++;
			}
		}
//		data += width;
	}
	*pack++ = 0x0c;
	for (i=0; i<768; i++)
		*pack++ = *pal++;
	len = pack - (unsigned char *)pcx;
	fp = fopen (name, "wb");
	if (!fp) return false;
	fwrite (pcx, len, 1, fp);
	fclose (fp);
	free (pcx);
  return true;
}
