// mdl Quake to sprite3d CrystalSpace

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mdl.h"

bool WriteSPR(char *spritename, Mdl mdl, float scaleMdl, int delayMdl,
  float positionMdlX, float positionMdlY, float positionMdlZ,
  bool actionNamingMdl, bool resizeSkin, bool altFormat);

int main(int ac, char ** av)
{
  bool
    actionNamingMdl = true,
    resizeSkin      = true,
    altFormat       = false,
    help            = false;
  char
    * mdlName = NULL,
    * sprName = NULL;
  int
    delayMdl = 100,
    tempInt  = 0;
  float
    positionMdlX = 0.0,
    positionMdlY = 0.0,
    positionMdlZ = 0.0,
    scaleMdl     = 0.025,
    tempFloat    = 0.0;

  fprintf(stdout, "mdl2spr version 0.32\n");
  fprintf(stdout, "A quake model convertor for CrystalSpace.\n");
  fprintf(stdout, "by NooTe (noote@bigfoot.com)\n\n");

  for(int i=1; i<ac && help==false; i++)
  {
    // if an arg is not a switch, it may be the mdl or sprite name
    if(av[i][0]!='-' && av[i][0]!='/')
    {
      if (mdlName == NULL)
      {
        mdlName = av[i];
        for (int j=0, k=strlen(mdlName)-3; j<k; j++)
        {
          if (strncmp (mdlName + j, ".mdl", 4) == 0) mdlName[j] = '\0';
          if (strncmp (mdlName + j, ".MDL", 4) == 0) mdlName[j] = '\0';
        }
        fprintf (stdout, "model to be converted: %s.mdl\n", mdlName);
      }
      else if (sprName == NULL) sprName = av[i];
      else
      {
        fprintf(stderr, "'%s' unreconized option !\n", av[i]);
        help = true;
      }
    }
    else switch(av[i][1])
    {
      case 'a':
        altFormat = (altFormat)?false:true;
        fprintf(stdout, "%s alternate sprite format.\n",
          (altFormat)?"enable":"disable");
        break;

      case 'd':
        if((tempInt=atoi(av[i+1])) == 0)
        {
          fprintf(stderr, "cannot convert %s to a valid int !\n", av[i+1]);
          help = true; break;
        }
        delayMdl = tempInt;
        fprintf(stdout, "set frame delay to: %i\n", delayMdl);
        i++; break;

      case 'h':
      case '?':
        help = true;
        break;

      case 'n':
        actionNamingMdl = (actionNamingMdl)?false:true;
        fprintf(stdout, "%s auto naming of action frameset.\n",
          (actionNamingMdl)?"enable":"disable");
        break;

      case 'r':
        resizeSkin = (resizeSkin)?false:true;
        fprintf(stdout, "%s power-of-2 skin resizing.\n",
          (resizeSkin)?"enable":"disable");
        break;

      case 's':
        if((tempFloat=atof(av[i+1])) == 0.0)
        {
          fprintf(stderr, "cannot convert %s to a valid float !\n", av[i+1]);
          help = true; break;
        }
        scaleMdl = tempFloat;
        fprintf(stdout, "set general scale to: %.3f\n", scaleMdl);
        i++; break;

      case 'x':
        if((tempFloat=atof(av[i+1])) == 0.0)
        {
          fprintf(stderr, "cannot convert %s to a valid float !\n", av[i+1]);
          help = true; break;
        }
        positionMdlX = tempFloat;
        fprintf(stdout, "set X axis translation to: %.3f\n", positionMdlX);
        i++; break;

      case 'y':
        if((tempFloat=atof(av[i+1])) == 0.0)
        {
          fprintf(stderr, "cannot convert %s to a valid float !\n", av[i+1]);
          help = true; break;
        }
        positionMdlY = tempFloat;
        fprintf(stdout, "set Y axis translation to: %.3f\n", positionMdlY);
        i++; break;

      case 'z':
        if((tempFloat=atof(av[i+1])) == 0.0)
        {
          fprintf(stderr, "cannot convert %s to a valid float !\n", av[i+1]);
          help = true; break;
        }
        positionMdlZ = tempFloat;
        fprintf(stdout, "set Z axis translation to: %.3f\n", positionMdlZ);
        i++; break;

      default:
        fprintf(stderr, "'%s' unreconized option !\n", av[i]);
        help = true; break;
    }
  }

  if (mdlName == NULL)
  {
    fprintf (stderr, "no model filename to convert !\n");
    help = true;
  }
  else
  {
    if (sprName == NULL) sprName = mdlName;
    else for (int j=0, k=strlen(sprName)-3; j<k; j++)
    {
      if (strncmp (sprName + j, ".spr", 4) == 0) sprName[j] = '\0';
      if (strncmp (sprName + j, ".SPR", 4) == 0) sprName[j] = '\0';
    }
    fprintf (stdout, "3D sprite to be created: %s.spr\n", sprName);
  }

  if(help)
  {
    fprintf(stdout, "Usage: mdl2spr <option> [mdl file] <sprite name>\n");
    fprintf(stdout, "Options:\n");
    fprintf(stdout, "  -a         %s alternate sprite format (%s by default)\n", (!altFormat)?"enable":"disable", (altFormat)?"enable":"disable");
    fprintf(stdout, "  -d [int]   frame delay for frames which don't have delay (default %d)\n", delayMdl);
    fprintf(stdout, "  -h         help (this page)\n");
    fprintf(stdout, "  -n         %s auto naming of action frameset (%s by default)\n", (!actionNamingMdl)?"enable":"disable", (actionNamingMdl)?"enable":"disable");
    fprintf(stdout, "  -r         %s automatic power-of-2 skin resizing (%s by default)\n", (!resizeSkin)?"enable":"disable", (resizeSkin)?"enable":"disable");
    fprintf(stdout, "  -s [float] global scale of mdl (default %.3f)\n", scaleMdl);
    fprintf(stdout, "  -x [float] sprite moving on X axis (default %.3f)\n", positionMdlX);
    fprintf(stdout, "  -y [float] sprite moving on Y axis (default %.3f)\n", positionMdlY);
    fprintf(stdout, "  -z [float] sprite moving on Z axis (default %.3f)\n", positionMdlZ);
    return -1;
  }

  Mdl mdl(mdlName);
  
  if(mdl.getError())
  {
    fprintf(stderr, "\nerror : %s !\n", mdl.getErrorString());
    exit(-1);
  }
  
  fprintf(stdout, "\nQuake Model %s has :\n", av[ac-1]);
  fprintf(stdout, "\t %d Skin%s\n", mdl.nbskins, (mdl.nbskins>1)?"s":"");
  fprintf(stdout, "\t %d Frame%s\n", mdl.nbframesets, (mdl.nbframesets>1)?"s":"");
  fprintf(stdout, "\t %d Triangle%s\n", mdl.nbtriangles, (mdl.nbtriangles>1)?"s":"");
  fprintf(stdout, "\t %d Vertice%s\n\n", mdl.nbvertices, (mdl.nbvertices>1)?"s":"");
  
  WriteSPR(sprName, mdl, scaleMdl, delayMdl,
    positionMdlX, positionMdlY, positionMdlZ,
    actionNamingMdl, resizeSkin, altFormat);
  return 1;
}