	.text
	.file "atoll.c"
	.type	_atoll,function
_atoll:
; Register assignments:
; eax: digit to be converted
; edx: old value of esi
; ecx: zero if positive, 1 if negative
; esi: points to string
; st(0) accumulator for the result
; st(1) 10
; Save esi in edx
	movl	%esi,%edx
; Read argument
	movl	4(%esp),%esi
; clear eax register for making sure only al is set later
	xor	%eax,%eax
	push	%eax
; load 10 into st(1) and zero into st(0)
	fildl	_$13
	fldz
	or	%esi,%esi
; test for NULL pointer
	je	_$atollExit
; number defaults to positive
	movl	%eax,%ecx
_$IgnoreSpaceLoop:
	lodsb
	cmpb	$32,%al
	je	_$IgnoreSpaceLoop
	cmpb	$9,%al
	je	_$IgnoreSpaceLoop
; Ignore '+' sign if present
	cmpb	$43,%al
	je	_$atolltest
; test if first digit is negative sign
	cmpb	$45,%al
	jne	_$atollTestentry
; ecx contains 1 if first digit negative sign
	inc	%ecx
; skip negative sign
	jmp	_$atolltest
_$atollLoop:
; 1) convert al from ascii to binary
	subb	$48,%al
; 2) Multiply old value by 10
	fmul	%st(1),%st
; 3) Add new digit
	movl	%eax,(%esp)
	fiaddl	(%esp)
_$atolltest:
	lodsb
_$atollTestentry:
	cmpb	$48,%al
	jl	_$atollTestIfNegative
	cmpb	$57,%al
	jle	_$atollLoop
_$atollTestIfNegative:
	or	%ecx,%ecx
	je	_$atollExit
	fchs
_$atollExit:
	push	%eax
	fistpq	(%esp)
	pop	%eax
	movl	%edx,%esi
	pop	%edx
	ffree	%st(0)
	fincstp
	ret
_$20:
	.size	_atoll,_$20-_atoll
	.globl	_atoll
	.data
	.align	2
_$13:
	.long	0xa
