/*
	e_gbstat.c

	Implimentation of GibStat logging specification for Expert Server

								----------
								Due Credit
								----------

		GibStat page at: http://www.planetquake.com/gibstat
		Great idea for a modification! I plan to follow this standard 
		where ever it's applicable to a Q2 project I work on.

						------------------------------
						Musical Selections of the Hour
						------------------------------

		Tool..........................................  AEnima
		The Mighty Mighty Bostones....................	Let's Face it
		Prodigy.......................................	Fat of the Land
		The Chemical Brothers.........................	Dig Your Own Hole
		Nine Inch Nails...............................	Pretty Hate Machine
														The Downward Spiral
*/

#include <stdlib.h>
#include <stdio.h>
#include "g_local.h"
#include "e_gbstat.h"

// Only these functions need to have access to the file pointer.
static FILE		*gsFile;

//
// Start/Stop logging functions
//
qboolean gsStartLogging(char *szFilename)
{
	char *filename;

	// File is open
	if (gsFile != NULL)
		return (true);

	// Create the filename.
	filename = malloc(strlen(gamedir->string) + strlen(szFilename) + 2);
	strcpy(filename, gamedir->string);
	strcat(filename, "/");
	strcat(filename, szFilename);

	// We want to open in append mode so as not to delete any previous logs.
	gsFile = fopen(filename, "a+");
	if ( gsFile == NULL)
	{
		gi.dprintf("***************************\n");
		gi.dprintf("ERROR: Couldn't open %s (GibStat).\n", filename);
		gi.dprintf("***************************\n");
		return (false);
	}

	// That's about it for now. If GibStat adds something like a "LogStart" put it here.

	return (true);
}

qboolean gsStopLogging()
{

	if (gsFile == NULL)
		return (true);

	if (fclose(gsFile))
		return (false);
	return (true);
}

//
// Game Start/Game End logs
//
void gsGameStart()
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	// Since fprintf returns a negative value when an error occurs, I'm not going
	// to bother checking it. If we want checking later, let me know... I'll add it.
	fprintf(gsFile, GS_GAME_START);
}

void gsGameEnd()
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	fprintf(gsFile, GS_GAME_END);
}

//
// Map and Client Connect/Disconnect logging.
//

void gsLogMap()
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	fprintf(gsFile, GS_MAP_INFO, level.mapname);
}

void gsLogClientConnect(edict_t *ent)
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	if (ent->team != NULL)
	{	// Teamplay writing.
		fprintf(gsFile, GS_PLAYER_INFO_TEAM, ent->client->pers.netname, ent->team);
	} else {
		fprintf(gsFile, GS_PLAYER_INFO_TEAM, ent->client->pers.netname);
	}
}

void gsLogClientDisconnect(edict_t *ent)
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	fprintf(gsFile, GS_PLAYER_CONNECT, ent->client->pers.netname);
}

//
// Frag Logging
//

void gsLogFrag(edict_t *vict, edict_t *attk)
{
	// This implimentation is specific to the Expert server as it uses the
	// vict->client->killedBy add on.

	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	// TODO:	As mods are created, extra parsing info must be done here.
	//			i.e. Flag Capture, Flag Defense, etc...

	fprintf(gsFile,	GS_FRAG_LOG,
			vict->client->pers.netname,
			attk->client->pers.netname,
			vict->client->killedBy,
			GS_TYPE_KILL,
			1,
			level.time,
			attk->client->ping);
	return;
}

void gsLogKillSelf(edict_t *vict, char *szCause)
{
	// This implimentation is specific to the Expert server as it uses the
	// vict->client->killedBy add on.

	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	// TODO:	As mods are created, extra parsing info must be done here.
	//			i.e. Flag Capture, Flag Defense, etc...

	fprintf(gsFile, GS_FRAG_LOG,
			vict->client->pers.netname,
			vict->client->pers.netname,
			szCause,
			GS_TYPE_SUICIDE,
			-1,
			level.time,
			vict->client->ping);
	return;
}

//
// Roll your own special stuff!
// USE WITH CAUTION! Improper formatting could totally screw up the log.
//

void gsLogMisc(char *logEvent)
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	fprintf(gsFile, logEvent);
}
