diff -crbB --unidirectional-new-file qw201/client.qc expert12/client.qc
*** qw201/client.qc	Tue Aug 12 15:30:00 1997
--- expert12/client.qc	Sat Aug 16 22:05:36 1997
***************
*** 6,11 ****
--- 5,12 ----
  void() player_stand1;
  void (vector org) spawn_tfog;
  void (vector org, entity death_owner) spawn_tdeath;
+ // 100% spawnfrag prevention
+ void (vector org, entity spawner) spawn_trespawn;
  
  float   modelindex_eyes, modelindex_player;
  
***************
*** 21,26 ****
--- 22,29 ----
  
  float   intermission_running;
  float   intermission_exittime;
+ // Expert
+ float   gotoCalled = 0; // flag indicates "GotoNextMap" has been called already
  
  /*QUAKED info_intermission (1 0.5 0.5) (-16 -16 -16) (16 16 16)
  This is the camera point for the intermission.
***************
*** 35,43 ****
  
  void() SetChangeParms =
  {
! 	if (self.health <= 0)
  	{
  		SetNewParms ();
  		return;
  	}
   
--- 38,52 ----
  
  void() SetChangeParms =
  {
! 	// Expert CTF
! 	// No carryover of gear between levels
! 	if ((self.health <= 0) || (ctf))
  	{
  		SetNewParms ();
+ 		// *TEAMPLAY*
+ 		// Store the team of the team of the player even
+ 		// if he's dead at level switch
+ 		parm10 = self.assignedTeam;	// Save the current team of the player
  		return;
  	}
   
***************
*** 62,69 ****
--- 71,89 ----
  	parm7 = self.ammo_cells;
  	parm8 = self.weapon;
  	parm9 = self.armortype * 100;
+ 	// *TEAMPLAY*
+ 	parm10 = self.assignedTeam;	// Save the current team of the player
+ 
+ 	// Expert DM
+ 	// Throwing axe
+ 	if (deathmatch & DM_WEAPON_MODES)
+ 		parm11 = self.ammo_axes;
+ 
  };
  
+ // Expert
+ void() FirstConnect;
+ 
  void() SetNewParms =
  {
  	parm1 = IT_SHOTGUN | IT_AXE;
***************
*** 75,84 ****
--- 95,114 ----
  	parm7 = 0;
  	parm8 = 1;
  	parm9 = 0;
+ 
+ 	// *TEAMPLAY*
+ // Set parm10 (team).  SetNewParms is called before DecodeLevelParms on all
+ // spawns _except_ spawns after level changes, so DecodeLevelParms needs to
+ // be able to know that SetNewParms has been called by checking parm10.
+ 	parm10 = -1;
+ 
  };
  
+ 
  void() DecodeLevelParms =
  {
+ 	local string temp;
+ 
  	if (serverflags)
  	{
  		if (world.model == "maps/start.bsp")
***************
*** 92,99 ****
--- 122,150 ----
  	self.ammo_nails = parm5;
  	self.ammo_rockets = parm6;
  	self.ammo_cells = parm7;
+ 	// Expert DM
+ 	// Throwing axe
+ 	if (deathmatch & DM_WEAPON_MODES)
+ 		self.ammo_axes = parm11;
  	self.weapon = parm8;
  	self.armortype = parm9 * 0.01;
+ 
+ // *TEAMPLAY*
+ // If parm10 is anything other than -1, SetNewParms has not been called,
+ // this player is reconnecting after a level change, and parm10 should be
+ // the team to assign to.  We might as well check that parm10 is a legal
+ // team, rather than just != -1
+ 	if(TeamIsLegal(parm10))
+ 		self.assignedTeam = parm10;
+ 
+ // Expert
+ // FL_JUSTCONNECTED indicates we've just connected or reconnected, and if parm10
+ // is equal to -1, then SetNewParms has been called, so this is an initial connect.
+ 	if ((self.flags & FL_JUSTCONNECTED) && (parm10 == -1))
+ 		self.flags = self.flags | FL_FIRSTCONNECT;
+ 
+ 	self.flags = self.flags - (self.flags & FL_JUSTCONNECTED);
+ 
  };
  
  /*
***************
*** 138,146 ****
--- 189,207 ----
  
  //ZOID: 12-13-96, samelevel is overloaded, only 1 works for same level
  
+ 	if (!gotoCalled)
+ 	{
  		if (cvar("samelevel") == 1)     // if samelevel is set, stay on same level
  			changelevel (mapname);
  		else {
+ 			// Expert DM
+ 			// Expert CTF
+ 			// Custom level cycling
+ 			if (ctf && (deathmatch & DM_LEVEL_SET))
+ 				CTFNextLevel();
+ 			else if (deathmatch & DM_LEVEL_SET)
+ 				DMNextLevel();
+ 			else {
  				// configurable map lists, see if the current map exists as a
  				// serverinfo/localinfo var
  				newmap = infokey(world, mapname);
***************
*** 149,154 ****
--- 210,218 ----
  				else
  					changelevel (nextmap);
  			}
+ 		}
+ 		gotoCalled = 1; // Checked to prevent calling mapcycle alias more than once.
+ 	}
  };
  
  
***************
*** 183,188 ****
--- 247,259 ----
  {
  	local entity    pos;
  
+ // *TEAMPLAY*
+ // Print the team score at the end of the level
+ 	if (ctf)
+ 		PrintCTFScore();
+ 	else if (teamplay & TEAM_SCORING)
+ 		TeamPrintTeamScore();
+ 
  	intermission_running = 1;
  	
  // enforce a wait time before allowing changelevel
***************
*** 218,227 ****
--- 288,310 ----
  void() changelevel_touch =
  {
  	local entity    pos;
+ 	local string 	s;
  
  	if (other.classname != "player")
  		return;
  
+ 	// Expert CTF
+ 	if (ctf) {
+ 		if (deathmatch & DM_GRAPPLE) {
+ 			// CTF with hook: exit inactive
+ 			return;
+ 		} else {
+ 			// CTF without hook: exit must be deadly
+ 			T_Damage (other, self, self, 50000);
+ 			return;
+ 		}
+ 	}
+ 
  // if "noexit" is set, blow up the player trying to leave
  //ZOID, 12-13-96, noexit isn't supported in QW.  Overload samelevel
  //      if ((cvar("noexit") == 1) || ((cvar("noexit") == 2) && (mapname != "start")))
***************
*** 231,236 ****
--- 314,335 ----
  		return;
  	}
  
+ // Expert DM
+ // if DM_FRAG_MIN is set, frag players who 
+ // try to leave with too few frags
+ 	if (teamplay & DM_FRAG_MIN) {
+ 		if (other.frags < DM_EXIT_FRAG_MIN) {
+ 			T_Damage(other, self, self, 50000);
+ 			s = ftos(DM_EXIT_FRAG_MIN);
+ 			bprint(PRINT_MEDIUM, other.netname);
+ 			bprint(PRINT_MEDIUM, " tried to exit with too few frags, ");
+ 			bprint(PRINT_MEDIUM, s);
+ 			bprint(PRINT_MEDIUM, " required.\n");
+ 			return;
+ 		}
+ 	}
+ 
+ 
  	bprint (PRINT_HIGH, other.netname);
  	bprint (PRINT_HIGH," exited the level\n");
  
***************
*** 290,302 ****
--- 389,410 ----
  */
  void() ClientKill =
  {
+ 	// Expert DM
+ 	// Bugfix - no endless chain suicides
+ 	if (self.frags > -2) {
  		bprint (PRINT_MEDIUM, self.netname);
  		bprint (PRINT_MEDIUM, " suicides\n");
+ 		// Expert CTF
+ 		if (ctf)
+ 			TeamCaptureDropFlagOfPlayer(self);
  		set_suicide_frame ();
  		self.modelindex = modelindex_player;
  		logfrag (self, self);
  		self.frags = self.frags - 2;    // extra penalty
  		respawn ();
+ 	} else {
+ 		sprint(self, PRINT_HIGH, "Can't suicide with negative frags\n");
+ 	}
  };
  
  float(vector v) CheckSpawnPoint =
***************
*** 327,332 ****
--- 435,449 ----
  	if (spot)
  		return spot;
  
+ 	// Expert CTF
+ 	// During the first 20 seconds after joining or
+ 	// cycling levels, players are spawned at base
+ 	if (ctf && (time - self.connecttime) < 20) {
+ 		spot = TeamCaptureSpawn();
+ 		if (spot != world)
+ 			return spot;
+ 	}
+ 		
  // choose a info_player_deathmatch point
  
  // ok, find all spots that don't have players nearby
***************
*** 462,468 ****
  	self.movetype = MOVETYPE_WALK;
  	self.show_hostile = 0;
  	self.max_health = 100;
! 	self.flags = FL_CLIENT;
  	self.air_finished = time + 12;
  	self.dmg = 2;                   // initial water damage
  	self.super_damage_finished = 0;
--- 580,603 ----
  	self.movetype = MOVETYPE_WALK;
  	self.show_hostile = 0;
  	self.max_health = 100;
! 	self.flags = FL_CLIENT | (self.flags & FL_JUSTCONNECTED);
! 
! // Show the spawn message every spawn
! 	CreateSpawnObj();
! 
! // *TEAMPLAY*
! // Reset some teamplay variables
! 	self.lastteamset = -50;
! 	self.lastteamcheck = -50;
! 
! 	// XXX EXPERT CTF
! 	// Players who have recently shot the flag carrier
! 	// aren't still worth extra points after they die
! 	self.last_hurt_carrier = -10;
! 	// reset escort markers
! 	self.escortSince = 0;
! 	self.lastEscort = 0;
! 
  	self.air_finished = time + 12;
  	self.dmg = 2;                   // initial water damage
  	self.super_damage_finished = 0;
***************
*** 511,517 ****
  	makevectors(self.angles);
  	spawn_tfog (self.origin + v_forward*20);
  
! 	spawn_tdeath (self.origin, self);
  
  	// Set Rocket Jump Modifiers
  	if (stof(infokey(world, "rj")) != 0)
--- 646,679 ----
  	makevectors(self.angles);
  	spawn_tfog (self.origin + v_forward*20);
  
! 	// Expert 100% spawnfrag prevention
! 	spawn_trespawn (self.origin, self);
! 
! 	// Expert DM_WEAPON_MODES
! 	// Alternate weapons lock - if alternate mode is set here
! 	// it can't be changed later
! 	if (deathmatch & DM_WEAPON_MODES) {
! 		s = infokey(self, "alock");
! 		if ((deathmatch & DM_ALTERNATES_ONLY) || stof(s))
! 			self.weaponmode = 1;
! 		else
! 			self.weaponmode = 0;
! 	}
! 
! // grapple stuff
!       self.on_hook = FALSE;
!       self.hook_out = FALSE;
!  
! // Expert SwitchFire
! 	self.switchfiring = 0;
! 
! // Expert optimization
! 	self.rules_time = time + 1;
! 
! // *TEAMPLAY*
! // TeamFragCheck will boot the player if he has too many negative frags and 
! // the TEAM_BOOT_NEGS bit is set.
! 	TeamFragCheck(self);
  
  	// Set Rocket Jump Modifiers
  	if (stof(infokey(world, "rj")) != 0)
***************
*** 519,551 ****
  		rj = stof(infokey(world, "rj"));
  	}
  
! 	if (deathmatch == 4)
  	{
  		self.ammo_shells = 0;
! 		if (stof(infokey(world, "axe")) == 0)
  		{
  			self.ammo_nails = 255;
  			self.ammo_shells = 255;
  			self.ammo_rockets = 255;
  			self.ammo_cells = 255;
  			self.items = self.items | IT_NAILGUN;
  			self.items = self.items | IT_SUPER_NAILGUN;
  			self.items = self.items | IT_SUPER_SHOTGUN;
  			self.items = self.items | IT_ROCKET_LAUNCHER;
! //		self.items = self.items | IT_GRENADE_LAUNCHER;
  			self.items = self.items | IT_LIGHTNING;
  		}
- 		self.items = self.items - (self.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + IT_ARMOR3;
- 		self.armorvalue = 200;
- 		self.armortype = 0.8;
  		self.health = 250;
- 		self.items = self.items | IT_INVULNERABILITY;
- 		self.invincible_time = 1;
- 		self.invincible_finished = time + 3;
- 	}
  
! 	if (deathmatch == 5)
! 	{
  		self.ammo_nails = 80;
  		self.ammo_shells = 30;
  		self.ammo_rockets = 10;
--- 681,717 ----
  		rj = stof(infokey(world, "rj"));
  	}
  
! 	// Expert: "DM4" and "DM5" rules
! 	if (deathmatch & DM_FREE_GEAR)
  	{
+ 		// DM4 only
+ 		if (!(deathmatch & DM_ITEM_RESPAWN)) {
  			self.ammo_shells = 0;
! 			s = infokey(world, "axe");
! 			if (stof(s) == 0)
  			{
  				self.ammo_nails = 255;
  	 			self.ammo_shells = 255;
  				self.ammo_rockets = 255;
  				self.ammo_cells = 255;
+ 				// Expert DM_WEAPON_MODES
+ 				self.ammo_axes = 255;
  				self.items = self.items | IT_NAILGUN;
  	 			self.items = self.items | IT_SUPER_NAILGUN;
  	 			self.items = self.items | IT_SUPER_SHOTGUN;
  				self.items = self.items | IT_ROCKET_LAUNCHER;
! 				// Expert DM
! 				// Either of these options should make
! 				// grenade ok even with infinite ammo
! 				if (  (deathmatch & DM_BALANCED_WEAPONS) ||
! 					(deathmatch & DM_GRAPPLE))
! 					self.items = self.items | IT_GRENADE_LAUNCHER;
  				self.items = self.items | IT_LIGHTNING;
  			}
  			self.health = 250;
  
! 		// DM5 only
! 		} else {
  			self.ammo_nails = 80;
  			self.ammo_shells = 30;
  			self.ammo_rockets = 10;
***************
*** 556,570 ****
  		self.items = self.items | IT_ROCKET_LAUNCHER;
  		self.items = self.items | IT_GRENADE_LAUNCHER;
  		self.items = self.items | IT_LIGHTNING;
- 		self.items = self.items - (self.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + IT_ARMOR3;
- 		self.armorvalue = 200;
- 		self.armortype = 0.8;
  		self.health = 200;
  		self.items = self.items | IT_INVULNERABILITY;
  		self.invincible_time = 1;
  		self.invincible_finished = time + 3;
  	}
  
  
  };
  
--- 722,783 ----
  			self.items = self.items | IT_ROCKET_LAUNCHER;
  			self.items = self.items | IT_GRENADE_LAUNCHER;
  			self.items = self.items | IT_LIGHTNING;
  			self.health = 200;
+ 		}
+ 		// common to DM4 and DM5
+ 
+ 		// give pentagram only if it's actually invulnerability
+ 		if (!(deathmatch & DM_ALTERNATE_POWERUPS)) {
  			self.items = self.items | IT_INVULNERABILITY;
  	 		self.invincible_time = 1;
  			self.invincible_finished = time + 3;
  		}
+ 		self.items = self.items - (self.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + IT_ARMOR3;
+ 		self.armorvalue = 200;
+ 		self.armortype = 0.8;
+ 	}
  	
+ 	// Expert DM_BALANCED_WEAPONS
+ 	// This is really just balanced weapons, not a balanced game.
+ 	// Gives 50 green armor if not already given, so armor penetration is important
+ 	if (deathmatch & DM_BALANCED_WEAPONS) {
+ 		if (! (self.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) ) {
+ 			self.items = self.items | IT_ARMOR1;
+ 			self.armorvalue = 50; // 50 armor
+ 			self.armortype = 0.3;	// standard absorption, will be overriden if
+ 							// DM_BALANCED_ITEMS is set
+ 		}
+ 	}
+ 	// Expert DM_BALANCED_ITEMS
+ 	// Overrides any previous mode to start player with 100 health and 50 green
+ 	// Gives SSG and extra shells if applicable
+ 	if (deathmatch & DM_BALANCED_ITEMS) {
+ 		self.health = 100; // override any previous armor and health settings
+ 		self.items = self.items - (self.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + IT_ARMOR1;
+ 		self.armorvalue = 50; // 50 armor (so armor penetration is important)
+ 		self.armortype = DM_GREEN_ABSORPTION;
+ 		self.items = self.items | IT_SUPER_SHOTGUN; // free SSG, can be redundant
+ 		if (self.ammo_shells < 40)
+ 			self.ammo_shells = 40; // extra shells
+ 	}
+ 	// Expert DM_ALTERNATE_RESTORE system
+ 	// Overrides any other mode to start player with 100 health and 50 yellow
+ 	if (deathmatch & DM_ALTERNATE_RESTORE) {
+ 		self.health = 100;
+ 		self.items = self.items - (self.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + IT_ARMOR2;
+ 		self.armorvalue = 50;
+ 		self.armortype = DM_YELLOW_ABSORPTION;
+ 	}
+ 	// Expert DM
+ 	// Throwing axe
+ 	if (deathmatch & DM_WEAPON_MODES) {
+ 		if (self.ammo_axes < 4)
+ 			self.ammo_axes = 4; // 4 throwing axes
+ 	}
+ 
+ 	// Expert: start with SSG
+ 	self.weapon = IT_SUPER_SHOTGUN;
+ 	W_SetCurrentAmmo ();
  
  };
  
***************
*** 685,695 ****
  */
  void() CheckRules =
  {       
! 	if (timelimit && time >= timelimit)
  		NextLevel ();
  	
! 	if (fraglimit && self.frags >= fraglimit)
  		NextLevel ();
  };
  
  //============================================================================
--- 898,929 ----
  */
  void() CheckRules =
  {       
! 	// Expert CTF
! 	local float teamCaptures;
! 
! 	if (timelimit && time >= timelimit) {
  		NextLevel ();
+ 		return;
+ 	}
  
! 	// Expert CTF
! 	// Treat fraglimit as a number of captures and end the
! 	// level when "fraglimit" captures are made by one team
! 	if (ctf) {
! 		if (self.assignedTeam == TEAM_COLOR1) {
! 			teamCaptures = team1_captures;
! 		} else {
! 			teamCaptures = team2_captures;
! 		}
! 		if (fraglimit && (teamCaptures >= fraglimit)) {
! 			NextLevel();
! 			return;
! 		}
! 	} else if (fraglimit && self.frags >= fraglimit) {
  		NextLevel ();
+ 		return;
+ 	}
+ 
  };
  
  //============================================================================
***************
*** 733,738 ****
--- 967,975 ----
  {
  	local vector start, end;
  
+ 	// Expert DM
+ 	local vector upVector;
+ 
  	if (self.flags & FL_WATERJUMP)
  		return;
  	
***************
*** 760,767 ****
  	self.flags = self.flags - (self.flags & FL_JUMPRELEASED);       
  	self.button2 = 0;
  
! // player jumping sound
  	sound (self, CHAN_BODY, "player/plyrjmp8.wav", 1, ATTN_NORM);
  };
  
  
--- 997,1020 ----
  	self.flags = self.flags - (self.flags & FL_JUMPRELEASED);       
  	self.button2 = 0;
  
! 	// EXPERT DM
! 	// If DM_ALTERNATE_POWERUPS is set, Pentagram of Protection becomes FiendGlide
! 	if ((self.invincible_finished > time) && (deathmatch & DM_ALTERNATE_POWERUPS))
! 	{
!         	sound (self, CHAN_VOICE, "demon/djump.wav", 1, ATTN_NORM);
! 		makevectors (self.v_angle);
! 		self.origin_z = self.origin_z + 1;
! 		//upVector = (v_forward_z*(-2)) * '0 0 1';
! 		//self.velocity = (v_forward + upVector)*900 + '0 0 300';
! 		self.velocity = v_forward*900 + '0 0 300';
! 
! 	}
! 	else
! 	{
! 		// player jumping sound
  		sound (self, CHAN_BODY, "player/plyrjmp8.wav", 1, ATTN_NORM);
+ 	}
+ 
  };
  
  
***************
*** 775,797 ****
  
  void() WaterMove =
  {
! //dprint (ftos(self.waterlevel));
  	if (self.movetype == MOVETYPE_NOCLIP)
  		return;
  	if (self.health < 0)
  		return;
  
  	if (self.waterlevel != 3)
  	{
  		if (self.air_finished < time)
  			sound (self, CHAN_VOICE, "player/gasp2.wav", 1, ATTN_NORM);
  		else if (self.air_finished < time + 9)
  			sound (self, CHAN_VOICE, "player/gasp1.wav", 1, ATTN_NORM);
  		self.air_finished = time + 12;
  		self.dmg = 2;
  	}
  	else if (self.air_finished < time)
! 	{       // drown!
  		if (self.pain_finished < time)
  		{
  			self.dmg = self.dmg + 2;
--- 1028,1067 ----
  
  void() WaterMove =
  {
! 
! //dprint(ftos(self.waterlevel));
! 
  	if (self.movetype == MOVETYPE_NOCLIP)
  		return;
  	if (self.health < 0)
  		return;
  
+ 	// not fully submerged
  	if (self.waterlevel != 3)
  	{
+ 		// just came out after starting to drown
  		if (self.air_finished < time)
  			sound (self, CHAN_VOICE, "player/gasp2.wav", 1, ATTN_NORM);
  		else if (self.air_finished < time + 9)
  			sound (self, CHAN_VOICE, "player/gasp1.wav", 1, ATTN_NORM);
  		self.air_finished = time + 12;
  		self.dmg = 2;
+ 
+ 		// completely out of the water
+ 		if (!self.waterlevel)
+ 		{
+ 			if (self.flags & FL_INWATER)
+ 			{       
+ 				// play leave water sound
+ 				sound (self, CHAN_BODY, "misc/outwater.wav", 1, ATTN_NORM);
+ 				self.flags = self.flags - FL_INWATER;
+ 			}
+ 			return;
+ 		}
  	}
  	else if (self.air_finished < time)
! 	{     
! 		// completely submerged, check for drowning
  		if (self.pain_finished < time)
  		{
  			self.dmg = self.dmg + 2;
***************
*** 802,822 ****
  		}
  	}
  	
! 	if (!self.waterlevel)
! 	{
! 		if (self.flags & FL_INWATER)
! 		{       
! 			// play leave water sound
! 			sound (self, CHAN_BODY, "misc/outwater.wav", 1, ATTN_NORM);
! 			self.flags = self.flags - FL_INWATER;
! 		}
! 		return;
! 	}
  
  	if (self.watertype == CONTENT_LAVA)
  	{       // do damage
  		if (self.dmgtime < time)
  		{
  			if (self.radsuit_finished > time)
  				self.dmgtime = time + 1;
  			else
--- 1072,1089 ----
  		}
  	}
  
! 	// partially submerged
  
+ 	// check for damaging liquids
  	if (self.watertype == CONTENT_LAVA)
  	{       // do damage
  		if (self.dmgtime < time)
  		{
+ 			// Expert DM (alternate powerups)
+ 			// Fiend's Pentagram gives environment immunity
+ 			if (deathmatch & DM_ALTERNATE_POWERUPS && self.invincible_finished > time) {
+ 				self.dmgtime = time + 1;
+ 			} else {
  				if (self.radsuit_finished > time)
  					self.dmgtime = time + 1;
  				else
***************
*** 825,839 ****
--- 1092,1114 ----
  				T_Damage (self, world, world, 10*self.waterlevel);
  			}
  		}
+ 	}
  	else if (self.watertype == CONTENT_SLIME)
  	{       // do damage
  		if (self.dmgtime < time && self.radsuit_finished < time)
  		{
+ 			// Expert DM (alternate powerups)
+ 			// Fiend's Pentagram gives environment immunity
+ 			if (deathmatch & DM_ALTERNATE_POWERUPS && self.invincible_finished > time) {
+ 				self.dmgtime = time + 1;
+ 			} else {
  				self.dmgtime = time + 1;
  				T_Damage (self, world, world, 4*self.waterlevel);
  			}
  		}
+ 	}
  	
+ 	// check for just entered liquid
  	if ( !(self.flags & FL_INWATER) )
  	{       
  
***************
*** 841,849 ****
  
  		if (self.watertype == CONTENT_LAVA)
  			sound (self, CHAN_BODY, "player/inlava.wav", 1, ATTN_NORM);
! 		if (self.watertype == CONTENT_WATER)
  			sound (self, CHAN_BODY, "player/inh2o.wav", 1, ATTN_NORM);
! 		if (self.watertype == CONTENT_SLIME)
  			sound (self, CHAN_BODY, "player/slimbrn2.wav", 1, ATTN_NORM);
  
  		self.flags = self.flags + FL_INWATER;
--- 1116,1124 ----
  
  		if (self.watertype == CONTENT_LAVA)
  			sound (self, CHAN_BODY, "player/inlava.wav", 1, ATTN_NORM);
! 		else if (self.watertype == CONTENT_WATER)
  			sound (self, CHAN_BODY, "player/inh2o.wav", 1, ATTN_NORM);
! 		else if (self.watertype == CONTENT_SLIME)
  			sound (self, CHAN_BODY, "player/slimbrn2.wav", 1, ATTN_NORM);
  
  		self.flags = self.flags + FL_INWATER;
***************
*** 905,911 ****
--- 1180,1191 ----
  
        self.deathtype = "";
  
+ 	// Expert optimization
+ 	if (time > self.rules_time) {
  		CheckRules ();
+ 		self.rules_time = time + 1;
+ 	}
+ 
  	WaterMove ();
  /*
  	if (self.waterlevel == 2)
***************
*** 932,942 ****
  	if (time < self.pausetime)
  		self.velocity = '0 0 0';
  
! 	if(time > self.attack_finished && self.currentammo == 0 && self.weapon != IT_AXE)
  	{
  		self.weapon = W_BestWeapon ();
  		W_SetCurrentAmmo ();
  	}
  };
  	
  /*
--- 1212,1245 ----
  	if (time < self.pausetime)
  		self.velocity = '0 0 0';
  
! 	if (time > self.attack_finished)
! 	{ 
! 		// Expert DM
! 		// Alternate weapon set has different ammo constraints
! 		if (self.weaponmode && (deathmatch & DM_WEAPON_MODES)) {
! 			if (self.currentammo == 0) 
! 			{
! 				if (self.weapon != IT_SHOTGUN && self.weapon != IT_SUPER_NAILGUN)
! 				{
! 					self.weapon = W2_BestWeapon ();
! 					W2_SetCurrentAmmo ();
! 				}
! 			}
! 		}
! 		else if (self.currentammo == 0)
! 		{
! 			if (self.weapon != IT_AXE)
  			{
  				self.weapon = W_BestWeapon ();
  				W_SetCurrentAmmo ();
  			}
+ 		}
+ 	}
+ 
+ // Do grapple stuff if I'm on a hook
+       if (self.on_hook)
+               Service_Grapple ();
+ 
  };
  	
  /*
***************
*** 957,962 ****
--- 1261,1271 ----
  // sound and screen flash when items starts to run out
  		if (self.invisible_sound < time)
  		{
+ 			// Expert DM
+ 			// Louder whispering for Ring of Will - no stealth required.
+ 			if (deathmatch & DM_ALTERNATE_POWERUPS)
+ 				sound (self, CHAN_AUTO, "items/inv3.wav", 1, ATTN_IDLE);
+ 			else
  				sound (self, CHAN_AUTO, "items/inv3.wav", 0.5, ATTN_IDLE);
  			self.invisible_sound = time + ((random() * 3) + 1);
  		}
***************
*** 966,971 ****
--- 1275,1284 ----
  		{
  			if (self.invisible_time == 1)
  			{
+ 				// Expert DM (DM_ALTERNATE_POWERUPS)
+ 				if (deathmatch & DM_ALTERNATE_POWERUPS)
+ 					sprint (self, PRINT_HIGH, "The Ring of Will is failing\n");
+ 				else
  					sprint (self, PRINT_HIGH, "Ring of Shadows magic is fading\n");
  				stuffcmd (self, "bf\n");
  				sound (self, CHAN_AUTO, "items/inv2.wav", 1, ATTN_NORM);
***************
*** 981,995 ****
--- 1294,1314 ----
  
  		if (self.invisible_finished < time)
  		{       // just stopped
+ 			// Expert DM
+ 			// Don't use Ring item for alternate Ring
+ 			// (item triggers client-side effects)
+ 			if (!(deathmatch & DM_ALTERNATE_POWERUPS))
  				self.items = self.items - IT_INVISIBILITY;
  			self.invisible_finished = 0;
  			self.invisible_time = 0;
  		}
  		
+ 		if (!(deathmatch & DM_ALTERNATE_POWERUPS)) {
  		// use the eyes
  			self.frame = 0;
  			self.modelindex = modelindex_eyes;
  		}
+ 	}
  	else
  		self.modelindex = modelindex_player;    // don't use eyes
  
***************
*** 1001,1006 ****
--- 1320,1329 ----
  		{
  			if (self.invincible_time == 1)
  			{
+ 				// Expert DM (DM_ALTERNATE_POWERUPS)
+ 				if (deathmatch & DM_ALTERNATE_POWERUPS)
+ 					sprint (self, PRINT_HIGH, "The Fiend's Pentagram is fading away\n");
+ 				else
  					sprint (self, PRINT_HIGH, "Protection is almost burned out\n");
  				stuffcmd (self, "bf\n");
  				sound (self, CHAN_AUTO, "items/protect2.wav", 1, ATTN_NORM);
***************
*** 1020,1032 ****
  			self.invincible_time = 0;
  			self.invincible_finished = 0;
  		}
! 		if (self.invincible_finished > time)
! 		{
  			self.effects = self.effects | EF_DIMLIGHT;
  			self.effects = self.effects | EF_RED;
! 		}
! 		else
! 		{
  			self.effects = self.effects - (self.effects & EF_DIMLIGHT);
  			self.effects = self.effects - (self.effects & EF_RED);
  		}
--- 1343,1354 ----
  			self.invincible_time = 0;
  			self.invincible_finished = 0;
  		}
! 		// Expert DM (DM_ALTERNATE_POWERUPS)
! 		// No glow for alternate powerups
! 		if ((self.invincible_finished > time) && !(deathmatch & DM_ALTERNATE_POWERUPS)) {
  			self.effects = self.effects | EF_DIMLIGHT;
  			self.effects = self.effects | EF_RED;
! 		} else {
  			self.effects = self.effects - (self.effects & EF_DIMLIGHT);
  			self.effects = self.effects - (self.effects & EF_RED);
  		}
***************
*** 1042,1048 ****
  		{
  			if (self.super_time == 1)
  			{
! 				if (deathmatch == 4)
  					sprint (self, PRINT_HIGH, "OctaPower is wearing off\n");
  				else
  					sprint (self, PRINT_HIGH, "Quad Damage is wearing off\n");
--- 1364,1374 ----
  		{
  			if (self.super_time == 1)
  			{
! 				// Expert DM (DM_ALTERNATE_POWERUPS)
! 				if (deathmatch & DM_ALTERNATE_POWERUPS)
! 					sprint (self, PRINT_HIGH, "The Glyph of the Lich is dying\n");
! 				// Expert: deathmatch == 4 only
! 				else if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  					sprint (self, PRINT_HIGH, "OctaPower is wearing off\n");
  				else
  					sprint (self, PRINT_HIGH, "Quad Damage is wearing off\n");
***************
*** 1061,1068 ****
  		if (self.super_damage_finished < time)
  		{       // just stopped
  			self.items = self.items - IT_QUAD;
! 			if (deathmatch == 4)
! 			{
  				self.ammo_cells = 255;
  				self.armorvalue = 1;
  				self.armortype = 0.8;
--- 1387,1395 ----
  		if (self.super_damage_finished < time)
  		{       // just stopped
  			self.items = self.items - IT_QUAD;
! 			// Expert: "deathmatch 4" rules, only with normal powerups
! 			if (  !(deathmatch & DM_ALTERNATE_POWERUPS) && 
! 				((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))  ) {
  				self.ammo_cells = 255;
  				self.armorvalue = 1;
  				self.armortype = 0.8;
***************
*** 1071,1083 ****
  			self.super_damage_finished = 0;
  			self.super_time = 0;
  		}
! 		if (self.super_damage_finished > time)
! 		{
  			self.effects = self.effects | EF_DIMLIGHT;
  			self.effects = self.effects | EF_BLUE;
! 		}
! 		else
! 		{
  			self.effects = self.effects - (self.effects & EF_DIMLIGHT);
  			self.effects = self.effects - (self.effects & EF_BLUE);
  		}
--- 1398,1409 ----
  			self.super_damage_finished = 0;
  			self.super_time = 0;
  		}
! 		// Expert DM (DM_ALTERNATE_POWERUPS)
! 		// No glow for alternate powerups
! 		if ((self.super_damage_finished > time) && !(deathmatch & DM_ALTERNATE_POWERUPS)) {
  			self.effects = self.effects | EF_DIMLIGHT;
  			self.effects = self.effects | EF_BLUE;
! 		} else {
  			self.effects = self.effects - (self.effects & EF_DIMLIGHT);
   			self.effects = self.effects - (self.effects & EF_BLUE);
  		}
***************
*** 1114,1119 ****
--- 1440,1451 ----
  		}
  	}       
  
+ 	// Expert DM
+ 	// Periodic sound effects to make Quad Damage and Pentagram
+ 	// visible, more avoidable, and more dangerous to the user.
+ 	// No periodic warning sounds for the alternate powerups.
+ 	if ((deathmatch & DM_BALANCED_ITEMS) && !(deathmatch & DM_ALTERNATE_POWERUPS))
+ 		DMPowerupSounds();
  };
  
  
***************
*** 1136,1142 ****
  		return;
  
  // check to see if player landed and play landing sound 
! 	if ((self.jump_flag < -300) && (self.flags & FL_ONGROUND) )
  	{
  		if (self.watertype == CONTENT_WATER)
  			sound (self, CHAN_BODY, "player/h2ojump.wav", 1, ATTN_NORM);
--- 1468,1476 ----
  		return;
  
  // check to see if player landed and play landing sound 
! 	if (self.jump_flag < -300)
! 	{
! 		if (self.flags & FL_ONGROUND)
  		{
  			if (self.watertype == CONTENT_WATER)
  				sound (self, CHAN_BODY, "player/h2ojump.wav", 1, ATTN_NORM);
***************
*** 1149,1163 ****
--- 1483,1584 ----
  			else
  				sound (self, CHAN_VOICE, "player/land.wav", 1, ATTN_NORM);
  		}
+ 	}
  
  	self.jump_flag = self.velocity_z;
  
  	CheckPowerups ();
  
+ 	// Expert DM
+ 	if (deathmatch & DM_PLAYER_FORWARDING)
+ 		DMForwardingCheck();
+ 
+ 	if (deathmatch & DM_ALTERNATE_RESTORE) {
+ 		if (self.heal_time < time) {
+ 			T_Heal(self, DM_REGEN_AMOUNT, 0);
+ 			self.heal_time = time + DM_REGEN_DELAY;
+ 		}
+ 	}
+ 
+ // *TEAMPLAY*
+ // TeamCheckLock performs all necessary teamlock checking, and performs all
+ // actions needed.
+ 
+ // *TEAMPLAY*
+ // Calling TeamCheckPrintScore every tic causes the score to be
+ // printed every TEAM_SCORE_FREQUENCY seconds
+ 
+ 	if (teamplay) {
+ 		if (self.lastteamcheck + TEAM_CHECK_DELAY < time) {
+ 			TeamCheckLock();
+ 			self.lastteamcheck = time;
+ 		}
+ 		if (time > teamScorePrintTime) {
+ 			if (ctf) {
+ 				PrintCTFScore();
+ 				//if (self.player_flag & ITEM_ENEMY_FLAG)
+ 				//	CheckEscort(self);
+ 			} else if (teamplay & TEAM_SCORING) {
+ 				TeamPrintTeamScore();
+ 			}
+ 			teamScorePrintTime = time + TEAM_PRINT_DELAY;
+ 		}
+ 	}
+ 
+ // Expert DM
+ // DMShirtColor locks shirt color to armor color
+ 	if (deathmatch & DM_ARMOR_COLOR)
+ 		DMShirtColorLock();
+ 
+ 	if (self.flags & FL_FIRSTCONNECT) {
+ 		FirstConnect();
+ 		self.flags = self.flags - FL_FIRSTCONNECT;
+ 	}
+ 
+ 	if (self.impulse || time > self.attack_finished)
  		W_WeaponFrame ();
  	
+ 	if (time > self.statustime)
+ 		StatusCheckTime (self);
+ 
  };
  
+ /*
+ ===========
+ FirstConnect
+ 
+ Guaranteed to be called only the first time a player connects to the server.
+ ============
+ */
+ void() FirstConnect =
+ {
+ 	local string s;
+ 
+ 	if (ctf) {
+ 		s = infokey(self, "statusbar");
+ 		if (s == "") {
+ 			stuffcmd(self, "setinfo statusbar 1\n");
+ 		}
+ 	}
+ 
+ 	s = infokey(self, "ident");
+ 	if (s == "") {
+ 		stuffcmd(self, "setinfo ident 1\n");
+ 	}
+ 
+ 	// Create the entity that will print the message
+ 	// of the day for this player
+ 	CreateMOTDObj();
+ 
+ 	stuffcmd(self, "alias settings \"impulse 25\";alias motd \"impulse 26\";alias serverhelp \"impulse 27\"\n");
+ 	stuffcmd(self, "alias help-server \"impulse 27\";alias helpserver \"impulse 27\"; alias server-help\"impulse 27\"\n");
+ 	if (teamplay & TEAM_AUDIO)
+ 		stuffcmd(self, "alias speech \"impulse 190\"; alias usage \"impulse 191\";\n");
+ 	if (deathmatch & DM_GRAPPLE)
+ 		stuffcmd(self, "alias +hook \"impulse 146\"; alias -hook \"impulse 147\";\n");
+ 	if (deathmatch & DM_WEAPON_MODES)
+ 		stuffcmd(self, "bind 9 \"impulse 210\"\n");
+ };
  
  /*
  ===========
***************
*** 1168,1175 ****
--- 1589,1623 ----
  */
  void() ClientConnect =
  {
+ 	// Expert DM
+ 	DMForwardingSetup();
+ 
+ 	if (self.ToBeFwded == 0) {
  		bprint (PRINT_HIGH, self.netname);
  		bprint (PRINT_HIGH, " entered the game\n");
+ 	}
+ 
+ 	// this flags the player as having just connected.  Later, in
+ 	// DecodeLevelParms(), we can determine if this is a new connect or
+ 	// a reconnect after level change, and do some "initial connection" stuff.
+ 	self.flags = self.flags | FL_JUSTCONNECTED;
+ 
+ 	// if this player is reconnecting after a level change, he'll
+ 	// get the correct team assigned in DecodeLevelParms.  Otherwise,
+ 	// we want to assign him to a new team, so we set him an invalid
+ 	// team that will be detected by TeamCheckLock()
+ 	self.assignedTeam = -1;
+ 
+ 	// mark the player with the time he connected
+ 	self.connecttime = time;
+ 
+ 	// XXX EXPERT CTF
+ 
+ 	// Reset times for additional scoring system on level change and server join
+ 	self.last_returned_flag = -10;	
+ 	self.last_fragged_carrier = -10;
+ 	self.flag_since = -10;
+ 	self.last_hurt_carrier = -10;
  
  // a client connecting during an intermission can cause problems
  	if (intermission_running)
***************
*** 1186,1200 ****
--- 1634,1685 ----
  */
  void() ClientDisconnect =
  {
+ 
+ // *TEAMPLAY*
+ // If we were NegBooted, indicate it in the exit message.
+ 	if((teamplay & TEAM_BOOT_NEGS) && (self.frags <= TEAM_FRAG_FLOOR))
+ 	{
+ 		bprint(PRINT_HIGH, self.netname);
+ 		bprint(PRINT_HIGH, " is kicked for having too many negative frags!\n");
+ 	}
+ 	else
+ 	{
  		// let everyone else know
  		bprint (PRINT_HIGH, self.netname);
  		bprint (PRINT_HIGH, " left the game with ");
  		bprint (PRINT_HIGH, ftos(self.frags));
  		bprint (PRINT_HIGH, " frags\n");
+ 	}
+ 	
+ 	// Expert CTF
+ 	if (ctf)
+ 		TeamCaptureDropFlagOfPlayer(self);
+ 
+ 	// Expert DM
+ 	// Forwarding
+ 	self.ToBeFwded = 10;
+ 
+ 	// Reset hook if out
+ 	if (self.hook_out)
+ 		Reset_Grapple(self);
+ 
  	sound (self, CHAN_BODY, "player/tornoff2.wav", 1, ATTN_NONE);
  	set_suicide_frame ();
+ 
+ // *TEAMPLAY*
+ // Reset teamplay variables
+ 	parm10 = -1;
+ 	self.assignedTeam = -1;
+ 	self.lastteamset = -50;
+ 
  };
  
+ // *TEAMPLAY*
+ // Prototypes
+ 
+ float(entity targ, entity attacker) TeamFragPenalty;
+ void(entity targ, entity attacker) TeamDeathPenalty;
+ 
  /*
  ===========
  ClientObituary
***************
*** 1202,1224 ****
  called when a player dies
  ============
  */
- 
  void(entity targ, entity attacker) ClientObituary =
  {
! 	local   float rnum;
  	local   string deathstring, deathstring2;
  	local   string s;
! 	local   string  attackerteam, targteam;
  
  	rnum = random();
  	//ZOID 12-13-96: self.team doesn't work in QW.  Use keys
! 	attackerteam = infokey(attacker, "team");
! 	targteam = infokey(targ, "team");
  
  	if (targ.classname == "player")
  	{
  
! 		if (deathmatch > 3)	
  		{
  			if (targ.deathtype == "selfwater")
  			{
--- 1687,1713 ----
  called when a player dies
  ============
  */
  void(entity targ, entity attacker) ClientObituary =
  {
! 	local   float rnum, temp;
  	local   string deathstring, deathstring2;
  	local   string s;
! 	local   float attackerteam, targteam;
  
  	rnum = random();
  	//ZOID 12-13-96: self.team doesn't work in QW.  Use keys
! 	//Myrkul 4-6-97: all team functions work on self.assignedTeam, 
! 	//since players can't set it.
! 	attackerteam = attacker.assignedTeam;
! 	targteam = targ.assignedTeam;
  
  	if (targ.classname == "player")
  	{
+ 		// EXPERT CTF SCORING
+ 		if (ctf)
+ 			ResetCarrierHurts (targ);
  
! 		if (deathmatch & DM_FREE_GEAR)	
  		{
  			if (targ.deathtype == "selfwater")
  			{
***************
*** 1264,1273 ****
  			return;
  		}
  	
- 
  		if (targ.deathtype == "squish")
  		{
! 			if (teamplay && targteam == attackerteam && attackerteam != "" && targ != attacker)
  			{
  				logfrag (attacker, attacker);
  				attacker.frags = attacker.frags - 1; 
--- 1753,1761 ----
  			return;
  		}
  	
  		if (targ.deathtype == "squish")
  		{
! 			if (teamplay && targteam == attackerteam && targ != attacker)
  			{
  				logfrag (attacker, attacker);
  				attacker.frags = attacker.frags - 1; 
***************
*** 1307,1312 ****
--- 1795,1810 ----
  					bprint (PRINT_MEDIUM," tries to put the pin back in\n");
  				else if (targ.deathtype == "rocket")
  					bprint (PRINT_MEDIUM," becomes bored with life\n");
+ 				// Expert DM
+ 				// Alternate's suicide messages
+ 				else if (targ.deathtype == "w2axe")
+ 					bprint(PRINT_MEDIUM, " axed a question\n");
+ 				else if (targ.deathtype == "w2gibgun")
+ 					bprint(PRINT_MEDIUM, " ran out of flesh\n");
+ 				else if (targ.deathtype == "w2squirrel")
+ 					bprint (PRINT_MEDIUM," couldn't tame his squirrel\n");
+ 				else if (targ.deathtype == "w2mortar")
+ 					bprint (PRINT_MEDIUM," shelled himself\n");
  				else if (targ.weapon == 64 && targ.waterlevel > 1)
  				{
  					if (targ.watertype == CONTENT_SLIME)
***************
*** 1315,1328 ****
  						bprint (PRINT_MEDIUM," discharges into the lava\n");
  					else
  						bprint (PRINT_MEDIUM," discharges into the water.\n");
  				}
  				else
  					bprint (PRINT_MEDIUM," becomes bored with life\n");
  				return;
  			}
! 			else if ( (teamplay == 2) && (targteam == attackerteam) &&
! 				(attackerteam != "") )
  			{
  				if (rnum < 0.25)
  					deathstring = " mows down a teammate\n";
  				else if (rnum < 0.50)
--- 1813,1840 ----
  						bprint (PRINT_MEDIUM," discharges into the lava\n");
  					else
  						bprint (PRINT_MEDIUM," discharges into the water.\n");
+ 					return;
  				}
    				else
  					bprint (PRINT_MEDIUM," becomes bored with life\n");
    				return;
  			}
! 			else if (teamplay && (targteam == attackerteam))
  			{
+ 
+ // *TEAMPLAY*
+ // TeamFragPenalty returns true if the attacker gets a frag penalty for
+ // killing this target.  It also deducts frags as needed.
+ 
+ 				if (!TeamFragPenalty(targ, attacker))
+ 					attacker.frags = attacker.frags + 1;
+ 
+ // *TEAMPLAY*
+ // TeamDeathPenalty kills the attacker if necessary and adjusts frags to
+ // offset the one frag penalty for dying.
+ 
+                         TeamDeathPenalty(targ, attacker);
+ 
  				if (rnum < 0.25)
  					deathstring = " mows down a teammate\n";
  				else if (rnum < 0.50)
***************
*** 1333,1339 ****
  					deathstring = " loses another friend\n";
  				bprint (PRINT_MEDIUM, attacker.netname);
  				bprint (PRINT_MEDIUM, deathstring);
- 				attacker.frags = attacker.frags - 1;
  				//ZOID 12-13-96:  killing a teammate logs as suicide
  				logfrag (attacker, attacker);
  				return;
--- 1845,1850 ----
***************
*** 1343,1348 ****
--- 1854,1863 ----
  				logfrag (attacker, targ);
  				attacker.frags = attacker.frags + 1;
  
+ 				// EXPERT CTF SCORING
+ 				if (ctf)
+ 					ExpertScoring (attacker, targ);
+ 
  				rnum = attacker.weapon;
  				if (targ.deathtype == "nail")
  				{
***************
*** 1366,1372 ****
  				}
  				else if (targ.deathtype == "rocket")
  				{
! 					if (attacker.super_damage_finished > 0 && targ.health < -40)
  					{
  						rnum = random();
  						if (rnum < 0.3)
--- 1881,1888 ----
  				}
  				else if (targ.deathtype == "rocket")
  				{
! 					if ((attacker.super_damage_finished > 0 && targ.health < -40) &&
! 						!(deathmatch & DM_ALTERNATE_POWERUPS))
  					{
  						rnum = random();
  						if (rnum < 0.3)
***************
*** 1394,1399 ****
--- 1910,1950 ----
  						}
  					}
  				}
+ 				// Expert DM
+ 				// Hook kill.. rare but true
+ 				else if (targ.deathtype == "hook")
+ 				{
+ 					deathstring = " got in ";
+ 					deathstring2 = "'s way\n";
+ 				}
+ 				// Expert DM
+ 				// Alternates with projectiles
+ 				else if (targ.deathtype == "w2axe")
+ 				{
+ 					deathstring = " was split by ";
+ 					deathstring2 = "'s throwing axe\n";
+ 				}
+ 				else if (targ.deathtype == "w2pulse")
+ 				{
+ 					deathstring = " feels ";
+ 					deathstring2 = "'s pulse\n";
+ 				}
+ 				else if (targ.deathtype == "w2gib")
+ 				{
+ 					deathstring = " was bludgeoned by ";
+ 					deathstring2 = "'s flesh\n";
+ 				}
+ 				else if (targ.deathtype == "w2squirrel")
+ 				{
+ 					deathstring = " was chased down by ";
+ 					deathstring2 = "'s squirrel bomb\n";
+ 				}
+ 				else if (targ.deathtype == "w2mortar")
+ 				{
+ 					deathstring = " was shelled by ";
+ 					deathstring2 = "'s mortars\n";
+ 				}
+ 				// Instant weapons
  				else if (rnum == IT_AXE)
  				{
  					deathstring = " was ax-murdered by ";
***************
*** 1468,1473 ****
--- 2019,2025 ----
  			}
  			if (targ.deathtype == "falling")
  			{
+ 				targ.deathtype = "";
  				bprint (PRINT_MEDIUM," fell to his death\n");
  				return;
  			}
***************
*** 1476,1486 ****
  				bprint (PRINT_MEDIUM," was spiked\n");
  				return;
  			}
- 			if (targ.deathtype == "laser")
- 			{
- 				bprint (PRINT_MEDIUM," was zapped\n");
- 				return;
- 			}
  			if (attacker.classname == "fireball")
  			{
  				bprint (PRINT_MEDIUM," ate a lavaball\n");
--- 2028,2033 ----
diff -crbB --unidirectional-new-file qw201/combat.qc expert12/combat.qc
*** qw201/combat.qc	Tue Aug 12 14:18:26 1997
--- expert12/combat.qc	Sat Aug 16 21:31:04 1997
***************
*** 84,89 ****
--- 84,92 ----
  
  	ClientObituary(self, attacker);
  
+ 	// Expert DM
+ 	ShowExitRules(self);	
+ 
  	self.takedamage = DAMAGE_NO;
  	self.touch = SUB_Null;
  	self.effects = 0;
***************
*** 111,123 ****
  	local   entity  oldself;
  	local   float   save;
  	local   float   take;
  	local   string  s;
! 	local   string  attackerteam, targteam;
  
  
  	if (!targ.takedamage)
  		return;
  
  // used by buttons and triggers to set activator for target firing
  	damage_attacker = attacker;
  
--- 113,137 ----
  	local   entity  oldself;
  	local   float   save;
  	local   float   take;
+ 	// Expert DM (DM_ALTERNATE_POWERUPS)
+ 	local   float   leech;
  	local   string  s;
! 	local   float attackerteam, targteam;
  
  
  	if (!targ.takedamage)
  		return;
  
+ 	// *XXX* EXPERT CTF mark players who hurt the flag carrier, so they 
+ 	// are worth more points for a while.
+ 	if ( (attacker.classname == "player") && // attacker must be a player
+ 	     (targ.player_flag & ITEM_ENEMY_FLAG) && // target is a flag carrier
+ 	     (attacker.assignedTeam != targ.assignedTeam) && // target and attacker on diff teams
+ 	     (targ.assignedTeam > 0) ) // unconnected check?
+ 	{
+ 		attacker.last_hurt_carrier = time;
+ 	}
+ 
  // used by buttons and triggers to set activator for target firing
  	damage_attacker = attacker;
  
***************
*** 121,137 ****
  // used by buttons and triggers to set activator for target firing
  	damage_attacker = attacker;
  
- 
  // check for quad damage powerup on the attacker
! 	if (attacker.super_damage_finished > time && inflictor.classname != "door")
! 	if (deathmatch == 4)
  		damage = damage * 8;
  	else
  		damage = damage * 4;
  
  // save damage based on the target's armor level
  
  	save = ceil(targ.armortype*damage);
  	if (save >= targ.armorvalue)
  	{
  		save = targ.armorvalue;
--- 135,168 ----
  // used by buttons and triggers to set activator for target firing
  	damage_attacker = attacker;
  
  // check for quad damage powerup on the attacker
! 	// Expert DM
! 	// If DM_ALTERNATE_POWERUPS is set, Quad is the Glyph of the Lich
! 	if (attacker.super_damage_finished > time) {
! 		if ( (inflictor.classname != "door") &&
! 			(!(deathmatch & DM_ALTERNATE_POWERUPS)) )
! 		{
! 			// Expert: "deathmatch 4" mode only
! 			if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  				damage = damage * 8;
  			else
  				damage = damage * 4;
+ 		}
+ 	}
  
  // save damage based on the target's armor level
  
+ // *TEAMPLAY*
+ // TeamArmorDam returns true iff the attacker can damage the target's armor
+ 	if (targ.armorvalue && TeamArmorDam(targ, inflictor, attacker, damage))	{
+ 		if (deathmatch & DM_BALANCED_WEAPONS)
+ 			save = ArmorPenetration(targ, inflictor, attacker, damage);
+ 		else
  			save = ceil(targ.armortype*damage);
+ 	} else {
+ 		save = 0;
+ 	}
+ 
  	if (save >= targ.armorvalue)
  	{
  		save = targ.armorvalue;
***************
*** 156,187 ****
  
  
  // figure momentum add
! 	if ( (inflictor != world) && (targ.movetype == MOVETYPE_WALK) )
  	{
  		dir = targ.origin - (inflictor.absmin + inflictor.absmax) * 0.5;
  		dir = normalize(dir);
  		// Set kickback for smaller weapons
  		// Read: only if it's not yourself doing the damage
! 		if ( (damage < 60) & ((attacker.classname == "player") & (targ.classname == "player")) & ( attacker.netname != targ.netname)) 
  			targ.velocity = targ.velocity + dir * damage * 11;
  		else                        
  		// Otherwise, these rules apply to rockets and grenades                        
  		// for blast velocity
  			targ.velocity = targ.velocity + dir * damage * 8;
! 		
  		// Rocket Jump modifiers
! 		if ( (rj > 1) & ((attacker.classname == "player") & (targ.classname == "player")) & ( attacker.netname == targ.netname)) 
  			targ.velocity = targ.velocity + dir * damage * rj;
! 
  	}
  
  
  
  // check for godmode or invincibility
  	if (targ.flags & FL_GODMODE)
  		return;
  	if (targ.invincible_finished >= time)
  	{
  		if (self.invincible_sound < time)
  		{
  			sound (targ, CHAN_ITEM, "items/protect3.wav", 1, ATTN_NORM);
--- 187,251 ----
  
  
  // figure momentum add
! 	// Expert DM (DM_ALTERNATE_POWERUPS)
! 	// Ring of Will gives immunity to weapon push
! 	if (  (inflictor != world) &&
! 		(targ.movetype == MOVETYPE_WALK) &&
! 		!((deathmatch & DM_ALTERNATE_POWERUPS) && (targ.invisible_finished))   )
  	{
  		dir = targ.origin - (inflictor.absmin + inflictor.absmax) * 0.5;
  		dir = normalize(dir);
+ 
+ 		// Expert DM
+ 		// Ring of Will throws opponents back
+ 		if ((deathmatch & DM_ALTERNATE_POWERUPS) && (attacker.invisible_finished))
+ 			dir = dir * 4;
+ 
  		// Set kickback for smaller weapons
  		// Read: only if it's not yourself doing the damage
! 		if (  (damage < 60) && ((attacker.classname == "player") && (targ.classname == "player")) &&
! 				(attacker.netname != targ.netname)  ) 
! 		{
! 			if (deathmatch & DM_BALANCED_WEAPONS)
! 				targ.velocity = targ.velocity + dir * damage * DM_LIGHT_VELOCITY;
! 			else
  				targ.velocity = targ.velocity + dir * damage * 11;
+ 		}
  		else
+ 		{                       
  			// Otherwise, these rules apply to rockets and grenades                        
  			// for blast velocity
+ 			// Expert DM
+ 			// Smaller kick.  Large kick lessens control; knock someone in the
+ 			// air even with a wide miss, and you keep them in the air.
+ 			if (deathmatch & DM_BALANCED_WEAPONS)
+ 				targ.velocity = targ.velocity + dir * damage * DM_HEAVY_VELOCITY;
+ 			else
  				targ.velocity = targ.velocity + dir * damage * 8;
! 		}
  		// Rocket Jump modifiers
! 		if (rj > 1) {
! 			if (  ((attacker.classname == "player") && (targ.classname == "player")) &&
! 				(attacker.netname == targ.netname)  )
  				targ.velocity = targ.velocity + dir * damage * rj;
! 		}
  	}
  
+ // *TEAMPLAY*
+ // Friendly fire detection and notification
  
+ 	if (teamplay & TEAM_FF_NOTICE)
+ 		TeamFFNotice(attacker, targ);
  
  // check for godmode or invincibility
  	if (targ.flags & FL_GODMODE)
  		return;
+ 
+ 	// Expert DM
+ 	// If DM_ALTERNATE_POWERUPS is set, Pentagram is the FiendGlide
  	if (targ.invincible_finished >= time)
  	{
+ 		if (!(deathmatch & DM_ALTERNATE_POWERUPS)) {
  			if (self.invincible_sound < time) 
  			{
  				sound (targ, CHAN_ITEM, "items/protect3.wav", 1, ATTN_NORM);
***************
*** 189,215 ****
  		}
  		return;
  	}
  
! // team play damage avoidance
! //ZOID 12-13-96: self.team doesn't work in QW.  Use keys
! 	attackerteam = infokey(attacker, "team");
! 	targteam = infokey(targ, "team");
! 
! 	if ((teamplay == 1) && (targteam == attackerteam) &&
! 		(attacker.classname == "player") && (attackerteam != "") &&
! 		inflictor.classname !="door")
! 		return;
  
! 	if ((teamplay == 3) && (targteam == attackerteam) &&
! 		(attacker.classname == "player") && (attackerteam != "") &&
! 		(targ != attacker)&& inflictor.classname !="door")
  		return;
  		
  // do the damage
  	targ.health = targ.health - take;
  
  	if (targ.health <= 0)
  	{
  		Killed (targ, attacker);
  		return;
  	}
--- 253,304 ----
  			}
  			return;
  		}
+ 	}
  
! // *TEAMPLAY*
! // TeamHealthDam will return true if the attacker can damage the target's
! // health
  
!         if (!TeamHealthDam(targ, inflictor, attacker, damage))
                  return;
  
+ 	// Expert DM
+ 	// If DM_ALTERNATE_POWERUPS is set, Quad becomes the Glyph of the Lich
+ 	if ((attacker.super_damage_finished > time) && 
+ 		(deathmatch & DM_ALTERNATE_POWERUPS) && 
+ 		(targ.classname == "player"))
+ 	{
+ 		if ((targ.health - take) <= 0)
+ 			leech = (0.5 * targ.health);
+ 		else
+ 			leech = (0.5 * take);
+ 		// Add to attacker's health, using a higher max
+ 		attacker.max_health = DM_LICH_CAP;
+ 		T_Heal(attacker, leech, 0);
+ 		attacker.max_health = 100;
+ 	}
+ 
  // do the damage
  	targ.health = targ.health - take;
  
  	if (targ.health <= 0)
  	{
+ 		// Expert DM
+ 		// Alternate health restoration system.
+ 		// Receive healing and restore armor on making a kill.
+ 		if (deathmatch & DM_ALTERNATE_RESTORE) 
+ 		{
+ 			if (attacker.classname == "player")
+ 			{	
+ 				// make sure has yellow armor item
+ 				attacker.items = attacker.items - 
+ 					(attacker.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + IT_ARMOR2;
+ 				attacker.armorvalue = attacker.armorvalue + DM_KILL_ARMOR;
+ 				if (attacker.armorvalue > DM_YELLOW_AMOUNT)
+ 					attacker.armorvalue = DM_YELLOW_AMOUNT;
+ 				T_Heal(attacker, DM_KILL_HEALTH, 0);
+ 			}
+ 		}
  		Killed (targ, attacker);
  		return;
  	}
***************
*** 218,240 ****
  	oldself = self;
  	self = targ;
  
- /*SERVER
- 	if ( (self.flags & FL_MONSTER) && attacker != world)
- 	{
- 	// get mad unless of the same class (except for soldiers)
- 		if (self != attacker && attacker != self.enemy)
- 		{
- 			if ( (self.classname != attacker.classname) 
- 			|| (self.classname == "monster_army" ) )
- 			{
- 				if (self.enemy.classname == "player")
- 					self.oldenemy = self.enemy;
- 				self.enemy = attacker;
- 				FoundTarget ();
- 			}
- 		}
- 	}
- */
  	if (self.th_pain)
  	{
  		self.th_pain (attacker, take);
--- 307,312 ----
***************
*** 253,258 ****
--- 325,331 ----
  	local   float   points;
  	local   entity  head;
  	local   vector  org;
+ 	local   float   selfdamage;	
  
  	head = findradius(inflictor.origin, damage+40);
  	
***************
*** 273,280 ****
  					points = 0;
  				points = damage - points;
  				
! 				if (head == attacker)
  					points = points * 0.5;
  				if (points > 0)
  				{
  					if (CanDamage (head, inflictor))
--- 347,360 ----
  					points = 0;
  				points = damage - points;
  				
! 				if (head == attacker) {
! 					// Expert DM
! 					if (deathmatch & DM_BALANCED_WEAPONS) {
! 						points = points * DM_SPLASH_FRACTION;
! 					} else {
  						points = points * 0.5;
+ 					}
+ 				}
  				if (points > 0)
  				{
  					if (CanDamage (head, inflictor))
***************
*** 314,320 ****
--- 394,402 ----
  			if (points > 0)
  			{
  				if (CanDamage (head, attacker))
+ 				{
  					T_Damage (head, attacker, attacker, points);
+ 				}
  			}
  		}
  		head = head.chain;
diff -crbB --unidirectional-new-file qw201/ctf.qc expert12/ctf.qc
*** qw201/ctf.qc	Thu Jan  1 00:00:00 1970
--- expert12/ctf.qc	Sat Aug 16 21:28:14 1997
***************
*** 0 ****
--- 1,1058 ----
+ /** Defs **/
+ 
+ // last time this player was marked as escort
+ .float escortSince;
+ .float lastEscort;
+ 
+ // Globals
+ 
+ entity team1_lastspawn;
+ entity team2_lastspawn;
+ 
+ float	nextteamupdtime;	// time until next team update
+ 
+ // EXPERT CTF
+ // Why make the top scores just contain all the members on the team in the
+ // lead?  Like stats for a professional sports game, scores should reflect
+ // the extent to which a player has benefitted his team.  The best individual
+ // players on the server should have the highest score, regardless of team.
+ // Team score is separate, and reflects a number of captures.
+ float TEAM_CAPTURE_CAPTURE_BONUS = 7; // what you get for capture
+ float TEAM_CAPTURE_TEAM_BONUS = 0; // what your team gets for capture
+ float TEAM_CAPTURE_RECOVERY_BONUS = 1; // what you get for recovery
+ float TEAM_CAPTURE_FLAG_BONUS = 0; // what you get for picking up enemy flag
+ float TEAM_CAPTURE_FRAG_CARRIER_BONUS = 2; // what you get for fragging
+ 	//enemy flag carrier
+ float TEAM_CAPTURE_FLAG_RETURN_TIME = 40; // seconds until auto return
+ 
+ // bonuses
+ 
+ float TEAM_CAPTURE_CARRIER_DANGER_PROTECT_BONUS = 2; // bonus for fraggin someone
+ // who has recently hurt your flag carrier
+ float TEAM_CAPTURE_CARRIER_PROTECT_BONUS = 1; // bonus for fraggin someone while
+ // either you or your target are near your flag carrier
+ float TEAM_CAPTURE_FLAG_DEFENSE_BONUS = 1; // bonus for fraggin someone while
+ // either you or your target are near your flag
+ float TEAM_CAPTURE_RETURN_FLAG_ASSIST_BONUS = 1; // awarded for returning a flag that causes a
+ // capture to happen almost immediately
+ float TEAM_CAPTURE_FRAG_CARRIER_ASSIST_BONUS = 2; // award for fragging a flag carrier if a
+ // capture happens almost immediately
+ 
+ float TEAM_CAPTURE_ESCORT_CARRIER_ASSIST_BONUS = 0.1; // per-second award for carrier escort
+ float TEAM_CAPTURE_MAX_ESCORT_BONUS = 5; // maximum carrier escort bonus (at 50+ seconds)
+ 
+ // radii
+ 
+ float TEAM_CAPTURE_TARGET_PROTECT_RADIUS = 600; // the radius around an object being
+ // defended where a target will be worth extra frags
+ float TEAM_CAPTURE_ATTACKER_PROTECT_RADIUS = 600; // the radius around an object being
+ // defended where an attacker will get extra frags when making kills
+ 
+ float TEAM_CAPTURE_ESCORT_RADIUS = 500; // the radius around a flag carrier where
+ // a player is considered an escort
+ 
+ // timeouts
+ 
+ float TEAM_CAPTURE_CARRIER_DANGER_PROTECT_TIMEOUT = 4;
+ float TEAM_CAPTURE_CARRIER_FLAG_SINCE_TIMEOUT = 2;
+ float TEAM_CAPTURE_FRAG_CARRIER_ASSIST_TIMEOUT = 6;
+ float TEAM_CAPTURE_RETURN_FLAG_ASSIST_TIMEOUT = 4;
+ 
+ float TEAM_CAPTURE_ESCORT_TIMEOUT = 8;
+ float TEAM_CAPTURE_MINIMUM_ESCORT_TIME = 5;
+ float TEAM_CAPTURE_ESCORT_ELIGIBILITY_TIME = 20;
+ 
+ float TEAM_CAPTURE_UPDATE_TIME = 120;
+ 
+ // END EXPERT CTF
+ 
+ // flag status used in cnt field of flag
+ float FLAG_AT_BASE = 0;
+ float FLAG_CARRIED = 1;
+ float FLAG_DROPPED = 2;
+ 
+ // ZOID: Capture the flag
+ float		ITEM_ENEMY_FLAG =			16;
+ 
+ // events
+ float EVENT_ASSIST = 1;
+ float EVENT_BONUS = 2;
+ 
+ // Prototypes
+ float() W_BestWeapon;
+ void() W_SetCurrentAmmo;
+ void() bound_other_ammo;
+ void(float o, float n) Deathmatch_Weapon;
+ void() BackpackTouch;
+ 
+ /*
+ ================
+ InitCTF
+ 
+ Called on the first frame of a new level.
+ ================
+ */
+ void() InitCTF =
+ {
+ 	team1_captures = team2_captures = 0;
+ };
+ 
+ // *XXX* EXPERT CTF
+ // Just a quickie to return the ASCII-ized team names for CTF
+ string(float Team) GetCTFTeam =
+ {
+ 
+ 	if (Team == TEAM_COLOR1) return "";
+ 	if (Team == TEAM_COLOR2) return "";
+ 	return "";
+ };
+ 
+ /*
+ ==================================
+ TeamCaptureSpawn
+ 
+ Special spawn function for cycling through CTF spawn spots
+ ==================================
+ */
+ entity() TeamCaptureSpawn =
+ {
+ 	
+ 	if (self.assignedTeam == TEAM_COLOR1) {
+ 		team1_lastspawn = find(team1_lastspawn, classname, "info_player_team1");
+ 		if (team1_lastspawn == world)
+ 			team1_lastspawn = find(team1_lastspawn, classname, "info_player_team1");
+ 		return team1_lastspawn;
+ 	} else if (self.assignedTeam == TEAM_COLOR2) {
+ 		team2_lastspawn = find(team2_lastspawn, classname, "info_player_team2");
+ 		if (team2_lastspawn == world)
+ 			team2_lastspawn = find(team2_lastspawn, classname, "info_player_team2");
+ 		return team2_lastspawn;
+ 	}
+ 	return world;
+ };
+ 
+ /*
+ ==================================
+ CTFNextLevel
+ 
+ Return the next level to go to for CTF, taking into account
+ the number of players and whether grapple is enabled.
+ ==================================
+ */
+ void() CTFNextLevel =
+ {
+ 	local string s;
+ 	local float maxPlayers;
+ 
+ 	// determine number of clients
+ 	s = infokey(world, "maxclients");
+ 	maxPlayers = stof(s);
+ 
+ 	if (deathmatch & DM_GRAPPLE) {
+ 		if (maxPlayers < 20) {
+ 			localcmd("CHSCYCLE\n");
+ 		} else {
+ 			localcmd("CHLCYCLE\n");
+ 		}
+ 	} else {
+ 		if (maxPlayers < 20) {
+ 			localcmd("CNSCYCLE\n");
+ 		} else {
+ 			localcmd("CNLCYCLE\n");
+ 		}
+ 	}
+ 
+ };
+ 
+ //--------------------//
+ // Expert CTF Scoring //
+ //--------------------//
+ 
+ /*
+ ==================================
+ PrintCTFScore
+ 
+ Announce the CTF team score: the number of captures
+ each team has made.
+ ==================================
+ */
+ void() PrintCTFScore =
+ {
+ 	local string s;
+ 
+ 	bprint(PRINT_HIGH, "Team Score: Red Team: ");
+ 	s = ftos(team1_captures);
+ 	bprint(PRINT_HIGH, s);
+ 	bprint(PRINT_HIGH, " Blue Team: ");
+ 	s = ftos(team2_captures);
+ 	bprint(PRINT_HIGH, s);
+ 	bprint(PRINT_HIGH, "\n");
+ };
+ 
+ /*
+ ==================================
+ PrintCTFScoreOne
+ 
+ Print the CTF team score for one player.
+ Self must be set to the player.
+ ==================================
+ */
+ void() PrintCTFScoreOne =
+ {
+ 	local string s;
+ 
+ 	sprint(self, PRINT_HIGH, "Team Score: Red Team: ");
+ 	s = ftos(team1_captures);
+ 	sprint(self, PRINT_HIGH, s);
+ 	sprint(self, PRINT_HIGH, " Blue Team: ");
+ 	s = ftos(team2_captures);
+ 	sprint(self, PRINT_HIGH, s);
+ 	sprint(self, PRINT_HIGH, "\n");
+ };
+ 
+ /*
+ ==================================
+ Expert Scoring
+ 
+ Given a killer and killee (attacker and targ), determine if bonus
+ points should be awarded for the kill in the context of CTF.
+ ==================================
+ */
+ void(entity attacker, entity targ) ExpertScoring =
+ {
+ 	local string s;
+ 
+ 	// *XXX* EXPERT CTF variable for 
+ 	// flag/flag carrier defense bonus determination
+ 	local	entity head;
+ 	local float flag_radius;
+ 	local float flag_carrier_radius;
+ 
+ 	// the attacker has already been awarded the one normal
+ 	// frag.. now we determine if he gets any bonuses
+    
+  	if ((targ.player_flag & ITEM_ENEMY_FLAG) &&
+ 		(targ.assignedTeam != attacker.assignedTeam))
+ 	{
+ 		//ZOID: one team fragged the other team's flag carrier
+ 
+ 		// *XXX* EXPERT CTF
+ 		// Mark the attacker with the time at which he killed the flag
+ 		// carrier, for awarding assist points
+ 	
+ 		attacker.last_fragged_carrier = time;
+  
+ 		// *XXX* EXPERT CTF: give player only the normal amount of frags
+ 		// if the carrier has only had the flag for a few seconds, to
+ 		// prevent ppl intentionally allowing enemies to grab the flag,
+ 		// then immediately fragging them
+  		attacker.frags = attacker.frags + TEAM_CAPTURE_FRAG_CARRIER_BONUS;
+ 		bprint(PRINT_MEDIUM, " "); // BONUS
+ 		bprint(PRINT_MEDIUM, attacker.netname);
+ 		bprint(PRINT_MEDIUM, ": CARRIER KILL: ");
+ 		if (targ.flag_since + TEAM_CAPTURE_CARRIER_FLAG_SINCE_TIMEOUT > time) {
+ 			s = ftos(TEAM_CAPTURE_FLAG_DEFENSE_BONUS);
+ 			bprint(PRINT_MEDIUM, s);
+ 			bprint(PRINT_MEDIUM, " FRAG\n");
+ 		} else {
+ 			s = ftos(TEAM_CAPTURE_FRAG_CARRIER_BONUS);
+ 			bprint(PRINT_MEDIUM, s);
+ 			bprint(PRINT_MEDIUM, " FRAGS\n");
+ 		}
+ 		// END FLAG CARRIER FRAG CODE
+ 	}
+  	
+ 	// *XXX* EXPERT CTF
+ 	// This code checks for all game-critical kills OTHER THAN fragging the enemy
+ 	// flag carrier, like killing players who are trying to kill your flag carrier
+ 	// or trying to grab your flag, and hands out bonus frags.
+ 
+ 	// The two variables below track whether special bonus frags have already
+ 	// been awarded for the attacker or target being near the flag or flag carrier.  
+ 
+ 	flag_radius = 0;
+ 	flag_carrier_radius = 0;
+ 
+ 	// get a string for the attacker's team now, for later announcements
+ 	s = GetCTFTeam(attacker.assignedTeam);
+  
+ 	if ((targ.last_hurt_carrier + TEAM_CAPTURE_CARRIER_DANGER_PROTECT_TIMEOUT > time) &&
+ 	    !(attacker.player_flag & ITEM_ENEMY_FLAG) ) 
+ 	{
+ 		// a player on the same team as the flag carrier killed 
+ 		// someone who recently shot the flag carrier
+ 		attacker.frags = attacker.frags + 
+ 			TEAM_CAPTURE_CARRIER_DANGER_PROTECT_BONUS;
+ 		flag_carrier_radius = 1;
+ 		// NOTE: getting CARRIER_DANGER_PROTECT_BONUS precludes getting
+ 		// other kinds of bonuses for defending the flag carrier, since
+ 		// it's worth more points
+ 		bprint(PRINT_MEDIUM, " "); // BONUS
+ 		bprint(PRINT_MEDIUM, attacker.netname);
+ 		bprint(PRINT_MEDIUM, ": ");
+ 		bprint(PRINT_MEDIUM, s);
+ 		bprint(PRINT_MEDIUM, " CARRIER SAVE\n");
+ 	}
+  
+ 	// *XXX* EXPERT CTF
+ 	// Bonusus for defending the flag carrier or the flag itself.
+ 	// Extra frags are awarded if either the attacker or the target are
+ 	// 1. within 40 feet of a flag carrier on the same team as the attacker
+ 	// 2. within 40 feet of the attacker's flag
+ 	// These bonuses are cumulative with respect to defending both the
+ 	// flag and the flag carrier at the same time, but not cumulative with
+ 	// respect to both the target and attacker being near the object being defended
+ 	// find flags or flag carriers within a radius of the attacker
+ 	head = findradius(attacker.origin, TEAM_CAPTURE_ATTACKER_PROTECT_RADIUS);
+ 
+ 	while (head) 
+ 	{
+ 		if (head.classname == "player") 
+ 		{
+ 			if ( (head.assignedTeam == attacker.assignedTeam) &&
+ 			     (head.player_flag & ITEM_ENEMY_FLAG) &&
+ 			     (head != attacker) && // self defense
+ 			     (!flag_carrier_radius) ) 
+ 			{ 
+ 				// attacker was near his own flag carrier
+ 				attacker.frags = attacker.frags + 
+ 					TEAM_CAPTURE_CARRIER_PROTECT_BONUS;
+ 				flag_carrier_radius = 1;
+ 				bprint(PRINT_MEDIUM, " "); // BONUS
+ 				bprint(PRINT_MEDIUM, attacker.netname);
+ 				bprint(PRINT_MEDIUM, ": ");
+ 				bprint(PRINT_MEDIUM, s);
+ 				bprint(PRINT_MEDIUM, " CARRIER DEFENSE\n");
+  			}
+  		}
+  		if ( (head.classname == "item_flag_team1") ||
+ 			(head.classname == "item_flag_team2")) 
+ 		{
+  			if (((attacker.assignedTeam == TEAM_COLOR1) &&
+ 				(head.classname == "item_flag_team1")) ||
+  				((attacker.assignedTeam == TEAM_COLOR2) &&
+  				(head.classname == "item_flag_team2"))) 
+ 			{ 
+ 				// attacker was near his own flag
+  				attacker.frags = attacker.frags + 
+  					TEAM_CAPTURE_FLAG_DEFENSE_BONUS;
+  				flag_radius = 1; 
+ 				bprint(PRINT_MEDIUM, " "); // BONUS
+ 				bprint(PRINT_MEDIUM, attacker.netname);
+ 				bprint(PRINT_MEDIUM, ": ");
+ 				bprint(PRINT_MEDIUM, s);
+ 				bprint(PRINT_MEDIUM, " FLAG DEFENSE\n");
+  			}
+  		}
+  		head = head.chain;
+ 	} 		
+ 	
+ 	// find flags or flag carriers within a radius from the target
+ 	head = findradius(targ.origin, TEAM_CAPTURE_TARGET_PROTECT_RADIUS);
+ 	while (head) 
+ 	{
+ 		if (head.classname == "player") 
+ 		{
+ 			if ( (head.assignedTeam == attacker.assignedTeam) &&
+ 				(head.player_flag & ITEM_ENEMY_FLAG) &&
+  				(head != attacker) &&
+  				(!flag_carrier_radius)) // prevents redundant points awarded
+ 			{
+ 				// target was near attacker's flag carrier
+  				attacker.frags = attacker.frags + 
+  					TEAM_CAPTURE_CARRIER_PROTECT_BONUS;
+  				flag_carrier_radius = 1;
+ 				bprint(PRINT_MEDIUM, " "); // BONUS
+ 				bprint(PRINT_MEDIUM, attacker.netname);
+ 				bprint(PRINT_MEDIUM, ": ");
+ 				bprint(PRINT_MEDIUM, s);
+ 				bprint(PRINT_MEDIUM, " CARRIER DEFENSE\n");
+  			}
+ 		}
+  	 	if ( (head.classname == "item_flag_team1") ||
+ 			(head.classname == "item_flag_team2")) 
+ 		{
+ 			if (((attacker.assignedTeam == TEAM_COLOR1) &&
+ 				(head.classname == "item_flag_team1")) ||
+ 				((attacker.assignedTeam == TEAM_COLOR2) &&
+ 				(head.classname == "item_flag_team2"))
+ 				&& (!flag_radius)) // prevents redundant points awarded
+ 			{ 
+ 				// target was near attacker's flag
+ 				attacker.frags = attacker.frags + 
+ 					TEAM_CAPTURE_FLAG_DEFENSE_BONUS;
+ 				flag_radius = 1;
+ 				bprint(PRINT_MEDIUM, " "); // BONUS
+ 				bprint(PRINT_MEDIUM, attacker.netname);
+ 				bprint(PRINT_MEDIUM, ": ");
+ 				bprint(PRINT_MEDIUM, s);
+ 				bprint(PRINT_MEDIUM, " FLAG DEFENSE\n");
+ 			}
+ 		}
+  		head = head.chain;
+  	}
+  		
+   	// *XXX* EXPERT CTF 
+ 	
+ };
+ 
+ void(entity targ) ResetCarrierHurts =
+ {
+ 	local	entity head;
+ 	// *XXX* EXPERT CTF: 
+ 	// When the flag carrier dies, reset the last_hurt_carrier field in
+ 	// all players on the opposite team from the flag carrier.  The carrier
+ 	// has been killed, so there is no longer a reason to award points for
+ 	// killing off his assailants
+ 	// Expert CTF
+ 	// When the carrier dies, reset any escorts.  They will become escorts
+ 	// again immediately if they start covering a new flag carrier
+ 	if (targ.player_flag & ITEM_ENEMY_FLAG) 
+ 	{
+ 		head = find(world, classname, "player");
+ 
+ 		while (head != world) 
+ 		{	
+ 			if (head.assignedTeam != targ.assignedTeam)	// other team
+ 				head.last_hurt_carrier = -10;
+ 			else {							// same team
+ 				head.escortSince = 0;
+ 				head.lastEscort = 0;
+ 			}
+ 			head = find(head, classname, "player");
+ 		}
+ 	}
+ 	// END EXPERT CTF
+ 
+ };
+ 
+ /*
+ ==================================
+ CheckEscort
+ 
+ Check for possible escorts around flag carrier.
+ ==================================
+ */
+ void(entity carrier) CheckEscort =
+ {
+ 	local entity head;
+ 
+ 	// the carrier's lastEscort field is used to
+ 	// control escort checking frequency
+ 	if (carrier.lastEscort > time)
+ 		return;
+ 
+ 	carrier.lastEscort = time + 0.3;	
+ 
+ 	// find players within a radius from the carrier
+ 	head = findradius(carrier.origin, TEAM_CAPTURE_ESCORT_RADIUS);
+ 
+ 	// mark any players on the same team as escorts
+ 	while (head != world) {
+ 		if ((head.classname == "player") &&
+ 			(head != carrier) && 
+ 			(head.assignedTeam == carrier.assignedTeam))
+ 		{
+ 			if (!head.escortSince) {
+ 				// possible new escort
+ 				// only allow new escorts for a limited amount of time, roughly 
+ 				// the amount of time it would take to get back to base
+ 				if (carrier.flag_since + TEAM_CAPTURE_ESCORT_ELIGIBILITY_TIME > time) {
+ 					head.escortSince = time;
+ 					head.lastEscort = time;
+ 					//bprint(PRINT_HIGH, head.netname);
+ 					//bprint(PRINT_HIGH, " is a new carrier escort\n");
+ 				}// else {
+ 					//bprint(PRINT_HIGH, head.netname);
+ 					//bprint(PRINT_HIGH, " is ineligible\n");
+ 				//}
+ 			} else {
+ 				//bprint(PRINT_HIGH, head.netname);
+ 				//bprint(PRINT_HIGH, " is a continuing carrier escort\n");
+ 				// refresh existing escort's timer
+ 				head.lastEscort = time;
+ 			}
+ 		}
+ 		head = head.chain;
+ 	}
+ 
+ 	// expire escorts who have left carrier
+ 	head = find(world, classname, "player");
+ 	while (head != world) {
+ 		if ((head.lastEscort) && (head != carrier) &&
+ 			(head.assignedTeam == carrier.assignedTeam) &&
+ 			(head.lastEscort + TEAM_CAPTURE_ESCORT_TIMEOUT < time)) 
+ 		{
+ 			head.escortSince = 0;
+ 			head.lastEscort = 0;
+ 			//bprint(PRINT_HIGH, head.netname);
+ 			//bprint(PRINT_HIGH, " is no longer a carrier escort\n");
+ 		}
+ 		head = find(head, classname, "player");
+ 	}
+ 
+ };
+ 
+ /*
+ ==================================
+ AwardEscort
+ 
+ Check for possible escort bonus.  "escort" must be a
+ player on the same team as the carrier
+ ==================================
+ */
+ void(entity escort) AwardEscort =
+ {
+ 	local float escortedFor, bonus;
+ 
+ 	if (escort.lastEscort) {
+ 		// found a valid escort
+ 		escortedFor = time - escort.escortSince;
+ 		if (escortedFor > TEAM_CAPTURE_MINIMUM_ESCORT_TIME) {
+ 			bonus = escortedFor * TEAM_CAPTURE_ESCORT_CARRIER_ASSIST_BONUS;
+ 			bonus = rint(bonus);
+ 			if (bonus > TEAM_CAPTURE_MAX_ESCORT_BONUS)
+ 			bonus = TEAM_CAPTURE_MAX_ESCORT_BONUS;
+ 			bprint(PRINT_MEDIUM, " "); // ASSIST
+ 			bprint(PRINT_HIGH, escort.netname);
+ 			bprint(PRINT_MEDIUM, ": CARRIER ESCORT\n");
+ 			self.frags = self.frags + bonus;
+ 		}
+ 		escort.lastEscort = 0;
+ 		escort.escortSince = 0;
+ 	}
+ };
+ 
+ /*
+ 	From byron@caseware.com Wed Oct 16 18:57:44 1996
+ 	Date: Wed, 16 Oct 1996 21:22:37 -0400
+ 	From: Byron Long <byron@caseware.com>
+ 	To: zoid@mindlink.net
+ 	Subject: Team Status Command (source code included) :-)
+ 
+ 	A co-worker of mine wondered if it was possible to add a function to
+ 	your capture the flag code that would give a status report on an
+ 	impulse. I think he may have mailed you, but I wrote a quick version
+ 	myself, which your welcome to use if you like the feature (it offsets
+ 	some of the problems with the chat capabilities in Quake so it seems
+ 	like a worthwhile feature). Feel free to change it
+ 	as necessary.
+ */
+ 
+ // *Capture The Flag - Status report by Wonko
+ // Expert CTF - altered messages for quicker reading
+ void() TeamFlagStatusReport =
+ {
+ 	local entity flag1, flag2, p;
+ 
+ 	if (!(ctf)) {
+ 		sprint(self, PRINT_HIGH, "Capture the Flag is not enabled.\n");
+ 		return;
+ 	}
+ 
+ 	// Expert CTF
+ 	// Print the team score as part of status
+ 	PrintCTFScoreOne();
+ 
+ 	// Find the flags at home base
+ 	flag1 = find (world,classname, "item_flag_team1");
+ 	flag2 = find (world,classname, "item_flag_team2");
+ 
+ 	// If on team 2 switch meanings of flags
+ 	if (self.assignedTeam != TEAM_COLOR1) {
+ 		p = flag1;
+ 		flag1 = flag2;
+ 		flag2 = p;
+ 	}
+ 
+ 	sprint(self, PRINT_HIGH, "Your flag is ");
+ 	if (flag1 != world && flag1.cnt == FLAG_CARRIED) {
+ 		sprint(self, PRINT_HIGH, "carried by ");
+ 		sprint(self, PRINT_HIGH, flag1.owner.netname);
+ 		sprint(self, PRINT_HIGH, "\n");
+ 	} else {
+ 		if (flag1 == world)
+ 			sprint(self, PRINT_HIGH, "missing!\n");
+ 		if (flag1.cnt == FLAG_AT_BASE)
+ 			sprint(self, PRINT_HIGH, "at base.\n");
+ 		else if (flag1.cnt == FLAG_DROPPED)
+ 			sprint(self, PRINT_HIGH, "in the open.\n");
+ 		else
+ 			sprint(self, PRINT_HIGH, "corrupt.\n");
+ 	}
+ 
+ 	sprint(self, PRINT_HIGH, "The enemy flag is ");
+ 	if (flag2 != world && flag2.cnt == FLAG_CARRIED) {
+ 		sprint(self, PRINT_HIGH, "carried by ");
+ 		sprint(self, PRINT_HIGH, flag2.owner.netname);
+ 		sprint(self, PRINT_HIGH, "\n");
+ 	} else {
+ 		if (flag2 == world)
+ 			sprint(self, PRINT_HIGH, "missing!\n");
+ 		if (flag2.cnt == FLAG_AT_BASE)
+ 			sprint(self, PRINT_HIGH, "at base.\n");
+ 		else if (flag2.cnt == FLAG_DROPPED)
+ 			sprint(self, PRINT_HIGH, "in the open.\n");
+ 		else
+ 			sprint(self, PRINT_HIGH, "corrupt.\n");
+ 	}
+ };
+ 
+ //---------------------//
+ // CTF Flag Management //
+ //---------------------//
+ 
+ void(string audiofile) GlobalAudio =
+ {
+ 	local entity audioto;
+ 
+ 	audioto = find(world, classname, "player");
+ 
+ 	while (audioto != world) 
+ 	{	
+ 		stuffcmd(audioto, "play ");
+ 		stuffcmd(audioto, audiofile);
+ 		stuffcmd(audioto, "\n");
+ 		audioto = find(audioto, classname, "player");
+ 	}
+ 
+ };
+ 
+ void(entity flg) RegenFlag =
+ {
+ 	flg.movetype = MOVETYPE_TOSS;
+ 	flg.solid = SOLID_TRIGGER;
+ 	setmodel(flg, flg.mdl);
+ 	setorigin(flg, flg.oldorigin);
+ 	flg.angles = flg.mangle;
+ 	flg.cnt = FLAG_AT_BASE; // it's at home base
+ 	flg.owner = world;
+ 	flg.velocity = '0 0 0';
+ 	sound (flg, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);	// play respawn sound
+ };
+ 
+ void(entity flg) TeamCaptureReturnFlag =
+ {
+ 	local entity p;
+ 
+ 	RegenFlag(flg);
+ 
+ // Expert CTF
+ // No need to centerprint this, the info is in the statusbar
+ // and there is a sound.
+ 	p = find(world, classname, "player");
+ 	while (p != world) {
+ 		if (p.assignedTeam != flg.assignedTeam)
+ 		{
+ 			sprint(p, PRINT_HIGH, " ENEMY FLAG HAS BEEN \n");
+ 			sprint(p, PRINT_HIGH, "  RETURNED TO BASE!  \n");
+ 		} else if (p.assignedTeam == flg.assignedTeam)
+ 		{
+ 			sprint(p, PRINT_HIGH, " YOUR FLAG HAS BEEN \n");
+ 			sprint(p, PRINT_HIGH, "  RETURNED TO BASE! \n");
+ 		}
+ 		p = find(p, classname, "player");
+ 	}
+ 
+ };
+ 
+ void () TeamCaptureRegenFlags =
+ {
+ 	local entity f;
+ 
+ 	f = find(world, classname, "item_flag_team1");
+ 	if (f != world)
+ 		RegenFlag(f);
+ 	f = find(world, classname, "item_flag_team2");
+ 	if (f != world)
+ 		RegenFlag(f);
+ };
+ 
+ void(entity flg) TeamDropFlag =
+ {
+ 	local entity item, f, oself;
+ 	local entity p;
+ 
+ 	p = flg.owner;
+ 
+ 	bprint(PRINT_HIGH, p.netname);
+ 	if (p.assignedTeam == TEAM_COLOR1)
+ 		bprint(PRINT_HIGH, "  the  flag!\n"); // blue
+ 	else
+ 		bprint(PRINT_HIGH, "  the  flag!\n"); // red
+ 	p.effects = p.effects - (p.effects & (EF_FLAG1 | EF_FLAG2));
+ 
+ 	flg.origin = p.origin - '0 0 24';
+ 	flg.cnt = FLAG_DROPPED;
+ 	flg.velocity_z = 300;
+ 	flg.velocity_x = 0;
+ 	flg.velocity_y = 0;
+ 	flg.flags = FL_ITEM;
+ 	flg.solid = SOLID_TRIGGER;
+ 	flg.movetype = MOVETYPE_TOSS;
+ 	setmodel(flg, flg.mdl);
+ 	setsize(self, '-16 -16 0', '16 16 74');
+ 	// return it after so long
+ 	flg.super_time = time + TEAM_CAPTURE_FLAG_RETURN_TIME;
+ };
+ 
+ void(entity player) TeamCaptureDropFlagOfPlayer =
+ {
+ 	local string kn;
+ 	local entity e;
+ 
+ 	if (!(player.player_flag & ITEM_ENEMY_FLAG))
+ 		return;
+ 	if (player.assignedTeam == TEAM_COLOR1) 
+ 		kn = "item_flag_team2";
+ 	else
+ 		kn = "item_flag_team1";
+ 	player.player_flag = player.player_flag - ITEM_ENEMY_FLAG;
+ 	e = find(world, classname, kn);
+ 	if (e != world)
+ 		TeamDropFlag(e);
+ };
+ 
+ void() TeamCaptureFlagTouch =
+ {
+ 	local entity p, oself, holder;
+ 	local string s;
+ 
+ 	if (other.classname != "player")
+ 		return;
+ 	if (other.health <= 0)
+ 		return;
+ 
+ 	if (self.assignedTeam == other.assignedTeam) {
+ 		// same team, if the flag is *not* at the base, return
+ 		// it to base.  we overload the 'cnt' field for this
+ 		if (self.cnt == FLAG_AT_BASE) {
+ 			// the flag is at home base.  if the player has the enemy
+ 			// flag, he's just won!
+ 
+ 			if (other.player_flag & ITEM_ENEMY_FLAG) {
+ 				bprint(PRINT_HIGH, other.netname);
+ 				if (other.assignedTeam == TEAM_COLOR1) {
+ 					bprint(PRINT_HIGH, "  the  flag!\n"); // blue
+ 					team1_captures = team1_captures + 1;
+ 				} else {
+ 					bprint(PRINT_HIGH, "  the  flag!\n"); // red
+ 					team2_captures = team2_captures + 1;
+ 				}
+ 				other.items = other.items - (other.items & (IT_KEY1 | IT_KEY2));
+ 
+ 				// Expert Bugfix
+ 				// Someone altered ATTN_NONE so that death sounds wouldn't
+ 				// be player for 32 players, but we actually need it here
+ 				GlobalAudio("misc/flagcap.wav");
+ //				sound (other, CHAN_VOICE, "misc/flagcap.wav", 1, ATTN_NONE);
+ 
+ 				// Expert CTF
+ 				// Print the team score after a capture
+ 				PrintCTFScore();
+ 
+ 				// other gets another 10 frag bonus
+ 				other.frags = other.frags + TEAM_CAPTURE_CAPTURE_BONUS;
+ 
+ 				// Expert CTF
+ 				// turn off escort checking for the flag carrier
+ 				other.lastEscort = 0;				
+ 
+ 				// Ok, let's do the player loop, hand out the bonuses
+ 				holder = self;
+ 				p = find(world, classname, "player");
+ 				while (p != world) {
+ 					self = p;
+ 					if (self.assignedTeam == other.assignedTeam && self != other)
+ 						self.frags = self.frags + TEAM_CAPTURE_TEAM_BONUS;
+ 					if (self.assignedTeam != other.assignedTeam) {
+ 						// *XXX* EXPERT CTF
+ 						// reset the last_hurt_carrier variable in all enemy players, so that you don't get
+ 						// bonuses for defending the flag carrier if the flag carrier has already
+ 						// completed a capture
+ 						self.last_hurt_carrier = -5;
+ 					} else if ((self.assignedTeam == other.assignedTeam) && (self != other)) {
+ 						// done to all players on the capturing team EXCEPT the carrier
+ 						// *XXX* EXPERT CTF
+ 						// award extra points for capture assists
+ 						s = GetCTFTeam(self.assignedTeam);
+ 						if (self.last_returned_flag + TEAM_CAPTURE_RETURN_FLAG_ASSIST_TIMEOUT > time) {
+ 							bprint(PRINT_MEDIUM, " "); // ASSIST
+ 							bprint(PRINT_HIGH, self.netname);
+ 							bprint(PRINT_MEDIUM, ": FLAG RETURN\n");
+ 							self.frags = self.frags + TEAM_CAPTURE_RETURN_FLAG_ASSIST_BONUS;
+ 						}
+ 						if (self.last_fragged_carrier + TEAM_CAPTURE_FRAG_CARRIER_ASSIST_TIMEOUT > time) {
+ 							bprint(PRINT_MEDIUM, " "); // ASSIST
+ 							bprint(PRINT_HIGH, self.netname);
+ 							bprint(PRINT_MEDIUM, ": CARRIER KILL\n");
+ 							self.frags = self.frags + TEAM_CAPTURE_FRAG_CARRIER_ASSIST_BONUS;
+ 						}
+ 						// Expert CTF
+ 						// Check for escort bonuses
+ 						// Bah, escort bonuses suck
+ 						//AwardEscort(self);
+ 					}
+ 					self.player_flag = self.player_flag - (self.player_flag & ITEM_ENEMY_FLAG);
+ 					
+ 					p = find(p, classname, "player");
+ 				}
+ 				self = holder;
+ 
+ 
+ 				p = find(world, classname, "player");
+ 				while (p != world) {
+ 					// Expert CTF
+ 					// No need to centerprint this, the info is in the statusbar
+ 					// and there is a sound.
+ 					if ((p.assignedTeam == TEAM_COLOR1 && other.assignedTeam == TEAM_COLOR2) ||
+ 						(p.assignedTeam == TEAM_COLOR2 && other.assignedTeam == TEAM_COLOR1))
+ 					{
+ 						sprint(p, PRINT_HIGH, " YOUR FLAG WAS \n");
+ 						sprint(p, PRINT_HIGH, "   CAPTURED!   \n");
+ 					} else if (p.assignedTeam == other.assignedTeam)
+ 					{
+ 						sprint(p, PRINT_HIGH, "     YOUR TEAM      \n");
+ 						sprint(p, PRINT_HIGH, " CAPTURED THE FLAG! \n");
+ 					}
+ 			
+ 					// remove any flags
+ 					p.effects = p.effects - (p.effects & (EF_FLAG1 | EF_FLAG2));
+ 					p = find(p, classname, "player");
+ 				}
+ 				
+ 				// respawn flags
+ 				TeamCaptureRegenFlags();
+ 				return;
+ 			}
+ 			return; // its at home base already
+ 		}	
+ 		// hey, its not home.  return it by teleporting it back
+ 		bprint(PRINT_HIGH, other.netname);
+ 		if (other.assignedTeam == TEAM_COLOR1)
+ 			bprint(PRINT_HIGH, "  the  flag!\n"); // red
+ 		else
+ 			bprint(PRINT_HIGH, "  the  flag!\n"); // blue
+ 		other.frags = other.frags + TEAM_CAPTURE_RECOVERY_BONUS;
+ 		// *XXX* EXPERT CTF set time when player last returned his flag
+ 		other.last_returned_flag = time;
+ 		// Expert Bugfix
+ 		// Someone altered ATTN_NONE so that death sounds wouldn't
+ 		// be player for 32 players, but we actually need it here
+ 		GlobalAudio(self.noise1);
+ //		sound (other, CHAN_ITEM, self.noise1, 1, ATTN_NORM);
+ 		TeamCaptureReturnFlag(self);
+ 		return;
+ 	}
+ 
+ 	// hey, its not our flag, pick it up
+ 	bprint(PRINT_HIGH, other.netname);
+ 	if (other.assignedTeam == TEAM_COLOR1)
+ 		bprint(PRINT_HIGH, "  the  flag!\n"); // blue
+ 	else
+ 		bprint(PRINT_HIGH, "  the  flag!\n"); // red
+ 	if (TEAM_CAPTURE_FLAG_BONUS)
+ 		other.frags = other.frags + TEAM_CAPTURE_FLAG_BONUS;
+ 
+ 	// Expert CTF
+ 	// Just sprint this.  This is a bad time to have text in your face.
+ 	sprint(other, PRINT_HIGH, "      \n");
+ 	sprint(other, PRINT_HIGH, "            \n");
+ 	// Expert Bugfix
+ 	// Someone altered ATTN_NONE so that death sounds wouldn't
+ 	// be player for 32 players, but we actually need it here
+ 	GlobalAudio(self.noise);
+ //	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
+ 
+ 	other.player_flag = other.player_flag + ITEM_ENEMY_FLAG;
+ 	other.items = other.items | self.items;
+ 
+ 	// *XXX* EXPERT CTF set the time at which the carrier picked up the flag
+ 	other.flag_since = time;
+ 	// Expert CTF begin checking for escorts immediately
+ 	other.lastEscort = time + 0.1;
+ 
+ 	// pick up the flag
+ 	self.cnt = FLAG_CARRIED;
+ 	self.solid = SOLID_NOT;
+ 	self.owner = other;
+ 	if (self.assignedTeam == TEAM_COLOR1)
+ 		self.owner.effects = self.owner.effects | EF_FLAG1;
+ 	else // must be other team
+ 		self.owner.effects = self.owner.effects | EF_FLAG2;
+ 	setmodel(self, "");
+ 
+ 	// Expert CTF
+ 	// No need to centerprint this, the info is in the statusbar
+ 	// and there is a sound.
+ 	p = find(world, classname, "player");
+ 	while (p != world) {
+ 		if (p != other) {
+ 			if (p.assignedTeam != other.assignedTeam)
+ 			{
+ 				sprint(p, PRINT_HIGH, "   YOUR FLAG     \n");
+ 				sprint(p, PRINT_HIGH, " HAS BEEN TAKEN! \n");
+ 			} else if (p.assignedTeam == other.assignedTeam)
+ 			{
+ 				sprint(p, PRINT_HIGH, "      YOUR TEAM      \n");
+ 				sprint(p, PRINT_HIGH, " HAS THE ENEMY FLAG! \n");
+ 			}
+ 		}
+ 		p = find(p, classname, "player");
+ 	}
+ 
+ };
+ 
+ void() TeamCaptureFlagThink =
+ {
+ 	local entity e;
+ 	local vector v;
+ 	local float f;
+ 	local string s;
+ 
+ 	self.nextthink = time + 0.1;
+ 
+ 	// Expert CTF
+ 	// Flags make periodic flapping noise instead of glowing
+ 	// Overload air_finished on the flag to hold the next time
+ 	// to play the sound
+ 	if (self.air_finished < time) {
+ 		if ((self.cnt == FLAG_AT_BASE) || (self.cnt == FLAG_DROPPED)) {
+ 			sound(self, CHAN_AUTO, "expert/flagwave.wav", 1, ATTN_IDLE);
+ 		} else if (self.cnt == FLAG_CARRIED) {
+ 			sound(self.owner, CHAN_AUTO, "expert/flagwave.wav", 1, ATTN_IDLE);
+ 		}
+ 		self.air_finished = time + 3.2;
+ 	}
+ 
+ 	if (self.cnt == FLAG_AT_BASE)
+ 		return; // just sitting around waiting to be picked up
+ 
+ 	if (self.cnt == FLAG_DROPPED) {
+ 		if (time - self.super_time > TEAM_CAPTURE_FLAG_RETURN_TIME)
+ 			TeamCaptureReturnFlag(self);
+ 		return;
+ 	}
+ 
+ 	if (self.cnt != FLAG_CARRIED)
+ 		objerror("Flag in invalid state\n");
+ };
+ 
+ //--------------//
+ // CTF Entities //
+ //--------------//
+ 
+ $cd id1/models/flag
+ $base base
+ $skin skin
+ 
+ void() place_flag = 
+ {
+ 	self.mdl = self.model;		// so it can be restored on respawn
+ 	self.flags = FL_ITEM;		// make extra wide
+ 	self.solid = SOLID_TRIGGER;
+ 	self.movetype = MOVETYPE_TOSS;	
+ 	self.velocity = '0 0 0';
+ 	self.origin_z = self.origin_z + 6;
+ 	self.think = TeamCaptureFlagThink;
+ 	self.touch = TeamCaptureFlagTouch;
+ 	self.nextthink = time + 0.1;
+ 	self.cnt = FLAG_AT_BASE;
+ 	self.mangle = self.angles;
+ // Expert CTF
+ // Glow kills framerate
+ //	self.effects = self.effects | EF_DIMLIGHT;
+ 	if (!droptofloor()) {
+ 		dprint ("Flag fell out of level at ");
+ 		dprint (vtos(self.origin));
+ 		dprint ("\n");
+ 		remove(self);
+ 		return;
+ 	}
+ 	self.oldorigin = self.origin; // save for flag return
+ };
+ 
+ void() item_flag_team1 =
+ {
+ 	local string s;
+ 
+ 	s = infokey(world, "ctf");
+ 	ctf = stof(s);
+ 
+ 	if (!deathmatch || !ctf) {
+ 		remove(self);
+ 		return;
+ 	}
+ 
+ 	self.assignedTeam = TEAM_COLOR1;
+ 	self.items = IT_KEY2;
+ 	precache_model ("progs/flag.mdl");
+ 	setmodel (self, "progs/flag.mdl");
+ 	self.skin = 0;
+ 	precache_sound ("misc/flagtk.wav");			// flag taken
+ 	precache_sound ("misc/flagcap.wav");		// flag capture
+ 	precache_sound ("doors/runetry.wav");
+ 	precache_sound("expert/flagwave.wav");
+ 	self.noise = "misc/flagtk.wav";
+ 	self.noise1 = "doors/runetry.wav";
+ 	setsize(self, '-16 -16 0', '16 16 74');
+ 	self.nextthink = time + 0.2;	// items start after other solids
+ 	self.think = place_flag;
+ };
+ 
+ void() item_flag_team2 =
+ {
+ 	local string s;
+ 
+ 	s = infokey(world, "ctf");
+ 	ctf = stof(s);
+ 
+ 	if (!deathmatch || !ctf) {
+ 		remove(self);
+ 		return;
+ 	}
+ 
+ 	self.assignedTeam = TEAM_COLOR2;
+ 	self.items = IT_KEY1;
+ 	precache_model ("progs/flag.mdl");
+ 	setmodel (self, "progs/flag.mdl");
+ 	self.skin = 1;
+ 	precache_sound ("misc/flagtk.wav");			// flag taken
+ 	precache_sound ("misc/flagcap.wav");			// flag capture
+ 	precache_sound ("doors/runetry.wav");
+ 	precache_sound("expert/flagwave.wav");
+ 	self.noise = "misc/flagtk.wav";
+ 	self.noise1 = "doors/runetry.wav";
+ 	setsize(self, '-16 -16 0', '16 16 74');
+ 	self.nextthink = time + 0.2;	// items start after other solids
+ 	self.think = place_flag;
+ };
+ 
+ // Team base starting locations
+ void() info_player_team1 =
+ {
+ };
+ 
+ void() info_player_team2 =
+ {
+ };
+ 
+ /*QUAKED func_ctf_wall (0 .5 .8) ?
+ This is just a solid wall if not inhibitted
+ Only appears in CTF teamplay
+ */
+ void() func_ctf_wall =
+ {
+ 	local string s;
+ 
+ 	s = infokey(world, "ctf");
+ 	ctf = stof(s);
+ 
+ 	if (ctf) {
+ 		self.angles = '0 0 0';
+ 		self.movetype = MOVETYPE_PUSH;	// so it doesn't get pushed by anything
+ 		self.solid = SOLID_BSP;
+ 		setmodel (self, self.model);
+ 	} else
+ 		remove(self);
+ };
\ No newline at end of file
diff -crbB --unidirectional-new-file qw201/defs.qc expert12/defs.qc
*** qw201/defs.qc	Wed Jul 30 23:15:52 1997
--- expert12/defs.qc	Thu Aug 14 20:47:10 1997
***************
*** 490,496 ****
  //
  // player only fields
  //
! .float          voided;
  .float          walkframe;
  
  // Zoid Additions
--- 486,519 ----
  //
  // player only fields
  //
! 
! // *TEAMPLAY*
! 
! // Team and color setting
! 
! .float          assignedTeam;       // The last team this player was a member of.
! .float          lastcolorset;		// last time the player's color was set
! .float          lastteamset;		// last time the player's "team" string was set
! .float          lastskinset;		// last time the player's skin was set
! .float          connecttime;		// the time at which the player connected to the server
! 
! // Friendly fire detection
! 
! .entity         shooting;		// the player that this player most recently shot
! .float          numshots;		// the number of times in a row shooting the same player
! .float          firstshot;		// the time of the first shot on the player
! 
! // *XXX* EXPERT CTF ALTERNATE SCORING
! 
! // time values
! 
! .float 		flag_since; 		// how long a player has had the flag
! .float		last_returned_flag; 	// last time player returned his own flag
! .float		last_fragged_carrier; 	// last time player fragged a flag carrier
! .float		last_hurt_carrier; 	// last time player hurt the flag carrier
! 
! // *XXX* end 
! 
  .float          walkframe;
  
  // Zoid Additions
***************
*** 523,528 ****
--- 544,559 ----
  .float          air_finished;   // when time > air_finished, start drowning
  .float          bubble_count;   // keeps track of the number of bubbles
  .string         deathtype;              // keeps track of how the player died
+ // CTF
+ .float          player_flag;	// misc flags (skins, etc.)
+ 
+ // CTF Status
+ .float 	    statustime;		// EXPERT CTF 
+ 
+ // Expert
+ .float          ToBeFwded;		// Expert DM Indicates forwarding status
+ .float          weaponmode;		// What mode a weapon is in, used both for players firing
+ 						// and marking projectiles
  
  //
  // object stuff
***************
*** 684,689 ****
--- 715,726 ----
  void(string var, string val) cvar_set = #72;    // sets cvar.value
  
  void(entity client, string s) centerprint = #73;        // sprint, but in middle
+ void(entity client, string s, string s1) centerprint2 = #73;	// sprint, but in middle
+ void(entity client, string s, string s1, string s2) centerprint3 = #73;	// sprint, but in middle
+ void(entity client, string s, string s1, string s2, string s3) centerprint4 = #73;	// sprint, but in middle
+ void(entity client, string s, string s1, string s2, string s3, string s4) centerprint5 = #73;	// sprint, but in middle
+ void(entity client, string s, string s1, string s2, string s3, string s4, string s5) centerprint6 = #73;	// sprint, but in middle
+ void(entity client, string s, string s1, string s2, string s3, string s4, string s5, string s6) centerprint7 = #73;	// sprint, but in middle
  
  void(vector pos, string samp, float vol, float atten) ambientsound = #74;
  
***************
*** 725,728 ****
--- 762,774 ----
  
  float(entity targ, entity inflictor) CanDamage;
  
+ 
+ //
+ // Grapple.qc - Wedge 
+ //
+ .float  on_hook;// TRUE if hook is anchored and client is being pulled
+ .float  hook_out;// TRUE if hook is in use
+ .entity hook;// pointer to client's hook
+ .float lasthookpull; // the last time hook pull was computed
+ .float hangtime;  // drops player that hangs too long (DaScott)
  
diff -crbB --unidirectional-new-file qw201/dm.qc expert12/dm.qc
*** qw201/dm.qc	Thu Jan  1 00:00:00 1970
--- expert12/dm.qc	Fri Aug 15 04:36:34 1997
***************
*** 0 ****
--- 1,507 ----
+ /* deathmatch.qc */
+ 
+ /** Fields **/
+ 
+ .float heal_time;		// last regeneration time under
+ 				// alternate restoration system
+ .float nailnum;		// for skipping nails under DM_PERFORMANCE
+ 
+ .float rules_time;	// next time to check exiting rules
+ 
+ /** Defs **/
+ 
+ /** MODIFIABLE CONSTANTS **/
+ 
+ float DM_AXE_DAMAGE =			80;
+ float DM_BULLET_DAMAGE =		5;
+ float DM_SG_SHOTS =			8;
+ float DM_SSG_SHOTS = 			14;
+ float DM_NAIL_DAMAGE = 			13;
+ float DM_SUPERNAIL_DAMAGE =		15;
+ float DM_ROCKET_DIRECT_DAMAGE =	100;
+ float DM_ROCKET_SPLASH_DAMAGE =	85;
+ float DM_GRENADE_SPLASH_DAMAGE =	75;
+ float DM_LIGHTNING_DAMAGE = 		12;
+ float DM_LIGHTNING_DISCHARGE =	5;
+ 
+ vector DM_SG_SPREAD =			'0.04 0.04 0'; // normal '0.04 0.04 0'
+ vector DM_SSG_SPREAD =			'0.10 0.08 0'; // normal '0.14 0.08 0'
+ float DM_NAIL_AIRSPEED =		1700; // air speed of non-super nails
+ 							// normally both nailguns have 1000
+ 
+ float DM_BULLET_PENETRATION =		0.3;  // percentage to reduce armor
+ float DM_NAIL_PENETRATION =		0.4;  // effectiveness
+ float DM_LIGHTNING_PENETRATION =	0.3;
+ 
+ float DM_SPLASH_FRACTION =		0.8;	// fraction of splash damage the shooter
+ 							// of an explosive takes
+ 
+ float DM_HEAVY_VELOCITY =	3;	// multipliers of velocity for weapon kickback
+ float DM_LIGHT_VELOCITY =	7;
+ 
+ // DAMAGE REFERENCE TABLE
+ // Weapon:			Fire Delay:		Damage per shot:		Max Rate:
+ // ----------------------------------------------------------------------
+ // Axe			0.5			80				160
+ // SingleShotgun		0.5			up to 40			80
+ // SuperShotgun		0.7			up to 70			100
+ // Nailgun			0.1			13				130
+ // SuperNailgun		0.1			15				150
+ // Grenade Launcher	0.6			75 radius			125 radius
+ // Rocket Launcher	0.8			100, 85 radius		125 direct, 106.25 radius
+ // Lightning Gun		0.1			12				120
+ //
+ // Default armor penetration: 0
+ // Default splash damage fraction: 0.5
+ // Default velocity multiplier: 8
+ 
+ float DM_GREEN_ABSORPTION =		0.3;
+ float DM_GREEN_AMOUNT =			190; // total value: 57
+ float DM_YELLOW_ABSORPTION =		0.45;
+ float DM_YELLOW_AMOUNT =		130; // total value: 58.5
+ float DM_RED_ABSORPTION =		0.6;
+ float DM_RED_AMOUNT =			100; // total value: 60
+ 
+ // Glyph of the Lich alternate powerup: max health
+ float DM_LICH_CAP = 			180;
+ 
+ // for alternate health system
+ float DM_KILL_HEALTH =			50;
+ float DM_KILL_ARMOR =			30;
+ float DM_REGEN_AMOUNT =			4;
+ float DM_REGEN_DELAY =			4;
+ 
+ float DM_EXIT_FRAG_MIN =		15;	// minimum frags to leave
+ 
+ /** End of MODIFIABLE CONSTANTS **/
+ 
+ // Globals
+ 
+ // Prototypes
+ float() W_BestWeapon;
+ void() W_SetCurrentAmmo;
+ void() bound_other_ammo;
+ void(float o, float n) Deathmatch_Weapon;
+ void() BackpackTouch;
+ 
+ /*
+ ================
+ DMNextLevel
+ 
+ Custom level cycling for DM and basic teamplay.
+ ================
+ */
+ void() DMNextLevel  =
+ {
+ 	localcmd("DMCYCLE;\n");
+ };
+ 
+ /*
+ ================
+ InitDM
+ 
+ Do initialization for DM mods.
+ ================
+ */
+ void() InitDM =
+ {
+ 	local float i;
+ 
+ 	if (deathmatch & DM_PERFORMANCE) {
+ 		i = 1;
+ 		while (i<12)
+ 		{
+ 			lightstyle(i, "m");
+ 			i = (i + 1);
+ 		}
+ 	}
+ };
+ 
+ /*
+ ================
+ DMShirtColorLock
+ 
+ Check that the player's shirt color matches his armor, and if not
+ stuff a command to the console to set the player's shirt color.
+ ================
+ */
+ void() DMShirtColorLock =
+ {
+ 	local float armorColor;
+ 	local string s;
+ 
+ 	if ((deathmatch & DM_ARMOR_COLOR) && (self.lastcolorset + TEAM_STUFF_DELAY < time)) {
+ 		if (self.items & IT_ARMOR1) {
+ 			armorColor = 11; // green
+ 		} else if (self.items & IT_ARMOR2) {
+ 			armorColor = 12; // yellow
+ 		} else if (self.items & IT_ARMOR3) {
+ 			armorColor = 4; // red
+ 		} else {
+ 			armorColor = 0; // white - no armor
+ 		}
+ 		if (armorColor != TeamShirtColor(self)) {
+ 			s = ftos(armorColor);
+ 			stuffcmd(self, "topcolor ");
+ 			stuffcmd(self, s);
+ 			stuffcmd(self, "\n");
+ 			self.lastcolorset = time;
+ 		}
+ 	}
+ };
+ 
+ void(entity targ, entity attacker) Killed;
+ void() powerup_touch;
+ 
+ /*
+ ============
+ RandomizePowerups
+ 
+ If the respawning item is quad damage, invisibility eyes, or a pentagram,
+ it can respawn randomly as any of the other three powerups.  Odds are
+ 40% quad, 40% invisibility, 20% pentagram.
+ ============
+ */
+ void()  RandomizePowerups = 
+ {
+ 	local string s;
+ 	local float powerup_select;
+ 	local float valid = 0;
+ 
+ 	s = infokey(world, "loadmod");
+ 	loadmod = stof(s);
+ 
+ 	while (!valid)
+ 	{
+ 		// repeatedly try to pick a random powerup until
+ 		// we get a legal one.
+ 		powerup_select = random()*5;
+ 
+ 		if (powerup_select <= 2)
+ 		{
+ 			if (!(loadmod & LM_REMOVE_QUAD)) {
+ 				valid = 1;
+ 				self.classname = "item_artifact_super_damage";
+ 				self.noise = "items/damage.wav";
+ 				setmodel (self, "progs/quaddama.mdl");
+ 				self.netname = "Quad Damage";
+ 				self.items = IT_QUAD;
+ 			} else {
+ 				valid = 0;
+ 			}
+ 		}
+ 		else if (powerup_select <= 4)
+ 		{
+ 			if (!(loadmod & LM_REMOVE_PENTAGRAM)) {
+ 				valid = 1;
+ 				self.classname = "item_artifact_invulnerability";
+ 				self.noise = "items/protect.wav";
+ 				setmodel (self, "progs/invulner.mdl");
+ 				self.netname = "Pentagram of Protection";
+ 				self.items = IT_INVULNERABILITY;
+ 			} else {
+ 				valid = 0;
+ 			}
+ 		}
+ 		else
+ 		{
+ 			if (!(loadmod & LM_REMOVE_RING)) {
+ 				valid = 1;
+ 				self.classname = "item_artifact_invisibility";
+ 				self.noise = "items/inv1.wav";
+ 				setmodel (self, "progs/invisibl.mdl");
+ 				self.netname = "Ring of Shadows";
+ 				self.items = IT_INVISIBILITY;
+ 			} else {
+ 				valid = 0;
+ 			}
+ 		}
+ 	}
+ 
+ 	self.touch = powerup_touch;
+ 	self.solid = SOLID_TRIGGER;     // allow it to be touched again
+ 	sound (self, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);    // play respawn sound
+ 	setorigin (self, self.origin);
+ 
+ };
+ 
+ /*
+ ================
+ DMPowerupSounds
+ 
+ Play periodic sounds for Quad Damage and Pentagram, for easy spotting
+ ================
+ */
+ void() DMPowerupSounds =
+ {
+ 	if ((self.super_damage_finished > time) && 
+ 		(self.super_damage_finished > time + 3)) // don't play during fade-out
+ 	{
+ 		// Be afraid.
+ 		if (self.super_sound < time)
+ 		{
+ 			self.super_sound = time + 3;
+ 			sound (self, CHAN_AUTO, "items/damage.wav", 1, ATTN_NORM);
+ 		}
+ 	} 
+ 	if ((self.invincible_finished >= time) &&
+ 		(self.invincible_finished > time + 3)) // don't play during fade-out
+ 	{
+ 		// Be very afraid...
+ 		if (self.invincible_sound < time)
+ 		{
+ 			sound (self, CHAN_AUTO, "items/protect.wav", 1, ATTN_NORM);
+ 			self.invincible_sound = time + 3;
+ 		}
+ 	}
+ };
+ 
+ /*
+ ================
+ DMPrintSettings
+ 
+ Print out current deathmatch options
+ ================
+ */
+ void() DMPrintSettings =
+ {
+ 	local string s;
+ 	
+ 	sprint(self,PRINT_HIGH,"The following Deathmatch options are set:\n");
+ 	
+ 	if(!deathmatch) 
+ 	{
+ 		sprint(self, PRINT_HIGH, "None\n");
+ 		return;
+ 	}
+ 	
+ 	if(deathmatch & DM_ITEM_RESPAWN)
+ 		sprint(self, PRINT_HIGH, "Items Respawn\n");
+ 	
+ 	if(deathmatch & DM_WEAPON_STAY)
+ 		sprint(self, PRINT_HIGH, "Weapons Stay\n");
+ 
+ 	if(deathmatch & DM_FREE_GEAR)
+ 		sprint(self, PRINT_HIGH, "\"deathmatch 4\" : free gear on spawn\n");
+ 	
+ 	if(deathmatch & DM_ALTERNATE_RESTORE)
+ 		sprint(self, PRINT_HIGH, "Alternate Restoration System\n");
+ 		
+ 	if(deathmatch & DM_BALANCED_WEAPONS)
+ 		sprint(self, PRINT_HIGH, "Balanced Weapons\n");
+ 		
+ 	if(deathmatch & DM_BALANCED_ITEMS)
+ 		sprint(self, PRINT_HIGH, "Balanced Items\n");
+ 
+ 	if(deathmatch & DM_RANDOMIZE_POWERUPS)
+ 		sprint(self, PRINT_HIGH, "Randomized Powerups\n");
+ 
+ 	if(deathmatch & DM_GRAPPLE)
+ 		sprint(self, PRINT_HIGH, "Expert Grappling Hook\n");
+ 
+ 	if(deathmatch & DM_SWING_HOOK)
+ 		sprint(self, PRINT_HIGH, "Swinging Grappling Hook\n");
+ 
+ 	if(deathmatch & DM_REAL_PHYSICS)
+ 		sprint(self, PRINT_HIGH, "Alternate Weapon Modes (hit 9)\n");
+ 
+ 	if(teamplay & DM_FRAG_MIN)
+ 	{
+ 		sprint(self, PRINT_HIGH, "Exit Frag Min (min set to ");
+ 		s = ftos(DM_EXIT_FRAG_MIN);
+ 		sprint(self, PRINT_HIGH, s);
+ 		sprint(self, PRINT_HIGH, ")\n");
+ 
+ 	}
+ 
+ 	if(deathmatch & DM_ARMOR_COLOR)
+ 		sprint(self, PRINT_HIGH, "Shirt Color Indicates Armor Type\n");
+ 
+ 	if(deathmatch & DM_REAL_PHYSICS)
+ 		sprint(self, PRINT_HIGH, "Realistic Weapon Physics\n");
+ };
+ 
+ 
+ /*
+ ================
+ ArmorPenetration
+ 
+ Checks for appropriate weapons and reduces the effectiveness of armor
+ according to DM_NAIL_PENETRATION or DM_BULLET_PENETRATION
+ ================
+ */
+ float(entity targ, entity inflictor, entity attacker, float damage) ArmorPenetration =
+ {
+ 
+ 	local float save;
+ 	local float armor;
+ 
+ 	if (attacker.classname == "player")	
+ 	{
+ 		// airborne weapons check
+ 		if (inflictor.classname == "spike")
+ 		{
+ 			armor = targ.armortype * (1 - DM_NAIL_PENETRATION);
+ 			save = ceil(armor * damage);
+ 			return save;
+ 		}
+ 		else if (inflictor.classname == "w2pulse") 
+ 		{
+ 			armor = targ.armortype * (1 - DM_PULSE_PENETRATION);
+ 			save = ceil(armor * damage);
+ 			return save;		
+ 		}
+ 
+ 		// instant weapons
+ 		if (attacker == inflictor) 
+ 		{
+ 			if ((attacker.weapon == IT_SHOTGUN) || (attacker.weapon == IT_SUPER_SHOTGUN))
+ 			{	
+ 				armor = targ.armortype * (1 - DM_BULLET_PENETRATION);
+ 				save = ceil(armor * damage);
+ 				return save;
+ 			}
+ 			else if (attacker.weapon == IT_LIGHTNING) 
+ 			{
+ 				armor = targ.armortype * (1 - DM_LIGHTNING_PENETRATION);
+ 				save = ceil(armor * damage);
+ 				return save;
+ 			}
+ 		}
+ 	}
+ 
+ 	save = ceil(targ.armortype*damage);
+ 	return save;
+ 
+ };
+ 
+ /*
+ ================
+ ShowExitRules
+ 
+ Prints to console if noexit, a fraglimit, or a timelimit is set.
+ Shows the time remaining formatted as min:sec
+ 
+  shows up as a gold bullet
+ ================
+ */
+ void(entity self) ShowExitRules   =
+ {
+ 
+ 	local float timeleft;
+ 	local float minleft, secleft;
+ 	local string fragstring;
+ 	local string minstring, secstring;
+ 
+ 
+ 	if (cvar("noexit"))
+ 		sprint(self, PRINT_MEDIUM, " Noexit is set  ");
+ 
+ 	if (cvar("fraglimit"))
+ 	{
+ 		fragstring = ftos(cvar("fraglimit"));
+ 		sprint(self, PRINT_MEDIUM, " Fraglimit: ");
+ 		sprint(self, PRINT_MEDIUM, fragstring);
+ 	}
+ 
+ 	if (cvar("noexit") || cvar("fraglimit"))
+ 		sprint(self, PRINT_MEDIUM, "\n");
+                  
+ 	if (cvar("timelimit")) 
+ 	{
+ 		sprint(self, PRINT_MEDIUM, " Time Remaining: ");
+ 
+ 		timeleft = cvar("timelimit") - (time/60);
+ 		minleft = floor(timeleft);
+ 		minstring = ftos(minleft);
+ 
+ 		sprint(self, PRINT_MEDIUM, minstring);
+ 		sprint(self, PRINT_MEDIUM, ":");
+ 
+ 		secleft = rint( (timeleft - minleft) * 60);
+ 		secstring = ftos(secleft);
+ 
+ 		if (secleft < 10)
+ 			sprint(self, PRINT_MEDIUM, "0");
+ 
+ 		sprint(self, PRINT_MEDIUM, secstring);
+ 		sprint(self, PRINT_MEDIUM, "\n");
+ 	}
+ 
+ };
+ 
+ /*
+ ================
+ DMForwardingSetup
+ 
+ Called by ClientConnect(), figures out whether a player
+ should be forwared or not.
+ ================
+ */
+ void() DMForwardingSetup =
+ {
+ 	local entity p;
+ 	local float players, maxPlayers;
+ 	local string s;
+ 
+ 	if (deathmatch & DM_PLAYER_FORWARDING) {
+ 		// determine maximum number of clients
+ 		s = infokey(world, "maxclients");
+ 		maxPlayers = stof(s);
+ 
+ 		// determine current number of clients
+ 		players = 0;
+ 		p = find(world, classname, "player");
+ 
+ 		while (p != world) {
+ 			if (p.ToBeFwded == 0) players = players + 1; // that means this player IS in the game
+ 			p = find(p, classname, "player");
+ 		}
+ 
+ 		// if there is only one slot left (or less than one.. defensive coding)
+ 		// forward the player that is currently connecting
+ 		if (maxPlayers - players <= 1) {
+ 			self.ToBeFwded = -10;	// this player will be forwarded
+ 		} else {
+ 			self.ToBeFwded = 0;	// value indicates player is in the game and won't be forwarded
+ 		}
+ 
+ 		// EXPERT BIG FAT HACK
+ 		// TOTALLY INSECURE FORWARDING OVERRIDE
+ 		//s = infokey(self, "noreally");
+ 		//if (s != "") self.ToBeFwded = 0;
+ 	}
+ 
+ };
+ 
+ /*
+ ================
+ DMForwardingCheck
+ 
+ Called by PlayerPostThink(), forwards players
+ who have been marked for forwarding.
+ ================
+ */
+ void() DMForwardingCheck =
+ {
+ 	local string s;
+ 
+ 	if (self.ToBeFwded < 0) {	
+ 		// player should be forwarded if ToBeFwded < 0 (set in ClientConnect)
+ 		s = infokey(world, "forwardTo");
+ 		if (s != "") {
+ 			stuffcmd(self, "echo Server full..; echo you are being forwarded;");
+ 			self.ToBeFwded = 20;	// so player won't be counted in player-counting loop in ClientConnect
+ 			stuffcmd(self, "disconnect; connect ");
+ 			stuffcmd(self, s);
+ 			stuffcmd(self, ";\n");
+ 			dprint("Player ");
+ 			dprint(self.netname);
+ 			dprint(" forwarded to ");
+ 			dprint(s);
+ 			dprint("\n");
+ 		} else {
+ 			dprint("Extra player not forwarded.. server key \"forwardTo\" not set\n");
+ 		}
+ 	}
+ };
\ No newline at end of file
diff -crbB --unidirectional-new-file qw201/doors.qc expert12/doors.qc
*** qw201/doors.qc	Tue Aug 12 14:18:34 1997
--- expert12/doors.qc	Wed Aug 13 20:25:46 1997
***************
*** 208,214 ****
  
  	if (self.owner.message != "")
  	{
! 		centerprint (other, self.owner.message);
  		sound (other, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);
  	}
  	
--- 207,217 ----
  
  	if (self.owner.message != "")
  	{
! 		// Expert
! 		// Avoid centerprints
! 		sprint(other, PRINT_MEDIUM, self.owner.message);
! 		sprint(other, PRINT_MEDIUM, "\n");
! 		//centerprint (other, self.owner.message);
  		sound (other, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);
  	}
  	
***************
*** 702,708 ****
  	
  	if (self.message)
  	{
! 		centerprint (other, self.message);
  		sound (other, CHAN_BODY, "misc/talk.wav", 1, ATTN_NORM);
  	}
  };
--- 705,715 ----
  	
  	if (self.message)
  	{
! 		// Expert
! 		// Avoid centerprints
! 		sprint (other, PRINT_MEDIUM, self.message);
! 		sprint (other, PRINT_MEDIUM, "\n");
! 		//centerprint (other, self.message);
  		sound (other, CHAN_BODY, "misc/talk.wav", 1, ATTN_NORM);
  	}
  };
diff -crbB --unidirectional-new-file qw201/expdefs.qc expert12/expdefs.qc
*** qw201/expdefs.qc	Thu Jan  1 00:00:00 1970
--- expert12/expdefs.qc	Sat Aug 16 06:36:14 1997
***************
*** 0 ****
--- 1,110 ----
+ // Deathmatch bitfield entries
+ 
+ float DM_ITEM_RESPAWN =		1;		// Items respawn (powerups always respawn)
+ float DM_WEAPON_STAY =		2;		// Weapons stay after being picked up
+ float DM_FREE_GEAR = 		4;		// Free gear on spawn, other behaviors
+ float DM_ALTERNATE_RESTORE =	8;		// Alternate health/armor system
+ float DM_BALANCED_WEAPONS =	16;		// Weapons are roughly equally effective (see below)
+ float DM_BALANCED_ITEMS =	32;		// Armors even, other small changes (see below)
+ float DM_GRAPPLE =		64;		// Enable Expert Grappling Hook
+ float DM_RANDOMIZE_POWERUPS =	128;		// Powerups have random chance of switching
+ float DM_ALTERNATE_POWERUPS =	256;		// Use alternate powerups, see below
+ float DM_LEVEL_SET =		512;		// A hand picked set of id levels is used.. see below
+ float DM_FRAG_MIN =		1024;		// kill players who try to leave with too few frags
+ float DM_ARMOR_COLOR =		2048;		// Players shirt color will match the armor they are wearing
+ float DM_SWING_HOOK =		4096; 	// Use Expert Swinging Hook
+ float DM_WEAPON_MODES =		8192;		// Alternate modes for weapons
+ float DM_PERFORMANCE =		16384;	// Changes to improve client rendering performance
+ float DM_PLAYER_FORWARDING =	32768;	// Forward players when server is full.. see below
+ float DM_REAL_PHYSICS =		65536;	// Use more realistic physics on weapons, etc
+ float DM_ALTERNATES_ONLY =	131072;	// Use _only_ alternate weapon modes
+ 
+ // NOT IMPLEMENTED YET
+ float DM_DEATH_CAM =		0;	// Switch to deathcam view on death
+ 
+ // DM_BALANCED_WEAPONS includes: (see constants below)
+ // o Modified weapon damages
+ // o Armor penetration for nails, buckshot and lightning
+ // o 50 Green armor given out on spawn
+ // o Super Nail Gun takes one nail per shot
+ // o Normal Nail Gun has faster air speed
+ // o Less resistance to splash damage from one's own explosions
+ // o Less kickback on heavy weapons fire, but still full rocket jump height
+ // o Reduced lightning gun discharge damage
+ 
+ // DM_BALANCED_ITEMS includes:
+ // o Equalized armors: amount inversely proportional to absorption
+ // o Armor of dead opponents is put in backpacks
+ // o SuperShotgun given out on spawn
+ // o Faster MegaHealth rot
+ // o Quad and Pentagram give off periodic sounds
+ 
+ // DM_ALTERNATE_POWERUPS are:
+ // o Quad becomes the Glyph of the Lich: you take back as health 1/2 of the health damage
+ // you do to other players.
+ // o Pentagram becomes the Fiend Glide: ability to jump like a fiend
+ // o Ring becomes the Ring of Will: weapon hits don't push you around
+ 
+ // DM_PERFORMANCE
+ // Flickering lights are changed to constant lights of medium brightness on-the-fly.
+ // No muzzleflash for nail and lightning gun.
+ // FIXME: want no glow for rockets
+ 
+ // DM_PLAYER_FORWARDING
+ // Set "maxclients" one higher than the actual number of players you want in the game.
+ // When the last client connects, he will be forwarded to the IP specified in serverinfo
+ // under the key "forwardTo" (caps count).  If no key is set, forwarding will not happen.
+ 
+ // Teamplay bitfield entries
+ 
+ float TEAM_HEALTH_PROTECT =	1;	// No health damage from friendly fire
+ float TEAM_ARMOR_PROTECT =	2;	// No armor damage from friendly fire
+ float TEAM_ATTACKER_DAMAGE =	4;	// Attacker takes damage from hitting teammates
+ float TEAM_FRAG_PENALTY =	8;	// One frag penalty for killing teammate
+ float TEAM_DEATH_PENALTY =	16;	// Die when you kill a teammate.
+ float TEAM_LOCK_COLORS =	32;	// Allow only defined team colors
+ float TEAM_STATIC_TEAMS =	64;	// Don't allow players to switch teams.  
+ 						// Overrides TEAM_FAIR_TEAMS
+ float TEAM_FAIR_TEAMS =		128;	// Allow only team changes to a team with less
+ 						// members than the player's current team
+ float TEAM_ENFORCE_SHIRT =	256;	// Enforce that player's shirt color must
+ 						// match pants
+ float TEAM_DROP_ITEMS = 	512;	// Allow players to drop packs and 
+ 						// weapons.
+ float TEAM_BOOT_NEGS =		1024;	// Boot players that have less than 
+ 						// TEAM_FRAG_FLOOR frags.
+ float TEAM_FF_NOTICE =		2048; // inform players if they repeatedly shoot a teammate
+ float TEAM_SCORING =		4096; // total frags for each team will be printed periodically
+ float TEAM_AUDIO =		8192; // enable basic Team Audio system (status.qc)
+ 
+ // CTF bitvector
+ 
+ float           ctf;
+ 
+ // CTF bitfield entries
+ 
+ float ENABLE_CTF =		1;	// Play capture the flag
+ 
+ // Loadmod bitvector
+ 
+ float           loadmod;
+ 
+ // Loadmod bitfield entries
+ 
+ // set "serverinfo loadmod" to a number which is the sum of the options you want to
+ // enable from the list below.  For example:
+ // serverinfo loadmod 9
+ // Would cause pentagrams to be removed from the level, and quotas for items to be
+ // fulfilled.
+ 
+ float LM_QUOTA_ADD =			1;	// add health and armor where necessary to fulfill quotas
+ float LM_QUOTA_REMOVE =			2;	// remove health and armor where necessary to trim to quotas [NOT IMPLEMENTED]
+ float LM_REDO_ITEMS = 			4;	// redo the placement of all items on the level [NOT IMPLEMENTED]
+ float LM_REMOVE_PENTAGRAM = 		8;	// remove all pentagrams of protection
+ float LM_REMOVE_RING =			16;	// remove all rings of invisibility
+ float LM_REMOVE_QUAD =			32;	// remove all quad damage powerups
+ float LM_REMOVE_BASE_SPAWNS =		64;	// remove deathmatch spawns near CTF flags
+ 
+ // Other globals
+ 
+ float cvartime;	// periodically check cvars instead of every frame
\ No newline at end of file
diff -crbB --unidirectional-new-file qw201/files.dat expert12/files.dat
*** qw201/files.dat	Tue Aug 12 15:31:56 1997
--- expert12/files.dat	Sun Aug 17 01:51:02 1997
***************
*** 1,21 ****
! 140
! 1 items/r_item1.wav
! 1 items/r_item2.wav
! 1 items/health1.wav
  1 misc/medkey.wav
  1 misc/runekey.wav
  2 misc/basekey.wav
- 1 items/protect.wav
- 1 items/protect2.wav
- 1 items/protect3.wav
  1 items/suit.wav
  1 items/suit2.wav
- 1 items/inv1.wav
- 1 items/inv2.wav
- 1 items/inv3.wav
  1 items/damage.wav
  1 items/damage2.wav
  1 items/damage3.wav
  1 weapons/r_exp3.wav
  1 weapons/rocket1i.wav
  1 weapons/sgun1.wav
--- 1,22 ----
! 159
! 1 misc/flagtk.wav
! 1 misc/flagcap.wav
! 1 doors/runetry.wav
! 1 expert/flagwave.wav
  1 misc/medkey.wav
  1 misc/runekey.wav
  2 misc/basekey.wav
  1 items/suit.wav
  1 items/suit2.wav
  1 items/damage.wav
  1 items/damage2.wav
  1 items/damage3.wav
+ 1 items/inv1.wav
+ 1 items/inv2.wav
+ 1 items/inv3.wav
+ 1 items/protect.wav
+ 1 items/protect2.wav
+ 1 items/protect3.wav
  1 weapons/r_exp3.wav
  1 weapons/rocket1i.wav
  1 weapons/sgun1.wav
***************
*** 28,33 ****
--- 29,39 ----
  1 weapons/grenade.wav
  1 weapons/bounce.wav
  1 weapons/shotgn2.wav
+ 1 weapons/chain1.wav
+ 1 weapons/chain2.wav
+ 1 weapons/chain3.wav
+ 1 weapons/bounce2.wav
+ 1 blob/land1.wav
  1 misc/menu1.wav
  1 misc/menu2.wav
  1 misc/menu3.wav
***************
*** 84,92 ****
  1 player/lburn2.wav
  1 misc/water1.wav
  1 misc/water2.wav
  1 doors/medtry.wav
  1 doors/meduse.wav
- 1 doors/runetry.wav
  1 doors/runeuse.wav
  1 doors/basetry.wav
  1 doors/baseuse.wav
--- 90,113 ----
  1 player/lburn2.wav
  1 misc/water1.wav
  1 misc/water2.wav
+ 1 items/r_item1.wav
+ 1 items/r_item2.wav
+ 1 items/health1.wav
+ 1 enforcer/enfstop.wav
+ 1 enforcer/enfire.wav
+ 1 zombie/z_hit.wav
+ 1 zombie/z_miss.wav
+ 1 speech/tlgath_a.wav
+ 1 speech/tlattk_a.wav
+ 1 speech/tlincm_a.wav
+ 1 speech/tlcovr_b.wav
+ 1 speech/tgattack.wav
+ 1 speech/tgdown.wav
+ 1 speech/tgclear.wav
+ 1 speech/tgstatus.wav
+ 1 demon/djump.wav
  1 doors/medtry.wav
  1 doors/meduse.wav
  1 doors/runeuse.wav
  1 doors/basetry.wav
  1 doors/baseuse.wav
***************
*** 122,129 ****
  1 ambience/fl_hum1.wav
  1 ambience/buzz1.wav
  1 ambience/fire1.wav
- 2 enforcer/enfire.wav
- 2 enforcer/enfstop.wav
  1 ambience/suck1.wav
  1 ambience/drone6.wav
  1 ambience/drip1.wav
--- 143,148 ----
***************
*** 139,163 ****
  2 enforcer/pain2.wav
  2 enforcer/death1.wav
  2 enforcer/idle1.wav
! 65
! 1 maps/b_bh10.bsp
! 1 maps/b_bh100.bsp
! 1 maps/b_bh25.bsp
! 1 progs/armor.mdl
! 1 progs/g_shot.mdl
! 1 progs/g_nail.mdl
! 1 progs/g_nail2.mdl
! 1 progs/g_rock.mdl
! 1 progs/g_rock2.mdl
! 1 progs/g_light.mdl
! 1 maps/b_shell1.bsp
! 1 maps/b_shell0.bsp
  1 maps/b_nail1.bsp
  1 maps/b_nail0.bsp
  1 maps/b_rock1.bsp
  1 maps/b_rock0.bsp
  1 maps/b_batt1.bsp
  1 maps/b_batt0.bsp
  1 progs/w_s_key.mdl
  1 progs/m_s_key.mdl
  2 progs/b_s_key.mdl
--- 158,173 ----
  2 enforcer/pain2.wav
  2 enforcer/death1.wav
  2 enforcer/idle1.wav
! 69
! 1 progs/flag.mdl
  1 maps/b_nail1.bsp
  1 maps/b_nail0.bsp
  1 maps/b_rock1.bsp
  1 maps/b_rock0.bsp
  1 maps/b_batt1.bsp
  1 maps/b_batt0.bsp
+ 1 maps/b_shell1.bsp
+ 1 maps/b_shell0.bsp
  1 progs/w_s_key.mdl
  1 progs/m_s_key.mdl
  2 progs/b_s_key.mdl
***************
*** 168,177 ****
  2 progs/end2.mdl
  2 progs/end3.mdl
  2 progs/end4.mdl
- 1 progs/invulner.mdl
  1 progs/suit.mdl
- 1 progs/invisibl.mdl
  1 progs/quaddama.mdl
  1 progs/player.mdl
  1 progs/eyes.mdl
  1 progs/h_player.mdl
--- 178,187 ----
  2 progs/end2.mdl
  2 progs/end3.mdl
  2 progs/end4.mdl
  1 progs/suit.mdl
  1 progs/quaddama.mdl
+ 1 progs/invisibl.mdl
+ 1 progs/invulner.mdl
  1 progs/player.mdl
  1 progs/eyes.mdl
  1 progs/h_player.mdl
***************
*** 187,192 ****
--- 197,204 ----
  1 progs/v_shot2.mdl
  1 progs/v_nail2.mdl
  1 progs/v_rock2.mdl
+ 1 progs/bit.mdl
+ 1 progs/star.mdl
  1 progs/bolt.mdl
  1 progs/bolt2.mdl
  1 progs/bolt3.mdl
***************
*** 198,210 ****
  1 progs/backpack.mdl
  1 progs/zom_gib.mdl
  1 progs/v_light.mdl
  2 progs/teleport.mdl
  1 progs/s_light.spr
  1 progs/flame.mdl
  1 progs/flame2.mdl
  1 maps/b_explob.bsp
  2 maps/b_exbox2.bsp
- 2 progs/laser.mdl
  104
  1 progs.dat
  1 gfx.wad
--- 210,233 ----
  1 progs/backpack.mdl
  1 progs/zom_gib.mdl
  1 progs/v_light.mdl
+ 1 progs/armor.mdl
+ 1 maps/b_bh10.bsp
+ 1 maps/b_bh100.bsp
+ 1 maps/b_bh25.bsp
+ 1 progs/g_shot.mdl
+ 1 progs/g_nail.mdl
+ 1 progs/g_nail2.mdl
+ 1 progs/g_rock.mdl
+ 1 progs/g_rock2.mdl
+ 1 progs/g_light.mdl
+ 1 progs/laser.mdl
+ 1 progs/throwaxe.mdl
  2 progs/teleport.mdl
  1 progs/s_light.spr
  1 progs/flame.mdl
  1 progs/flame2.mdl
  1 maps/b_explob.bsp
  2 maps/b_exbox2.bsp
  104
  1 progs.dat
  1 gfx.wad
diff -crbB --unidirectional-new-file qw201/grapple.qc expert12/grapple.qc
*** qw201/grapple.qc	Thu Jan  1 00:00:00 1970
--- expert12/grapple.qc	Sat Aug 16 01:28:48 1997
***************
*** 0 ****
--- 1,355 ----
+ /*
+ ===========================================================================
+ grapple.qc 12/29/96
+ 
+ Expert Hook / Swing Hook by Charles "Myrkul" Kendrick, based on
+ 
+ Quakeworld-friendly grapple hook code by Wedge (Steve Bond)
+            visit Quake Command http://www.nuc.net/quake 
+ 
+ 
+ Original 'Morning Star' (Grapple Hook) by "Mike" <amichael@asu.alasu.edu> 
+ I took care to preserve the speed and damage values of the original
+ Morning Star. Depending on latency, performance should be near exact.
+ ===========================================================================
+ */
+ 
+ // internal to this file: flag indicating if there is a chain out
+ .float chain_out;
+ 
+ // prototypes for WEAPONS.QC functions
+ float() crandom;
+ void(vector org, float damage) SpawnBlood;
+ 
+ //
+ // Remove_Chain - Removes all chain link entities; checks self.owner
+ //                (the spiked ball) too see if two links exist.
+ //
+ void () Remove_Chain =
+ {
+ 	self.think = SUB_Remove;
+ 	self.nextthink = time;
+ 
+ 	// Check if second link has been created
+ 	if (self.owner.chain_out == 2)
+ 	{
+ 		self.goalentity.think = SUB_Remove;
+ 		self.goalentity.nextthink = time;
+ 	}          
+        
+ 	self.owner.chain_out = 0;
+          
+ };
+ 
+ //
+ // Reset_Grapple - Removes the hook and resets its owner's state.
+ //                 expects a pointer to the hook user.
+ //
+ void (entity hookUser) Reset_Grapple =
+ {
+ 	if (hookUser.hook_out) {
+ 		sound (hookUser, CHAN_NO_PHS_ADD+CHAN_WEAPON, "weapons/bounce2.wav", 1, ATTN_NORM);
+ 		hookUser.on_hook = FALSE;
+ 		hookUser.hook_out = FALSE;
+ 		hookUser.hook.voided = 1;
+ 		// Set up to remove chain here, if it exists
+ 		if (hookUser.hook.chain_out) {
+ 			hookUser.hook.goalentity.think = Remove_Chain;
+ 			hookUser.hook.goalentity.nextthink = time;
+ 		}
+ 		hookUser.hook.think = SUB_Remove;
+ 		hookUser.hook.nextthink = time;
+ 	}
+ };
+ 
+ //
+ // Grapple_Track - Constantly updates the hook's position relative to
+ //                 what it's hooked to. Inflicts damage if attached to
+ //                 a player that is not on the same team as the hook's
+ //                 owner.
+ //
+ void () Grapple_Track =
+ {
+ 	local   vector  spray;
+ 
+ 	// this velocity copying is for doors and 
+ 	// func_trains and such only, not players
+ 	self.velocity = self.enemy.velocity;
+ 
+ 	// Hook doesn't track players, so don't
+ 	// do need to do this often
+ 	self.nextthink = time + 0.3;
+ };
+ 
+ //
+ // MakeLink - spawns a chain link entity
+ //
+ entity (float head) MakeLink =
+ {
+         newmis = spawn ();
+ 
+         newmis.movetype = MOVETYPE_FLYMISSILE;
+         newmis.solid = SOLID_NOT;
+         newmis.owner = self;// SELF is the hook!
+ 
+         newmis.avelocity = '200 200 200';
+ 
+         setmodel (newmis, "progs/bit.mdl");
+         setorigin (newmis, self.origin);
+         setsize (newmis, '0 0 0' , '0 0 0');
+ 
+         return  newmis;
+ };
+ 
+ //
+ // Update_Chain - Repositions the chain links each frame. This single function
+ //                maintains the positions of all of the links. Only one link
+ //                ever thinks.
+ //
+ void () Update_Chain =
+ {
+ 	local   vector  temp;
+ 
+ 	// vector from hook to player
+ 	temp = (self.owner.origin - self.owner.owner.origin);
+ 
+ 	// Check if second link has been created
+ 	if (self.owner.chain_out == 2)
+ 	{
+ 		// These numbers are correct assuming 2 links.
+ 		// 3 links would be 0.25 0.5 0.75
+ 		setorigin (self, self.owner.owner.origin + temp * 0.33);
+ 		setorigin (self.goalentity, self.owner.owner.origin + temp * 0.67);
+ 	} else {
+ 		// only one link exists
+ 		setorigin (self, self.owner.owner.origin + temp * 0.5);
+ 	}
+ 
+ 	// don't update every frame.  only LPBs could 
+ 	// see the diff, and it's pure cosmetics
+ 	self.nextthink = time + 0.3;
+ };
+ 
+ //
+ // Build_Chain - Builds the chain (linked list).  This is the think function
+ //               for the spiked ball until it hits a wall.
+ //
+ void () Build_Chain =
+ {
+ 	// flag on the spiked ball: number of links created
+ 	if (self.chain_out == 0) {
+ 		self.goalentity = MakeLink();
+ 
+ 		// first link will update all links
+ 		self.goalentity.think = Update_Chain;
+ 		self.goalentity.nextthink = time + 0.1;
+ 
+ 		// create a second link in 0.3 seconds
+ 		// often the hook will hit before the second
+ 		// link is created.
+ 		self.nextthink = time + 0.3;
+ 		self.chain_out = 1;
+ 	} else if (self.chain_out == 1) {
+ 		self.goalentity.goalentity = MakeLink();
+ 		self.chain_out = 2;
+ 	}
+ };
+ 
+ //
+ // Anchor_Grapple - Tries to anchor the grapple to whatever it touches
+ //
+ void () Anchor_Grapple =
+ {
+ 	local   float   test;
+ 
+ 	if (other == self.owner)
+ 		return;
+ 
+ 	// Hooks can double-touch in QW, like rockets and other
+ 	// projectiles.  Check if hook has already been removed,
+ 	// or has already hit something.
+ 	if (!self.owner.hook_out || self.voided)
+ 		return;
+ 	self.voided = 1;
+ 
+         // DO NOT allow the grapple to hook to any projectiles, no matter WHAT!
+         // if you create new types of projectiles, make sure you use one of the
+         // classnames below or write code to exclude your new classname so
+         // grapples will not stick to them.
+         if (other.classname == "missile" || other.classname == "grenade" || 
+ 			other.classname == "spike" || other.classname == "rocket" ||
+ 			other.classname == "hook")
+ 			return;
+ 
+         // Don't stick the the sky.
+   /*      if (pointcontents(self.origin) == CONTENT_SKY)
+         {
+                 Reset_Grapple (self.owner);
+                 return;
+         }
+ */
+         if (other.classname == "player")
+         {
+                 // don't latch on.  just whack the player and release
+                 sound (self, CHAN_NO_PHS_ADD+CHAN_WEAPON, "player/axhit1.wav", 1, ATTN_NORM);
+                 other.deathtype = "hook";
+                 T_Damage (other, self, self.owner, 10);
+                 SpawnBlood (other.origin, 10);
+                 Reset_Grapple(self.owner);
+                 return;
+         }
+         else if (other.classname != "player")
+         {
+                 sound (self, CHAN_NO_PHS_ADD+CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
+ 
+                 // One point of damage inflicted upon
+                 // impact, to trigger things
+                 if (other.takedamage)
+                         T_Damage (other, self, self.owner, 1);
+ 	
+                 self.velocity = '0 0 0';
+                 self.avelocity = '0 0 0';
+ 
+                 // Sets how long a hook remains anchored in the wall (DaScott)
+                 self.owner.hangtime = time + 3.5;
+         }
+ 
+         // conveniently clears the sound channel of the CHAIN1 sound,
+         // which is a looping sample and would continue to play. Tink1 is
+         // the least offensive choice, ass NULL.WAV loops and clogs the
+         // channel with silence
+         sound (self.owner, CHAN_NO_PHS_ADD+CHAN_WEAPON, "weapons/tink1.wav", 1, ATTN_NORM);
+ 
+         // indicate being pulled.  PlayerPostThink checks this in order
+         // to call Service_Grapple()
+         self.owner.on_hook = TRUE;
+ 
+         if (self.owner.flags & FL_ONGROUND)
+         {
+                 self.owner.flags = self.owner.flags - FL_ONGROUND;
+         }
+ 
+         sound (self.owner, CHAN_WEAPON, "weapons/chain2.wav", 1, ATTN_NORM);
+ 
+         // CHAIN2 is a looping sample. Use LEFTY as a flag so that client.qc
+         // will know to only play the tink sound ONCE to clear the weapons
+         // sound channel. (Lefty is a leftover from AI.QC, so I reused it to
+         // avoid adding a field)
+         self.owner.lefty = TRUE;
+ 
+ 	// Expert DM (DM_SWING_HOOK)
+ 	if (deathmatch & DM_SWING_HOOK) {
+ 		self.owner.lasthookpull = -1;
+ 		self.owner.velocity_z = self.owner.velocity_z + 100;
+ 	}
+ 
+         self.enemy = other;// remember this guy!
+         self.velocity = self.enemy.velocity;
+         self.think = Grapple_Track;
+         self.nextthink = time = 0.3;
+         self.solid = SOLID_NOT;
+         self.touch = SUB_Null;
+ };
+ 
+ 
+ //
+ // Throw_Grapple - called from WEAPONS.QC, 'fires' the grapple
+ // Note that this doesn't do any checking about whether it's
+ // ok to fire a hook out (eg there could be a hook already out),
+ // so make those checks before calling this.
+ //
+ void () Throw_Grapple =
+ {
+         msg_entity = self;
+ 	  WriteByte (MSG_ONE, SVC_SMALLKICK);
+ 
+         // chain out sound (loops)
+         sound (self, CHAN_WEAPON, "weapons/chain1.wav", 1, ATTN_NORM);
+ 
+         newmis = spawn();
+         newmis.movetype = MOVETYPE_FLYMISSILE;
+         newmis.solid = SOLID_BBOX;
+         newmis.chain_out = 0;
+         newmis.owner = self;	// hook keeps track of player
+         self.hook = newmis;	// player keeps track of hook
+         newmis.classname = "hook";
+ 
+         makevectors (self.v_angle);
+         newmis.velocity = v_forward * 1000;
+         newmis.avelocity = '0 0 -500';
+ 
+         newmis.touch = Anchor_Grapple;
+         newmis.think = Build_Chain;
+         newmis.nextthink = time + 0.3;	// separate creation of hook and links by
+ 							// a delay.  this evens out the net traffic
+ 							// and allows us not to create a chain at
+ 							// all on short hooks
+ 
+         setmodel (newmis,"progs/star.mdl");
+         setorigin (newmis, self.origin + v_forward * 16 + '0 0 16');
+         setsize(newmis, '0 0 0' , '0 0 0 ');
+ 
+         self.hook_out = TRUE;
+ 
+         self.hangtime = time + 10000;
+         // Makes sure hangtime is reset when a new hook is fired (DaScott)
+ 
+ };
+ 
+ //
+ // Service_Grapple - called each frame by CLIENT.QC if client is ON_HOOK
+ //
+ void () Service_Grapple =
+ {
+         local   vector  hook_dir;
+ 	// Expert DM (DM_SWING_HOOK)
+ 	local float hookpull, test;
+ 
+ 	// Resets hook if player is hanging for too long (DaScott)
+ 	if (self.hangtime < time)  
+ 		Reset_Grapple(self);
+ 
+       hook_dir = (self.hook.origin - self.origin);
+ 
+ 	// Expert DM (DM_SWING_HOOK)
+ 	// The swinging hook basically accelerates you toward the anchor point.
+ 	if (deathmatch & DM_SWING_HOOK)
+ 	{
+ 		if (self.flags & FL_ONGROUND) {
+ 			// player landed back on ground
+ 			self.velocity_z = self.velocity_z + 100;
+ 			self.flags = self.flags - (self.flags & FL_ONGROUND);
+ 			// set swing hook for immediate pull
+ 			self.lasthookpull = time - 0.5;
+ 		} else if (vlen(hook_dir) > 50) {
+ 			if ((time - self.lasthookpull) > 0.03) {
+ 				hookpull = 65;
+ 				self.lasthookpull = time;
+ 			} else {
+ 				hookpull = 0;
+ 			}
+ 			self.velocity = self.velocity + (normalize(hook_dir) * hookpull); 
+ 		} else {
+ 			// at close range, behave like a normal hook
+ 			self.velocity = normalize(hook_dir) * 750;
+ 		}
+ 	}
+ 	else
+ 		self.velocity = normalize(hook_dir) * 750;
+ 
+         if ( vlen(hook_dir) <= 200 && self.lefty)	// cancel chain sound
+         {
+                 // If there is a chain, ditch it now. We're
+                 // close enough. Having extra entities lying around
+                 // is never a good idea.
+                 if (self.hook.chain_out) { 
+                         self.hook.goalentity.think = Remove_Chain;
+                         self.hook.goalentity.nextthink = time;
+                 }
+ 
+                 sound(self, CHAN_WEAPON, "weapons/chain3.wav", 1, ATTN_NORM);
+                 self.lefty = FALSE;// we've reset the sound channel.
+         }
+ };
+ 
+ 
diff -crbB --unidirectional-new-file qw201/ident.qc expert12/ident.qc
*** qw201/ident.qc	Thu Jan  1 00:00:00 1970
--- expert12/ident.qc	Thu Aug 14 19:20:48 1997
***************
*** 0 ****
--- 1,68 ----
+ // Identify the player you are pointed towards
+ // By Suck (Nat Friedman)
+ // This code falls under the GNU public license, and cannot be 
+ // redistributed without my name attached.
+ 
+ // hacked by Zoid for CTF4
+ // rehacked by TheGriffin for Expert CTF
+ //   (mostly generalizing things)
+ 
+ // This is called with the player who wants to know whose in front
+ // of him as "me."  I call it with an impulse in weapons.qc 
+ 
+ string(entity me) identify_player =
+ {
+ 	// e is a temp entity; guy is our current best guess
+ 	// as to at whom the player is pointing
+ 	local entity e, guy;
+ 
+ 	// The best "closeness" heuristic so far.
+ 	local float closeness = 50;
+ 
+ 	// Temp vars.
+ 	local vector diff, point;
+ 	local float currclose;
+ 	local string s1;
+ 	
+ 
+ 	// Walk the list of players...
+ 	e=find(world, classname, "player");
+ 	while (e!=world)
+ 	{
+ 		traceline(me.origin, e.origin, FALSE, me);
+ 		if (trace_ent == e) {
+ 			// Get a vector pointing from the viewer to the current
+ 			// player under consideration
+ 			diff=e.origin - me.origin;
+ 
+ 			// Normalize it since we only care where he's pointing,
+ 			// not how far away the guy is.
+ 			diff=normalize(diff);
+ 
+ 			// Expert bugfix
+ 			// anyone heard of different coordinate systems??
+ 			makevectors(me.v_angle);
+ 
+ 			// Find the different between the current player's angle
+ 			// and the viewer's vision angle
+ 			diff=diff - v_forward;
+ 
+ 			// The length is going to be our definition of closeness
+ 			currclose=vlen(diff);
+ 			if (currclose < closeness) {
+ 				closeness = currclose;
+ 				guy = e;
+ 			}
+ 		}
+ 
+ 		e=find(e, classname, "player");
+ 	}
+ 
+ 	// Now we display.
+ 	if ((guy == world) || (closeness > 0.5))
+ 		return "";
+ 	else
+ 		return guy.netname;
+ 
+ };	 
+ 
diff -crbB --unidirectional-new-file qw201/items.qc expert12/items.qc
*** qw201/items.qc	Tue Aug 12 14:21:46 1997
--- expert12/items.qc	Sat Aug 16 21:22:22 1997
***************
*** 44,50 ****
  	self.solid = SOLID_NOT;
  	other.items = other.items | IT_QUAD;
  	self.model = string_null;
! 		if (deathmatch == 4)
  		{
  			other.armortype = 0;
  			other.armorvalue = 0 * 0.01;
--- 44,52 ----
  	self.solid = SOLID_NOT;
  	other.items = other.items | IT_QUAD;
  	self.model = string_null;
! 
! 	if (  ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) &&
! 		!(deathmatch & DM_BALANCED_ITEMS) && !(deathmatch & DM_ALTERNATE_POWERUPS)  )
  	{
  		other.armortype = 0;
  		other.armorvalue = 0 * 0.01;
***************
*** 58,64 ****
  	s=ftos(rint(other.super_damage_finished - time));
  
  	bprint (PRINT_LOW, other.netname);
! 	if (deathmatch == 4)
  		bprint (PRINT_LOW, " recovered an OctaPower with ");
  	else 
  		bprint (PRINT_LOW, " recovered a Quad with ");
--- 60,68 ----
  	s=ftos(rint(other.super_damage_finished - time));
  
  	bprint (PRINT_LOW, other.netname);
! 	if (deathmatch & DM_ALTERNATE_POWERUPS)
! 		bprint (PRINT_LOW, " recovered a Glyph with ");
! 	else if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  		bprint (PRINT_LOW, " recovered an OctaPower with ");
  	else
  		bprint (PRINT_LOW, " recovered a Quad with ");	
***************
*** 112,117 ****
--- 118,124 ----
  	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
  	stuffcmd (other, "bf\n");
  	self.solid = SOLID_NOT;
+ 	if (!(deathmatch & DM_ALTERNATE_POWERUPS))
  		other.items = other.items | IT_INVISIBILITY;
  	self.model = string_null;
  
***************
*** 153,158 ****
--- 160,232 ----
  	item.think = SUB_Remove;
  };
  
+ // Expert DM
+ // Corresponding code for dropping Pentagrams, which are not
+ // invulernability with DM_ALTERNATE_POWERUPS set
+ 
+ void() p_touch;
+ 
+ void() p_touch =
+ {
+ local entity    stemp;
+ local float     best;
+ local string 	s;
+ 
+ 	if (other.classname != "player")
+ 		return;
+ 	if (other.health <= 0)
+ 		return;
+ 
+ 	self.mdl = self.model;
+ 
+ 	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+ 	stuffcmd (other, "bf\n");
+ 	self.solid = SOLID_NOT;
+ 	other.items = other.items | IT_INVULNERABILITY;
+ 	self.model = string_null;
+ 
+ // do the apropriate action
+ 	other.super_time = 1;
+ 	other.invincible_finished = self.cnt;
+ 
+ 	s=ftos(rint(other.invincible_finished - time));
+ 
+ 	bprint (PRINT_LOW, other.netname);
+ 	bprint (PRINT_LOW, " recovered a Pentagram with ");
+ 	bprint (PRINT_LOW, s);
+ 	bprint (PRINT_LOW, " seconds remaining!\n");
+ 
+ 
+ 
+ 	activator = other;
+ 	SUB_UseTargets();                               // fire all targets / killtargets
+ };
+ 
+ 
+ void(float timeleft) DropPent =
+ {
+ 	local entity    item;
+ 
+ 	item = spawn();
+ 	item.origin = self.origin;
+ 	
+ 	item.velocity_z = 300;
+ 	item.velocity_x = -100 + (random() * 200);
+ 	item.velocity_y = -100 + (random() * 200);
+ 	
+ 	item.flags = FL_ITEM;
+ 	item.solid = SOLID_TRIGGER;
+ 	item.movetype = MOVETYPE_TOSS;
+ 	item.noise = "items/protect.wav";
+ 	setmodel (item, "progs/invulner.mdl");
+ 	setsize (item, '-16 -16 -24', '16 16 32');
+ 	item.cnt = time + timeleft;
+ 	item.touch = p_touch;
+ 	item.nextthink = time + timeleft;    // remove it with the time left on it
+ 	item.think = SUB_Remove;
+ };
+ 
+ 
  /*
  ============
  PlaceItem
***************
*** 179,184 ****
--- 253,271 ----
  		remove(self);
  		return;
  	}
+ 
+ 	// Expert DM
+ 	// If this is a powerup and Randomize Powerups is set,
+ 	// respawn as a random powerup immediately.
+ 	if (  (deathmatch & DM_RANDOMIZE_POWERUPS) && 
+ 		((self.classname == "item_artifact_invulnerability") ||
+ 		 (self.classname == "item_artifact_invisibility") ||
+ 		 (self.classname == "item_artifact_super_damage"))  ) {
+ 		self.mdl = self.model;
+ 		self.model = string_null;
+ 		self.think = RandomizePowerups;
+ 		self.nextthink = time + 0.1;
+ 	}
  };
  
  /*
***************
*** 209,221 ****
  {
  	if (e.health <= 0)
  		return 0;
! 	if ((!ignore) && (e.health >= other.max_health))
  		return 0;
  	healamount = ceil(healamount);
  
  	e.health = e.health + healamount;
! 	if ((!ignore) && (e.health >= other.max_health))
! 		e.health = other.max_health;
  		
  	if (e.health > 250)
  		e.health = 250;
--- 296,308 ----
  {
  	if (e.health <= 0)
  		return 0;
! 	if ((!ignore) && (e.health >= e.max_health))
  		return 0;
  	healamount = ceil(healamount);
  
  	e.health = e.health + healamount;
! 	if ((!ignore) && (e.health >= e.max_health))
! 		e.health = e.max_health;
  		
  	if (e.health > 250)
  		e.health = 250;
***************
*** 238,250 ****
  
  void() item_health =
  {       
  	self.touch = health_touch;
  
  	if (self.spawnflags & H_ROTTEN)
  	{
- 		precache_model("maps/b_bh10.bsp");
- 
- 		precache_sound("items/r_item1.wav");
  		setmodel(self, "maps/b_bh10.bsp");
  		self.noise = "items/r_item1.wav";
  		self.healamount = 15;
--- 325,337 ----
  
  void() item_health =
  {       
+ 	if (deathmatch & DM_ALTERNATE_RESTORE)
+ 		return;
+ 	
  	self.touch = health_touch;
  
  	if (self.spawnflags & H_ROTTEN)
  	{
  		setmodel(self, "maps/b_bh10.bsp");
  		self.noise = "items/r_item1.wav";
  		self.healamount = 15;
***************
*** 253,260 ****
  	else
  	if (self.spawnflags & H_MEGA)
  	{
- 		precache_model("maps/b_bh100.bsp");
- 		precache_sound("items/r_item2.wav");
  		setmodel(self, "maps/b_bh100.bsp");
  		self.noise = "items/r_item2.wav";
  		self.healamount = 100;
--- 340,345 ----
***************
*** 262,269 ****
  	}
  	else
  	{
- 		precache_model("maps/b_bh25.bsp");
- 		precache_sound("items/health1.wav");
  		setmodel(self, "maps/b_bh25.bsp");
  		self.noise = "items/health1.wav";
  		self.healamount = 25;
--- 347,352 ----
***************
*** 279,287 ****
  	local   float amount;
  	local   string  s;
  	
! 	if (deathmatch == 4)
! 		if (other.invincible_time > 0)
  			return;
  
  	if (other.classname != "player")
  		return;
--- 362,373 ----
  	local   float amount;
  	local   string  s;
  
! 	// Expert: "deathmatch 4" rules
! 	if (other.invincible_time > 0) {
! 		if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN) &&
! 			!(deathmatch & DM_ALTERNATE_POWERUPS))
  			return;
+ 	}
  
  	if (other.classname != "player")
  		return;
***************
*** 290,308 ****
--- 376,438 ----
  	{
  		if (other.health >= 250)
  			return;
+ 		// Expert DM_ALTERNATE_POWERUPS
+ 		// 100 health is "Ark of Life": a big health and armor pack
+ 		if (deathmatch & DM_BALANCED_ITEMS) {
+ 			if ((other.armorvalue * other.armortype) < (DM_GREEN_ABSORPTION*DM_GREEN_AMOUNT)) 
+ 			{
+ 				amount = 1; // flag: armor given
+ 				other.items = other.items - (other.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + IT_ARMOR1;
+ 				other.armorvalue = DM_GREEN_AMOUNT;
+ 				other.armortype = DM_GREEN_ABSORPTION;
+ 			}
+ 			if (!amount && !T_Heal(other, self.healamount, 0)) 
+ 			{
+ 				// Expert DM
+ 				// Player doesn't need restoration - tell him that
+ 				// every two secods, controlled by "statustime".
+ 				if (self.statustime < time) 
+ 				{
+ 					s = infokey(other, "nocprint");
+ 					amount = stof(s);
+ 					if (amount) {
+ 						sprint(other, PRINT_MEDIUM, "The Ark cannot restore you further\n");
+ 					} else {
+ 						centerprint(other, "The Ark of Life cannot\n\nrestore you further\n");
+ 						other.statustime = time + 2;
+ 					}
+ 					// mark next print time
+ 					self.statustime = time + 2;
+ 				}
+ 				return;
+ 			} else {
+ 				// Expert: infokey to suppress centerprints
+ 				s = infokey(other, "nocprint");
+ 				amount = stof(s); // flag: nocprint set
+ 				if (amount) {
+ 					sprint(other, PRINT_MEDIUM, "You got the Ark of Life\n");
+ 				} else {
+ 					centerprint(other, "Ark of Life\n\nFull restoration\n");
+ 					other.statustime = time + 2;
+ 				}
+ 			}
+ 		} else {
  			if (!T_Heal(other, self.healamount, 1))
  				return;
  		}
+ 	}
  	else
  	{
  		if (!T_Heal(other, self.healamount, 0))
  			return;
  	}
  	
+ 	if (!(deathmatch & DM_BALANCED_ITEMS)) {
  		sprint(other, PRINT_LOW, "You receive ");
  		s = ftos(self.healamount);
  		sprint(other, PRINT_LOW, s);
  		sprint(other, PRINT_LOW, " health\n");
+ 	}
  	
  // health touch sound
  	sound(other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
***************
*** 313,322 ****
  	self.solid = SOLID_NOT;
  
  	// Megahealth = rot down the player's super health
! 	if (self.healtype == 2)
  	{
  		other.items = other.items | IT_SUPERHEALTH;
! 		if (deathmatch != 4)
  		{
  			self.nextthink = time + 5;
  			self.think = item_megahealth_rot;
--- 443,452 ----
  	self.solid = SOLID_NOT;
  
  	// Megahealth = rot down the player's super health
! 	if ((self.healtype == 2) && !(deathmatch & DM_BALANCED_ITEMS))
  	{
  		other.items = other.items | IT_SUPERHEALTH;
! 		if (! ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) )
  		{
    			self.nextthink = time + 5;
    			self.think = item_megahealth_rot;
***************
*** 325,331 ****
  	}
  	else
  	{
! 		if (deathmatch != 2)            // deathmatch 2 is the silly old rules
  		{
  			self.nextthink = time + 20;
  			self.think = SUB_regen;
--- 455,461 ----
  	}
  	else
  	{
! 		if ((deathmatch & DM_ITEM_RESPAWN) || (deathmatch & DM_FREE_GEAR))
  		{
  			self.nextthink = time + 20;
  			self.think = SUB_regen;
***************
*** 351,357 ****
  // just blindly subtract the flag off
  	other.items = other.items - (other.items & IT_SUPERHEALTH);
  	
! 	if (deathmatch != 2)    // deathmatch 2 is silly old rules
  	{
  		self.nextthink = time + 20;
  		self.think = SUB_regen;
--- 481,487 ----
  // just blindly subtract the flag off
  	other.items = other.items - (other.items & IT_SUPERHEALTH);
  	
! 	if (deathmatch & DM_ITEM_RESPAWN)
  	{
  		self.nextthink = time + 20;
  		self.think = SUB_regen;
***************
*** 377,403 ****
  	if (other.classname != "player")
  		return;
  
! 	if (deathmatch == 4)
! 		if (other.invincible_time > 0)
  			return;
  
  	if (self.classname == "item_armor1")
  	{
  		type = 0.3;
  		value = 100;
  		bit = IT_ARMOR1;
  	}
! 	if (self.classname == "item_armor2")
  	{
  		type = 0.6;
  		value = 150;
  		bit = IT_ARMOR2;
  	}
! 	if (self.classname == "item_armorInv")
  	{
  		type = 0.8;
  		value = 200;
  		bit = IT_ARMOR3;
  	}
  	if (other.armortype*other.armorvalue >= type*value)
  		return;
--- 507,548 ----
  	if (other.classname != "player")
  		return;
  
! 	// Expert: "deathmatch 4" rules
! 	if (other.invincible_time > 0) {
! 		if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN) &&
! 			!(deathmatch & DM_ALTERNATE_POWERUPS))
  			return;
+ 	}
  
  	if (self.classname == "item_armor1")
  	{
  		type = 0.3;
  		value = 100;
  		bit = IT_ARMOR1;
+ 		if (deathmatch & DM_BALANCED_ITEMS) {
+ 			type = DM_GREEN_ABSORPTION;
+ 			value = DM_GREEN_AMOUNT;
  		}
! 	}
! 	else if (self.classname == "item_armor2")
  	{
  		type = 0.6;
  		value = 150;
  		bit = IT_ARMOR2;
+ 		if (deathmatch & DM_BALANCED_ITEMS) {
+ 			type = DM_YELLOW_ABSORPTION;
+ 			value = DM_YELLOW_AMOUNT;
+ 		}
  	}
! 	else if (self.classname == "item_armorInv")
  	{
  		type = 0.8;
  		value = 200;
  		bit = IT_ARMOR3;
+ 		if (deathmatch & DM_BALANCED_ITEMS) {
+ 			type = DM_RED_ABSORPTION;
+ 			value = DM_RED_AMOUNT;
+ 		}
  	}
  	if (other.armortype*other.armorvalue >= type*value)
  		return;
***************
*** 408,414 ****
  
  	self.solid = SOLID_NOT;
  	self.model = string_null;
! 	if (deathmatch != 2)
  		self.nextthink = time + 20;
  	self.think = SUB_regen;
  
--- 553,559 ----
  
  	self.solid = SOLID_NOT;
  	self.model = string_null;
! 	if ((deathmatch & DM_ITEM_RESPAWN) || (deathmatch & DM_FREE_GEAR))
  		self.nextthink = time + 20;
  	self.think = SUB_regen;
  
***************
*** 427,434 ****
  
  void() item_armor1 =
  {
  	self.touch = armor_touch;
- 	precache_model ("progs/armor.mdl");
  	setmodel (self, "progs/armor.mdl");
  	self.skin = 0;
  	setsize (self, '-16 -16 0', '16 16 56');
--- 572,581 ----
  
  void() item_armor1 =
  {
+ 	if (deathmatch & DM_ALTERNATE_RESTORE)
+ 		return;
+ 
  	self.touch = armor_touch;
  	setmodel (self, "progs/armor.mdl");
  	self.skin = 0;
  	setsize (self, '-16 -16 0', '16 16 56');
***************
*** 440,447 ****
  
  void() item_armor2 =
  {
  	self.touch = armor_touch;
- 	precache_model ("progs/armor.mdl");
  	setmodel (self, "progs/armor.mdl");
  	self.skin = 1;
  	setsize (self, '-16 -16 0', '16 16 56');
--- 587,596 ----
  
  void() item_armor2 =
  {
+ 	if (deathmatch & DM_ALTERNATE_RESTORE)
+ 		return;
+ 
  	self.touch = armor_touch;
  	setmodel (self, "progs/armor.mdl");
  	self.skin = 1;
  	setsize (self, '-16 -16 0', '16 16 56');
***************
*** 453,460 ****
  
  void() item_armorInv =
  {
  	self.touch = armor_touch;
- 	precache_model ("progs/armor.mdl");
  	setmodel (self, "progs/armor.mdl");
  	self.skin = 2;
  	setsize (self, '-16 -16 0', '16 16 56');
--- 602,611 ----
  
  void() item_armorInv =
  {
+ 	if (deathmatch & DM_ALTERNATE_RESTORE)
+ 		return;
+ 
  	self.touch = armor_touch;
  	setmodel (self, "progs/armor.mdl");
  	self.skin = 2;
  	setsize (self, '-16 -16 0', '16 16 56');
***************
*** 560,576 ****
  	else
  		w_switch = stof(infokey(other,"w_switch"));
  	
  // if the player was using his best weapon, change up to the new one if better          
  	stemp = self;
  	self = other;
  	best = W_BestWeapon();
  	self = stemp;
  
- 	if (deathmatch == 2 || deathmatch == 3 || deathmatch == 5)
- 		leave = 1;
- 	else
- 		leave = 0;
- 	
  	if (self.classname == "weapon_nailgun")
  	{
  		if (leave && (other.items & IT_NAILGUN) )
--- 711,731 ----
  	else
  		w_switch = stof(infokey(other,"w_switch"));
  	
+ 	if (deathmatch & DM_WEAPON_STAY)
+ 		leave = 1;
+ 	else
+ 		leave = 0;
+ 	
+ 	// Expert optimization
+ 	if (leave && (other.items & self.weapon))
+ 		return;
+ 
  // if the player was using his best weapon, change up to the new one if better          
  	stemp = self;
  	self = other;
  	best = W_BestWeapon();
  	self = stemp;
  
  	if (self.classname == "weapon_nailgun")
  	{
  		if (leave && (other.items & IT_NAILGUN) )
***************
*** 660,674 ****
  	if (leave)
  		return;
  
- 	if (deathmatch!=3 || deathmatch !=5)
- 	{
  	// remove it in single player, or setup for respawning in deathmatch
  		self.model = string_null;
  		self.solid = SOLID_NOT;
! 		if (deathmatch != 2)
  			self.nextthink = time + 30;
  		self.think = SUB_regen;
! 	}
  	activator = other;
  	SUB_UseTargets();                               // fire all targets / killtargets
  };
--- 815,829 ----
  	if (leave)
  		return;
  
  	// remove it in single player, or setup for respawning in deathmatch
  	self.model = string_null;
  	self.solid = SOLID_NOT;
! 	if (deathmatch) 
! 		// if DM_WEAPON_STAY is set, we would already have return from this function,
! 		// so we avoid the bug of having the weapon both be there and respawn
  		self.nextthink = time + 30;
  	self.think = SUB_regen;
! 
  	activator = other;
  	SUB_UseTargets();                               // fire all targets / killtargets
  };
***************
*** 679,694 ****
  
  void() weapon_supershotgun =
  {
! if (deathmatch <= 3)
! {
! 	precache_model ("progs/g_shot.mdl");
! 	setmodel (self, "progs/g_shot.mdl");
  	self.weapon = IT_SUPER_SHOTGUN;
  	self.netname = "Double-barrelled Shotgun";
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
- }
  };
  
  /*QUAKED weapon_nailgun (0 .5 .8) (-16 -16 0) (16 16 32)
--- 834,848 ----
  
  void() weapon_supershotgun =
  {
! 	if (deathmatch & DM_FREE_GEAR)
! 		return;
! 
  	self.weapon = IT_SUPER_SHOTGUN;
  	self.netname = "Double-barrelled Shotgun";
+ 	setmodel (self, "progs/g_shot.mdl");
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
  };
  
  /*QUAKED weapon_nailgun (0 .5 .8) (-16 -16 0) (16 16 32)
***************
*** 696,711 ****
  
  void() weapon_nailgun =
  {
! if (deathmatch <= 3)
! {
! 	precache_model ("progs/g_nail.mdl");
! 	setmodel (self, "progs/g_nail.mdl");
  	self.weapon = IT_NAILGUN;
  	self.netname = "nailgun";
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
- }
  };
  
  /*QUAKED weapon_supernailgun (0 .5 .8) (-16 -16 0) (16 16 32)
--- 850,864 ----
  
  void() weapon_nailgun =
  {
! 	if (deathmatch & DM_FREE_GEAR)
! 		return;
! 
  	self.weapon = IT_NAILGUN;
  	self.netname = "nailgun";
+ 	setmodel (self, "progs/g_nail.mdl");
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
  };
  
  /*QUAKED weapon_supernailgun (0 .5 .8) (-16 -16 0) (16 16 32)
***************
*** 713,728 ****
  
  void() weapon_supernailgun =
  {
! if (deathmatch <= 3)
! {
! 	precache_model ("progs/g_nail2.mdl");
! 	setmodel (self, "progs/g_nail2.mdl");
  	self.weapon = IT_SUPER_NAILGUN;
  	self.netname = "Super Nailgun";
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
- }
  };
  
  /*QUAKED weapon_grenadelauncher (0 .5 .8) (-16 -16 0) (16 16 32)
--- 866,880 ----
  
  void() weapon_supernailgun =
  {
! 	if (deathmatch & DM_FREE_GEAR)
! 		return;
! 
  	self.weapon = IT_SUPER_NAILGUN;
  	self.netname = "Super Nailgun";
+ 	setmodel (self, "progs/g_nail2.mdl");
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
  };
  
  /*QUAKED weapon_grenadelauncher (0 .5 .8) (-16 -16 0) (16 16 32)
***************
*** 730,745 ****
  
  void() weapon_grenadelauncher =
  {
! if (deathmatch <= 3)
! {
! 	precache_model ("progs/g_rock.mdl");
! 	setmodel (self, "progs/g_rock.mdl");
! 	self.weapon = 3;
  	self.netname = "Grenade Launcher";
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
- }
  };
  
  /*QUAKED weapon_rocketlauncher (0 .5 .8) (-16 -16 0) (16 16 32)
--- 882,897 ----
  
  void() weapon_grenadelauncher =
  {
! 	if (deathmatch & DM_FREE_GEAR)
! 		return;
! 
! //	self.weapon = 3;
! 	self.weapon = IT_GRENADE_LAUNCHER;
  	self.netname = "Grenade Launcher";
+ 	setmodel (self, "progs/g_rock.mdl");
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
  };
  
  /*QUAKED weapon_rocketlauncher (0 .5 .8) (-16 -16 0) (16 16 32)
***************
*** 747,762 ****
  
  void() weapon_rocketlauncher =
  {
! if (deathmatch <= 3)
! {
! 	precache_model ("progs/g_rock2.mdl");
! 	setmodel (self, "progs/g_rock2.mdl");
! 	self.weapon = 3;
  	self.netname = "Rocket Launcher";
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
- }
  };
  
  
--- 899,914 ----
  
  void() weapon_rocketlauncher =
  {
! 	if (deathmatch & DM_FREE_GEAR)
! 		return;
! 
! //	self.weapon = 3;
! 	self.weapon = IT_ROCKET_LAUNCHER;
  	self.netname = "Rocket Launcher";
+ 	setmodel (self, "progs/g_rock2.mdl");
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
  };
  
  
***************
*** 765,780 ****
  
  void() weapon_lightning =
  {
! if (deathmatch <= 3)
! {
! 	precache_model ("progs/g_light.mdl");
! 	setmodel (self, "progs/g_light.mdl");
! 	self.weapon = 3;
  	self.netname = "Thunderbolt";
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
- }
  };
  
  
--- 917,932 ----
  
  void() weapon_lightning =
  {
! 	if (deathmatch & DM_FREE_GEAR)
! 		return;
! 
! //	self.weapon = 3;
! 	self.weapon = IT_LIGHTNING;
  	self.netname = "Thunderbolt";
+ 	setmodel (self, "progs/g_light.mdl");
  	self.touch = weapon_touch;
  	setsize (self, '-16 -16 0', '16 16 56');
  	StartItem ();
  };
  
  
***************
*** 864,876 ****
  // remove it in single player, or setup for respawning in deathmatch
  	self.model = string_null;
  	self.solid = SOLID_NOT;
! 	if (deathmatch != 2)
! 		self.nextthink = time + 30;
! 
! // Xian -- If playing in DM 3.0 mode, halve the time ammo respawns        
! 
! 	if (deathmatch == 3 || deathmatch == 5)        
  		self.nextthink = time + 15;
  
  	self.think = SUB_regen;
  
--- 1016,1029 ----
  // remove it in single player, or setup for respawning in deathmatch
  	self.model = string_null;
  	self.solid = SOLID_NOT;
! 	// Expert DM: replicate original behavior.  "deathmatch 3" and 
! 	// "deathmatch 5" have faster respawn, "deathmatch 1" doesn't
! 	if (deathmatch & DM_ITEM_RESPAWN) {
! 		if ((deathmatch & DM_WEAPON_STAY) || (deathmatch & DM_FREE_GEAR))
  			self.nextthink = time + 15;
+ 		else
+ 			self.nextthink = time + 30;
+ 	}
  
  	self.think = SUB_regen;
  
***************
*** 888,909 ****
  
  void() item_shells =
  {
! 	if (deathmatch == 4)
  		return;
  
  	self.touch = ammo_touch;
  
  	if (self.spawnflags & WEAPON_BIG2)
  	{
- 		precache_model ("maps/b_shell1.bsp");
- 		setmodel (self, "maps/b_shell1.bsp");
  		self.aflag = 40;
  	}
  	else
  	{
- 		precache_model ("maps/b_shell0.bsp");
- 		setmodel (self, "maps/b_shell0.bsp");
  		self.aflag = 20;
  	}
  	self.weapon = 1;
  	self.netname = "shells";
--- 1041,1060 ----
  
  void() item_shells =
  {
! 	if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  		return;
  
  	self.touch = ammo_touch;
  
  	if (self.spawnflags & WEAPON_BIG2)
  	{
  		self.aflag = 40;
+ 		setmodel (self, "maps/b_shell1.bsp");
  	}
  	else
  	{
  		self.aflag = 20;
+ 		setmodel (self, "maps/b_shell0.bsp");
  	}
  	self.weapon = 1;
  	self.netname = "shells";
***************
*** 916,922 ****
  
  void() item_spikes =
  {
! 	if (deathmatch == 4)
  		return;
  
  	self.touch = ammo_touch;
--- 1067,1073 ----
  
  void() item_spikes =
  {
! 	if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  		return;
  
  	self.touch = ammo_touch;
***************
*** 945,951 ****
  
  void() item_rockets =
  {
! 	if (deathmatch == 4)
  		return;
  
  	self.touch = ammo_touch;
--- 1095,1101 ----
  
  void() item_rockets =
  {
! 	if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  		return;
  
  	self.touch = ammo_touch;
***************
*** 975,981 ****
  
  void() item_cells =
  {
! 	if (deathmatch == 4)
  		return;
  
  	self.touch = ammo_touch;
--- 1124,1130 ----
  
  void() item_cells =
  {
! 	if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  		return;
  
  	self.touch = ammo_touch;
***************
*** 1222,1228 ****
  	if (other.health <= 0)
  		return;
  
! 	centerprint (other, "You got the rune!");
  
  	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
  	stuffcmd (other, "bf\n");
--- 1370,1379 ----
  	if (other.health <= 0)
  		return;
  
! 	// Expert
! 	// Avoid centerprints
! 	sprint (other, PRINT_MEDIUM, "You got the rune!\n");
! 	//centerprint (other, "You got the rune!");
  
  	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
  	stuffcmd (other, "bf\n");
***************
*** 1289,1303 ****
--- 1440,1461 ----
  {
  local entity    stemp;
  local float             best;
+ // Expert
+ local string 	s;
  
  	if (other.classname != "player")
  		return;
  	if (other.health <= 0)
  		return;
  
+ 	// Expert DM
+ 	// If using alternate powerups, print verbose pickup message later
+ 	if (!(deathmatch & DM_ALTERNATE_POWERUPS))
+ 	{
  		sprint (other, PRINT_LOW, "You got the ");
  		sprint (other,PRINT_LOW,  self.netname);
  		sprint (other,PRINT_LOW, "\n");
+ 	}
  
  	self.mdl = self.model;
  
***************
*** 1307,1317 ****
--- 1465,1490 ----
  	else
  		self.nextthink = time + 60;
  	
+ 	// Expert DM
+ 	// The alternate powerups don't need different respawn times
+ 	if (deathmatch & DM_ALTERNATE_POWERUPS)
+ 		self.nextthink = time + 60;
+ 
+ 	// Expert DM
+ 	// Set regen function to randomizer.
+ 	if ((deathmatch & DM_RANDOMIZE_POWERUPS) && (self.classname != "item_artifact_envirosuit"))
+ 		self.think = RandomizePowerups;
+ 	else
  		self.think = SUB_regen;
  
  	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
  	stuffcmd (other, "bf\n");
  	self.solid = SOLID_NOT;
+ 	// Expert DM
+ 	// Don't set the item for the Ring, since it isn't invisibility, we
+ 	// don't want the client-side effect of the ring (severe pallete shift,
+ 	// no weapon model) 
+ 	if (!(deathmatch & DM_ALTERNATE_POWERUPS && self.items == IT_INVISIBILITY))
  		other.items = other.items | self.items;
  	self.model = string_null;
  
***************
*** 1326,1371 ****
  	{
  		other.invincible_time = 1;
  		other.invincible_finished = time + 30;
  	}
  	
  	if (self.classname == "item_artifact_invisibility")
  	{
  		other.invisible_time = 1;
  		other.invisible_finished = time + 30;
  	}
  
  	if (self.classname == "item_artifact_super_damage")
  	{
! 		if (deathmatch == 4)
! 		{
  			other.armortype = 0;
  			other.armorvalue = 0 * 0.01;
  			other.ammo_cells = 0;
  		}
- 		other.super_time = 1;
- 		other.super_damage_finished = time + 30;
  	}       
  
  	activator = other;
  	SUB_UseTargets();                               // fire all targets / killtargets
  };
  
  
  
  /*QUAKED item_artifact_invulnerability (0 .5 .8) (-16 -16 -24) (16 16 32)
  Player is invulnerable for 30 seconds
  */
  void() item_artifact_invulnerability =
  {
! 	self.touch = powerup_touch;
  
  	precache_model ("progs/invulner.mdl");
  	precache_sound ("items/protect.wav");
  	precache_sound ("items/protect2.wav");
  	precache_sound ("items/protect3.wav");
  	self.noise = "items/protect.wav";
  	setmodel (self, "progs/invulner.mdl");
  	self.netname = "Pentagram of Protection";
  	self.effects = self.effects | EF_RED;
  	self.items = IT_INVULNERABILITY;
  	setsize (self, '-16 -16 -24', '16 16 32');
--- 1499,1601 ----
  	{
  		other.invincible_time = 1;
  		other.invincible_finished = time + 30;
+ 		// Expert DM
+ 		if (deathmatch & DM_ALTERNATE_POWERUPS) {
+ 			// Expert: infokey to suppress centerprints
+ 			s = infokey(other, "nocprint");
+ 			best = stof(s);
+ 			if (best) {
+ 				sprint(other, PRINT_MEDIUM, "You got the Fiend's Pentagram\n");
+ 			} else {
+ 				centerprint(other, "You got the Fiend's Pentagram!\n\nFiend jumping\nEnvironment immunity\n");
+ 				other.statustime = time + 2;
+ 			}
+ 		}
  	}
  	
  	if (self.classname == "item_artifact_invisibility")
  	{
  		other.invisible_time = 1;
  		other.invisible_finished = time + 30;
+ 		// Expert DM
+ 		if (deathmatch & DM_ALTERNATE_POWERUPS) {
+ 			// Expert: infokey to suppress centerprints
+ 			s = infokey(other, "nocprint");
+ 			best = stof(s);
+ 			if (best) {
+ 				sprint(other, PRINT_MEDIUM, "You got the Ring of Will\n");
+ 			} else {
+ 				centerprint(other, "You got the Ring of Will!\n\nWeapons cannot move you\nYour weapons throw opponents\n");
+ 				other.statustime = time + 2;
+ 			}
+ 		}
  	}
  
  	if (self.classname == "item_artifact_super_damage")
  	{
! 		other.super_time = 1;
! 		other.super_damage_finished = time + 30;
! 		// Expert DM
! 		if (deathmatch & DM_ALTERNATE_POWERUPS) {
! 			// Expert: infokey to suppress centerprints
! 			s = infokey(other, "nocprint");
! 			best = stof(s);
! 			if (best) {
! 				sprint(other, PRINT_MEDIUM, "You got the Glyph of the Lich\n");
! 			} else {
! 				centerprint(other, "You got the Glyph of the Lich!\n\nLife stealing\n");
! 				other.statustime = time + 2;
! 			}
! 		// Expert: "deathmatch 4" rules
! 		} else if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) {
  			other.armortype = 0;
  			other.armorvalue = 0 * 0.01;
  			other.ammo_cells = 0;
  		}
  	}       
  
  	activator = other;
  	SUB_UseTargets();                               // fire all targets / killtargets
  };
  
+ /*
+ 
+ Expert DM
+ DM_RANDOMIZE_POWERUPS
  
+ Note: the precaching for each powerup is moved to W_Precache
+ in weapons.qc.  Otherwise Quake would only precache the powerups
+ that already exist on the map, and would crash when a new powerup
+ is spawned.
+ 
+ */
  
  /*QUAKED item_artifact_invulnerability (0 .5 .8) (-16 -16 -24) (16 16 32)
  Player is invulnerable for 30 seconds
  */
  void() item_artifact_invulnerability =
  {
! 	// Expert DM / loadmod
! 	// Prevent pentagram from spawning, but only if not randomizing powerups.
! 	// If randomizing powerups
! 	local string s;
  
+ 	s = infokey(world, "loadmod");
+ 	loadmod = stof(s);
+ 	if ((loadmod & LM_REMOVE_PENTAGRAM) && !(deathmatch & DM_RANDOMIZE_POWERUPS))
+ 		return;
+ 
+ 	self.touch = powerup_touch;
+ /*
  	precache_model ("progs/invulner.mdl");
  	precache_sound ("items/protect.wav");
  	precache_sound ("items/protect2.wav");
  	precache_sound ("items/protect3.wav");
+ */
  	self.noise = "items/protect.wav";
  	setmodel (self, "progs/invulner.mdl");
  	self.netname = "Pentagram of Protection";
+ 	if (!(deathmatch & DM_ALTERNATE_POWERUPS))
  		self.effects = self.effects | EF_RED;
  	self.items = IT_INVULNERABILITY;
  	setsize (self, '-16 -16 -24', '16 16 32');
***************
*** 1396,1407 ****
  */
  void() item_artifact_invisibility =
  {
! 	self.touch = powerup_touch;
  
  	precache_model ("progs/invisibl.mdl");
  	precache_sound ("items/inv1.wav");
  	precache_sound ("items/inv2.wav");
  	precache_sound ("items/inv3.wav");
  	self.noise = "items/inv1.wav";
  	setmodel (self, "progs/invisibl.mdl");
  	self.netname = "Ring of Shadows";
--- 1627,1649 ----
  */
  void() item_artifact_invisibility =
  {
! 	// Expert DM / loadmod
! 	// Prevent pentagram from spawning, but only if not randomizing powerups.
! 	// If randomizing powerups
! 	local string s;
! 
! 	s = infokey(world, "loadmod");
! 	loadmod = stof(s);
! 	if ((loadmod & LM_REMOVE_PENTAGRAM) && !(deathmatch & DM_RANDOMIZE_POWERUPS))
! 		return;
  
+ 	self.touch = powerup_touch;
+ /*
  	precache_model ("progs/invisibl.mdl");
  	precache_sound ("items/inv1.wav");
  	precache_sound ("items/inv2.wav");
  	precache_sound ("items/inv3.wav");
+ */
  	self.noise = "items/inv1.wav";
  	setmodel (self, "progs/invisibl.mdl");
  	self.netname = "Ring of Shadows";
***************
*** 1416,1434 ****
  */
  void() item_artifact_super_damage =
  {
! 	self.touch = powerup_touch;
  
  	precache_model ("progs/quaddama.mdl");
  	precache_sound ("items/damage.wav");
  	precache_sound ("items/damage2.wav");
  	precache_sound ("items/damage3.wav");
  	self.noise = "items/damage.wav";
  	setmodel (self, "progs/quaddama.mdl");
! 	if (deathmatch == 4)
  		self.netname = "OctaPower";	
  	else
  		self.netname = "Quad Damage";
  	self.items = IT_QUAD;
  	self.effects = self.effects | EF_BLUE;
  	setsize (self, '-16 -16 -24', '16 16 32');
  	StartItem ();
--- 1659,1689 ----
  */
  void() item_artifact_super_damage =
  {
! 	// Expert DM / loadmod
! 	// Prevent pentagram from spawning, but only if not randomizing powerups.
! 	// If randomizing powerups
! 	local string s;
! 
! 	s = infokey(world, "loadmod");
! 	loadmod = stof(s);
! 	if ((loadmod & LM_REMOVE_PENTAGRAM) && !(deathmatch & DM_RANDOMIZE_POWERUPS))
! 		return;
  
+ 	self.touch = powerup_touch;
+ /*
  	precache_model ("progs/quaddama.mdl");
  	precache_sound ("items/damage.wav");
  	precache_sound ("items/damage2.wav");
  	precache_sound ("items/damage3.wav");
+ */
  	self.noise = "items/damage.wav";
  	setmodel (self, "progs/quaddama.mdl");
! 	if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  		self.netname = "OctaPower";	
  	else
  		self.netname = "Quad Damage";
  	self.items = IT_QUAD;
+ 	if (!(deathmatch & DM_ALTERNATE_POWERUPS))
  		self.effects = self.effects | EF_BLUE;
  	setsize (self, '-16 -16 -24', '16 16 32');
  	StartItem ();
***************
*** 1450,1484 ****
  	local   float   best, old, new;
  	local           entity  stemp;
  	local   float   acount;
  	local   float   b_switch;
  
- 	if (deathmatch == 4)
- 		if (other.invincible_time > 0)
- 			return;
- 
  	if ((stof(infokey(other,"b_switch"))) == 0)
  		b_switch = 8;
  	else
  		b_switch = stof(infokey(other,"b_switch"));
  	
  
  	if (other.classname != "player")
  		return;
  	if (other.health <= 0)
  		return;
  		
  	acount = 0;
  	sprint (other, PRINT_LOW, "You get ");
   
! 	if (deathmatch == 4)
! 	{       
  		other.health = other.health + 10;
  		sprint (other, PRINT_LOW, "10 additional health\n");
  		if ((other.health > 250) && (other.health < 300))
  			sound (other, CHAN_ITEM, "items/protect3.wav", 1, ATTN_NORM);
  		else
  			sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
  		stuffcmd (other, "bf\n");
  		remove(self);
  
  		if (other.health >299)
--- 1706,1806 ----
  	local   float   best, old, new;
  	local           entity  stemp;
  	local   float   acount;
+ 	local   float   armorbit;	
  	local   float   b_switch;
  
  	if ((stof(infokey(other,"b_switch"))) == 0)
  		b_switch = 8;
  	else
  		b_switch = stof(infokey(other,"b_switch"));
  	
+ 	// Expert: "deathmatch 4" rules
+ 	if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
+ 		if ((other.invincible_time > 0) && !(deathmatch & DM_ALTERNATE_POWERUPS))
+ 			return;
  
  	if (other.classname != "player")
  		return;
  	if (other.health <= 0)
  		return;
  
+ // *TEAMPLAY*
+ // Don't let the owner pick up his own backpack for one second.
+ 	if ( (other == self.owner) && ( (self.nextthink - time) > 119 ) )
+ 		return;
+ 		
+ 	// the bit for the armor in the backpack, if any
+ 	armorbit = self.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3);
+ 	// remove the bit for the armor in the backpack's item bitvector,
+ 	// so that all the later stuff that assumes just weapons are in
+ 	// backpacks will do the right thing
+ 	self.items = self.items - armorbit;
+ 
  	acount = 0;
  	sprint (other, PRINT_LOW, "You get ");
   
! 	// Expert DM
! 	// Code for receiving armor and health from packs, 
! 	// inactive in Alternate Restore mode.
! 	if (!(deathmatch & DM_ALTERNATE_RESTORE)) {
! 		// Expert DM
! 		// Give player the armor in the pack if DM_BALANCED_ITEMS is set
! 		// if it's better than the player's current armor
! 		if (deathmatch & DM_BALANCED_ITEMS) {
! 			if (armorbit && (self.armortype*self.armorvalue >= other.armortype*other.armorvalue)) 
! 			{
! 				// replace the player's values for armor
! 				other.armortype = self.armortype;
! 				other.armorvalue = self.armorvalue;
! 
! 				// remove any armor item bits the player had,
! 				// and add the bit for the armor in the backpack
! 				other.items = other.items - 
! 					(other.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + armorbit;
! 
! 				// inform the player, "50 red armor, "
! 				acount = 1;
! 				s = ftos(self.armorvalue);
! 				sprint(other, PRINT_LOW, s);
! 				if (armorbit == IT_ARMOR1)
! 					s = "Green armor, ";
! 				else if (armorbit == IT_ARMOR2)
! 					s = "Yellow armor, ";
! 				else if (armorbit == IT_ARMOR3)
! 					s = "Red armor, ";
! 				sprint(other, PRINT_LOW, s);
! 				// player the armor grabbing sound (from the backpack) to clue the player in
! 				sound(self, CHAN_ITEM, "items/armor1.wav", 1, ATTN_NORM);
! 			}
! 		}
! 		// Expert: "deathmatch 4" rules: health from packs.  
! 		// NOTE: if DM_BALANCED_ITEMS is set, health will be in
! 		// packs in "deathmatch 5" mode too.
! 		if (  (deathmatch & DM_FREE_GEAR) && 
! 			(!(deathmatch & DM_ITEM_RESPAWN) || (deathmatch & DM_BALANCED_ITEMS))  )
! 	 	{       
! 			// Expert
! 			// If balanced items is set, heal by 30 but don't go over limit.
! 			// Thus "bonus powers" never happen 
! 			if (deathmatch & DM_BALANCED_ITEMS) {
! 				T_Heal(other, 30 ,0);
! 				sprint (other, PRINT_LOW, "30 health restored\n");
! 			} else {
  				other.health = other.health + 10;
  				sprint (other, PRINT_LOW, "10 additional health\n");
+ 			}
  			if ((other.health > 250) && (other.health < 300))
  				sound (other, CHAN_ITEM, "items/protect3.wav", 1, ATTN_NORM);
  			else
  				sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
  			stuffcmd (other, "bf\n");
+ 		}
+ 	} // end !(deathmatch & DM_ALTERNATE_RESTORE)
+ 
+ 	// Expert: "deathmatch 4" only rules.  Pack is removed since player doesn't
+ 	// need ammo or items.  Check for "attaining bonus powers"
+ 	if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
+ 	{
  		remove(self);
  
  		if (other.health >299)
***************
*** 1495,1501 ****
  
  				other.ammo_cells = 0;		
  		
- 	
  				sound (other, CHAN_VOICE, "boss1/sight1.wav", 1, ATTN_NORM);
  				stuffcmd (other, "bf\n");               
  				bprint (PRINT_HIGH, other.netname);
--- 1817,1822 ----
***************
*** 1524,1529 ****
--- 1846,1857 ----
  	other.ammo_nails = other.ammo_nails + self.ammo_nails;
  	other.ammo_rockets = other.ammo_rockets + self.ammo_rockets;
  	other.ammo_cells = other.ammo_cells + self.ammo_cells;
+ 	// Expert DM
+ 	// Throwing axes in backpacks
+ 	if (deathmatch & DM_WEAPON_MODES) {
+ 		other.ammo_axes = other.ammo_axes + self.ammo_axes;
+ 		if (other.ammo_axes > 15) other.ammo_axes = 15;
+ 	}
  
  	new = self.items;
  	if (!new)
***************
*** 1569,1576 ****
  		sprint (other, PRINT_LOW, s);
  		sprint (other,PRINT_LOW, " cells");
  	}
  	
! 	if ( (deathmatch==3 || deathmatch == 5) & ( (WeaponCode(new)==6) || (WeaponCode(new)==7) ) & (other.ammo_rockets < 5) )
  		other.ammo_rockets = 5;
  
  	sprint (other, PRINT_LOW, "\n");
--- 1897,1913 ----
  		sprint (other, PRINT_LOW, s);
  		sprint (other,PRINT_LOW, " cells");
  	}
+ 	if ((self.ammo_axes) && (deathmatch & DM_WEAPON_MODES))
+ 	{
+ 		if (acount)
+ 			sprint(other, PRINT_LOW, ", ");
+ 		acount = 1;
+ 		s = ftos(self.ammo_axes);
+ 		sprint (other, PRINT_LOW, s);
+ 		sprint (other,PRINT_LOW, " throwing axes");
+ 	}
  	
! 	if ( (deathmatch & DM_WEAPON_STAY) & ( (WeaponCode(new)==6) || (WeaponCode(new)==7) ) & (other.ammo_rockets < 5) )
  		other.ammo_rockets = 5;
  
  	sprint (other, PRINT_LOW, "\n");
***************
*** 1599,1604 ****
--- 1936,1943 ----
  		}
  	}
  	
+ 	
+ 
  	W_SetCurrentAmmo ();
  };
  
***************
*** 1614,1619 ****
--- 1953,1965 ----
  	if (!(self.ammo_shells + self.ammo_nails + self.ammo_rockets + self.ammo_cells))
  		return; // nothing in it
  
+ 	// Expert DM
+ 	// If in "deathmatch 4" mode, and in alternate restore mode, there's
+ 	// nothing to put in the pack, so don't drop one!
+ 	if (  ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) &&
+ 		(deathmatch & DM_ALTERNATE_RESTORE)   )
+ 		return;
+ 
  	item = spawn();
  	item.origin = self.origin - '0 0 24';
  	
***************
*** 1641,1646 ****
--- 1987,2029 ----
  	item.ammo_nails = self.ammo_nails;
  	item.ammo_rockets = self.ammo_rockets;
  	item.ammo_cells = self.ammo_cells;
+ 	// Expert DM
+ 	// Throwing axes in backpacks
+ 	item.ammo_axes = self.ammo_axes;
+ 
+ 	// Never put an emtpy weapon into a backpack in DM_WEAPON_STAY mode
+ 
+ 	if (deathmatch & DM_WEAPON_STAY)
+ 	{
+ 		if ((item.items == IT_SUPER_SHOTGUN) && (!item.ammo_shells))
+ 		{
+ 			item.items = 0;
+ 			item.netname = "";
+ 		}
+ 		else if ( ((item.items == IT_NAILGUN) || (item.items == IT_SUPER_NAILGUN)) && (!item.ammo_nails))
+ 		{
+ 			item.items = 0;
+ 			item.netname = "";
+ 		}
+ 		else if ( ((item.items == IT_GRENADE_LAUNCHER) || (item.items == IT_ROCKET_LAUNCHER)) && (!item.ammo_rockets))
+ 		{
+ 			item.items = 0;
+ 			item.netname = "";
+ 		}
+ 		if ((item.items == IT_LIGHTNING) && (!item.ammo_cells))
+ 		{
+ 			item.items = 0;
+ 			item.netname = "";
+ 		}
+ 	}
+ 
+ // Expert DM
+ // stick armor into the backpack
+ 	if (self.armorvalue > 0) {
+ 		item.armortype = self.armortype;
+ 		item.armorvalue = self.armorvalue; 
+ 		item.items = item.items | (self.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3));
+ 	}
  
  	item.velocity_z = 300;
  	item.velocity_x = -100 + (random() * 200);
diff -crbB --unidirectional-new-file qw201/lmspam.qc expert12/lmspam.qc
*** qw201/lmspam.qc	Thu Jan  1 00:00:00 1970
--- expert12/lmspam.qc	Thu Aug 14 22:06:26 1997
***************
*** 0 ****
--- 1,989 ----
+ /* loadmod.qc */
+ 
+ /**
+ 
+ LoadMod by Charles "Myrkul" Kendrick (myrkul@myrkul.org)
+ 
+ LoadMod is a system for dynamically changing the entities in a level on the first few
+ game tics after level load.  It was primarily desgined for placing additional armor 
+ and health in levels in order to facilitate game balance, but the system is highly
+ flexible and extensible, and there are numerous other purposes that LoadMod can be
+ used for (and is used for).
+ 
+ If a level has too few armors, LoadMod can place a new set of armor in the level, on
+ top of the item that is furthest away from all the other armors on the level.  As an
+ example, if one armor is added to dm3, it will be placed in the SNG room on top of a
+ box of shells on the walkway.
+ 
+ For programmers:
+ 
+ LoadMod() is called on the first game tic from StartFrame() in world.qc.  The function
+ LoadMod() itself doesn't do everything, rather it sets up for it to be done over the
+ next few seconds.  This is necessary because LoadMod has to go through the entire 
+ entity list many times in order to get its work done, and if you try to do that in 
+ one tic, the Quake engine will spuriously detect a runaway loop because your function
+ takes too long to return.
+ 
+ To get around this problem, LoadMod spawns new entities whose only purpose is to sit
+ and call .think() functions, accomplishing a bit of the massive task of LoadMod every
+ game tic.  LoadMod usually completes in about 5 seconds.  If you are in the game after
+ a level change and are quick, you may be able to see an item dynamically added to the
+ level.
+ 
+ One nifty hack that I should probably explain separately: in order to get some
+ object-oriented functionality out of QuakeC, I assign functions to the .touch() field
+ of entities, and then pass those entities around essentially as "function pointers",
+ allowing a given routine to, for instance, call an arbitrary function on all entities
+ on the level, with no idea what that function will do.  The simplest example of this
+ is LMWalkAll() (below).
+ 
+ Passing function pointers around is one way in which LoadMod is very re-usable.  For
+ instance, it's very easy to swap in your own functions for optimal entity placement.
+ 
+ Some example uses of LoadMod:
+ 
+ 1. Adding cells and the lightning gun to e1m* maps.
+ 2. Placing a new type of weapon and its ammo evenly throughout a level that wouldn't
+ otherwise have it.
+ 3. Placing any new game object evenly throughout a level, for instance, placing "flags"
+ for an alternate CTF mode in which flags are scattered around the map and each team must
+ gather as many flags as possible.
+ 4. Adding camera entities above critical game items.
+ 5. Removing DM spawn spots near CTF bases. [this one is actually implemented below]
+ 6. Completely re-doing item placement for a level.
+ 
+ **/
+ 
+ /** Defs **/
+ 
+ // TEMP
+ 
+ .entity searchPos;
+ .float quotagap;
+ .float bestdistance;
+ .float status;
+ .entity spawnInfo;
+ .entity avoider;
+ .entity bestentity;
+ 
+ // whether an entity is essentially "gone" with respect to loadmod
+ .float voided;
+ // holds the result of a LoadMod touch function
+ .float funcResult;
+ .string stringResult;
+ 
+ // internal defs
+ 
+ float FIND_NEAREST =		1;
+ float FIND_FURTHEST =		2;
+ 
+ float DO_ADD =			4;
+ float DO_VOID =			8;
+ 
+ /** MODIFIABLE CONSTANTS **/
+ 
+ // LM Quota Constants
+ // Quotas for the amounts of various items in levels.  LoadMod
+ // will add or remove items from the level (according to what
+ // options are set) in order to make the actual items in the level
+ // match the quotas. These are per player constants, ie, 0.4 armor
+ // means 4 total armors in a 10 player game.
+ 
+ float LMQUOTA_ARMOR =		0.4;
+ float LMQUOTA_HEALTH =		40;
+ // [BELOW NOT IMPLEMENTED]
+ float LMQUOTA_SHELLS =		10;
+ float LMQUOTA_SPIKES =		30;
+ float LMQUOTA_ROCKETS =		3; 
+ float LMQUOTA_CELLS =		20;
+ float LMQUOTA_WEAPONS =		0.8;
+ 
+ /** Globals **/
+ 
+ float loadmodCalled = 0; // whether loadmod has been called yet
+ 
+ float numPlayers; 	// number of players in the game
+ 
+ float itemtype;		// the current itemtype that actions are being performed for
+ float action;		// the current action to perform: init, switching item types,
+ 				// placing new items, cleanup.
+ 
+ //--------------------------//
+ // IDENTIFICATION FUNCTIONS //
+ //--------------------------//
+ 
+ /*
+ ================
+ LMIsAmmoHealth
+ 
+ Reports true if an entity is an ammo or health box
+ ================
+ */
+ float(string className) LMIsAmmoHealth =
+ {
+ 
+ 	if ((className == "item_shells") ||
+ 		(className == "item_spikes") ||
+ 		(className == "item_rockets") ||
+ 		(className == "item_cells") ||
+ 		(className == "item_health"))
+ 		return 1;
+ 	return 0;
+ };
+ 
+ /*
+ ================
+ LMIsWeaponArmor
+ 
+ Reports true if an entity is a weapon or armor
+ ================
+ */
+ float(string className) LMIsWeaponArmor =
+ {
+ 
+ 	if ((className == "weapon_supershotgun") ||
+ 		(className == "weapon_nailgun") ||
+ 		(className == "weapon_supernailgun") ||
+ 		(className == "weapon_grenadelauncher") ||
+ 		(className == "weapon_rocketlauncher") ||
+ 		(className == "weapon_lightning") ||
+ 		(className == "item_armor1") ||
+ 		(className == "item_armor2") ||
+ 		(className == "item_armorInv")) 
+ 		return 1;
+ 	return 0;
+ };
+ 
+ /*
+ ================
+ LMIsItem
+ 
+ Reports true if an entity is an "item" entity as opposed
+ to some non-item entity, such as an ambient sound or missile.
+ ================
+ */
+ float(string className) LMIsItem =
+ {
+ 
+ 	if ((className == "item_shells") ||
+ 		(className == "item_spikes") ||
+ 		(className == "item_rockets") ||
+ 		(className == "item_cells") ||
+ 		(className == "item_health") ||
+ 		(className == "weapon_supershotgun") ||
+ 		(className == "weapon_nailgun") ||
+ 		(className == "weapon_supernailgun") ||
+ 		(className == "weapon_grenadelauncher") ||
+ 		(className == "weapon_rocketlauncher") ||
+ 		(className == "weapon_lightning") ||
+ 		(className == "item_armor1") ||
+ 		(className == "item_armor2") ||
+ 		(className == "item_armorInv")) 
+ 		return 1;
+ 	return 0;
+ };
+ 
+ /*
+ ================
+ ItemOffset
+ 
+ Reports the offset required to place an item of "placingClass" on
+ exactly on top of an item of class "onClass".
+ ================
+ */
+ vector(string placingClass, string onClass) ItemOffset =
+ {
+ 	local float spawningWeapon, spawningHealth, onWeapon, onHealth;
+ 
+ 	spawningWeapon = LMIsWeaponArmor(placingClass);
+ 	spawningHealth = LMIsAmmoHealth(placingClass);
+ 	onWeapon = LMIsWeaponArmor(onClass);
+ 	onHealth = LMIsAmmoHealth(onClass);
+ 
+ 	if (spawningWeapon && onHealth) {
+ 		// spawning a weapon or armor on top of ammo or health
+ 		return '16 16 0';
+ 	} else if (spawningHealth && onWeapon) {
+ 		// spawning an ammo or health on top of a weapon or armor
+ 		return '-16 -16 0';
+ 	} else {
+ 		return '0 0 0';
+ 	}
+ 
+ };
+ 
+ //-------------------------//
+ // SPAWN CONTROL FUNCTIONS //
+ //-------------------------//
+ 
+ /*
+ ================
+ LMWalkAll
+ 
+ LMWalkAll walks the list of all entities and calls the touch
+ function of the entity argument, with "self" set to the entity
+ holding the touch function and other set to the current entity
+ in the list.
+ 
+ Example usage: pass in an entity with a touch function that with
+ do a sum of all rocket ammo in the level, by storing the sum in
+ a field in the entity.
+ ================
+ */
+ void(entity funcHolder) LMWalkAll =
+ {
+ 	local entity p;
+ 
+ 	p = nextent(world);
+ 	while (p != world) {
+ 		self = funcHolder;
+ 		other = p;
+ 		funcHolder.touch();
+ 		p = nextent(p);
+ 	}
+ };
+ 
+ /*
+ ================
+ LMWalkClass
+  
+ LMWalkAll walks the list of all entities of the class "className"
+ and calls the touch function of the entity argument, with "self" set
+ to the entity holding the touch function and other set to the current
+ entity in the list.
+ ================
+ */
+ void(string className, entity funcHolder) LMWalkClass =
+ {
+ 	local entity p;
+ 
+ 	p = find(world, classname, className);
+ 	while (p != world) {
+ 		self = funcHolder;
+ 		other = p;
+ 		funcHolder.touch();
+ 		p = find(p, classname, className);
+ 	}
+ };
+ 
+ /*
+ ================
+ LMSetVoided
+ 
+ LMSetVoided sets the "voided" field of all entities of the classes
+ given as arguments.  If className is to "null", all entities will
+ be set.  Entities marked as "voided" will be replaced or removed.
+ ================
+ */
+ void(float voidValue, string className, string className2,
+ 			string className3) LMSetVoided =
+ {
+ 	local entity p;
+ 
+ 	p = nextent(world);
+ 	while (p != world) {
+ 		if ((className == "null") ||
+ 			(p.classname == className) ||
+ 			(p.classname == className2) ||
+ 			(p.classname == className3))
+ 		{
+ 			p.voided = voidValue;
+ 		}
+ 		p = nextent(p);
+ 	}
+ };
+ 
+ /*
+ ================
+ LMReleaseVoided
+ 
+ LMReleaseVoided removes all voided entities from the entity list.
+ ================
+ */
+ void() LMReleaseVoided =
+ {
+ 	local entity p;
+ 
+ 	p = nextent(world);
+ 	while (p != world) {
+ 		if (p.voided) {
+ 			remove(p);
+ 		}
+ 		p = nextent(p);
+ 	}
+ };
+ 
+ //--------------------//
+ // SPAWNING FUNCTIONS //
+ //--------------------//
+ 
+ /*
+ ================
+ LMDoSpawn
+ 
+ Call the correct spawn function for "spawnClass".  Basically a big switch
+ statement, that I wish id had written as part of the spawn() built-in
+ ================
+ */
+ void(entity spawnEnt, string spawnClass) LMDoSpawn =
+ {
+ 
+ 	local entity holder;
+ 
+ 	spawnEnt.classname = spawnClass;
+ 
+ 	// store the value of "self" and set it for calling the spawn function
+ 	holder = self;
+ 	self = spawnEnt;
+ 
+ 	if (spawnClass == "item_armor1") {
+ 		item_armor1();
+ 	} else if (spawnClass == "item_armor2") {
+ 		item_armor2();
+ 	} else if (spawnClass == "item_armorInv") {
+ 		item_armorInv();
+ 	} else if (spawnClass == "item_health") {
+ 		item_health();
+ 	} else if (spawnClass == "weapon_supershotgun") {
+ 		weapon_supershotgun();
+ 	} else if (spawnClass == "weapon_nailgun") {
+ 		weapon_nailgun();
+ 	} else if (spawnClass == "weapon_supernailgun") {
+ 		weapon_supernailgun();
+ 	} else if (spawnClass == "weapon_grenadelauncher") {
+ 		weapon_grenadelauncher();
+ 	} else if (spawnClass == "weapon_rocketlauncher") {
+ 		weapon_rocketlauncher();
+ 	} else if (spawnClass == "weapon_lightning") {
+ 		weapon_lightning();
+ 	} else if (spawnClass == "item_shells") {
+ 		item_shells();
+ 	} else if (spawnClass == "item_spikes") {
+ 		item_spikes();
+ 	} else if (spawnClass == "item_rockets") {
+ 		item_rockets();
+ 	} else if (spawnClass == "item_cells") {
+ 		item_cells();
+ 	}
+ 
+ 	// reset self
+ 	self = holder;
+ 
+ };
+ 
+ // Spawn Cycling functions
+ // Set as touch functions for entities passed to item placement,
+ // routines these functions return in "stringResult" a classname
+ // to be spawned and in "funcResult" the amount that spawning an
+ // item of that class will reduce the quota.
+ 
+ /*
+ ================
+ LMTArmorSpawn
+ 
+ Touch function passed in for cycling through armors for spawning.
+ ================
+ */
+ void() LMTArmorSpawn =
+ {
+ 	if (self.status == 0) {
+ 		self.stringResult = "item_armorInv";
+ 		self.funcResult = 1;
+ 		self.status = 1;
+ 	} else if (self.status == 1) {
+ 		self.stringResult = "item_armor2";
+ 		self.funcResult = 1;
+ 		self.status = 2;
+ 	} else if (self.status == 2) {
+ 		self.stringResult = "item_armor1";
+ 		self.funcResult = 1;
+ 		self.status = 0;
+ 	}
+ };
+ 
+ /*
+ ================
+ LMTHealthSpawn
+ 
+ Touch function passed in for cycling through healths for spawning.
+ ================
+ */
+ void() LMTHealthSpawn =
+ {
+ 	self.stringResult = "item_health";
+ 	self.funcResult = 25;
+ };
+ 
+ //--------------------//
+ // COUNTING FUNCTIONS //
+ //--------------------//
+ 
+ /*
+ ================
+ LMClassCount
+ 
+ Return the number of entities in the game of a certain class,
+ eg, "item_armor1".
+ ================
+ */
+ float(string class) LMClassCount =
+ {
+ 	local entity p;
+ 	local float result;
+ 
+ 	result = 0;
+ 
+ 	if (class != "null") {
+ 		p = find (world, classname, class);
+ 		while(p != world)
+ 		{
+ 			if (!p.voided) {
+ 				result = result + 1;
+ 			}
+ 			p = find(p, classname, class);
+ 		}
+ 	}
+ 	return result;
+ };
+ 
+ /*
+ ================
+ LMClassCountMulti
+ 
+ Return the number of entities in the game of class
+ "class", "class2" or "class3"
+ ================
+ */
+ float(string class, string class2, string class3) LMClassCountMulti =
+ {
+ 	local float result;
+ 
+ 	if (class != "null") {
+ 		result = LMClassCount(class);
+ 	}
+ 
+ 	if (class2 != "null") {
+ 		result = result + LMClassCount(class2);
+ 	}
+ 
+ 	if (class3 != "null") {
+ 		result = result + LMClassCount(class3);
+ 	}
+ 	return result;
+ };
+ 
+ //--------------------//
+ // CRITERIA FUNCTIONS //
+ //--------------------//
+ 
+ /*
+ ================
+ LMDistanceToNearestAvoid
+ 
+ Walks the entire entity list, finding the closest entity
+ to "position" that "avoidID.touch()" identifies as being important.
+ 
+ "avoidID" is an entity whose .touch() function will set 
+ self.funcResult to TRUE (1) if "self" is a entity that
+ should be considered an entity to avoid (and thus calculate
+ nearness to).
+ ================
+ */
+ float(vector position, entity avoidID) LMDistanceToNearestAvoid =
+ {
+ 	local float entDistance, nearestDistance;
+ 	local entity near, holder;
+ 
+ 	nearestDistance = 60000;
+ 
+ 	near = nextent(world);
+ 	while(near != world)
+ 	{
+ 		holder = self;
+ 		// HACK BLUDGEON MAIM
+ 		// set "self" to the current entity in the list
+ 		// walk, and call avoidID's touch function, 
+ 		// effectively on "near"
+ 		self = near;
+ 		avoidID.touch();
+ 
+ 		self = holder;
+ 
+ 		// NOTE: avoidID's touch function actually set a
+ 		// field in "near", since the global "self" was set
+ 		// to "near" when avoidID.touch was called.
+ 		if (near.funcResult) {
+ 			entDistance = vlen(position - near.origin);
+ 			if ((entDistance < nearestDistance) && !near.voided)
+ 				nearestDistance = entDistance;
+ 		}
+ 		near = nextent(near);
+ 	}
+ 
+ 	return nearestDistance;
+ 
+ };
+ 
+ //----------------------------------//
+ // TOUCH FUNCTIONS FOR LIST WALKING //
+ //----------------------------------//
+ 
+ /*
+ ================
+ LMTHealthAmount
+ ================
+ */
+ void() LMTHealthAmount =
+ {
+ 	local string s;
+ 
+ 	if (other.spawnflags & H_ROTTEN) {
+ 		self.funcResult = self.funcResult + 15;
+ 	} else if (other.spawnflags & H_MEGA) {
+ 		// don't count mega healths as part of normal
+ 		// restoration health.  It's considered a powerup.
+ 		return;
+ 	} else {
+ 		self.funcResult = self.funcResult + 25;
+ 	}
+ };
+ 
+ /*
+ ================
+ LMTAmmoAmount
+ ================
+ */
+ void() LMTAmmoAmount =
+ {
+ 	self.funcResult = self.funcResult + other.aflag;
+ };
+ 
+ 
+ /*
+ ==================================
+ LMTRemoveSpawns
+ 
+ Remove all deathmatch spawn spots that are
+ within a certain radius of CTF flags
+ ==================================
+ */
+ void() LMTRemoveSpawns =
+ {
+ 	local entity list, temp;
+ 
+ 	list = findradius(other.origin, 400);
+ 	while (list != world) {
+ 		if ((list.classname == "item_flag_team1") ||
+ 			(list.classname == "item_flag_team2")) {
+ 			remove(other);
+ 			return;
+ 		} else {
+ 			list = list.chain;
+ 		}
+ 	}
+ 
+ };
+ 
+ //-------------------------------------//
+ // THINK FUNCTIONS FOR PLACER ENTITIES //
+ //-------------------------------------//
+ 
+ /*
+ ================
+ LMAny_Avoid
+ 
+ Items to avoid when placing any item - powerups and megahealths.
+ "self" must be set to the item to be checked.
+ ================
+ */
+ float() LMAny_Avoid =
+ {
+ 	if (self.classname == "item_artifact_invulnerability" ||
+ 		self.classname == "item_artifact_super_damage" ||
+ 		self.classname == "item_artifact_invisibility" ||
+ 		(self.classname == "item_health" && self.spawnflags & H_MEGA))
+ 		return 1;
+ 	return 0;
+ };
+ 
+ /*
+ ================
+ LMTHealth_Avoid
+ 
+ Function that identifies items to be avoided when
+ placing health packs.
+ ================
+ */
+ void() LMTHealth_Avoid =
+ {
+ 	if (self.classname == "item_health" ||
+ 		LMAny_Avoid()) 
+ 	{
+ 		self.funcResult = 1;
+ 		return;
+ 	}
+ 	self.funcResult = 0;
+ 	return;
+ };
+ 
+ /*
+ ================
+ LMTArmor_Avoid
+ 
+ Function that identifies items to be avoided when
+ placing armors.
+ ================
+ */
+ void() LMTArmor_Avoid =
+ {
+ 	if (self.classname == "item_armor1" ||
+ 		self.classname == "item_armor2" ||
+ 		self.classname == "item_armorInv" ||
+ 		LMAny_Avoid()) 
+ 	{
+ 		self.funcResult = 1;
+ 		return;
+ 	}
+ 	self.funcResult = 0;
+ 	return;
+ };
+ 
+ void() LMThink_Control;
+ 
+ /*
+ ================
+ LMThink_Spawn
+ ================
+ */
+ void() LMThink_Spawn =
+ {
+ 	local string spawnClass;	
+ 	local entity holder, spawnEnt;
+ 	local vector position;
+ 
+ 		// XXXXXXXXXXXXXXXX
+ 		if (self.bestentity == world)
+ 			dprint("ATTEMPT TO SPAWN @ WORLD\n");
+ 		// XXXXXXXXXXXXXXXX
+ 
+ 	// determine the kind of item to spawn
+ 	holder = self;
+ 	self = self.spawnInfo;
+ 	self.touch();
+ 	self = holder;
+ 
+ 	spawnClass = self.spawnInfo.stringResult;
+ 	self.quotagap = self.quotagap - self.spawnInfo.funcResult;
+ 
+ 	// origin adjustment to prevent items falling out of level.
+ 	position = self.bestentity.origin + ItemOffset(spawnClass, self.bestentity.classname);
+ 
+ 	if (self.bestentity.voided) {
+ 		// overwrite (become) the entity with the best position
+ 		spawnEnt = self.bestentity;
+ 		spawnEnt.voided = 0;
+ 		setorigin(spawnEnt, position);
+ 	} else {
+ 		// create a new entity directly on top of 
+ 		// the entity with the best position
+ 		spawnEnt = spawn();
+ 		setorigin(spawnEnt, position);
+ 	}
+ 
+ 	LMDoSpawn(spawnEnt, spawnClass);
+ 
+ /*
+ 	dprint("\nSpawning an item of class ");
+ 	dprint(spawnClass);
+ 	if (self.bestentity.voided) {
+ 		dprint(" in place of an ");
+ 	} else {
+ 		dprint(" on top of an ");
+ 	}
+ 	dprint(self.bestentity.classname);
+ 	dprint("\nLocation is ");
+ 	s = vtos(self.bestentity.origin);
+ 	dprint(s);
+ 	dprint(", nearest similar entity is ");
+ 	s = ftos(self.bestdistance);
+ 	dprint(s);
+ 	dprint(" away\n\n");
+ */
+ 
+ 	self.nextthink = time + 0.1;
+ 	self.think = LMThink_Control;
+ 
+ };
+ 
+ /*
+ ================
+ LMThink_Place
+ ================
+ */
+ void() LMThink_Place =
+ {
+ 	local entity p, identifier;
+ 	local string s;
+ 	local float thisDistance;	
+ 
+ 	self.searchPos = nextent(self.searchPos);
+ 	p = self.searchPos;
+ 
+ 	while ((p != world) && !LMIsItem(p.classname)) {
+ 		// go through the entire entire entity list until we hit either an 
+ 		// item (which is a potential spawn point) or the end of the list (world).
+ 		p = nextent(p);
+ 	}
+ 
+ 	if (p != world) {
+ 
+ 		thisDistance = LMDistanceToNearestAvoid(p.origin, self.avoider);
+ 
+ 		// find the entity furthest from the nearclasses, but
+ 		// prefer voided entities 100% over non-voided
+ 		if ((thisDistance > self.bestdistance) &&
+ 			!(self.bestentity.voided && !p.voided))
+ 		{
+ 			self.bestdistance = thisDistance;
+ 			self.bestentity = p;
+ 		}
+ 
+ 	} else {
+ 		self.think = LMThink_Spawn;
+ 	}
+ 	self.nextthink = time + 0.1;
+ 
+ };
+ 
+ /*
+ ================
+ LMThink_Control
+ ================
+ */
+ void() LMThink_Control =
+ {
+ 	// XXXXXXXXXXXXXX
+ 	local string spawnClass;
+ 	local entity holder;
+ 
+ 	if (self.quotagap > 0) {
+ 
+ 	// XXXXXXXXXXXXXXXXXXXX
+ 	dprint("Placer control: placing more ");
+ 
+ 	holder = self;
+ 	self = self.spawnInfo;
+ 	self.touch();
+ 	self = holder;
+ 
+ 	dprint(self.spawnInfo.stringResult);
+ 	dprint("\n");
+ 	// XXXXXXXXXXXXXXXXXXX
+ 
+ 		self.nextthink = time + 0.1;
+ 		self.think = LMThink_Place;
+ 		self.bestdistance = 0;
+ 		self.searchPos = world;
+ 	} else {
+ 
+ 	// XXXXXXXXXXXXXXXXXXXX
+ 	dprint("Placer control: done placing ");
+ 	holder = self;
+ 	self = self.spawnInfo;
+ 	self.touch();
+ 	self = holder;
+ 
+ 	dprint(self.spawnInfo.stringResult);
+ 	dprint("\n");
+ 	// XXXXXXXXXXXXXXXXXXXX
+ 
+ 
+ 		self.think = SUB_Remove;
+ 		self.nextthink = time + 110;
+ 		self.avoider.think = SUB_Remove;
+ 		self.avoider.nextthink = time + 105;
+ 		self.spawnInfo.think = SUB_Remove;
+ 		self.spawnInfo.nextthink = time + 100;
+ /*
+ 		remove(self.avoider);
+ 		remove(self.spawnInfo);
+ 		remove(self);
+ */
+ 	}
+ };
+ 
+ /*
+ ================
+ LMThink_Armor
+ ================
+ */
+ void() LMThink_Armor =
+ {
+ 	local string s;
+ 	local entity funcHolder, placer;
+ 
+ 	// XXXXXXXXXXXXXXXXXXXXXX
+ 	dprint("Armor setup think\n");
+ 
+ 	// set up the spawning function for armors
+ 	placer = spawn();
+ 	placer.classname = "placer";
+ 
+ 	// determine if quota for armors is met
+ 	placer.quotagap = (LMQUOTA_ARMOR * numPlayers) -
+ 			LMClassCountMulti("item_armor1", "item_armor2", "item_armorInv");
+ 	placer.quotagap = rint(placer.quotagap);
+ 
+ 	// identifier function entity - this is what causes this
+ 	// placer to avoid other armors (and other items) when placing
+ 	placer.avoider = spawn();
+ 	placer.avoider.classname = "info_avoid_armor";
+ 	placer.avoider.touch = LMTArmor_Avoid;
+ 
+ 	// spawner function entity - this is what causes this
+ 	// placer to place armors (in a cycle)
+ 	placer.spawnInfo = spawn();
+ 	placer.spawnInfo.classname = "info_spawn_armor";
+ 	placer.spawnInfo.touch = LMTArmorSpawn;
+ 
+ 	// start placing
+ 	placer.think = LMThink_Control;
+ 	placer.nextthink = time + 0.1;
+ 
+ 	remove(self);
+ 
+ };
+ 
+ /*
+ ================
+ LMThink_Health
+ ================
+ */
+ void() LMThink_Health =
+ {
+ 	local string s;
+ 	local entity funcHolder, placer;
+ 
+ 	// XXXXXXXXXXXXXXXXXX
+ 	dprint("Health setup think\n");
+ 
+ 	// determine if the quota for health is met
+ 	// create an entity to hold the summing function
+ 	funcHolder = spawn();
+ 	funcHolder.touch = LMTHealthAmount;
+ 	LMWalkClass("item_health", funcHolder);
+ 
+ 	// set up the spawning function for health
+ 	placer = spawn();
+ 	placer.classname = "placer";
+ 	placer.quotagap = (LMQUOTA_HEALTH * numPlayers) - funcHolder.funcResult;
+ 	placer.quotagap = rint(placer.quotagap);
+ 	remove(funcHolder);
+ 
+ 	// identifier function entity - this is what causes this
+ 	// placer to avoid other armors (and other items) when placing
+ 	placer.avoider = spawn();
+ 	placer.avoider.classname = "info_avoid_health";
+ 	placer.avoider.touch = LMTHealth_Avoid;
+ 
+ 	// spawner function entity - this is what causes this
+ 	// placer to place armors (in a cycle)
+ 	placer.spawnInfo = spawn();
+ 	placer.spawnInfo.classname = "info_spawn_health";
+ 	placer.spawnInfo.touch = LMTHealthSpawn;
+ 
+ 	// start placing
+ 	placer.think = LMThink_Control;
+ 	placer.nextthink = time + 0.1;
+ 
+ 	remove(self);
+ };
+ 
+ /*
+ ================
+ LoadMod
+ 
+ An ambitious function :) Goes through the list of entities in the map and
+ modifies it to produce a more balanced game with less shortages.  There are
+ a set of quotas for each set of items of a kind, for instance armor.
+ 
+ When items need to be added according to quotas, the added items will be
+ added at the item-entity position furthest from all other items of the same 
+ type as the item being added.
+ ================
+ */
+ void() LoadMod =
+ {
+ 	local string s;
+ 	local entity funcHolder, placer;
+ 
+ 	// flag to ensure a single call
+ 	loadmodCalled = 1;
+ 
+ 	// grab the bitvector for controlling loading modifications
+ 	s = infokey(world, "loadmod");
+ 	loadmod = stof(s);
+ 
+ 	if (loadmod > 0) {
+ 
+ 		// XXXXXXXXXXXXXXXX
+ 		dprint("Entering LoadMod main\n");
+ 
+ 		// determine number of clients
+ 		s = infokey(world, "maxclients");
+ 		numPlayers = stof(s);
+ 
+ 		// if REDO_ITEMS is set, mark all items in the map as "voided",
+ 		// so they will be replaced by items created to fulfill quotas
+ 	//	if (loadmod & LM_REDO_ITEMS) {
+ 	//		LMSetVoided(1, "null", "null", "null");
+ 	//	} else {
+ 	//		LMSetVoided(0, "null", "null", "null");
+ 	//	}
+ 
+ 		// XXXXXXXXXXXXXX
+ 		dprint("Setting voided\n");
+ 
+ 		// set all entities as not voided
+ 		LMSetVoided(0, "null", "null", "null");
+ 
+ 		// remove deathmatch spawns near CTF bases
+ 		if (loadmod & LM_REMOVE_BASE_SPAWNS) {
+ 			// XXXXXXXXXXXXXXXX
+ 			dprint("Removing DM spawns near bases\n");
+ 			funcHolder = spawn();
+ 			funcHolder.touch = LMTRemoveSpawns;
+ 		
+ 			LMWalkClass("info_player_deathmatch", funcHolder);
+ 
+ 			remove(funcHolder);
+ 		}
+ 
+ 		// XXXXXXXXXXXXXXXXXX
+ 		dprint("Releasing voided\n");
+ 
+ 		// release all entities that are voided
+ 		LMReleaseVoided();
+ 
+ 		if (loadmod & LM_QUOTA_ADD) {
+ 
+ 			// XXXXXXXXXXXX
+ 			dprint("Setting up quota objects\n");
+ 
+ 			// create entities to place additional items
+ 			funcHolder = spawn();
+ 			funcHolder.classname = "armorSpawner";
+ 			funcHolder.think = LMThink_Armor;
+ 			funcHolder.nextthink = time + 0.1;
+ 	
+ 			funcHolder = spawn();
+ 			funcHolder.classname = "healthSpawner";
+ 			funcHolder.think = LMThink_Health;
+ 			funcHolder.nextthink = time + 0.1;
+ 		}
+ 
+ 		// XXXXXXXXXXXXXXX
+ 		dprint("LoadMod main ended\n");
+ 	}
+ 
+ };
\ No newline at end of file
diff -crbB --unidirectional-new-file qw201/loadmod.qc expert12/loadmod.qc
*** qw201/loadmod.qc	Thu Jan  1 00:00:00 1970
--- expert12/loadmod.qc	Sat Aug 16 20:30:30 1997
***************
*** 0 ****
--- 1,938 ----
+ /* loadmod.qc */
+ 
+ /**
+ 
+ LoadMod by Charles "Myrkul" Kendrick (myrkul@myrkul.org)
+ 
+ LoadMod is a system for dynamically changing the entities in a level on the first few
+ game tics after level load.  It was primarily desgined for placing additional armor 
+ and health in levels in order to facilitate game balance, but the system is highly
+ flexible and extensible, and there are numerous other purposes that LoadMod can be
+ used for (and is used for).
+ 
+ If a level has too few armors, LoadMod can place a new set of armor in the level, on
+ top of the item that is furthest away from all the other armors on the level.  As an
+ example, if one armor is added to dm3, it will be placed in the SNG room on top of a
+ box of shells on the walkway.
+ 
+ For programmers:
+ 
+ LoadMod() is called on the first game tic from StartFrame() in world.qc.  The function
+ LoadMod() itself doesn't do everything, rather it sets up for it to be done over the
+ next few seconds.  This is necessary because LoadMod has to go through the entire 
+ entity list many times in order to get its work done, and if you try to do that in 
+ one tic, the Quake engine will spuriously detect a runaway loop because your function
+ takes too long to return.
+ 
+ To get around this problem, LoadMod spawns new entities whose only purpose is to sit
+ and call .think() functions, accomplishing a bit of the massive task of LoadMod every
+ game tic.  LoadMod usually completes in about 5 seconds.  If you are in the game after
+ a level change and are quick, you may be able to see an item dynamically added to the
+ level.
+ 
+ One nifty hack that I should probably explain separately: in order to get some
+ object-oriented functionality out of QuakeC, I assign functions to the .touch() field
+ of entities, and then pass those entities around essentially as "function pointers",
+ allowing a given routine to, for instance, call an arbitrary function on all entities
+ on the level, with no idea what that function will do.  The simplest example of this
+ is LMWalkAll() (below).
+ 
+ Passing function pointers around is one way in which LoadMod is very re-usable.  For
+ instance, it's very easy to swap in your own functions for optimal entity placement.
+ 
+ Some example uses of LoadMod:
+ 
+ 1. Adding cells and the lightning gun to e1m* maps.
+ 2. Placing a new type of weapon and its ammo evenly throughout a level that wouldn't
+ otherwise have it.
+ 3. Placing any new game object evenly throughout a level, for instance, placing "flags"
+ for an alternate CTF mode in which flags are scattered around the map and each team must
+ gather as many flags as possible.
+ 4. Adding camera entities above critical game items.
+ 5. Removing DM spawn spots near CTF bases. [this one is actually implemented below]
+ 6. Completely re-doing item placement for a level.
+ 
+ **/
+ 
+ /** Defs **/
+ 
+ // TEMP
+ 
+ .entity searchPos;
+ .float quotagap;
+ .float bestdistance;
+ .float status;
+ .entity spawnInfo;
+ .entity avoider;
+ .entity bestentity;
+ 
+ // whether an entity is essentially "gone" with respect to loadmod
+ .float voided;
+ // holds the result of a LoadMod touch function
+ .float funcResult;
+ .string stringResult;
+ 
+ // internal defs
+ 
+ float FIND_NEAREST =		1;
+ float FIND_FURTHEST =		2;
+ 
+ float DO_ADD =			4;
+ float DO_VOID =			8;
+ 
+ /** MODIFIABLE CONSTANTS **/
+ 
+ // LM Quota Constants
+ // Quotas for the amounts of various items in levels.  LoadMod
+ // will add or remove items from the level (according to what
+ // options are set) in order to make the actual items in the level
+ // match the quotas. These are per player constants, ie, 0.4 armor
+ // means 4 total armors in a 10 player game.
+ 
+ float LMQUOTA_ARMOR =		0.4;
+ float LMQUOTA_HEALTH =		40;
+ // [BELOW NOT IMPLEMENTED]
+ float LMQUOTA_SHELLS =		10;
+ float LMQUOTA_SPIKES =		30;
+ float LMQUOTA_ROCKETS =		3; 
+ float LMQUOTA_CELLS =		20;
+ float LMQUOTA_WEAPONS =		0.8;
+ 
+ /** Globals **/
+ 
+ float loadmodCalled = 0; // whether loadmod has been called yet
+ 
+ float numPlayers; 	// number of players in the game
+ 
+ float itemtype;		// the current itemtype that actions are being performed for
+ float action;		// the current action to perform: init, switching item types,
+ 				// placing new items, cleanup.
+ 
+ //--------------------------//
+ // IDENTIFICATION FUNCTIONS //
+ //--------------------------//
+ 
+ /*
+ ================
+ LMIsAmmoHealth
+ 
+ Reports true if an entity is an ammo or health box
+ ================
+ */
+ float(string className) LMIsAmmoHealth =
+ {
+ 
+ 	if ((className == "item_shells") ||
+ 		(className == "item_spikes") ||
+ 		(className == "item_rockets") ||
+ 		(className == "item_cells") ||
+ 		(className == "item_health"))
+ 		return 1;
+ 	return 0;
+ };
+ 
+ /*
+ ================
+ LMIsWeaponArmor
+ 
+ Reports true if an entity is a weapon or armor
+ ================
+ */
+ float(string className) LMIsWeaponArmor =
+ {
+ 
+ 	if ((className == "weapon_supershotgun") ||
+ 		(className == "weapon_nailgun") ||
+ 		(className == "weapon_supernailgun") ||
+ 		(className == "weapon_grenadelauncher") ||
+ 		(className == "weapon_rocketlauncher") ||
+ 		(className == "weapon_lightning") ||
+ 		(className == "item_armor1") ||
+ 		(className == "item_armor2") ||
+ 		(className == "item_armorInv")) 
+ 		return 1;
+ 	return 0;
+ };
+ 
+ /*
+ ================
+ LMIsItem
+ 
+ Reports true if an entity is an "item" entity as opposed
+ to some non-item entity, such as an ambient sound or missile.
+ ================
+ */
+ float(string className) LMIsItem =
+ {
+ 
+ 	if ((className == "item_shells") ||
+ 		(className == "item_spikes") ||
+ 		(className == "item_rockets") ||
+ 		(className == "item_cells") ||
+ 		(className == "item_health") ||
+ 		(className == "weapon_supershotgun") ||
+ 		(className == "weapon_nailgun") ||
+ 		(className == "weapon_supernailgun") ||
+ 		(className == "weapon_grenadelauncher") ||
+ 		(className == "weapon_rocketlauncher") ||
+ 		(className == "weapon_lightning") ||
+ 		(className == "item_armor1") ||
+ 		(className == "item_armor2") ||
+ 		(className == "item_armorInv")) 
+ 		return 1;
+ 	return 0;
+ };
+ 
+ /*
+ ================
+ ItemOffset
+ 
+ Reports the offset required to place an item of "placingClass" on
+ exactly on top of an item of class "onClass".
+ ================
+ */
+ vector(string placingClass, string onClass) ItemOffset =
+ {
+ 	local float spawningWeapon, spawningHealth, onWeapon, onHealth;
+ 
+ 	spawningWeapon = LMIsWeaponArmor(placingClass);
+ 	spawningHealth = LMIsAmmoHealth(placingClass);
+ 	onWeapon = LMIsWeaponArmor(onClass);
+ 	onHealth = LMIsAmmoHealth(onClass);
+ 
+ 	if (spawningWeapon && onHealth) {
+ 		// spawning a weapon or armor on top of ammo or health
+ 		return '16 16 0';
+ 	} else if (spawningHealth && onWeapon) {
+ 		// spawning an ammo or health on top of a weapon or armor
+ 		return '-16 -16 0';
+ 	} else {
+ 		return '0 0 0';
+ 	}
+ 
+ };
+ 
+ //-------------------------//
+ // SPAWN CONTROL FUNCTIONS //
+ //-------------------------//
+ 
+ /*
+ ================
+ LMWalkAll
+ 
+ LMWalkAll walks the list of all entities and calls the touch
+ function of the entity argument, with "self" set to the entity
+ holding the touch function and other set to the current entity
+ in the list.
+ 
+ Example usage: pass in an entity with a touch function that with
+ do a sum of all rocket ammo in the level, by storing the sum in
+ a field in the entity.
+ ================
+ */
+ void(entity funcHolder) LMWalkAll =
+ {
+ 	local entity p;
+ 
+ 	p = nextent(world);
+ 	while (p != world) {
+ 		self = funcHolder;
+ 		other = p;
+ 		funcHolder.touch();
+ 		p = nextent(p);
+ 	}
+ };
+ 
+ /*
+ ================
+ LMWalkClass
+  
+ LMWalkAll walks the list of all entities of the class "className"
+ and calls the touch function of the entity argument, with "self" set
+ to the entity holding the touch function and other set to the current
+ entity in the list.
+ ================
+ */
+ void(string className, entity funcHolder) LMWalkClass =
+ {
+ 	local entity p;
+ 
+ 	p = find(world, classname, className);
+ 	while (p != world) {
+ 		self = funcHolder;
+ 		other = p;
+ 		funcHolder.touch();
+ 		p = find(p, classname, className);
+ 	}
+ };
+ 
+ /*
+ ================
+ LMSetVoided
+ 
+ LMSetVoided sets the "voided" field of all entities of the classes
+ given as arguments.  If className is to "null", all entities will
+ be set.  Entities marked as "voided" will be replaced or removed.
+ ================
+ */
+ void(float voidValue, string className, string className2,
+ 			string className3) LMSetVoided =
+ {
+ 	local entity p;
+ 
+ 	p = nextent(world);
+ 	while (p != world) {
+ 		if ((className == "null") ||
+ 			(p.classname == className) ||
+ 			(p.classname == className2) ||
+ 			(p.classname == className3))
+ 		{
+ 			p.voided = voidValue;
+ 		}
+ 		p = nextent(p);
+ 	}
+ };
+ 
+ /*
+ ================
+ LMReleaseVoided
+ 
+ LMReleaseVoided removes all voided entities from the entity list.
+ ================
+ */
+ void() LMReleaseVoided =
+ {
+ 	local entity p;
+ 
+ 	p = nextent(world);
+ 	while (p != world) {
+ 		if (p.voided) {
+ 			remove(p);
+ 		}
+ 		p = nextent(p);
+ 	}
+ };
+ 
+ //--------------------//
+ // SPAWNING FUNCTIONS //
+ //--------------------//
+ 
+ /*
+ ================
+ LMDoSpawn
+ 
+ Call the correct spawn function for "spawnClass".  Basically a big switch
+ statement, that I wish id had written as part of the spawn() built-in
+ ================
+ */
+ void(entity spawnEnt, string spawnClass) LMDoSpawn =
+ {
+ 
+ 	local entity holder;
+ 
+ 	spawnEnt.classname = spawnClass;
+ 
+ 	// store the value of "self" and set it for calling the spawn function
+ 	holder = self;
+ 	self = spawnEnt;
+ 
+ 	if (spawnClass == "item_armor1") {
+ 		item_armor1();
+ 	} else if (spawnClass == "item_armor2") {
+ 		item_armor2();
+ 	} else if (spawnClass == "item_armorInv") {
+ 		item_armorInv();
+ 	} else if (spawnClass == "item_health") {
+ 		item_health();
+ 	} else if (spawnClass == "weapon_supershotgun") {
+ 		weapon_supershotgun();
+ 	} else if (spawnClass == "weapon_nailgun") {
+ 		weapon_nailgun();
+ 	} else if (spawnClass == "weapon_supernailgun") {
+ 		weapon_supernailgun();
+ 	} else if (spawnClass == "weapon_grenadelauncher") {
+ 		weapon_grenadelauncher();
+ 	} else if (spawnClass == "weapon_rocketlauncher") {
+ 		weapon_rocketlauncher();
+ 	} else if (spawnClass == "weapon_lightning") {
+ 		weapon_lightning();
+ 	} else if (spawnClass == "item_shells") {
+ 		item_shells();
+ 	} else if (spawnClass == "item_spikes") {
+ 		item_spikes();
+ 	} else if (spawnClass == "item_rockets") {
+ 		item_rockets();
+ 	} else if (spawnClass == "item_cells") {
+ 		item_cells();
+ 	}
+ 
+ 	// reset self
+ 	self = holder;
+ 
+ };
+ 
+ // Spawn Cycling functions
+ // Set as touch functions for entities passed to item placement,
+ // routines these functions return in "stringResult" a classname
+ // to be spawned and in "funcResult" the amount that spawning an
+ // item of that class will reduce the quota.
+ 
+ /*
+ ================
+ LMTArmorSpawn
+ 
+ Touch function passed in for cycling through armors for spawning.
+ ================
+ */
+ void() LMTArmorSpawn =
+ {
+ 	if (self.status == 0) {
+ 		self.stringResult = "item_armorInv";
+ 		self.funcResult = 1;
+ 		self.status = 1;
+ 	} else if (self.status == 1) {
+ 		self.stringResult = "item_armor2";
+ 		self.funcResult = 1;
+ 		self.status = 2;
+ 	} else if (self.status == 2) {
+ 		self.stringResult = "item_armor1";
+ 		self.funcResult = 1;
+ 		self.status = 0;
+ 	}
+ };
+ 
+ /*
+ ================
+ LMTHealthSpawn
+ 
+ Touch function passed in for cycling through healths for spawning.
+ ================
+ */
+ void() LMTHealthSpawn =
+ {
+ 	self.stringResult = "item_health";
+ 	self.funcResult = 25;
+ };
+ 
+ //--------------------//
+ // COUNTING FUNCTIONS //
+ //--------------------//
+ 
+ /*
+ ================
+ LMClassCount
+ 
+ Return the number of entities in the game of a certain class,
+ eg, "item_armor1".
+ ================
+ */
+ float(string class) LMClassCount =
+ {
+ 	local entity p;
+ 	local float result;
+ 
+ 	result = 0;
+ 
+ 	if (class != "null") {
+ 		p = find (world, classname, class);
+ 		while(p != world)
+ 		{
+ 			if (!p.voided) {
+ 				result = result + 1;
+ 			}
+ 			p = find(p, classname, class);
+ 		}
+ 	}
+ 	return result;
+ };
+ 
+ /*
+ ================
+ LMClassCountMulti
+ 
+ Return the number of entities in the game of class
+ "class", "class2" or "class3"
+ ================
+ */
+ float(string class, string class2, string class3) LMClassCountMulti =
+ {
+ 	local float result;
+ 
+ 	if (class != "null") {
+ 		result = LMClassCount(class);
+ 	}
+ 
+ 	if (class2 != "null") {
+ 		result = result + LMClassCount(class2);
+ 	}
+ 
+ 	if (class3 != "null") {
+ 		result = result + LMClassCount(class3);
+ 	}
+ 	return result;
+ };
+ 
+ //--------------------//
+ // CRITERIA FUNCTIONS //
+ //--------------------//
+ 
+ /*
+ ================
+ LMDistanceToNearestAvoid
+ 
+ Walks the entire entity list, finding the closest entity
+ to "position" that "avoidID.touch()" identifies as being important.
+ 
+ "avoidID" is an entity whose .touch() function will set 
+ self.funcResult to TRUE (1) if "self" is a entity that
+ should be considered an entity to avoid (and thus calculate
+ nearness to).
+ ================
+ */
+ float(vector position, entity avoidID) LMDistanceToNearestAvoid =
+ {
+ 	local float entDistance, nearestDistance;
+ 	local entity near, holder;
+ 
+ 	nearestDistance = 60000;
+ 
+ 	near = nextent(world);
+ 	while(near != world)
+ 	{
+ 		holder = self;
+ 		// HACK BLUDGEON MAIM
+ 		// set "self" to the current entity in the list
+ 		// walk, and call avoidID's touch function, 
+ 		// effectively on "near"
+ 		self = near;
+ 		avoidID.touch();
+ 
+ 		self = holder;
+ 
+ 		// NOTE: avoidID's touch function actually set a
+ 		// field in "near", since the global "self" was set
+ 		// to "near" when avoidID.touch was called.
+ 		if (near.funcResult) {
+ 			entDistance = vlen(position - near.origin);
+ 			if ((entDistance < nearestDistance) && !near.voided)
+ 				nearestDistance = entDistance;
+ 		}
+ 		near = nextent(near);
+ 	}
+ 
+ 	return nearestDistance;
+ 
+ };
+ 
+ //----------------------------------//
+ // TOUCH FUNCTIONS FOR LIST WALKING //
+ //----------------------------------//
+ 
+ /*
+ ================
+ LMTHealthAmount
+ ================
+ */
+ void() LMTHealthAmount =
+ {
+ 	local string s;
+ 
+ 	if (other.spawnflags & H_ROTTEN) {
+ 		self.funcResult = self.funcResult + 15;
+ 	} else if (other.spawnflags & H_MEGA) {
+ 		// don't count mega healths as part of normal
+ 		// restoration health.  It's considered a powerup.
+ 		return;
+ 	} else {
+ 		self.funcResult = self.funcResult + 25;
+ 	}
+ };
+ 
+ /*
+ ================
+ LMTAmmoAmount
+ ================
+ */
+ void() LMTAmmoAmount =
+ {
+ 	self.funcResult = self.funcResult + other.aflag;
+ };
+ 
+ 
+ /*
+ ==================================
+ LMTRemoveSpawns
+ 
+ Remove all deathmatch spawn spots that are
+ within a certain radius of CTF flags
+ ==================================
+ */
+ void() LMTRemoveSpawns =
+ {
+ 	local entity list, temp;
+ 
+ 	list = findradius(other.origin, 400);
+ 	while (list != world) {
+ 		if ((list.classname == "item_flag_team1") ||
+ 			(list.classname == "item_flag_team2")) {
+ 			remove(other);
+ 			return;
+ 		} else {
+ 			list = list.chain;
+ 		}
+ 	}
+ 
+ };
+ 
+ //-------------------------------------//
+ // THINK FUNCTIONS FOR PLACER ENTITIES //
+ //-------------------------------------//
+ 
+ /*
+ ================
+ LMAny_Avoid
+ 
+ Items to avoid when placing any item - powerups and megahealths.
+ "self" must be set to the item to be checked.
+ ================
+ */
+ float() LMAny_Avoid =
+ {
+ 	if (self.classname == "item_artifact_invulnerability" ||
+ 		self.classname == "item_artifact_super_damage" ||
+ 		self.classname == "item_artifact_invisibility" ||
+ 		(self.classname == "item_health" && self.spawnflags & H_MEGA))
+ 		return 1;
+ 	return 0;
+ };
+ 
+ /*
+ ================
+ LMTHealth_Avoid
+ 
+ Function that identifies items to be avoided when
+ placing health packs.
+ ================
+ */
+ void() LMTHealth_Avoid =
+ {
+ 	if (self.classname == "item_health" ||
+ 		LMAny_Avoid()) 
+ 	{
+ 		self.funcResult = 1;
+ 		return;
+ 	}
+ 	self.funcResult = 0;
+ 	return;
+ };
+ 
+ /*
+ ================
+ LMTArmor_Avoid
+ 
+ Function that identifies items to be avoided when
+ placing armors.
+ ================
+ */
+ void() LMTArmor_Avoid =
+ {
+ 	if (self.classname == "item_armor1" ||
+ 		self.classname == "item_armor2" ||
+ 		self.classname == "item_armorInv" ||
+ 		LMAny_Avoid()) 
+ 	{
+ 		self.funcResult = 1;
+ 		return;
+ 	}
+ 	self.funcResult = 0;
+ 	return;
+ };
+ 
+ void() LMThink_Control;
+ 
+ /*
+ ================
+ LMThink_Spawn
+ ================
+ */
+ void() LMThink_Spawn =
+ {
+ 	local string spawnClass;	
+ 	local entity holder, spawnEnt;
+ 	local vector position;
+ 
+ 	// determine the kind of item to spawn
+ 	holder = self;
+ 	self = self.spawnInfo;
+ 	self.touch();
+ 	self = holder;
+ 
+ 	spawnClass = self.spawnInfo.stringResult;
+ 	self.quotagap = self.quotagap - self.spawnInfo.funcResult;
+ 
+ 	// origin adjustment to prevent items falling out of level.
+ 	position = self.bestentity.origin + ItemOffset(spawnClass, self.bestentity.classname);
+ 
+ 	if (self.bestentity.voided) {
+ 		// overwrite (become) the entity with the best position
+ 		spawnEnt = self.bestentity;
+ 		spawnEnt.voided = 0;
+ 		setorigin(spawnEnt, position);
+ 	} else {
+ 		// create a new entity directly on top of 
+ 		// the entity with the best position
+ 		spawnEnt = spawn();
+ 		setorigin(spawnEnt, position);
+ 	}
+ 
+ 	LMDoSpawn(spawnEnt, spawnClass);
+ 
+ /*
+ 	dprint("\nSpawning an item of class ");
+ 	dprint(spawnClass);
+ 	if (self.bestentity.voided) {
+ 		dprint(" in place of an ");
+ 	} else {
+ 		dprint(" on top of an ");
+ 	}
+ 	dprint(self.bestentity.classname);
+ 	dprint("\nLocation is ");
+ 	s = vtos(self.bestentity.origin);
+ 	dprint(s);
+ 	dprint(", nearest similar entity is ");
+ 	s = ftos(self.bestdistance);
+ 	dprint(s);
+ 	dprint(" away\n\n");
+ */
+ 
+ 	self.nextthink = time + 0.1;
+ 	self.think = LMThink_Control;
+ 
+ };
+ 
+ /*
+ ================
+ LMThink_Place
+ ================
+ */
+ void() LMThink_Place =
+ {
+ 	local entity p, identifier;
+ 	local string s;
+ 	local float thisDistance;	
+ 
+ 	self.searchPos = nextent(self.searchPos);
+ 	p = self.searchPos;
+ 
+ 	while ((p != world) && !LMIsItem(p.classname)) {
+ 		// go through the entire entire entity list until we hit either an 
+ 		// item (which is a potential spawn point) or the end of the list (world).
+ 		p = nextent(p);
+ 	}
+ 
+ 	if (p != world) {
+ 
+ 		thisDistance = LMDistanceToNearestAvoid(p.origin, self.avoider);
+ 
+ 		// find the entity furthest from the nearclasses, but
+ 		// prefer voided entities 100% over non-voided
+ 		if ((thisDistance > self.bestdistance) &&
+ 			!(self.bestentity.voided && !p.voided))
+ 		{
+ 			self.bestdistance = thisDistance;
+ 			self.bestentity = p;
+ 		}
+ 
+ 	} else {
+ 		self.think = LMThink_Spawn;
+ 	}
+ 	self.nextthink = time + 0.1;
+ 
+ };
+ 
+ /*
+ ================
+ LMThink_Control
+ ================
+ */
+ void() LMThink_Control =
+ {
+ 	local entity holder;
+ 
+ 	if (self.quotagap > 0) {
+ 
+ 	holder = self;
+ 	self = self.spawnInfo;
+ 	self.touch();
+ 	self = holder;
+ 		self.nextthink = time + 0.1;
+ 		self.think = LMThink_Place;
+ 		self.bestdistance = 0;
+ 		self.searchPos = world;
+ 	} else {
+ 		self.think = SUB_Remove;
+ 		self.nextthink = time + 110;
+ 		self.avoider.think = SUB_Remove;
+ 		self.avoider.nextthink = time + 105;
+ 		self.spawnInfo.think = SUB_Remove;
+ 		self.spawnInfo.nextthink = time + 100;
+ /*
+ 		remove(self.avoider);
+ 		remove(self.spawnInfo);
+ 		remove(self);
+ */
+ 	}
+ };
+ 
+ /*
+ ================
+ LMThink_Armor
+ ================
+ */
+ void() LMThink_Armor =
+ {
+ 	local string s;
+ 	local entity funcHolder, placer;
+ 
+ 	// set up the spawning function for armors
+ 	placer = spawn();
+ 	placer.classname = "placer";
+ 
+ 	// determine if quota for armors is met
+ 	placer.quotagap = (LMQUOTA_ARMOR * numPlayers) -
+ 			LMClassCountMulti("item_armor1", "item_armor2", "item_armorInv");
+ 	placer.quotagap = rint(placer.quotagap);
+ 
+ 	// identifier function entity - this is what causes this
+ 	// placer to avoid other armors (and other items) when placing
+ 	placer.avoider = spawn();
+ 	placer.avoider.classname = "info_avoid_armor";
+ 	placer.avoider.touch = LMTArmor_Avoid;
+ 
+ 	// spawner function entity - this is what causes this
+ 	// placer to place armors (in a cycle)
+ 	placer.spawnInfo = spawn();
+ 	placer.spawnInfo.classname = "info_spawn_armor";
+ 	placer.spawnInfo.touch = LMTArmorSpawn;
+ 
+ 	// start placing
+ 	placer.think = LMThink_Control;
+ 	placer.nextthink = time + 0.1;
+ 
+ 	remove(self);
+ 
+ };
+ 
+ /*
+ ================
+ LMThink_Health
+ ================
+ */
+ void() LMThink_Health =
+ {
+ 	local string s;
+ 	local entity funcHolder, placer;
+ 
+ 	// determine if the quota for health is met
+ 	// create an entity to hold the summing function
+ 	funcHolder = spawn();
+ 	funcHolder.touch = LMTHealthAmount;
+ 	LMWalkClass("item_health", funcHolder);
+ 
+ 	// set up the spawning function for health
+ 	placer = spawn();
+ 	placer.classname = "placer";
+ 	placer.quotagap = (LMQUOTA_HEALTH * numPlayers) - funcHolder.funcResult;
+ 	placer.quotagap = rint(placer.quotagap);
+ 	remove(funcHolder);
+ 
+ 	// identifier function entity - this is what causes this
+ 	// placer to avoid other armors (and other items) when placing
+ 	placer.avoider = spawn();
+ 	placer.avoider.classname = "info_avoid_health";
+ 	placer.avoider.touch = LMTHealth_Avoid;
+ 
+ 	// spawner function entity - this is what causes this
+ 	// placer to place armors (in a cycle)
+ 	placer.spawnInfo = spawn();
+ 	placer.spawnInfo.classname = "info_spawn_health";
+ 	placer.spawnInfo.touch = LMTHealthSpawn;
+ 
+ 	// start placing
+ 	placer.think = LMThink_Control;
+ 	placer.nextthink = time + 0.1;
+ 
+ 	remove(self);
+ };
+ 
+ /*
+ ================
+ LoadMod
+ 
+ An ambitious function :) Goes through the list of entities in the map and
+ modifies it to produce a more balanced game with less shortages.  There are
+ a set of quotas for each set of items of a kind, for instance armor.
+ 
+ When items need to be added according to quotas, the added items will be
+ added at the item-entity position furthest from all other items of the same 
+ type as the item being added.
+ ================
+ */
+ void() LoadMod =
+ {
+ 	local string s;
+ 	local entity funcHolder, placer;
+ 
+ 	// flag to ensure a single call
+ 	loadmodCalled = 1;
+ 
+ 	// grab the bitvector for controlling loading modifications
+ 	s = infokey(world, "loadmod");
+ 	loadmod = stof(s);
+ 
+ 	if (loadmod > 0) {
+ 
+ 		// determine number of clients
+ 		s = infokey(world, "maxclients");
+ 		numPlayers = stof(s);
+ 
+ 		// if REDO_ITEMS is set, mark all items in the map as "voided",
+ 		// so they will be replaced by items created to fulfill quotas
+ 	//	if (loadmod & LM_REDO_ITEMS) {
+ 	//		LMSetVoided(1, "null", "null", "null");
+ 	//	} else {
+ 	//		LMSetVoided(0, "null", "null", "null");
+ 	//	}
+ 
+ 		// set all entities as not voided
+ 		LMSetVoided(0, "null", "null", "null");
+ 
+ 		// remove deathmatch spawns near CTF bases
+ 		if (loadmod & LM_REMOVE_BASE_SPAWNS) {
+ 			funcHolder = spawn();
+ 			funcHolder.touch = LMTRemoveSpawns;
+ 		
+ 			LMWalkClass("info_player_deathmatch", funcHolder);
+ 
+ 			remove(funcHolder);
+ 		}
+ 
+ 		// release all entities that are voided
+ 		LMReleaseVoided();
+ 
+ 		if (loadmod & LM_QUOTA_ADD) {
+ 			// create entities to place additional items
+ 			funcHolder = spawn();
+ 			funcHolder.classname = "armorSpawner";
+ 			funcHolder.think = LMThink_Armor;
+ 			funcHolder.nextthink = time + 0.1;
+ 	
+ 			funcHolder = spawn();
+ 			funcHolder.classname = "healthSpawner";
+ 			funcHolder.think = LMThink_Health;
+ 			funcHolder.nextthink = time + 0.1;
+ 		}
+ 
+ 	}
+ 
+ };
\ No newline at end of file
diff -crbB --unidirectional-new-file qw201/motd.qc expert12/motd.qc
*** qw201/motd.qc	Thu Jan  1 00:00:00 1970
--- expert12/motd.qc	Sun Aug 17 01:47:18 1997
***************
*** 0 ****
--- 1,274 ----
+ /** MODIFIABLE CONSTANTS **/
+ 
+ // *TEAMPLAY*
+ float   FL_SPAWNVIEWED			= 16384; // if we've seen the spawn message
+ 
+ // Expert
+ float   FL_JUSTCONNECTED		= 32768; // just connected or reconnected to the server
+ float   FL_FIRSTCONNECT			= 65536; // first connection to the server
+ 
+ /** End of MODIFIABLE CONSTANTS **/
+ 
+ /*
+ ================
+ SpawnMessage
+ 
+ Think function for spawnobj.  Display the spawn message
+ and destroys itself.
+ ================
+ */
+ void() SpawnMessage =
+ {	
+ 	local string mode;
+ 
+ 	if (ctf) {
+ 		mode = "-Expert CTF-\n";
+ 	} else if (teamplay) {
+ 		mode = "-Expert Teamplay-\n";
+ 	} else {
+ 		mode = "-Expert Deathmatch-\n";
+ 	}
+ 	sprint(self.owner, PRINT_HIGH, mode);
+ 	sprint(self.owner, PRINT_HIGH, "\"settings\" for current settings.\n\"motd\" to redisplay MOTD\n");
+ 	sprint(self.owner, PRINT_HIGH, "\"serverhelp\" for server help\n");
+ 
+ 	remove(self);
+ };
+ 
+ /*
+ ================
+ CreateSpawnObj
+ 
+ Create an entity that will display the spawn message for a player.
+ ================
+ */
+ void() CreateSpawnObj = 
+ {
+ 	local entity intro;
+ 
+ 	intro = spawn ();
+ 	intro.classname = "spawn";
+ 	intro.think = SpawnMessage;
+ 	intro.nextthink = time + 0.2;
+ 	intro.owner = self;
+ };
+ 
+ /*
+ ================
+ Intro_Think
+ 
+ Display the MOTD repeatedly for a few seconds,
+ then remove self.
+ ================
+ */
+ void() Intro_Think = 
+ {
+ 	local string mode, ctfonly, weaponsonly, s;
+ 
+ 	if (self.attack_finished < time)
+ 		remove (self);
+ 	else {
+ 		ctfonly = "";
+ 		/* Servers!  Add your motd here! */
+ 		if (ctf) {
+ 			mode = "-Expert CTF-";
+ 			ctfonly = "\n\n\"speech\" for CTF Team Radio\nhelp system\n";
+ 		} else if (teamplay) {
+ 			mode = "-Expert Teamplay-";
+ 		} else {
+ 			mode = "-Expert Deathmatch-";
+ 		}
+ 		if ((deathmatch & DM_WEAPON_MODES) && !(deathmatch & DM_ALTERNATES_ONLY))
+ 			weaponsonly = "impulse 210 switches\nweapon mode\n";
+ 		centerprint7(self.owner, mode, 
+ 				"\n\n\"settings\" for current settings.\n",
+ 				"\"motd\" to redisplay MOTD\n",
+ 				"\"serverhelp\" for server help\n\n",
+ 				"impulse 71-79: status bar placement\nimpulse 70: status bar off\nimpulse 81: QW2 statusbar\n",
+ 				weaponsonly,
+ 				ctfonly);
+ 
+ 		self.owner.statustime = time + 2;
+ 	}
+ 
+ 	self.nextthink = time + 0.7;
+ };
+ 
+ /*
+ ================
+ Message_Think
+ 
+ Display the MOTD repeatedly for a few seconds,
+ then remove self.
+ ================
+ */
+ void() Message_Think = 
+ {
+ 	local entity temp;
+ 
+ 	if (self.attack_finished < time)
+ 		remove (self);
+ 	else {
+ 		temp = self;
+ 		self = self.owner;
+ 		temp.touch();
+ 		self = temp;
+ 		self.owner.statustime = time + 2;
+ 	}
+ 
+ 	self.nextthink = time + 0.7;
+ };
+ 
+ /*
+ ================
+ SetupMessageObj
+ 
+ Setup a messageObj.  A messageObj will repeatedly call it's .touch()
+ function every 0.7 seconds and then remove itself after "duration"
+ seconds.
+ 
+ Set the messageObj's .touch() function to a function that centerprints
+ to "self.owner" to get a centerprint to stay on the screen for "duration".
+ ================
+ */
+ void(entity messageObj, entity printTarget, float duration) SetupMessageObj = 
+ {
+ 
+ 	messageObj.classname = "message_object";
+ 	messageObj.think = Message_Think;
+ 	messageObj.nextthink = time + 0.1;
+ 	messageObj.owner = printTarget;
+ 	// this is when the object will remove itself
+ 	messageObj.attack_finished = time + duration;
+ };
+ 
+ /*
+ ================
+ CreateMOTDObj
+ 
+ Create an entity that will display the MOTD for a player.
+ ================
+ */
+ void() CreateMOTDObj = 
+ {
+ 	local entity intro;
+ 
+ 	intro = spawn ();
+ 	intro.classname = "intro";
+ 	intro.think = Intro_Think;
+ 	intro.nextthink = time + 0.2;
+ 	intro.owner = self;
+ 	// this is when the object will remove itself
+ 	intro.attack_finished = time + 6;
+ };
+ 
+ /*
+ ==================================
+ AudioTutorial
+ 
+ Tell people how to use the team audio messages
+ and remind them which messages are bound to which
+ keys and impulses. 
+ ==================================
+ */
+ void() AudioTutorial =
+ {
+ 	sprint(self, PRINT_HIGH, "TEAM RADIO SYSTEM\n\n");
+ 
+ 	sprint(self, PRINT_HIGH, "Messages are sent ONLY to teammates.  ");
+ 	if (ctf)
+ 		sprint(self, PRINT_HIGH, "\"Global\" messages go to the entire team.  ");
+ 	sprint(self, PRINT_HIGH, "\"Local\" messages go to players within short range.");
+ 	sprint(self, PRINT_HIGH, "\n\n");
+ 
+ 	sprint(self, PRINT_HIGH, "impulse 160 will bind f5-f12 to the audio messages listed.  Alternately, you can bind whatever keys you choose to the impulse listed by each message\n\n");
+ 
+ 	if (ctf)
+ 		sprint(self, PRINT_HIGH, "TEAM GLOBAL MESSAGES\n----------------------- ---      ---\nBase status query       F5       161\nBase clear              F6       162\nBase under attack       F7       163\nBase overrun            F8       164\n\n");
+ 		sprint(self, PRINT_HIGH, "TEAM LOCAL MESSAGES\n----------------------- ---      ---\nGather for attack       F9       165\nAttack now              F10      166\nIncoming hostiles       F11      167\nCover me                F12      168\n\n");
+ 
+ 	sprint(self, PRINT_HIGH, "To bring up these tables for quick reference, use impulses 180 and 181.\n\n");
+ 
+ 	if (ctf)
+ 		sprint(self, PRINT_HIGH, "For usage info for globals, type \"usage\".\n");
+ 
+ };
+ 
+ /*
+ ==================================
+ AudioUsage
+ 
+ Tell people how to use the team audio messages
+ and remind them which messages are bound to which
+ keys and impulses. 
+ ==================================
+ */
+ void() AudioUsage =
+ {
+ 	sprint(self, PRINT_HIGH, "Each Team Audio message means a specific action that teammates should take.\n\n");
+ 
+ 	sprint(self, PRINT_HIGH, "KEY    MEANING\n----------------------------------\n");
+ 	sprint(self, PRINT_HIGH, "F5     Defenders report status\n");
+ 	sprint(self, PRINT_HIGH, "F6     Base clear for carrier return\n");
+ 	sprint(self, PRINT_HIGH, "F7     Base not clear for return\n");
+ 	sprint(self, PRINT_HIGH, "F8     Any free players come to base\n");
+ 
+ };
+ 
+ /*
+ ================
+ ServerHelp
+ 
+ Display help for Expert Deathmatch/Teamplay
+ ================
+ */
+ void() ServerHelp =
+ {
+ 	sprint(self, PRINT_HIGH, "EXPERT QUAKE HELP FILE\n\n");
+ 
+ 	sprint(self, PRINT_HIGH, "Expert Quake is all about creating a balanced game in which skill is emphasized.\n");
+ 	sprint(self, PRINT_HIGH, "Expert Quake website\nhttp://www.planetquake.com/expert/\n\n");
+ 
+ 	sprint(self, PRINT_HIGH, "Use impulse 71-79 to set your status bar's position, or impulse 70 to turn it ");
+ 	sprint(self, PRINT_HIGH, "off.  Or, directly set the status bar for your vertical resolution like so:\n\n");
+ 
+ 	sprint(self, PRINT_HIGH, "setinfo statusbar 384\n\n");
+ 
+ 	sprint(self, PRINT_HIGH, "impulse 81 toggles QW 2.0 status bar.  You can also use\n\n");
+ 
+ 	sprint(self, PRINT_HIGH, "setinfo hud2 1\n\n");
+ 
+ 	if (ctf) {
+ 		sprint(self, PRINT_HIGH, "Flag carriers no longer glow because of the huge drop in framerate this causes. ");
+ 		sprint(self, PRINT_HIGH, "Instead, the flag emits a periodic \"flag flapping in the wind\" noise to allow ");
+ 		sprint(self, PRINT_HIGH, "carriers to be hunted effectively.\n\n");
+ 	}
+ 
+ 	if (deathmatch & DM_GRAPPLE) {
+ 		sprint(self, PRINT_HIGH, "In order to use the Expert hook, bind a key to \"+hook\".  A good key to ");
+ 		sprint(self, PRINT_HIGH, "bind is your right or middle mouse button (mouse2 or mouse3).  Here's ");
+ 		sprint(self, PRINT_HIGH, "how to bind a your right mouse button:\n\n");
+ 	
+ 		sprint(self, PRINT_HIGH, "bind mouse2 \"+hook\"\n\n");
+ 
+ 		sprint(self, PRINT_HIGH, "You can no longer use the grapple to hook enemy players and hang on.  ");
+ 		sprint(self, PRINT_HIGH, "You also can not hang on to surfaces for more than three seconds, so ");
+ 		sprint(self, PRINT_HIGH, "that the hook cannot be used for camping or ambushing.\n\n");
+ 	}
+ 
+ 	sprint(self, PRINT_HIGH, "Use PGUP (page up) and PGDN (page down) to scroll back\n");
+ 
+ };
+ 
+ /*
+ ================
+ GrappleTutorial
+ 
+ Tell people how to use the Expert Hook if they try to use impulses
+ for old hook, or if they try to "hit axe twice".
+ ================
+ */
+ void() GrappleTutorial =
+ {
+ 	centerprint(self, "TO USE THE HOOK\n\nBIND A KEY TO\n\n\"+HOOK\"\n\nFOR EXAMPLE\n\nbind mouse2 +hook\n\n");
+ };
\ No newline at end of file
diff -crbB --unidirectional-new-file qw201/player.qc expert12/player.qc
*** qw201/player.qc	Sun Jul 27 20:49:10 1997
--- expert12/player.qc	Sat Aug 16 05:09:50 1997
***************
*** 1,5 ****
--- 1,7 ----
  
  void() bubble_bob;
+ void() player_chain5;
+ void() player_chain4;
  
  /*
  ==============================================================================
***************
*** 173,193 ****
  void()  player_axed3 =  [$axattd3, player_axed4 ] {self.weaponframe=7;W_FireAxe();};
  void()  player_axed4 =  [$axattd4, player_run   ] {self.weaponframe=8;};
  
  
  //============================================================================
  
  void() player_nail1   =[$nailatt1, player_nail2  ] 
  {
  	muzzleflash();
  
! 	if (!self.button0 || intermission_running || self.impulse)
  		{player_run ();return;}
  	self.weaponframe = self.weaponframe + 1;
  	if (self.weaponframe == 9)
  		self.weaponframe = 1;
  	SuperDamageSound();
  	W_FireSpikes (4);
  	self.attack_finished = time + 0.2;
  };
  void() player_nail2   =[$nailatt2, player_nail1  ]
  {
--- 175,260 ----
  void()  player_axed3 =  [$axattd3, player_axed4 ] {self.weaponframe=7;W_FireAxe();};
  void()  player_axed4 =  [$axattd4, player_run   ] {self.weaponframe=8;};
  
+ // Expert DM
+ // Throwing axe frames
+ void()  w2player_axe1 =   [$axatt1, w2player_axe2   ] {self.weaponframe=4;};
+ void()  w2player_axe2 =   [$axatt2, w2player_axe3   ] {self.weaponframe=0;self.weaponmodel="";};
+ void()  w2player_axe3 =   [$axatt3, w2player_axe4   ] {self.weaponframe=0;};
+ void()  w2player_axe4 =   [$axatt4, w2player_axe5   ] {self.weaponframe=1;self.weaponmodel="progs/v_axe.mdl";};
+ void()  w2player_axe5 =   [$axatt5, w2player_axe6   ] {self.weaponframe=2;};
+ void()  w2player_axe6 =   [$axatt6, player_run    ] {self.weaponframe=0;};
+ 
+ //============================================================================
+ void()  player_chain1=  [$axattd1, player_chain2 ] {self.weaponframe=2;Throw_Grapple();};
+ void()  player_chain2=  [$axattd2, player_chain3 ] {self.weaponframe=3;};
+ void()  player_chain3=  [$axattd3, player_chain3 ]
+ {
+ 
+ 
+         self.weaponframe=3;
+         if (!self.hook_out)
+         {
+                 player_chain5();
+                 return;
+         }
+         if (vlen(self.velocity) >= 750)
+         {
+                player_chain4();
+                 return;
+         }
+ };
+ 
+ void() player_chain4=  [$deathc4, player_chain4 ]
+ {
+         self.weaponframe=4;
+         if (!self.hook_out)
+         {
+                 player_chain5();
+                 return;
+         }
+         if (vlen(self.velocity) < 750)
+         {
+                 player_chain3();
+                 return;
+         }
+ };
+ 
+ void()  player_chain5=  [$axattd4, player_run    ] {self.weaponframe=5;};
+ 
+ //============================================================================
  
  //============================================================================
  
  void() player_nail1   =[$nailatt1, player_nail2  ] 
  {
+ 	// Expert DM
+ 	// Reduce surface redraw from muzzleflash
+ 	if (!(deathmatch & DM_PERFORMANCE))
  		muzzleflash();
  
! 	// Expert DM
! 	// SwitchFire fix
! 	if ((!self.button0 && !self.switchfiring) || intermission_running || self.impulse)
  		{player_run ();return;}
  	self.weaponframe = self.weaponframe + 1;
  	if (self.weaponframe == 9)
  		self.weaponframe = 1;
+ 
+ 	// Expert DM
+ 	// Fire only 2/3 as many nails, where each nail will do
+ 	// 3/2 the damage.  Play sound even when nails aren't fired.
+ 	if ((deathmatch & DM_PERFORMANCE) && (self.nailnum == 2)) {
+ 		// pretend to fire a nail: play sound, subtract ammo
+ 		FakeNail();
+ 		self.nailnum = 0;
+ 	} else {
+ 		// actually fire a nail
  		SuperDamageSound();
  		W_FireSpikes (4);
+ 		self.nailnum = self.nailnum + 1;
+ 	}
  	self.attack_finished = time + 0.2;
+ 
  };
  void() player_nail2   =[$nailatt2, player_nail1  ]
  {
***************
*** 191,206 ****
  };
  void() player_nail2   =[$nailatt2, player_nail1  ]
  {
  	muzzleflash();
  
! 	if (!self.button0 || intermission_running || self.impulse)
  		{player_run ();return;}
  	self.weaponframe = self.weaponframe + 1;
  	if (self.weaponframe == 9)
  		self.weaponframe = 1;
  	SuperDamageSound();
  	W_FireSpikes (-4);
  	self.attack_finished = time + 0.2;
  };
  
  //============================================================================
--- 258,291 ----
  };
  void() player_nail2   =[$nailatt2, player_nail1  ]
  {
+ 	// Expert DM
+ 	// Reduce surface redraw from muzzleflash
+ 	if (!(deathmatch & DM_PERFORMANCE))
  		muzzleflash();
  
! 	// Expert DM
! 	// SwitchFire fix
! 	if ((!self.button0 && !self.switchfiring) || intermission_running || self.impulse)
  		{player_run ();return;}
  	self.weaponframe = self.weaponframe + 1;
  	if (self.weaponframe == 9)
  		self.weaponframe = 1;
+ 	
+ 	// Expert DM
+ 	// Fire only 2/3 as many nails, where each nail will do
+ 	// 3/2 the damage.  Play sound even when nails aren't fired.
+ 	if ((deathmatch & DM_PERFORMANCE) && (self.nailnum == 2)) {
+ 		// pretend to fire a nail: play sound, subtract ammo
+ 		FakeNail();
+ 		self.nailnum = 0;
+ 	} else {
+ 		// actually fire a nail
  		SuperDamageSound();
  		W_FireSpikes (-4);
+ 		self.nailnum = self.nailnum + 1;
+ 	}
  	self.attack_finished = time + 0.2;
+ 
  };
  
  //============================================================================
***************
*** 207,215 ****
  
  void() player_light1   =[$light1, player_light2  ] 
  {
  	muzzleflash();
  
! 	if (!self.button0 || intermission_running)
  		{player_run ();return;}
  	self.weaponframe = self.weaponframe + 1;
  	if (self.weaponframe == 5)
--- 292,303 ----
  
  void() player_light1   =[$light1, player_light2  ] 
  {
+ 	// Expert DM
+ 	// Reduce surface redraw from muzzleflash
+ 	if (!(deathmatch & DM_PERFORMANCE))
  		muzzleflash();
  
! 	if ((!self.button0 && !self.switchfiring) || intermission_running || self.impulse)
  		{player_run ();return;}
  	self.weaponframe = self.weaponframe + 1;
  	if (self.weaponframe == 5)
***************
*** 220,234 ****
  };
  void() player_light2   =[$light2, player_light1  ]
  {
  	muzzleflash();
  
! 	if (!self.button0 || intermission_running)
  		{player_run ();return;}
  	self.weaponframe = self.weaponframe + 1;
  	if (self.weaponframe == 5)
  		self.weaponframe = 1;
  	SuperDamageSound();
  	W_FireLightning();
  	self.attack_finished = time + 0.2;
  };
  
--- 309,330 ----
  };
  void() player_light2   =[$light2, player_light1  ]
  {
+ 	// Expert DM
+ 	// Reduce surface redraw from muzzleflash
+ 	if (!(deathmatch & DM_PERFORMANCE))
  		muzzleflash();
  
! 	if ((!self.button0 && !self.switchfiring) || intermission_running || self.impulse)
  		{player_run ();return;}
  	self.weaponframe = self.weaponframe + 1;
  	if (self.weaponframe == 5)
  		self.weaponframe = 1;
+ 	// Expert
+ 	// Fire only every other frame, at double damage
+ 	if (!(deathmatch & DM_PERFORMANCE)) {
  		SuperDamageSound();
  		W_FireLightning();
+ 	}
  	self.attack_finished = time + 0.2;
  };
  
***************
*** 555,561 ****
  		{
  			DropQuad (self.super_damage_finished - time);
  			bprint (PRINT_LOW, self.netname);
! 			if (deathmatch == 4)
  				bprint (PRINT_LOW, " lost an OctaPower with ");
  			else
  				bprint (PRINT_LOW, " lost a quad with ");
--- 651,659 ----
  		{
  			DropQuad (self.super_damage_finished - time);
  			bprint (PRINT_LOW, self.netname);
! 			if (deathmatch & DM_ALTERNATE_POWERUPS)
! 				bprint (PRINT_LOW, " lost a glyph with ");
! 			else if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  				bprint (PRINT_LOW, " lost an OctaPower with ");
  			else				
  				bprint (PRINT_LOW, " lost a quad with ");
***************
*** 578,590 ****
--- 676,708 ----
  		}
  	}
  
+ 	if (((stof(infokey(world,"dp"))) != 0) && (deathmatch & DM_ALTERNATE_POWERUPS))
+ 	{
+ 		if (self.invincible_finished > 0)
+ 		{
+ 			bprint (PRINT_LOW, self.netname);
+ 			bprint (PRINT_LOW, " lost a pentagram with ");
+ 			s = ftos(rint(self.invincible_finished - time));
+ 			bprint (PRINT_LOW, s);
+ 			bprint (PRINT_LOW, " seconds remaining\n");
+ 			DropPent (self.invincible_finished - time);
+ 		}
+ 	}
+ 
  	self.invisible_finished = 0;    // don't die as eyes
  	self.invincible_finished = 0;
  	self.super_damage_finished = 0;
  	self.radsuit_finished = 0;
  	self.modelindex = modelindex_player;    // don't use eyes
  
+ 	// Reset hook if out
+ 	if (self.hook_out)
+ 		Reset_Grapple(self);
+ 
  	DropBackpack();
+ 	// CTF
+ 	if (ctf)
+ 		TeamCaptureDropFlagOfPlayer(self);
  
  	self.weaponmodel="";
  	self.view_ofs = '0 0 -8';
diff -crbB --unidirectional-new-file qw201/progs.src expert12/progs.src
*** qw201/progs.src	Tue Aug 12 21:27:52 1997
--- expert12/progs.src	Wed Aug 13 20:31:16 1997
***************
*** 1,9 ****
--- 1,19 ----
  ../qwprogs.dat
  
  defs.qc
+ expdefs.qc
  subs.qc
+ teamplay.qc
+ weapons2.qc
+ dm.qc
+ ctf.qc
+ ident.qc
+ status.qc
+ motd.qc
  combat.qc
  items.qc
+ loadmod.qc
+ grapple.qc      // Wedge
  weapons.qc
  world.qc
  client.qc
diff -crbB --unidirectional-new-file qw201/qcc.bat expert12/qcc.bat
*** qw201/qcc.bat	Thu Jan  1 00:00:00 1970
--- expert12/qcc.bat	Mon Aug 11 05:43:50 1997
***************
*** 0 ****
--- 1,2 ----
+ 
+ qcc
Binary files qw201/qcc.exe and expert12/qcc.exe differ
diff -crbB --unidirectional-new-file qw201/spectate.qc expert12/spectate.qc
*** qw201/spectate.qc	Mon Aug 11 15:17:36 1997
--- expert12/spectate.qc	Thu Aug 14 03:10:18 1997
***************
*** 23,28 ****
--- 23,34 ----
  	bprint (PRINT_MEDIUM, " entered the game\n");
  
  	self.goalentity = world; // used for impulse 1 below
+ 
+ 	// Expert
+ 	// Set a team for status bar purposes
+ 	// Flag as just connected
+ 	self.lefty = 1;
+ 	self.assignedTeam = TEAM_COLOR1;
  };
  
  /*
***************
*** 48,53 ****
--- 54,61 ----
  */
  void() SpectatorImpulseCommand =
  {
+ 	local string temp;
+ 
  	if (self.impulse == 1) {
  		// teleport the spectator to the next spawn point
  		// note that if the spectator is tracking, this doesn't do
***************
*** 60,65 ****
--- 68,103 ----
  			self.angles = self.goalentity.angles;
  			self.fixangle = TRUE;           // turn this way immediately
  		}
+ 	// Expert DM
+ 	// Status bar impulses
+ 	} else if (self.impulse >= 70 && self.impulse <= 79) {
+ 		sprint(self, PRINT_HIGH, "Status bar set\n");
+ 		stuffcmd(self, "setinfo statusbar ");
+ 		temp = ftos(self.impulse - 70);
+ 		stuffcmd(self, temp);
+ 		stuffcmd(self, "\n");
+ 	} else if (self.impulse == 80) {
+ 		temp = infokey(self, "ident");
+ 		if (stof(temp)) {
+ 			sprint(self, PRINT_HIGH, "Player identify off\n");
+ 			stuffcmd(self, "setinfo ident 0\n");
+ 		} else {
+ 			sprint(self, PRINT_HIGH, "Player identify on\n");
+ 			stuffcmd(self, "setinfo ident 1\n");
+ 		}
+ 	} else if (self.impulse == 81) {
+ 		temp = infokey(self, "hud2");
+ 		if (stof(temp)) {
+ 			sprint(self, PRINT_HIGH, "Normal status bar\n");
+ 			stuffcmd(self, "setinfo hud2 0\n");
+ 		} else {
+ 			sprint(self, PRINT_HIGH, "Quakeworld 2.0 HUD status bar\n");
+ 			stuffcmd(self, "setinfo hud2 1\n");
+ 		}
+ 	} else if (self.impulse == 141) {
+ 		// force immediate statusbar update
+ 		self.statustime = 0;
+ 		StatusCheckTime(self);
  	}
  
  	self.impulse = 0;
***************
*** 74,84 ****
--- 112,150 ----
  */
  void() SpectatorThink =
  {
+ 	local string s;
+ 
  	// self.origin, etc contains spectator position, so you could
  	// do some neat stuff here
  
  	if (self.impulse)
  		SpectatorImpulseCommand();
+ 
+ 	// Spectator just connected
+ 	if (self.lefty) {
+ 		if (ctf) {
+ 			s = infokey(self, "statusbar");
+ 			if (s == "") {
+ 				stuffcmd(self, "setinfo statusbar 1\n");
+ 			}
+ 		}
+ 
+ 		s = infokey(self, "ident");
+ 		if (s == "") {
+ 			stuffcmd(self, "setinfo ident 1\n");
+ 		}
+ 
+ 		// Create the entity that will print the message
+ 		// of the day for this player
+ 		CreateMOTDObj();
+ 		
+ 		self.lefty = 0;
+ 	}
+ 
+ 	// Expert
+ 	// Show status bar to spectators
+ 	if (time > self.statustime)
+ 		StatusCheckTime (self);
  };
  
  
diff -crbB --unidirectional-new-file qw201/status.qc expert12/status.qc
*** qw201/status.qc	Thu Jan  1 00:00:00 1970
--- expert12/status.qc	Tue Aug 12 00:22:08 1997
***************
*** 0 ****
--- 1,358 ----
+ /* STATUS.QC -- Function series responsible for status information within Expert CTF */
+ 
+ float TEAM_SHORT_RANGE_RADIO_RADIUS =		400;
+ 
+ // Expert CTF Team Radio
+ // flood control, separate for local vs global sounds
+ .float          lastlocalaudio;	
+ .float          lastglobalaudio;    
+ 
+ 	// Global sounds (to team) [161-164]
+ 	// 	"Is base secure?" - query for base status
+ 	// 	"Base is clear" - base clear for carrier
+ 	// 	"Base under attack" - base not clear for carrier
+ 	// 	"Our base is overrun" - indicates teammates should return to secure the base
+ 
+ 	// Local sounds (to anyone near) [165-168]
+ 	// 	Gather for attack
+ 	// 	Attack now
+ 	// 	Incoming
+ 	// 	Cover me *
+ 
+ /*
+ ==================================
+ SendTeamAudio
+ 
+ Function to play specified Team Audio
+ ==================================
+ */
+ void(entity sender, float audnum) SendTeamAudio =
+ {
+ 	local string audiofile, audiostring;
+ 	local float localsound;
+ 	local entity audioto;
+ 
+ 	if (audnum >= 161 && audnum <= 164) {
+ 		// Global sounds (to team) [161-164]
+ 		if ((sender.lastglobalaudio + 4) < time) {
+ 			sender.lastglobalaudio = time;
+ 			localsound = 0;
+ 		} else {
+ 			// repeated sound too quickly
+ 			return;
+ 		}
+ 		if (audnum == 161) {
+ 			audiostring = "IS BASE CLEAR?";
+ 			audiofile = "speech/tgstatus.wav";
+ 		} else if (audnum == 162) {
+ 			audiostring = "BASE CLEAR";
+ 			audiofile = "speech/tgclear.wav";
+ 		} else if (audnum == 163) {
+ 			audiofile = "speech/tgattack.wav";
+ 			audiostring = "BASE NOT CLEAR";
+ 		} else if (audnum == 164) {
+ 			audiostring = "BASE OVERRUN";
+ 			audiofile = "speech/tgdown.wav";
+ 		}
+ 
+ 		// play the sound
+ 		audioto = find(world, classname, "player");
+ 
+ 		while (audioto != world) 
+ 		{	
+ 			if (audioto.assignedTeam == sender.assignedTeam) {
+ 				stuffcmd(audioto, "play ");
+ 				stuffcmd(audioto, audiofile);
+ 				stuffcmd(audioto, "\n");
+ 				// "TEAM RADIO FROM"
+ 				sprint(audioto, PRINT_HIGH, "  : ");
+ 				sprint(audioto, PRINT_HIGH, sender.netname);
+ 				sprint(audioto, PRINT_HIGH, "\n");
+ 				sprint(audioto, PRINT_HIGH, audiostring);
+ 				sprint(audioto, PRINT_HIGH, "\n");
+ 			}
+ 			audioto = find(audioto, classname, "player");
+ 		}
+ 	} else if (audnum >= 165 && audnum <= 168) {
+ 		// Local sounds (to anyone near) [165-168]
+ 		if (sender.lastlocalaudio + 4 <= time) {
+ 			sender.lastlocalaudio = time;
+ 			localsound = 1;
+ 		} else {
+ 			// repeated sound too quickly
+ 			return;
+ 		} 
+ 		if (audnum == 165) {
+ 			audiofile = "speech/tlgath_a.wav";
+ 			audiostring = "GATHER FOR ATTACK";
+ 		} else if (audnum == 166) {
+ 			audiofile = "speech/tlattk_a.wav";
+ 			audiostring = "ATTACK NOW!!";
+ 		} else if (audnum == 167) {
+ 			audiofile = "speech/tlincm_a.wav";
+ 			audiostring = "INCOMING!!";
+ 		} else if (audnum == 168) {
+ 			audiofile = "speech/tlcovr_b.wav";
+ 			audiostring = "COVER ME!";
+ 		}
+ 
+ 		// play the sound
+ 		local string localradio;
+ 
+ 		localradio = infokey(world, "localradiooff");
+ 		
+ 		// If localradiooff is not set, local messages are canned to teammates in the area.  Otherwise,
+ 		// local messages are shouted like normal sound effects, hearable by everyone in the area.
+ 
+ 		if (localradio == "" || localradio == "0") {
+ 			// find teammates within short range radio radius
+ 			audioto = findradius(sender.origin, TEAM_SHORT_RANGE_RADIO_RADIUS);
+ 			while (audioto) 
+ 			{
+ 				if ((audioto.classname == "player") && 
+ 					(audioto.assignedTeam == sender.assignedTeam)) {
+ 					// "SHORT RANGE RADIO FROM"
+ 					sprint(audioto, PRINT_HIGH, "   : ");
+ 					sprint(audioto, PRINT_HIGH, sender.netname);
+ 					sprint(audioto, PRINT_HIGH, "\n");
+ 					sprint(audioto, PRINT_HIGH, audiostring);
+ 					sprint(audioto, PRINT_HIGH, "\n");
+ 					stuffcmd(audioto, "play ");
+ 					stuffcmd(audioto, audiofile);
+ 					stuffcmd(audioto, "\n");
+ 				}
+ 				audioto = audioto.chain;
+ 			}
+ 		} else {
+ 			sound (sender, CHAN_VOICE, audiofile, 1, ATTN_NORM);
+ 		}
+ 	}
+ 
+ };
+ 
+ /*
+ ==================================
+ TeamAudioTutorial
+ 
+ Tell people how to use the new team audio messages
+ and remind them which messages are bound to which
+ keys and impulses.  (Impulse 180)
+ ==================================
+ */
+ void() TeamAudioTutorial =
+ {
+ 	local string tutinfo, tutmsgs;
+ 	
+ 	if (self.impulse == 180 && ctf)
+ 	{
+ 		tutinfo = "TEAM GLOBAL MESSAGES\n\n----------------------- ---      ---\n\n";
+ 		tutmsgs = "Base status query       F5       161\n\nBase clear              F6       162\n\nBase under attack       F7       163\n\nBase overrun            F8       164";
+ 	} else if (self.impulse == 181)
+ 	{
+ 		tutinfo = "TEAM LOCAL MESSAGES\n\n----------------------- ---      ---\n\n";
+ 		tutmsgs =  "Gather for attack       F9       165\n\nAttack now              F10      166\n\nIncoming hostiles       F11      167\n\nCover me                F12      168";
+ 	}
+ 
+ 	centerprint2(self, tutinfo, tutmsgs);
+ 	self.statustime = time + 2;
+ };
+ 
+ /*
+ ==================================
+ BindTeamAudio
+ 
+ Bind Team Audio messages to F5-F12
+ ==================================
+ */
+ void(entity sender) BindTeamAudio =
+ {
+ 	if (ctf)
+ 	{
+ 		stuffcmd(sender, "bind f5 \"impulse 161\"\n");
+ 		stuffcmd(sender, "bind f6 \"impulse 162\"\n");
+ 		stuffcmd(sender, "bind f7 \"impulse 163\"\n");
+ 		stuffcmd(sender, "bind f8 \"impulse 164\"\n");
+ 	}
+ 	stuffcmd(sender, "bind f9 \"impulse 165\"\n");
+ 	stuffcmd(sender, "bind f10 \"impulse 166\"\n");
+ 	stuffcmd(sender, "bind f11 \"impulse 167\"\n");
+ 	stuffcmd(sender, "bind f12 \"impulse 168\"\n");
+ };
+ 
+ // vres:  0 = off, 1 = 200, 2 = 240, 3 = 300, 4 = 350, 5 = 384, 6 = 400, 7 = 480, 8 = 600, 9 = 768
+ 
+ // default to off (0, 0)
+ 
+ string(float vres) StatusVAlign =
+ {
+ 	if ((vres == 9) || (vres == 768)) // 768 
+ 		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
+ 	else if (vres == 8 || vres == 600) // 600 
+ 		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
+ 	else if (vres == 7 || vres == 480) // 480 
+ 		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
+ 	else if (vres == 6 || vres == 400) // 400
+ 		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
+ 	else if (vres == 5 || vres == 384) // 384 
+ 		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
+ 	else if (vres == 4 || vres == 350) // 350 
+ 		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
+ 	else if (vres == 3 || vres == 300) // 300 
+ 		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
+ 	else if (vres == 2 || vres == 240) // 240 
+ 		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
+ 	else
+ 		// 200 
+ 		return "\n\n\n\n\n\n\n\n\n\n";
+ 
+ };
+ 
+ string(entity e) StatusBlueFlag =
+ {
+ 	local entity flag, p;
+ 
+ 	flag = find (world,classname, "item_flag_team2");
+ 
+ 	if (e.assignedTeam == TEAM_COLOR2) {
+ 		if (flag != world && flag.cnt == FLAG_CARRIED) {
+                         return "\n   ";
+ 		} else {
+ 			if (flag.cnt == FLAG_AT_BASE)
+                                 return "\n    base ";
+ 			else
+                                 return "\n    lost ";
+ 		}
+ 	} else {
+ 		if (flag != world && flag.cnt == FLAG_CARRIED) {
+ 			return "  BLUE  ";
+ 		} else {
+ 			if (flag.cnt == FLAG_AT_BASE)
+ 				return "  BLUE   base ";
+ 			else
+ 				return "  BLUE   lost ";
+ 		}
+ 	}
+ };
+ 
+ string(entity e) StatusRedFlag =
+ {
+ 	local entity flag, p;
+ 
+ 	flag = find (world,classname, "item_flag_team1");
+ 
+ 	if (e.assignedTeam == TEAM_COLOR1) {
+ 		if (flag != world && flag.cnt == FLAG_CARRIED) {
+                         return "\n   ";
+ 		} else {
+ 			if (flag.cnt == FLAG_AT_BASE)
+                                 return "\n    base ";
+ 			else
+                                 return "\n    lost ";
+ 		}
+ 	} else {
+ 		if (flag != world && flag.cnt == FLAG_CARRIED) {
+ 			return "  RED  ";
+ 		} else {
+ 			if (flag.cnt == FLAG_AT_BASE)
+ 				return "  RED   base ";
+ 			else
+ 				return "  RED   lost ";
+ 		}
+ 	}
+ };
+ 
+ string(float integer) itos = 
+ {
+ 	if (integer == 0)
+ 		return "0";
+ 	else if (integer == 1)
+ 		return "1";
+ 	else if (integer == 2)
+ 		return "2";
+ 	else if (integer == 3)
+ 		return "3";
+ 	else if (integer == 4)
+ 		return "4";
+ 	else if (integer == 5)
+ 		return "5";
+ 	else if (integer == 6)
+ 		return "6";
+ 	else if (integer == 7)
+ 		return "7";
+ 	else if (integer == 8)
+ 		return "8";
+ 	else if (integer == 9)
+ 		return "9";
+ 	else if (integer == 10)
+ 		return "10";
+ 	else if (integer == 11)
+ 		return "11";
+ 	else if (integer == 12)
+ 		return "12";
+ 	else if (integer == 13)
+ 		return "13";
+ 	else if (integer == 14)
+ 		return "14";
+ 	else if (integer == 15)
+ 		return "15";
+ 	else if (integer == 16)
+ 		return "16";
+ 	else if (integer == 17)
+ 		return "17";
+ 	else if (integer == 18)
+ 		return "18";
+ 	else if (integer == 19)
+ 		return "19";
+ 	else if (integer == 20)
+ 		return "20";
+ 	else return "0";
+ };
+ 
+ void(entity e) StatusCheckTime =
+ {
+ 	local string temp, vcenter, lookingat, redstr, bluestr, redscore, bluescore, redflag, blueflag;
+ 	local float vres, identon, hud2;
+ 
+ 	temp = infokey(e, "statusbar");
+ 	vres = stof(temp);
+ 	if (vres && time > e.statustime)
+ 	{
+ 		vcenter = StatusVAlign(vres);
+ 
+ 		temp = infokey(e, "ident");
+ 		identon = stof(temp);
+ 
+ 		if (identon)
+ 			lookingat = identify_player(e);
+ 		else
+ 			lookingat = "";
+ 
+ 		if (ctf) {
+ 			redstr = StatusRedFlag(e);
+ 			bluestr = StatusBlueFlag(e);
+ 			redscore = itos(team1_captures);
+ 			bluescore = itos(team2_captures);
+ 			// status bar for QW 2.0 HUD: three lines
+ 			temp = infokey(e, "hud2");
+ 			hud2 = stof(temp);
+ 			if (hud2) {
+ 				if (e.assignedTeam == TEAM_COLOR1)
+ 					centerprint7 (e, vcenter, lookingat, redstr, redscore, "\n", bluestr, bluescore);
+ 				else
+ 					centerprint7 (e, vcenter, lookingat, bluestr, bluescore, "\n", redstr, redscore);
+ 			} else {
+ 				if (e.assignedTeam == TEAM_COLOR1)
+ 					centerprint7 (e, vcenter, lookingat, redstr, redscore, "        ", bluestr, bluescore);
+ 				else
+ 					centerprint7 (e, vcenter, lookingat, bluestr, bluescore, "        ", redstr, redscore);
+ 			}
+ 		} else {
+ 			// display just ident if on
+ 			if (identon)
+ 				centerprint3(e, vcenter, "\n", lookingat);
+ 			// extra carriage return compensates for one line status
+ 		}
+ 		e.statustime = time + 1.5;
+ 	}
+ };
+ 
diff -crbB --unidirectional-new-file qw201/subs.qc expert12/subs.qc
*** qw201/subs.qc	Fri Dec 13 15:51:24 1996
--- expert12/subs.qc	Fri Aug  8 20:16:50 1997
***************
*** 230,236 ****
  //
  	if (activator.classname == "player" && self.message != "")
  	{
! 		centerprint (activator, self.message);
  		if (!self.noise)
  			sound (activator, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);
  	}
--- 230,240 ----
  //
  	if (activator.classname == "player" && self.message != "")
  	{
! 		// Expert
! 		// Avoid centerprints
! 		sprint (activator, PRINT_MEDIUM, self.message);
! 		sprint (activator, PRINT_MEDIUM, "\n");
! 		//centerprint (activator, self.message);
  		if (!self.noise)
  			sound (activator, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);
  	}
diff -crbB --unidirectional-new-file qw201/teamplay.qc expert12/teamplay.qc
*** qw201/teamplay.qc	Thu Jan  1 00:00:00 1970
--- expert12/teamplay.qc	Sat Aug 16 21:32:30 1997
***************
*** 0 ****
--- 1,1339 ----
+ /** Defs **/
+ 
+ /** MODIFIABLE CONSTANTS **/
+ 
+ // Team colors
+ 
+ float COLOR1 =		4; // red
+ float COLOR2 =		13; // blue
+ float COLOR3 =		11; // green
+ float COLOR4 =		12; // yellow
+ 
+ // Teams active by default
+ // -1 indicates not active
+ 
+ float TEAM_COLOR1       =       4;
+ float TEAM_COLOR2       =       13;
+ float TEAM_COLOR3       =       -1;
+ float TEAM_COLOR4       =       -1;
+ 
+ float TEAM_DEFAULT_PENALTY =	1;	// Default frag penalty
+ float TEAM_FRAG_FLOOR =		-8;	// Minimum frags before boot
+ 
+ float TEAM_NOSWITCH_DELAY =	5;	// number of seconds to wait after player connects before
+ 						// deciding the player must be trying to change team
+ float TEAM_STUFF_DELAY =	1;	// the minimum delay between any two 
+ 						// team- or skin-setting stuffcmds
+ float TEAM_PRINT_DELAY =	45;	// how many seconds between score printouts
+ 
+ // Friendly fire detection.  A player will be informed he is shooting
+ // a teammate if that player shoots a player on his team TEAM_FF_NUMSHOTS
+ // times or more in a row over a time period between TEAM_FF_MINDELAY
+ // and TEAM_FF_MAXDELAY.
+ 
+ float TEAM_FF_NUMSHOTS =	3;	// 3 shots is fairly unambiguos
+ float TEAM_FF_MINDELAY =	2;	// 2 seconds is a long time in Quake
+ float TEAM_FF_MAXDELAY =	7;	// after 7 seconds it's probably an unrelated shot
+ 
+ float TEAM_CHECK_DELAY =	1;	// check team lock every second
+ 
+ /** End of MODIFIABLE CONSTANTS **/
+ 
+ // Globals
+ 
+ .float lastteamcheck;
+ 
+ // CTF
+ float team1_captures;
+ float team2_captures;
+ 
+ float teamScorePrintTime;
+ 
+ // Prototypes
+ float() W_BestWeapon;
+ void() W_SetCurrentAmmo;
+ void() bound_other_ammo;
+ void(float o, float n) Deathmatch_Weapon;
+ void() BackpackTouch;
+ 
+ /*
+ ================
+ TeamSkinForTeam
+ 
+ Return the skin that is assigned for a particular team.  If you want to run
+ a teamplay-by-skins server, replace the strings in the function below, ie
+ "base" -> "arnold"
+ ================
+ */
+ string(float theTeam) TeamSkinForTeam =
+ {
+ 	if (self.assignedTeam == TEAM_COLOR1)
+ 		return "base";
+ 	else if (self.assignedTeam == TEAM_COLOR2)
+ 		return "base";
+ 	else if (self.assignedTeam == TEAM_COLOR3)
+ 		return "base";
+ 	else if (self.assignedTeam == TEAM_COLOR4)
+ 		return "base";
+ 	else
+ 		// if we're running a server with both STATIC_TEAMS and
+ 		// LOCK_COLORS turned off, then we need a skin to set for
+ 		// players who set themselves to some arbitrary team.
+ 		// This skin has to be able to show color, so you can tell
+ 		// whether the player is on your team.
+ 		return "base";
+ };
+ 
+ /*
+ ================
+ TeamNameForTeam
+ 
+ Return the team name that is assigned for a particular team.  Replace
+ the strings in the function below to get different team names, ie
+ "Red" -> "[DR]"
+ ================
+ */
+ string(float theTeam) TeamNameForTeam =
+ {
+ 	if (theTeam == TEAM_COLOR1)
+ 		return "Red";
+ 	else if (theTeam == TEAM_COLOR2)
+ 		return "Blue";
+ 	else if (theTeam == TEAM_COLOR3)
+ 		return "Green";
+ 	else if (theTeam == TEAM_COLOR4)
+ 		return "Yellow";
+ 	else return "Solo";
+ };
+ 
+ /*
+ ================
+ InitTeams
+ 
+ Called on the first frame of a new level.  If the infokey "numteams"
+ is set to 3 or 4, the third and fourth teams will be activated.
+ ================
+ */
+ void() InitTeams =
+ {
+ 	local float numteams;
+ 	local string s;
+ 
+ 	s = infokey(world, "numteams");
+ 	if (s != "")
+ 		numteams = stof(s);
+ 	else
+ 		numteams = 0;
+ 
+ 	if (numteams > 2)
+ 		TEAM_COLOR3 = COLOR3;
+ 	if (numteams > 3)
+ 		TEAM_COLOR4 = COLOR4;
+ 
+ };
+ 
+ /*
+ ================
+ TeamPantColor
+ 
+ Return the pants color of the entity argument.  Note that the number returned
+ is the actual pant color of the player, and not that number + 1, as was the 
+ case in Quake classic.
+ ================
+ */
+ float(entity e) TeamPantColor =
+ {
+ 	local string s;
+ 	local float f;
+ 	s = infokey(e, "bottomcolor");
+ 	f = stof(s);
+ 	return f;
+ };
+ 
+ /*
+ ================
+ TeamShirtColor
+ 
+ Return the shirt color of the entity argument.  Note that the number returned
+ is the actual shirt color of the player, and not that number + 1, as was the 
+ case in Quake classic.
+ ================
+ */
+ float(entity e) TeamShirtColor =
+ {
+ 	local string s;
+ 	local float f;
+ 	s = infokey(e, "topcolor");
+ 	f = stof(s);
+ 	return f;
+ };
+ 
+ /*
+ ================
+ TeamSkin
+ 
+ Return the skin of the entity argument.  We have to do skin management in QW,
+ even for normal teamplay, since skins aren't guaranteed to show team correctly
+ just by color.
+ ================
+ */
+ string(entity e) TeamSkin =
+ {
+ 	local string s;
+ 
+ 	s = infokey(e, "skin");
+ 	return s;
+ };
+ 
+ /*
+ ================
+ TeamTeamName
+ 
+ Return the teamName, which is a team string settable by the player that is
+ used internally by Quake for messagemode2.
+ ================
+ */
+ string(entity e) TeamTeamName =
+ {
+ 	local string s;
+ 
+ 	s = infokey(e, "team");
+ 	return s;
+ };
+ 
+ /*
+ ================
+ TeamStuffColor
+ 
+ Stuff a command to the console to set the player's
+ colors to match his team.
+ ================
+ */
+ void(string msg) TeamStuffColor =
+ {
+ 	local string s;
+ 
+ 	if (self.lastcolorset + TEAM_STUFF_DELAY < time) {
+ 		s = ftos(self.assignedTeam);
+ 		if (!(teamplay & TEAM_ENFORCE_SHIRT)) {
+ 			stuffcmd(self, "bottomcolor ");
+ 			stuffcmd(self, s);
+ 			stuffcmd(self, "\n");
+ 		} else {
+ 			stuffcmd(self, "color ");
+ 			stuffcmd(self, s);
+ 			stuffcmd(self, "\n");
+ 		}
+ 		self.lastcolorset = time;
+ 		sprint(self, PRINT_HIGH, msg);
+ 	}
+ };
+ 
+ /*
+ ================
+ TeamStuffSkin
+ 
+ Stuff a command to the console to set the player's skin.
+ ================
+ */
+ void(string msg) TeamStuffSkin =
+ {
+ 	local string s;
+ 
+ 	if (self.lastskinset + TEAM_STUFF_DELAY < time) {
+ 		s = TeamSkinForTeam(self.assignedTeam);
+ 		stuffcmd(self, "setinfo skin ");
+ 		stuffcmd(self, s);
+ 		stuffcmd(self, "\n");
+ 		self.lastskinset = time;
+ 		sprint(self, PRINT_HIGH, msg);
+ 	}
+ };
+ 
+ /*
+ ================
+ TeamStuffTeamName
+ 
+ Stuff a command to the console to set the player's teamName.
+ ================
+ */
+ void(string msg) TeamStuffTeamName =
+ {
+ 	local string s;
+ 
+ 	if (self.lastteamset + TEAM_STUFF_DELAY < time) {
+ 		s = TeamNameForTeam(self.assignedTeam);
+ 		stuffcmd(self, "team ");
+ 		stuffcmd(self, s);
+ 		stuffcmd(self, "\n");
+ 		self.lastteamset = time;
+ 		sprint(self, PRINT_HIGH, msg);
+ 	}
+ };
+ 
+ /*
+ ================
+ TeamFragCheck
+ 
+ Check and see if the player has too many negative frags and boot him if so and
+ the TEAM_BOOT_NEGS bit is set.
+ ================
+ */
+ void(entity pl) TeamFragCheck =
+ {
+ 	// If TEAM_BOOT_NEGS is not set, don't do anything.
+ 	if(!(teamplay & TEAM_BOOT_NEGS))
+ 		return;
+ 		
+ 	if(pl.frags < TEAM_FRAG_FLOOR)
+ 	{
+ 		// Boot the neg!
+ 		sprint(pl, PRINT_HIGH, "You have too many negative frags!\nYou are kicked!\n");
+ 		stuffcmd(pl, "disconnect\n");
+ 	}
+ 	if(pl.frags == TEAM_FRAG_FLOOR)
+ 	{
+ 		// Notify the neg of their precarious position.
+ 		centerprint(pl, "WARNING!\nYou are one frag away from being kicked!\n");
+ 	}
+ };
+ 
+ /*
+ ================
+ TeamArmorDam
+ 
+ Return TRUE if the target's armor can take damage from this attacker.
+ ================
+ */
+ 
+ float(entity targ, entity inflictor, entity attacker, float damage) TeamArmorDam =
+ {
+ 	local float ateam;
+ 	local float tteam;
+ 
+ 	ateam = attacker.assignedTeam;
+ 	tteam = targ.assignedTeam;
+ 
+         if( teamplay < 0 )
+                 return TRUE;
+         if( (teamplay & TEAM_ARMOR_PROTECT) && (ateam == tteam) && (attacker != targ) && (tteam > 0) )
+         {
+                 // Armor is protected
+                 return FALSE;
+         }
+         return TRUE;
+ };
+ 
+ /*
+ ================
+ TeamHealthDam
+ 
+ Return TRUE if the target can take health damage from this attacker.
+ ================
+ */
+ 
+ float(entity targ, entity inflictor, entity attacker, float damage) TeamHealthDam =
+ {
+ 	local float ateam;
+ 	local float tteam;
+ 
+ 	ateam = attacker.assignedTeam;
+ 	tteam = targ.assignedTeam;
+ 	
+         if( teamplay < 0 )
+         {
+                 return TRUE;
+         }
+         if( (ateam == tteam) && (attacker != targ) && (tteam > 0) )
+         {
+                 // Attacker and target are on the same team.
+                 if( teamplay & TEAM_ATTACKER_DAMAGE )
+                 {
+                         // Damage applied to teammate.
+                         T_Damage(attacker, inflictor, attacker, damage);
+                 }
+                 if( teamplay & TEAM_HEALTH_PROTECT )
+                 {
+                         // Health is protected
+                         return FALSE;
+                 }
+         }
+         return TRUE;
+ };
+ 
+ /*
+ ================
+ TeamPFrags
+ 
+ Return the number of frags we should penalize attacker for killing targ.
+ ================
+ */
+ 
+ float(entity targ, entity attacker) TeamPFrags =
+ {
+ 	local float ateam;
+ 	local float tteam;
+ 
+ 	ateam = attacker.assignedTeam;
+ 	tteam = targ.assignedTeam;
+ 	
+         if( teamplay < 0 )
+                 return (-1 * teamplay);
+         if( (tteam > 0) && (targ != attacker) && (tteam == ateam) )
+         {
+                 // targ and attacker are on the same team
+                 if( teamplay < 0 )
+                 {
+                         // teamplay indicates frag penalty
+                         return ( -1 * teamplay );
+                 }
+                 if( teamplay & TEAM_FRAG_PENALTY )
+                 {
+                         // default penalty
+                         return TEAM_DEFAULT_PENALTY;
+                 }
+         }
+         // No frag penalty
+         return 0;
+ };
+ 
+ /*
+ ================
+ TeamFragPenalty
+ 
+ If attacker should be penalized for killing targ, penalize attacker
+ and return TRUE.
+ ================
+ */
+ 
+ float(entity targ, entity attacker) TeamFragPenalty =
+ {
+         local float f;
+ 
+         f = TeamPFrags(targ, attacker);
+ 
+         if( f )
+         {
+                 // We should penalize some frags.
+                 attacker.frags = attacker.frags - f;
+                 return TRUE;
+         }
+         // No penalty
+         return FALSE;
+ };
+ 
+ /*
+ =================
+ TeamDeathPenalty
+ 
+ If attacker should be killed for killing targ, kill attacker and
+ add a frag to offset the one attacker will lose for killing himself.
+ =================
+ */
+ 
+ void(entity targ, entity attacker) TeamDeathPenalty =
+ {
+ 	local float ateam;
+ 	local float tteam;
+ 
+ 	ateam = attacker.assignedTeam;
+ 	tteam = targ.assignedTeam;
+ 	
+         //Don't kill anyone if teamplay is negative.
+         if ( teamplay < 0 )
+                 return;
+ 
+         if ( (teamplay & TEAM_DEATH_PENALTY) && (tteam > 0) && (attacker != targ) && (ateam == tteam) )
+         {
+                 //We should kill the attacker.
+                 T_Damage(attacker,attacker,attacker,1000);
+                 //Add a frag to offset the self-kill penalty.
+                 attacker.frags = attacker.frags + 1;
+         }
+ };
+ 
+ /*
+ ==================
+ TeamDeathMsg
+ 
+ Display a teammate death message if necessary
+ ==================
+ */
+ 
+ void(entity targ, entity attacker) TeamDeathMsg =
+ {
+ 	local float ateam;
+ 	local float tteam;
+ 
+ 	ateam = attacker.assignedTeam;
+ 	tteam = targ.assignedTeam;
+ 	
+ 	// No messages if teamplay is zero
+ 	if(!teamplay)
+ 		return;
+ 		
+ 	// No messages if targ and attacker are on different teams.
+ 	if(ateam != tteam)
+ 		return;
+ 		
+ 	// Print a teammate death message.
+ 	bprint(PRINT_HIGH, attacker.netname);
+ 	bprint(PRINT_HIGH, " killed his teammate, ");
+ 	bprint(PRINT_HIGH, targ.netname);
+ 	bprint(PRINT_HIGH, "!\n");
+ };
+ 
+ /*
+ ==================
+ TeamIsLegal
+ 
+ Return TRUE if the indicated team is legal
+ ==================
+ */
+ float(float color) TeamIsLegal =
+ {
+ 
+         // All colors are legal if teamplay is negative.
+         if( teamplay < 0 )
+                 return TRUE;
+         // All colors are legal if TEAM_LOCK_COLORS is off.
+         if( !(teamplay & TEAM_LOCK_COLORS) && color >= 0 && color <= 13)
+                 return TRUE;
+         if( (color == TEAM_COLOR1) && (TEAM_COLOR1 >= 0) )
+                 return TRUE;
+         if( (color == TEAM_COLOR2) && (TEAM_COLOR2 >= 0) )
+                 return TRUE;
+         if( (color == TEAM_COLOR3) && (TEAM_COLOR3 >= 0) )
+                 return TRUE;
+         if( (color == TEAM_COLOR4) && (TEAM_COLOR4 >= 0) )
+                 return TRUE;
+         return FALSE;
+ };
+ 
+ /*
+ =======================
+ TeamSumTeamFrags
+ 
+ Helper function.  Given a team, sum the total
+ frags that all players on that team have.
+ =======================
+ */
+ 
+ float(float theTeam) TeamSumTeamFrags =
+ {
+ 
+ 	local float totalFrags = 0;
+ 	local entity p;
+ 
+ 	// count up total
+ 	p = find(world, classname, "player");
+ 	while (p != world) {
+ 		if (p.assignedTeam == theTeam)
+ 			totalFrags = totalFrags + p.frags;
+ 		p = find(p, classname, "player");
+ 	}
+ 
+ 	return totalFrags;
+ 
+ };
+ 
+ /*
+ ==================
+ TeamAssign
+ 
+ Assign a player to the team that needs him most.
+ ==================
+ */
+ void() TeamAssign =
+ {
+         local float Team1Total, Team2Total, Team3Total, Team4Total;
+         local float ties, tie1, tie2, tie3, tie4;
+ 
+         local float newTeam;
+         local float least;
+ 
+         local entity p;
+ 
+         local string s;
+ 
+         if (!(teamplay & TEAM_LOCK_COLORS)) {
+             // if colors aren't locked, assign the player to the team
+             // that matches the color he came in with and return
+             self.assignedTeam = TeamPantColor(self);
+             return;
+         }
+ 
+         // Sum the players on all the teams.
+ 
+         Team1Total = 0;
+         Team2Total = 0;
+         Team3Total = 0;
+         Team4Total = 0;
+ 
+         p = find (world, classname, "player");
+ 
+         while(p)
+         {
+ 		if( p != self )
+ 		{
+ 			if( (TEAM_COLOR1 >= 0) && (p.assignedTeam == (TEAM_COLOR1)) )
+ 				Team1Total = Team1Total + 1;
+ 			if( (TEAM_COLOR2 >= 0) && (p.assignedTeam == (TEAM_COLOR2)) )
+ 				Team2Total = Team2Total + 1;
+ 			if( (TEAM_COLOR3 >= 0) && (p.assignedTeam == (TEAM_COLOR3)) )
+ 				Team3Total = Team3Total + 1;
+ 			if( (TEAM_COLOR4 >= 0) && (p.assignedTeam == (TEAM_COLOR4)) )
+ 				Team4Total = Team4Total + 1;
+ 		}
+             p = find(p, classname, "player");
+         }
+ 
+         // Find the team with the least players.
+ 
+         newTeam = TEAM_COLOR1;
+         least = Team1Total;
+ 
+         if ( (TEAM_COLOR2 >= 0) && (Team2Total < least) )
+         {
+                 newTeam = TEAM_COLOR2;
+                 least = Team2Total;
+         }
+ 
+         if ( (TEAM_COLOR3 >= 0) && (Team3Total < least) )
+         {
+                 newTeam = TEAM_COLOR3;
+                 least = Team3Total;
+         }
+ 
+         if ( (TEAM_COLOR4 >= 0) && (Team4Total < least) )
+         {
+                 newTeam = TEAM_COLOR4;
+                 least = Team4Total;
+         }
+ 
+         // check for ties
+         tie1 = tie2 = tie3 = tie4 = ties = 0;
+         
+         if (least == Team1Total) {tie1 = 1;ties = ties + 1;}
+         if (least == Team2Total) {tie2 = 1;ties = ties + 1;}
+         if (least == Team3Total) {tie3 = 1;ties = ties + 1;}
+         if (least == Team4Total) {tie4 = 1;ties = ties + 1;}
+ 
+         if (ties > 1) {
+               // Tie for least team members, team with least score
+               // gets new player
+               least = 60000;
+ 		  if (tie1) {
+               		Team1Total = TeamSumTeamFrags(TEAM_COLOR1);
+ 				if (Team1Total < least) {
+ 					newTeam = TEAM_COLOR1;
+ 					least = Team1Total;
+ 				}
+               } 
+               if (tie2) {
+               		Team2Total = TeamSumTeamFrags(TEAM_COLOR2);
+ 				if (Team2Total < least) {
+ 					newTeam = TEAM_COLOR2;
+ 					least = Team2Total;
+ 				}
+ 		  } 
+               if (tie3) {
+               		Team3Total = TeamSumTeamFrags(TEAM_COLOR3);
+ 				if (Team3Total < least) {
+ 					newTeam = TEAM_COLOR3;
+ 					least = Team3Total;
+ 				}
+               } 
+               if (tie4) {
+               		Team4Total = TeamSumTeamFrags(TEAM_COLOR4);
+ 				if (Team4Total < least) {
+ 					newTeam = TEAM_COLOR4;
+ 					least = Team4Total;
+ 				}
+ 		  }
+         }
+ 
+ 	  // Put the player on a the new team.
+ 	  self.assignedTeam = newTeam;
+ 
+         // stuffcmd the color, skin and teamName of the player
+         TeamStuffColor("");
+         TeamStuffSkin("");
+         TeamStuffTeamName("");
+ 
+         // and some info for the players
+         s = TeamNameForTeam(newTeam);
+         bprint(PRINT_HIGH, self.netname);
+         bprint(PRINT_HIGH, " has been assigned to team ");
+         bprint(PRINT_HIGH, s);
+         bprint(PRINT_HIGH, "\n");
+         sprint(self, PRINT_HIGH, "\nLegal teams are:");
+ 
+         if(TEAM_COLOR1 >= 0)
+         {
+                 s = ftos(TEAM_COLOR1);
+                 sprint(self, PRINT_HIGH, " ");
+                 sprint(self, PRINT_HIGH, s);
+         }
+         if(TEAM_COLOR2 >= 0)
+         {
+                 s = ftos(TEAM_COLOR2);
+                 sprint(self, PRINT_HIGH, " ");
+                 sprint(self, PRINT_HIGH, s);
+         }
+         if(TEAM_COLOR3 >= 0)
+         {
+                 s = ftos(TEAM_COLOR3);
+                 sprint(self, PRINT_HIGH, " ");
+                 sprint(self, PRINT_HIGH, s);
+         }
+         if(TEAM_COLOR4 >= 0)
+         {
+                 s = ftos(TEAM_COLOR4);
+                 sprint(self, PRINT_HIGH, " ");
+                 sprint(self, PRINT_HIGH, s);
+         }
+ 
+         sprint(self, PRINT_HIGH, "\n");
+ };
+ 
+ /*
+ ===============
+ TeamMemberGap
+ 
+ TeamMemberGap returns the difference in the number of players on
+ "currentTeam" and the number of players on "newTeam" (may be a
+ negative number).
+ ===============
+ */
+ float(float currentTeam, float newTeam) TeamMemberGap =
+ {
+ 	local entity 	p;
+ 	local float		currentTeamNum;
+ 	local float		newTeamNum;
+ 
+ 	currentTeamNum = 0;
+ 	newTeamNum = 0;
+ 
+ 	p = find (world, classname, "player");
+ 	while(p)
+ 	{
+ 		if (p.assignedTeam == currentTeam) {
+ 			currentTeamNum = currentTeamNum + 1;
+ 		} else if (p.assignedTeam == newTeam) {
+ 			newTeamNum = newTeamNum + 1;
+ 		}
+             p = find(p, classname, "player");
+ 	}
+ 
+ 	return (currentTeamNum - newTeamNum);
+ 
+ };      
+ 
+ /*
+ ===============
+ TeamCheckLock
+ 
+ Check for team changing and perform whatever actions are neccessary.
+ ===============
+ */
+ void() TeamCheckLock =
+ {
+ 
+ 	local   float   n, pantColorNow, shirtColorNow;
+ 	local   string  s, skinNow, teamNameNow, 
+ 			assignedSkin, assignedTeamName;
+ 
+ 	// Don't do anything if teamplay is negative
+ 	if ( teamplay < 0 )
+ 		return;
+ 
+ 	// if the player has an invalid assignedTeam, assign him to a valid team.
+ 	if (!TeamIsLegal(self.assignedTeam)) {
+ 		TeamAssign();
+ 	}
+ 
+ 	// get the player's current pant color
+ 	pantColorNow = TeamPantColor(self);
+ 
+ 	// player has attempted to change pant color.. treat as an attempted team change
+ 	if (pantColorNow != self.assignedTeam)
+ 	{
+ 		// If teams are static
+ 		if (teamplay & TEAM_STATIC_TEAMS)
+ 		{
+ 			// just prevent the color change
+ 			TeamStuffColor("Team changes not allowed.\n");
+ 		} else { 
+ 			// teams aren't completely static
+ 			if (!TeamIsLegal(pantColorNow))
+ 			{
+ 				// illegal team, just prevent the team change
+ 				TeamStuffColor("Not a valid team.\n");
+ 			} else if ((self.connecttime + TEAM_NOSWITCH_DELAY) < time) {
+ 				// if the play just connected, assume he just hasn't got his
+ 				// colors in sync yet.  Otherwise, assume an attempted team change
+ 				if ((teamplay & TEAM_FAIR_TEAMS) &&
+ 					(TeamMemberGap(self.assignedTeam, pantColorNow) < 1)) {
+ 					// team switches must be to a team with less members
+ 					TeamStuffColor("That team has at least as many players.\n");
+ 				} else {
+ 					// no carryover of frags or power
+ 					self.frags = 1; // zero out frags (compensate for suicide)
+ 					T_Damage(self, self, self, 10000); // kill the player
+ 					self.assignedTeam = pantColorNow;
+ 					// set color to match.. skin and teamName handled later
+ 					TeamStuffColor("");
+ 					bprint(PRINT_HIGH, self.netname);
+ 					bprint(PRINT_HIGH, " has switched to team ");
+ 					s = TeamNameForTeam(pantColorNow);
+ 					bprint(PRINT_HIGH, s);
+ 					bprint(PRINT_HIGH, ".\n");
+ 				}
+ 			}
+ 		}
+ 
+ 	}
+ 
+ 	// find out the player's current visible attributes
+ 	shirtColorNow = TeamShirtColor(self);
+ 	skinNow = TeamSkin(self);
+ 	teamNameNow = TeamTeamName(self);
+ 
+ 	// get the correct skin and teamName for the player's assigned team
+ 	assignedSkin = TeamSkinForTeam(self.assignedTeam);
+ 	assignedTeamName = TeamNameForTeam(self.assignedTeam);
+ 
+ 	if (skinNow != assignedSkin) {
+ 		// an attempted skin change doesn't constitute an attemped team
+ 		// change, so we do no checking, just reset the skin
+ 		TeamStuffSkin("You cannot change skin.\n");
+ 	}
+ 
+ 	if (teamNameNow != assignedTeamName) {
+ 		// an attempted teamName change doesn't constitute an attemped team
+ 		// change, so we do no checking, just reset the teamName
+ 		TeamStuffTeamName("You cannot change your team name.\n");
+ 	}
+ 
+ 	if ((teamplay & TEAM_ENFORCE_SHIRT) && (shirtColorNow != self.assignedTeam)) {
+ 		// an attempted shirtColor change doesn't constitute an attemped team
+ 		// change, so we do no checking, just reset the shirt color
+ 		TeamStuffColor("You cannot change your shirt color.\n");
+ 	}
+ };
+ 
+ /*
+ =======================
+ TeamPrintTeamScore
+ 
+ Print the team score: the total numbers of
+ frags for each team.
+ =======================
+ */
+ 
+ void() TeamPrintTeamScore =
+ {
+ 
+ 	local float teamScore;
+ 	local string s;
+ 
+ 	bprint(PRINT_HIGH, "Team Score: ");
+ 
+ 	if (TEAM_COLOR1 >= 0)
+ 	{
+ 		teamScore = TeamSumTeamFrags(TEAM_COLOR1);
+ 		s = TeamNameForTeam(TEAM_COLOR1);
+ 		bprint(PRINT_HIGH, s);
+ 		bprint(PRINT_HIGH, ": ");
+ 		s = ftos(teamScore);
+ 		bprint(PRINT_HIGH, s);
+ 		bprint(PRINT_HIGH, " ");
+ 	}
+ 	if (TEAM_COLOR2 >= 0)
+ 	{
+ 		teamScore = TeamSumTeamFrags(TEAM_COLOR2);
+ 		s = TeamNameForTeam(TEAM_COLOR2);
+ 		bprint(PRINT_HIGH, s);
+ 		bprint(PRINT_HIGH, ": ");
+ 		s = ftos(teamScore);
+ 		bprint(PRINT_HIGH, s);
+ 		bprint(PRINT_HIGH, " ");	
+ 	}
+ 	if (TEAM_COLOR3 >= 0)
+ 	{
+ 		teamScore = TeamSumTeamFrags(TEAM_COLOR3);
+ 		s = TeamNameForTeam(TEAM_COLOR3);
+ 		bprint(PRINT_HIGH, s);
+ 		bprint(PRINT_HIGH, ": ");
+ 		s = ftos(teamScore);
+ 		bprint(PRINT_HIGH, s);
+ 		bprint(PRINT_HIGH, " ");
+ 	}
+ 	if (TEAM_COLOR4 >= 0)
+ 	{
+ 		teamScore = TeamSumTeamFrags(TEAM_COLOR4);
+ 		s = TeamNameForTeam(TEAM_COLOR4);
+ 		bprint(PRINT_HIGH, s);
+ 		bprint(PRINT_HIGH, ": ");
+ 		s = ftos(teamScore);
+ 		bprint(PRINT_HIGH, s);
+ 		bprint(PRINT_HIGH, " ");
+ 	}
+ 
+ 	bprint(PRINT_HIGH, "\n");
+ 
+ };
+ 
+ /*
+ =======================
+ TeamFFNotice
+ 
+ Friendly fire detection.  A player will be informed he is shooting
+ a teammate if that player shoots another player on his team 
+ TEAM_FF_NUMSHOTS times or more in a row over a time period between
+ TEAM_FF_MINDELAY and TEAM_FF_MAXDELAY.  The idea is to print a message
+ if a player shoots a teammate several times in a row, it wasn't a burst
+ of shots (MIN_DELAY), and it wasn't two unrelated sets of accidental
+ FF shots with a large time gap between them (MAX_DELAY).
+ Players will not be warned if they are shooting themselves.
+ =======================
+ */
+ void(entity attacker, entity targ) TeamFFNotice =
+ {
+ 	if ((targ.classname == "player") &&
+ 		(attacker.classname == "player") &&
+ 		(attacker != targ)) {
+ 		if (attacker.shooting == targ) {
+ 			// this is our second or later shot on the same target
+ 			if ((targ.assignedTeam == attacker.assignedTeam) &&
+ 				(attacker.numshots >= TEAM_FF_NUMSHOTS) && 
+ 				(attacker.firstshot + TEAM_FF_MINDELAY < time)) {
+ 				if (attacker.firstshot + TEAM_FF_MAXDELAY > time) {
+ 					// shooting a teammate repeatedly 			
+ 					centerprint(attacker, "Stop shooting your\n\nTEAMMATE\n\nfool!");
+ 					if (ctf)
+ 						attacker.statustime = time + 2;
+ 				}
+ 				// NOTE: we do the reset in the case that we've gone past the max
+ 				// delay too, so that we'll get the message if we keep firing at
+ 				// the same target well past the MAXDELAY.
+ 				attacker.shooting = world;
+ 				attacker.numshots = 0;
+ 				attacker.firstshot = time;
+ 			} else {
+ 				// well, we're shooting someone repeatedly.
+ 				attacker.numshots = attacker.numshots + 1;
+ 			}
+ 		} else {
+ 			// shooting a new target
+ 			attacker.shooting = targ;
+ 			attacker.numshots = 1;
+ 			attacker.firstshot = time;
+ 		}
+ 	}
+ 
+ };
+ 
+ /*
+ =======================
+ TossBackPack
+ 
+ Original idea by Vhold
+ Rewritten by John Spickes
+ 
+ Toss out a backpack containing some ammo from your current weapon,
+ and any weapons you don't have.
+ =======================
+ */
+ void() TossBackpack =
+ {
+ 	local entity 	item;
+ 
+ 	// If we don't have any ammo, return
+ 	if(self.currentammo <= 0)
+ 		return;
+ 
+ 	item = spawn();
+ 
+ 	// See if you have the Shotgun or Super Shotgun on
+         if ( (self.weapon == IT_SHOTGUN) || (self.weapon == IT_SUPER_SHOTGUN) )
+ 	{
+ 		if( self.ammo_shells >= 20 ) {
+ 			item.ammo_shells = 20;
+ 			self.ammo_shells = self.ammo_shells - 20;
+ 		}
+ 		else
+ 		{
+ 			item.ammo_shells = self.ammo_shells;
+ 			self.ammo_shells = 0;
+ 		}
+ 	}		
+ 	
+ 	// See if you have neither the Shotgun or Super Shotgun
+         if ( !(self.items & IT_SHOTGUN) && !(self.items & IT_SUPER_SHOTGUN) )
+ 	{
+ 		if( self.ammo_shells >= 20 ) {
+ 			item.ammo_shells = 20;
+ 			self.ammo_shells = self.ammo_shells - 20;
+ 		}
+ 		else
+ 		{
+ 			item.ammo_shells = self.ammo_shells;
+ 			self.ammo_shells = 0;
+ 		}
+ 	}		
+ 	
+ 	// See if we are using a nailgun
+         if ( (self.weapon == IT_NAILGUN) || (self.weapon == IT_SUPER_NAILGUN) )
+ 	{
+ 		if( self.ammo_nails >= 20 )
+ 		{
+ 			item.ammo_nails = 20;
+ 			self.ammo_nails = self.ammo_nails - 20;
+ 		}
+ 		else
+ 		{
+ 			item.ammo_nails = self.ammo_nails;
+ 			self.ammo_nails = 0;
+ 		}
+ 	}	
+ 	// Check to see if we have neither nailgun
+         if ( !(self.items & IT_NAILGUN) && !(self.items & IT_SUPER_NAILGUN) )
+ 	{
+ 		if( self.ammo_nails >= 20 )
+ 		{
+ 			item.ammo_nails = 20;
+ 			self.ammo_nails = self.ammo_nails - 20;
+ 		}
+ 		else
+ 		{
+ 			item.ammo_nails = self.ammo_nails;
+ 			self.ammo_nails = 0;
+ 		}
+ 	}	
+ 	
+ 	// See if we are using a grenade or rocket launcher
+         if ( (self.weapon == IT_GRENADE_LAUNCHER) || (self.weapon == IT_ROCKET_LAUNCHER) )
+ 	{
+ 		if( self.ammo_rockets >= 10 )
+ 		{
+ 			item.ammo_rockets = 10;
+ 			self.ammo_rockets = self.ammo_rockets - 10;
+ 		}
+ 		else
+ 		{
+ 			item.ammo_rockets = self.ammo_rockets;
+ 			self.ammo_rockets = 0;
+ 		}
+ 	}
+ 	// See if we have neither the Grenade or rocket launcher
+         if ( !(self.items & IT_GRENADE_LAUNCHER) && !(self.items & IT_ROCKET_LAUNCHER) )
+ 	{
+ 		if( self.ammo_rockets >= 10 )
+ 		{
+ 			item.ammo_rockets = 10;
+ 			self.ammo_rockets = self.ammo_rockets - 10;
+ 		}
+ 		else
+ 		{
+ 			item.ammo_rockets = self.ammo_rockets;
+ 			self.ammo_rockets = 0;
+ 		}
+ 	}
+ 
+ 	// See if we're using the lightning gun
+ 	if ( self.weapon == IT_LIGHTNING )
+ 	{	
+ 		if( self.ammo_cells >= 20 )
+ 		{
+ 			item.ammo_cells = 20;
+ 			self.ammo_cells = self.ammo_cells - 20;
+ 		}
+ 		else
+ 		{
+ 			item.ammo_cells = self.ammo_cells;
+ 			self.ammo_cells = 0;
+ 		}
+ 	}
+ 	// see if we don't have the lightning gun
+         if ( !(self.items & IT_LIGHTNING) )
+ 	{	
+ 		if( self.ammo_cells >= 20 )
+ 		{
+ 			item.ammo_cells = 20;
+ 			self.ammo_cells = self.ammo_cells - 20;
+ 		}
+ 		else
+ 		{
+ 			item.ammo_cells = self.ammo_cells;
+ 			self.ammo_cells = 0;
+ 		}
+ 	}
+ 	 
+ 	item.owner = self;
+ 	makevectors(self.v_angle);
+ 
+ 	setorigin(item, self.origin + '0 0 16');
+ 	item.velocity = aim(self, 1000);
+ 	item.velocity = item.velocity * 500;
+ 	item.flags = FL_ITEM;
+ 	item.solid = SOLID_TRIGGER;
+ 	item.movetype = MOVETYPE_BOUNCE;
+ 
+ 	setmodel (item, "progs/backpack.mdl");
+ 	setsize(item, '-16 -16 0', '16 16 56');
+ 	item.touch = BackpackTouch;
+ 	item.nextthink = time + 120;	// remove after 2 minutes
+ 	item.think = SUB_Remove;
+ 
+ 	W_SetCurrentAmmo();
+ 
+ };
+ 
+ void() Team_weapon_touch =
+ {
+ 	local	float	hadammo, best, new, old;
+ 	local	entity	stemp;
+ 
+ 	if (!(other.flags & FL_CLIENT))
+ 		return;
+ 	// Don't let the owner pick up his own weapon for a second.
+ 	if ( (other == self.owner) && ( (self.nextthink - time) > 119 ) )
+ 		return;
+ 
+ // if the player was using his best weapon, change up to the new one if better		
+ 	stemp = self;
+ 	self = other;
+ 	best = W_BestWeapon();
+ 	self = stemp;
+ 
+ 	if (self.classname == "weapon_nailgun")
+ 	{
+ 		hadammo = other.ammo_nails;			
+ 		new = IT_NAILGUN;
+ 	}
+ 	else if (self.classname == "weapon_supernailgun")
+ 	{
+ 		hadammo = other.ammo_rockets;			
+ 		new = IT_SUPER_NAILGUN;
+ 	}
+ 	else if (self.classname == "weapon_supershotgun")
+ 	{
+ 		hadammo = other.ammo_rockets;			
+ 		new = IT_SUPER_SHOTGUN;
+ 	}
+ 	else if (self.classname == "weapon_rocketlauncher")
+ 	{
+ 		hadammo = other.ammo_rockets;			
+ 		new = IT_ROCKET_LAUNCHER;
+ 	}
+ 	else if (self.classname == "weapon_grenadelauncher")
+ 	{
+ 		hadammo = other.ammo_rockets;			
+ 		new = IT_GRENADE_LAUNCHER;
+ 	}
+ 	else if (self.classname == "weapon_lightning")
+ 	{
+ 		hadammo = other.ammo_rockets;			
+ 		new = IT_LIGHTNING;
+ 	}
+ 	else
+ 		objerror ("Team_weapon_touch: unknown classname");
+ 
+ 	sprint (other, PRINT_HIGH, "You got the ");
+ 	sprint (other, PRINT_HIGH, self.netname);
+ 	sprint (other, PRINT_HIGH, "\n");
+ // weapon touch sound
+ 	sound (other, CHAN_ITEM, "weapons/pkup.wav", 1, ATTN_NORM);
+ 	stuffcmd (other, "bf\n");
+ 
+ 	bound_other_ammo ();
+ 
+ // change to the weapon
+ 	old = other.items;
+ 	other.items = other.items | new;
+ 	
+ 	stemp = self;
+ 	self = other;
+ 
+ 	if (!deathmatch)
+ 		self.weapon = new;
+ 	else
+ 		Deathmatch_Weapon (old, new);
+ 
+ 	W_SetCurrentAmmo();
+ 
+ 	self = stemp;
+ 
+ 	self.model = string_null;
+ 	self.solid = SOLID_NOT;
+ 	
+ 	activator = other;
+ 	SUB_UseTargets();				// fire all targets / killtargets
+ };
+         
+ void() TossWeapon =
+ {
+ 	local entity item;
+ 	
+ 	if((self.weapon == IT_AXE) || (self.weapon == IT_SHOTGUN))
+ 		return;
+ 		
+ 	item = spawn();
+ 	item.owner = self;
+ 	makevectors(self.v_angle);
+ 
+ 	setorigin(item, self.origin + '0 0 16');
+ 	item.velocity = aim(self, 1000);
+ 	item.velocity = item.velocity * 500;
+ 	item.flags = FL_ITEM;
+ 	item.solid = SOLID_TRIGGER;
+ 	item.movetype = MOVETYPE_BOUNCE;
+ 	
+ 	if(self.weapon == IT_SUPER_SHOTGUN)
+ 	{
+ 		setmodel (item, "progs/g_shot.mdl");
+ 		item.weapon = IT_SUPER_SHOTGUN;
+ 		item.netname = "Double-barrelled Shotgun";
+ 		item.classname = "weapon_supershotgun";
+ 		self.items = self.items - IT_SUPER_SHOTGUN;
+ 	}
+ 
+ 	if( self.weapon == IT_NAILGUN )
+ 	{
+ 		setmodel (item, "progs/g_nail.mdl");
+ 		item.weapon = IT_NAILGUN;
+ 		item.netname = "nailgun";
+ 		item.classname = "weapon_nailgun";
+ 		self.items = self.items - IT_NAILGUN;
+ 	}
+ 		
+ 	if( self.weapon == IT_SUPER_NAILGUN )
+ 	{
+ 		setmodel (item, "progs/g_nail2.mdl");
+ 		item.weapon = IT_SUPER_NAILGUN;
+ 		item.netname = "Super Nailgun";
+ 		item.classname = "weapon_supernailgun";
+ 		self.items = self.items - IT_SUPER_NAILGUN;
+ 	}
+ 	
+ 	if( self.weapon == IT_GRENADE_LAUNCHER )
+ 	{
+ 		setmodel (item, "progs/g_rock.mdl");
+ 		item.weapon = 3;
+ 		item.netname = "Grenade Launcher";
+ 		item.classname = "weapon_grenadelauncher";
+ 		self.items = self.items - IT_GRENADE_LAUNCHER;
+ 	}
+ 	
+ 	if( self.weapon == IT_ROCKET_LAUNCHER )
+ 	{
+ 		setmodel (item, "progs/g_rock2.mdl");
+ 		item.weapon = 3;
+ 		item.netname = "Rocket Launcher";
+ 		item.classname = "weapon_rocketlauncher";
+ 		self.items = self.items - IT_ROCKET_LAUNCHER;
+ 	}
+ 	
+ 	if( self.weapon == IT_LIGHTNING )
+ 	{
+ 		setmodel (item, "progs/g_light.mdl");
+ 		item.weapon = 3;
+ 		item.netname = "Thunderbolt";
+ 		item.classname = "weapon_lightning";
+ 		self.items = self.items - IT_LIGHTNING;
+ 	}
+ 	setsize(item, '-16 -16 0', '16 16 56');
+ 	item.touch = Team_weapon_touch;
+ 	item.think = SUB_Null;
+ 	item.nextthink = time + 120;
+ 	
+ 	self.weapon = W_BestWeapon();
+ 	W_SetCurrentAmmo();
+ };
+ 
+ /*
+ ================
+ TeamPrintSettings
+ 
+ Print out current teamplay options
+ ================
+ */
+ 
+ void() TeamPrintSettings =
+ {
+ 	local string s;
+ 	
+ 	sprint(self,PRINT_HIGH,"The following Teamplay options are set:\n");
+ 	
+ 	if(teamplay < 0)
+ 	{
+ 		sprint(self, PRINT_HIGH, "Frag penalty manually set to ");
+ 		s = ftos(teamplay);
+ 		sprint(self, PRINT_HIGH, s);
+ 		sprint(self, PRINT_HIGH, "\n");
+ 		return;
+ 	}
+ 	
+ 	if(!teamplay) 
+ 	{
+ 		sprint(self, PRINT_HIGH, "None\n");
+ 		return;
+ 	}
+ 	
+ 	if(1 == teamplay)
+ 	{
+ 		sprint(self, PRINT_HIGH, "ID's original teamplay 1\n");
+ 		return;
+ 	}
+ 	
+ 	if(teamplay & TEAM_HEALTH_PROTECT)
+ 		sprint(self, PRINT_HIGH, "Health-Protect\n");
+ 	
+ 	if(teamplay & TEAM_ARMOR_PROTECT)
+ 		sprint(self, PRINT_HIGH, "Armor-Protect\n");
+ 		
+ 	if(teamplay & TEAM_ATTACKER_DAMAGE)
+ 		sprint(self, PRINT_HIGH, "Mirror-Damage\n");
+ 		
+ 	if(teamplay & TEAM_FRAG_PENALTY)
+ 		sprint(self, PRINT_HIGH, "Frag-Penalty\n");
+ 		
+ 	if(teamplay & TEAM_DEATH_PENALTY)
+ 		sprint(self, PRINT_HIGH, "Death-Penalty\n");
+ 		
+ 	if(teamplay & TEAM_LOCK_COLORS)
+ 		sprint(self, PRINT_HIGH, "Lock-Colors\n");
+ 		
+ 	if(teamplay & TEAM_STATIC_TEAMS)
+ 		sprint(self, PRINT_HIGH, "Static-Teams\n");
+ 
+ 	if(teamplay & TEAM_FAIR_TEAMS)
+ 		sprint(self, PRINT_HIGH, "Fair-Teams\n");
+ 
+ 	if(teamplay & TEAM_ENFORCE_SHIRT)
+ 		sprint(self, PRINT_HIGH, "Enforced-Shirts\n");
+ 
+ 	if(teamplay & TEAM_DROP_ITEMS)
+ 		sprint(self, PRINT_HIGH, "Drop-Items (Backpack Impulse 20, Weapon Impulse 21)\n");
+ 
+ 	if(teamplay & TEAM_BOOT_NEGS)
+ 	{
+ 		sprint(self, PRINT_HIGH, "Frag Floor (min set to ");
+ 		s = ftos(TEAM_FRAG_FLOOR);
+ 		sprint(self, PRINT_HIGH, s);
+ 		sprint(self, PRINT_HIGH, ")\n");
+ 
+ 	}
+ 		
+ 	if(teamplay & TEAM_FF_NOTICE)
+ 		sprint(self, PRINT_HIGH, "Friendly-Fire-Notice\n");
+ 
+ 	if(teamplay & TEAM_SCORING)
+ 		sprint(self, PRINT_HIGH, "Team-Scoring\n");
+ 
+ 	if(ctf)
+ 		sprint(self, PRINT_HIGH, "Capture-The-Flag\n");
+ 
+ };
\ No newline at end of file
diff -crbB --unidirectional-new-file qw201/triggers.qc expert12/triggers.qc
*** qw201/triggers.qc	Tue Aug 12 15:31:50 1997
--- expert12/triggers.qc	Sun Aug 17 01:18:16 1997
***************
*** 232,252 ****
  		if (activator.classname == "player"
  		&& (self.spawnflags & SPAWNFLAG_NOMESSAGE) == 0)
  		{
  			if (self.count >= 4)
! 				centerprint (activator, "There are more to go...");
  			else if (self.count == 3)
! 				centerprint (activator, "Only 3 more to go...");
  			else if (self.count == 2)
! 				centerprint (activator, "Only 2 more to go...");
  			else
! 				centerprint (activator, "Only 1 more to go...");
  		}
  		return;
  	}
  	
  	if (activator.classname == "player"
  	&& (self.spawnflags & SPAWNFLAG_NOMESSAGE) == 0)
! 		centerprint(activator, "Sequence completed!");
  	self.enemy = activator;
  	multi_trigger ();
  };
--- 232,254 ----
  		if (activator.classname == "player"
  		&& (self.spawnflags & SPAWNFLAG_NOMESSAGE) == 0)
  		{
+ 			// Expert
+ 			// Avoid centerprints
  			if (self.count >= 4)
! 				sprint (activator, PRINT_MEDIUM, "There are more to go...\n");
  			else if (self.count == 3)
! 				sprint (activator, PRINT_MEDIUM, "Only 3 more to go...\n");
  			else if (self.count == 2)
! 				sprint (activator, PRINT_MEDIUM, "Only 2 more to go...\n");
  			else
! 				sprint (activator, PRINT_MEDIUM, "Only 1 more to go...\n");
  		}
  		return;
  	}
  	
  	if (activator.classname == "player"
  	&& (self.spawnflags & SPAWNFLAG_NOMESSAGE) == 0)
! 		sprint(activator, PRINT_MEDIUM, "Sequence completed!\n");
  	self.enemy = activator;
  	multi_trigger ();
  };
***************
*** 327,333 ****
  	if (other.classname == "player")
  	{
  		if (other.invincible_finished > time &&
! 			self.owner.invincible_finished > time) {
  			self.classname = "teledeath3";
  			other.invincible_finished = 0;
  			self.owner.invincible_finished = 0;
--- 329,336 ----
  	if (other.classname == "player")
  	{
  		if (other.invincible_finished > time &&
! 			self.owner.invincible_finished > time &&
! 			!(deathmatch & DM_ALTERNATE_POWERUPS)) {
  			self.classname = "teledeath3";
  			other.invincible_finished = 0;
  			self.owner.invincible_finished = 0;
***************
*** 337,343 ****
  			T_Damage (other2, self, self, 50000);
  		}
  			
! 		if (other.invincible_finished > time)
  		{
  			self.classname = "teledeath2";
  			T_Damage (self.owner, self, self, 50000);
--- 340,346 ----
  			T_Damage (other2, self, self, 50000);
  		}
  
! 		if ((other.invincible_finished > time) && !(deathmatch & DM_ALTERNATE_POWERUPS))
  		{
  			self.classname = "teledeath2";
  			T_Damage (self.owner, self, self, 50000);
***************
*** 423,428 ****
--- 426,434 ----
  	other.angles = t.mangle;
  	if (other.classname == "player")
  	{
+ 		// Teleporting - detach hook (wedge)
+ 		if (other.hook_out)
+ 			Reset_Grapple(other);
  		other.fixangle = 1;		// turn this way immediately
  		other.teleport_time = time + 0.7;
  		if (other.flags & FL_ONGROUND)
***************
*** 521,527 ****
  	{
  		if (self.message != "")
  		{
! 			centerprint (other, self.message);
  			sound (other, CHAN_BODY, "misc/talk.wav", 1, ATTN_NORM);
  		}
  	}
--- 527,537 ----
  	{
  		if (self.message != "")
  		{
! 			// Expert
! 			// Avoid centerprints
! 			sprint (other, PRINT_MEDIUM, self.message);
! 			sprint (other, PRINT_MEDIUM, "\n");
! 			//centerprint (other, self.message);
  			sound (other, CHAN_BODY, "misc/talk.wav", 1, ATTN_NORM);
  		}
  	}
***************
*** 595,600 ****
--- 606,648 ----
  		remove(self);
  };
  
+ void() trigger_respawn_touch =
+ {
+ local entity spot;
+ 
+ 	if ((other.health > 0) && (other.classname == "player") && (other.netname != self.owner.netname))
+ 	{
+ 		// if another playwe is present at the spawn position,
+ 		// move to another spawn point
+ 		spot = SelectSpawnPoint();
+ 		setorigin(self.owner, spot.origin + '0 0 1');
+ 		spawn_tfog(spot.origin);
+ 		// 100% spawnfrag prevention
+ 		spawn_trespawn (spot.origin, self);
+ 		self.owner.angles = spot.angles;
+ 		self.owner.fixangle = TRUE;           // turn this way immediately
+ 	}
+ };
+ 
+ void(vector org, entity spawner) spawn_trespawn =
+ {
+ local entity	pusher;
+ 
+ 	pusher = spawn();
+ 	pusher.classname = "trigger_respawn";
+ 	pusher.movetype = MOVETYPE_NONE;
+ 	pusher.solid = SOLID_TRIGGER;
+ 	pusher.angles = '0 0 0';
+ 	setsize (pusher, spawner.mins - '1 1 1', spawner.maxs + '1 1 1');
+ 	setorigin (pusher, org);
+ 	pusher.touch = trigger_respawn_touch;
+ 	pusher.nextthink = time + 0.2;
+ 	pusher.think = SUB_Remove;
+ 	pusher.owner = spawner;
+ 	pusher.angles = spawner.angles;
+ 
+ 	force_retouch = 2;		// make sure even still objects get hit
+ };
  
  /*QUAKED trigger_push (.5 .5 .5) ? PUSH_ONCE
  Pushes the player
diff -crbB --unidirectional-new-file qw201/weapons.qc expert12/weapons.qc
*** qw201/weapons.qc	Tue Aug 12 14:22:18 1997
--- expert12/weapons.qc	Fri Aug 15 04:29:44 1997
***************
*** 1,5 ****
--- 1,9 ----
+ // Expert: McBain's PreviousWeaponCommand
+ .float previous_weapon;
+ 
  /*
  */
+ void () player_chain1; // prototype from player.qc
  void (entity targ, entity inflictor, entity attacker, float damage) T_Damage;
  void () player_run;
  void(entity bomb, entity attacker, float rad, entity ignore, string dtype) T_RadiusDamage;
***************
*** 10,15 ****
--- 14,34 ----
  // called by worldspawn
  void() W_Precache =
  {
+ 	precache_model ("progs/quaddama.mdl"); // precache powerups somewhere
+ 	precache_sound ("items/damage.wav");   // for DM_RANDOMIZE_POWERUPS
+ 	precache_sound ("items/damage2.wav");
+ 	precache_sound ("items/damage3.wav");
+ 
+ 	precache_model ("progs/invisibl.mdl");
+ 	precache_sound ("items/inv1.wav");
+ 	precache_sound ("items/inv2.wav");
+ 	precache_sound ("items/inv3.wav");
+ 
+ 	precache_model ("progs/invulner.mdl");
+ 	precache_sound ("items/protect.wav");
+ 	precache_sound ("items/protect2.wav");
+ 	precache_sound ("items/protect3.wav");
+ 
  	precache_sound ("weapons/r_exp3.wav");  // new rocket explosion
  	precache_sound ("weapons/rocket1i.wav");        // spike gun
  	precache_sound ("weapons/sgun1.wav");
***************
*** 22,27 ****
--- 41,57 ----
  	precache_sound ("weapons/grenade.wav"); // grenade launcher
  	precache_sound ("weapons/bounce.wav");          // grenade bounce
  	precache_sound ("weapons/shotgn2.wav"); // super shotgun
+ 
+ 	// Expert DM
+ 	if (cvar("deathmatch") & DM_GRAPPLE) {
+ 	      //grapple sounds (wedge)
+ 		precache_sound ("weapons/chain1.wav");
+ 		precache_sound ("weapons/chain2.wav");
+ 		precache_sound ("weapons/chain3.wav");
+ 		precache_sound ("weapons/bounce2.wav");
+ 		precache_sound ("blob/land1.wav");
+ 	}
+ 
  };
  
  float() crandom =
***************
*** 38,43 ****
--- 68,74 ----
  {
  	local   vector  source;
  	local   vector  org;
+ 	local   float   damage;
  
  	makevectors (self.v_angle);
  	source = self.origin + '0 0 16';
***************
*** 50,60 ****
  	if (trace_ent.takedamage)
  	{
  		trace_ent.axhitme = 1;
! 		SpawnBlood (org, 20);
! 		if (deathmatch > 3)
! 			T_Damage (trace_ent, self, self, 75);
  		else
! 			T_Damage (trace_ent, self, self, 20);
  	}
  	else
  	{       // hit wall
--- 81,94 ----
  	if (trace_ent.takedamage)
  	{
  		trace_ent.axhitme = 1;
! 		if (deathmatch & DM_BALANCED_WEAPONS)
! 			damage = DM_AXE_DAMAGE;
! 		else if (deathmatch & DM_FREE_GEAR)
! 			damage = 75;
  		else
! 			damage = 20;
! 		SpawnBlood (org, damage);
! 		T_Damage (trace_ent, self, self, damage);
  	}
  	else
  	{       // hit wall
***************
*** 266,271 ****
--- 303,309 ----
  {
  	local   vector direction;
  	local   vector  src;
+ 	local   float   damage;
  
  	makevectors(self.v_angle);
  
***************
*** 279,288 ****
  
  	while (shotcount > 0)
  	{
  		direction = dir + crandom()*spread_x*v_right + crandom()*spread_y*v_up;
  		traceline (src, src + direction*2048, FALSE, self);
  		if (trace_fraction != 1.0)
! 			TraceAttack (4, direction);
  
  		shotcount = shotcount - 1;
  	}
--- 317,331 ----
  
  	while (shotcount > 0)
  	{
+ 
  		direction = dir + crandom()*spread_x*v_right + crandom()*spread_y*v_up;
  		traceline (src, src + direction*2048, FALSE, self);
+ 		if (deathmatch & DM_BALANCED_WEAPONS)
+ 			damage = DM_BULLET_DAMAGE;
+ 		else
+ 			damage = 4;
  		if (trace_fraction != 1.0)
! 			TraceAttack (damage, direction);
  
  		shotcount = shotcount - 1;
  	}
***************
*** 297,314 ****
  */
  void() W_FireShotgun =
  {
! 	local vector dir;
  
  	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM); 
  
  	msg_entity = self;
  	WriteByte (MSG_ONE, SVC_SMALLKICK);
  	
! 	if (deathmatch != 4 )
  		self.currentammo = self.ammo_shells = self.ammo_shells - 1;
  
  	dir = aim (self, 100000);
! 	FireBullets (6, dir, '0.04 0.04 0');
  };
  
  
--- 340,367 ----
  */
  void() W_FireShotgun =
  {
! 	// Expert DM
! 	local vector dir, spread;
! 	local float  numShots;
  
  	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM); 
  
  	msg_entity = self;
  	WriteByte (MSG_ONE, SVC_SMALLKICK);
  
! 	if (! ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) )
  		self.currentammo = self.ammo_shells = self.ammo_shells - 1;
  
  	dir = aim (self, 100000);
! 	// Expert DM
! 	if (deathmatch & DM_BALANCED_WEAPONS) {
! 		numShots = DM_SG_SHOTS;
! 		spread = DM_SG_SPREAD;
! 	} else {
! 		numShots = 6;
! 		spread = '0.04 0.04 0';
! 	}
! 	FireBullets (numShots, dir, spread);
  };
  
  
***************
*** 319,325 ****
  */
  void() W_FireSuperShotgun =
  {
! 	local vector dir;
  
  	if (self.currentammo == 1)
  	{
--- 372,380 ----
  */
  void() W_FireSuperShotgun =
  {
! 	// Expert DM
! 	local vector dir, spread;
! 	local float  numShots;
  
  	if (self.currentammo == 1)
  	{
***************
*** 332,341 ****
  	msg_entity = self;
  	WriteByte (MSG_ONE, SVC_BIGKICK);
  	
! 	if (deathmatch != 4)
  		self.currentammo = self.ammo_shells = self.ammo_shells - 2;
  	dir = aim (self, 100000);
! 	FireBullets (14, dir, '0.14 0.08 0');
  };
  
  
--- 387,405 ----
  	msg_entity = self;
  	WriteByte (MSG_ONE, SVC_BIGKICK);
  	
! 	if (! ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) )
  		self.currentammo = self.ammo_shells = self.ammo_shells - 2;
+ 
  	dir = aim (self, 100000);
! 	// Expert DM
! 	if (deathmatch & DM_BALANCED_WEAPONS) {
! 		numShots = DM_SSG_SHOTS;
! 		spread = DM_SSG_SPREAD;
! 	} else {
! 		numShots = 14;
! 		spread = '0.14 0.08 0';
! 	}
! 	FireBullets (numShots, dir, spread);
  };
  
  
***************
*** 351,356 ****
--- 415,423 ----
  {
  	local float     damg;
  
+ 	if (other == self.owner)
+ 		return;         // don't explode on owner
+ 
  //	if (deathmatch == 4)
  //	{
  //	if ( ((other.weapon == 32) || (other.weapon == 16)))
***************
*** 368,377 ****
  //		}	
  //	}
  
- 	if (other == self.owner)
- 		return;         // don't explode on owner
- 
  	if (self.voided) {
  		return;
  	}
  	self.voided = 1;
--- 435,442 ----
  //		}	
  //	}
  
  	if (self.voided) {
+ //		bprint(PRINT_HIGH, "Duplicate missile touch: ROCKET\n");
  		return;
  	}
  	self.voided = 1;
***************
*** 382,387 ****
--- 447,456 ----
  		return;
  	}
  
+ 	// Expert DM
+ 	if (deathmatch & DM_BALANCED_WEAPONS)
+ 		damg = DM_ROCKET_DIRECT_DAMAGE;
+ 	else
  		damg = 100 + random()*20;
  	
  	if (other.health)
***************
*** 390,400 ****
  		T_Damage (other, self, self.owner, damg );
  	}
  
  	// don't do radius damage to the other, because all the damage
  	// was done in the impact
! 
! 
! 	T_RadiusDamage (self, self.owner, 120, other, "rocket");
  
  //  sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
  	self.origin = self.origin - 8 * normalize(self.velocity);
--- 459,472 ----
  		T_Damage (other, self, self.owner, damg );
  	}
  
+ 	// Expert DM
+ 	if (deathmatch & DM_BALANCED_WEAPONS)
+ 		damg = DM_ROCKET_SPLASH_DAMAGE;
+ 	else
+ 		damg = 120;
  	// don't do radius damage to the other, because all the damage
  	// was done in the impact
! 	T_RadiusDamage (self, self.owner, damg, other, "rocket");
  
  //      sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
  	self.origin = self.origin - 8 * normalize(self.velocity);
***************
*** 418,424 ****
  */
  void() W_FireRocket =
  {
! 	if (deathmatch != 4)
  		self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
  	
  	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
--- 490,496 ----
  */
  void() W_FireRocket =
  {
! 	if (! ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) )
  		self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
  	
  	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
***************
*** 430,435 ****
--- 502,508 ----
  	newmis.owner = self;
  	newmis.movetype = MOVETYPE_FLYMISSILE;
  	newmis.solid = SOLID_BBOX;
+ 	newmis.classname = "rocket";
  		
  // set newmis speed     
  
***************
*** 437,442 ****
--- 510,519 ----
  	newmis.velocity = aim(self, 1000);
  	newmis.velocity = newmis.velocity * 1000;
  	newmis.angles = vectoangles(newmis.velocity);
+ 	// Expert DM
+ 	if (deathmatch & DM_REAL_PHYSICS)
+ 		newmis.velocity = newmis.velocity + self.velocity;
+ 
  	
  	newmis.touch = T_MissileTouch;
  	newmis.voided = 0;
***************
*** 444,450 ****
  // set newmis duration
  	newmis.nextthink = time + 5;
  	newmis.think = SUB_Remove;
- 	newmis.classname = "rocket";
  
  	setmodel (newmis, "progs/missile.mdl");
  	setsize (newmis, '0 0 0', '0 0 0');             
--- 521,526 ----
***************
*** 520,542 ****
  {
  	local   vector          org;
  	local   float           cells;
  
  	if (self.ammo_cells < 1)
  	{
  		self.weapon = W_BestWeapon ();
  		W_SetCurrentAmmo ();
  		return;
  	}
  
  // explode if under water
  	if (self.waterlevel > 1)
  	{
! 		if (deathmatch > 3)
! 		{
  			if (random() <= 0.5)
  			{
  				self.deathtype = "selfwater";
! 				T_Damage (self, self, self.owner, 4000 );
  			}
  			else
  			{
--- 598,641 ----
  {
  	local   vector          org;
  	local   float           cells;
+ 	local   float		damage;
+ 
+ 	local string s;
  
  	if (self.ammo_cells < 1)
  	{
+ 		// Expert DM
+ 		// If using lightning while in alternate weapon mode
+ 		// and out of ammo, pick new weapon by alternates rules
+ 		if (self.weaponmode) {
+ 			self.weapon = W2_BestWeapon ();
+ 			W2_SetCurrentAmmo ();
+ 		} else {
  			self.weapon = W_BestWeapon ();
  			W_SetCurrentAmmo ();
+ 		}
  		return;
  	}
  
  // explode if under water
  	if (self.waterlevel > 1)
  	{
! 		// Expert DM
! 		// Only hurt yourself.  There's just nothing good about discharge.
! 		if (deathmatch & DM_BALANCED_WEAPONS) {
! 			cells = self.ammo_cells;
! 			self.ammo_cells = 0;
! 			self.deathtype = "selfwater";
! 			T_Damage (self, self, self.owner, DM_LIGHTNING_DISCHARGE*cells);
! 			self.deathtype = "";
! 			return;
! 		} else if (deathmatch & DM_FREE_GEAR) {
! 			// deathmatch 4&5 rules
  			if (random() <= 0.5)
  			{
  				self.deathtype = "selfwater";
! 				T_Damage (self, self, self.owner, 4000);
! 				return;
  			}
  			else
  			{
***************
*** 552,558 ****
  			cells = self.ammo_cells;
  			self.ammo_cells = 0;
  			W_SetCurrentAmmo ();
! 			T_RadiusDamage (self, self, 35*cells, world,"");
  			return;
  		}
  	}
--- 651,657 ----
  			cells = self.ammo_cells;
  			self.ammo_cells = 0;
  			W_SetCurrentAmmo ();
! 			T_RadiusDamage (self, self, 35*cells, world, "");
  			return;
  		}
  	}
***************
*** 565,572 ****
  	msg_entity = self;
  	WriteByte (MSG_ONE, SVC_SMALLKICK);
  
! 	if (deathmatch != 4)
! 		self.currentammo = self.ammo_cells = self.ammo_cells - 1;
  
  	org = self.origin + '0 0 16';
  	
--- 664,683 ----
  	msg_entity = self;
  	WriteByte (MSG_ONE, SVC_SMALLKICK);
  
! 	// Expert DM
! 	// In "Balanced Weapons" mode, ammo consumption no longer needs to
! 	// be a constraint on the LG.
! 	if (! ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) ) {
! 		if (deathmatch & DM_BALANCED_WEAPONS)
! 			damage = 0.5;
! 		else
! 			damage = 1;
! 		// If in DM_PERFORMANCE mode, we're firing half as often at double
! 		// the damage, so use normal cell consumption rate.
!  		if (deathmatch & DM_PERFORMANCE)
! 			damage = damage * 2;
! 		self.currentammo = self.ammo_cells = self.ammo_cells - damage;
! 	}
  
  	org = self.origin + '0 0 16';
  	
***************
*** 583,589 ****
  	WriteCoord (MSG_MULTICAST, trace_endpos_z);
  	multicast (org, MULTICAST_PHS);
  
! 	LightningDamage (self.origin, trace_endpos + v_forward*4, self, 30);
  };
  
  
--- 694,710 ----
  	WriteCoord (MSG_MULTICAST, trace_endpos_z);
  	multicast (org, MULTICAST_PHS);
  
! 	// Expert DM
! 	if (deathmatch & DM_BALANCED_WEAPONS)
! 		damage = DM_LIGHTNING_DAMAGE;
! 	else
! 		damage = 30;
! 	// Expert DM
! 	// Firing half as often as twice the damage per shot
! 	if (deathmatch & DM_PERFORMANCE)
! 		damage = damage * 2;
! 
! 	LightningDamage (self.origin, trace_endpos + v_forward*4, self, damage);
  };
  
  
***************
*** 592,603 ****
  
  void() GrenadeExplode =
  {
  	if (self.voided) {
  		return;
  	}
  	self.voided = 1;
  
! 	T_RadiusDamage (self, self.owner, 120, world, "grenade");
  
  	WriteByte (MSG_MULTICAST, SVC_TEMPENTITY);
  	WriteByte (MSG_MULTICAST, TE_EXPLOSION);
--- 713,734 ----
  
  void() GrenadeExplode =
  {
+ 
+ 	local float damage;
+ 
  	if (self.voided) {
+ //		bprint(PRINT_HIGH, "Duplicate missile touch: GRENADE\n");
  		return;
  	}
  	self.voided = 1;
  
! 	// Expert DM
! 	if (deathmatch & DM_BALANCED_WEAPONS)
! 		damage = DM_GRENADE_SPLASH_DAMAGE;
! 	else
! 		damage = 120;
! 
! 	T_RadiusDamage (self, self.owner, damage, world, "grenade");
  
  	WriteByte (MSG_MULTICAST, SVC_TEMPENTITY);
  	WriteByte (MSG_MULTICAST, TE_EXPLOSION);
***************
*** 630,636 ****
  */
  void() W_FireGrenade =
  {       
! 	if (deathmatch != 4)
  		self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
  	
  	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);
--- 762,771 ----
  */
  void() W_FireGrenade =
  {       
! 	// Expert DM
! 	local float forwardSpeed, upSpeed;
! 
! 	if (! ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) )
  		self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
  	
  	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);
***************
*** 639,645 ****
  	WriteByte (MSG_ONE, SVC_SMALLKICK);
  
  	newmis = spawn ();
! 	newmis.voided=0;
  	newmis.owner = self;
  	newmis.movetype = MOVETYPE_BOUNCE;
  	newmis.solid = SOLID_BBOX;
--- 774,780 ----
  	WriteByte (MSG_ONE, SVC_SMALLKICK);
  
  	newmis = spawn ();
! 	newmis.voided = 0;
  	newmis.owner = self;
  	newmis.movetype = MOVETYPE_BOUNCE;
  	newmis.solid = SOLID_BBOX;
***************
*** 650,662 ****
  	makevectors (self.v_angle);
  
  	if (self.v_angle_x)
! 		newmis.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
  	else
  	{
  		newmis.velocity = aim(self, 10000);
  		newmis.velocity = newmis.velocity * 600;
  		newmis.velocity_z = 200;
  	}
  
  	newmis.avelocity = '300 300 300';
  
--- 785,800 ----
  	makevectors (self.v_angle);
  
  	if (self.v_angle_x)
! 		newmis.velocity = v_forward*600 + v_up*200 + crandom()*v_right*10 + crandom()*v_up*10;
  	else
  	{
  		newmis.velocity = aim(self, 10000);
  		newmis.velocity = newmis.velocity * 600;
  		newmis.velocity_z = 200;
  	}
+ 	// Expert DM
+ 	if (deathmatch & DM_REAL_PHYSICS)
+ 		newmis.velocity = newmis.velocity + self.velocity;
  
  	newmis.avelocity = '300 300 300';
  
***************
*** 664,680 ****
  	
  	newmis.touch = GrenadeTouch;
  	
! // set newmis duration
! 	if (deathmatch == 4)
  	{
- 		newmis.nextthink = time + 2.5;		
  		self.attack_finished = time + 1.1;
  //		self.health = self.health - 1;
  		T_Damage (self, self, self.owner, 10 );
  	}
! 	else
! 		newmis.nextthink = time + 2.5;
  
  	newmis.think = GrenadeExplode;
  
  	setmodel (newmis, "progs/grenade.mdl");
--- 802,822 ----
  	
  	newmis.touch = GrenadeTouch;
  	
! 	// Expert DM - commented out
! 	// Damage for throwing grenades in "deathmatch 4".  In normal "deathmatch 4",
! 	// no GL is given out, so this code is never entered.  With Expert balance
! 	// options also set, GL is given out, and it shouldn't hurt to fire it.
! /*
! 	if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
  	{
  		self.attack_finished = time + 1.1;
  //		self.health = self.health - 1;
  		T_Damage (self, self, self.owner, 10 );
  	}
! */
  
+ // set newmis duration
+ 	newmis.nextthink = time + 2.5;
  	newmis.think = GrenadeExplode;
  
  	setmodel (newmis, "progs/grenade.mdl");
***************
*** 699,705 ****
  void(vector org, vector dir) launch_spike =
  {
  	newmis = spawn ();
! 	newmis.voided=0;
  	newmis.owner = self;
  	newmis.movetype = MOVETYPE_FLYMISSILE;
  	newmis.solid = SOLID_BBOX;
--- 841,849 ----
  void(vector org, vector dir) launch_spike =
  {
  	newmis = spawn ();
! 
! 	newmis.voided = 0;
! 
  	newmis.owner = self;
  	newmis.movetype = MOVETYPE_FLYMISSILE;
  	newmis.solid = SOLID_BBOX;
***************
*** 724,733 ****
  	
  	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
  	self.attack_finished = time + 0.2;
! 	if (deathmatch != 4) 
  		self.currentammo = self.ammo_nails = self.ammo_nails - 2;
  	dir = aim (self, 1000);
  	launch_spike (self.origin + '0 0 16', dir);
  	newmis.touch = superspike_touch;
  	setmodel (newmis, "progs/s_spike.mdl");
  	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);               
--- 868,887 ----
  	
  	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
  	self.attack_finished = time + 0.2;
! 
! 	if (! ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) ) {
! 		if (deathmatch & DM_BALANCED_WEAPONS) {
! 			self.currentammo = self.ammo_nails = self.ammo_nails - 1;
! 		} else {
  			self.currentammo = self.ammo_nails = self.ammo_nails - 2;
+ 		}
+ 	}
+ 
  	dir = aim (self, 1000);
  	launch_spike (self.origin + '0 0 16', dir);
+ 	// Expert DM
+ 	if (deathmatch & DM_REAL_PHYSICS)
+ 		newmis.velocity = newmis.velocity + self.velocity;
  	newmis.touch = superspike_touch;
  	setmodel (newmis, "progs/s_spike.mdl");
  	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);               
***************
*** 750,767 ****
  
  	if (self.ammo_nails < 1)
  	{
  		self.weapon = W_BestWeapon ();
  		W_SetCurrentAmmo ();
  		return;
  	}
  
  	sound (self, CHAN_WEAPON, "weapons/rocket1i.wav", 1, ATTN_NORM);
  	self.attack_finished = time + 0.2;
! 	if (deathmatch != 4)
  		self.currentammo = self.ammo_nails = self.ammo_nails - 1;
  	dir = aim (self, 1000);
  	launch_spike (self.origin + '0 0 16' + v_right*ox, dir);
! 
  	msg_entity = self;
  	WriteByte (MSG_ONE, SVC_SMALLKICK);
  };
--- 904,934 ----
  
  	if (self.ammo_nails < 1)
  	{
+ 		// Expert DM
+ 		// If using nailgun while in alternate weapon mode
+ 		// and out of ammo, pick new weapon by alternates rules
+ 		if (self.weaponmode) {
+ 			self.weapon = W2_BestWeapon ();
+ 			W2_SetCurrentAmmo ();
+ 		} else {
  			self.weapon = W_BestWeapon ();
  			W_SetCurrentAmmo ();
+ 		}
  		return;
  	}
  
  	sound (self, CHAN_WEAPON, "weapons/rocket1i.wav", 1, ATTN_NORM);
  	self.attack_finished = time + 0.2;
! 	if (! ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) )
  		self.currentammo = self.ammo_nails = self.ammo_nails - 1;
  	dir = aim (self, 1000);
  	launch_spike (self.origin + '0 0 16' + v_right*ox, dir);
! 	// Expert DM
! 	if (deathmatch & DM_BALANCED_WEAPONS)
! 		newmis.velocity = dir * DM_NAIL_AIRSPEED;
! 	// Expert DM
! 	if (deathmatch & DM_REAL_PHYSICS)
! 		newmis.velocity = newmis.velocity + self.velocity;
  	msg_entity = self;
  	WriteByte (MSG_ONE, SVC_SMALLKICK);
  };
***************
*** 772,781 ****
--- 939,951 ----
  void() spike_touch =
  {
  local float rand;
+ local float damage;
+ 
  	if (other == self.owner)
  		return;
  
  	if (self.voided) {
+ //		bprint(PRINT_HIGH, "Duplicate missile touch: NAIL\n");
  		return;
  	}
  	self.voided = 1;
***************
*** 792,800 ****
  // hit something that bleeds
  	if (other.takedamage)
  	{
! 		spawn_touchblood (9);
  		other.deathtype = "nail";
! 		T_Damage (other, self, self.owner, 9);
  	}
  	else
  	{
--- 962,979 ----
  // hit something that bleeds
  	if (other.takedamage)
  	{
! 		// Expert DM
! 		if (deathmatch & DM_BALANCED_WEAPONS)
! 			damage = DM_NAIL_DAMAGE;
! 		else
! 			damage = 9;
! 		// Expert DM
! 		// Firing 2/3 the nails at 3/2 the damage
! 		if (deathmatch & DM_PERFORMANCE)
! 			damage = damage * 1.5;
! 		spawn_touchblood (damage);
  		other.deathtype = "nail";
! 		T_Damage (other, self, self.owner, damage);
  	}
  	else
  	{
***************
*** 818,827 ****
--- 997,1008 ----
  void() superspike_touch =
  {
  local float rand;
+ local float damage;
  	if (other == self.owner)
  		return;
  
  	if (self.voided) {
+ //		bprint(PRINT_HIGH, "Duplicate missile touch: SUPERNAIL\n");
  		return;
  	}
  	self.voided = 1;
***************
*** 839,847 ****
  // hit something that bleeds
  	if (other.takedamage)
  	{
! 		spawn_touchblood (18);
  		other.deathtype = "supernail";
! 		T_Damage (other, self, self.owner, 18);
  	}
  	else
  	{
--- 1019,1036 ----
  // hit something that bleeds
  	if (other.takedamage)
  	{
! 		// Expert DM
! 		if (deathmatch & DM_BALANCED_WEAPONS)
! 			damage = DM_SUPERNAIL_DAMAGE;
! 		else
! 			damage = 18;
! 		// Expert DM
! 		// Firing 2/3 the nails at 3/2 the damage
! 		if (deathmatch & DM_PERFORMANCE)
! 			damage = damage * 1.5;
! 		spawn_touchblood (damage);
  		other.deathtype = "supernail";
! 		T_Damage (other, self, self.owner, damage);
  	}
  	else
  	{
***************
*** 868,873 ****
--- 1057,1068 ----
  
  void() W_SetCurrentAmmo =
  {
+ 
+ 	if (self.weaponmode && (deathmatch & DM_WEAPON_MODES)) {
+ 		W2_SetCurrentAmmo();
+ 		return;
+ 	}
+ 
  	player_run ();          // get out of any weapon firing states
  
  	self.items = self.items - ( self.items & (IT_SHELLS | IT_NAILS | IT_ROCKETS | IT_CELLS) );
***************
*** 939,944 ****
--- 1134,1144 ----
  {
  	local   float   it;
  	
+ 	if (self.weaponmode && (deathmatch & DM_WEAPON_MODES)) {
+ 		W2_BestWeapon();
+ 		return;
+ 	}
+ 
  	it = self.items;
  
  	if (self.waterlevel <= 1 && self.ammo_cells >= 1 && (it & IT_LIGHTNING) )
***************
*** 965,970 ****
--- 1165,1176 ----
  
  float() W_CheckNoAmmo =
  {
+ 
+ 	if (self.weaponmode && (deathmatch & DM_WEAPON_MODES)) {
+ 		W2_CheckNoAmmo();
+ 		return;
+ 	}
+ 
  	if (self.currentammo > 0)
  		return TRUE;
  
***************
*** 999,1004 ****
--- 1205,1215 ----
  {
  	local   float   r;
  
+ 	if (self.weaponmode && (deathmatch & DM_WEAPON_MODES)) {
+ 		W2_Attack();
+ 		return;
+ 	}
+ 
  	if (!W_CheckNoAmmo ())
  		return;
  
***************
*** 1033,1042 ****
--- 1244,1255 ----
  	}
  	else if (self.weapon == IT_NAILGUN)
  	{
+ 		self.nailnum = 0;
  		player_nail1 ();
  	}
  	else if (self.weapon == IT_SUPER_NAILGUN)
  	{
+ 		self.nailnum = 0;
  		player_nail1 ();
  	}
  	else if (self.weapon == IT_GRENADE_LAUNCHER)
***************
*** 1067,1079 ****
--- 1280,1305 ----
  */
  void() W_ChangeWeapon =
  {
+ 	local entity messageObj;
  	local   float   it, am, fl;
  	
+ 	if (self.weaponmode && (deathmatch & DM_WEAPON_MODES)) {
+ 		W2_ChangeWeapon();
+ 		return;
+ 	}
+ 
  	it = self.items;
  	am = 0;
  	
  	if (self.impulse == 1)
  	{
+ 		if ((self.weapon == IT_AXE) && (deathmatch & DM_GRAPPLE)) {
+ 			// set up a message object to keep the grapple 
+ 			// tutorial on the screen for a few seconds.
+ 			messageObj = spawn();
+ 			messageObj.touch = GrappleTutorial;
+ 			SetupMessageObj(messageObj, self, 7);
+ 		}
  		fl = IT_AXE;
  	}
  	else if (self.impulse == 2)
***************
*** 1133,1138 ****
--- 1359,1369 ----
  		return;
  	}
  
+ 	// Expert: McBain's PreviousWeaponCommand plus Expert tweak
+ 	// Only set previous_weapon if we are actually changing to a new weapon
+ 	if (fl != self.weapon)
+ 		self.previous_weapon = self.weapon;	
+ 
  //
  // set weapon, set ammo
  //
***************
*** 1333,1338 ****
--- 1564,1616 ----
  	serverflags = serverflags * 2 + 1;
  };
  
+ //McBain: Here's the beef...
+ /*
+ ============
+ PreviousWeaponCommand
+ ============
+ */
+ void() PreviousWeaponCommand =
+ {
+ 	local	float	fl, am;
+ 	
+ 	self.impulse = 0;
+ 	am = 0;
+ 
+ 	if (!(self.items & self.previous_weapon))
+ 	{	// don't have the weapon or the ammo
+ 		sprint (self, PRINT_HIGH, "no weapon.\n");
+ 		return;
+ 	}
+ 	
+ 	fl = self.weapon;
+ 	self.weapon = self.previous_weapon;
+ 	self.previous_weapon = fl;
+ 
+ 	// this might not be the best method, but I'll be able to play sooner
+ 	if (self.weapon == IT_SHOTGUN || self.weapon == IT_SUPER_SHOTGUN) {
+ 		if (self.ammo_shells < 1)
+ 			am = 1;
+ 	}
+ 	else if (self.weapon == IT_NAILGUN || self.weapon == IT_SUPER_NAILGUN) {
+ 		if (self.ammo_nails < 1)
+ 			am = 1;
+ 	}
+ 	else if (self.weapon == IT_GRENADE_LAUNCHER || self.weapon == IT_ROCKET_LAUNCHER) {
+ 		if (self.ammo_rockets < 1)
+ 			am = 1;
+ 	}
+ 	else if (self.weapon == IT_LIGHTNING) {
+ 		if (self.ammo_cells < 1)
+ 			am = 1;
+ 	}
+ 	// ignore AXE -- no ammo needed
+ 
+ 	if (am)
+ 		self.weapon = W_BestWeapon ();
+ 
+ 	W_SetCurrentAmmo ();
+ };
  
  /*
  ============
***************
*** 1342,1360 ****
  */
  void() ImpulseCommands =
  {
  	if (self.impulse >= 1 && self.impulse <= 8)
  		W_ChangeWeapon ();
  
! 	if (self.impulse == 9)
  		CheatCommand ();
! 	if (self.impulse == 10)
  		CycleWeaponCommand ();
! 	if (self.impulse == 11)
  		ServerflagsCommand ();
! 	if (self.impulse == 12)
  		CycleWeaponReverseCommand ();
  
  	self.impulse = 0;
  };
  
  /*
--- 1620,1821 ----
  */
  void() ImpulseCommands =
  {
+ 	local entity messageObj;
+ 	local string s;
+ 
  	if (self.impulse >= 1 && self.impulse <= 8)
  		W_ChangeWeapon ();
  
! 	else if (self.impulse == 9)
  		CheatCommand ();
! 	else if (self.impulse == 10)
  		CycleWeaponCommand ();
! 	else if (self.impulse == 11)
  		ServerflagsCommand ();
! 	else if (self.impulse == 12)
  		CycleWeaponReverseCommand ();
+ 	else if (self.impulse == 22) {
+ 		if (deathmatch & DM_GRAPPLE) {
+ 			// set up a message object to keep the grapple 
+ 			// tutorial on the screen for a few seconds.
+ 			messageObj = spawn();
+ 			messageObj.touch = GrappleTutorial;
+ 			SetupMessageObj(messageObj, self, 7);
+ 		}
+ 	}
+ 	// SwitchFire system
+ 	else if (self.impulse > 100 && self.impulse <= 120) {
+ 		if (!self.switchfiring)
+ 			W2_SwitchFire();
+ 	} else if (self.impulse == 121) {
+ 		if (self.switchfiring)
+ 			W2_StopSwitchFire();
+ 	}
+ 
+ // *TEAMPLAY*
+ // If we're allowed to drop items, enable impulse 20 and 21
+ 	else if ( (self.impulse == 20 || self.impulse == 21) && (teamplay > 0) && (teamplay & TEAM_DROP_ITEMS) )
+ 	{
+ 		if (self.impulse == 20) {
+ 			if ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN))
+ 				sprint(self, PRINT_HIGH, "Backpack tossing disabled in this mode\n");
+ 			else
+ 				TossBackpack ();
+ 		} else if (self.impulse == 21) {
+ 			if ((deathmatch & DM_WEAPON_STAY) || (deathmatch & DM_FREE_GEAR))	
+ 				sprint(self, PRINT_HIGH, "Weapon tossing disabled in this mode\n");
+ 			else
+ 				TossWeapon ();
+ 		}
+ 	}
+ 
+ 	else if (self.impulse == 23) {
+ 		TeamFlagStatusReport();
+ 	}
+ 
+ //McBain: I picked 69 -- seems appropriate!  I hope 69 hasn't been used in
+ // other add-ons.  This is my first attempt at Quake C, and I hope I haven't
+ // violated any Quake C ettiquette.  :(
+ 	else if (self.impulse == 69)
+ 		PreviousWeaponCommand ();
  
+ 	else if (self.impulse == 192) {
+ 		s = vtos(self.origin);
+ 		centerprint(self, s);
+ 	}
+ 
+ // *TEAMPLAY*
+ // Impulse 25 prints info about the current teamplay and deathmatch settings.
+ 
+ 	else if (self.impulse == 25) {
+ 		TeamPrintSettings ();
+ 		DMPrintSettings ();
+ 	}
+ 
+ // Impulse 26 redisplays the MOTD
+ 
+ 	else if (self.impulse == 26) {
+ 		CreateMOTDObj();
+ 	}
+ 
+ 	else if (self.impulse == 27)
+ 		ServerHelp();
+ 
+ 	self.impulse = 0;
+ };
+ 
+ /*
+ ============
+ InstantImpulses
+ 
+ Instant impulses is called without checking if the player is done with his
+ current attack.  It should be used for commands that should be able to go
+ through at any time, such as releasing the grappling hook.
+ ============
+ */
+ void() InstantImpulses =
+ {
+ 	local string temp;
+ 
+ 	if (self.impulse == 146) {
+ 		if (!self.hook_out && (deathmatch & DM_GRAPPLE))
+ 			Throw_Grapple ();
+ 		self.impulse = 0;
+ 	} else if (self.impulse == 147) {
+ 		if (self.hook_out)
+ 			Reset_Grapple(self);
+ 		self.impulse = 0;
+ 	} else if (self.impulse == 210) {
+ 		// Expert DM
+ 		// Weapon mode switching, only valid when mode
+ 		// switching is allowed.
+ 		if ((deathmatch & DM_WEAPON_MODES) &&
+ 			!(deathmatch & DM_ALTERNATES_ONLY))	{
+ 			if (self.weaponmode == 0) {
+ 				self.weaponmode = 1;
+ 				sprint(self, PRINT_HIGH, "Weapon mode: ALTERNATE\n");
+ 				W2_SetCurrentAmmo();
+ 				W2_CheckNoAmmo();
+ 			} else {
+ 				self.weaponmode = 0;
+ 				sprint(self, PRINT_HIGH, "Weapon mode: NORMAL\n");
+ 				W_SetCurrentAmmo();
+ 				W_CheckNoAmmo();
+ 			}
+ 		}
+ 		self.impulse = 0;
+ 
+ 	// Expert Teamplay
+ 	// Team Audio impulses
+ 	} else if (self.impulse == 160) {
+ 		// Expert CTF
+ 		sprint(self, PRINT_HIGH, "Audio messages bound to F5-F12\n");
+ 		BindTeamAudio(self);
+ 		self.impulse = 0;
+ 	} else if (self.impulse >= 161 && self.impulse <= 164) {
+ 		// Expert TeamAudio (Global)
+ 		if ((ctf) && (teamplay & TEAM_AUDIO))
+ 			SendTeamAudio(self, self.impulse);
+ 		self.impulse = 0;
+ 	} else if (self.impulse >= 165 && self.impulse <= 168) {
+ 		// Expert TeamAudio (Local)
+ 		if (teamplay & TEAM_AUDIO)
+ 			SendTeamAudio(self, self.impulse);
+ 		self.impulse = 0;
+ 	} else if (self.impulse == 180 || self.impulse == 181) {
+ 		// Expert CTF
+ 		// Quick reference (centerprint) version
+ 		if (teamplay & TEAM_AUDIO)
+ 			TeamAudioTutorial();
+ 		self.impulse = 0;
+ 	} else if (self.impulse == 190) {
+ 		// Expert CTF
+ 		// Console (sprint) version
+ 		if (teamplay & TEAM_AUDIO)
+ 			AudioTutorial();
+ 		self.impulse = 0;
+ 	} else if (self.impulse == 191) {
+ 		// Expert CTF
+ 		// Console (sprint) version
+ 		if ((ctf) && (teamplay & TEAM_AUDIO))
+ 			AudioUsage();
+ 		self.impulse = 0;
+ 
+ 	// Expert DM
+ 	// Status bar impulses
+ 	} else if (self.impulse >= 70 && self.impulse <= 79) {
+ 		sprint(self, PRINT_HIGH, "Status bar set\n");
+ 		stuffcmd(self, "setinfo statusbar ");
+ 		temp = ftos(self.impulse - 70);
+ 		stuffcmd(self, temp);
+ 		stuffcmd(self, "\n");
+ 		self.impulse = 0;
+ 	} else if (self.impulse == 80) {
+ 		temp = infokey(self, "ident");
+ 		if (stof(temp)) {
+ 			sprint(self, PRINT_HIGH, "Player identify off\n");
+ 			stuffcmd(self, "setinfo ident 0\n");
+ 		} else {
+ 			sprint(self, PRINT_HIGH, "Player identify on\n");
+ 			stuffcmd(self, "setinfo ident 1\n");
+ 		}
+ 		self.impulse = 0;
+ 	} else if (self.impulse == 81) {
+ 		temp = infokey(self, "hud2");
+ 		if (stof(temp)) {
+ 			sprint(self, PRINT_HIGH, "Normal status bar\n");
+ 			stuffcmd(self, "setinfo hud2 0\n");
+ 		} else {
+ 			sprint(self, PRINT_HIGH, "Quakeworld 2.0 HUD status bar\n");
+ 			stuffcmd(self, "setinfo hud2 1\n");
+ 		}
  		self.impulse = 0;
+ 	} else if (self.impulse == 141) {
+ 		// force immediate statusbar update
+ 		self.statustime = 0;
+ 		StatusCheckTime(self);
+ 		self.impulse = 0;		
+ 	}
  };
  
  /*
***************
*** 1366,1378 ****
  */
  void() W_WeaponFrame =
  {
  	if (time < self.attack_finished)
  		return;
  
! 	ImpulseCommands ();
  	
  // check for attack
! 	if (self.button0)
  	{
  		SuperDamageSound ();
  		W_Attack ();
--- 1827,1859 ----
  */
  void() W_WeaponFrame =
  {
+ 
+ 	// instant impulses are commands that don't depend on a shot
+ 	// being completed, and go through immediately
+ 	if (self.impulse != 0) {
+ 		// Expert DM: crude hack to get around impulses overriding
+ 		// each other.  If any impulse is triggered while a player
+ 		// is switchfiring, stop switchfiring.  This is the right
+ 		// thing 90% of the time.
+ 		if (self.switchfiring)
+ 			W2_StopSwitchFire();
+ 		InstantImpulses();
+ 	}
+ 
  	if (time < self.attack_finished)
  		return;
  	
! 	if (self.impulse != 0) ImpulseCommands ();
  
  // check for attack
! 	// Expert
! 	// SwitchFire
! 	// Impulse commands may have caused an attack -
! 	// check attack_finished to prevent double fire.
! 	if (time < self.attack_finished)
! 		return;
! 
! 	if (self.button0 || self.switchfiring)
  	{
  		SuperDamageSound ();
  		W_Attack ();
diff -crbB --unidirectional-new-file qw201/weapons2.qc expert12/weapons2.qc
*** qw201/weapons2.qc	Thu Jan  1 00:00:00 1970
--- expert12/weapons2.qc	Fri Aug 15 04:11:36 1997
***************
*** 0 ****
--- 1,1330 ----
+ /* weapons2.qc */
+ 
+ // Source file for alternate weapon modes available on some weapons
+ //
+ // Again changes were minimized:
+ // client.qc : special obituary calls
+ // weapons.qc : calls into this file on firing, and mode switching.
+ // dm.qc : armor penetration
+ 
+ /** Defs **/
+ 
+ .float used;
+ .float lasthit;
+ .float switch_weapon;
+ .float switch_mode;
+ .float switchfiring;
+ 
+ .float ammo_axes;
+ .float timer;
+ .vector oldvelocity;
+ 
+ /** MODIFIABLE CONSTANTS **/
+ 
+ float DM_THROWAXE_SPEED =				1000;
+ float DM_THROWAXE_REFIRE =				0.7;
+ float DM_THROWAXE_DAMAGE =				75;
+ float DM_THROWAXE_BOUNCE_DAMAGE =			50;
+ 
+ float DM_PULSE_RIFLE_REFIRE =				0.5;
+ float DM_PULSE_RIFLE_DAMAGE =				60;
+ 
+ float DM_PULSE_SPREAD_REFIRE =			0.7;
+ float DM_PULSE_SPREAD_DAMAGE =			25;
+ 
+ float DM_PULSE_RIFLE_SPEED =				1700; 
+ float DM_PULSE_SPREAD_SPEED =				1000;
+ 
+ float DM_PULSE_PENETRATION =				0.3;  // percentage to reduce armor
+ 									// effectiveness
+ 
+ float DM_GIB_REFIRE =					0.3;
+ float DM_GIB_DAMAGE =					50;
+ float DM_GIB_SELF_DAMAGE =				6;
+ 
+ float DM_SQUIRREL_REFIRE =				0.8;
+ float DM_SQUIRREL_SPLASH_DAMAGE =			100;
+ 
+ float DM_MORTAR_REFIRE =				0.7;
+ float DM_MORTAR_DAMAGE =				90;
+ float DM_MORTAR_RADIUS = 				100;
+ float DM_MORTAR_TAPER =					0.3;
+ 
+ // DAMAGE REFERENCE TABLE
+ // Weapon:			Fire Delay:		Damage per shot:		Max Rate:			Penetration:
+ // ---------------------------------------------------------------------------------------------------
+ // Throwing Axe		0.7			75, 50 bounce		variable			0
+ // Pulse Rifle		0.5			60				120				0.3
+ // Pulse Spread		0.7			up to 90			128.5				0.3
+ // [Nailgun Unchanged]
+ // GibGun			0.3			50, 6 self			166, 20 self		0
+ // Squirrel Bomb		0.8			100 radius			125 radius			0
+ // Mortar Launcher	0.7			90 specific radius	128.5 specific radius	0
+ // [Lightning Gun]
+ 
+ // Prototypes
+ float() W2_BestWeapon;
+ void() W2_SetCurrentAmmo;
+ void() bound_other_ammo;
+ void(float o, float n) Deathmatch_Weapon;
+ void() BackpackTouch;
+ void (entity targ, entity inflictor, entity attacker, float damage) T_Damage;
+ void(entity bomb, entity attacker, float rad, entity ignore, string dtype) T_RadiusDamage;
+ void(vector org, float damage) SpawnBlood;
+ void(float damage) spawn_touchblood;
+ void() GrenadeExplode;
+ void() SuperDamageSound;
+ void() W_Attack;
+ void() superspike_touch;
+ void(float ox) W_FireSpikes;
+ 
+ /*
+ ================
+ W2ThrowAxe_Pickup
+ 
+ Touch function for axe items on the ground.
+ ================
+ */
+ void() W2ThrowAxe_Pickup =
+ {
+ 	local entity stemp;
+ 
+ 	if (other.classname == "world") {
+ 		return;
+ 	} else if (other.classname == "player") {
+ 		if (other.ammo_axes < 15)
+ 			other.ammo_axes = other.ammo_axes + 1;
+ 	
+ 		sprint (other, PRINT_LOW, "You got the Throwing Axe\n");
+ 
+ 		sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);  // loud bounce
+ 
+ 		stuffcmd (other, "bf\n");
+ 
+ 		// if changed current ammo, update it
+ 		stemp = self;
+ 		self = other;
+ 		W_SetCurrentAmmo();
+ 		self = stemp;
+ 
+ 		remove(self);
+ 		return;
+ 	}
+ 
+ };
+ 
+ /*
+ ================
+ W2ThrowAxe_Touch
+ 
+ Axes start out with a non-ballistic flight path (straight).  After
+ they first hit another player, they take on a ballistic flight path
+ (which actually requires the axe to be replaced in mid air by another
+ axe entity).
+ ================
+ */
+ void() W2ThrowAxe_Touch =
+ {
+ 	local float damage;
+ 
+ 	// axe is still in the air
+ 	if (self.velocity != '0 0 0') {
+ 		// axe can't hit thrower until it's bounced
+ 		if ((other == self.enemy) && !self.used)
+ 			return;
+     
+ 		if (other.takedamage) {
+ 			// Double touch prevention for throwing axe.  Can't just
+ 			// count hits since the axe can legitimately hit twice
+ 			if (time - self.lasthit < 0.1)
+ 				return;
+ 			self.lasthit = time;
+ 
+ 			// hit player, do damage, spray blood
+ 			sound (self, CHAN_WEAPON, "zombie/z_hit.wav", 1, ATTN_NORM);
+ 			if (self.used)
+ 				damage = DM_THROWAXE_BOUNCE_DAMAGE;
+ 			else
+ 				damage = DM_THROWAXE_DAMAGE;
+ 			// Expert HACK
+ 			// Pass in self.enemy as owner (see explanation below).
+ 			SpawnBlood (self.origin, damage);
+ 			other.deathtype = "w2axe";
+ 			T_Damage(other, self, self.enemy, damage);
+ 		} else {
+ 			// hit world, bounce sound
+ 			if (random() < 0.5)
+ 				sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);  // loud bounce
+ 			else
+ 				sound (self, CHAN_WEAPON, "weapons/tink1.wav", 1, ATTN_NORM);  // tink sound
+ 		}
+ 		// set ballistic movetype after first real player or world hit
+ 		if (!self.used) {
+ 			self.movetype = MOVETYPE_BOUNCE;
+ 		}
+ 		// prevent axes from getting caught in crevices
+ 		// and hitting walls at ridiculous frequency
+ 		if (self.used > 10)
+ 			remove(self);
+ 
+ 		self.used = self.used + 1;
+ 
+ 
+ 
+ 	}
+ };
+ 
+ /*
+ ================
+ W2ThrowAxe_Think
+ 
+ Play the whooshing sound if in the air.  When the axe
+ comes to a rest, remove it and replace it with an "axe item"
+ which can be picked up like ammo.  Axe items remove themselves
+ after several seconds, to prevent buildup.
+ ================
+ */
+ void() W2ThrowAxe_Think =
+ {
+ 
+ 	// when the axe comes to rest, remove the old axe and create a new
+ 	// one in its place that is actually an item that can be picked up.
+ 	if (self.velocity == '0 0 0') {
+ 		// Expert: "deathmatch 4" rules
+ 		// Limitless axes, so just remove them when they stop moving
+ 		if ((deathmatch & 4) && !(deathmatch & 1)) {
+ 			remove(self);
+ 			return;
+ 		}
+ 
+ 		newmis = spawn();
+ 
+ 		setmodel(newmis, "progs/throwaxe.mdl");
+ 		setsize(newmis, VEC_ORIGIN, VEC_ORIGIN);
+ 		setorigin(newmis, self.origin);
+ 
+ 		newmis.angles = self.angles;
+ 		newmis.flags = FL_ITEM;
+ 		newmis.movetype = MOVETYPE_NONE;
+ 		newmis.solid = SOLID_TRIGGER;
+ 		newmis.classname = "w2throwaxe";
+ 		newmis.touch = W2ThrowAxe_Pickup;
+ 		newmis.nextthink = time + 7;
+ 		newmis.think = SUB_Remove;
+ 
+ 		remove(self);
+ 
+ 		// created a new trigger.. 
+ 		// check touch for stationary objects
+ 		force_retouch = 2;
+ 
+ 		return;
+ 	}
+ 
+ 	// play whooshing sound if moving and haven't hit ground
+ 	if ((self.velocity != '0 0 0') && !self.used)
+ 		sound (self, CHAN_WEAPON, "weapons/ax1.wav", 1, ATTN_NORM);
+ 
+ 	self.nextthink = time + 0.4;
+ 
+ };
+ 
+ /*
+ ================
+ W2ThrowAxe
+ 
+ Alternate weapon mode for the axe.
+ ================
+ */
+ void() W2ThrowAxe =
+ {
+ 	self.attack_finished = time + DM_THROWAXE_REFIRE;
+ 
+ 	sound (self, CHAN_VOICE, "player/land.wav", 1, ATTN_NORM);
+ 
+ 	// Expert: "deathmatch 4" rules: limitless ammo
+ 	if (! ((deathmatch & DM_FREE_GEAR) && !(deathmatch & DM_ITEM_RESPAWN)) )
+ 		self.currentammo = self.ammo_axes = self.ammo_axes - 1;
+ 
+ 	newmis = spawn();
+ 	// Expert HACK
+ 	// "Bounce" projectiles ignore their owner, but we need
+ 	// to store the owner so we know who to credit the kill
+ 	// to, so store the axe thrower in .enemy
+ 	newmis.enemy = self;	newmis.movetype = MOVETYPE_FLYMISSILE;
+ 	newmis.solid = SOLID_BBOX;
+ 	newmis.effects = 0;
+ 	newmis.used = 0;
+ 	newmis.lasthit = 0;
+ 	newmis.classname = "w2throwaxe";
+ 
+ 	setmodel (newmis, "progs/throwaxe.mdl");		
+ 	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+ 
+ 	setorigin (newmis, self.origin + '0 0 16');
+ 
+ 	makevectors(self.v_angle);
+ 
+ 	newmis.velocity = v_forward*DM_THROWAXE_SPEED;
+ 	// Expert DM
+ 	if (deathmatch & DM_REAL_PHYSICS)
+ 		newmis.velocity = newmis.velocity + self.velocity;
+ 	newmis.avelocity = '-500 0 30'; // forward flipping, slight roll
+ 	newmis.angles = vectoangles(newmis.velocity);
+ 
+ 	newmis.nextthink = time + 0.4;
+ 	newmis.think = W2ThrowAxe_Think;
+ 	newmis.touch = W2ThrowAxe_Touch;
+ };
+ 
+ void() W2Pulse_Touch =
+ {
+ 	local vector org;
+ 	
+ 	if (other == self.owner)
+ 		return;		// don't explode on owner
+ 
+ 	if (self.used) {
+ //		bprint(PRINT_HIGH, "Duplicate missile touch: PULSE\n");
+ 		return;
+ 	}
+ 	self.used = 1;
+ 
+ 	if (pointcontents(self.origin) == CONTENT_SKY)
+ 	{
+ 		remove(self);
+ 		return;
+ 	}
+ 	
+ 	sound (self, CHAN_WEAPON, "enforcer/enfstop.wav", 1, ATTN_STATIC);
+ 	org = self.origin - 8*normalize(self.velocity);
+ 
+ 	if (other.health)
+ 	{
+ 		// weaponmode indicates damage
+ 		SpawnBlood (org, self.weaponmode);
+ 		other.deathtype = "w2pulse";
+ 		T_Damage (other, self, self.owner, self.weaponmode);
+ 	}
+ 	else
+ 	{
+ 		WriteByte (MSG_MULTICAST, SVC_TEMPENTITY);
+ 		WriteByte (MSG_MULTICAST, TE_GUNSHOT);
+ 		WriteByte (MSG_MULTICAST, 5);
+ 		WriteCoord (MSG_MULTICAST, org_x);
+ 		WriteCoord (MSG_MULTICAST, org_y);
+ 		WriteCoord (MSG_MULTICAST, org_z);
+ 		multicast (org, MULTICAST_PVS);
+ 	}
+ 	
+ 	remove(self);	
+ };
+ 
+ /*
+ ================
+ FirePulse
+ 
+ Fire a single pulse bolt at "offset" from self.
+ ================
+ */
+ void(vector offset, float airSpeed, float damage) FirePulse =
+ {	
+ 	local vector dir;
+ 
+ 	makevectors(self.v_angle);
+ 	dir = normalize(v_forward);
+ 	
+ 	newmis = spawn();
+ 	newmis.owner = self;
+ 	newmis.movetype = MOVETYPE_FLY;
+ 	newmis.solid = SOLID_BBOX;
+ 	newmis.effects = 0;
+ 	newmis.weaponmode = damage; // indicates both weaponmode and damage to do
+ 	self.used = 0;
+ 	newmis.classname = "w2pulse";
+ 
+ 	setmodel (newmis, "progs/laser.mdl");
+ 	setsize (newmis, '0 0 0', '0 0 0');		
+ 
+ 	setorigin (newmis, self.origin + offset);
+ 
+ 	newmis.velocity = dir * airSpeed;
+ 	newmis.angles = vectoangles(newmis.velocity);
+ 	// Expert DM
+ 	if (deathmatch & DM_REAL_PHYSICS)
+ 		newmis.velocity = newmis.velocity + self.velocity;
+ 
+ 	newmis.nextthink = time + 5;
+ 	newmis.think = SUB_Remove;
+ 	newmis.touch = W2Pulse_Touch;
+ 
+ };
+ 
+ /*
+ ================
+ W2PulseFire
+ 
+ Alternate weapon mode for the shotguns.
+ ================
+ */
+ void(vector offset) W2PulseFire =
+ {
+ 	makevectors(self.v_angle);
+ 
+ 	if (self.weapon == IT_SHOTGUN) {
+ 		self.attack_finished = time + DM_PULSE_RIFLE_REFIRE;
+ 		sound (self, CHAN_WEAPON, "enforcer/enfire.wav", 1, ATTN_NORM);
+ 		FirePulse (16*v_up, DM_PULSE_RIFLE_SPEED, DM_PULSE_RIFLE_DAMAGE);
+ 	} else if (self.weapon == IT_SUPER_SHOTGUN) {
+ 		if (self.ammo_shells < 1)
+ 		{
+ 			self.weapon = W2_BestWeapon ();
+ 			W2_SetCurrentAmmo ();
+ 			return;
+ 		}
+ 		self.attack_finished = time + DM_PULSE_SPREAD_REFIRE;
+ 		sound (self, CHAN_WEAPON, "enforcer/enfire.wav", 1, ATTN_NORM);
+ 		FirePulse (16*v_up - 8*v_right, DM_PULSE_SPREAD_SPEED, DM_PULSE_SPREAD_DAMAGE);
+ 		FirePulse (12 * v_up, DM_PULSE_SPREAD_SPEED, DM_PULSE_SPREAD_DAMAGE);
+ 		FirePulse (16*v_up + 8*v_right, DM_PULSE_SPREAD_SPEED, DM_PULSE_SPREAD_DAMAGE);
+ 		self.currentammo = self.ammo_shells = self.ammo_shells - 1;
+ 	}
+ };
+ 
+ void() W2Gib_Touch =
+ {
+ 	local vector org;
+ 	
+ 	if (other == self.owner)
+ 		return;		// don't hit owner
+ 
+ 	if (self.used) {
+ //		bprint(PRINT_HIGH, "Duplicate missile touch: GIB\n");
+ 		return;
+ 	}
+ 	self.used = 1;
+ 
+ 	if (pointcontents(self.origin) == CONTENT_SKY)
+ 	{
+ 		remove(self);
+ 		return;
+ 	}
+ 	
+ 	org = self.origin - 8*normalize(self.velocity);
+ 
+ 	// bloody splat no matter what
+ 	SpawnBlood (org, 2*DM_GIB_DAMAGE);
+ 	if (other.health)	{
+ 		sound (self, CHAN_WEAPON, "zombie/z_hit.wav", 1, ATTN_NORM);
+ 		other.deathtype = "w2gib";
+ 		T_Damage (other, self, self.owner, DM_GIB_DAMAGE);
+ 	} else {
+ 		sound (self, CHAN_WEAPON, "zombie/z_miss.wav", 1, ATTN_NORM);	// bounce sound
+ 	}
+ 	
+ 	remove(self);	
+ };
+ 
+ /*
+ ================
+ W2_FireGib
+ ================
+ */
+ void() W2_FireGib =
+ {
+ 
+ 	newmis = spawn();
+ 	newmis.owner = self;
+ 	newmis.movetype = MOVETYPE_FLY;
+ 	newmis.solid = SOLID_BBOX;
+ 	newmis.effects = 0;
+ 	newmis.used = 0;
+ 	
+ 	newmis.classname = "w2gib";
+ 
+ 	setmodel (newmis, "progs/zom_gib.mdl");
+ 	setsize (newmis, '0 0 0', '0 0 0');		
+ 
+ 	setorigin (newmis, self.origin + '0 0 16');
+ 
+ 	makevectors(self.v_angle);
+ 	newmis.velocity = v_forward*1200;
+ 	newmis.angles = vectoangles(newmis.velocity);
+ 	// Expert DM
+ 	if (deathmatch & DM_REAL_PHYSICS)
+ 		newmis.velocity = newmis.velocity + self.velocity;
+ 
+ 	newmis.nextthink = time + 5;
+ 	newmis.think = SUB_Remove;
+ 	newmis.touch = W2Gib_Touch;
+ };
+ 
+ /*
+ ================
+ W2_FireGibgun
+ 
+ Alternate weapon mode for the SNG.  Fires a gib projectile
+ every 0.3 seconds.  The gibs do a lot of damage, but you
+ also hurt yourself firing.
+ ================
+ */
+ void() W2_FireGibgun =
+ {
+ 	local vector dir;
+ 
+ 	self.attack_finished = time + DM_GIB_REFIRE;
+ 
+ 	// note no muzzleflash
+ 
+ 	W2_FireGib();
+ 
+ 	// essentially costs health instead of ammo
+ 	// this also causes a pain sound
+ 	self.deathtype = "w2gibgun";
+ 	T_Damage(self, self, self, DM_GIB_SELF_DAMAGE);
+ 	self.deathtype = "";
+ };
+ 
+ /*
+ ================
+ W2_CheckBounce
+ 
+ Called every 0.1 seconds for Squirrels.  Check whether a bounce
+ has occured (self.used) and if so sets the Squirrel's velocity to
+ the initial velocity.  Also checks for explosion due to timer
+ expiring.
+ ================
+ */
+ void() W2_CheckBounce =
+ {
+ 	local vector flydir;
+ 
+ 	if (self.lasthit) {
+ 		self.lasthit = 0;
+ 		self.velocity = self.oldvelocity;
+ 	}
+ 
+ 	self.nextthink = time + 0.1;
+ 
+ 	if (time - self.timer > 3)
+ 		GrenadeExplode();
+ };
+ 
+ void() SquirrelExplode =
+ {
+ 	local float damage;
+ 
+ 	if (self.used) {
+ //		bprint(PRINT_HIGH, "Duplicate missile touch: SQUIRREL\n");
+ 		return;
+ 	}
+ 	self.used = 1;
+ 
+ 	T_RadiusDamage (self, self.owner, DM_SQUIRREL_SPLASH_DAMAGE, world, "w2squirrel");
+ 
+ 	WriteByte (MSG_MULTICAST, SVC_TEMPENTITY);
+ 	WriteByte (MSG_MULTICAST, TE_EXPLOSION);
+ 	WriteCoord (MSG_MULTICAST, self.origin_x);
+ 	WriteCoord (MSG_MULTICAST, self.origin_y);
+ 	WriteCoord (MSG_MULTICAST, self.origin_z);
+ 	multicast (self.origin, MULTICAST_PHS);
+ 
+ 	remove (self);
+ };
+ 
+ /*
+ ================
+ W2Squirrel_Touch
+ 
+ On a touch, explode if a player, otherwise
+ set up for special bounce.
+ ================
+ */
+ void() W2Squirrel_Touch =
+ {
+ 
+ 	if (other == self.owner)
+ 		return;         // don't explode on owner
+ 
+ 	if (other.takedamage == DAMAGE_AIM)
+ 	{
+ 		SquirrelExplode();
+ 		return;
+ 	}
+ 
+ 	// prevent extreme repeat bounces with a timer
+ 	if (self.invisible_finished < time) {
+ 		sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);  // bounce sound
+ 		self.invisible_finished = time + 0.3;
+ 	}
+ 
+ 	// can't set velocity here, because physics runs right
+ 	// after touches and overrides.
+ 	// so indicate a bounce to the think function
+ 	self.lasthit = 1;
+ 
+ 	// super_damage_finished is used to mark the last time the grenade bounces.
+ 	// if the grenade bounces more than once with 0.2 seconds, it explodes.
+ 	// otherwise it would climb walls (which is very squirrel like, but possibly
+ 	// laggy and in any case not very good for the game)
+ 	if (time - self.super_damage_finished < 0.2)
+ 		SquirrelExplode();
+ 
+ 	self.super_damage_finished = time;
+ 	
+ };
+ 
+ /*
+ ================
+ W2_FireSquirrel
+ 
+ Squirrel grenades explode on impact with something that takes damage,
+ like normal grenades.  Unlike normal grenades, when they hit the ground
+ or walls they regain the velocity they started with, so that they bounce
+ forward like a squirrel.
+ ================
+ */
+ void() W2_FireSquirrel =
+ {
+ 	// Expert DM
+ 	local float forwardSpeed, upSpeed;
+ 
+ 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
+ 	
+ 	self.attack_finished = time + DM_SQUIRREL_REFIRE;
+ 
+ 	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);
+ 
+ 	msg_entity = self;
+ 	WriteByte (MSG_ONE, SVC_SMALLKICK);
+ 
+ 	newmis = spawn ();
+ 	newmis.lasthit = 0;
+ 	newmis.used = 0;
+ 	newmis.owner = self;
+ 	newmis.movetype = MOVETYPE_BOUNCE;
+ 	newmis.solid = SOLID_BBOX;
+ 	newmis.classname = "grenade";
+ 		
+ // set newmis speed     
+ 
+ 	makevectors (self.v_angle);
+ 	newmis.velocity = v_forward*350 + '0 0 200';
+ 	newmis.angles = vectoangles(newmis.velocity);
+ 	// Expert DM
+ 	if (deathmatch & DM_REAL_PHYSICS)
+ 		newmis.velocity = newmis.velocity + self.velocity;
+ 
+ 	// velocity after a bounce matches initial velocity
+ 	newmis.oldvelocity = v_forward*400 + '0 0 300';
+ 	// Expert DM
+ 	if (deathmatch & DM_REAL_PHYSICS)
+ 		newmis.oldvelocity = newmis.oldvelocity + self.velocity;
+ 
+ 	newmis.touch = W2Squirrel_Touch;
+ 	
+ // set up timers
+ 	newmis.timer = time;
+ 	newmis.invisible_finished = 0;
+ 
+ 	newmis.nextthink = time + 0.1;
+ 	newmis.think = W2_CheckBounce;
+ 
+ 	setmodel (newmis, "progs/grenade.mdl");
+ 	setsize (newmis, '0 0 0', '0 0 0');             
+ 	setorigin (newmis, self.origin);
+ };
+ 
+ /*
+ ============
+ T_SpecificRadiusDamage
+ 
+ Do damage in a specific radius, with a specific linear
+ falloff "taper".  Higher taper is faster falloff.
+ Taper of 1 indicates one point falloff per game unit
+ 
+ ============
+ */
+ void(entity inflictor, entity attacker, float damage, 
+ 		float radius, float taper, entity ignore, string dtype) T_SpecificRadiusDamage =
+ {
+ 	local   float   points;
+ 	local   entity  head;
+ 	local   vector  org;
+ 	local   float   selfdamage;	
+ 
+ 	head = findradius(inflictor.origin, radius);
+ 	
+ 	while (head)
+ 	{
+ 		if (head != ignore)
+ 		{
+ 			if (head.takedamage)
+ 			{
+ 				if (CanDamage (head, inflictor))
+ 				{
+ 					org = head.origin + (head.mins + head.maxs)*0.5;
+ 					points = taper*vlen (inflictor.origin - org);
+ 					if (points < 0)
+ 						points = 0;
+ 					points = damage - points;
+ 					// Note attacker takes full damage too
+ 					head.deathtype = dtype;
+ 					T_Damage (head, inflictor, attacker, points);
+ 				}
+ 			}
+ 		}
+ 		head = head.chain;
+ 	}
+ };
+ 
+ /*
+ ================
+ T_MortarTouch
+ 
+ Mortars do radial damage with slow falloff.
+ ================
+ */
+ void() T_MortarTouch =
+ {
+ 	local float     damg;
+ 
+ 	if (other == self.owner)
+ 		return;         // don't explode on owner
+ 
+ 	if (self.used) {
+ //		bprint(PRINT_HIGH, "Duplicate missile touch: ROCKET\n");
+ 		return;
+ 	}
+ 	self.used = 1;
+ 
+ 	if (pointcontents(self.origin) == CONTENT_SKY)
+ 	{
+ 		remove(self);
+ 		return;
+ 	}
+ 
+ 	// don't do radius damage to the other, because all the damage
+ 	// was done in the impact
+ 	T_SpecificRadiusDamage (self, self.owner, DM_MORTAR_DAMAGE, DM_MORTAR_RADIUS, DM_MORTAR_TAPER, world, "w2mortar");
+ 
+ 	self.origin = self.origin - 8 * normalize(self.velocity);
+ 
+ 	WriteByte (MSG_MULTICAST, SVC_TEMPENTITY);
+ 	WriteByte (MSG_MULTICAST, TE_EXPLOSION);
+ 	WriteCoord (MSG_MULTICAST, self.origin_x);
+ 	WriteCoord (MSG_MULTICAST, self.origin_y);
+ 	WriteCoord (MSG_MULTICAST, self.origin_z);
+ 	multicast (self.origin, MULTICAST_PHS);
+ 
+ 	remove(self);
+ };
+ 
+ /*
+ ================
+ W2_FireMortar
+ 
+ A mortar is a rocket with a ballistic flight path that does
+ uniform damage in a radius on impact.
+ ================
+ */
+ void() W2_FireMortar =
+ {
+ 	self.attack_finished = time + DM_MORTAR_REFIRE;
+ 
+ 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
+ 	
+ 	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
+ 
+ 	msg_entity = self;
+ 	WriteByte (MSG_ONE, SVC_SMALLKICK);
+ 
+ 	newmis = spawn ();
+ 	newmis.owner = self;
+ 	newmis.movetype = MOVETYPE_BOUNCE;
+ 	newmis.solid = SOLID_BBOX;
+ 		
+ // set newmis speed     
+ 
+ 	makevectors (self.v_angle);
+ 	newmis.velocity = v_forward*750 + v_up*440;
+ 	newmis.angles = vectoangles(newmis.velocity);
+ 
+ 	// Expert DM
+ 	if (deathmatch & DM_REAL_PHYSICS)
+ 		newmis.velocity = newmis.velocity + self.velocity;
+ 	
+ 	newmis.touch = T_MortarTouch;
+ 	newmis.used = 0;
+ 
+ // set newmis duration
+ 	newmis.nextthink = time + 5;
+ 	newmis.think = SUB_Remove;
+ 
+ 	setmodel (newmis, "progs/missile.mdl");
+ 	setsize (newmis, '0 0 0', '0 0 0');             
+ 	setorigin (newmis, self.origin + v_forward*8 + '0 0 16');
+ 
+ };
+ 
+ /*
+ ===============================================================================
+ 
+ PLAYER WEAPON USE
+ 
+ ===============================================================================
+ */
+ 
+ void() player_run;
+ 
+ void() W2_SetCurrentAmmo =
+ {
+ 	player_run ();          // get out of any weapon firing states
+ 
+ 	self.items = self.items - ( self.items & (IT_SHELLS | IT_NAILS | IT_ROCKETS | IT_CELLS) );
+ 	
+ 	if (self.weapon == IT_AXE)
+ 	{
+ 		self.currentammo = self.ammo_axes;
+ 		self.weaponmodel = "progs/v_axe.mdl";
+ 		self.weaponframe = 0;
+ 	}
+ 	else if (self.weapon == IT_SHOTGUN)
+ 	{
+ 		// Pulse Rifle requires no ammo
+ 		self.currentammo = 0;
+ 		self.weaponmodel = "progs/v_shot.mdl";
+ 		self.weaponframe = 0;
+ 	}
+ 	else if (self.weapon == IT_SUPER_SHOTGUN)
+ 	{
+ 		// Pulse Spread uses shells
+ 		self.currentammo = self.ammo_shells;
+ 		self.weaponmodel = "progs/v_shot2.mdl";
+ 		self.weaponframe = 0;
+ 		self.items = self.items | IT_SHELLS;
+ 	}
+ 	else if (self.weapon == IT_NAILGUN)
+ 	{
+ 		self.currentammo = self.ammo_nails;
+ 		self.weaponmodel = "progs/v_nail.mdl";
+ 		self.weaponframe = 0;
+ 		self.items = self.items | IT_NAILS;
+ 	}
+ 	else if (self.weapon == IT_SUPER_NAILGUN)
+ 	{
+ 		// Gibgun requires no ammo
+ 		self.currentammo = 0;
+ 		self.weaponmodel = "progs/v_nail2.mdl";
+ 		self.weaponframe = 0;
+ 	}
+ 	else if (self.weapon == IT_GRENADE_LAUNCHER)
+ 	{
+ 		self.currentammo = self.ammo_rockets;
+ 		self.weaponmodel = "progs/v_rock.mdl";
+ 		self.weaponframe = 0;
+ 		self.items = self.items | IT_ROCKETS;
+ 	}
+ 	else if (self.weapon == IT_ROCKET_LAUNCHER)
+ 	{
+ 		self.currentammo = self.ammo_rockets;
+ 		self.weaponmodel = "progs/v_rock2.mdl";
+ 		self.weaponframe = 0;
+ 		self.items = self.items | IT_ROCKETS;
+ 	}
+ 	else if (self.weapon == IT_LIGHTNING)
+ 	{
+ 		self.currentammo = self.ammo_cells;
+ 		self.weaponmodel = "progs/v_light.mdl";
+ 		self.weaponframe = 0;
+ 		self.items = self.items | IT_CELLS;
+ 	}
+ 	else
+ 	{
+ 		self.currentammo = 0;
+ 		self.weaponmodel = "";
+ 		self.weaponframe = 0;
+ 	}
+ };
+ 
+ float() W2_BestWeapon =
+ {
+ 	local   float   it;
+ 	
+ 	it = self.items;
+ 
+ 	if(self.ammo_shells >= 1 && (it & IT_SUPER_SHOTGUN) )
+ 		return IT_SUPER_SHOTGUN;
+ 	else if ((it & IT_AXE) && (self.ammo_axes >= 1))
+ 		return IT_AXE;
+ 	else if (self.waterlevel <= 1 && self.ammo_cells >= 1 && (it & IT_LIGHTNING) )
+ 		return IT_LIGHTNING;
+ 	else if(self.ammo_nails >= 1 && (it & IT_NAILGUN) )
+ 		return IT_NAILGUN;
+ 
+ 	// note.. never switch to gibgun automatically	
+ /*
+ 	if(self.ammo_rockets >= 1 && (it & IT_ROCKET_LAUNCHER) )
+ 		return IT_ROCKET_LAUNCHER;
+ 	else if(self.ammo_rockets >= 1 && (it & IT_GRENADE_LAUNCHER) )
+ 		return IT_GRENADE_LAUNCHER;
+ 
+ */
+ 
+ 	return IT_SHOTGUN;
+ };
+ 
+ float() W2_CheckNoAmmo =
+ {
+ 	if (self.currentammo > 0)
+ 		return TRUE;
+ 
+ 	// Expert DM
+ 	// Pulse Rifle and Gibgun require no ammo
+ 	if (self.weapon == IT_SHOTGUN || self.weapon == IT_SUPER_NAILGUN)
+ 		return TRUE;
+ 
+ 	self.weapon = W2_BestWeapon ();
+ 
+ 	W2_SetCurrentAmmo ();
+ 	
+ // drop the weapon down
+ 	return FALSE;
+ };
+ 
+ 
+ /*
+ ================
+ W2_Attack
+ 
+ Attack with an alternate weapon.
+ ================
+ */
+ void() w2player_axe1;
+ void()  player_shot1;
+ void()  player_nail1;
+ void()  player_light1;
+ void()  player_rocket1;
+ 
+ void() W2_Attack =
+ {
+ 	local   float   r;
+ 
+ 	if (!W2_CheckNoAmmo ())
+ 		return;
+ 
+ 	makevectors     (self.v_angle);                 // calculate forward angle for velocity
+ 	self.show_hostile = time + 1;   // wake monsters up
+ 
+ 	if (self.weapon == IT_AXE)
+ 	{
+ 		w2player_axe1();
+ 		W2ThrowAxe();
+ 	}
+ 	else if (self.weapon == IT_SHOTGUN)
+ 	{
+ 		player_shot1 ();
+ 		W2PulseFire();
+ 	}
+ 	else if (self.weapon == IT_SUPER_SHOTGUN)
+ 	{
+ 		player_shot1 ();
+ 		W2PulseFire();
+ 	}
+ 	else if (self.weapon == IT_NAILGUN)
+ 	{
+ 		player_nail1();
+ 	}
+ 	else if (self.weapon == IT_SUPER_NAILGUN)
+ 	{
+ 		W2_FireGibgun ();
+ 	}
+ 	else if (self.weapon == IT_GRENADE_LAUNCHER)
+ 	{
+ 		player_rocket1();
+ 		W2_FireSquirrel();
+ 	}
+ 	else if (self.weapon == IT_ROCKET_LAUNCHER)
+ 	{
+ 		player_rocket1();
+ 		W2_FireMortar();
+ 	}
+ 	else if (self.weapon == IT_LIGHTNING)
+ 	{
+ 		self.attack_finished = time + 0.1;
+ 		sound (self, CHAN_AUTO, "weapons/lstart.wav", 1, ATTN_NORM);
+ 		player_light1();
+ 	}
+ };
+ 
+ /*
+ ============
+ W2_ChangeWeapon
+ 
+ ============
+ */
+ void() W2_ChangeWeapon =
+ {
+ 	local   float   it, am, fl;
+ 	
+ 	it = self.items;
+ 	am = 0;
+ 	
+ 	if (self.impulse == 1)
+ 	{
+ 		fl = IT_AXE;
+ 		if (self.ammo_axes < 1)
+ 			am = 1;
+ 	}
+ 	else if (self.impulse == 2)
+ 	{
+ 		fl = IT_SHOTGUN;
+ 	}
+ 	else if (self.impulse == 3)
+ 	{
+ 		fl = IT_SUPER_SHOTGUN;
+ 		if (self.ammo_shells < 1)
+ 			am = 1;
+ 	}               
+ 	else if (self.impulse == 4)
+ 	{
+ 		fl = IT_NAILGUN;
+ 		if (self.ammo_nails < 1)
+ 			am = 1;
+ 	}
+ 	else if (self.impulse == 5)
+ 	{
+ 		fl = IT_SUPER_NAILGUN;
+ 	}
+ 	else if (self.impulse == 6)
+ 	{
+ 		fl = IT_GRENADE_LAUNCHER;
+ 		if (self.ammo_rockets < 1)
+ 			am = 1;
+ 	}
+ 	else if (self.impulse == 7)
+ 	{
+ 		fl = IT_ROCKET_LAUNCHER;
+ 		if (self.ammo_rockets < 1)
+ 			am = 1;
+ 	}
+ 	else if (self.impulse == 8)
+ 	{
+ 		fl = IT_LIGHTNING;
+ 		if (self.ammo_cells < 1)
+ 			am = 1;
+ 	}
+ 
+ 	self.impulse = 0;
+ 	
+ 	if (!(self.items & fl))
+ 	{       // don't have the weapon or the ammo
+ 		sprint (self, PRINT_HIGH, "no weapon.\n");
+ 		return;
+ 	}
+ 	
+ 	if (am)
+ 	{       // don't have the ammo
+ 		sprint (self, PRINT_HIGH, "not enough ammo.\n");
+ 		return;
+ 	}
+ 
+ //
+ // set weapon, set ammo
+ //
+ 	self.weapon = fl;               
+ 	W2_SetCurrentAmmo ();
+ };
+ 
+ 
+ // Expert: SwitchFire System
+ // This provides a series of what are essentially secondary fire keys with
+ // customizable weapon select ordering.  For instance, a key can be setup
+ // to fire the lightning gun, SNG, or nailgun, in that order, according to
+ // weapon availability.
+ 
+ /*
+ ============
+ W2_SwitchAndFire
+ 
+ If the given "weaponNum" can be fired, fire it.  Otherwise return false.
+ ============
+ */
+ float(float weaponNum) W2_SwitchAndFire =
+ {
+ 	local   float   it, am, fl;
+ 	
+ 	it = self.items;
+ 	am = 0;
+ 	
+ 	if (weaponNum == 9)
+ 	{
+ 		fl = IT_AXE;
+ 		if (self.ammo_axes < 1)
+ 			am = 1;
+ 	}
+ 	else if (weaponNum == 10)
+ 	{
+ 		fl = IT_SHOTGUN;
+ 	}
+ 	else if (weaponNum == 11)
+ 	{
+ 		fl = IT_SUPER_SHOTGUN;
+ 		if (self.ammo_shells < 1)
+ 			am = 1;
+ 	}               
+ 	else if (weaponNum == 12)
+ 	{
+ 		fl = IT_NAILGUN;
+ 		if (self.ammo_nails < 1)
+ 			am = 1;
+ 	}
+ 	else if (weaponNum == 13)
+ 	{
+ 		fl = IT_SUPER_NAILGUN;
+ 	}
+ 	else if (weaponNum == 14)
+ 	{
+ 		fl = IT_GRENADE_LAUNCHER;
+ 		if (self.ammo_rockets < 1)
+ 			am = 1;
+ 	}
+ 	else if (weaponNum == 15)
+ 	{
+ 		fl = IT_ROCKET_LAUNCHER;
+ 		if (self.ammo_rockets < 1)
+ 			am = 1;
+ 	}
+ 	else if (weaponNum == 16)
+ 	{
+ 		fl = IT_LIGHTNING;
+ 		if (self.ammo_cells < 1)
+ 			am = 1;
+ 	}
+ 	
+ 	if (!(self.items & fl))
+ 	{       // don't have the weapon or the ammo
+ 		return FALSE;
+ 	}
+ 	
+ 	if (am)
+ 	{       // don't have the ammo
+ 		return FALSE;
+ 	}
+ 
+ //
+ // set weapon, set ammo
+ //
+ 	self.switch_weapon = self.weapon;
+ 	self.switch_mode = self.weaponmode;
+ 	self.weapon = fl;
+ 	self.weaponmode = 1;
+ 	W2_SetCurrentAmmo ();
+ 
+ // FIRE
+ 	SuperDamageSound ();
+ 	W2_Attack ();
+ 
+ 	// indicate has started switchfiring
+ 	return TRUE;
+ 
+ };
+ 
+ /*
+ ============
+ W_SwitchAndFire
+ 
+ If the given "weaponNum" can be fired, fire it.  Otherwise return false.
+ ============
+ */
+ float(float weaponNum) W_SwitchAndFire =
+ {
+ 	local   float   it, am, fl, wmode;
+ 	
+ 	if (weaponNum > 8) {
+ 		if (deathmatch & DM_WEAPON_MODES)
+ 			return W2_SwitchAndFire(weaponNum);
+ 		else
+ 			return FALSE;
+ 	}
+ 
+ 	it = self.items;
+ 	am = 0;
+ 	
+ 	if (weaponNum == 1)
+ 	{
+ 		fl = IT_AXE;
+ 	}
+ 	else if (weaponNum == 2)
+ 	{
+ 		fl = IT_SHOTGUN;
+ 		if (self.ammo_shells < 1)
+ 			am = 1;
+ 	}
+ 	else if (weaponNum == 3)
+ 	{
+ 		fl = IT_SUPER_SHOTGUN;
+ 		if (self.ammo_shells < 2)
+ 			am = 1;
+ 	}               
+ 	else if (weaponNum == 4)
+ 	{
+ 		fl = IT_NAILGUN;
+ 		if (self.ammo_nails < 1)
+ 			am = 1;
+ 	}
+ 	else if (weaponNum == 5)
+ 	{
+ 		fl = IT_SUPER_NAILGUN;
+ 		if (self.ammo_nails < 2)
+ 			am = 1;
+ 	}
+ 	else if (weaponNum == 6)
+ 	{
+ 		fl = IT_GRENADE_LAUNCHER;
+ 		if (self.ammo_rockets < 1)
+ 			am = 1;
+ 	}
+ 	else if (weaponNum == 7)
+ 	{
+ 		fl = IT_ROCKET_LAUNCHER;
+ 		if (self.ammo_rockets < 1)
+ 			am = 1;
+ 	}
+ 	else if (weaponNum == 8)
+ 	{
+ 		fl = IT_LIGHTNING;
+ 		if (self.ammo_cells < 1)
+ 			am = 1;
+ 	}
+ 	
+ 	if (!(self.items & fl))
+ 	{       // don't have the weapon or the ammo
+ 		return FALSE;
+ 	}
+ 	
+ 	if (am)
+ 	{       // don't have the ammo
+ 		return FALSE;
+ 	}
+ 
+ //
+ // set weapon, set ammo
+ //
+ 	self.switch_weapon = self.weapon;
+ 	self.switch_mode = self.weaponmode;
+ 	self.weapon = fl;
+ 	self.weaponmode = 0;
+ 	W_SetCurrentAmmo ();
+ 
+ // FIRE
+ 	SuperDamageSound ();
+ 	W_Attack ();
+ 
+ 	// indicate has started switchfiring
+ 	return TRUE;
+ };
+ 
+ 
+ /*
+ ============
+ W2_SwitchFire
+ 
+ ============
+ */
+ void() W2_SwitchFire =
+ {
+ 	local string s;
+ 	local float attacknum, weaponOrder, fireWeapon, weaponItem;
+ 
+ 	// up to 20 alternate attack keys are available.
+ 	// the "fire" impulses are 101 - 120
+ 	attacknum = self.impulse - 100;
+ 
+ 	// numbered infokeys (eg "1" "2") describe weapon
+ 	// priorities for a given alternate attack key
+ 	s = ftos(attacknum);
+ 	s = infokey(self, s);
+ 	weaponOrder = stof(s);	
+ 	weaponOrder = floor(weaponOrder);
+ 
+ 	// no weapon order defined, just return
+ 	if (weaponOrder == 0) {
+ 		sprint(self, PRINT_HIGH, "No weapon ordering defined for SwitchFire key ");
+ 		s = ftos(attacknum);
+ 		sprint(self, PRINT_HIGH, s);
+ 		sprint(self, PRINT_HIGH, "\n");
+ 		return;
+ 	}
+ 
+ 	fireWeapon = weaponOrder & 15; // get only first four bits
+ 
+ 	while (fireWeapon != 0) {
+ 		fireWeapon = W_SwitchAndFire(fireWeapon); 
+ 		if (fireWeapon) {
+ 			self.switchfiring = 1;
+ 			return;
+ 		} else {
+ 			weaponOrder = floor(weaponOrder / 16); // equivalent of 4 <<
+ 			fireWeapon = weaponOrder & 15; // get only first four bits
+ 		}
+ 	}
+ 
+ 	// if we get this far, either all out of ammo, don't have weapons,
+ 	// or incorrect weapon ordering (for instance 4 lowest order bits zero)
+ 	sprint(self, PRINT_HIGH, "Weapon switch invalid\n");
+ };
+ 
+ /*
+ ============
+ W2_StopSwitchFire
+ 
+ ============
+ */
+ void() W2_StopSwitchFire =
+ {
+ 	self.switchfiring = 0;
+ 	self.weapon = self.switch_weapon;
+ 	self.weaponmode = self.switch_mode;
+ 	W_SetCurrentAmmo();
+ };
+ 
+ // DM_PERFORMANCE related
+ 
+ /*
+ ============
+ FakeNail
+ 
+ Nailgun and SNG fire 2/3 normal nails under DM_PERFORMANCE, each
+ nail doing 3/2 normal damage.  Here we are fake the firing of each
+ third nail, by playing the firing sound and subtracting ammo.
+ ============
+ */
+ void() FakeNail =
+ {
+ 	if (self.weapon == IT_NAILGUN) {
+ 		// if out of ammo
+ 		if (self.ammo_nails < 1) {
+ 			// call normal firing routine, it'll handle
+ 			// out of ammo situation.
+ 			W_FireSpikes(0);
+ 		} else { // fake a nailgun shot
+ 			sound (self, CHAN_WEAPON, "weapons/rocket1i.wav", 1, ATTN_NORM);
+ 			self.ammo_nails = self.ammo_nails - 1;
+ 		}
+ 	} else if (self.weapon == IT_SUPER_NAILGUN) {
+ 		// if out of ammo
+ 		if (  (deathmatch & DM_BALANCED_WEAPONS && self.ammo_nails < 1) ||
+ 			(!(deathmatch & DM_BALANCED_WEAPONS) && self.ammo_nails < 2)  ) 
+ 		{
+ 			W_FireSpikes(0);
+ 		} else { // fake a SNG shot
+ 			sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
+ 			if (deathmatch & DM_BALANCED_WEAPONS)
+ 				self.ammo_nails = self.ammo_nails - 1;
+ 			else
+ 				self.ammo_nails = self.ammo_nails - 2;
+ 		}
+ 	}
+ 
+ };
diff -crbB --unidirectional-new-file qw201/world.qc expert12/world.qc
*** qw201/world.qc	Thu Jul 31 14:54:34 1997
--- expert12/world.qc	Sat Aug 16 20:30:46 1997
***************
*** 171,176 ****
--- 172,179 ----
  //=======================
  void() worldspawn =
  {
+ 	local string s;
+ 
  	lastspawn = world;
  	InitBodyQue ();
  
***************
*** 282,287 ****
--- 283,294 ----
  	precache_model ("progs/v_nail2.mdl");
  	precache_model ("progs/v_rock2.mdl");
  
+ 	// Expert DM
+ 	if (cvar("deathmatch") & DM_GRAPPLE) {
+ 		precache_model ("progs/bit.mdl");// precache grapple (Wedge)
+ 		precache_model ("progs/star.mdl");// precache grapple (Wedge)
+ 	}
+ 
  	precache_model ("progs/bolt.mdl");		// for lightning gun
  	precache_model ("progs/bolt2.mdl");		// for lightning gun
  	precache_model ("progs/bolt3.mdl");		// for boss shock
***************
*** 298,303 ****
--- 305,373 ----
  
  	precache_model ("progs/v_light.mdl");
  	
+ // Expert DM
+ // These precaches make dynamic spawning of items possible
+ // armors
+ 	precache_model ("progs/armor.mdl");
+ // 15 health
+ 	precache_model("maps/b_bh10.bsp");
+ 	precache_sound("items/r_item1.wav");
+ // 25 health
+ 	precache_model("maps/b_bh100.bsp");
+ 	precache_sound("items/r_item2.wav");
+ // 100 Health
+ 	precache_model("maps/b_bh25.bsp");
+ 	precache_sound("items/health1.wav");
+ // weapons
+ 	precache_model ("progs/g_shot.mdl");
+ 	precache_model ("progs/g_nail.mdl");
+ 	precache_model ("progs/g_nail2.mdl");
+ 	precache_model ("progs/g_rock.mdl");
+ 	precache_model ("progs/g_rock2.mdl");
+ 	precache_model ("progs/g_light.mdl");
+ // shell boxes
+ 	precache_model ("maps/b_shell1.bsp");
+ 	precache_model ("maps/b_shell0.bsp");
+ 
+ // Expert DM (DM_WEAPON_MODES)
+ // alternate weapons necessary precaches
+ 	if (cvar("deathmatch") & DM_WEAPON_MODES) {
+ 		// pulse rifle/spread
+ 		precache_model ("progs/laser.mdl");
+ 		precache_sound ("enforcer/enfstop.wav");
+ 		precache_sound ("enforcer/enfire.wav");
+ 		// gibgun
+ 		precache_model ("progs/zom_gib.mdl");
+ 		precache_sound ("zombie/z_hit.wav");
+ 		precache_sound ("zombie/z_miss.wav");
+ 		// throwaxe (custom)
+ 		precache_model ("progs/throwaxe.mdl");
+ 	}
+ 
+ // Expert Teamplay
+ // Team Radio
+ 	if (cvar("teamplay") & TEAM_AUDIO) {
+ 		// Audio files for basic teamplay Team Audio
+ 		precache_sound ("speech/tlgath_a.wav");
+ 		precache_sound ("speech/tlattk_a.wav");
+ 		precache_sound ("speech/tlincm_a.wav");
+ 		precache_sound ("speech/tlcovr_b.wav");
+ 
+ 		// Expert CTF
+ 		s = infokey(world, "ctf");
+ 		ctf = stof(s);
+ 		if (ctf) {
+ 			// Audio files for CTF Team Audio
+ 			precache_sound ("speech/tgattack.wav");
+ 			precache_sound ("speech/tgdown.wav");
+ 			precache_sound ("speech/tgclear.wav");
+ 			precache_sound ("speech/tgstatus.wav");
+ 		}
+ 	}
+ 
+ // Expert DM
+ // For DM_ALTERNATE_POWERUPS, if set
+ 	precache_sound("demon/djump.wav");
  
  //
  // Setup light animation tables. 'a' is total darkness, 'z' is maxbright.
***************
*** 347,358 ****
--- 417,465 ----
  
  void() StartFrame =
  {
+ 	local string s;
+ 
+ 	// Expert optimization
+ 	// cvars don't need split second timing
+ 	if (time > cvartime) {
  		timelimit = cvar("timelimit") * 60;
  		fraglimit = cvar("fraglimit");
  		teamplay = cvar("teamplay");
  		deathmatch = cvar("deathmatch");
+ 		cvartime = time + 2;
+ 	}
+ 
+ 	if (framecount == 1) {
+ 		// Note: CTF can be enabled or disabled except
+ 		// by changing levels.  This was already true,
+ 		// as an issue of flags spawning/no spawning.
+ 		s = infokey(world, "ctf");
+ 		ctf = stof(s);
+ 		s = infokey(world, "loadmod");
+ 		loadmod = stof(s);
+ 		InitDM();
+ 		InitTeams();
+ 		InitCTF();
+ 		localcmd("serverinfo expert 1.20\n"); // server ident and version info
+ 		localcmd("serverinfo mode ");
+ 		if (ctf)
+ 			localcmd("ctf\n");
+ 		else if (teamplay)
+ 			localcmd("teamplay\n");
+ 		else // deathmatch
+ 			localcmd("deathmatch\n");
+ 	}
+ 
+ 	if (!loadmodCalled) {
+ 		if (time > 10 && framecount > 1) {
+ 			dprint("Calling LoadMod\n");
+ 			LoadMod();
+ 		}
+ 	}
  		
  	framecount = framecount + 1;
+ 
+ 
  };
  
  /*
