unit tdemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,math;

type
	TVector = record
   	x,y,z:single;
	end;
	TKeyValueMsg = class(Tobject)
   	key:integer;
		value:longint;
   end;
   TVersion = class(Tobject)
   	version:longint;
	end;
   TValueMsg = class(Tobject)
		value:integer;
   end;
   TSound = class(Tobject)
		volume,attenuation:integer;
       channel:integer;
		entity:integer;
       sound:integer;
       origin:TVector;
	end;
   TStringMsg = class(Tobject)
		s:string;
   end;
   TKeyStringMsg = class(tobject)
		key:integer;
       s:string;
   end;
	TSetAngle = class(tobject)
   	angle:single;
   end;
   TUpdateColor = class(tobject)
   	player:integer;
       shirt:integer;
       pants:integer;
	end;
	TSpawnStatic = class(tobject)
		default_modelindex,default_frame,default_colormap,default_skin:integer;
       origin,angles:Tvector;
	end;
   TSpawnbaseline = class(tobject)
   	entity:integer;
		default_modelindex,default_frame,default_colormap,default_skin:integer;
		origin,angles:Tvector;
	end;
	TSpawnStaticSound = class(tobject)
		origin:TVector;
		sound:integer;
		volume,attenuation:single;
	end;
	Tcdtrack = class(tobject)
		fromtrack,totrack:integer;
	end;
	Tupdateentity = class(tobject)
		entity,modelindex,frame,colormap,skin,effects:integer;
		position,angle:TVector;
	end;
{	TClientdata = class(tobject)
		viewheight:integer;
		idealpitch:integer;
		punchangle_x:integer;
		angles,velocity:TVector;
		items,onground,inwater:integer;
		weaponframe,armourvalue,weaponmodel:integer;
		health,currentammo,shells,nails,rockets,cells,weapon:integer;
	end;}
	Tparticlemsg = class(tobject)
		origin,velocity:TVector;
		color,count:longint;
	end;
	TVectormsg = class(tobject)
		v:Tvector;
	end;
	Tdamage = class(tobject)
   	save,take:integer;
       origin:TVector;
   end;
   Ttempentity = class(tobject)
   	entitytype:integer;
       entity,count:integer;
       origin:TVector;
		trace_endpos:TVector;
	end;
	TMsg = class(Tobject)
		id:integer;
		desc:string;
		next:Tmsg;
		obj:Tobject;
	end;
	TMessageBlock = class(Tobject)
		blocksize:longint;
		angles:TVector;
		clientpos:TVector;
		m:Tmsg;
		msg:pchar;
		time:single;

		viewheight:integer;
		idealpitch:integer;
		punchangle_x:integer;
		pangles,pvelocity:TVector;
		items,onground,inwater:integer;
		weaponframe,armour,weaponmodel:integer;
		health,currentammo,shells,nails,rockets,cells,weapon:integer;
		clientdata:boolean;
	end;
  TDemo1 = class(TDataModule)
  private
	 { Private declarations }

  public
	 { Public declarations }
	 ModelList:Tstringlist;
	 SoundList:Tstringlist;
	 EntityList:Tstringlist;
	 LightstyleList:tstringlist;
	 playerlist:Tstringlist;
	 spawnstaticsoundlist:Tstringlist;
	 spawnbaselinelist:Tstringlist;
	 spawnstaticlist:Tstringlist;
	 filename,levelname,mapname:string;
	 cdtrack:integer;
	 blocks:Tmessageblock;
	 numblocks,nummsgs:integer;
	 blockarray:Pchar;
	 blockarraycount,clientid,age,arraycount:longint;
	 greeting:string;
	 viewentity,clientblocks,serverblocks:integer;
	 serverversion,maxclients,multi:integer;
	 wasqwd:boolean;
	 procedure ReadDEM(filename:string);
	 procedure WriteDEM(filename:string);
	 procedure ReadQWD(filename:string);
	 procedure WriteQWD(filename:string);
	 function EncodeBlock(index:integer;p:Pchar):integer;
	 function EncodeBlock0(p:pchar):integer;
	 function EncodeBlock1(p:pchar):integer;
	 function EncodeBlock2(p:pchar):integer;
	procedure SetBlockInArray(mb:Tmessageblock);
	function GetBlockFromArray(i:integer):Tmessageblock;
	procedure AddMsgToBlock(mb:Tmessageblock;id:integer;desc:string;obj:Tobject);
  end;

var
  Demo1: TDemo1;

implementation

uses Main, blocks;

function ReadString(var p:pchar):string;
begin
	Result := '';
	while (1=1) do
   begin
		if (p^ = #0) then
       	break;
       Result := Result + p^;
		inc(p);
   end;
	inc(p);
end;

procedure WriteString(var p:pchar;s:string);
begin
	CopyMemory(p,@s[1],length(s));
   p := p + length(s);
   p[0] := #0;
   inc(p);
end;

function ReadLong(var p:Pchar):longint;
var
	a:Plongint;
begin
	a := @p[0];
   Result := a^;
	p := p + 4;
end;

procedure WriteLong(var p:pchar;l:longint);
var
	a:Plongint;
begin
	a := @p[0];
	a^ := l;
	p := p + 4;
end;

function ReadShort(var p:Pchar):integer;
var
	a :Psmallint;
begin
	a := @p[0];
	Result := a^;
   p := p + 2;
end;

procedure WriteShort(var p:Pchar;i:smallint);
var
	a :Psmallint;
begin
	a := @p[0];
	a^ := i;
	p := p + 2;
end;

function ReadByte(var p:Pchar):integer;
begin
	Result := ord(p^);
   inc(p);
end;

procedure WriteByte(var p:Pchar;i:integer);
begin
	p^ := chr(i);
   inc(p);
end;

function ReadAngle(var p:Pchar):single;
begin
	Result := ReadByte(p) / 92160;
end;

procedure WriteAngle(var p:Pchar;a:single);
begin
	WriteByte(p, floor(a * 92160));
end;

function ReadAngle16(var p:Pchar):single;
begin
	Result := ReadShort(p) /  12792960;
end;

procedure WriteAngle16(var p:Pchar;a:single);
begin
	WriteShort(p, floor(a * 12792960));
end;

function ReadCoord(var p:Pchar):single;
begin
	Result := ReadShort(p) * 0.125;
end;

procedure WriteCoord(var p:Pchar;a:single);
begin
	WriteShort(p,floor(a*8));
end;

function ReadFloat(var p:Pchar):single;
var
	a:Psingle;
begin
	a := @p[0];
	Result := a^;
   p := p + 4;
end;

procedure WriteFloat(var p:Pchar;b:single);
var
	a:Psingle;
begin
	a := @p[0];
	a^ := b;
   p := p + 4;
end;

{$R *.DFM}
procedure TDemo1.ReadDEM(filename:string);
var
	f:TFileStream;
	flen:longint;
	mask:smallint;
	mb:Tmessageblock;
	p,q:pchar;
   filebuf:pchar;
   c,d:char;
   m:tmsg;
	desc,junk,junk1:string;
	parts,arraycount:integer;
   temparray:pchar;
	ap:pchar;
   app:^pointer;
   obj:Tobject;
	i,currentviewentity:integer;
	ue:Tupdateentity;
begin
	ModelList := Tstringlist.create;
	Soundlist := Tstringlist.create;
	EntityList := Tstringlist.create;
	Lightstylelist := Tstringlist.create;
	playerlist := Tstringlist.create;
	spawnstaticsoundlist := Tstringlist.create;
	spawnbaselinelist := Tstringlist.create;
	spawnstaticlist := Tstringlist.create;

	{read file into memory}
	f := TFileStream.create(filename,fmOpenRead);
   flen := f.size;
	if (f.size =0) then
   begin
		f.destroy;
       exit;
	end;
	filebuf := allocmem(f.size);
	f.read(filebuf^,f.size);
	f.destroy;
	p := filebuf; { don't want to disturb filebuf}
	arraycount := 0;
	parts := 0;
   while (1=1) do
   begin
		if (p^ = #10) then
			break;
		junk := junk + p^;
		inc(p);
	end;
	inc(p);
	cdtrack := strtoint(junk);
	while (p < (filebuf + flen)) do
	begin
		mb := Tmessageblock.create;
		frmBlocks.listbox1.items.addobject('1',mb);
		inc(numblocks);
		CopyMemory(@mb.blocksize,p,16);
		p := p + 16;
		mb.m := nil;
		mb.msg := p;
		mb.clientdata := false;
		m := nil;

		while( p < (mb.msg + mb.blocksize)) do
		begin
			c := chr(ReadByte(p));
			desc := '';
			case (c) of
			#0: {bad len=0}
				begin
					showmessage('bad');
					obj := nil;
					desc := 'bad';
					exit;
				end;
			#1: {nop len=0}
				begin
					desc := 'nop';
					obj := nil;
				end;
			#2: {disconnect len=0}
				begin
					desc := 'disconnect';
					obj := nil;
				end;
			#3: {updatestat}
				begin
					desc := 'updatestat';
					obj := nil;
					case ReadByte(p) of
					0:
						mb.health := ReadLong(p);
					2:
						mb.weaponmodel := ReadLong(p);
					3:
						mb.currentammo := ReadLong(p);
					4:
						mb.armour := ReadLong(p);
					5:
						mb.weaponframe := ReadLong(p);
					6:
						mb.shells := ReadLong(p);
					7:
						mb.nails := ReadLong(p);
					8:
						mb.rockets := ReadLong(p);
					9:
						mb.cells := ReadLong(p);
					10:
						mb.weapon := ReadLong(p);
					15:
						mb.items := ReadLong(p);
					else
						i := ReadLong(p);
					end;
				end;
			#4: {version }
				begin
					desc := 'version';
					obj := Tvaluemsg.create;
					TValuemsg(obj).value := ReadLong(p);
				end;
			#5: {setview }
				begin
					desc := 'setview';
					obj := Tvaluemsg.create;
					Tvaluemsg(obj).value := ReadShort(p);
					if numblocks < 3 then
					begin
						viewentity := Tvaluemsg(obj).value;
						c := #0;
					end;
					currentviewEntity := Tvaluemsg(obj).value;
				end;
			#6: {sound }
				begin
					desc := 'sound';
					obj := Tsound.create;
					mask := ReadByte(p);
					if ((mask and 1)=1) then begin
						Tsound(obj).volume := ReadByte(p);
					end else
						Tsound(obj).volume  := 255;

					if ((mask and 2)=2) then begin
						Tsound(obj).attenuation := ReadByte(p);
					end else
						Tsound(obj).attenuation := 64;

					i := ReadShort(p);
					Tsound(obj).channel := i and 7;
					Tsound(obj).entity := (i shr 3)  and $1fff;

					Tsound(obj).sound := ReadByte(p) -1;

					Tsound(obj).origin.x := ReadCoord(p);
					Tsound(obj).origin.y := ReadCoord(p);
					Tsound(obj).origin.z := ReadCoord(p);
				end;
			#7: {time len=4}
				begin
					desc := 'time';
					obj := nil;
					mb.time := ReadFloat(p);
				end;
			#8: {print len=null term string }
				begin
					desc := 'print';
					obj := Tstringmsg.create;
					Tstringmsg(obj).s := ReadString(p);
					if numblocks = 1 then
						greeting := Tstringmsg(obj).s ;
				end;
			#9: {stufftext }
				begin
					desc := 'stufftext';
					obj := Tstringmsg.create;
					Tstringmsg(obj).s := ReadString(p);
           	end;
       	#$A: {setangle }
				begin
					desc := 'setangle';
                   obj := TVectormsg.create;
					TVectormsg(obj).v.x := ReadAngle(p);
					TVectormsg(obj).v.y := ReadAngle(p);
					TVectormsg(obj).v.z := ReadAngle(p);
				end;
			#$B: {serverinfo }
				begin
					desc := 'serverinfo';
                   serverversion := ReadLong(p);
					maxclients := ReadByte(p);
					multi := ReadByte(p);

					obj := nil;
					levelname := ReadString(p);

					mapname := ReadString(p);

               	ModelList.add(mapname);

					while (1=1) do
					begin
						junk := ReadString(p);
                       if junk = '' then
							break;
						ModelList.add(junk);
                   end;

					while (1=1) do
                   begin
						junk := ReadString(p);
                       if junk = '' then
							break;
						SoundList.add(junk);
                   end;
				end;
			#$C: {lightstyle}
				begin
					mask := ReadByte(p);
                   desc := 'lightstyle';
					junk := ReadString(p);
                   obj := nil;
					LightstyleList.add(junk);
				end;
			#$D: {updatename}
       		begin
					mask := ReadByte(p);
					desc := 'updatename';
					junk := ReadString(p);
{                   EntityList[mask+1] := junk;}
					obj := tkeystringmsg.create;
                   TKeystringmsg(obj).key := mask;
					Tkeystringmsg(obj).s := junk;
                   if numblocks = 3 then
						playerlist.add(junk);
				end;
			#$E: {updatefrags}
				begin
					desc := 'updatefrags';
					obj := Tkeyvaluemsg.create;
					Tkeyvaluemsg(obj).key := ReadByte(p);
                   tkeyvaluemsg(obj).value := ReadShort(p);
				end;
       	#$F: {clientdata}
				begin;
					desc := 'clientdata';
					mask := ReadShort(p);
					mb.clientdata := true;
					obj := nil;
					c := #0;
					if ((mask and $1)<>0) then {viewheight}
					begin
						mb.viewheight := ReadByte(p);
					end else begin
						mb.viewheight := 22;
					end;
					if ((mask and $2)<>0) then {idealpitch}
					begin
						mb.punchangle_x := ReadByte(p);
					end else begin
						mb.punchangle_x := 0;
					end;

					if ((mask and $4)<>0) then {punchangles}
					begin
						mb.pangles.x := ReadAngle(p);
					end else begin
						mb.pangles.x := 0;
					end;
					if ((mask and $20)<>0) then
					begin
						mb.pvelocity.x := ReadAngle(p);
					end else begin
						mb.pvelocity.x := 0;
					end;
					if ((mask and $8)<>0) then
					begin
						mb.pangles.y := ReadAngle(p);
					end else begin
						mb.pangles.y := 0;
					end;
					if ((mask and $40)<>0) then
					begin
						mb.pvelocity.y := ReadAngle(p);
					end else begin
						mb.pvelocity.y := 0;
					end;
					if ((mask and $10)<>0) then
					begin
						mb.pangles.z := ReadAngle(p);
					end else begin
						mb.pangles.z := 0;
					end;
					if ((mask and $80)<>0) then
					begin
						mb.pvelocity.z := ReadAngle(p);
					end else begin
						mb.pvelocity.z := 0;
					end;

					mb.items := ReadLong(p);
{               	if ((mask and $200)<>0) then
						len := len + 0;}
					if ((mask and $400)<>0) then {onground}
						mb.onground := 1
					else
						mb.onground := 0;
					if ((mask and $800)<>0) then {inwater}
						mb.inwater := 1
                   else
               		mb.inwater := 0;

               	if ((mask and $1000)<>0) then {weaponframe}
					begin
						mb.weaponframe := ReadByte(p);
					end else begin
						mb.weaponframe := 0;
					end;
               	if ((mask and $2000)<>0) then {armour}
					begin
						mb.armour := ReadByte(p);
					end else begin
						mb.armour := 0;
                   end;
					if ((mask and $4000)<>0) then {weapon}
					begin
                   	mb.weaponmodel := ReadByte(p);
					end else begin
						mb.weaponmodel := 0;
					end;
					mb.health := ReadShort(p);
                   mb.currentammo := ReadByte(p);
                   mb.shells := ReadByte(p);
                   mb.nails := ReadByte(p);
                   mb.rockets := ReadByte(p);
					mb.cells := ReadByte(p);
					mb.weapon := ReadByte(p);
				end;
			#$10: {stopsound}
				begin
                   desc := 'stopsound';
					obj := Tvaluemsg.create;
					tvaluemsg(obj).value := ReadShort(p);
				end;
			#$11: {updatecolors}
				begin
					desc := 'updatecolors';
					obj := Tupdatecolor.create;
					Tupdatecolor(obj).player := ReadByte(p);
					i := ReadByte(p);
					Tupdatecolor(obj).shirt := i shr 4;
					Tupdatecolor(obj).pants := i and $0f;
				end;
			#$12: {particle}
       		begin
                   desc := 'particle';
                   obj := Tparticlemsg.create;
					Tparticlemsg(obj).origin.x := ReadCoord(p);
					Tparticlemsg(obj).origin.y := ReadCoord(p);
					Tparticlemsg(obj).origin.z := ReadCoord(p);

					Tparticlemsg(obj).velocity.x := ReadAngle(p);
                   Tparticlemsg(obj).velocity.y := ReadAngle(p);
					Tparticlemsg(obj).velocity.z := ReadAngle(p);

					Tparticlemsg(obj).color := ReadByte(p);
					Tparticlemsg(obj).count := ReadByte(p);
				end;
			#$13: {damage}
				begin
                   desc := 'damage';
					obj := Tdamage.create;
					Tdamage(obj).save := ReadByte(p);
					Tdamage(obj).take := ReadByte(p);
					Tdamage(obj).origin.x := ReadCoord(p);
					Tdamage(obj).origin.y := ReadCoord(p);
					Tdamage(obj).origin.z := ReadCoord(p);
				end;
			#$14: {spawnstatic}
				begin
					desc := 'spawnstatic';
					obj := Tspawnstatic.create;
					with Tspawnstatic(obj) do
					begin
						default_modelindex := ReadByte(p);
						default_frame := ReadByte(p);
						default_colormap := ReadByte(p);
						default_skin := ReadByte(p);

						origin.x := ReadCoord(p);
						angles.x  := ReadAngle(p);
						origin.y := ReadCoord(p);
						angles.y  := ReadAngle(p);
						origin.z := ReadCoord(p);
						angles.z  := ReadAngle(p);
						Spawnstaticlist.addobject('',obj);
					end;
				end;
			#$15: {spawnbinary...obsolete, shouldn't occur}
				begin
					desc := 'spawnbinary';
					obj := nil;
				end;
			#$16: {spawnbaseline}
				begin
					desc := 'spawnbaseline';
					obj := Tspawnbaseline.create;
					with Tspawnbaseline(obj) do
					begin
						entity := ReadShort(p);
{						while (entity) > Entitylist.count -1 do
							Entitylist.add('');
						EntityList[entity] := Modellist[entity-1];}

						default_modelindex := ReadByte(p);
						default_frame := ReadByte(p);
						default_colormap := ReadByte(p);
						default_skin := ReadByte(p);
						origin.x := ReadCoord(p);
						angles.x  := ReadAngle(p);
						origin.y := ReadCoord(p);
						angles.y  := ReadAngle(p);
						origin.z := ReadCoord(p);
						angles.z  := ReadAngle(p);
						spawnbaselinelist.addobject('',obj);
					end;
				end;
			#$17: {tempentity}
				begin
					desc := 'tempentity';
					obj := Ttempentity.create;
					with Ttempentity(obj) do
					begin
						entitytype := ReadByte(p);
						case (entitytype) of
						0,1,2,3,4,7,8,10,11:
						begin
							origin.x := ReadCoord(p);
							origin.y := ReadCoord(p);
							origin.z := ReadCoord(p);
						end;
						5,6,9:
						begin
							entity := ReadShort(p);
							origin.x := ReadCoord(p);
							trace_endpos.x := ReadCoord(p);
							origin.y := ReadCoord(p);
							trace_endpos.y := ReadCoord(p);
							origin.z := ReadCoord(p);
							trace_endpos.z := ReadCoord(p);
						end;
						end;
					end;
				end;
			#$18: {setpause}
				begin
					desc := 'setpause';
					obj := Tvaluemsg.create;
					Tvaluemsg(obj).value := ReadByte(p);
				end;
			#$19: {signon}
				begin
					desc := 'signon';
					obj := Tvaluemsg.create;
					Tvaluemsg(obj).value := ReadByte(p);
				end;
			#$1A: {centerprint}
				begin
					desc := 'centerprint';
					junk := ReadString(p);
					obj := Tstringmsg.create;
					Tstringmsg(obj).s := junk;
				end;
			#$1B: {killedmonster}
				begin
					desc := 'killedmonster';
					obj := nil;
				end;
			#$1C: {foundsecret}
				begin
					desc := 'foundsecret';
					obj := nil;
				end;
			#$1D: {spawnstaticsound}
				begin
					desc := 'spawnstaticsound';
					obj := Tspawnstaticsound.create;
					with Tspawnstaticsound(obj) do
					begin
						origin.x := ReadCoord(p);
						origin.y := ReadCoord(p);
						origin.z := ReadCoord(p);
						sound := ReadByte(p);
						volume := ReadByte(p) / 255.0;
						attenuation := ReadByte(p) / 64.0;
						spawnstaticsoundlist.addobject('',obj);
					end;
				end;
			#$1E: {intermission}
				begin
					desc := 'intermission';
					obj := nil;
				end;
			#$1F: {finale}
				begin
					desc := 'finale';
					junk := ReadString(p);
					obj := Tstringmsg.create;
					Tstringmsg(obj).s := junk;
				end;
			#$20: {cdtrack len=2}
				begin
					desc := 'cdtrack';
					obj := Tcdtrack.create;
					Tcdtrack(obj).fromtrack := ReadByte(p);
					Tcdtrack(obj).totrack := ReadByte(p);
				end;
			#$21: {sellscreen}
				begin
					desc := 'sellscreen';
					obj := nil;
				end;
			else {update entity}
				begin
					desc := 'updateentity';
					mask := ord(c) and $7f;
					obj := Tupdateentity.create;
					with Tupdateentity(obj) do
					begin
						if ((mask and $1)<>0) then
						begin
							mask := mask or (ReadByte(p) shl 8);
						end;
						if ((mask and $4000)<>0) then {entity}
						begin
							entity := ReadShort(p);
						end else begin
							entity := ReadByte(p);
						end;

						for i := 0 to spawnbaselinelist.count -1 do
						begin
							ue := Tupdateentity(spawnbaselinelist.objects[i]);
							if ue.entity = entity then
							begin
								break;
							end;
						end;

						if ((mask and $400)<>0) then {modelindex}
						begin
							modelindex := ReadByte(p);
						end else
							modelindex := ue.modelindex;

						if ((mask and $40)<>0) then {frame}
						begin
							frame := ReadByte(p);
						end else
							frame := ue.frame;

						if ((mask and $800)<>0) then {colormap}
						begin
							colormap := ReadByte(p);
						end else
							colormap := ue.colormap;

						if ((mask and $1000)<>0) then {skin}
						begin
							skin := ReadByte(p);
						end else
							skin := ue.skin;

						if ((mask and $2000)<>0) then {effects}
						begin
							effects := ReadByte(p);
						end	else
							effects := ue.effects;

						if ((mask and $2)<>0) then
						begin
							position.x := ReadCoord(p);
						end else begin
							position.x := ue.position.x;
						end;
						if ((mask and $100)<>0) then
						begin
							angle.x := ReadAngle(p);
						end else begin
							angle.x := ue.angle.x;
						end;
						if ((mask and $4)<>0) then
						begin
							position.y := ReadCoord(p);
						end else begin
							position.y := ue.position.y;
						end;
						if ((mask and $10)<>0) then
						begin
							angle.y := ReadAngle(p);
						end else begin
							angle.y := ue.angle.y;
						end;
						if ((mask and $8)<>0) then
						begin
							position.z := ReadCoord(p);
						end else begin
							position.z := ue.position.z;
						end;
						if ((mask and $200)<>0) then
						begin
							angle.z := ReadAngle(p);
						end else begin
							angle.z := ue.angle.z;
						end;

{						if entity = currentviewentity then
						begin
							mb.clientpos := position;
							c := #0;
							obj.free;
						end;}
					end;
				end;
			end;
			inc(parts);

			if mb <> nil then
				if numblocks > 3 then
				begin
					if c <> #0 then
						AddMsgToBlock(mb,ord(c),desc,obj);
				end;
		end;
		if numblocks > 3 then
			SetBlockInArray(mb);
	end;
	freemem(filebuf);
	ShowMessage('done '+inttostr(parts));
end;

procedure TDemo1.WriteDEM(filename:string);
var
	f:TFileStream;
	f1:textfile;
	len:integer;
	junk:string;
	i:integer;
	msgbuf:array[0..10000] of char;
begin
	{ make sure the file exists }
	Assignfile(f1,filename);
	rewrite(f1);
	closefile(f1);
	f := TFileStream.create(filename,fmOpenWrite);
	{ write the cd track }
	junk := inttostr(cdtrack) + #10;
	f.write(junk[1],length(junk));


	len := EncodeBlock0(@msgbuf[0]);
	f.write(msgbuf[0],len);

	len := EncodeBlock1(@msgbuf[0]);
	f.write(msgbuf[0],len);

	len := EncodeBlock2(@msgbuf[0]);
	f.write(msgbuf[0],len);

	{ now write out all the blocks }
	for i := 0 to arraycount -1 do
	begin
		len := EncodeBlock(i,@msgbuf[0]);
		f.write(msgbuf[0],len);
	end;
	f.destroy;
end;

function Tdemo1.EncodeBlock0(p:pchar):integer;
var
	start:pchar;
	i:integer;
	junk:string;
	a:Plongint;
begin
	start := p;
	p := p + 16;
	WriteByte(p,8);
	WriteString(p,greeting);

	WriteByte(p,$B);{serverinfo}
	WriteLong(p,$0f);
	WriteByte(p,maxclients);
	WriteByte(p,multi);

	WriteString(p,levelname);

	{model precache}
	for i := 0 to modellist.count -1 do
	begin
		WriteString(p,modellist[i]);
	end;
	junk := '';
	WriteString(p,junk);

	{sound precache}
	for i := 0 to soundlist.count -1 do
	begin
		WriteString(p,soundlist[i]);
	end;
	junk := '';
	WriteString(p,junk);

	{cd track }
	WriteByte(p,$20);
	WriteByte(p,cdtrack);
	WriteByte(p,cdtrack);

	{setview}
	WriteByte(p,5);
	WriteShort(p,viewentity);

   WriteByte(p,$19);
   WriteByte(p,1);

	a := @start[0];
	a^ := p-start-16;
	Result := p - start;
end;

function Tdemo1.EncodeBlock1(p:pchar):integer;
var
	start:pchar;
   i:integer;
	junk:string;
   sss:Tspawnstaticsound;
   sbl:Tspawnbaseline;
   a:Plongint;
begin
	start := p;
   p := p + 16;

	for i := 0 to spawnstaticsoundlist.count -1 do
   begin
		sss := Tspawnstaticsound(spawnstaticsoundlist.objects[i]);
       WriteByte(p,$1d);

       WriteCoord(p,sss.origin.x);
		WriteCoord(p,sss.origin.y);
		WriteCoord(p,sss.origin.z);
		WriteByte(p,sss.sound);
		WriteByte(p,floor(sss.volume * 255));
		WriteByte(p,floor(sss.attenuation * 64));
	end;
	for i := 0 to spawnbaselinelist.count -1 do
	begin
		sbl := Tspawnbaseline(spawnbaselinelist.objects[i]);
		WriteByte(p,$16);

		WriteShort(p,sbl.entity);

		WriteByte(p,sbl.default_modelindex);
		WriteByte(p,sbl.default_frame);
		WriteByte(p,sbl.default_colormap);
		WriteByte(p,sbl.default_skin);

		WriteCoord(p,sbl.origin.x);
		WriteAngle(p,sbl.angles.x);
		WriteCoord(p,sbl.origin.y);
		WriteAngle(p,sbl.angles.y);
		WriteCoord(p,sbl.origin.z);
		WriteAngle(p,sbl.angles.z);
	end;
   WriteByte(p,$19);
	WriteByte(p,2);

	a := @start[0];
   a^ := p-start-16;
	Result := p - start;
end;

function Tdemo1.EncodeBlock2(p:pchar):integer;
var
	start:pchar;
   i:integer;
	junk:string;
	a:plongint;
begin
	start := p;
   p := p + 16;

   {time}
	WriteByte(p,7);
	WriteFloat(p,0);
	{players..name,frags,color}
   WriteByte(p,$D);
	WriteByte(p,0);
	junk := playerlist[0];
   WriteString(p,junk);

	WriteByte(p,$E);
	WriteByte(p,0);
	WriteShort(p,0);

	WriteByte(p,$11);
	WriteByte(p,0);
   WriteByte(p,0);

	{lightstyles}
	for i := 0 to lightstylelist.count -1 do
   begin
   	WriteByte(p,$C);
		WriteByte(p,i);
   	junk := lightstylelist[i];
		WriteString(p,junk);
	end;
	{updatestats}
	{setangles}
	{clientdata}
	{signon-3}
	WriteByte(p,$19);
	WriteByte(p,3);
	{name,colors}
	a := @start[0];
	a^ := p-start-16;
	Result := p - start;
end;

function TDemo1.EncodeBlock(index:integer;p:Pchar):integer;
var
	mb:Tmessageblock;
	m:tmsg;
	obj:Pointer;
	q,start:pchar;
	mask:smallint;
	i,j:integer;
	ue:TupdateEntity;
	a:Plongint;
begin
	start := p;
	mb := GetBlockFromArray(index);
	m := mb.m;
	CopyMemory(p,@mb.blocksize,16);
	p := p + 16;
	{write the time block}
	WriteByte(p,7);
	WriteFloat(p,mb.time);
	if mb.clientdata then
	begin
				WriteByte(p,$F);      //clientdata
				q := p;
				p := p + 2;
				mask := 0;
					if mb.viewheight <> 22 then
					begin
						mask := mask or 1;
						WriteByte(p,mb.viewheight);
					end;
					if mb.punchangle_x <> 0 then
					begin
						mask := mask or 2;
						WriteByte(p,mb.punchangle_x);
					end;

					if mb.pangles.x <> 0 then
					begin
						mask := mask or 4;
						WriteAngle(p,mb.pangles.x);
					end;
					if mb.pvelocity.x <> 0 then
					begin
						mask := mask or $20;
						WriteAngle(p,mb.pvelocity.x);
					end;
					if mb.pangles.y <> 0 then
					begin
						mask := mask or 8;
						WriteAngle(p,mb.pangles.y);
					end;
					if mb.pvelocity.y <> 0 then
					begin
						mask := mask or $40;
						WriteAngle(p,mb.pvelocity.y);
					end;
					if mb.pangles.z <> 0 then
					begin
						mask := mask or $10;
						WriteAngle(p,mb.pangles.z);
					end;
					if mb.pvelocity.z <> 0 then
					begin
						mask := mask or $80;
						WriteAngle(p,mb.pvelocity.z);
					end;

					mask := mask or $200;
					WriteLong(p,mb.items);
					if mb.onground = 1 then
						mask := mask or $400;
					if mb.inwater = 1 then
						mask := mask or $800;

					if mb.weaponframe <> 0 then
					begin
						mask := mask or $1000;
						WriteByte(p,mb.weaponframe);
					end;
					if mb.armour <> 0 then
					begin
						mask := mask or $2000;
						WriteByte(p,mb.armour);
					end;
					if mb.weaponmodel <> 0 then
					begin
						mask := mask or $4000;
						WriteByte(p,mb.weaponmodel);
					end;
					WriteShort(p,mb.health);
					WriteByte(p,mb.currentammo);
					WriteByte(p,mb.shells);
					WriteByte(p,mb.nails);
					WriteByte(p,mb.rockets);
					WriteByte(p,mb.cells);
					WriteByte(p,mb.weapon);
					WriteSHort(q,mask);
	end;
	while (m <> nil) do
	begin
		WriteByte(p,m.id);
		obj := m.obj;
		case m.id of
			0: {bad}
				exit;
			1: {nop}
				exit;
			2: {disconnect}
			begin
			end;
			3: {updatestat}
			begin
				WriteByte(p,Tkeyvaluemsg(obj).key);
				WriteLong(p,Tkeyvaluemsg(obj).value);
			end;
           4: {version}
           begin
               WriteLong(p,Tvaluemsg(obj).value);
			end;
           5,$10: {setview,stopsound}
           begin
				WriteShort(p,Tvaluemsg(obj).value);
           end;
			6: {sound}
			begin
				q := p; {leave space for mask }
           	inc(p);
               mask := 0;
				if Tsound(obj).volume <> 255 then
				begin
					mask := mask or 1;
                   WriteByte(p,Tsound(obj).volume);
				end;
				if Tsound(obj).attenuation <> 64 then
				begin
					mask := mask or 2;
					WriteByte(p,Tsound(obj).attenuation);
               end;
               i := Tsound(obj).channel;
               i := i or (Tsound(obj).entity shl 3);
				WriteShort(p,i);

               WriteByte(p,Tsound(obj).sound + 1);
				WriteCoord(p,Tsound(obj).origin.x);
               WriteCoord(p,Tsound(obj).origin.y);
				WriteCoord(p,Tsound(obj).origin.z);
				WriteByte(q,mask);{ go back and put the mask in }
			end;
			7: {time}
           begin
           	WriteFloat(p,mb.time);
			end;
           8,9,$1A,$1F: {print,stufftext,centerprint,finale}
           begin
				WriteString(p,Tstringmsg(obj).s);
			end;
			$A: {setangle}
			begin
				WriteAngle(p,Tvectormsg(obj).v.x );
           	WriteAngle(p,Tvectormsg(obj).v.y );
           	WriteAngle(p,Tvectormsg(obj).v.z );
           end;
			$B: {serverinfo..shouldn't occur}
				exit;
			$C: {lightstyle...shouldn't occur}
				exit;
			$D: {updatename}
			begin
				WriteByte(p,Tkeystringmsg(obj).key);
				WriteString(p,Tkeystringmsg(obj).s);
			end;
			$E: {updatefrags}
			begin
				WriteByte(p,Tkeyvaluemsg(obj).key);
				WriteShort(p,Tkeyvaluemsg(obj).value);
			end;
			$F: {clientdata..this should be fun }
			begin
				ShowMessage('clientdata');
			end;
			$11: {updatecolors}
			begin
				WriteByte(p,Tupdatecolor(obj).player);
				mask := Tupdatecolor(obj).pants and (tupdatecolor(obj).shirt shl 4);
               WriteByte(p,mask);
           end;
			$12: {particle}
			begin
           	with Tparticlemsg(obj) do
				begin
					WriteCoord(p,origin.x);
               	WriteCoord(p,origin.y);
               	WriteCoord(p,origin.z);

					WriteAngle(p,velocity.x);
					WriteAngle(p,velocity.y);
					WriteAngle(p,velocity.z);

                   WriteByte(p,color);
                   WriteByte(p,count);
				end;
			end;
			$13: {damage}
           begin
           	with Tdamage(obj) do
				begin
					WriteByte(p,save);
					WriteByte(p,take);
					WriteCoord(p,origin.x);
					WriteCoord(p,origin.y);
               	WriteCoord(p,origin.z);
				end;
			end;
			$14..$16,$1D: {spawns..shouldn't happen}
           	exit;
			$17: {tempentity}
			begin
				with Ttempentity(obj) do
               begin
					WriteByte(p,entitytype);
					case entitytype of
                   0,1,2,3,4,7,8,10,11:
					begin
						WriteCoord(p,origin.x);
               		WriteCoord(p,origin.y);
               		WriteCoord(p,origin.z);
					end;
					5,6,9:
                   begin
                   	WriteShort(p,entity);
						WriteCoord(p,origin.x);
						WriteCoord(p,trace_endpos.x);
               		WriteCoord(p,origin.y);
						WriteCoord(p,trace_endpos.y);
						WriteCoord(p,origin.z);
               		WriteCoord(p,trace_endpos.z);
                   end;
					end;
				end;
           end;
			$18,$19: {setpause,signon}
			begin
				WriteByte(p,Tvaluemsg(obj).value);
           end;
			$20: {cdtrack}
			begin
				WriteByte(p,Tcdtrack(obj).fromtrack);
				WriteByte(p,Tcdtrack(obj).totrack);
           end;
			else {updateentity}
           begin
				q := p; {leave spot for mask}
				inc(p);
				with Tupdateentity(obj) do
				begin
						for j := 0 to spawnbaselinelist.count -1 do
						begin
							ue := Tupdateentity(spawnbaselinelist.objects[j]);
							if ue.entity = entity then
							begin
								break;
							end;
						end;

				mask := 1;
				if entity > 256 then
				begin
					WriteShort(p,entity);
					mask := mask or $4000;
				end else begin
					WriteByte(p,entity);
				end;
				if modelindex <> ue.modelindex then
				begin
					WriteByte(p,modelindex);
					mask := mask or $400;
				end;
				if frame <> ue.frame then
				begin
					WriteByte(p,frame);
					mask := mask or $40;
				end;
				if colormap <> ue.colormap then
				begin
					WriteByte(p,colormap);
					mask := mask or $800;
				end;
				if skin <> ue.skin then
				begin
					WriteByte(p,skin);
					mask := mask or $1000;
				end;
				if effects <> ue.effects then
				begin
					WriteByte(p,effects);
					mask := mask or $2000;
				end;

				if position.x <> ue.position.x then
				begin
					WriteCoord(p,position.x);
					mask := mask or $2;
				end;
				if angle.x <> ue.angle.x then
				begin
					WriteAngle(p,angle.x);
					mask := mask or $100;
				end;

				if position.y <> ue.position.y then
				begin
					WriteCoord(p,position.y);
					mask := mask or $4;
				end;
				if angle.y <> ue.angle.y then
				begin
					WriteAngle(p,angle.y);
					mask := mask or $10;
				end;

				if position.z <> ue.position.z then
				begin
					WriteCoord(p,position.z);
					mask := mask or $8;
				end;
				if angle.z <> ue.angle.z then
				begin
					WriteAngle(p,angle.z);
					mask := mask or $200;
				end;
				dec(q);
				WriteByte(q,mask or 128);
				WriteByte(q,mask shr 8);
				end;
			end;
			end;
			m := m.next;
		end;
	a := @start[0];
	a^ := p-start-16;
	Result := p - start;
end;

procedure Tdemo1.AddMsgToBlock(mb:Tmessageblock;id:integer;desc:string;obj:Tobject);
var
	n,m:Tmsg;
begin
	if id = 0 then
		exit;
	m := Tmsg.create;
	m.desc := desc;
	m.id := id;
	m.obj := obj;
	m.next := nil;

	if mb.m = nil then
	begin
		mb.m := m;
		exit;
	end;

	n := mb.m;
	while (n.next<>nil) do
		n := n.next;
	n.next := m;
end;

procedure Tdemo1.SetBlockInArray(mb:Tmessageblock);
var
	temparray:pchar;
	ap:pchar;
	app:^pointer;
begin
	if mb = nil then
		exit;
	if mb.m = nil then
		exit;

	if arraycount > blockarraycount-1 then
	begin
		Temparray := allocmem((blockarraycount + 100) * 4);
		CopyMemory(Temparray,blockarray,blockarraycount * 4);
		Freemem(blockarray);
		blockarray := temparray;
		blockarraycount := blockarraycount + 100;
	end;

	ap := pchar(@blockarray[0]) + (arraycount * 4);
	app := @ap[0];
	app^ := mb;
	inc(arraycount);
end;

function Tdemo1.GetBlockFromArray(i:integer):Tmessageblock;
var
	ap:pchar;
	app:^pointer;
begin
	if i > arraycount-1 then
	begin
		Result := nil;
		exit;
	end;
	ap := pchar(@blockarray[0]) + (i * 4);
	app := @ap[0];
	Result := app^;
end;

procedure TDemo1.ReadQWD(filename:string);
var
	f:TFileStream;
	flen,h:longint;
	len:integer;
	mask,mask2:smallint;
	mb:Tmessageblock;
	p,q,endp:pchar;
	filebuf:pchar;
	c,d:char;
	desc,junk,junk1,junk2,bc:string;
	parts,arraycount:integer;
	obj:Tobject;
	i,j:integer;
	ue:Tupdateentity;
	z:single;
begin
	ModelList := Tstringlist.create;
	Soundlist := Tstringlist.create;
	EntityList := Tstringlist.create;
	Lightstylelist := Tstringlist.create;
	playerlist := Tstringlist.create;
	spawnstaticsoundlist := Tstringlist.create;
	spawnbaselinelist := Tstringlist.create;
	spawnstaticlist := Tstringlist.create;

	{read file into memory}
	f := TFileStream.create(filename,fmOpenRead);
	flen := f.size;
	if (f.size =0) then
	begin
		f.destroy;
		exit;
	end;
	filebuf := allocmem(f.size);
	f.read(filebuf^,f.size);
	f.destroy;
	p := filebuf; { don't want to disturb filebuf}
	arraycount := 0;
	parts := 0;
	len := 0;
	wasqwd := true;
	while (p < (filebuf + flen)) do
	begin
		mb := Tmessageblock.create;
		mb.time := ReadFloat(p);
		mb.m := nil;
		c := chr(ReadByte(p));
		case c of
			#0: {client block}
				begin
					inc(clientblocks);
					desc := 'client block';
					p := p + 36;
					mb.free;
					mb := nil;
				end;
			#1: {server block}
				begin
					inc(serverblocks);
					mb.blocksize := ReadLong(p);
					h := ReadLong(p);
					mb.blocksize := mb.blocksize -4;
					if h = $FFFFFFFF then {special block}
					begin
						c := chr(ReadByte(p));
						mb.free;
						mb := nil;
						case c of
							#2: {disconnect}
								begin
									junk := ReadString(p);
									obj := nil;
									desc := 'disconnect';
									c := #0;
								end;
							#$42: {stufftext}
								begin
									desc := 'stufftext';
									junk := ReadString(p);
									obj := Tstringmsg.create;
									Tstringmsg(obj).s := junk;
									c := #0;
								end;
							#$6A: {connect}
								begin
									obj := nil;
									desc := 'connect';
									c := #0;
								end;
							#$6B: {keepalive}
								begin
									obj := nil;
									desc := 'keepalive';
									c := #0;
								end;
							#$6E: {print}
								begin
									junk := ReadString(p);
									desc := 'print';
									c := #8;
									obj := Tstringmsg.create;
									Tstringmsg(obj).s := junk;
									c := #0;
								end;
						end;
					end else begin {game block}
						mb.blocksize := mb.blocksize -4;
						p := p + 4; {jump over sequences}
						endp := p + mb.blocksize;
						while (p < endp) do
						begin
							c := chr(ReadByte(p));
							case (c) of
								#0,#4,#5,#7,#$D,#$F,#$11,#$12,#$18,#$19:
								begin
									showmessage('bad');
									obj := nil;
									desc := 'bad';
									exit;
								end;
								#1: {nop }
								begin
									desc := 'nop';
									obj := nil;
								end;
								#2: {disconnect }
								begin
									desc := 'disconnect';
									obj := nil;
								end;
			#3: {updatestat}
				begin
					desc := 'updatestat';
					obj := nil;
					case ReadByte(p) of
					0:
						mb.health := ReadByte(p);
					2:
						mb.weaponmodel := ReadByte(p);
					3:
						mb.currentammo := ReadByte(p);
					4:
						mb.armour := ReadByte(p);
					5:
						mb.weaponframe := ReadByte(p);
					6:
						mb.shells := ReadByte(p);
					7:
						mb.nails := ReadByte(p);
					8:
						mb.rockets := ReadByte(p);
					9:
						mb.cells := ReadByte(p);
					10:
						mb.weapon := ReadByte(p);
					15:
						mb.items := ReadByte(p);
					else
						i := ReadByte(p);
					end;
					c := #0;
				end;
			#6: {sound }
				begin
					desc := 'sound';
					obj := Tsound.create;
					mask := ReadShort(p);
					if ((mask and $8000)=$8000) then begin
						Tsound(obj).volume := ReadByte(p);
					end else
						Tsound(obj).volume  := 255;

					if ((mask and $4000)=$4000) then begin
						Tsound(obj).attenuation := ReadByte(p);
					end else
						Tsound(obj).attenuation := 64;

					Tsound(obj).channel := mask and 7;
					Tsound(obj).entity := (mask shr 3)  and $03ff;

					Tsound(obj).sound := ReadByte(p) -1;

					Tsound(obj).origin.x := ReadCoord(p);
					Tsound(obj).origin.y := ReadCoord(p);
					Tsound(obj).origin.z := ReadCoord(p);
				end;
			#8: {print }
				begin
					desc := 'print';
					mask := ReadByte(p);
					junk := ReadString(p);
					obj := Tstringmsg.create;
					Tstringmsg(obj).s := junk;
					if numblocks = 1 then
						greeting := junk;
				end;
			#9: {stufftext }
				begin
					desc := 'stufftext';
					junk := ReadString(p);
					obj := Tstringmsg.create;
					Tstringmsg(obj).s := junk;
				end;
			#$A: {setangle }
				begin
					desc := 'setangle';
					obj := TVectormsg.create;
					TVectormsg(obj).v.x := ReadAngle(p);
					TVectormsg(obj).v.y := ReadAngle(p);
					TVectormsg(obj).v.z := ReadAngle(p);
				end;
			#$B: {serverinfo }
				begin
					desc := 'serverinfo';
					serverversion := ReadLong(p);
					clientid := ReadLong(p);
					age := ReadLong(p);
					mapname := ReadString(p);
					obj := nil;
					c := #0;

					maxclients := 8;
					viewentity := 1;
				end;
			#$C: {lightstyle}
				begin
					desc := 'lightstyle';
					mask := ReadByte(p);
					junk := ReadString(p);
					obj := nil;
					LightstyleList.add(junk);
					c := #0;
				end;
			#$E: {updatefrags}
				begin
					desc := 'updatefrags';
					obj := Tkeyvaluemsg.create;
					Tkeyvaluemsg(obj).key := ReadByte(p);
					if Tkeyvaluemsg(obj).key >= maxclients then
						c := #0;
					tkeyvaluemsg(obj).value := ReadShort(p);
				end;
			#$10: {stopsound}
				begin
					desc := 'stopsound';
					obj := Tvaluemsg.create;
					tvaluemsg(obj).value := ReadShort(p);
				end;
			#$13: {damage}
				begin
					desc := 'damage';
					obj := Tdamage.create;
					Tdamage(obj).save := ReadByte(p);
					Tdamage(obj).take := ReadByte(p);
					Tdamage(obj).origin.x := ReadCoord(p);
					Tdamage(obj).origin.y := ReadCoord(p);
					Tdamage(obj).origin.z := ReadCoord(p);
				end;
			#$14: {spawnstatic}
				begin
					desc := 'spawnstatic';
					obj := Tspawnstatic.create;
					with Tspawnstatic(obj) do
					begin
						default_modelindex := ReadByte(p);
						default_frame := ReadByte(p);
						default_colormap := ReadByte(p);
						default_skin := ReadByte(p);
						origin.x := ReadCoord(p);
						angles.x := ReadAngle(p);
						origin.y := ReadCoord(p);
						angles.y := ReadAngle(p);
						origin.z := ReadCoord(p);
						angles.z := ReadAngle(p);

						Spawnstaticlist.addobject('',obj);
						c := #0;
					end;
				end;
			#$15: {spawnbinary...obsolete, shouldn't occur}
				begin
					desc := 'spawnbinary';
					obj := nil;
					exit;
				end;
			#$16: {spawnbaseline}
				begin
					desc := 'spawnbaseline';
					obj := Tspawnbaseline.create;
					with Tspawnbaseline(obj) do
					begin
						entity := ReadShort(p);
{						while (entity) > Entitylist.count -1 do
							Entitylist.add('');
						EntityList[entity] := Modellist[entity-1];}

						default_modelindex := ReadByte(p);
						default_frame := ReadByte(p);
						default_colormap := ReadByte(p);
						default_skin := ReadByte(p);
						origin.x := ReadCoord(p);
						angles.x := ReadAngle(p);
						origin.y := ReadCoord(p);
						angles.y := ReadAngle(p);
						origin.z := ReadCoord(p);
                       angles.z := ReadAngle(p);
						spawnbaselinelist.addobject('',obj);
						c:=#0;
					end;
				end;
			#$17: {tempentity}
				begin
					desc := 'tempentity';
					obj := Ttempentity.create;
					with Ttempentity(obj) do
					begin
						entitytype := ReadByte(p);
						case (entitytype) of
						0,1,3,4,7,8,10,11:
						begin
							origin.x := ReadCoord(p);
							origin.y := ReadCoord(p);
							origin.z := ReadCoord(p);
						end;
						5,6,9:
						begin
							entity := ReadShort(p);
							origin.x := ReadCoord(p);
							origin.y := ReadCoord(p);
							origin.z := ReadCoord(p);
							trace_endpos.x := ReadCoord(p);
							trace_endpos.y := ReadCoord(p);
							trace_endpos.z := ReadCoord(p);
						end;
						2,12,13: {not supported}
						begin
							count := ReadByte(p);
							origin.x := ReadCoord(p);
							origin.y := ReadCoord(p);
							origin.z := ReadCoord(p);
							obj.free;
							obj := nil;
							c := #0;
						end;
						end;
					end;
				end;
			#$1A: {centerprint}
				begin
					desc := 'centerprint';
					junk := ReadString(p);
					obj := Tstringmsg.create;
					Tstringmsg(obj).s := junk;
				end;
			#$1B: {killedmonster}
				begin
					desc := 'killedmonster';
					obj := nil;
				end;
			#$1C: {foundsecret}
				begin
					desc := 'foundsecret';
					obj := nil;
				end;
			#$1D: {spawnstaticsound}
				begin
					desc := 'spawnstaticsound';
					obj := Tspawnstaticsound.create;
					with Tspawnstaticsound(obj) do
					begin
						origin.x := ReadCoord(p);
						origin.y:= ReadCoord(p);
						origin.z:= ReadCoord(p);
						sound := ReadByte(p);
						volume := ReadByte(p)/ 255.0;
						attenuation := ReadByte(p) / 64.0;
						spawnstaticsoundlist.addobject('',obj);
						c := #0;
					end;
				end;
			#$1E: {intermission}
				begin
					desc := 'intermission';
					{there is coord/angle data here...we'll ignore for now}
					z := ReadCoord(p);
					z := ReadAngle(p);
					z := ReadCoord(p);
					z := ReadAngle(p);
					z := ReadCoord(p);
					z := ReadAngle(p);
					obj := nil;
				end;
			#$1F: {finale}
				begin
					desc := 'finale';
					junk := ReadString(p);
					obj := Tstringmsg.create;
					Tstringmsg(obj).s := junk;
				end;
			#$20: {cdtrack }
				begin
					desc := 'cdtrack';
					obj := Tcdtrack.create;
					Tcdtrack(obj).fromtrack := ReadByte(p);
					Tcdtrack(obj).totrack := Tcdtrack(obj).fromtrack;
				end;
			#$21: {sellscreen}
				begin
					desc := 'sellscreen';
					obj := nil;
				end;
			#$22: {smallkick}
				begin
					desc := 'smallkick';
					obj := nil;
					c := #0;
				end;
			#$23: {bigkick}
				begin
					desc := 'bigkick';
					obj := nil;
					c := #0;
				end;
			#$24: {updateping}
				begin
					desc := 'updateping';
					obj := Tkeyvaluemsg.create;
					Tkeyvaluemsg(obj).key :=ReadByte(p);
					Tkeyvaluemsg(obj).value := ReadShort(p);
					c := #0;
				end;
			#$25: {updateentertime}
				begin
					desc := 'updateentertime';
					obj := Tkeyvaluemsg.create;
					Tkeyvaluemsg(obj).key := ReadByte(p);
					Tkeyvaluemsg(obj).value := ReadLong(p);
					c := #0;
				end;
			#$26: {updatestatlong}
				begin
					desc := 'updatestatlong';
					obj := nil;
					case ReadByte(p) of
					0:
						mb.health := ReadLong(p);
					2:
						mb.weaponmodel := ReadLong(p);
					3:
						mb.currentammo := ReadLong(p);
					4:
						mb.armour := ReadLong(p);
					5:
						mb.weaponframe := ReadLong(p);
					6:
						mb.shells := ReadLong(p);
					7:
						mb.nails := ReadLong(p);
					8:
						mb.rockets := ReadLong(p);
					9:
						mb.cells := ReadLong(p);
					10:
						mb.weapon := ReadLong(p);
					15:
						mb.items := ReadLong(p);
					else
						i := ReadLong(p);
					end;
					c := #0;
				end;
			#$27: {muzzleflash}
				begin
					desc := 'muzzleflash';
					obj := nil;
					i := ReadShort(p); {entity}
					c := #0;
				end;
			#$28: {updateuserinfo}
				begin
					desc := 'updateuserinfo';
					obj := nil;
					j := ReadByte(p); {player}
					i := ReadLong(p); {unknown}
					junk := ReadString(p);
					delete(junk,1,1);
					while junk <>'' do
					begin
						i := pos('\',junk);
						junk1 := copy(junk,1,i-1);
						delete(junk,1,i);
						i := pos('\',junk);
						if i = 0 then
							i := length(junk);
						junk2 := copy(junk,1,i-1);
						delete(junk,1,i);
						if j < maxclients then
						begin
						if junk1 = 'name' then
						begin
							obj := Tkeystringmsg.create;
							Tkeystringmsg(obj).key := j;
							Tkeystringmsg(obj).s := junk2;
							playerlist.add(junk2);
							AddMsgToBlock(mb,$D,desc,obj);
						end;
						if junk1 = 'bottomcolor' then
						begin
							bc := junk2;
						end;
						if junk1 = 'topcolor' then
						begin
							obj := Tupdatecolor.create;
							Tupdatecolor(obj).player := j;
							Tupdatecolor(obj).shirt := strtoint(junk2);
							Tupdatecolor(obj).pants := strtoint(bc);

							AddMsgToBlock(mb,$11,desc,obj);
						end;
						end;
					end;
					c := #0;
				end;
			#$29: {download}
				begin
					desc := 'download';
					obj := nil;
					mask := ReadShort(p);
					i := ReadByte(p);
					p := p + mask;
					c := #0;
				end;
			#$2A: {playerinfo}
				begin
					desc := 'playerinfo';
					obj := nil;
					i := ReadByte(p);
					mask := ReadShort(p);
					mb.clientdata := true;

					z := ReadCoord(p); {coords}
					mb.clientpos.x := z;
					z := ReadCoord(p);
					mb.clientpos.y := z;
					z := ReadCoord(p);
					mb.clientpos.z := z;

					i := ReadByte(p); {frame}

					if (mask and 1) = 1 then
						i := ReadByte(p); {ping}
					if (mask and 2) = 2 then
					begin
						mask2 := ReadByte(p);
						if (mask2 and 1) = 1 then
							mb.pangles.x := ReadShort(p); {angles}
						mb.pangles.y := ReadShort(p); {angles}
						if (mask2 and 2) = 2 then
							mb.pangles.z := ReadShort(p); {angles}
						if (mask2 and 4) = 4 then
							mb.pvelocity.x := ReadByte(p); {speed}
						if (mask2 and 8) = 8 then
							mb.pvelocity.y := ReadByte(p); {speed}
						if (mask2 and $10) = $10 then
							mb.pvelocity.z := ReadByte(p); {speed}
						if (mask2 and $20) = $20 then
							i := ReadByte(p); {flag}
						if (mask2 and $40) = $40 then
							i := ReadByte(p); {impulse}
						if (mask2 and $80) = $80 then
							i := ReadByte(p); {load}
					end;
					if (mask and 4) = 4 then
						z := ReadCoord(p); {cspeed}
					if (mask and 8) = 8 then
						z := ReadCoord(p); {cspeed}
					if (mask and $10) = $10 then
						z := ReadCoord(p); {cspeed}

					if (mask and $20) = $20 then
						i := ReadByte(p); {playermodel}
					if (mask and $40) = $40 then
						i := ReadByte(p); {uk_byte6..i'm guessing armour}
					if (mask and $80) = $80 then
						mb.weapon := ReadByte(p); {weapon}
					if (mask and $100) = $100 then
						mb.weaponframe := ReadByte(p); {weaponframe}

					c := #0;
				end;
			#$2b: {nails}
				begin
					desc := 'nails';
					obj := nil;
					mask := ReadByte(p);
					p := p + (5 * mask);
					c := #0;
				end;
			#$2C: {choke}
				begin
					desc := 'choke';
					i := ReadByte(p);
					obj := nil;
					c := #0;
				end;
			#$2D: {modellist}
				begin
					desc := 'modellist';
					obj := nil;
					while (1=1) do
					begin
						junk := ReadString(p);
						if junk = '' then
							break;
						ModelList.add(junk);
					end;
					c := #0;
				end;
			#$2E: {soundlist}
				begin
					desc := 'soundlist';
					obj := nil;
					while (1=1) do
					begin
						junk := ReadString(p);
						if junk = '' then
							break;
						SoundList.add(junk);
					end;
					c := #0;
				end;
			#$2F: {packetentities}
				begin
					desc := 'updateentity';
					mask := ReadShort(p);
					while (mask <> 0) do
					begin
						obj := Tupdateentity.create;
						with Tupdateentity(obj) do
						begin
							entity := mask and $1FF;
							mask := mask and $FE00;
							for i := 0 to spawnbaselinelist.count -1 do
							begin
								ue := Tupdateentity(spawnbaselinelist.objects[i]);
								if ue.entity = entity then
									break;
							end;

							if (mask and $8000) = $8000 then
							begin
								mask := mask and ReadByte(p);
							end;

							if (mask and 4) = 4 then
							begin
								modelindex := ReadByte(p);
							end else
								modelindex := ue.modelindex;
							if (mask and $2000) = $2000 then
							begin
								frame := ReadByte(p);
							end else
								frame := ue.frame;

							if (mask and 8) = 8 then
							begin
								colormap := ReadByte(p);
							end else
								colormap := ue.colormap;
							if (mask and $10) = $10 then
							begin
								skin := ReadByte(p);
							end else
								skin := ue.skin;
							if (mask and $20) = $20 then
							begin
								effects := ReadByte(p);
							end else
								effects := ue.effects;
							if ((mask and $200)<>0) then
							begin
								position.x := ReadCoord(p);
							end else
								position.x := ue.position.x;
							if ((mask and $1)<>0) then
							begin
								angle.x := ReadAngle(p);
							end else
								angle.x := ue.angle.x;
							if ((mask and $400)<>0) then
							begin
								position.y := ReadCoord(p);
							end else
								position.y := ue.position.y;
							if ((mask and $1000)<>0) then
							begin
								angle.y := ReadAngle(p);
							end else
								angle.y := ue.angle.y;
							if ((mask and $800)<>0) then
							begin
								position.z := ReadCoord(p);
							end else
								position.z := ue.position.z;
							if ((mask and $2)<>0) then
							begin
								angle.z := ReadAngle(p);
							end else
								angle.z := ue.angle.z;
						end;
						AddMsgToBlock(mb,ord(c),desc,obj);
						mask := ReadShort(p);
					end;
					c := #0;
				end;
			#$30: {deltapacketentities}
				begin
					i := ReadByte(p);
					desc := 'deltaupdateentity';
					mask := ReadShort(p);
					while (mask <> 0) do
					begin
						obj := Tupdateentity.create;
						with Tupdateentity(obj) do
						begin
							entity := mask and $1FF;
							mask := mask and $FE00;
							if (mask and $8000) = $8000 then
							begin
								mask := mask and ReadByte(p);
							end;
							if (mask and 4) = 4 then
							begin
								modelindex := ReadByte(p);
							end;
							if (mask and $2000) = $2000 then
							begin
								frame := ReadByte(p);
							end;
							if (mask and 8) = 8 then
							begin
								colormap := ReadByte(p);
							end;
							if (mask and $10) = $10 then
							begin
								skin := ReadByte(p);
							end;
							if (mask and $20) = $20 then
							begin
								effects := ReadByte(p);
							end;

							if ((mask and $200)<>0) then
							begin
								position.x := ReadCoord(p);
							end;
							if ((mask and $1)<>0) then
							begin
								angle.x := ReadAngle(p);
							end;
							if ((mask and $400)<>0) then
							begin
								position.y := ReadCoord(p);
							end;
							if ((mask and $1000)<>0) then
							begin
								angle.y := ReadAngle(p);
							end;
							if ((mask and $800)<>0) then
							begin
								position.z := ReadCoord(p);
							end;
							if ((mask and $2)<>0) then
							begin
								angle.z := ReadAngle(p);
							end;
						end;
						AddMsgToBlock(mb,ord(c),desc,obj);
						mask := ReadShort(p);

					end;
				end;
				else begin
					desc := 'bad';
					obj := nil;
					exit;
				end;
			end;

		if mb <> nil then
		if c <> #0 then
		begin
			AddMsgToBlock(mb,ord(c),desc,obj);
		end;
			end;
			inc(numblocks);
			SetBlockInArray(mb);
		end;
		end;
	end;
	end;
end;

procedure TDemo1.WriteQWD(filename:string);
var
	i:integer;
begin
end;


end.
