unit Main;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls,Tdemo,Registry;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    SpeedPanel: TPanel;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    StatusBar: TStatusBar;
    SaveDialog1: TSaveDialog;
    test1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure CutItemClick(Sender: TObject);
    procedure CopyItemClick(Sender: TObject);
    procedure PasteItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure test1Click(Sender: TObject);
	procedure PopulateFileHistory;
	procedure FileHistoryClick(Sender:Tobject);
	procedure AddToFileHistory(s:string);

  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string);
    procedure ShowHint(Sender: TObject);
  public
    { Public declarations }
    t:Tdemo1;
  end;

var
  MainForm: TMainForm;
	FileHistory:Tstringlist;
   originalmenuitems :integer;

implementation

{$R *.DFM}

uses ChildWin, About, blocks, qserv;

procedure TMainForm.FormCreate(Sender: TObject);
var
 processhandle:integer;
	r:TRegIniFile;
	m:Tmenuitem;
	i,j:integer;
	junk:string;
begin
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;

	r := TRegIniFile.create('Software\FilmAt11');
   Top := r.ReadInteger('MainWindow','Top',0);
   Left := r.ReadInteger('MainWindow','Left',0);
   Width := r.ReadInteger('MainWindow','Width',200);
   Height := r.ReadInteger('MainWindow','Height',320);
	WindowState := TWindowState(r.ReadInteger('MainWindow','WindowState',0));
	i := r.ReadInteger('FileHistory','Num',0);
	originalmenuitems := MainMenu1.items[0].count;
	FileHistory := Tstringlist.create;
   if i > 0 then
   begin
       for j := 0 to i-1 do
       begin
			junk := r.ReadString('FileHistory',inttostr(j),'');
			FileHistory.add(junk);
		end;
	end;
	r.free;
	PopulateFileHistory;

 processHandle := OpenProcess ($200, False,GetCurrentProcessID);
 try
	SetPriorityClass (processHandle, HIGH_PRIORITY_CLASS);
 finally
	CloseHandle (processHandle)
 end;

end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TMDIChild;
begin
  { create a new MDI child window }
  Child := TMDIChild.Create(Application);
  Child.Caption := Name;
end;

procedure TMainForm.FileNewItemClick(Sender: TObject);
begin
  CreateMDIChild('NONAME' + IntToStr(MDIChildCount + 1));
end;

procedure TMainForm.FileOpenItemClick(Sender: TObject);
var
	i:integer;
	junk:string;
begin
	Opendialog.InitialDir := 'c:\games\quake\id1';
  	if OpenDialog.Execute then
	begin
		T := Tdemo1.create(nil);
 		t.blockarraycount := 100;
   	t.blockarray := allocmem(t.blockarraycount * 4);
       junk := copy(opendialog.filename,length(opendialog.filename)-2,3);
       if uppercase(junk) = 'DEM' then
       	T.ReadDEM(OpenDialog.filename)
       else if uppercase(junk) = 'QWD' then
       	T.ReadQWD(Opendialog.filename)
       else
       	exit;

		   	Statusbar.simpletext := 'Loaded ' + inttostr(T.clientblocks) + 'blocks, ' + inttostr(t.serverblocks) + ' messages';
		Form1.InitQServ(T);
		AddToFileHistory(OpenDialog.filename);
	end;
end;

procedure TMainForm.FileCloseItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

procedure TMainForm.FileSaveItemClick(Sender: TObject);
begin
	if SaveDialog1.execute then
   begin
		T.WriteDEM(SaveDialog1.filename);
   end;
end;

procedure TMainForm.FileSaveAsItemClick(Sender: TObject);
begin
  { save current file under new name }
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.CutItemClick(Sender: TObject);
begin
  {cut selection to clipboard}
end;

procedure TMainForm.CopyItemClick(Sender: TObject);
begin
  {copy selection to clipboard}
end;

procedure TMainForm.PasteItemClick(Sender: TObject);
begin
  {paste from clipboard}
end;

procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.UpdateMenuItems(Sender: TObject);
begin
  FileCloseItem.Enabled := MDIChildCount > 0;
  FileSaveItem.Enabled := MDIChildCount > 0;
  FileSaveAsItem.Enabled := MDIChildCount > 0;
  CutItem.Enabled := MDIChildCount > 0;
  CopyItem.Enabled := MDIChildCount > 0;
  PasteItem.Enabled := MDIChildCount > 0;
  SaveBtn.Enabled := MDIChildCount > 0;
  CutBtn.Enabled := MDIChildCount > 0;
  CopyBtn.Enabled := MDIChildCount > 0;
  PasteBtn.Enabled := MDIChildCount > 0;
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
	r:Treginifile;
   j:integer;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   r.writeInteger('MainWindow','Top',Top);
   r.writeInteger('MainWindow','Left',Left);
   r.writeInteger('MainWindow','Width',Width);
   r.writeInteger('MainWindow','Height',Height);
   r.writeInteger('MainWindow','WindowState',Longint(WindowState));
   if FileHistory.count > 0 then
   begin
		r.writeinteger('FileHistory','Num',FileHistory.count);
       for j := 0 to FileHistory.count -1  do
       begin
  			r.WriteString('FileHistory',inttostr(j),FileHistory[j]);
       end;
   end;

   r.free;
  Screen.OnActiveFormChange := nil;
end;

procedure TMainForm.HelpAboutItemClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainForm.test1Click(Sender: TObject);
begin
	Form1.show;
end;

procedure TMainForm.PopulateFileHistory;
var
	i,j:integer;
   m:Tmenuitem;
begin
	// remove previous filehistory menu items
	while MainMenu1.items[0].count > originalmenuitems do
   	MainMenu1.items[0].delete(MainMenu1.items[0].count-1);

   if FileHistory.count > 0 then
   begin
  		m := Tmenuitem.create(Owner);
  		m.caption := '-';
  		MainMenu1.items[0].add(m);
       for j := 0 to FileHistory.count-1 do
       begin
  			m := Tmenuitem.create(Owner);
  			m.caption := '&' + inttostr(j) + ' ' + FileHistory[j];
			m.OnClick := FileHistoryClick;
  			MainMenu1.items[0].add(m);
       end;
   end;
end;

procedure TMainForm.AddToFileHistory(s:string);
var
	i,j:integer;
   m:Tmenuitem;
label start;
begin
start:
	for i := 0 to FileHistory.count -1 do
   	if FileHistory[i] = s then
       begin
       	FileHistory.delete(i);
           goto start;
       end;

	FileHistory.insert(0,s);
	while FileHistory.count > 10 do
   	FileHistory.delete(FileHistory.count-1);
   PopulateFileHistory;
end;

procedure TMainForm.FileHistoryClick(Sender:Tobject);
var
	f1,f2:string;
   i:integer;
   junk:string;
begin
		f1 := copy(TMenuitem(Sender).caption,pos(' ',TMenuitem(Sender).caption)+1,300);
		T := Tdemo1.create(nil);
 		t.blockarraycount := 100;
   	t.blockarray := allocmem(t.blockarraycount * 4);
       junk := copy(f1,length(f1)-2,3);
       if uppercase(junk) = 'DEM' then
       	T.ReadDEM(f1)
       else if uppercase(junk) = 'QWD' then
       	T.ReadQWD(f1)
       else
       	exit;

   	Statusbar.simpletext := inttostr(t.arraycount) +' Loaded ' + inttostr(T.numblocks) + 'blocks, ' + inttostr(t.serverblocks) + ' messages';
		Form1.InitQServ(T);
		AddToFileHistory(f1);
       Application.title := 'Film At 11 - ' + f1;
//       modified := false;

end;


end.
