#include "g_local.h"
/* _________ *\
**  **
** Nightmare **
** _________ **
\*  */
void nightmareModeSetup (void)
{
	if (nightmareModeState)
	{
		gi.configstring(CS_LIGHTS+0, "a");
		gi.configstring(CS_LIGHTS+1, "a");
		gi.configstring(CS_LIGHTS+2, "a");
		gi.configstring(CS_LIGHTS+3, "a");
		gi.configstring(CS_LIGHTS+4, "a");
		gi.configstring(CS_LIGHTS+5, "a");
		gi.configstring(CS_LIGHTS+6, "a");
		gi.configstring(CS_LIGHTS+7, "a");
		gi.configstring(CS_LIGHTS+8, "a");
		gi.configstring(CS_LIGHTS+9, "a");
		gi.configstring(CS_LIGHTS+10, "a");
		gi.configstring(CS_LIGHTS+11, "a");
		gi.configstring(CS_LIGHTS+63, "z");
	}
	else
	{
		gi.configstring(CS_LIGHTS+0, "m");
		gi.configstring(CS_LIGHTS+1, "mmnmmommommnonmmonqnmmo");
		gi.configstring(CS_LIGHTS+2, "abcdefghijklmnopqrstuvwxyzyxwvutsrqponmlkjihgfedcba");
		gi.configstring(CS_LIGHTS+3, "mmmmmaaaaammmmmaaaaaabcdefgabcdefg");
		gi.configstring(CS_LIGHTS+4, "mamamamamama");
		gi.configstring(CS_LIGHTS+5, "jklmnopqrstuvwxyzyxwvutsrqponmlkj");
		gi.configstring(CS_LIGHTS+6, "nmonqnmomnmomomno");
		gi.configstring(CS_LIGHTS+7, "mmmaaaabcdefgmmmmaaaammmaamm");
		gi.configstring(CS_LIGHTS+8, "mmmaaammmaaammmabcdefaaaammmmabcdefmmmaaaa");
		gi.configstring(CS_LIGHTS+9, "aaaaaaaazzzzzzzz");
		gi.configstring(CS_LIGHTS+10, "mmamammmmammamamaaamammma");
		gi.configstring(CS_LIGHTS+11, "abcdefghijklmnopqrrqponmlkjihgfedcba");
		gi.configstring(CS_LIGHTS+63, "a");
	}
	nightmareToggleTime = level.time;
}
void nightmareResetFlashlight (edict_t *self)
{
	if (self->owner->client && self->owner->client->flashlight)
	{
		float volume = 1.0;

		if (self->owner->client->silencer_shots)
			volume = 0.2;
		gi.sound(self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("misc/lasfly.wav"), volume, ATTN_NORM, 0);
		self->owner->client->flashlight = NULL;
	}
	G_FreeEdict(self);
}
void flashlight_think (edict_t *self)
{
	vec3_t	forward, right, up, offset, start, end;
	trace_t	tr;

	if (!nightmare->value || level.intermissiontime || !self->owner->inuse)
	{
		nightmareResetFlashlight(self);
		return;
	}
	AngleVectors(self->owner->client->v_angle, forward, right, up);
	VectorSet(offset, 0, 8, self->owner->viewheight-8);
	G_ProjectSource(self->owner->s.origin, offset, forward, right, start);
	VectorMA(start, 8192, forward, end);
	tr = gi.trace(start, NULL, NULL, end, self->owner, MASK_SHOT);
	if (!((tr.surface) && (tr.surface->flags & SURF_SKY)) && tr.fraction < 1.0)
		self->svflags &= ~SVF_NOCLIENT;
	else
		self->svflags |= SVF_NOCLIENT;
	vectoangles(tr.plane.normal, self->s.angles);
	VectorCopy(tr.endpos, self->s.origin);
	self->nextthink = level.time+NIGHTMARE_THINK;
	self->s.renderfx = (RF_SHELL_RED|RF_SHELL_GREEN|RF_SHELL_BLUE);
	if (abs(nightmare->value) > 1)
	{
		self->s.renderfx = RF_SHELL_GREEN;
#ifdef IT_TECH
		switch (self->owner->client->resp.ctf_team)
		{
		case CTF_TEAM1:
			self->s.renderfx = RF_SHELL_RED;
			break;
		case CTF_TEAM2:
			self->s.renderfx = RF_SHELL_BLUE;
			break;
		}
#endif
	}
	gi.linkentity(self);
}
void Use_Laser (edict_t *player)
{
	if (player->client->flashlight)
		nightmareResetFlashlight(player->client->flashlight);
	else
	{
		float volume = 1.0;

		if (player->client->silencer_shots)
			volume = 0.2;
		gi.sound(player, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("misc/lasfly.wav"), volume, ATTN_NORM, 0);
		player->client->flashlight = G_Spawn();
		VectorCopy(player->s.origin, player->client->flashlight->s.origin);
		player->client->flashlight->movetype = MOVETYPE_NOCLIP;
		player->client->flashlight->clipmask = MASK_SHOT;
		player->client->flashlight->solid = SOLID_NOT;
		player->client->flashlight->s.effects = EF_BFG;
		player->client->flashlight->s.modelindex = gi.modelindex("models/objects/gibs/sm_meat/tris.md2");
		player->client->flashlight->owner = player;
		player->client->flashlight->nextthink = level.time+NIGHTMARE_THINK;
		player->client->flashlight->think = flashlight_think;
		player->client->flashlight->classname = "flashlight";
		player->client->flashlight->svflags = SVF_NOCLIENT;
	}
}
void nightmareCheckRules (void)
{
	if (nightmareModeState && (!nightmare->value || level.intermissiontime))
		nightmareModeState = false;
	else if (nightmare->value && !nightmareModeState && lighttime->value > 0 && level.time >= nightmareToggleTime+lighttime->value*60)
		nightmareModeState = true;
	else if (nightmareModeState && nighttime->value > 0 && level.time >= nightmareToggleTime+nighttime->value*60)
		nightmareModeState = false;
	else
		return;
	nightmareModeSetup();
}
void nightmareModeToggle (qboolean cmd)
{
	if (cmd)
	{
		if (gi.argc() > 2 && atoi(gi.argv(2)))
		{
			gi.cvar_forceset("nightmare", gi.argv(2));
			gi.bprintf(PRINT_HIGH, "Nightmare mode TOGGLE\n");
		}
		else if (nightmare->value)
		{
			gi.cvar_forceset("nightmare", "0");
			gi.bprintf(PRINT_HIGH, "Nightmare mode OFF\n");
		}
		else
		{
			gi.cvar_forceset("nightmare", "1");
			gi.bprintf(PRINT_HIGH, "Nightmare mode ON\n");
		}
	}
	else
	{
		nightmare = gi.cvar("nightmare", "0", CVAR_SERVERINFO|CVAR_LATCH);
		nighttime = gi.cvar("nighttime", "0", 0);
		lighttime = gi.cvar("lighttime", "0", 0);
	}
	if (nightmare->value > 0)
		nightmareModeState = true;
	else
		nightmareModeState = false;
	nightmareModeSetup();
}
void nightmarePlayerResetFlashlight (edict_t *player)
{
	if (player->client->flashlight)
		nightmareResetFlashlight(player->client->flashlight);
}
void nightmareClientGiveFlashlight (gclient_t *client)
{
	if (nightmare->value)
	{
		gitem_t *item;

		item = FindItem("Flashlight");
		client->pers.selected_item = ITEM_INDEX(item);
		client->pers.inventory[client->pers.selected_item] = 1;
	}
}
void nightmareEffects (edict_t *player)
{
	if (player->client->flashlight && !((player->s.effects & EF_FLAG1) || (player->s.effects & EF_FLAG2)))
	{
		player->s.effects |= (EF_FLAG1|EF_FLAG2);
#ifdef IT_TECH
		switch (player->client->resp.ctf_team)
		{
		case CTF_TEAM1:
			player->s.effects &= ~EF_FLAG2;
			break;
		case CTF_TEAM2:
			player->s.effects &= ~EF_FLAG1;
			break;
		}
#endif
	}
}
//Nightmare
