/* Aftershock 3D rendering engine
 * Copyright (C) 1999 Stephen C. Taylor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __RENDER_H__
#define __RENDER_H__

extern vec3_t r_eyepos;      /* World coords */
extern vec3_t r_eyedir;      /* Camera direction unit vector */
extern float r_eye_az, r_eye_el;  /* eyedir azimuth and elevation (deg) */
extern float r_eyefov;       /* Field of view angle (deg) */
extern int r_eyecluster;     /* Current PVS cluster */
extern int r_lockpvs;        /* Enable to lock PVS cluster */
extern double g_frametime;   /* Current time */

void render_init(void);
void render_finalize(void);
void render_scene();

#endif /*__RENDER_H__*/
