/* Aftershock 3D rendering engine
 * Copyright (C) 1999 Stephen C. Taylor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "util.h"
#include "bsp.h"
#include "lightmap.h"
#include "tex.h"
#include "glinc.h"

void
lightmap_loadobjs(void)
{
    int i, texsize = (128*128*3);
    
    r_numlightmaptex = r_lightmapsize / texsize;
    r_lightmaptex = malloc(r_numlightmaptex * sizeof(uint_t));
    glGenTextures(r_numlightmaptex, r_lightmaptex);
    
    for (i=0; i < r_numlightmaptex; ++i)
    {
	if (r_gamma > 1.0)
	{
	    int j, val;
	    byte_t *c;

	    c = &r_lightmapdata[i * texsize];
	    for (j=0; j < texsize; j++, c++)
	    {
		val = *c * r_gamma;
		if (val > 255) val = 255;
		*c = val;
	    }
	}
	
	glBindTexture(GL_TEXTURE_2D, r_lightmaptex[i]);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 128, 128, 0, GL_RGB,
		     GL_UNSIGNED_BYTE, &r_lightmapdata[i * texsize]);
    }

    /* We don't need this data any more */
    free(r_lightmapdata);
}

void
lightmap_freeobjs(void)
{
    glDeleteTextures(r_numlightmaptex, r_lightmaptex);
    free(r_lightmaptex);
}
