--- v101qc/items.qc	Thu Jul 25 01:51:23 1996
+++ rdi/items.qc	Mon Oct 14 08:02:19 1996
@@ -2,9 +2,36 @@
 /* ALL LIGHTS SHOULD BE 0 1 0 IN COLOR ALL OTHER ITEMS SHOULD
 BE .8 .3 .4 IN COLOR */
 
+entity item_to_exchange;
+void(float exchange) SUB_Withdraw = {
+	local vector temp;
+
+	if(exchange) {
+		if(item_to_exchange) {
+//			dprint(self.classname);
+//			dprint(" moved from ");
+//			dprint(vtos(self.origin));
+//			dprint(" to ");
+//			dprint(vtos(spare_item_origin));
+//			dprint("\n");
+			temp=self.origin;
+			self.origin=item_to_exchange.origin;
+			item_to_exchange.origin=temp;
+			item_to_exchange=world;
+		} else {
+			item_to_exchange=self;
+		}
+	}
+
+	self.model = string_null;
+	self.solid = SOLID_NOT;
+};
 
 void() SUB_regen =
 {
+	if(item_to_exchange == self) { // Didn't get exchanged
+		item_to_exchange = world;
+	}
 	self.model = self.mdl;		// restore original model
 	self.solid = SOLID_TRIGGER;	// allow it to be touched again
 	sound (self, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);	// play respawn sound
@@ -178,8 +205,7 @@
 
 	stuffcmd (other, "bf\n");
 	
-	self.model = string_null;
-	self.solid = SOLID_NOT;
+	SUB_Withdraw(1);
 
 	// Megahealth = rot down the player's super health
 	if (self.healtype == 2)
@@ -269,8 +295,7 @@
 	other.armorvalue = value;
 	other.items = other.items - (other.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + bit;
 
-	self.solid = SOLID_NOT;
-	self.model = string_null;
+	SUB_Withdraw(1);
 	if (deathmatch == 1)
 		self.nextthink = time + 20;
 	self.think = SUB_regen;
@@ -489,8 +514,8 @@
 		return;
 
 // remove it in single player, or setup for respawning in deathmatch
-	self.model = string_null;
-	self.solid = SOLID_NOT;
+	
+	SUB_Withdraw(1);
 	if (deathmatch == 1)
 		self.nextthink = time + 30;
 	self.think = SUB_regen;
@@ -670,8 +695,8 @@
 	self = stemp;
 
 // remove it in single player, or setup for respawning in deathmatch
-	self.model = string_null;
-	self.solid = SOLID_NOT;
+
+	SUB_Withdraw(1);
 	if (deathmatch == 1)
 		self.nextthink = time + 30;
 	
@@ -889,8 +914,7 @@
 
 	if (!coop)
 	{	
-		self.solid = SOLID_NOT;
-		self.model = string_null;
+		SUB_Withdraw(1);
 	}
 
 	activator = other;
@@ -1017,8 +1041,7 @@
 
 	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
-	self.solid = SOLID_NOT;
-	self.model = string_null;
+	SUB_Withdraw(1);
 	serverflags = serverflags | (self.spawnflags & 15);
 	self.classname = "";		// so rune doors won't find it
 	
@@ -1105,33 +1128,35 @@
 
 	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
-	self.solid = SOLID_NOT;
 	other.items = other.items | self.items;
-	self.model = string_null;
 
 // do the apropriate action
 	if (self.classname == "item_artifact_envirosuit")
 	{
 		other.rad_time = 1;
 		other.radsuit_finished = time + 30;
+		SUB_Withdraw(0); // Leave envirosuit, it's there for a reason
 	}
 	
 	if (self.classname == "item_artifact_invulnerability")
 	{
 		other.invincible_time = 1;
 		other.invincible_finished = time + 30;
+		SUB_Withdraw(1);
 	}
 	
 	if (self.classname == "item_artifact_invisibility")
 	{
 		other.invisible_time = 1;
 		other.invisible_finished = time + 30;
+		SUB_Withdraw(1);
 	}
 
 	if (self.classname == "item_artifact_super_damage")
 	{
 		other.super_time = 1;
 		other.super_damage_finished = time + 30;
+		SUB_Withdraw(1);
 	}	
 
 	activator = other;
--- v101qc/world.qc	Thu Jul 25 01:51:24 1996
+++ rdi/world.qc	Mon Oct 14 08:02:37 1996
@@ -173,6 +173,7 @@
 {
 	lastspawn = world;
 	InitBodyQue ();
+	item_to_exchange = world;
 
 // custom map attributes
 	if (self.model == "maps/e1m8.bsp")
@@ -180,6 +181,7 @@
 	else
 		cvar_set ("sv_gravity", "800");
 
+	
 // the area based ambient sounds MUST be the first precache_sounds
 
 // player precaches	
