/* *********************************************************************

	xutils.c	XLib Utility Functions
	--------------------------------------
	Functions:
	int XuGetFontInfo(XFontStruct **xfont_info, char *xfontname)
	unsigned long XuGetColor(char *spec, XColor xcolor_in)
	int XuDFrameWindow(Window w, int width, int height,
		unsigned long highlight, unsigned long shadow)
	void XuTranslateWindow(Window w, int x_rec, int y_rec)

	---

	XuGetFontInfo() convience function to get xfont info.

	XuGetColor() convience function to set a xcolor and
	get its pixel number.

	XuDFrameWindow() frames a window, adds depressed style
	shading.

	XuTranslateWindow() convience function to move a
	window.


	---

	Note: Global variables such Display *display need to be
	initialized before you can used any of these functions.
	These functions are not intended to be portable, please
	consult author.


********************************************************************* */

#include "xjscal.h"



/* *********************************************************************
 *
 *     int XuGetFontInfo(XFontStruct **xfont_info, char *xfontname)
 *
 *   Gets font information for givin font, make sure you pass
 * XFontStruct **font_info argument as an address, char *fontname
 * would be the name of the font.
 *
 * Returns:
 *	-1 for error loading xfont.
 *       0 for xfont not found, default used.
 *       1 for xfont found and used.
 *
 * Example:
 *	XuGetFontInfo(&my_xfont,"8x16");
 *
 */
int XuGetFontInfo(XFontStruct **xfont_info, char *xfontname)
{

        /* Attempt to get the font. */
        if( (*xfont_info = XLoadQueryFont(display,xfontname)) == NULL )
        {
                fprintf(stderr,
                        "Can't find the font named \"%s\".\n",
                	xfontname
		);
		fprintf(stderr, "Using \"7x14\" instead.\n");
                xfontname="7x14";
                *xfont_info = XLoadQueryFont(display,xfontname);
		return(0);
        }
	else
	{
		return(1);
	}
}



/* *********************************************************************
 *
 *       unsigned long XuGetColor(char *spec, XColor **xcolor_in)
 *
 * Allocates and returns a pixel value for a givin color string
 * char *spec to parse.
 *
 * Returns the pixel value of the color.
 *
 * Example:
 *
 *	XuGetColor("rgbi:1.0/0.0/0.0", my_xcolor)
 *
 * Note that my_xcolor will be modified in this function.
 *
 */
unsigned long XuGetColor(char *spec, XColor xcolor_in)
{
	/* Local variables. */
	unsigned long rtn_xcolor;


	/* Parse spec to get the xcolor_in. */
	if(
           (XParseColor(display, colormap, spec, &xcolor_in))
        ==
           BadColor
	)
	{
		fprintf(stderr,"Badcolor, \"%s\"\n",spec);
	}

	/* Allocate color_in. */
	XAllocColor(display, colormap, &xcolor_in);

	/* Get the pixel of the allocated color_in. */
	rtn_xcolor = xcolor_in.pixel;

	/* Return the pixel. */
	return(rtn_xcolor);
}



/* **********************************************************************
 *
 *      int XuDFrameWindow(w, width, height, highlight, shadow)
 *
 *   Creates a depressed frame around Window w.   width and height
 *   must be the width and height of the Window w.
 *   hightlight and shadow are pixels.
 *
 *   Notes:
 *      Window w will *not* be cleared by this function,
 *      XClearWindow() should be called prior to this function call.
 *
 *      This function also calls XSetForeground(), so your foreground
 *      color will be changed.
 *
 *      Window w should have a border width of 0.
 *
 *   Returns -1 on error.
 *
 */
int XuDFrameWindow(
	Window w,
	int width,
	int height,
        unsigned long highlight,
	unsigned long shadow
)
{
	/* Draw top frame. */
	XSetForeground(display, the_GC, shadow);
	XDrawLine(display, w, the_GC,
		0, 0,
		width - 1, 0
	);

	/* Draw right frame. */
	XSetForeground(display, the_GC, highlight);
	XDrawLine(display, w, the_GC,
                width - 1, 0,
                width - 1, height - 1
        );

        /* Draw bottom frame. */
        XSetForeground(display, the_GC, highlight);
        XDrawLine(display, w, the_GC, 
                0, height - 1,
                width - 1, height - 1
        );
 
        /* Draw right frame. */
        XSetForeground(display, the_GC, shadow);
        XDrawLine(display, w, the_GC,
                0, 0,
                0, height - 1
        );


	return(0);
}



/* *******************************************************************
 *
 *     void XuTranslateWindow(Window w, int x_rec, int y_rec)
 *
 *   x_rec and y_rec are the original positions recorded relative
 *   to child window w when the button was pressed.
 *
 */
void XuTranslateWindow(Window w, int x_rec, int y_rec)
{
	/* Local variables. */
        Window root_return, child_return;
        int root_x_return, root_y_return;
        int win_x_return, win_y_return;
        unsigned int mask_return;

        int new_x, new_y;               /* Rel to root window. */


	new_x = 0;
	new_y = 0;

	/* Fetch current pointer coordinates. */
	XQueryPointer(
		display, w,
		&root_return, &child_return,
		&root_x_return, &root_y_return,
		&win_x_return, &win_y_return,
		&mask_return
	);


	/* Calculate new_x and new_y positions. */
	new_x = root_x_return - x_rec;
	new_y = root_y_return - y_rec;


	XMoveWindow(display, w, new_x, new_y);

	return;
}
