/* *********************************************************************

	timming.c	Timming Functions
	---------------------------------
	Functions:

	long MilliTime(void)

	---

	MilliTime() returns the milliseconds since midnight.
	Coded by Calle Kash (calle@kash.se).


	---

	Copyright (C) 1995, 1996 Calle Karlsson (calle@kash.se)
	This software is in the public domain.



********************************************************************* */

#include "xjscal.h"



/* *********************************************************************
 *
 *   long MilliTime(void)
 *
 *	Returns milliseconds since midnight.
 *	NOTE: There is an obvious flaw in this function which occures
 *	when the previous time obtained was just before midnight and
 *	the next time obtained was just after midnight (the next day).
 *
 */
long MilliTime(void)
{
   struct timeval tv[1];

   if (gettimeofday(tv, NULL) < 0)
   {    
      perror("gettimeofday");
      exit(1);
   }
 
   return((tv->tv_sec % 86400) * 1000 + tv->tv_usec / 1000);
}
