/* **************************************************************************
 * 
 *      joystick.c        Joystick Handling Functions
 *      ---------------------------------------------
 *      Functions:
 *
 *      int JSOpenDevice(char *js_device_to_open)
 *      int JSReadCaliberationFile(char *calibfilename)
 *	int JSWriteCaliberationFile(char *calibfilename)
 *
 *      ---
 *
 *
 *
 *
 * 
 */
   
#include "xjscal.h"



/* **********************************************************************
 *
 *   int JSOpenDevice(char *js_device_to_open)
 *
 *      Opens joystick device js_device_to_open.   Setting global
 *      cur_js_fd to the newly opened joystick's file descriptor.
 *
 *      If the a joystick device is already opened, then the cur_js_fd
 *      should be closed first!!! 
 *
 *      Returns non-zero on error.
 */

int JSOpenDevice(char *js_device_to_open)
{  
        /* Open the joystick device. */
        cur_js_fd = open(js_device_to_open, O_RDONLY);

        /* Check for errors. */
        if(cur_js_fd < 0)
           return(-1);
        else
           return(0);
} 



int JSReadCaliberationFile(char *calibfilename)
{
	/* Local variables. */
	int x, y, z;
        char stringa[256];
        char *strptr;
        FILE *fp;
        char *filebuf;
        off_t filesize;
        struct stat statbuf;
        int lines_read = 0;
	int js_num = 0;
	int joysticks_read = 0;


        /* Does the joystick configuration file exist? */
        if(access(calibfilename,F_OK) != 0)
        {
                fprintf(stderr,
                    "Warning: Cannot find yoystick calibration file: %s\n",
                    calibfilename
                );
                return(-1);
        }


        /* Open the file. */
        fp=fopen(calibfilename,"r");
        if(fp == NULL)
        {
                fprintf(stderr, "Warning: Unable to open file: %s\n",
                        calibfilename
                );
                return(-1);   
        }


        /* Get statistics and stuff about the file. */
        fstat(fileno(fp), &statbuf);    /* Get stats on file. */
        filesize = statbuf.st_size;     /* Get size of file. */
        
        /* Allocate memory. */
        filebuf = malloc(filesize * sizeof(char) + 1);


        /* Begin reading each line. */
        while(fgets(filebuf,256,fp) != NULL)
        {
           lines_read++;

           /* Skip comments. */
           if(strstr(filebuf,"#") != NULL)
               continue;
 
           /* Skip short lines. */
           if(strlen(filebuf) < 4)
               continue;

           /* Remove newlines characters. */
           while(1)
           {
              strptr = strchr(filebuf,'\n');
              if(strptr == NULL)
                 break; 
              else  
                 *strptr='\0';
           }

	   /* BeginJoystick */
           if(strstr(filebuf, "BeginJoystick") != NULL)
           {
		if(strstr(filebuf, "BeginJoystick1"))
			js_num = 0;
                else if(strstr(filebuf, "BeginJoystick2"))
                        js_num = 1;
                else if(strstr(filebuf, "BeginJoystick3"))
                        js_num = 2;
                else if(strstr(filebuf, "BeginJoystick4"))
                        js_num = 3;
                else
                        js_num = 0;

		while(fgets(filebuf,256,fp) != NULL)
                {   
                     lines_read++;
 
                     /* Skip comments. */
                     if(strstr(filebuf,"#") != NULL)
                        continue;
                 
                     /* Skip short lines. */
                     if(strlen(filebuf) < 4)
                        continue;
         
                     /* Remove newlines characters. */
                     while(1)
                     {
                        strptr = strchr(filebuf,'\n');
                        if(strptr == NULL)
                           break;
                        else
                           *strptr='\0';
                     }
 
                     /* X_Min */
                     if(strstr(filebuf, "X_Min") != NULL)
                     {
                        sscanf(filebuf,"%s %s %i",
                            &stringa,
                            &stringa,
                            &js_caliberation_record[js_num].x_min
                        );
                        continue;
                     }

                     /* Y_Min */
                     else if(strstr(filebuf, "Y_Min") != NULL)
                     {
                        sscanf(filebuf,"%s %s %i",
                            &stringa,
                            &stringa,
                            &js_caliberation_record[js_num].y_min
                        );
                        continue;
                     }

                     /* X_Max */   
                     else if(strstr(filebuf, "X_Max") != NULL)
                     {
                        sscanf(filebuf,"%s %s %i",
                            &stringa,
                            &stringa,
                            &js_caliberation_record[js_num].x_max
                        );
                        continue;
                     }

                     /* Y_Max */
                     else if(strstr(filebuf, "Y_Max") != NULL)
                     {
                        sscanf(filebuf,"%s %s %i",
                            &stringa,
                            &stringa,
                            &js_caliberation_record[js_num].y_max
                        );
                        continue;
                     }

                     /* NullZone */
                     else if(strstr(filebuf, "NullZone") != NULL)
                     {
                        sscanf(filebuf,"%s %s %i",
                            &stringa,
                            &stringa,
                            &js_caliberation_record[js_num].nullzone
                        );
                        continue;
                     }

                     /* EndJoystick */
                     else if(strstr(filebuf, "EndJoystick") != NULL)
                     {
			joysticks_read++;
			break;
                     }
		}
	    }
	}


        /* Free filebuf and fclose fp. */
        free(filebuf);
        fclose(fp);

	return(joysticks_read);
}



int JSWriteCaliberationFile(char *calibfilename)
{
        /* Local variables. */
        char stringa[256];
        FILE *fp;
        char *filebuf;
        char *strptr;
	int js_num;

        long bytes_written = 0;


        /* Open dbfilename for writing, overwrites existing one. */
        fp = fopen(calibfilename,"w");
        if(fp == NULL)
        {
                fprintf(stderr, "Unable to create file: %s\n",
                        calibfilename
                );
                return(-1);
        }


        /* ************************************************ */
        /* ***               Write Header               *** */
        sprintf(stringa,
"# Joystick Caliberation File\n#\n"
	);
        bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);

        sprintf(stringa,
"#      Contains the caliberation information for your joysticks.\n#\n"
        );
        bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);

        sprintf(stringa,
"#      Created by %s Version %s.\n#\n",
		XJSCAL_NAME, XJSCAL_VERSION
	);
        bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);


        /* ******************************************************** */
        /* ***   Begin Writing Joysticks Caliberation to File   *** */
	for(js_num = 0; js_num < MAX_JOYSTICKS; js_num++)
	{

           /* Comment */
           sprintf(stringa, "\n# Joystick %i.\n", (js_num + 1) );
           bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);

           /* BeginJoystick# */
           sprintf(stringa, "BeginJoystick%i\n", (js_num + 1) );
           bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);

           /* X_Min */
           sprintf(stringa, "   X_Min = %i\n",
                js_caliberation_record[js_num].x_min);
           bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);

           /* Y_Min */
           sprintf(stringa, "   Y_Min = %i\n",
                js_caliberation_record[js_num].y_min);
           bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);

           /* X_Max */
           sprintf(stringa, "   X_Max = %i\n",
                js_caliberation_record[js_num].x_max);
           bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);

           /* Y_Max */
           sprintf(stringa, "   Y_Max = %i\n",
                js_caliberation_record[js_num].y_max);
           bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);

           /* NullZone */
           sprintf(stringa, "   NullZone = %i\n",
                js_caliberation_record[js_num].nullzone);
           bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);

           /* EndJoystick# */
           sprintf(stringa, "EndJoystick%i\n", (js_num + 1) );
           bytes_written += fwrite(stringa,sizeof(char),strlen(stringa),fp);
	}


	/* Close the file. */
        fclose(fp);

	return(0);
}
