/* **********************************************************************
 *
 *	timming.c	Timming Functions
 *	---------------------------------
 *	Functions:
 *
 *	long MilliTime(void)
 *	long UTime(void)
 *
 *	---
 *
 *	MilliTime() returns the number of milliseconds since midnight.
 *
 *	UTime() returns number of microseconds from timeval's
 *	calculation from last gettimeofday().
 *
 *
 */

#include "../include/swserv.h"



long MilliTime(void)
{
   struct timeval tv[1];

   if (gettimeofday(tv, NULL) < 0)
   {    
      perror("gettimeofday");
      exit(1);
   }
 
   return((tv->tv_sec % 86400) * 1000 + tv->tv_usec / 1000);
}



long UTime(void)
{
	/* Local variables. */
        struct timeval tv[1];
        

        if(gettimeofday(tv, NULL) < 0)
        {
                perror("gettimeofday");
                exit(1);
        }


	return(tv->tv_usec);
}
