/* ***************************************************************************
 *
 *	swserv.h	ShipWars Server Definations
 *	-------------------------------------------
 *
 */


#ifndef __SWSERV_H__
#define __SWSERV_H__


#include <stdio.h> 
#include <unistd.h>
#include <stdlib.h> 
#include <errno.h> 
#include <string.h> 
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <unistd.h>
#include <fcntl.h>
#include <waitflags.h>
#include <sys/time.h>
#include <sys/signal.h>
#include <sys/types.h>


/* Local header files. */
#include "objects.h"
#include "netcodes.h"
#include "reality.h"


/* ****************************************************************************
 *
 *                        USER EDITABLE DEFINATIONS
 *
 *   You may edit these definations, read the comments carefully, so you know
 *   which settings you must edit and which to leave alone.
 */

/*
 *   Directories:
 *
 *	Directories used by swserv.
 *	These directories may be modified in SWSERV_RC_FILE
 *	(see farther below).
 */
#define SWSERV_HOME_DIR   "/home/swserv"
#define SWSERV_ETC_DIR    "/home/swserv/etc"
#define SWSERV_LOGS_DIR   "/home/swserv/logs"
#define SWSERV_BIN_DIR    "/home/swserv/bin"
#define SWSERV_DB_DIR     "/home/swserv/db"
#define ETC_DIR           "/etc"


/*
 *   Default Port:
 *
 *	This can be changed in SWSERV_RC_FILE.
 */
#define DEFAULT_PORT 1701


/*
 *   Maximum Connections:
 */
#define MAX_CONNECTIONS 100


/*
 *   Login Timeout:
 *
 *	If a socket is connected, but hasn't logged in within this many
 *	seconds, the socket will be disconnected.
 */
#define LOGIN_TIMEOUT 30


/*
 *   Maximum Bad Logins:
 *
 *	If a socket is connected, but hasn't logged in, and sent more than
 *	this many bad logins (incorrect name or password) then the socket
 *	will be disconnected.
 */
#define MAX_BAD_LOGINS 5

/*
 *   Object Update Send Interval:
 *
 *	In milliseconds. This is how often object updates are sent
 *	to a connection. Each connection has its own interval setting
 *	must be within these minimum and maximum values.
 *
 *	WARNING: If the minimum interval is set too low, players may set
 *	their minimums to this value which will cause the bandwidth to
 *	choke! Keep the setting above 50 milliseconds.
 *	1000 milliseconds is the lowest for modem players.
 */
#define MIN_OBJECT_UPDATE_INTERVAL 50
#define MAX_OBJECT_UPDATE_INTERVAL 5000
#define DEFAULT_UPDATE_INTERVAL 1000


/*
 *   Maximum Items Buffered for Each Connection:
 */
#define MAX_CON_BUF_ITEMS 100


/* 
 *   RC File:
 *
 *	Name (not including path) for the configuration file.
 *	This is the very first file swserv looks for, it *MUST* exist!
 *	It will searched for in the following order:
 *	   Current working directory.
 *	   SWSERV_ETC_DIR directory.
 *	   ETC_DIR global directory.
 *
 *	If this file is not found, swserv will not run.
 */
#define SWSERV_RC_FILE "swserv.conf"


/*
 *   Primary Log:
 *
 *	Major events get logged into this file. This file is located in the
 *	SWSERV_LOGS_DIR directory. The name can be changed in the SWSERV_RC_FILE
 *	file.
 */
#define PRIMARY_LOG_FILENAME "swserv.log"          


/*
 *   Database Files:
 *
 *	These are the default database filenames names when none is specified
 *	from the command line.   You should, however, always specify a database
 *	file from the command line for good practice.
 */
#define DEFAULT_DB_IN_FILE    "generic_in.db"
#define DEFAULT_DB_OUT_FILE   "generic_out.db"


/*
 *   Permission Access Levels:
 *
 *	Minimum permission level to access a function.   Values less or equal
 *	will be granted access.  Permission level 0 is always unrestricted.
 *
 *	Each XSW Object has a permission setting and a group setting.
 *	These settings apply to permission settings only, not group settings.
 *
 *	Highest access level is 0, lowest level is DEFAULT_UID which is
 *	usually #define'ed as 5.
 */
#define ACCESS_UID_SET 3		/* Set owned objects only. */
#define ACCESS_UID_SET_OTHER 1		/* Set any object. */

#define ACCESS_UID_SHUTDOWN 0
#define ACCESS_UID_SAVE 1
#define ACCESS_UID_BOOT 1
#define ACCESS_UID_SYNCTIME 1

#define ACCESS_UID_SETPASS 5		/* Everyone should be able to */
					/* set their own password.    */
#define ACCESS_UID_CREATEOBJ 1
#define ACCESS_UID_RECYCLEOBJ 1
#define ACCESS_UID_CREATEPLAYER 1

#define ACCESS_UID_EXAMINE 4
#define ACCESS_UID_EXAMINE_OTHER 3



/*
 * *********************************************************************
 * *********************************************************************
 * ***      THERE IS NO NEED FOR USER EDITING BELOW THIS LINE        ***
 * *********************************************************************
 * *********************************************************************
 */

/*
 *   Master name and version strings:
 */
#define SWSERV_NAME "ShipWars Server"
#define SWSERV_VERSION "0.17"

   
/*
 *   Copyright information:
 */
#define SWSERV_COPYRIGHT \
"Copyright (C) 1997, 1998 Taura (learfox@hotmail.com)\n\
This is a developer's edition and is not publically distributed.\n\
Permission is NOT granted to distribute, use, modify, or copy this\n\
program.\n"



/*
 *   Main Loop Interval:
 *
 *	In microseconds (1000000 microseconds = 1 second).
 *
 *	WARNING: Changing MAIN_LOOP_INTERVAL value will change results from
 *	velocity, acceleration, and other such calculations.
 *	Default is 1000.
 *
 *	MAIN_LOOP_CATCHUP is the interval to sleep whenever a loop cycle took
 *	longer than MAIN_LOOP_INTERVAL microseconds to complete.
 */
#define MAIN_LOOP_INTERVAL 16000
#define MAIN_LOOP_CATCHUP  14000


/*
 *   Default Update Intervals:
 *
 *	In milliseconds (1000 milliseconds = 1 second).
 *
 */
#define DEFAULT_OBJVAL_UPDATE_INTERVAL 3000
#define DEFAULT_WEAPONS_UPDATE_INTERVAL 10000


/*
 *   Timming Intervals:
 *
 *	In milliseconds (1000 milliseconds = 1 second).
 */
#define MEMORY_CLEAN_INTERVAL      20000
#define SOCKET_POLL_INTERVAL       3000


/*
 *   Listening Socket Backlog
 */
#define LISTEN_SOCKET_BACKLOG 10


/*
 *   Maximum Hostname Length:
 */
#ifndef MAX_HOSTNAME_LENGTH
   #define MAX_HOSTNAME_LENGTH 256
#endif


/* **********************************************************************
 *
 *                         GLOBAL VARIABLES
 *
 */

/*
 *   Process handling:
 *
 *	Note the rootpid is the PID of the main xpppcon process,
 *	the process that started it all.   childpid can change
 *	during execution, it will contain and child processes'
 *      PID.
 */
pid_t rootpid;
pid_t childpid;
int child_procs;


/*
 *   Up Time:
 *
 *	The systime in seconds the server was started at.
 *	time(NULL) - uptime will give you the time in seconds the
 *	server has been running.
 */
long uptime;


/* 
 *   Runlevel:
 *
 *	Indicates the runlevel code.
 *	runlevel 0 = shutdown and should be terminated.
 *	runlevel 1 = initializing (starting up).
 *	runlevel 2 = stable and under normal operations.
 *
 *	The main loop in main() tests the runlevel code, when the runlevel
 *	becomes 0 or less, it exits.
 */
int runlevel;


/*
 *   Current MilliTime:
 *
 *	Contains the number of milliseconds since midnight.
 *	The contents of this variable are updated in main() with
 *	a call to MilliTime().
 */
long cur_millitime;


/*
 *   Last Update Records:
 *
 *	Keeps track of last updated times, in milliseconds.
 *
 */
long objval_update_last;
long weapons_update_last;
long memory_clean_last;
long socket_poll_last;
 

/*
 *   Update Intervals:
 *
 *	These contain adjustable values for various main loop
 *	update intervals, in milliseconds.
 */
long objval_update_interval;
long weapons_update_interval;



/*
 *   Listening Port:
 */
int listening_port;
int uset_listening_port;	/* 0 = not set, 1 = set. */


/*
 *   Directories and Full Path Names:
 *
 *	These are various global variables for the locations of directories
 *	and files used by this program.
 */
char swserv_home_dir[1024];
char swserv_etc_dir[1024];
char swserv_logs_dir[1024];
char swserv_bin_dir[1024];
char swserv_db_dir[1024];

char swserv_rc_fullname[1024];

char db_in_fullname[1024];
int uset_db_in_fullname;        /* 0 = not set, 1 = set. */
char db_out_fullname[1024];
int uset_db_out_fullname;       /* 0 = not set, 1 = set. */

char primary_log_fullname[1024];


/*
 *   Connection Buffer Structure:
 *
 *	Array of strings to be sent for the connection in question.
 */
typedef struct
{
	char buffer[MAX_NET_CMD_SIZE];
}connection_struct;


/*
 *   Connection Structure:
 */
struct connection_struct
{
	int socket;		/* -1 means not connected. */
	char conhost[1024];
	long object_num;
	time_t contime;		/* When connected. In systime seconds. */
	unsigned long bytes_recieved;
	unsigned long bytes_sent;
	unsigned long errors_recieved;
	unsigned long errors_sent;

	int badlogins;		/* Bad login count. */

	long obj_ud_interval;	/* In milliseconds. */
	long obj_ud_last;	/* In milliseconds. */

	/* Connection buffer. */
	connection_struct conbuf[MAX_CON_BUF_ITEMS];

	long conbuf_items;	/* Total items in this connection buffer. */

} connection[MAX_CONNECTIONS];

long total_connections;
long highest_connection;


/*
 *   Listening Socket for accept()ing Connections:
 */
int listening_socket;
struct sockaddr_in server_addr;



/* *******************************************************************
 *
 *                        GLOBAL FUNCTIONS
 */

/* In db.c */
extern void DBClearObjectsFromMemory();
extern long DBReadFromFile(char *dbfilename);
extern long DBSaveToFile(char *dbfilename);
extern long DBCleanMemory();
extern long DBCreateObject(int width, int height);
extern long DBCreateExplosion1(double loc_x, double loc_y);
extern long DBCreateExplosion2(double loc_x, double loc_y);
extern void DBRecycleObject(long object_num);
extern long DBGetTopObjectNumber();
extern void DBEmergancySave();
extern double DBGetObjectVisibility(long object_num);


/* In exec.c */
extern int ExecHandleInput(long condescriptor, char *input);


/* In execset.c */
extern int ExecDoSet(long condescriptor, char *arg);


/* In log.c */
extern long LogAppendLineFormatted(char *filename, char *str);


/* In match.c */
extern long MatchWeaponsLock(long ref_object, long start_object, double range);
extern long MatchIntercept(long object_num, char *arg);
extern long MatchInterceptByNumber(long ref_object, long target_object);
extern long MatchObjectByName(char *nameofobject, int typeofobject);


/* In math.c */
extern double MuPolarRotX(double input_angle, double input_radius);
extern double MuPolarRotY(double input_angle, double input_radius);
extern double MuLocationtoHeading(double delta_x, double delta_y);
extern double Mu3DDistance(double delta_x, double delta_y, double delta_z);
extern int Mu3DInContact(long object_num1, long object_num2);
extern int Mu3DInVectorContact(long object_num1, long object_num2, double
	heading, double heading_variance, double range);
extern int Mu3DInRange(long object_num1, long object_num2, double distance);


/* In net.c */
extern int NetSendDataToConnection(int condescriptor, char *outbounddata,
    int priority);
extern void NetCloseConnection(long condescriptor);
extern void NetClearAllConnections();
extern long NetGetNewDescriptor();
extern int NetPollSocket(int sockettopoll);
extern int NetSendRecycleObject(long condescriptor, long object_num);
extern int NetHandleLogin(long condescriptor, char *arg);
extern int NetHandleGlobalMessage(int sendercondescriptor, char *message);
extern int NetSendRefresh(long condescriptor);
extern int NetHandleSetInterval(long condescriptor, char *arg);
extern int NetSendObjectPosition(long condescriptor, long object_num);
extern int NetSendObjectPositionS(long condescriptor, long object_num);
extern int NetSendObjectValues(long condescriptor, long object_num);
extern int NetSendObjectMaximums(long condescriptor, long object_num);
extern int NetSendWhoAmI(long condescriptor);
extern int NetSendEchoToConnection(long condescriptor, char *arg);
extern int NetHandleSetObjApp(long condescriptor, char *arg);
extern int NetHandleSetObjAppS(long condescriptor, char *arg);
extern int NetHandleSetWeapon(long condescriptor, char *arg);
extern int NetHandleSetShields(long condescriptor, char *arg);
extern int NetHandleSetCloak(long condescriptor);
extern int NetHandleSetDmgCtl(long condescriptor);
extern int NetSendSetName(long condescriptor, long object_num);
extern int NetSendWeaponValues(long condescriptor, long object_num,
	int weapon_num);
extern int NetHandleSetWeaponsLock(long condescriptor);
extern int NetHandleSetWeaponsUnlock(long condescriptor);
extern int NetHandleFireWeapon(long condescriptor, char *arg);
extern int NetPollSocketRecvData(long condescriptor);


/* In prochandle.c */
extern void fork_system(char *command_string);
extern void zombiekiller();


/* In rcfile.c */
extern int RCLoadConfigurationFromFile(char *filename);


/* In strings.c */
extern char *StringStripSpaces(char *string);
extern char *StringParseAddress(char *input_str);
extern int StringParsePort(char *input_str);
extern int StringGetNetCommand(char *input_str);
extern char *StringGetNetArgument(char *input_str);
extern char *StringCurrentTimeFormat(char *time_str);
extern char *StringFormatTime(long seconds);


/* In swserv.c */
extern void swserv_help();
extern void swserv_version();
extern void swserv_signalhandle(int signal_recieved);
extern void swserv_reset_timming();
extern void swserv_shutdown();


/* In timming.c */
extern long MilliTime();
extern long UTime();


/* In update.c */
extern int UpdateObject(long object_num);


/* In weapons.c */   
extern int WepCreate(
        long weapon_type,
        long owner,       /* Must not be garbage or error. */
        double birth_x,
        double birth_y,
        double birth_heading,
        double power,
        double range      /* Disgarded for projectile weapons */
);




#endif
