/* **********************************************************************
 *
 *	xsw.c	XShipWars Client
 *	------------------------
 *      Functions:
 *
 *	void xsw_help()
 *	void xsw_version()
 *	void message_win_print_help()
 *	void xsw_exit_CB()
 *	int main()
 *
 *	---
 *
 * Copyright (C) 1997, 1998  Taura (learfox@hotmail.com).
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * TAURA BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#include "../include/xsw.h"  



/* **********************************************************************
 *
 *   void xsw_help()
 *
 *	Prints the help screen.
 *
 *	No return value.
 */
void xsw_help()
{
 printf("Developer's edition, please do not redistribute!\n\n");
 printf("Usage: xsw [address[:port]] [options] [toolkitoptions]\n\n");
 printf("   [options] can be any of the following:\n\n");
 printf("      -f <rcfile>            Load configuration from this file.\n");
 printf("      --help | -h            Print (this) help screen and exit.\n");
 printf("      --version              Print version information.\n");
 printf("\n");

 return;
}



/* *********************************************************************
 *
 *   void xsw_version()
 *
 *	Prints version information.
 *
 */
void xsw_version()
{
 printf("%s Version %s\n\n", XSW_NAME, XSW_VERSION);

 printf(XSW_COPYRIGHT);

 return;
}



/* *********************************************************************
 *
 *   void message_win_print_help()
 *
 *	Prints the help message on the message_win.
 *
 */
void message_win_print_help()
{
	MesgWinAddMessage(
"F1 = Help  F2 = Heading Arrow  F3 = Labels  F4 = Event Msgs  F9 =\
 Connect  F10 = Disconnect",
		normal_text_pixel
	);

        MesgWinAddMessage(
"r = Reverse  s = Shields  z = Cloak   , . = Scan Zoom  i = Intercept  x = Exit",
                normal_text_pixel
        );

        MesgWinAddMessage(
"pgup pgdn = Scroll Messages  tab = Cycle Targets  u = Unlock Weapons  1 to 4 =\
 Select Weapons",
                normal_text_pixel
        );

	return;
}



/* *********************************************************************
 *
 *   void xsw_exit_CB()
 *
 *	Exit callback function.
 *
 *	No return value.
 */
void xsw_exit_CB()
{
	/* Disconnect from server. */
	if(swserv_socket >= 0)
	{
		NetSendDisconnect();
	}

        /* Free all pixmaps. */
	IMGFreeAllImages();

        /* Free the colormap. */
        XFreeColormap(display,colormap);

        /* Close the connection to display. */
        XCloseDisplay(display);

#ifdef LINUX
	/* Close the joystick device */
	close(joystick_fd);
#endif

	return;
}




void xsw_reset_timmers()
{
	/* Local variables. */
	long lx, ly, lz;
	char stringa[256];


	/* Print message. */
        MesgWinAddMessage(   
            "Client: Resetting timming counters.",
            normal_text_pixel
        );


	/* Reset object timmers. */
        for(ly = 0; ly < total_objects; ly++)
        {
	    /* Skip garbage and error objects. */
            if(xsw_object[ly].type <= XSW_OBJ_TYPE_GARBAGE)
                continue;

            xsw_object[ly].last_updated = 0;
	    xsw_object[ly].animation.last_interval = 0;

	    /* Reset weapon timmers. */
            for(lz = 0; lz < MAX_WEAPONS; lz++)
            {
                xsw_object[ly].weapons[lz].last_used = 0;
            }
        }


	/* Reset global animation timmer. */
	genanim_timmer[0].lastud = 0;


	/* Reset FPS timmer. */
        fps_counter.fcount = 0;
        fps_counter.lfcount = 0;
        fps_counter.lastud = 0;


	return;
}



/* *********************************************************************
 *
 *   int main(int argc, char *argv[])
 *
 */
int main(int argc, char *argv[])
{
	/* Local variables */
	int x,y,z;
	long lx, ly, lz;
	long object_count;
	char stringa[256];

	int xsw_x=0;		/* x,y geometry of xsw. */
	int xsw_y=0;
	unsigned int xsw_width=1024;	/* xsw width and height. */
	unsigned int xsw_height=768;
	Bool is_geometry_set=False;

	long game_win_last_updated = MilliTime();
	long stats_last_updated = MilliTime();
	long scanner_last_updated = MilliTime();
	long memory_clean_last = MilliTime();
	long lplayer_last_updated = MilliTime();

	long lapsed_utime = UTime();
	long cur_utime = UTime();


	/* ********************************************* */
	/* Set global variables to their default values. */
	rootpid = getpid();
	childpid = rootpid;
	child_procs = 0;

	cur_millitime = MilliTime();

	fps_counter.fcount = 0;
	fps_counter.lfcount = 0;
	fps_counter.lastud = MilliTime();
	fps_counter.interval = 1000;	/* In milliseconds. */

	genanim_timmer[0].count = 0;
        genanim_timmer[0].count_max = 5;
        genanim_timmer[0].lastud = MilliTime();
        genanim_timmer[0].interval = 200;

	normal_fontname="7x14";		/* Default fontnames. */
	bold_fontname="7x14";

	button_draw_count = 0;

	verbose_bool = False;
	print_event_bool = False;

	message_prompt = False;
	intercept_prompt = False;
	connect_prompt = False;
	shield_frequency_prompt = False;
	lexec_prompt = False;
	exec_prompt = False;
	exit_prompt = False;

        shift_key_state = False; 

	show_heading_arrow = 1;
	show_object_names = 1;
	scanner_zoom_scale = 7.6;	/* 76 / 10.0 */

	message_win_curline = 0;

	total_objects = 0;

	joystick_data.x_min = 0;
        joystick_data.y_min = 0;
        joystick_data.x_max = 1000;
        joystick_data.y_max = 1000;
	joystick_data.button1_state = 0;
        joystick_data.button2_state = 0;
        joystick_data.button3_state = 0;
        joystick_data.button4_state = 0;

	js_throttle_mode = 0;	/* Normal throttle scope, 0 to 100. */

	lplayer_object = -1;	/* Local player object. */

	sprintf(message_prompt_buffer, "");
	sprintf(intercept_prompt_buffer, "");

	sprintf(js_calibration_file_fullname, "%s/%s",
             getenv("HOME"),
             JS_CALIBRATION_FILE
	);

	getcwd(stringa, sizeof(stringa));
	sprintf(xsw_rcfile_fullname, "%s/%s",
	     stringa,
	     XSW_RCFILE
	);

	connection_state = 0;	/* 0 = not connected. */
	swserv_socket = -1;

	strncpy(loginname, getenv("LOGNAME"), MAX_NAME_LENGTH);
	strncpy(loginpassword, "", MAX_PASSWORD_LENGTH);

	strcpy(swservaddress, DEFAULT_SWSERV_ADDRESS);
	swservport = DEFAULT_SWSERV_PORT;
	swserv_address_set = 0;

	total_address_entries = 0;

	net_server_update_interval = DEFAULT_UPDATE_INTERVAL;

	disconnect_send_count = 0;


/* If swap spaces starts to fill up, remove this for() loop. */
	for(lx = 0; lx < MAX_IMAGESETS; lx++)
	{
		xsw_imageset[lx].load_state = 0;
	}



        /* ********************************************* */
	/* ***     Parse Command Line Parameters     *** */

	for(x = 1; x < argc; x++)
	{
	    /* Help. */
            if( 0 == (strcmp(argv[x],"--help")) )
            {
		xsw_help();
		return(0);
            }
            /* Help. */
            else if( 0 == (strcmp(argv[x],"-help")) )
            {
		xsw_help();
		return(0);
            }
            /* Help. */
            else if( 0 == (strcmp(argv[x],"-h")) )
            {
		xsw_help();
		return(0);
            }
            /* Version. */
            else if( 0 == (strcmp(argv[x],"--version")) )
            {
                xsw_version();
                return(0);
            }
	    /* RCFile. */
	    else if( 0 == (strcmp(argv[x],"-f")) )
	    {
		x++;
		strncpy(xsw_rcfile_fullname, argv[x], 1024);
            }
            /* Toolkit: Geometry. */
	    else if( 0 == (strcmp(argv[x],"-geometry")) )
            {
                x++;
                XParseGeometry(argv[x],
                    &xsw_x,     /* x,y */
                    &xsw_y,
                    &z,             /* width, height (not used). */
                    &z
                );
                is_geometry_set=True;
            }
	    /* Check if argument is prefixed with '-' '+' or '/'. */
	    else if(
		    (argv[x][0] == '-') ||
		    (argv[x][0] == '+')
	    )
	    {
		fprintf(stderr,
                   "%s: Argument %i: Warning: Unsupported argument: `%s'\n", 
		   argv[0], x, argv[x]
		);
	    }
	    /* Site address and port. */
	    else
	    {
		if(StringParseAddress(argv[x]) != NULL)
		{
		   strcpy(swservaddress, StringParseAddress(argv[x]));
		}
		else
		{
		   fprintf(stderr, "%s: Unable to interprite URL: `%s'\n",
			argv[0], argv[x]);
		}
		if(StringParsePort(argv[x]) > -1)
		{
		   swservport = StringParsePort(argv[x]);
		}

                swserv_address_set = 1;
	    }
        }



	/* ********************************************************** */
	/* ***                      Load RC File                  *** */
	/* Look in current or specified directory. */
	if( access(xsw_rcfile_fullname, R_OK) == 0)
	{
	    RCLoadFromFile(xsw_rcfile_fullname);
	}
	else
	{
	    /* Look in home directory. */
	    sprintf(xsw_rcfile_fullname, "%s/%s",
		getenv("HOME"), XSW_RCFILE);
	    if( access(xsw_rcfile_fullname, R_OK) == 0)
	    {
                RCLoadFromFile(xsw_rcfile_fullname);
	    }
	    else
	    {
                /* Look in xshipwars' etc directory. */
                sprintf(xsw_rcfile_fullname, "%s/%s",
                    XSW_ETC_DIR, XSW_RCFILE_GLOBAL);
                if( access(xsw_rcfile_fullname, R_OK) == 0)
                {
                    RCLoadFromFile(xsw_rcfile_fullname);
                }
                else
                {
                    /* Look in global etc directory. */
                    sprintf(xsw_rcfile_fullname, "%s/%s",
                        ETC_DIR, XSW_RCFILE_GLOBAL);
                    if( access(xsw_rcfile_fullname, R_OK) == 0)
                    {
                        RCLoadFromFile(xsw_rcfile_fullname);
                    }
		    else
		    {
			fprintf(stderr,
 "Error: Unable to find configuration file `%s' in the\n", XSW_RCFILE
			);
			fprintf(stderr,
 "following directories:\n\n"
			);
			getcwd(stringa, sizeof(stringa));
                        fprintf(stderr,
 "   %s  (Current directory)\n", stringa
                        );
                        sprintf(stringa, "%s/%s",
                            getenv("HOME"), XSW_RCFILE);
                        fprintf(stderr,
 "   %s\n", stringa
                        );
                        sprintf(stringa, "%s/%s",
                            XSW_ETC_DIR, XSW_RCFILE_GLOBAL);
                        fprintf(stderr,
 "   %s\n", stringa
                        );
                        sprintf(stringa, "%s/%s",
                            ETC_DIR, XSW_RCFILE_GLOBAL);
                        fprintf(stderr,
 "   %s\n", stringa
                        );
                        fprintf(stderr,
 "\nContinuing to run, but program may not function properly.\n"
                        );

		    }
		}
	    }
	}



	/* Check if required directories exist. */
	if(access(XSW_DIR, R_OK) != 0)
	{
	    fprintf(stderr, "Error: Cannot access directory: %s\n", XSW_DIR);
	    fprintf(stderr,
"This is the global data files directory for %s.\n", XSW_NAME);
	    fprintf(stderr,
"Please check if it exists and that its permission settings allow access.\n");
            fprintf(stderr,
"If this directory cannot be found, please reinstall %s.\n", XSW_NAME);
	    return(-1);
	}
	else if(access(XSW_IMAGES_DIR, R_OK) != 0)
	{
            fprintf(stderr, "Error: Cannot access directory: %s\n", XSW_DIR);
            fprintf(stderr,
"This is the global imagesets directory for %s.\n", XSW_NAME);
            fprintf(stderr,
"Please check if it exists and that its permission settings allow access.\n");
	    fprintf(stderr,
"If this directory cannot be found, please reinstall %s.\n", XSW_NAME);
            return(-1);
	}
        else if(access(XSW_ETC_DIR, R_OK) != 0)
        {
            fprintf(stderr, "Error: Cannot access directory: %s\n", XSW_ETC_DIR);
            fprintf(stderr,
"This is the global etc directory for %s.\n", XSW_NAME);
            fprintf(stderr,
"Please check if it exists and that its permission settings allow access.\n");
            fprintf(stderr,
"If this directory cannot be found, please reinstall %s.\n", XSW_NAME);
            return(-1);
        }



	/* ************************************************* */
	/* ***             Initialize Devices            *** */
#ifdef LINUX
	joystick_fd = JSInitialize(DEV_JOYSTICK, js_calibration_file_fullname);
	if(joystick_fd < 0)
	{
	    return(-1);
	}
#endif


        /* *********************************************************** */
        /*     Initiate X display connection and set X resources.      */

	/* Open a connection to the Display. */
	if((display=XOpenDisplay(NULL)) == NULL)
	{
	   fprintf(stderr,"%s: cannot connect to X server",argv[0]);
	   if(getenv("DISPLAY") == NULL)
              fprintf(stderr,", 'DISPLAY' environment variable not set.\n");
           else
              fprintf(stderr," %s\n", XDisplayName(NULL));
           return(-1);
 	}

	/* Get some default values of the server. */
	scr_num = DefaultScreen(display);
	scr_ptr = DefaultScreenOfDisplay(display);
	visual = DefaultVisualOfScreen(scr_ptr);
	depth = DefaultDepthOfScreen(scr_ptr);
	black_pix = BlackPixelOfScreen(scr_ptr);
	white_pix = WhitePixelOfScreen(scr_ptr);
	the_GC = DefaultGC(display,scr_num);
	colormap = DefaultColormap(display, scr_num);


        /* Get xfontinfos. */
        XuGetFontInfo(&normal_xfont, normal_fontname);
        XuGetFontInfo(&bold_xfont, bold_fontname);
        XSetFont(display, the_GC, normal_xfont->fid);  /* Use normal_xfont. */

	/* Get color pixels. */
	normal_text_pixel =
	   XuGetColor(NORMAL_TEXT_COLOR_SPEC, normal_text_xcolor);
	bold_text_pixel =
           XuGetColor(BOLD_TEXT_COLOR_SPEC, bold_text_xcolor);
        light_grey_pixel =
           XuGetColor(LIGHT_GREY_COLOR_SPEC, light_grey_xcolor);
        dark_grey_pixel =
           XuGetColor(DARK_GREY_COLOR_SPEC, dark_grey_xcolor);
        status_text_pixel =
           XuGetColor(STATUS_TEXT_COLOR_SPEC, status_text_xcolor);

	hull_bar_pixel =
           XuGetColor(HULL_BAR_COLOR_SPEC, hull_bar_xcolor);
	power_bar_pixel =
           XuGetColor(POWER_BAR_COLOR_SPEC, power_bar_xcolor);
	shields_bar_pixel =
	   XuGetColor(SHIELDS_BAR_COLOR_SPEC, shields_bar_xcolor);
	weapons_lock_pixel =
	   XuGetColor(WEAPONS_LOCK_COLOR_SPEC, weapons_lock_xcolor);
	selected_weapon_pixel =
	   XuGetColor(SELECTED_WEAPON_COLOR_SPEC, selected_weapon_xcolor);
	unselected_weapon_pixel =
	   XuGetColor(UNSELECTED_WEAPON_COLOR_SPEC, unselected_weapon_xcolor);
	visibility_bar_pixel =
           XuGetColor(VISIBILITY_BAR_COLOR_SPEC, visibility_bar_xcolor);
	intercept_pixel =
           XuGetColor(INTERCEPT_COLOR_SPEC, intercept_xcolor);
	throttle_bar_pixel =
	   XuGetColor(THROTTLE_BAR_COLOR_SPEC, throttle_bar_xcolor);
	velocity_bar_pixel =
	   XuGetColor(VELOCITY_BAR_COLOR_SPEC, throttle_bar_xcolor);
	antimatter_bar_pixel =
	   XuGetColor(ANTIMATTER_BAR_COLOR_SPEC, antimatter_bar_xcolor);
        dmgctl_bar_pixel =
           XuGetColor(DMGCTL_BAR_COLOR_SPEC, dmgctl_bar_xcolor);

        star1_pixel =
           XuGetColor(STAR1_COLOR_SPEC, star1_xcolor);
        star2_pixel =
           XuGetColor(STAR2_COLOR_SPEC, star2_xcolor);
        star3_pixel =
           XuGetColor(STAR3_COLOR_SPEC, star3_xcolor);
        star4_pixel =
           XuGetColor(STAR4_COLOR_SPEC, star4_xcolor);
        star5_pixel =
           XuGetColor(STAR5_COLOR_SPEC, star5_xcolor);
        star6_pixel =
           XuGetColor(STAR6_COLOR_SPEC, star6_xcolor);
        star7_pixel =
           XuGetColor(STAR7_COLOR_SPEC, star7_xcolor);
        star8_pixel =
           XuGetColor(STAR8_COLOR_SPEC, star8_xcolor);
        star9_pixel =
           XuGetColor(STAR9_COLOR_SPEC, star9_xcolor);




	/* Set foreground color. */
	XSetForeground(display, the_GC, white_pix);

	/* Setting the window attributes. */
	attributes.background_pixel = light_grey_pixel;
	attributes.background_pixmap = ParentRelative;
	attributes.border_pixel = white_pix;
	attributes.border_pixel = None;
	attributes.backing_store = NotUseful;
	attributes.bit_gravity = CenterGravity; 
	attributes.win_gravity = StaticGravity;
	attributes.colormap = DefaultColormapOfScreen(scr_ptr);
	attributes.cursor = XCreateFontCursor(display,XC_left_ptr);


	/* ***      XLib Resources Initialization Finished       *** */
	/* ********************************************************* */


	/* Initialize load status windows. */
	LSWinInit();


        /* ********************************************************* */
        /* ***             Create Primary Windows                *** */

	toplevel = XCreateWindow(
	   display,
	   DefaultRootWindow(display),
	   xsw_x,	   /* x (obsolete) */
	   xsw_y,	   /* y (obsolete) */
	   xsw_width,      /* width. */
	   xsw_height,     /* height. */
	   0,              /* border_width. */
	   depth,          /* depth from parent. */
	   InputOutput,    /* IO option. */
	   visual,
	   WIN_ATTR_MASK,
	   &attributes
	);


	game_win = XCreateSimpleWindow(display,
	   toplevel, 162, 5, 700, 700, 0, white_pix, black_pix);

	player_stats_win = XCreateSimpleWindow(display,
	   toplevel, 5, 75, 152, 688, 0, white_pix, black_pix);

	sensor_win = XCreateSimpleWindow(display,
           toplevel, 867, 75, 152, 152, 0, white_pix, black_pix);

	sensor_readout_win = XCreateSimpleWindow(display,
           toplevel, 867, 232, 152, 531, 0, white_pix, black_pix);

        message_win = XCreateSimpleWindow(display,
           toplevel, 162, 708, 700, 55, 0, white_pix, black_pix);


	/* Print greeting message to message_win. */
        sprintf(stringa, "%s %s", XSW_NAME, XSW_VERSION); 
        MesgWinAddMessage(stringa, normal_text_pixel);
        
        sprintf(stringa, "Copyright (C) 1997, 1998  Taura (learfox@hotmail.com)");
        MesgWinAddMessage(stringa, normal_text_pixel);



	/* *************************************************** */
        /* ***           Load Basic Pixmaps                *** */
        x = IMGLoadBasic();
	if(x != 0)
	{
	    fprintf(stderr,
		"%s: Warning: Error loading basic imagesets.\n",
		argv[0]
	    );
	}


	/* ****************************************************** */
	/* ***         Set Size Hints for Toplevel            *** */
	if(is_geometry_set)
	{
	   /* Set definate position if is_geometry_set is True. */
	   sizehints.flags=USPosition|PSize|PMinSize|PMaxSize;
	   sizehints.x=xsw_x;
	   sizehints.y=xsw_y;
	}
	else
	{
	   sizehints.flags=PPosition|PSize|PMinSize|PMaxSize;
	}
	sizehints.min_width=xsw_width;	  /* width and height, we  */
        sizehints.min_height=xsw_height;  /* set them the same for */
	sizehints.max_width=xsw_width;    /* min and max so no     */
	sizehints.max_height=xsw_height;  /* resizing. */

	sprintf(stringa,"%s %s",XSW_NAME, XSW_VERSION);
	XSetStandardProperties(display,
	   toplevel,
	   stringa,		/* Window title name. */
	   XSW_NAME,		/* Iconified name. */
	   xsw_icon_pixmap,	/* Icon pixmap. */
	   argv,argc,		/* Command line arguments. */
	   &sizehints		/* Sizehints. */
	);


	/* Setting the XEvent mask for windows, these windows will */
	/* be monitored for input events such as ButtonPress,      */
	/* ButtonRelease, and KeyPress events.                     */
	XSelectInput(display, toplevel, toplevel_eventmask);
        XSelectInput(display, player_stats_win, button_eventmask);
        XSelectInput(display, sensor_win, button_eventmask);
        XSelectInput(display, sensor_readout_win, button_eventmask);
        XSelectInput(display, message_win, button_eventmask);


        /* Define cursors for each window */
        XDefineCursor(display,toplevel,
                XCreateFontCursor(display,XC_left_ptr)
        );
        XDefineCursor(display,game_win,
                XCreateFontCursor(display,XC_crosshair)
        );
/*
	XDefineCursor(display,message_win,
                XCreateFontCursor(display,XC_exchange)
        );  
*/


	/* ******************************************************* */
	/*       Map and draw windows for the first time.          */
	XMapWindow(display, toplevel);
	XMapSubwindows(display, toplevel);


	/* Set toplevel pixmap. */
        XSetWindowBackgroundPixmap(display,
        	toplevel,
                bridge_pixmap
        );


	/* Destroy load status window. */
	LSWinDestroy();


	/* ******************************************************* */
	/* ***************** Main Event Loop ********************* */
	while(1)
	{

                 
                /* ************************************************ */
                /* ***             Update Timming               *** */
                lapsed_utime = UTime() - cur_utime;
		while(lapsed_utime < 0)
			lapsed_utime += 1000000;
		cur_utime = UTime();

		lx = MilliTime();
		if(lx < cur_millitime)
		{
		    /* Reset local timmers. */
		    game_win_last_updated = 0;
		    stats_last_updated = 0;
		    scanner_last_updated = 0;
		    memory_clean_last = 0;
                    lplayer_last_updated = 0;

		    /* Reset global and object/weapons timmers. */
                    xsw_reset_timmers();
		}
		cur_millitime = lx;


                /* *********************************************** */
                /* ***                  Sleep                  *** */
                if(lapsed_utime > MAIN_LOOP_INTERVAL)
                {
		    usleep(MAIN_LOOP_CATCHUP);
                }
                else
                {
                    usleep(MAIN_LOOP_INTERVAL);
                }


		/* ************************************************ */
		/* ***             ReFetch XEvents              *** */
		XCheckTypedEvent(display, ButtonPress, &buttonpress_xevent);
		XCheckTypedEvent(display, ButtonRelease, &buttonrelease_xevent);
		XCheckTypedEvent(display, KeyPress, &keypress_xevent);
		XCheckTypedEvent(display, KeyRelease, &keyrelease_xevent);
		XCheckTypedEvent(display, Expose, &expose_xevent);
                XCheckTypedEvent(display, DestroyNotify, &destroy_xevent);

/*
fprintf(stderr,"QueuedAlready: %i   QueuedAfterFlush: %i   QueuedAfterReading: %i\r",
XEventsQueued(display,QueuedAlready),
XEventsQueued(display,QueuedAfterFlush),
XEventsQueued(display,QueuedAfterReading)
);
*/

/*
fprintf(stderr, "X: %lf   Y: %lf\r",
JSGetTurn(joystick_fd),
JSGetThrottle(joystick_fd)
);
*/

		/* ************************************************* */
		/* ***            Handle Network Data            *** */

		/* Handle login only if we have a valid socket and    */
		/* connection_state is 1.                             */
		if( (swserv_socket > -1) && (connection_state == 1) )
		{
			NetHandleRecv();
		}

		/*
		 * Handle recieve (incoming) data and send out lplayer_object
		 * position.   Only if we have a valid socket and
		 * connection_state is 2.
		 */
		if( (swserv_socket > -1) && (connection_state == 2) )
		{
			/* Check for incoming recieved data. */
			NetHandleRecv();

			if( (lplayer_last_updated + net_server_update_interval)
                            < cur_millitime
                        )
                        {
			    if(lplayer_object >= 0)
			    {
			        NetSendLocalObjectPosition();
			    }
			    lplayer_last_updated = cur_millitime;
			}
		}


		/* *********************************************** */
		/* ***        Update Local Player Object       *** */
		UpdateObject(lplayer_object);


		/* ****************************************************** */
		/* ***                Redraw Windows                  *** */

		/* Game window. */
		if( (game_win_last_updated + 18) < cur_millitime)
		{
		    DrawGameWin();
		    game_win_last_updated = cur_millitime;
		}

	        /* Scanner window. */
		if( (scanner_last_updated + SCANNER_REFRESH_INTERVAL) <
			cur_millitime)
		{
		    XClearWindow(display, sensor_win);
                    DrawSensor(
                        lplayer_object,
                        sensor_win,
                        0, 0,
                        152, 152,
                        scanner_zoom_scale
		    );
		    scanner_last_updated = cur_millitime;
		}

                /* Stats and scanner readout windows. */
                if( (stats_last_updated + STATS_REFRESH_INTERVAL) <
                        cur_millitime)
                {
                    DrawStats(player_stats_win);
		    DrawSensorReadout(sensor_readout_win);
                    stats_last_updated = cur_millitime;
                }

		/* ************************************************* */
		/*      Clean Memory & Readjust total_objects        */
		if( (memory_clean_last + MEMORY_CLEAN_INTERVAL) <
			cur_millitime)
		{
		    total_objects = DBCleanMemory();
		    total_objects += 1;
		    memory_clean_last = cur_millitime;
		}

		/* ************************************************* */
		/* ***        Joystick Button Handling           *** */
		EventHandleJSButton1Input();
		EventHandleJSButton2Input();


                /* ************************************************ */
                /* ***             Destroy XEvent               *** */
                if(destroy_xevent.type == DestroyNotify)
                {
                        fprintf(stderr,
                                "%s: DestroyNotify signal recieved.\n",
                                argv[0]
                        );

                        /* Clear the DestroyNotify XEvent. */
                        destroy_xevent.type = False;
                }


		/* ************************************************** */
		/* ***              KeyPress XEvent               *** */
		if(keypress_xevent.type == KeyPress)
		{
			/* Exit prompt handling. */
		        if(exit_prompt)
		        {
			    exit_prompt = False;

			    sprintf(stringa,
                                 "Are you sure you want to exit? (y/n): %c_",
                                 xkeytoa(keypress_xevent.xkey.keycode)
			    );
			    MesgWinReplaceMessage(stringa,
				normal_text_pixel, 0);

			    /* User pressed "y"? */
			    if(keypress_xevent.xkey.keycode == 29)
			    {
				xsw_exit_CB();
				break;
			    }

                            MesgWinAddMessage("Cancled.",
                                normal_text_pixel);
		        }
			else
			{
			    EventHandleKeyInput(keypress_xevent.xkey.keycode);
			}

                        /* Clear the KeyPress XEvents. */
                        keypress_xevent.type = False;
                        keypress_xevent.xkey.keycode = False;
		}


		/* ************************************************ */
		/* ***            KeyRelease XEvent             *** */
		if(keyrelease_xevent.type == KeyRelease)
		{
			/* Event handle key release. */
			EventHandleKeyReleaseInput(
			    keyrelease_xevent.xkey.keycode);

			/* Clear the KeyRelease XEvents. */
			keyrelease_xevent.type = False;
			keyrelease_xevent.xkey.keycode = False;
		}


		/* ************************************************ */
		/* ***       ButtonPress XEvent Button1         *** */
		if(buttonpress_xevent.type == ButtonPress)
		{
		    /* and is it the left pointer button? (1) */
		    if(buttonpress_xevent.xbutton.button == Button1)
		    {
			/* Handle Button1 press event. */
			EventHandleButton1PressInput(
			    buttonpress_xevent.xany.window,
			    buttonpress_xevent.xbutton.x,
                            buttonpress_xevent.xbutton.y
			);

			/* Clear the ButtonPress XEvents. */
                        buttonpress_xevent.type = False;
                        buttonpress_xevent.xany.window = False;
		    }
		}


                /* ************************************************* */
                /* ***        ButtonPress XEvent Button3         *** */
                if(buttonpress_xevent.type == ButtonPress)
                {
                    /* and is it the right pointer button? (3) */
                    if(buttonpress_xevent.xbutton.button == Button3)
                    {
                        /* Handle Button3 press event. */
                        EventHandleButton3PressInput(
			    buttonpress_xevent.xany.window,
                            buttonpress_xevent.xbutton.x,
                            buttonpress_xevent.xbutton.y 
			);

                        /* Clear the ButtonPress XEvents. */
                        buttonpress_xevent.type = False;
                        buttonpress_xevent.xany.window = False;
                    }
                }


                /* ************************************************* */
                /* ***          ButtonRelease XEvent             *** */
		if(buttonrelease_xevent.type == ButtonRelease)
		{
		    /* and is it the left pointer button? (1) */
                    if(buttonrelease_xevent.xbutton.button == Button1)
                    {
			EventHandleButtonReleaseInput(
                            buttonrelease_xevent.xany.window,
                            buttonpress_xevent.xbutton.x,
                            buttonpress_xevent.xbutton.y
                        );


			/* Clear the ButtonRelease XEvents. */
                        buttonrelease_xevent.type = False;
                        buttonrelease_xevent.xany.window = False;
		    }
		}


		/* *********************************************** */
		/* ***         Exposure Event Check            *** */
		if(expose_xevent.type == Expose)
		{
                    /* Set button_draw_count to 0 so buttons will  */
                    /* get drawn, see below.                       */
		    button_draw_count = 0;


                    XClearWindow(display, toplevel);

                    DrawMessageWin();
                    DrawStats(player_stats_win);
                    DrawSensorReadout(sensor_readout_win);

                    XClearWindow(display, sensor_win);
                    DrawSensor(
                        lplayer_object,
                        sensor_win,
                        0, 0,
                        152, 152,
                        scanner_zoom_scale
                    );
                    scanner_last_updated = cur_millitime;


		    /* Clear the Expose XEvents. */
                    expose_xevent.type = False;
                    expose_xevent.xany.window = False;
		}
		/* Redraw buttons 2 times whenever */
		/* button_draw_count is set to 0.  */
		if(button_draw_count < 3)
		{


		   button_draw_count++;
		}


	}

	return(0);
}
