/* ******************************************************************************
 *
 *	rcfile.c	RCFile Handling
 *	-------------------------------
 *
 *
 *
 *
 *
 *
 */

#include "../include/xsw.h"


int RCLoadFromFile(char *filename)
{
	/* Local varables. */
        FILE *fp;
        char *filebuf;
        off_t filesize;
        struct stat statbuf;

        char stringa[256];
        char stringb[256];
        char stringc[256];
        char *strptr;

        long lines_read = 0;
	long parameters_read = 0;


	/* Check if filename exists. */
	if(access(filename, F_OK) == -1)
	{
	    fprintf(stderr, "%s: No such file.\n", filename);
	    return(-1);
	}

        /* Open filename. */
        fp = fopen(filename, "r");
        if(fp == NULL)
        {
            fprintf(stderr, "%s: Unable to open file.\n", filename);
            return(-1);
        }


	/* Reset global total_address_enties. */
	total_address_entries = 0;


        /* Get statistics and stuff about the file. */
        fstat(fileno(fp), &statbuf);    /* Get stats on file. */
        filesize = statbuf.st_size;     /* Get size of file. */
        
        /* Allocate memory. */
        filebuf = malloc(filesize * sizeof(char) + 1);


	/* ******************************************************** */
	/* ***            Begin Reading Configurations          *** */
        while( fgets(filebuf,256,fp) != NULL )
        {
            lines_read++;

            /* Skip comments. */
            if(strstr(filebuf,"#") != NULL)
                continue;
 
            /* Skip short lines. */
            if(strlen(filebuf) < 4)
                continue;

            /* Remove newline characters from filebuf. */
            while( (strptr = strchr(filebuf, '\n')) != NULL )
            {    
                *strptr='\0';
            }


            /*
             *   Parsing format:
             *
             *       <parameter>[ = <value>]
             */
            
            /* Fetch parameter and put it into stringa. */
            strncpy(stringa, filebuf, 256);
            stringa[255] = '\0';   
            if( (strptr = strchr(stringa, '=')) != NULL)
            {
                *strptr = '\0';
            }


            /* DefaultServerAddress */
            if( strstr(stringa, "DefaultServerAddress") != NULL )
            {
		if(swserv_address_set == 0)
		{
		    strptr = strchr(filebuf, '=');
		    strptr += 2;
		    strncpy(swservaddress, strptr, 1024);
		}
                parameters_read++;
                continue;
            }
            /* DefaultServerPort */
            else if( strstr(stringa, "DefaultServerPort") != NULL )
            {
                if(swserv_address_set == 0)
                {
                    sscanf(filebuf, "%s %s %i",
                        &stringb,
                        &stringb,
                        &swservport
                    );
		}
                parameters_read++;
                continue;
            }
            /* DefaultLoginName */
            else if( strstr(stringa, "DefaultLoginName") != NULL )
            {
                strptr = strchr(filebuf, '=');
                strptr += 2;
                strncpy(loginname, strptr, MAX_NAME_LENGTH);
                loginname[MAX_NAME_LENGTH - 1] = '\0';

                parameters_read++;
                continue;
            }
            /* DefaultLoginPassword */
            else if( strstr(stringa, "DefaultLoginPassword") != NULL )
            {
                strptr = strchr(filebuf, '=');
                strptr += 2;
                strncpy(loginpassword, strptr, MAX_PASSWORD_LENGTH);
                loginpassword[MAX_PASSWORD_LENGTH - 1] = '\0';
                
                parameters_read++;
                continue;
            }

            /* **************************************************** */
            /* ***                   KeyMapping                 *** */
            else if(strstr(filebuf,"BeginKeyMap") != NULL)
            {
                while((fgets(filebuf,256,fp)) != NULL)
                {
                    lines_read++;
         
                    /* Skip comments. */
                    if(strstr(filebuf,"#") != NULL)
                        continue;
                           
                    /* Skip short lines. */
                    if(strlen(filebuf) < 4)
                        continue;

                    /* Remove newline characters from filebuf. */
                    while( (strptr = strchr(filebuf, '\n')) != NULL )
                    {
                        *strptr='\0';
                    }

                    /*          
                     *   Parsing format:
                     *
                     *       <parameter>[ = <value>]
                     */
             
                    /* Fetch parameter and put it into stringa. */
                    strncpy(stringa, filebuf, 256);
                    stringa[255] = '\0';
                    if( (strptr = strchr(stringa, '=')) != NULL)
                    {
                        *strptr = '\0';
                    }


                    /* Help */
                    if( strstr(stringa, "Help") != NULL )
                    {
			sscanf(filebuf, "%s %s %i",
                            &stringb,
			    &stringb,
                            &xsw_keymap.help
			);
			parameters_read++;
                        continue;
                    }
                    /* DisplayArrow */
                    else if( strstr(stringa, "DisplayArrow") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.display_arrow
                        );
                        parameters_read++;
                        continue;
                    }
                    /* DisplayLabels */
                    else if( strstr(stringa, "DisplayLabels") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.display_labels
                        );
                        parameters_read++;
                        continue;
                    }
                    /* DisplayEvents */
                    else if( strstr(stringa, "DisplayEvents") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.display_events
                        );
                        parameters_read++;
                        continue;
                    }
                    /* NetUpdateIntervalDec */
                    else if( strstr(stringa, "NetUpdateIntervalDec") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_interval_dec
                        );
                        parameters_read++;  
                        continue;
                    }
                    /* NetUpdateIntervalInc */
                    else if( strstr(stringa, "NetUpdateIntervalInc") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",   
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_interval_inc
                        );
                        parameters_read++;
                        continue;
                    }
                    /* MessageScrollUp */
                    else if( strstr(stringa, "MessageScrollUp") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.mesg_win_scroll_up
                        );
                        parameters_read++;
                        continue;
                    }
                    /* MessageScrollDown */
                    else if( strstr(stringa, "MessageScrollDown") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.mesg_win_scroll_down
                        );
                        parameters_read++;
                        continue;
                    }
                    /* NetConnect */
                    else if( strstr(stringa, "NetConnect") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_connect
                        );
                        parameters_read++;
                        continue;
                    }
                    /* NetDisconnect */
                    else if( strstr(stringa, "NetDisconnect") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_disconnect
                        );
                        parameters_read++;
                        continue;
                    }
                    /* NetRefresh */
                    else if( strstr(stringa, "NetRefresh") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_refresh
                        );
                        parameters_read++;
                        continue;
                    }
                    /* NetExec */
                    else if( strstr(stringa, "NetExec") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_exec
                        );
                        parameters_read++;
                        continue;
                    }
                    /* LocalExec */
                    else if( strstr(stringa, "LocalExec") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.local_exec
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ScannerToggle */
                    else if( strstr(stringa, "ScannerToggle") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.scanner_toggle
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ScannerZoomIn */
                    else if( strstr(stringa, "ScannerZoomIn") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.scanner_zin
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ScannerZoomOut */
                    else if( strstr(stringa, "ScannerZoomOut") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.scanner_zout
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ScannerZoomMax */
                    else if( strstr(stringa, "ScannerZoomMax") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.scanner_max
                        );
                        parameters_read++;
                        continue;
                    }
                    /* JoystickMode */
                    else if( strstr(stringa, "JoystickMode") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.joystick_mode
                        );
                        parameters_read++;
                        continue;
                    }
                    /* JoystickMode */
                    else if( strstr(stringa, "JoystickMode") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.joystick_mode
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ReverseThrust */
                    else if( strstr(stringa, "ReverseThrust") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.reverse_thrust
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ShieldsToggle */
                    else if( strstr(stringa, "ShieldsToggle") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.shields_toggle
                        );
                        parameters_read++;
                        continue;
                    }
                    /* DmgCtlToggle */
                    else if( strstr(stringa, "DmgCtlToggle") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.dmgctl_toggle
                        );
                        parameters_read++;
                        continue;
                    }
                    /* CloakToggle */
                    else if( strstr(stringa, "CloakToggle") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.cloak_toggle
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon1 */
                    else if( strstr(stringa, "SelectWeapon1") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon1
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon2 */
                    else if( strstr(stringa, "SelectWeapon2") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon2
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon3 */
                    else if( strstr(stringa, "SelectWeapon3") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon3
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon4 */
                    else if( strstr(stringa, "SelectWeapon4") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon4
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon5 */
                    else if( strstr(stringa, "SelectWeapon5") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon5
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon6 */
                    else if( strstr(stringa, "SelectWeapon6") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon6
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon7 */
                    else if( strstr(stringa, "SelectWeapon7") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon7
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon8 */
                    else if( strstr(stringa, "SelectWeapon8") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon8
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon9 */
                    else if( strstr(stringa, "SelectWeapon9") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon9
                        );
                        parameters_read++;
                        continue;
                    }
                    /* WeaponsLock */
                    else if( strstr(stringa, "WeaponsLock") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.weapons_lock
                        );
                        parameters_read++;
                        continue;
                    }
                    /* WeaponsUnlock */
                    else if( strstr(stringa, "WeaponsUnlock") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.weapons_unlock
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SetIntercept */
                    else if( strstr(stringa, "SetIntercept") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.set_intercept
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SetShieldFreq */
                    else if( strstr(stringa, "SetShieldFreq") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.set_shield_freq
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SendMessage */
                    else if( strstr(stringa, "SendMessage") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.send_message
                        );
                        parameters_read++;
                        continue;
                    }
                    /* Exit */
                    else if( strstr(stringa, "Exit") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,  
                            &xsw_keymap.exit
                        );
                        parameters_read++;
                        continue;
                    }


                    /* EndKeyMap */
                    else if( strstr(stringa, "EndKeyMap") != NULL )
                    {
                        break;
                    }
                    /* Unknown parameter. */
                    else
                    {
                        fprintf(stderr,
                            "%s: Line %i: Unknown parameter: `%s'\n",
                            filename,
                            lines_read,
                            filebuf
                        );
                        continue;
                    }
		}
		continue;
	    }
            /* **************************************************** */
            /* ***              SWServ Bookmarks                *** */
            else if(strstr(filebuf,"BeginSWAddressEntry") != NULL)
            {
		/* Increment total SWServ address entries. */
		total_address_entries++;

                while((fgets(filebuf,256,fp)) != NULL)
                {
                    lines_read++;
                
		    /* Make sure we don't go beyond MAX_SWSERV_ADDRESS_ENTRIES. */
		    if(total_address_entries > MAX_SWSERV_ADDRESS_ENTRIES)
		    {
			fprintf(stderr,
			    "%s: Maximum SWServer address %i exceeded.\n",
			    filename,
			    MAX_SWSERV_ADDRESS_ENTRIES
			);
			break;
		    }

                    /* Skip comments. */
                    if(strstr(filebuf,"#") != NULL)
                        continue;
                 
                    /* Skip short lines. */
                    if(strlen(filebuf) < 4)
                        continue;

                    /* Remove newline characters from filebuf. */
                    while( (strptr = strchr(filebuf, '\n')) != NULL )
                    {
                        *strptr='\0';
                    }

                    /*   
                     *   Parsing format:
                     *
                     *       <parameter>[ = <value>]
                     */

                    /* Fetch parameter and put it into stringa. */
                    strncpy(stringa, filebuf, 256);
                    stringa[255] = '\0';
                    if( (strptr = strchr(stringa, '=')) != NULL)
                    {
                        *strptr = '\0';
                    }
            
            
                    /* Alias */
                    if( strstr(stringa, "Alias") != NULL ) 
                    {
                        strptr = strchr(filebuf, '=');
                        strptr += 1;
                        strncpy(swserv_addr_ent[total_address_entries - 1].alias,
                            StringStripSpaces(strptr), 256);
			swserv_addr_ent[total_address_entries - 1].alias[256 - 1] = '\0';

	                parameters_read++;
        	        continue;
		    }
                    /* URL */
                    else if( strstr(stringa, "URL") != NULL )
                    {
                        strptr = strchr(filebuf, '=');
                        strptr += 1;
                        strncpy(swserv_addr_ent[total_address_entries - 1].url,
                            StringStripSpaces(strptr), 1024);
                        swserv_addr_ent[total_address_entries - 1].url[1024 - 1] = '\0';

                        parameters_read++;
                        continue;
                    }
                    /* EndSWAddressEntry */
                    else if( strstr(stringa, "EndSWAddressEntry") != NULL )
                    {
                        break;
                    }

                    /* Unknown parameter. */
                    else
                    { 
                        fprintf(stderr,
                            "%s: Line %i: Unknown parameter: `%s'\n",
                            filename,
                            lines_read,
                            filebuf
                        );
                        continue;
                    }

                }
                continue;
            }

            /* Unknown parameter. */
            else
            {
                fprintf(stderr, "%s: Line %i: Unknown parameter: `%s'\n",
                    filename,
                    lines_read,
                    filebuf
                );
                continue;
            }
	}



	/* Free filebuf and close fp. */
	free(filebuf);
	fclose(fp);

	return(0);
}
