/* ************************************************************************
 *
 *	history.c	History Buffer Management Functions
 *	---------------------------------------------------
 *
 *	void HistoryClear(long history)
 *	int HistoryAddItem(long history, char *item)
 *
 *	---
 *
 *	Manages history buffers.
 *
 *
 */


#include "../include/xsw.h"


void HistoryClear(long history)
{
	/* Local variables. */
	long item_count;


	/* Make sure history is valid. */
	if( (history < 0) || (history >= MAX_HISTORY_BUFFERS) )
	    return;


	/* Begin clearing this history. */
	for(item_count = 0; item_count < MAX_HISTORY_ITEMS; item_count++)
	{
	    history_buffer[history].items[item_count].item[0] = '\0';
	}

	/* Reset current item to 0. */
	history_buffer[history].current_item = 0;


	return;
}



int HistoryAddItem(long history, char *item)
{
	/* Local variables. */
	char stringa[MAX_HISTORY_ITEMSIZE];
	long item_count;


        /* Make sure history is valid. */
        if( (history < 0) || (history >= MAX_HISTORY_BUFFERS) )
            return(-1);


	/* Copy item to stringa. */
	strncpy(stringa, item, MAX_HISTORY_ITEMSIZE);
        stringa[MAX_HISTORY_ITEMSIZE - 1] = '\0';


	/* 'Shift' items. */
	for(item_count = MAX_HISTORY_ITEMS - 1; item_count > 0; item_count--)
	{
	    strncpy(history_buffer[history].items[item_count].item,
		history_buffer[history].items[item_count - 1].item,
		MAX_HISTORY_ITEMSIZE
	    );
	}


	/* Add the new line. */
	strncpy(history_buffer[history].items[0].item,
	    stringa, MAX_HISTORY_ITEMSIZE);


	return(0);
}
