/* graphics.c - easy-to-use wrapper to Xlib interface
** copyleft March 1997 Quantum Porcupine / grey (pascal@acm.org)
** see graphics.h for more information
*/

#include <stdio.h>
#include <stdlib.h>
#include "graphics.h"

void GetRootWindow (QGraph *g)
{
	g->win = DefaultRootWindow(g->disp);
}

int OpenDisp(QGraph *g, char *d)
{
	int bpp, i;
	XVisualInfo *vis_info, vis_temp;
	Display *disp;

	disp = XOpenDisplay(d);
	if (disp == NULL)
		return 0;

	g->disp = disp;
	g->scr = DefaultScreen(disp);
	g->blk = BlackPixel(disp, g->scr);
	g->wht = WhitePixel(disp, g->scr);

	g->vis = DefaultVisual(disp, g->scr);
	vis_temp.visual = g->vis;
	vis_temp.visualid = XVisualIDFromVisual(g->vis);
	vis_info = XGetVisualInfo(disp, VisualIDMask, &vis_temp, &i);
	if (i = 0)
		return 0;

	g->depth = vis_info->depth;

	return 1;
}

int MakeGC(QGraph *g)
{
	XGCValues gcvals;
	GC gc;

	gc = XCreateGC(g->disp, g->win, (unsigned long)0, &gcvals);
	if (gc)
	{
		XSetForeground (g->disp, gc, g->wht);
		XSetBackground (g->disp, gc, g->blk);
		g->gc = gc;
		return 1;
	}
	else
		return 0;
}

int OpenWindow(QGraph *g, int w, int h)
{
	g->win = XCreateSimpleWindow (g->disp, RootWindow(g->disp,
	    g->scr), 10, 10, w + 32, h + 32, 32, g->blk, g->blk);
	/*GetRootWindow (g);*/
	g->w = w;
	g->h = h;
	g->size = w*h;

	if (!MakeGC(g))
	{
		XDestroyWindow (g->disp, g->win);
		return 0;
	}

	XMapWindow (g->disp, g->win);
	XFlush (g->disp);
	return 1;
}

int SetupXImage (QGraph *g)
{
	g->rmask = g->vis->red_mask;
	g->gmask = g->vis->green_mask;
	g->bmask = g->vis->blue_mask;

	/*for (g->rs = 0; (g->rs < 16) && !((g->rmask << g->rs) & 32768);
	    g->rs++);
	for (g->gs = 0; (g->gs < 16) && !((g->gmask << g->gs) & 32768);
	    g->gs++);
	for (g->bs = 0; (g->bs < 16) && !((g->bmask << g->bs) & 32768);
	    g->bs++);*/

	printf ("%d %x %x %x\n", g->depth, g->rmask, g->gmask, g->bmask);
	printf ("%d %d %d\n", g->rs, g->gs, g->bs);

	g->im = (void *)malloc(g->w*g->h*4);

	g->xim = XCreateImage(g->disp, g->vis, g->depth, ZPixmap, 0,
	    g->im, g->w, g->h, 32, 0);

	g->depth = g->xim->bits_per_pixel;

	if (g->im == NULL)
		return 0;

	if (g->depth == 8)
	{
		printf ("getting colormap\n");
		g->cm = XCreateColormap(g->disp, g->win, g->vis,
		    AllocAll);
		XSetWindowColormap (g->disp, g->win, g->cm);
	}

	XMapWindow (g->disp, g->win);
	XFlush (g->disp);
	return 1;
}

void Blit (QGraph *g, int x, int y, int w, int h)
{
	XPutImage (g->disp, g->win, g->gc, g->xim, x, y, 16 + x, 16 + y,
	    w, h);
	XSync (g->disp, 0);
}

QGraph *QSetupGraphics (char *disp, int w, int h)
{
	QGraph *g = (QGraph *)malloc(sizeof(QGraph));
	if (g == (QGraph *)NULL)
	{
		fprintf (stderr, "Unable to allocate window!\n");
		return NULL;
	}

	if (!OpenDisp(g, disp))
	{
		fprintf (stderr, "OpenDisp failed!\n");
		free (g);
		return NULL;
	}

	if (!OpenWindow(g, w, h))
	{
		fprintf (stderr, "OpenWindow failed!\n");
		free (g);
		return NULL;
	}

	/*AllocPalette (g);*/
	if (!SetupXImage(g))
	{
		fprintf (stderr, "SetupXImage failed!\n");
		free (g);
		return NULL;
	}

	return g;
}

int ShutdownGraphics (QGraph *g)
{
	/*FreePalette (g);*/

	return 1;
}

void *GetBuffer (QGraph *g)
{
	return g->im;
}

void SetColor (QGraph *gb, int c, int r, int g, int b)
{
	XColor xc;

	xc.pixel = c;
	xc.red = r<<8;
	xc.green = g<<8;
	xc.blue = b<<8;
	xc.flags = DoRed | DoGreen | DoBlue;

	XStoreColor (gb->disp, gb->cm, &xc);
}
