#!/bin/bash
# Copyright(c) 2002 Sun Microsystems, Inc.
# All rights reserved.

#ident  "@(#)help_s10.sh  1.2  05/05/04  SMI"

#============================================================
# This help script is to launch SunVTS help in mozilla
#============================================================

LANG_DIR=$LANG
if [ -z "$LANG_DIR" ]; 
then
  LANG_DIR=C
fi

VTS_INST=`/usr/bin/pwd`
VTS_BASE=`dirname $VTS_INST`

# If help files are not installed for that LANG, display
# the one in C lang dir.
if [ ! -f $VTS_BASE/lib/locale/$LANG_DIR/help/help_s10.html ];
then
  LANG_DIR=C
fi

if [ ! -f "/usr/sfw/bin/mozilla" ];
then
	/usr/openwin/bin/xterm -e sh -c  '

       echo ; echo Could not invoke /usr/sfw/bin/mozilla ;
       echo;
       echo Invoke any browser and copy the below url.;
       echo file://$VTS_BASE/lib/locale/$LANG_DIR/help/help_s10.html;
       echo;
       echo Press Enter/Return Key to dismiss this window.;
       read ch'  &
else
/usr/sfw/bin/mozilla $VTS_BASE/lib/locale/$LANG_DIR/help/help_s10.html &
fi

exit 0
