DROP INDEX idx_mon_service_threshold_fks; 
DROP INDEX idx_monitoring_service_name; 
DROP INDEX idx_interface_names; 
DROP TABLE hd_monitoring_service_threshold;
DROP TABLE hd_monitoring_threshold;
DROP TABLE hd_monitoring_polling_interval;
DROP TABLE hd_interface;

ALTER TABLE hd_operating_system ADD COLUMN driver_url VARCHAR(256);
ALTER TABLE hd_operating_system ALTER COLUMN support_monitoring SET DEFAULT 0;

update hd_operating_system set driver_url='file:/opt/sun/n1gc/agent/drvrs/sunmc.jar' where support_monitoring = 1;
update hd_operating_system set driver_url='file:/opt/sun/n1gc/agent/drvrs/ssh.jar' where support_monitoring = 0;

update hd_operating_system set name = 'SunOS' where name = 'Solaris';
update hd_object_instance set object_name = substring(object_name for char_length(object_name) - 7) || 'SunOS' where object_name like '%name=Solaris';

-- ALTER TABLE hd_operating_system DROP COLUMN type;
-- ALTER TABLE hd_operating_system DROP COLUMN version;
-- ALTER TABLE hd_operating_system DROP COLUMN support_monitoring;

update hd_schema_version set version='1.4';

CREATE TABLE hd_monitored_attribute (
    object_id INTEGER PRIMARY KEY,
    monitor VARCHAR(512) NOT NULL,
    object_name VARCHAR(512) NOT NULL,
    attribute VARCHAR(256)
);

insert into hd_monitored_attribute (object_id, monitor, object_name, attribute) select nextval('seq_hd_object_id'), 'com.sun.hss.domain:type=MonitoringService.ValueMonitor,name=AccessibilityMonitor', key, 'Status' from hd_monitoring_enabled_object where key like 'com.sun.hss.domain:type=Server,%' and key not like '%#%' and value = 1;
insert into hd_monitored_attribute (object_id, monitor, object_name, attribute) select nextval('seq_hd_object_id'), 'com.sun.hss.domain:type=MonitoringService.ValueMonitor,name=StatusMonitor', key, 'Status' from hd_monitoring_enabled_object where key like 'com.sun.hss.domain:type=Server,%' and key not like '%#%' and value = 1;

DROP TABLE hd_monitoring_enabled_object;
DROP TABLE hd_monitoring_service;

CREATE INDEX idx_monitored_attribute_monitor ON hd_monitored_attribute(monitor);

delete from hd_cache_value;

delete from hd_object_instance where object_name like 'com.sun.hss.domain:type=Server.OperatingSystem.Interface%';
delete from hd_object_instance where object_name like 'com.sun.hss.domain:type=Server.OperatingSystem.OverallCpuUsage%';
delete from hd_object_instance where object_name like 'com.sun.hss.domain:type=Server.OperatingSystem.Memory%';
delete from hd_object_instance where object_name like 'com.sun.hss.domain:type=Server.OperatingSystem.FileSystem%';
delete from hd_object_instance where object_name like 'com.sun.hss.domain:type=Server.Temperature%';
delete from hd_object_instance where object_name like 'com.sun.hss.domain:type=Server.Voltage%';
delete from hd_object_instance where object_name like 'com.sun.hss.domain:type=Server.FanSpeed%';
