#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Helper script to run the DDL for upgrading the services tier schema
# from 1.0 to 1.1.  1.0 schema corresponds to N1SM versions 1.0 and 1.1;
# schema version 1.1 corresponds to N1SM version 1.2.
#

. /opt/sun/n1gc/bin/n1hss_common.sh

PSQL=$BASE/bin/psql
USER=roxadmin
PASS=roxOdin
DBNAME=rox
DDL="/opt/sun/n1gc/upgrade/hd_job_upgrade.sql \
/opt/sun/n1gc/hd_version_schema.sql"
PORT=5433

LD_LIBRARY_PATH=$BASE/lib/
PGHOST=$BASE/socket
export LD_LIBRARY_PATH PGHOST

for ddl in `echo $DDL`
do
    if [ `uname` = "SunOS" ]; then
	/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER -p $PORT -f $ddl $DBNAME
    else
	/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER $DBNAME -p $PORT -f $ddl
    fi
done

# Upgrade the OS Profiles

$SCS_HOME/sbin/db_tool.pl load /opt/sun/n1gc/hd_upgrade_osprofile.sql

# Copy agents

AGENT_HOME=/opt/sun/n1gc/etc/agents
if [ `uname` = "SunOS" ]; then
    SCS_DIR=/var/opt/SUNWscs/data/swinstaller/pkgs
else
    SCS_DIR=/var/opt/sun/scs/data/swinstaller/pkgs
fi

if [ -f $SCS_DIR/sunmc-linux-agent-1-1.i386.rpm ]
then
    mv -f $SCS_DIR/sunmc-linux-agent-1-1.i386.rpm $SCS_DIR/sunmc-linux-agent-1-1.i386.rpm.orig 
    cp $AGENT_HOME/n1sm-linux-agent-1-2.rpm $SCS_DIR/sunmc-linux-agent-1-1.i386.rpm
fi

if [ -f $SCS_DIR/SUNWn1gcsolx86ag.pkg ]
then
    mv -f $SCS_DIR/SUNWn1gcsolx86ag.pkg $SCS_DIR/SUNWn1gcsolx86ag.pkg.orig
    cp $AGENT_HOME/SUNWn1smx86ag-1-2.pkg $SCS_DIR/SUNWn1gcsolx86ag.pkg
fi

if [ -f $SCS_DIR/SUNWn1gcsolsparcag.pkg ]
then
    mv -f $SCS_DIR/SUNWn1gcsolsparcag.pkg $SCS_DIR/SUNWn1gcsolsparcag.pkg.orig
    cp $AGENT_HOME/SUNWn1smsparcag-1-2.pkg $SCS_DIR/SUNWn1gcsolsparcag.pkg
fi

exit $?
