--   ...services schema upgrade script...
--   
--
--   ************************************************************
--   * WARNING - This script is to be used to upgrade services db
--   *           from version 1.1 to 1.2. 
--   * 
--   * To determin current services db version, execute
--   * sh /opt/sun/n1gc/hd_show_services_schema_version.sh 
--   ************************************************************
-- 
--   Note: This script should be run using the driver script
--         /opt/sun/n1gc/upgrade/services_upgrade1.1-1.2.sh
-- 
--   To run this script manually for debugging purpose, perform the
--   following steps:
--   (1) source /opt/sun/n1gc/bin/n1hss_common.sh
--       . /opt/sun/n1gc/bin/n1hss_common.sh
--   (2) log in to psql
--       $ cd $BASE/bin
--       $ ./psql -p 5433 -d rox
--   (3) execute the script in psql
--       rox-# \i <pathname>/hd_job_upgrade.sql
--   
--   Date     Edited By            Change Description
--   11/30/05 Chinchih Lu           Initial Cut.

-- Update hd_firmware_install_info : change version from varchar(32) to varchar(128)

-- Create a temporary table
CREATE LOCAL TEMPORARY TABLE "hd_firmware_install_info0fxntm" (
  "object_id" INTEGER, 
  "device_object_name" VARCHAR(256), 
  "install_date" TIMESTAMP WITH TIME ZONE, 
  "release_date" TIMESTAMP WITH TIME ZONE, 
  "type" VARCHAR(256), 
  "version" VARCHAR(32), 
  "provider" VARCHAR(256), 
  "description" VARCHAR(256), 
  "firmware_package_id" INTEGER
) WITH OIDS;

-- Copy the source table's data to the temporary table
INSERT INTO "hd_firmware_install_info0fxntm" ("object_id", "device_object_name", "install_date", "release_date", "type", "version", "provider", "description", "firmware_package_id")
SELECT "object_id", "device_object_name", "install_date", "release_date", "type", "version", "provider", "description", "firmware_package_id" 
FROM "hd_firmware_install_info";

-- Drop the source table
DROP TABLE "hd_firmware_install_info";

-- Create the destination table
CREATE TABLE "hd_firmware_install_info" (
  "object_id" INTEGER NOT NULL, 
  "device_object_name" VARCHAR(256) NOT NULL, 
  "install_date" TIMESTAMP WITH TIME ZONE, 
  "release_date" TIMESTAMP WITH TIME ZONE, 
  "type" VARCHAR(256), 
  "version" VARCHAR(128), 
  "provider" VARCHAR(256), 
  "description" VARCHAR(256), 
  "firmware_package_id" INTEGER NOT NULL, 
  CONSTRAINT "hd_firmware_install_info_pkey" PRIMARY KEY("object_id"), 
  FOREIGN KEY ("firmware_package_id")
    REFERENCES "hd_firmware_package"("object_id")
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    NOT DEFERRABLE
) WITH OIDS;

-- Copy the temporary table's data to the destination table
INSERT INTO "hd_firmware_install_info" ("object_id", "device_object_name", "install_date", "release_date", "type", "version", "provider", "description", "firmware_package_id")
SELECT "object_id", "device_object_name", "install_date", "release_date", "type", CAST("version" AS varchar(128)), "provider", "description", "firmware_package_id" 
FROM "hd_firmware_install_info0fxntm";


UPDATE hd_component_schema_version set version='1.2' WHERE component = 'services';


-- Create the GE profile tables.
CREATE TABLE hd_geprofiles (
   geprofile_id serial,
   name varchar(255) not null,
   type varchar(255) not null,
   appname varchar(255) not null,
   active varchar(5) not null,
   admin_homedir varchar(1024) not null,
   admin_uid integer,
   admin_username varchar(1024) not null,
   execd_port integer,
   inst_version varchar(1024) not null,
   lnx_nfs_mt_opts varchar(1024) not null,
   loadCritical float8,
   loadWarning float8,
   maxPendTime float8,
   memCritical float8,
   memWarning  float8,
   nfs_mount_point varchar(1024) not null,
   nfs_server_name varchar(1024) not null,
   proxy_host varchar(1024) not null,
   master_port integer,
   sge_cell varchar(1024) not null,
   sge_root varchar(1024) not null,
   sol_nfs_mt_opts varchar(1024) not null,
   primary key (geprofile_id)
);


-- Increase the size of the value column in hd_user_preference.
CREATE TABLE pref_new (
  object_id integer CONSTRAINT no_null NOT NULL,
  user_name varchar(64) CONSTRAINT no_null NOT NULL,
  key varchar(64) CONSTRAINT no_null NOT NULL,
  value varchar(256)
);
INSERT INTO pref_new SELECT * FROM hd_user_preference;
DROP TABLE hd_user_preference;
ALTER TABLE pref_new RENAME TO hd_user_preference;

