#! /bin/sh
# This script replaces the initrd.img file with initrd-everything.img 
# for Redhat 2.1 distribution.
# Usage: sh replaceInitrd.sh <distro id>
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

DISTRO_ID=$1


if [ "$DISTRO_ID" = "" ]
then
   echo "Exiting: Distro id was not passed in."
   exit 1
fi
# go to the directory where initrd.img file is.
cd /tftpboot/$DISTRO_ID

INITRD=initrd.img
INITRD_EVERYTHING=initrd-everything.img

if [ ! -f $INITRD -o ! -f $INITRD_EVERYTHING ]; then
    echo "$INITRD or $INITRD_EVERYTHING doesn't exist."
    exit 1
fi

mv $INITRD $INITRD.bk
mv $INITRD_EVERYTHING $INITRD
