#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

usage() {
    echo ""
    echo "Usage: ${progname} <new_version>"
    echo ""
    exit 1
}

error() {
    echo "ERROR: ${1}"
    exit 1
}

show_version() {
    sh $N1GC_DIR/hd_show_services_schema_version.sh 
}

progname=`basename ${0}`

if [ $# -ne 1 ]; then
    usage;
fi

new_version=$1

N1GC_DIR=/opt/sun/n1gc/
upgrade_dir=${N1GC_DIR}/upgrade

current_version=`show_version`

if [ ! -n "${current_version}" ]; then
    error "Couldn't obtain current version info"
fi

echo "Current version of schema is: " ${current_version}

echo "Attempt to upgrade to version: " ${new_version}

if [ "$current_version" = "$new_version" ]; then
    echo "Current version is ${new_version} already. No need to upgrade"
    exit 0
fi

found_old=0
found_new=0
for upgrade_script in `ls ${upgrade_dir}/services_upgrade*.sh 2>/dev/null`
do
    from_version=`echo $upgrade_script | \
        sed 's/.*\([0-9]\.[0-9]\)-\([0-9]\.[0-9]\).*/\1/g'`
    to_version=`echo $upgrade_script | \
        sed 's/.*\([0-9]\.[0-9]\)-\([0-9]\.[0-9]\).*/\2/g'`

    echo "from_version=${from_version}"
    echo "to_version=${to_version}"

    if [ ${new_version} = ${to_version} ] ; then
        found_new=1
    fi
    if [ ${current_version} = ${from_version} ] ; then
        found_old=1
    fi
done

if [ $found_new = 0 ]; then
    error "Invalid version to upgrade. Cannot upgrade to version: ${new_version}" 
fi

if [ $found_old = 0 ]; then
    error "Invalid version to upgrade. Cannot upgrade from version: ${current_version}" 
fi

while [ "$new_version" != "$current_version" ]
do
    upgrade_script=`ls ${upgrade_dir}/services_upgrade${current_version}*.sh`
    sh ${upgrade_script}
    if [ $? != 0 ]; then
        error "Error occurred in executing ${upgrade_script}"
    fi

    current_version=`show_version`
    echo "current version = $current_version"
done

echo "DB upgrade done"
exit 0
