-- This insert statement upgrades the OS profiles in the SCS database to
-- include the init_agent_firstboot.sh script.  This script is used to
-- upgrade from pre-1.2 to 1.2 N1SM.

insert into as_script_profile (profile_id,script_id)
select
    distinct profile_id,
    (
      select
         distinct script_id
      from
         as_script
      where
         location like '%scs/data/allstart/scripts/init_agent_firstboot.sh'
    )
from
    as_script_profile
where
    profile_id not in
    (
      select
          distinct profile_id
      from
          as_script_profile
      where
          script_id=(select script_id from as_script where location
              like '%scs/data/allstart/scripts/init_agent_firstboot.sh')
    )

