#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Helper script to run the query to determine the version of the services
# schema.  
#

. /opt/sun/n1gc/bin/n1hss_common.sh

PSQL=$BASE/bin/psql
USER=roxadmin
PASS=roxOdin
DBNAME=rox
DDL=/opt/sun/n1gc/hd_show_services_schema_version.sql
PORT=5433

LD_LIBRARY_PATH=$BASE/lib/
PGHOST=$BASE/socket
export LD_LIBRARY_PATH PGHOST

if [ `uname` = "SunOS" ]; then
    version=`/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER -p $PORT -f $DDL $DBNAME 2>&1 | head -3 | tail -1 | awk '{ print $1 }'`
else
    version=`/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER $DBNAME -p $PORT -f $DDL 2>&1 | head -3 | tail -1 | awk '{ print $1 }'`
fi

rval=$?

# We expect this for N1SM 1.0/1.1 systems trying to upgrade to N1SM 1.2,
# as the services schema version table doesn't exist and so the query will
# fail.  
version=`echo $version | sed -n 's/[0-9][0-9]*\.[0-9][0-9]*/&/gp'`
if [ -z "$version" ]
then
    version="1.0"
fi

echo $version

exit $rval
